/*
 * Decompiled with CFR 0.152.
 */
package io.radar.sdk;

import android.content.Context;
import android.content.SharedPreferences;
import io.radar.sdk.Radar;
import io.radar.sdk.RadarTrackingOptions;
import io.radar.sdk.RadarTripOptions;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b \b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b\u001aJ\u0017\u0010\u001b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b\u001cJ\u0015\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b\u001eJ\u0017\u0010\u001f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b J\u0015\u0010!\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b\"J\u0015\u0010#\u001a\u00020$2\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b%J\u0017\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b(J\u0017\u0010)\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b*J\u0010\u0010+\u001a\u00020,2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0015\u0010-\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b.J\u0015\u0010/\u001a\u0002002\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b1J\u0017\u00102\u001a\u0004\u0018\u0001032\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b4J\u0017\u00105\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b6J\u001d\u00107\u001a\u0002082\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u00109\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b:J\u001f\u0010;\u001a\u0002082\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010<\u001a\u0004\u0018\u00010'H\u0000\u00a2\u0006\u0002\b=J\u001f\u0010>\u001a\u0002082\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010?\u001a\u0004\u0018\u00010\u0004H\u0000\u00a2\u0006\u0002\b@J\u001f\u0010A\u001a\u0002082\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010B\u001a\u0004\u0018\u00010\u0004H\u0000\u00a2\u0006\u0002\bCJ\u001d\u0010D\u001a\u0002082\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010E\u001a\u00020$H\u0000\u00a2\u0006\u0002\bFJ\u001f\u0010G\u001a\u0002082\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010H\u001a\u0004\u0018\u00010'H\u0000\u00a2\u0006\u0002\bIJ\u001f\u0010J\u001a\u0002082\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010K\u001a\u0004\u0018\u00010\u0004H\u0000\u00a2\u0006\u0002\bLJ\u001d\u0010M\u001a\u0002082\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010N\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\bOJ\u001d\u0010P\u001a\u0002082\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010Q\u001a\u000200H\u0000\u00a2\u0006\u0002\bRJ\u001f\u0010S\u001a\u0002082\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010Q\u001a\u0004\u0018\u000103H\u0000\u00a2\u0006\u0002\bTJ\u001f\u0010U\u001a\u0002082\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010V\u001a\u0004\u0018\u00010\u0004H\u0000\u00a2\u0006\u0002\bWR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006X"}, d2={"Lio/radar/sdk/RadarSettings;", "", "()V", "KEY_AD_ID_ENABLED", "", "KEY_CONFIG", "KEY_DESCRIPTION", "KEY_HOST", "KEY_ID", "KEY_INSTALL_ID", "KEY_LOG_LEVEL", "KEY_METADATA", "KEY_OLD_OFFLINE_MODE", "KEY_OLD_SYNC_MODE", "KEY_OLD_UPDATE_INTERVAL", "KEY_OLD_UPDATE_INTERVAL_RESPONSIVE", "", "KEY_PUBLISHABLE_KEY", "KEY_TRACKING", "KEY_TRACKING_OPTIONS", "KEY_TRIP_OPTIONS", "KEY_USER_ID", "getAdIdEnabled", "", "context", "Landroid/content/Context;", "getAdIdEnabled$sdk_release", "getDescription", "getDescription$sdk_release", "getHost", "getHost$sdk_release", "getId", "getId$sdk_release", "getInstallId", "getInstallId$sdk_release", "getLogLevel", "Lio/radar/sdk/Radar$RadarLogLevel;", "getLogLevel$sdk_release", "getMetadata", "Lorg/json/JSONObject;", "getMetadata$sdk_release", "getPublishableKey", "getPublishableKey$sdk_release", "getSharedPreferences", "Landroid/content/SharedPreferences;", "getTracking", "getTracking$sdk_release", "getTrackingOptions", "Lio/radar/sdk/RadarTrackingOptions;", "getTrackingOptions$sdk_release", "getTripOptions", "Lio/radar/sdk/RadarTripOptions;", "getTripOptions$sdk_release", "getUserId", "getUserId$sdk_release", "setAdIdEnabled", "", "enabled", "setAdIdEnabled$sdk_release", "setConfig", "config", "setConfig$sdk_release", "setDescription", "description", "setDescription$sdk_release", "setId", "_id", "setId$sdk_release", "setLogLevel", "level", "setLogLevel$sdk_release", "setMetadata", "metadata", "setMetadata$sdk_release", "setPublishableKey", "publishableKey", "setPublishableKey$sdk_release", "setTracking", "tracking", "setTracking$sdk_release", "setTrackingOptions", "options", "setTrackingOptions$sdk_release", "setTripOptions", "setTripOptions$sdk_release", "setUserId", "userId", "setUserId$sdk_release", "sdk_release"})
public final class RadarSettings {
    private static final String KEY_PUBLISHABLE_KEY = "publishable_key";
    private static final String KEY_INSTALL_ID = "install_id";
    private static final String KEY_ID = "radar_user_id";
    private static final String KEY_USER_ID = "user_id";
    private static final String KEY_DESCRIPTION = "user_description";
    private static final String KEY_METADATA = "user_metadata";
    private static final String KEY_AD_ID_ENABLED = "ad_id_enabled";
    private static final String KEY_TRACKING = "background_tracking";
    private static final String KEY_TRACKING_OPTIONS = "tracking_options";
    private static final String KEY_TRIP_OPTIONS = "trip_options";
    private static final String KEY_LOG_LEVEL = "log_level";
    private static final String KEY_CONFIG = "config";
    private static final String KEY_HOST = "host";
    private static final String KEY_OLD_UPDATE_INTERVAL = "dwell_delay";
    private static final int KEY_OLD_UPDATE_INTERVAL_RESPONSIVE = 60000;
    private static final String KEY_OLD_SYNC_MODE = "sync_mode";
    private static final String KEY_OLD_OFFLINE_MODE = "offline_mode";
    public static final RadarSettings INSTANCE;

    private final SharedPreferences getSharedPreferences(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("RadarSDK", 0);
        Intrinsics.checkExpressionValueIsNotNull((Object)sharedPreferences, (String)"context.getSharedPrefere\u2026K\", Context.MODE_PRIVATE)");
        return sharedPreferences;
    }

    @Nullable
    public final String getPublishableKey$sdk_release(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return this.getSharedPreferences(context).getString(KEY_PUBLISHABLE_KEY, null);
    }

    public final void setPublishableKey$sdk_release(@NotNull Context context, @Nullable String publishableKey) {
        SharedPreferences.Editor editor$iv;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        SharedPreferences $this$edit$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor = editor$iv = $this$edit$iv.edit();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"editor");
        SharedPreferences.Editor $this$edit = editor;
        boolean bl = false;
        $this$edit.putString(KEY_PUBLISHABLE_KEY, publishableKey);
        editor$iv.apply();
    }

    @NotNull
    public final String getInstallId$sdk_release(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        String installId = this.getSharedPreferences(context).getString(KEY_INSTALL_ID, null);
        if (installId == null) {
            SharedPreferences.Editor editor$iv;
            installId = UUID.randomUUID().toString();
            SharedPreferences $this$edit$iv = this.getSharedPreferences(context);
            boolean commit$iv = false;
            boolean $i$f$edit = false;
            SharedPreferences.Editor editor = editor$iv = $this$edit$iv.edit();
            Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"editor");
            SharedPreferences.Editor $this$edit = editor;
            boolean bl = false;
            $this$edit.putString(KEY_INSTALL_ID, installId);
            editor$iv.apply();
        }
        return installId;
    }

    @Nullable
    public final String getId$sdk_release(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return this.getSharedPreferences(context).getString(KEY_ID, null);
    }

    public final void setId$sdk_release(@NotNull Context context, @Nullable String _id) {
        SharedPreferences.Editor editor$iv;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        SharedPreferences $this$edit$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor = editor$iv = $this$edit$iv.edit();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"editor");
        SharedPreferences.Editor $this$edit = editor;
        boolean bl = false;
        $this$edit.putString(KEY_ID, _id);
        editor$iv.apply();
    }

    @Nullable
    public final String getUserId$sdk_release(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return this.getSharedPreferences(context).getString(KEY_USER_ID, null);
    }

    public final void setUserId$sdk_release(@NotNull Context context, @Nullable String userId) {
        SharedPreferences.Editor editor$iv;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        SharedPreferences $this$edit$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor = editor$iv = $this$edit$iv.edit();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"editor");
        SharedPreferences.Editor $this$edit = editor;
        boolean bl = false;
        $this$edit.putString(KEY_USER_ID, userId);
        editor$iv.apply();
    }

    @Nullable
    public final String getDescription$sdk_release(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return this.getSharedPreferences(context).getString(KEY_DESCRIPTION, null);
    }

    public final void setDescription$sdk_release(@NotNull Context context, @Nullable String description) {
        SharedPreferences.Editor editor$iv;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        SharedPreferences $this$edit$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor = editor$iv = $this$edit$iv.edit();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"editor");
        SharedPreferences.Editor $this$edit = editor;
        boolean bl = false;
        $this$edit.putString(KEY_DESCRIPTION, description);
        editor$iv.apply();
    }

    @Nullable
    public final JSONObject getMetadata$sdk_release(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        String string = this.getSharedPreferences(context).getString(KEY_METADATA, null);
        if (string == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"getSharedPreferences(con\u2026ATA, null) ?: return null");
        String metadataJson = string;
        return new JSONObject(metadataJson);
    }

    public final void setMetadata$sdk_release(@NotNull Context context, @Nullable JSONObject metadata) {
        SharedPreferences.Editor editor$iv;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        JSONObject jSONObject = metadata;
        String metadataJSON = jSONObject != null ? jSONObject.toString() : null;
        SharedPreferences $this$edit$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor = editor$iv = $this$edit$iv.edit();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"editor");
        SharedPreferences.Editor $this$edit = editor;
        boolean bl = false;
        $this$edit.putString(KEY_METADATA, metadataJSON);
        editor$iv.apply();
    }

    public final boolean getAdIdEnabled$sdk_release(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return this.getSharedPreferences(context).getBoolean(KEY_AD_ID_ENABLED, false);
    }

    public final void setAdIdEnabled$sdk_release(@NotNull Context context, boolean enabled) {
        SharedPreferences.Editor editor$iv;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        SharedPreferences $this$edit$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor = editor$iv = $this$edit$iv.edit();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"editor");
        SharedPreferences.Editor $this$edit = editor;
        boolean bl = false;
        $this$edit.putBoolean(KEY_AD_ID_ENABLED, enabled);
        editor$iv.apply();
    }

    public final boolean getTracking$sdk_release(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return this.getSharedPreferences(context).getBoolean(KEY_TRACKING, false);
    }

    public final void setTracking$sdk_release(@NotNull Context context, boolean tracking) {
        SharedPreferences.Editor editor$iv;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        SharedPreferences $this$edit$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor = editor$iv = $this$edit$iv.edit();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"editor");
        SharedPreferences.Editor $this$edit = editor;
        boolean bl = false;
        $this$edit.putBoolean(KEY_TRACKING, tracking);
        editor$iv.apply();
    }

    @NotNull
    public final RadarTrackingOptions getTrackingOptions$sdk_release(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        String optionsJson = this.getSharedPreferences(context).getString(KEY_TRACKING_OPTIONS, null);
        RadarTrackingOptions options = null;
        if (optionsJson != null) {
            JSONObject optionsObj = new JSONObject(optionsJson);
            options = RadarTrackingOptions.Companion.fromJson(optionsObj);
        } else {
            int oldInterval = this.getSharedPreferences(context).getInt(KEY_OLD_UPDATE_INTERVAL, 0);
            if (oldInterval > 0) {
                int oldOffline;
                options = oldInterval == 60000 ? RadarTrackingOptions.RESPONSIVE : RadarTrackingOptions.EFFICIENT;
                int oldSync = this.getSharedPreferences(context).getInt(KEY_OLD_SYNC_MODE, 0);
                if (oldSync == -1) {
                    options.setSync(RadarTrackingOptions.RadarTrackingOptionsSync.ALL);
                }
                if ((oldOffline = this.getSharedPreferences(context).getInt(KEY_OLD_OFFLINE_MODE, 0)) == -1) {
                    options.setReplay(RadarTrackingOptions.RadarTrackingOptionsReplay.NONE);
                }
            } else {
                options = RadarTrackingOptions.EFFICIENT;
            }
        }
        return options;
    }

    public final void setTrackingOptions$sdk_release(@NotNull Context context, @NotNull RadarTrackingOptions options) {
        SharedPreferences.Editor editor$iv;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        JSONObject optionsObj = options.toJson();
        String string = optionsObj.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"optionsObj.toString()");
        String optionsJson = string;
        SharedPreferences $this$edit$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor = editor$iv = $this$edit$iv.edit();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"editor");
        SharedPreferences.Editor $this$edit = editor;
        boolean bl = false;
        $this$edit.putString(KEY_TRACKING_OPTIONS, optionsJson);
        editor$iv.apply();
    }

    @Nullable
    public final RadarTripOptions getTripOptions$sdk_release(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        String string = this.getSharedPreferences(context).getString(KEY_TRIP_OPTIONS, null);
        if (string == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"getSharedPreferences(con\u2026ONS, null) ?: return null");
        String optionsJson = string;
        JSONObject optionsObj = new JSONObject(optionsJson);
        return RadarTripOptions.Companion.fromJson(optionsObj);
    }

    public final void setTripOptions$sdk_release(@NotNull Context context, @Nullable RadarTripOptions options) {
        SharedPreferences.Editor editor$iv;
        JSONObject optionsObj;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        RadarTripOptions radarTripOptions = options;
        JSONObject jSONObject = optionsObj = radarTripOptions != null ? radarTripOptions.toJson() : null;
        String optionsJson = jSONObject != null ? jSONObject.toString() : null;
        boolean bl = false;
        System.out.print((Object)optionsJson);
        SharedPreferences $this$edit$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor = editor$iv = $this$edit$iv.edit();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"editor");
        SharedPreferences.Editor $this$edit = editor;
        boolean bl2 = false;
        $this$edit.putString(KEY_TRIP_OPTIONS, optionsJson);
        editor$iv.apply();
    }

    @NotNull
    public final Radar.RadarLogLevel getLogLevel$sdk_release(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        int logLevelInt = this.getSharedPreferences(context).getInt(KEY_LOG_LEVEL, 0);
        return Radar.RadarLogLevel.Companion.fromInt(logLevelInt);
    }

    public final void setLogLevel$sdk_release(@NotNull Context context, @NotNull Radar.RadarLogLevel level) {
        SharedPreferences.Editor editor$iv;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)((Object)level), (String)"level");
        int logLevelInt = level.getValue();
        SharedPreferences $this$edit$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor = editor$iv = $this$edit$iv.edit();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"editor");
        SharedPreferences.Editor $this$edit = editor;
        boolean bl = false;
        $this$edit.putInt(KEY_LOG_LEVEL, logLevelInt);
        editor$iv.apply();
    }

    public final void setConfig$sdk_release(@NotNull Context context, @Nullable JSONObject config) {
        SharedPreferences.Editor editor$iv;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        String configJson = String.valueOf(config);
        SharedPreferences $this$edit$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor = editor$iv = $this$edit$iv.edit();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"editor");
        SharedPreferences.Editor $this$edit = editor;
        boolean bl = false;
        $this$edit.putString(KEY_CONFIG, configJson);
        editor$iv.apply();
    }

    @NotNull
    public final String getHost$sdk_release(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        String string = this.getSharedPreferences(context).getString(KEY_HOST, null);
        if (string == null) {
            string = "https://api.radar.io";
        }
        return string;
    }

    private RadarSettings() {
    }

    static {
        RadarSettings radarSettings;
        INSTANCE = radarSettings = new RadarSettings();
    }
}

