/*
 * Decompiled with CFR 0.152.
 */
package io.radar.sdk;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.os.Bundle;
import android.os.IBinder;
import androidx.annotation.RequiresApi;
import io.radar.sdk.RadarLogger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\"\u0010\t\u001a\u00020\n2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0016J\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/radar/sdk/RadarForegroundService;", "Landroid/app/Service;", "()V", "logger", "Lio/radar/sdk/RadarLogger;", "onBind", "Landroid/os/IBinder;", "intent", "Landroid/content/Intent;", "onStartCommand", "", "flags", "startId", "startForegroundService", "", "extras", "Landroid/os/Bundle;", "Companion", "sdk_release"})
@RequiresApi(value=26)
public final class RadarForegroundService
extends Service {
    private RadarLogger logger;
    private static boolean started;
    public static final Companion Companion;

    public int onStartCommand(@Nullable Intent intent, int flags, int startId) {
        if (this.logger == null) {
            Context context = this.getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"applicationContext");
            this.logger = new RadarLogger(context);
        }
        if (intent != null) {
            if (Intrinsics.areEqual((Object)intent.getAction(), (Object)"start")) {
                if (started) {
                    RadarLogger radarLogger = this.logger;
                    if (radarLogger == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                    }
                    RadarLogger.d$default(radarLogger, "Foreground service already started", null, 2, null);
                } else {
                    try {
                        this.startForegroundService(intent.getExtras());
                        started = true;
                    }
                    catch (Exception e) {
                        RadarLogger radarLogger = this.logger;
                        if (radarLogger == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                        }
                        radarLogger.e("Error starting foreground service", e);
                    }
                }
            } else if (Intrinsics.areEqual((Object)intent.getAction(), (Object)"stop")) {
                try {
                    this.stopForeground(true);
                    this.stopSelf();
                    started = false;
                }
                catch (Exception e) {
                    RadarLogger radarLogger = this.logger;
                    if (radarLogger == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                    }
                    radarLogger.e("Error stopping foreground service", e);
                }
            }
        }
        return 1;
    }

    private final void startForegroundService(Bundle extras) {
        boolean bl;
        CharSequence charSequence;
        Object object = this.getSystemService("notification");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.app.NotificationManager");
        }
        NotificationManager manager = (NotificationManager)object;
        manager.deleteNotificationChannel("RadarSDK");
        Bundle bundle = extras;
        int id = bundle != null ? bundle.getInt("id") : 0;
        id = id == 0 ? 20160525 : id;
        Bundle bundle2 = extras;
        int importance = bundle2 != null ? bundle2.getInt("importance") : 0;
        importance = importance == 0 ? 3 : importance;
        Bundle bundle3 = extras;
        String title = bundle3 != null ? bundle3.getString("title") : null;
        Object object2 = extras;
        if (object2 == null || (object2 = object2.getString("text")) == null) {
            object2 = "Location tracking started";
        }
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"extras?.getString(\"text\"\u2026ocation tracking started\"");
        Object text = object2;
        Bundle bundle4 = extras;
        int icon = bundle4 != null ? bundle4.getInt("icon") : 0;
        icon = icon == 0 ? this.getApplicationInfo().icon : icon;
        Resources resources = this.getResources();
        String string = String.valueOf(icon);
        Context context = this.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"applicationContext");
        int smallIcon = resources.getIdentifier(string, "drawable", context.getPackageName());
        NotificationChannel channel = new NotificationChannel("RadarSDK", (CharSequence)"RadarSDK", importance);
        Object object3 = this.getSystemService("notification");
        if (object3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.app.NotificationManager");
        }
        NotificationManager notificationManager = (NotificationManager)object3;
        notificationManager.createNotificationChannel(channel);
        Notification.Builder builder = new Notification.Builder(this.getApplicationContext(), "RadarSDK").setContentText((CharSequence)text).setOngoing(true).setSmallIcon(smallIcon);
        if (title != null) {
            charSequence = title;
            bl = false;
            if (charSequence.length() > 0) {
                builder = builder.setContentTitle((CharSequence)title);
            }
        }
        try {
            Object object4 = extras;
            if (object4 != null && (object4 = object4.getString("activity")) != null) {
                charSequence = object4;
                bl = false;
                boolean bl2 = false;
                CharSequence it = charSequence;
                boolean bl3 = false;
                Class<?> clazz = Class.forName((String)it);
                Intrinsics.checkNotNullExpressionValue(clazz, (String)"Class.forName(it)");
                Class<?> activityClass = clazz;
                Intent intent = new Intent((Context)this, activityClass);
                intent.setFlags(0x10008000);
                PendingIntent pendingIntent = PendingIntent.getActivity((Context)((Context)this), (int)0, (Intent)intent, (int)0);
                builder = builder.setContentIntent(pendingIntent);
            }
        }
        catch (ClassNotFoundException e) {
            RadarLogger radarLogger = this.logger;
            if (radarLogger == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
            }
            radarLogger.e("Error setting foreground service content intent", e);
        }
        Notification notification = builder.build();
        this.startForeground(id, notification);
    }

    @Nullable
    public IBinder onBind(@NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        throw (Throwable)new UnsupportedOperationException();
    }

    static {
        Companion = new Companion(null);
    }

    public static final /* synthetic */ RadarLogger access$getLogger$p(RadarForegroundService $this) {
        RadarLogger radarLogger = $this.logger;
        if (radarLogger == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
        }
        return radarLogger;
    }

    public static final /* synthetic */ void access$setLogger$p(RadarForegroundService $this, RadarLogger radarLogger) {
        $this.logger = radarLogger;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lio/radar/sdk/RadarForegroundService$Companion;", "", "()V", "started", "", "getStarted$sdk_release", "()Z", "setStarted$sdk_release", "(Z)V", "sdk_release"})
    public static final class Companion {
        public final boolean getStarted$sdk_release() {
            return started;
        }

        public final void setStarted$sdk_release(boolean bl) {
            started = bl;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

