/*
 * Decompiled with CFR 0.152.
 */
package io.radar.sdk;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.location.Location;
import android.location.LocationManager;
import android.os.Build;
import android.provider.Settings;
import androidx.core.content.ContextCompat;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import io.radar.sdk.RadarSettings;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u0015\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u0018J\u0015\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u001bJ\u0017\u0010\u001c\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0001\u00a2\u0006\u0002\b\u001dJ\u0015\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u001fJ\u0015\u0010 \u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b!J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\r\u0010$\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b%J\u0015\u0010&\u001a\u00020'2\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b(J\u0015\u0010)\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020+H\u0000\u00a2\u0006\u0002\b,R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\n \t*\u0004\u0018\u00010\u00040\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0007R\u001c\u0010\u000b\u001a\n \t*\u0004\u0018\u00010\u00040\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0007R\u001c\u0010\r\u001a\n \t*\u0004\u0018\u00010\u00040\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0007R\u000e\u0010\u000f\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00128@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006-"}, d2={"Lio/radar/sdk/RadarUtils;", "", "()V", "KEY_AD_ID", "", "country", "getCountry$sdk_release", "()Ljava/lang/String;", "deviceMake", "kotlin.jvm.PlatformType", "getDeviceMake$sdk_release", "deviceModel", "getDeviceModel$sdk_release", "deviceOS", "getDeviceOS$sdk_release", "deviceType", "sdkVersion", "timeZoneOffset", "", "getTimeZoneOffset$sdk_release", "()I", "getAdId", "context", "Landroid/content/Context;", "getAdId$sdk_release", "getBluetoothSupported", "", "getBluetoothSupported$sdk_release", "getDeviceId", "getDeviceId$sdk_release", "getLocationAuthorization", "getLocationAuthorization$sdk_release", "getLocationEnabled", "getLocationEnabled$sdk_release", "getSharedPreferences", "Landroid/content/SharedPreferences;", "isEmulator", "isEmulator$sdk_release", "loadAdId", "", "loadAdId$sdk_release", "valid", "location", "Landroid/location/Location;", "valid$sdk_release", "sdk_release"})
public final class RadarUtils {
    private static final String KEY_AD_ID = "adId";
    private static final String deviceModel;
    private static final String deviceOS;
    @NotNull
    public static final String sdkVersion = "3.1.12";
    @NotNull
    public static final String deviceType = "Android";
    private static final String deviceMake;
    public static final RadarUtils INSTANCE;

    private final SharedPreferences getSharedPreferences(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("RadarSDK", 0);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"context.getSharedPrefere\u2026K\", Context.MODE_PRIVATE)");
        return sharedPreferences;
    }

    public final String getDeviceModel$sdk_release() {
        return deviceModel;
    }

    public final String getDeviceOS$sdk_release() {
        return deviceOS;
    }

    @NotNull
    public final String getCountry$sdk_release() {
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.getDefault()");
        String string = locale.getCountry();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Locale.getDefault().country");
        return string;
    }

    public final int getTimeZoneOffset$sdk_release() {
        TimeZone timeZone;
        Calendar calendar = Calendar.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)calendar, (String)"Calendar.getInstance()");
        TimeZone timeZone2 = timeZone = calendar.getTimeZone();
        Intrinsics.checkNotNullExpressionValue((Object)timeZone2, (String)"timeZone");
        int offset = timeZone2.getRawOffset();
        if (timeZone.inDaylightTime(new Date())) {
            offset += timeZone.getDSTSavings();
        }
        return offset / 1000;
    }

    public final void loadAdId$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        new Thread(new Runnable(context){
            final /* synthetic */ Context $context;

            public final void run() {
                try {
                    SharedPreferences.Editor editor$iv;
                    AdvertisingIdClient.Info advertisingIdInfo;
                    AdvertisingIdClient.Info info = advertisingIdInfo = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.$context);
                    Intrinsics.checkNotNullExpressionValue((Object)info, (String)"advertisingIdInfo");
                    String adId = info.isLimitAdTrackingEnabled() ? "OptedOut" : advertisingIdInfo.getId();
                    SharedPreferences $this$edit$iv = RadarUtils.access$getSharedPreferences(RadarUtils.INSTANCE, this.$context);
                    boolean commit$iv = false;
                    boolean $i$f$edit = false;
                    SharedPreferences.Editor editor = editor$iv = $this$edit$iv.edit();
                    Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"editor");
                    SharedPreferences.Editor $this$edit = editor;
                    boolean bl = false;
                    $this$edit.putString("adId", adId);
                    editor$iv.apply();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            {
                this.$context = context;
            }
        }).start();
    }

    @Nullable
    public final String getAdId$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.getSharedPreferences(context).getString(KEY_AD_ID, null);
    }

    @SuppressLint(value={"HardwareIds"})
    @Nullable
    public final String getDeviceId$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
    }

    public final String getDeviceMake$sdk_release() {
        return deviceMake;
    }

    @NotNull
    public final String getLocationAuthorization$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String locationAuthorization = "NOT_DETERMINED";
        if (RadarSettings.INSTANCE.getPermissionsDenied$sdk_release(context)) {
            locationAuthorization = "DENIED";
        }
        if (ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_FINE_LOCATION") == 0) {
            locationAuthorization = "GRANTED_FOREGROUND";
        }
        if (Build.VERSION.SDK_INT >= 29 && ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_BACKGROUND_LOCATION") == 0) {
            locationAuthorization = "GRANTED_BACKGROUND";
        }
        return locationAuthorization;
    }

    public final boolean getBluetoothSupported$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return context.getPackageManager().hasSystemFeature("android.hardware.bluetooth");
    }

    public final boolean getLocationEnabled$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("location");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.location.LocationManager");
        }
        LocationManager manager = (LocationManager)object;
        return manager.isProviderEnabled("gps") || manager.isProviderEnabled("network");
    }

    public final boolean valid$sdk_release(@NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        boolean latitudeValid = location.getLatitude() != 0.0 && location.getLatitude() > -90.0 && location.getLatitude() < 90.0;
        boolean longitudeValid = location.getLongitude() != 0.0 && location.getLongitude() > -180.0 && location.getLongitude() < 180.0;
        boolean accuracyValid = location.getAccuracy() > 0.0f;
        return latitudeValid && longitudeValid && accuracyValid;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isEmulator$sdk_release() {
        String string = Build.BRAND;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Build.BRAND");
        if (StringsKt.startsWith$default((String)string, (String)"generic", (boolean)false, (int)2, null)) {
            String string2 = Build.DEVICE;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"Build.DEVICE");
            if (StringsKt.startsWith$default((String)string2, (String)"generic", (boolean)false, (int)2, null)) return true;
        }
        String string3 = Build.FINGERPRINT;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"Build.FINGERPRINT");
        if (StringsKt.startsWith$default((String)string3, (String)"generic", (boolean)false, (int)2, null)) return true;
        String string4 = Build.FINGERPRINT;
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"Build.FINGERPRINT");
        if (StringsKt.startsWith$default((String)string4, (String)"unknown", (boolean)false, (int)2, null)) return true;
        String string5 = Build.HARDWARE;
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"Build.HARDWARE");
        if (StringsKt.contains$default((CharSequence)string5, (CharSequence)"goldfish", (boolean)false, (int)2, null)) return true;
        String string6 = Build.HARDWARE;
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"Build.HARDWARE");
        if (StringsKt.contains$default((CharSequence)string6, (CharSequence)"ranchu", (boolean)false, (int)2, null)) return true;
        String string7 = Build.MODEL;
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"Build.MODEL");
        if (StringsKt.contains$default((CharSequence)string7, (CharSequence)"google_sdk", (boolean)false, (int)2, null)) return true;
        String string8 = Build.MODEL;
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"Build.MODEL");
        if (StringsKt.contains$default((CharSequence)string8, (CharSequence)"Emulator", (boolean)false, (int)2, null)) return true;
        String string9 = Build.MODEL;
        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"Build.MODEL");
        if (StringsKt.contains$default((CharSequence)string9, (CharSequence)"Android SDK built for x86", (boolean)false, (int)2, null)) return true;
        String string10 = Build.MANUFACTURER;
        Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"Build.MANUFACTURER");
        if (StringsKt.contains$default((CharSequence)string10, (CharSequence)"Genymotion", (boolean)false, (int)2, null)) return true;
        String string11 = Build.PRODUCT;
        Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"Build.PRODUCT");
        if (StringsKt.contains$default((CharSequence)string11, (CharSequence)"sdk_google", (boolean)false, (int)2, null)) return true;
        String string12 = Build.PRODUCT;
        Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"Build.PRODUCT");
        if (StringsKt.contains$default((CharSequence)string12, (CharSequence)"google_sdk", (boolean)false, (int)2, null)) return true;
        String string13 = Build.PRODUCT;
        Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"Build.PRODUCT");
        if (StringsKt.contains$default((CharSequence)string13, (CharSequence)"sdk", (boolean)false, (int)2, null)) return true;
        String string14 = Build.PRODUCT;
        Intrinsics.checkNotNullExpressionValue((Object)string14, (String)"Build.PRODUCT");
        if (StringsKt.contains$default((CharSequence)string14, (CharSequence)"sdk_x86", (boolean)false, (int)2, null)) return true;
        String string15 = Build.PRODUCT;
        Intrinsics.checkNotNullExpressionValue((Object)string15, (String)"Build.PRODUCT");
        if (StringsKt.contains$default((CharSequence)string15, (CharSequence)"vbox86p", (boolean)false, (int)2, null)) return true;
        String string16 = Build.PRODUCT;
        Intrinsics.checkNotNullExpressionValue((Object)string16, (String)"Build.PRODUCT");
        if (StringsKt.contains$default((CharSequence)string16, (CharSequence)"emulator", (boolean)false, (int)2, null)) return true;
        String string17 = Build.PRODUCT;
        Intrinsics.checkNotNullExpressionValue((Object)string17, (String)"Build.PRODUCT");
        if (!StringsKt.contains$default((CharSequence)string17, (CharSequence)"simulator", (boolean)false, (int)2, null)) return false;
        return true;
    }

    private RadarUtils() {
    }

    static {
        RadarUtils radarUtils;
        INSTANCE = radarUtils = new RadarUtils();
        deviceModel = Build.MODEL;
        deviceOS = Build.VERSION.RELEASE;
        deviceMake = Build.MANUFACTURER;
    }

    public static final /* synthetic */ SharedPreferences access$getSharedPreferences(RadarUtils $this, Context context) {
        return $this.getSharedPreferences(context);
    }
}

