/*
 * Decompiled with CFR 0.152.
 */
package io.radar.sdk;

import io.radar.sdk.Radar;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\b\u0018\u0000 (2\u00020\u0001:\u0001(B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u001d\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\tH\u00c6\u0003JA\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\t\u0010$\u001a\u00020%H\u00d6\u0001J\u0006\u0010&\u001a\u00020\u0005J\t\u0010'\u001a\u00020\u0003H\u00d6\u0001R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\f\"\u0004\b\u0010\u0010\u000eR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\f\"\u0004\b\u0012\u0010\u000eR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006)"}, d2={"Lio/radar/sdk/RadarTripOptions;", "", "externalId", "", "metadata", "Lorg/json/JSONObject;", "destinationGeofenceTag", "destinationGeofenceExternalId", "mode", "Lio/radar/sdk/Radar$RadarRouteMode;", "(Ljava/lang/String;Lorg/json/JSONObject;Ljava/lang/String;Ljava/lang/String;Lio/radar/sdk/Radar$RadarRouteMode;)V", "getDestinationGeofenceExternalId", "()Ljava/lang/String;", "setDestinationGeofenceExternalId", "(Ljava/lang/String;)V", "getDestinationGeofenceTag", "setDestinationGeofenceTag", "getExternalId", "setExternalId", "getMetadata", "()Lorg/json/JSONObject;", "setMetadata", "(Lorg/json/JSONObject;)V", "getMode", "()Lio/radar/sdk/Radar$RadarRouteMode;", "setMode", "(Lio/radar/sdk/Radar$RadarRouteMode;)V", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toJson", "toString", "Companion", "sdk_release"})
public final class RadarTripOptions {
    @NotNull
    private String externalId;
    @Nullable
    private JSONObject metadata;
    @Nullable
    private String destinationGeofenceTag;
    @Nullable
    private String destinationGeofenceExternalId;
    @NotNull
    private Radar.RadarRouteMode mode;
    @NotNull
    public static final String KEY_EXTERNAL_ID = "externalId";
    @NotNull
    public static final String KEY_METADATA = "metadata";
    @NotNull
    public static final String KEY_DESTINATION_GEOFENCE_TAG = "destinationGeofenceTag";
    @NotNull
    public static final String KEY_DESTINATION_GEOFENCE_EXTERNAL_ID = "destinationGeofenceExternalId";
    @NotNull
    public static final String KEY_MODE = "mode";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final JSONObject toJson() {
        JSONObject obj = new JSONObject();
        obj.put(KEY_EXTERNAL_ID, (Object)this.externalId);
        obj.put(KEY_METADATA, (Object)this.metadata);
        obj.put(KEY_DESTINATION_GEOFENCE_TAG, (Object)this.destinationGeofenceTag);
        obj.put(KEY_DESTINATION_GEOFENCE_EXTERNAL_ID, (Object)this.destinationGeofenceExternalId);
        obj.put(KEY_MODE, (Object)Radar.stringForMode(this.mode));
        return obj;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type io.radar.sdk.RadarTripOptions");
        }
        RadarTripOptions cfr_ignored_0 = (RadarTripOptions)object2;
        if (!Intrinsics.areEqual((Object)this.externalId, (Object)((RadarTripOptions)other).externalId)) return false;
        JSONObject jSONObject = this.metadata;
        JSONObject jSONObject2 = ((RadarTripOptions)other).metadata;
        if (!Intrinsics.areEqual((Object)(jSONObject != null ? jSONObject.toString() : null), (Object)(jSONObject2 != null ? jSONObject2.toString() : null))) return false;
        if (!Intrinsics.areEqual((Object)this.destinationGeofenceTag, (Object)((RadarTripOptions)other).destinationGeofenceTag)) return false;
        if (!Intrinsics.areEqual((Object)this.destinationGeofenceExternalId, (Object)((RadarTripOptions)other).destinationGeofenceExternalId)) return false;
        if (this.mode != ((RadarTripOptions)other).mode) return false;
        return true;
    }

    @NotNull
    public final String getExternalId() {
        return this.externalId;
    }

    public final void setExternalId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.externalId = string;
    }

    @Nullable
    public final JSONObject getMetadata() {
        return this.metadata;
    }

    public final void setMetadata(@Nullable JSONObject jSONObject) {
        this.metadata = jSONObject;
    }

    @Nullable
    public final String getDestinationGeofenceTag() {
        return this.destinationGeofenceTag;
    }

    public final void setDestinationGeofenceTag(@Nullable String string) {
        this.destinationGeofenceTag = string;
    }

    @Nullable
    public final String getDestinationGeofenceExternalId() {
        return this.destinationGeofenceExternalId;
    }

    public final void setDestinationGeofenceExternalId(@Nullable String string) {
        this.destinationGeofenceExternalId = string;
    }

    @NotNull
    public final Radar.RadarRouteMode getMode() {
        return this.mode;
    }

    public final void setMode(@NotNull Radar.RadarRouteMode radarRouteMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)radarRouteMode), (String)"<set-?>");
        this.mode = radarRouteMode;
    }

    public RadarTripOptions(@NotNull String externalId, @Nullable JSONObject metadata, @Nullable String destinationGeofenceTag, @Nullable String destinationGeofenceExternalId, @NotNull Radar.RadarRouteMode mode) {
        Intrinsics.checkNotNullParameter((Object)externalId, (String)KEY_EXTERNAL_ID);
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)KEY_MODE);
        this.externalId = externalId;
        this.metadata = metadata;
        this.destinationGeofenceTag = destinationGeofenceTag;
        this.destinationGeofenceExternalId = destinationGeofenceExternalId;
        this.mode = mode;
    }

    public /* synthetic */ RadarTripOptions(String string, JSONObject jSONObject, String string2, String string3, Radar.RadarRouteMode radarRouteMode, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            jSONObject = null;
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        if ((n & 8) != 0) {
            string3 = null;
        }
        if ((n & 0x10) != 0) {
            radarRouteMode = Radar.RadarRouteMode.CAR;
        }
        this(string, jSONObject, string2, string3, radarRouteMode);
    }

    @NotNull
    public final String component1() {
        return this.externalId;
    }

    @Nullable
    public final JSONObject component2() {
        return this.metadata;
    }

    @Nullable
    public final String component3() {
        return this.destinationGeofenceTag;
    }

    @Nullable
    public final String component4() {
        return this.destinationGeofenceExternalId;
    }

    @NotNull
    public final Radar.RadarRouteMode component5() {
        return this.mode;
    }

    @NotNull
    public final RadarTripOptions copy(@NotNull String externalId, @Nullable JSONObject metadata, @Nullable String destinationGeofenceTag, @Nullable String destinationGeofenceExternalId, @NotNull Radar.RadarRouteMode mode) {
        Intrinsics.checkNotNullParameter((Object)externalId, (String)KEY_EXTERNAL_ID);
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)KEY_MODE);
        return new RadarTripOptions(externalId, metadata, destinationGeofenceTag, destinationGeofenceExternalId, mode);
    }

    public static /* synthetic */ RadarTripOptions copy$default(RadarTripOptions radarTripOptions, String string, JSONObject jSONObject, String string2, String string3, Radar.RadarRouteMode radarRouteMode, int n, Object object) {
        if ((n & 1) != 0) {
            string = radarTripOptions.externalId;
        }
        if ((n & 2) != 0) {
            jSONObject = radarTripOptions.metadata;
        }
        if ((n & 4) != 0) {
            string2 = radarTripOptions.destinationGeofenceTag;
        }
        if ((n & 8) != 0) {
            string3 = radarTripOptions.destinationGeofenceExternalId;
        }
        if ((n & 0x10) != 0) {
            radarRouteMode = radarTripOptions.mode;
        }
        return radarTripOptions.copy(string, jSONObject, string2, string3, radarRouteMode);
    }

    @NotNull
    public String toString() {
        return "RadarTripOptions(externalId=" + this.externalId + ", metadata=" + this.metadata + ", destinationGeofenceTag=" + this.destinationGeofenceTag + ", destinationGeofenceExternalId=" + this.destinationGeofenceExternalId + ", mode=" + (Object)((Object)this.mode) + ")";
    }

    public int hashCode() {
        String string = this.externalId;
        JSONObject jSONObject = this.metadata;
        String string2 = this.destinationGeofenceTag;
        String string3 = this.destinationGeofenceExternalId;
        Radar.RadarRouteMode radarRouteMode = this.mode;
        return ((((string != null ? string.hashCode() : 0) * 31 + (jSONObject != null ? jSONObject.hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31 + (radarRouteMode != null ? ((Object)((Object)radarRouteMode)).hashCode() : 0);
    }

    @JvmStatic
    @NotNull
    public static final RadarTripOptions fromJson(@NotNull JSONObject obj) {
        return Companion.fromJson(obj);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/radar/sdk/RadarTripOptions$Companion;", "", "()V", "KEY_DESTINATION_GEOFENCE_EXTERNAL_ID", "", "KEY_DESTINATION_GEOFENCE_TAG", "KEY_EXTERNAL_ID", "KEY_METADATA", "KEY_MODE", "fromJson", "Lio/radar/sdk/RadarTripOptions;", "obj", "Lorg/json/JSONObject;", "sdk_release"})
    public static final class Companion {
        /*
         * Enabled aggressive block sorting
         */
        @JvmStatic
        @NotNull
        public final RadarTripOptions fromJson(@NotNull JSONObject obj) {
            Radar.RadarRouteMode radarRouteMode;
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            String string = obj.optString(RadarTripOptions.KEY_EXTERNAL_ID);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"obj.optString(KEY_EXTERNAL_ID)");
            JSONObject jSONObject = obj.optJSONObject(RadarTripOptions.KEY_METADATA);
            String string2 = obj.optString(RadarTripOptions.KEY_DESTINATION_GEOFENCE_TAG);
            String string3 = obj.optString(RadarTripOptions.KEY_DESTINATION_GEOFENCE_EXTERNAL_ID);
            String string4 = obj.optString(RadarTripOptions.KEY_MODE);
            if (string4 != null) {
                switch (string4) {
                    case "foot": {
                        radarRouteMode = Radar.RadarRouteMode.FOOT;
                        return new RadarTripOptions(string, jSONObject, string2, string3, radarRouteMode);
                    }
                    case "bike": {
                        radarRouteMode = Radar.RadarRouteMode.BIKE;
                        return new RadarTripOptions(string, jSONObject, string2, string3, radarRouteMode);
                    }
                    case "truck": {
                        radarRouteMode = Radar.RadarRouteMode.TRUCK;
                        return new RadarTripOptions(string, jSONObject, string2, string3, radarRouteMode);
                    }
                    case "motorbike": {
                        radarRouteMode = Radar.RadarRouteMode.MOTORBIKE;
                        return new RadarTripOptions(string, jSONObject, string2, string3, radarRouteMode);
                    }
                }
            }
            radarRouteMode = Radar.RadarRouteMode.CAR;
            return new RadarTripOptions(string, jSONObject, string2, string3, radarRouteMode);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

