/*
 * Decompiled with CFR 0.152.
 */
package io.radar.sdk;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanRecord;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import androidx.annotation.RequiresApi;
import io.radar.sdk.Radar;
import io.radar.sdk.RadarBeaconUtils;
import io.radar.sdk.RadarLogger;
import io.radar.sdk.RadarPermissionsHelper;
import io.radar.sdk.model.RadarBeacon;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u0000 -2\u00020\u0001:\u0001-B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0003\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u0011H\u0002J\u001f\u0010$\u001a\u00020\"2\u0010\b\u0002\u0010%\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\fH\u0002\u00a2\u0006\u0002\u0010&J\u0012\u0010'\u001a\u00020\"2\b\u0010(\u001a\u0004\u0018\u00010)H\u0002J#\u0010*\u001a\u00020\"2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\u0010#\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0002\u0010+J\b\u0010,\u001a\u00020\"H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR2\u0010\u000f\u001a&\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u0011 \u0012*\u0012\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u0011\u0018\u00010\u00130\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lio/radar/sdk/RadarBeaconManager;", "", "context", "Landroid/content/Context;", "logger", "Lio/radar/sdk/RadarLogger;", "permissionsHelper", "Lio/radar/sdk/RadarPermissionsHelper;", "(Landroid/content/Context;Lio/radar/sdk/RadarLogger;Lio/radar/sdk/RadarPermissionsHelper;)V", "adapter", "Landroid/bluetooth/BluetoothAdapter;", "beacons", "", "Lio/radar/sdk/model/RadarBeacon;", "[Lio/radar/sdk/model/RadarBeacon;", "callbacks", "", "Lio/radar/sdk/Radar$RadarBeaconCallback;", "kotlin.jvm.PlatformType", "", "handler", "Landroid/os/Handler;", "nearbyBeaconIdentifiers", "", "", "getPermissionsHelper$sdk_release", "()Lio/radar/sdk/RadarPermissionsHelper;", "setPermissionsHelper$sdk_release", "(Lio/radar/sdk/RadarPermissionsHelper;)V", "scanCallback", "Landroid/bluetooth/le/ScanCallback;", "started", "", "addCallback", "", "callback", "callCallbacks", "nearbyBeacons", "([Ljava/lang/String;)V", "handleScanResult", "result", "Landroid/bluetooth/le/ScanResult;", "rangeBeacons", "([Lio/radar/sdk/model/RadarBeacon;Lio/radar/sdk/Radar$RadarBeaconCallback;)V", "stopRanging", "Companion", "sdk_release"})
@RequiresApi(value=21)
@SuppressLint(value={"MissingPermission"})
public final class RadarBeaconManager {
    private BluetoothAdapter adapter;
    private boolean started;
    private final List<Radar.RadarBeaconCallback> callbacks;
    private Set<String> nearbyBeaconIdentifiers;
    private RadarBeacon[] beacons;
    private ScanCallback scanCallback;
    private final Handler handler;
    private final Context context;
    private final RadarLogger logger;
    @NotNull
    private RadarPermissionsHelper permissionsHelper;
    private static final String TIMEOUT_TOKEN = "timeout";
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addCallback(Radar.RadarBeaconCallback callback) {
        if (callback == null) {
            return;
        }
        List<Radar.RadarBeaconCallback> list = this.callbacks;
        Intrinsics.checkNotNullExpressionValue(list, (String)"callbacks");
        List<Radar.RadarBeaconCallback> list2 = list;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (list2) {
            boolean bl3 = false;
            bl2 = this.callbacks.add(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void callCallbacks(String[] nearbyBeacons) {
        List<Radar.RadarBeaconCallback> list = this.callbacks;
        Intrinsics.checkNotNullExpressionValue(list, (String)"callbacks");
        List<Radar.RadarBeaconCallback> list2 = list;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (list2) {
            boolean bl3 = false;
            if (this.callbacks.isEmpty()) {
                return;
            }
            RadarLogger.d$default(this.logger, this.context, "Calling callbacks | callbacks.size = " + this.callbacks.size(), null, 4, null);
            for (Radar.RadarBeaconCallback callback : this.callbacks) {
                callback.onComplete(Radar.RadarStatus.SUCCESS, nearbyBeacons);
            }
            this.callbacks.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    static /* synthetic */ void callCallbacks$default(RadarBeaconManager radarBeaconManager, String[] stringArray, int n, Object object) {
        if ((n & 1) != 0) {
            stringArray = null;
        }
        radarBeaconManager.callCallbacks(stringArray);
    }

    public final void rangeBeacons(@NotNull RadarBeacon[] beacons, @Nullable Radar.RadarBeaconCallback callback) {
        Intrinsics.checkNotNullParameter((Object)beacons, (String)"beacons");
        if (!this.permissionsHelper.bluetoothPermissionsGranted$sdk_release(this.context)) {
            RadarLogger.d$default(this.logger, this.context, "Bluetooth permissions not granted", null, 4, null);
            Radar.INSTANCE.broadcastErrorIntent$sdk_release(Radar.RadarStatus.ERROR_PERMISSIONS);
            Radar.RadarBeaconCallback radarBeaconCallback = callback;
            if (radarBeaconCallback != null) {
                Radar.RadarBeaconCallback.DefaultImpls.onComplete$default(radarBeaconCallback, Radar.RadarStatus.ERROR_PERMISSIONS, null, 2, null);
            }
            return;
        }
        if (this.adapter == null) {
            BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
            Intrinsics.checkNotNullExpressionValue((Object)bluetoothAdapter, (String)"BluetoothAdapter.getDefaultAdapter()");
            this.adapter = bluetoothAdapter;
        }
        BluetoothAdapter bluetoothAdapter = this.adapter;
        if (bluetoothAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
        }
        if (!bluetoothAdapter.isEnabled()) {
            RadarLogger.d$default(this.logger, this.context, "Bluetooth not enabled", null, 4, null);
            Radar.INSTANCE.broadcastErrorIntent$sdk_release(Radar.RadarStatus.ERROR_BLUETOOTH);
            Radar.RadarBeaconCallback radarBeaconCallback = callback;
            if (radarBeaconCallback != null) {
                Radar.RadarBeaconCallback.DefaultImpls.onComplete$default(radarBeaconCallback, Radar.RadarStatus.ERROR_BLUETOOTH, null, 2, null);
            }
            return;
        }
        this.addCallback(callback);
        if (this.started) {
            RadarLogger.d$default(this.logger, this.context, "Already ranging beacons", null, 4, null);
            return;
        }
        RadarBeacon[] radarBeaconArray = beacons;
        boolean bl = false;
        if (radarBeaconArray.length == 0) {
            RadarLogger.d$default(this.logger, this.context, "No beacons to range", null, 4, null);
            return;
        }
        this.beacons = beacons;
        this.started = true;
        bl = false;
        List scanFilters = new ArrayList();
        for (RadarBeacon beacon : beacons) {
            ScanFilter scanFilter;
            RadarLogger.d$default(this.logger, this.context, "Building scan filter | _id = " + beacon.get_id(), null, 4, null);
            if (RadarBeaconUtils.INSTANCE.getScanFilter(beacon) == null) continue;
            boolean bl2 = false;
            boolean bl3 = false;
            ScanFilter scanFilter2 = scanFilter;
            boolean bl4 = false;
            RadarLogger.d$default(this.logger, this.context, "Starting ranging beacon | _id = " + beacon.get_id() + "; uuid = " + beacon.getUuid() + "; major = " + beacon.getMajor() + "; minor = " + beacon.getMinor(), null, 4, null);
            scanFilters.add(scanFilter2);
        }
        ScanSettings scanSettings = new ScanSettings.Builder().setScanMode(1).setReportDelay(0L).build();
        RadarBeaconManager beaconManager = this;
        this.scanCallback = new ScanCallback(this, beaconManager){
            final /* synthetic */ RadarBeaconManager this$0;
            final /* synthetic */ RadarBeaconManager $beaconManager;

            public void onScanResult(int callbackType, @Nullable ScanResult result) {
                super.onScanResult(callbackType, result);
                RadarBeaconManager.access$handleScanResult(this.$beaconManager, result);
            }

            public void onBatchScanResults(@Nullable List<ScanResult> results) {
                super.onBatchScanResults(results);
                List<ScanResult> list = results;
                if (list != null) {
                    Iterable $this$forEach$iv = list;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        ScanResult result = (ScanResult)element$iv;
                        boolean bl = false;
                        RadarBeaconManager.access$handleScanResult(this.$beaconManager, result);
                    }
                }
            }

            public void onScanFailed(int errorCode) {
                super.onScanFailed(errorCode);
                RadarLogger.d$default(RadarBeaconManager.access$getLogger$p(this.this$0), RadarBeaconManager.access$getContext$p(this.$beaconManager), "Scan failed", null, 4, null);
                RadarBeaconManager.access$stopRanging(this.$beaconManager);
            }
            {
                this.this$0 = this$0;
                this.$beaconManager = $captured_local_variable$1;
            }
        };
        BluetoothAdapter bluetoothAdapter2 = this.adapter;
        if (bluetoothAdapter2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
        }
        bluetoothAdapter2.getBluetoothLeScanner().startScan(scanFilters, scanSettings, this.scanCallback);
        this.handler.postAtTime(new Runnable(this){
            final /* synthetic */ RadarBeaconManager this$0;

            public final void run() {
                RadarLogger.d$default(RadarBeaconManager.access$getLogger$p(this.this$0), RadarBeaconManager.access$getContext$p(this.this$0), "Beacon ranging timeout", null, 4, null);
                RadarBeaconManager.access$stopRanging(this.this$0);
            }
            {
                this.this$0 = radarBeaconManager;
            }
        }, (Object)TIMEOUT_TOKEN, SystemClock.uptimeMillis() + 5000L);
    }

    private final void stopRanging() {
        RadarLogger.d$default(this.logger, this.context, "Stopping ranging", null, 4, null);
        this.handler.removeCallbacksAndMessages((Object)TIMEOUT_TOKEN);
        BluetoothAdapter bluetoothAdapter = this.adapter;
        if (bluetoothAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
        }
        bluetoothAdapter.getBluetoothLeScanner().stopScan(this.scanCallback);
        this.scanCallback = null;
        Collection $this$toTypedArray$iv = this.nearbyBeaconIdentifiers;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        this.callCallbacks(stringArray);
        this.beacons = new RadarBeacon[0];
        this.started = false;
        this.nearbyBeaconIdentifiers.clear();
    }

    private final void handleScanResult(ScanResult result) {
        RadarLogger.d$default(this.logger, this.context, "Handling scan result", null, 4, null);
        Object object = result;
        if (object != null && (object = object.getScanRecord()) != null) {
            ScanResult scanResult = object;
            boolean bl = false;
            boolean bl2 = false;
            ScanResult scanRecord = scanResult;
            boolean bl3 = false;
            ScanResult scanResult2 = scanRecord;
            Intrinsics.checkNotNullExpressionValue((Object)scanResult2, (String)"scanRecord");
            object = RadarBeaconUtils.INSTANCE.getBeacon(this.beacons, (ScanRecord)scanResult2);
            if (object != null) {
                scanResult = object;
                bl = false;
                bl2 = false;
                ScanResult beacon = scanResult;
                boolean bl4 = false;
                RadarLogger.d$default(this.logger, this.context, "Ranged beacon | beacon._id = " + beacon.get_id(), null, 4, null);
                this.nearbyBeaconIdentifiers.add(beacon.get_id());
            }
        }
        if (this.nearbyBeaconIdentifiers.size() == this.beacons.length) {
            RadarLogger.d$default(this.logger, this.context, "Finished ranging", null, 4, null);
            this.stopRanging();
        }
    }

    @NotNull
    public final RadarPermissionsHelper getPermissionsHelper$sdk_release() {
        return this.permissionsHelper;
    }

    public final void setPermissionsHelper$sdk_release(@NotNull RadarPermissionsHelper radarPermissionsHelper) {
        Intrinsics.checkNotNullParameter((Object)radarPermissionsHelper, (String)"<set-?>");
        this.permissionsHelper = radarPermissionsHelper;
    }

    public RadarBeaconManager(@NotNull Context context, @NotNull RadarLogger logger, @SuppressLint(value={"VisibleForTests"}) @NotNull RadarPermissionsHelper permissionsHelper) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)permissionsHelper, (String)"permissionsHelper");
        this.context = context;
        this.logger = logger;
        this.permissionsHelper = permissionsHelper;
        boolean bl = false;
        this.callbacks = Collections.synchronizedList(new ArrayList());
        bl = false;
        this.nearbyBeaconIdentifiers = new LinkedHashSet();
        this.beacons = new RadarBeacon[0];
        this.handler = new Handler(Looper.getMainLooper());
    }

    public /* synthetic */ RadarBeaconManager(Context context, RadarLogger radarLogger, RadarPermissionsHelper radarPermissionsHelper, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            radarPermissionsHelper = new RadarPermissionsHelper();
        }
        this(context, radarLogger, radarPermissionsHelper);
    }

    public static final /* synthetic */ BluetoothAdapter access$getAdapter$p(RadarBeaconManager $this) {
        BluetoothAdapter bluetoothAdapter = $this.adapter;
        if (bluetoothAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
        }
        return bluetoothAdapter;
    }

    public static final /* synthetic */ void access$setAdapter$p(RadarBeaconManager $this, BluetoothAdapter bluetoothAdapter) {
        $this.adapter = bluetoothAdapter;
    }

    public static final /* synthetic */ void access$handleScanResult(RadarBeaconManager $this, ScanResult result) {
        $this.handleScanResult(result);
    }

    public static final /* synthetic */ RadarLogger access$getLogger$p(RadarBeaconManager $this) {
        return $this.logger;
    }

    public static final /* synthetic */ Context access$getContext$p(RadarBeaconManager $this) {
        return $this.context;
    }

    public static final /* synthetic */ void access$stopRanging(RadarBeaconManager $this) {
        $this.stopRanging();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/radar/sdk/RadarBeaconManager$Companion;", "", "()V", "TIMEOUT_TOKEN", "", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

