/*
 * Decompiled with CFR 0.152.
 */
package io.radar.sdk;

import android.annotation.SuppressLint;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.location.Location;
import android.os.Build;
import com.google.android.gms.location.GeofencingEvent;
import com.google.android.gms.location.LocationResult;
import io.radar.sdk.Radar;
import io.radar.sdk.RadarJobScheduler;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0017\u00a8\u0006\n"}, d2={"Lio/radar/sdk/RadarLocationReceiver;", "Landroid/content/BroadcastReceiver;", "()V", "onReceive", "", "context", "Landroid/content/Context;", "intent", "Landroid/content/Intent;", "Companion", "sdk_release"})
public final class RadarLocationReceiver
extends BroadcastReceiver {
    @NotNull
    public static final String ACTION_LOCATION = "io.radar.sdk.LocationReceiver.LOCATION";
    @NotNull
    public static final String ACTION_BUBBLE_GEOFENCE = "io.radar.sdk.LocationReceiver.GEOFENCE";
    @NotNull
    public static final String ACTION_SYNCED_GEOFENCES = "io.radar.sdk.LocationReceiver.SYNCED_GEOFENCES";
    @NotNull
    public static final String ACTION_BEACON = "io.radar.sdk.LocationReceiver.BEACON";
    public static final int REQUEST_CODE_LOCATION = 201605250;
    public static final int REQUEST_CODE_BUBBLE_GEOFENCE = 201605251;
    public static final int REQUEST_CODE_SYNCED_GEOFENCES = 201605252;
    public static final int REQUEST_CODE_BEACON = 201605253;
    public static final Companion Companion = new Companion(null);

    @SuppressLint(value={"MissingPermission"})
    public void onReceive(@NotNull Context context, @NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        String string = intent.getAction();
        if (string != null) {
            switch (string) {
                case "io.radar.sdk.LocationReceiver.GEOFENCE": 
                case "io.radar.sdk.LocationReceiver.SYNCED_GEOFENCES": {
                    GeofencingEvent event = GeofencingEvent.fromIntent((Intent)intent);
                    GeofencingEvent geofencingEvent = event;
                    if (geofencingEvent != null && (geofencingEvent = geofencingEvent.getTriggeringLocation()) != null) {
                        Radar.RadarLocationSource source;
                        GeofencingEvent geofencingEvent2 = geofencingEvent;
                        boolean bl = false;
                        boolean bl2 = false;
                        GeofencingEvent it = geofencingEvent2;
                        boolean bl3 = false;
                        switch (event.getGeofenceTransition()) {
                            case 1: {
                                Radar.RadarLocationSource radarLocationSource = Radar.RadarLocationSource.GEOFENCE_ENTER;
                                break;
                            }
                            case 4: {
                                Radar.RadarLocationSource radarLocationSource = Radar.RadarLocationSource.GEOFENCE_DWELL;
                                break;
                            }
                            default: {
                                Radar.RadarLocationSource radarLocationSource = source = Radar.RadarLocationSource.GEOFENCE_EXIT;
                            }
                        }
                        if (Build.VERSION.SDK_INT >= 21) {
                            RadarJobScheduler.Companion.scheduleJob$sdk_release(context, (Location)it, source);
                            break;
                        }
                        Radar.INSTANCE.handleLocation$sdk_release(context, (Location)it, source);
                    }
                    break;
                }
                case "io.radar.sdk.LocationReceiver.LOCATION": {
                    LocationResult result = LocationResult.extractResult((Intent)intent);
                    LocationResult locationResult = result;
                    if (locationResult != null && (locationResult = locationResult.getLastLocation()) != null) {
                        LocationResult locationResult2 = locationResult;
                        boolean bl = false;
                        boolean bl4 = false;
                        LocationResult it = locationResult2;
                        boolean bl5 = false;
                        Radar.RadarLocationSource source = Radar.RadarLocationSource.BACKGROUND_LOCATION;
                        if (Build.VERSION.SDK_INT >= 21) {
                            RadarJobScheduler.Companion.scheduleJob$sdk_release(context, (Location)it, source);
                            break;
                        }
                        Radar.INSTANCE.handleLocation$sdk_release(context, (Location)it, source);
                    }
                    break;
                }
                case "io.radar.sdk.LocationReceiver.BEACON": {
                    Radar.INSTANCE.handleBeacon$sdk_release(context, Radar.RadarLocationSource.BEACON_ENTER);
                    break;
                }
                case "android.intent.action.BOOT_COMPLETED": {
                    Radar.INSTANCE.handleBootCompleted$sdk_release(context);
                    break;
                }
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0015\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0013J\u0015\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0015J\u0015\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0017J\u0015\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0019R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lio/radar/sdk/RadarLocationReceiver$Companion;", "", "()V", "ACTION_BEACON", "", "ACTION_BUBBLE_GEOFENCE", "ACTION_LOCATION", "ACTION_SYNCED_GEOFENCES", "REQUEST_CODE_BEACON", "", "REQUEST_CODE_BUBBLE_GEOFENCE", "REQUEST_CODE_LOCATION", "REQUEST_CODE_SYNCED_GEOFENCES", "baseIntent", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "getBeaconPendingIntent", "Landroid/app/PendingIntent;", "getBeaconPendingIntent$sdk_release", "getBubbleGeofencePendingIntent", "getBubbleGeofencePendingIntent$sdk_release", "getLocationPendingIntent", "getLocationPendingIntent$sdk_release", "getSyncedGeofencesPendingIntent", "getSyncedGeofencesPendingIntent$sdk_release", "sdk_release"})
    public static final class Companion {
        @NotNull
        public final PendingIntent getLocationPendingIntent$sdk_release(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intent intent = this.baseIntent(context);
            boolean bl = false;
            boolean bl2 = false;
            Intent $this$apply = intent;
            boolean bl3 = false;
            $this$apply.setAction(RadarLocationReceiver.ACTION_LOCATION);
            Intent intent2 = intent;
            PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)201605250, (Intent)intent2, (int)0x8000000);
            Intrinsics.checkNotNullExpressionValue((Object)pendingIntent, (String)"PendingIntent.getBroadca\u2026tent.FLAG_UPDATE_CURRENT)");
            return pendingIntent;
        }

        @NotNull
        public final PendingIntent getBubbleGeofencePendingIntent$sdk_release(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intent intent = this.baseIntent(context);
            boolean bl = false;
            boolean bl2 = false;
            Intent $this$apply = intent;
            boolean bl3 = false;
            $this$apply.setAction(RadarLocationReceiver.ACTION_BUBBLE_GEOFENCE);
            Intent intent2 = intent;
            PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)201605251, (Intent)intent2, (int)0x8000000);
            Intrinsics.checkNotNullExpressionValue((Object)pendingIntent, (String)"PendingIntent.getBroadca\u2026tent.FLAG_UPDATE_CURRENT)");
            return pendingIntent;
        }

        @NotNull
        public final PendingIntent getSyncedGeofencesPendingIntent$sdk_release(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intent intent = this.baseIntent(context);
            boolean bl = false;
            boolean bl2 = false;
            Intent $this$apply = intent;
            boolean bl3 = false;
            $this$apply.setAction(RadarLocationReceiver.ACTION_SYNCED_GEOFENCES);
            Intent intent2 = intent;
            PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)201605252, (Intent)intent2, (int)0x8000000);
            Intrinsics.checkNotNullExpressionValue((Object)pendingIntent, (String)"PendingIntent.getBroadca\u2026tent.FLAG_UPDATE_CURRENT)");
            return pendingIntent;
        }

        @NotNull
        public final PendingIntent getBeaconPendingIntent$sdk_release(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intent intent = this.baseIntent(context);
            boolean bl = false;
            boolean bl2 = false;
            Intent $this$apply = intent;
            boolean bl3 = false;
            $this$apply.setAction(RadarLocationReceiver.ACTION_BEACON);
            Intent intent2 = intent;
            PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)201605253, (Intent)intent2, (int)0x8000000);
            Intrinsics.checkNotNullExpressionValue((Object)pendingIntent, (String)"PendingIntent.getBroadca\u2026tent.FLAG_UPDATE_CURRENT)");
            return pendingIntent;
        }

        private final Intent baseIntent(Context context) {
            return new Intent(context, RadarLocationReceiver.class);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

