/*
 * Decompiled with CFR 0.152.
 */
package io.radar.sdk.model;

import io.radar.sdk.model.RadarCircleGeometry;
import io.radar.sdk.model.RadarCoordinate;
import io.radar.sdk.model.RadarGeofenceGeometry;
import io.radar.sdk.model.RadarPolygonGeometry;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u0015\u001a\u00020\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\r\u00a8\u0006\u0017"}, d2={"Lio/radar/sdk/model/RadarGeofence;", "", "_id", "", "description", "tag", "externalId", "metadata", "Lorg/json/JSONObject;", "geometry", "Lio/radar/sdk/model/RadarGeofenceGeometry;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lorg/json/JSONObject;Lio/radar/sdk/model/RadarGeofenceGeometry;)V", "get_id", "()Ljava/lang/String;", "getDescription", "getExternalId", "getGeometry", "()Lio/radar/sdk/model/RadarGeofenceGeometry;", "getMetadata", "()Lorg/json/JSONObject;", "getTag", "toJson", "Companion", "sdk_release"})
public final class RadarGeofence {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String _id;
    @NotNull
    private final String description;
    @Nullable
    private final String tag;
    @Nullable
    private final String externalId;
    @Nullable
    private final JSONObject metadata;
    @Nullable
    private final RadarGeofenceGeometry geometry;
    @NotNull
    private static final String FIELD_ID = "_id";
    @NotNull
    private static final String FIELD_DESCRIPTION = "description";
    @NotNull
    private static final String FIELD_TAG = "tag";
    @NotNull
    private static final String FIELD_EXTERNAL_ID = "externalId";
    @NotNull
    private static final String FIELD_METADATA = "metadata";
    @NotNull
    private static final String FIELD_TYPE = "type";
    @NotNull
    private static final String FIELD_GEOMETRY = "geometry";
    @NotNull
    private static final String FIELD_GEOMETRY_RADIUS = "geometryRadius";
    @NotNull
    private static final String FIELD_GEOMETRY_CENTER = "geometryCenter";
    @NotNull
    private static final String FIELD_COORDINATES = "coordinates";
    @NotNull
    private static final String TYPE_CIRCLE = "circle";
    @NotNull
    private static final String TYPE_POLYGON = "polygon";
    @NotNull
    private static final String TYPE_ISOCHRONE = "isochrone";
    @NotNull
    private static final String TYPE_GEOMETRY_CIRCLE = "Circle";
    @NotNull
    private static final String TYPE_GEOMETRY_POLYGON = "Polygon";

    public RadarGeofence(@NotNull String _id, @NotNull String description, @Nullable String tag, @Nullable String externalId, @Nullable JSONObject metadata, @Nullable RadarGeofenceGeometry geometry) {
        Intrinsics.checkNotNullParameter((Object)_id, (String)FIELD_ID);
        Intrinsics.checkNotNullParameter((Object)description, (String)FIELD_DESCRIPTION);
        this._id = _id;
        this.description = description;
        this.tag = tag;
        this.externalId = externalId;
        this.metadata = metadata;
        this.geometry = geometry;
    }

    @NotNull
    public final String get_id() {
        return this._id;
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    @Nullable
    public final String getTag() {
        return this.tag;
    }

    @Nullable
    public final String getExternalId() {
        return this.externalId;
    }

    @Nullable
    public final JSONObject getMetadata() {
        return this.metadata;
    }

    @Nullable
    public final RadarGeofenceGeometry getGeometry() {
        return this.geometry;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final JSONObject toJson() {
        JSONObject jSONObject;
        JSONObject obj = new JSONObject();
        obj.putOpt(FIELD_ID, (Object)this._id);
        obj.putOpt(FIELD_TAG, (Object)this.tag);
        obj.putOpt(FIELD_EXTERNAL_ID, (Object)this.externalId);
        obj.putOpt(FIELD_DESCRIPTION, (Object)this.description);
        obj.putOpt(FIELD_METADATA, (Object)this.metadata);
        RadarGeofenceGeometry radarGeofenceGeometry = this.geometry;
        if (radarGeofenceGeometry == null) return obj;
        RadarGeofenceGeometry geometry = radarGeofenceGeometry;
        boolean bl = false;
        RadarGeofenceGeometry radarGeofenceGeometry2 = geometry;
        if (radarGeofenceGeometry2 instanceof RadarCircleGeometry) {
            obj.putOpt(FIELD_GEOMETRY_CENTER, (Object)((RadarCircleGeometry)geometry).getCenter().toJson());
            obj.putOpt(FIELD_GEOMETRY_RADIUS, (Object)((RadarCircleGeometry)geometry).getRadius());
            jSONObject = obj.putOpt(FIELD_TYPE, (Object)TYPE_GEOMETRY_CIRCLE);
            return obj;
        } else {
            if (!(radarGeofenceGeometry2 instanceof RadarPolygonGeometry)) throw new NoWhenBranchMatchedException();
            obj.putOpt(FIELD_GEOMETRY_CENTER, (Object)((RadarPolygonGeometry)geometry).getCenter().toJson());
            obj.putOpt(FIELD_GEOMETRY_RADIUS, (Object)((RadarPolygonGeometry)geometry).getRadius());
            if (((RadarPolygonGeometry)geometry).getCoordinates() != null) {
                JSONArray geometryCoordinates = new JSONArray();
                geometryCoordinates.put((Object)RadarGeofence.Companion.toJson(((RadarPolygonGeometry)geometry).getCoordinates()));
                obj.putOpt(FIELD_COORDINATES, (Object)geometryCoordinates);
            }
            jSONObject = obj.putOpt(FIELD_TYPE, (Object)TYPE_GEOMETRY_POLYGON);
        }
        return obj;
    }

    @JvmStatic
    @Nullable
    public static final RadarGeofence fromJson(@Nullable JSONObject obj) {
        return Companion.fromJson(obj);
    }

    @JvmStatic
    @Nullable
    public static final RadarGeofence[] fromJson(@Nullable JSONArray arr) {
        return Companion.fromJson(arr);
    }

    @JvmStatic
    @Nullable
    public static final JSONArray toJson(@Nullable RadarGeofence[] geofences) {
        return Companion.toJson(geofences);
    }

    @JvmStatic
    private static final JSONArray toJson(RadarCoordinate[] coordinates) {
        return RadarGeofence.Companion.toJson(coordinates);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0007\u00a2\u0006\u0002\u0010\u0018J\u0014\u0010\u0013\u001a\u0004\u0018\u00010\u00152\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0007J\u001f\u0010\u001b\u001a\u0004\u0018\u00010\u00172\u000e\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u0014H\u0003\u00a2\u0006\u0002\u0010\u001eJ\u001f\u0010\u001b\u001a\u0004\u0018\u00010\u00172\u000e\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0014H\u0007\u00a2\u0006\u0002\u0010 R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lio/radar/sdk/model/RadarGeofence$Companion;", "", "()V", "FIELD_COORDINATES", "", "FIELD_DESCRIPTION", "FIELD_EXTERNAL_ID", "FIELD_GEOMETRY", "FIELD_GEOMETRY_CENTER", "FIELD_GEOMETRY_RADIUS", "FIELD_ID", "FIELD_METADATA", "FIELD_TAG", "FIELD_TYPE", "TYPE_CIRCLE", "TYPE_GEOMETRY_CIRCLE", "TYPE_GEOMETRY_POLYGON", "TYPE_ISOCHRONE", "TYPE_POLYGON", "fromJson", "", "Lio/radar/sdk/model/RadarGeofence;", "arr", "Lorg/json/JSONArray;", "(Lorg/json/JSONArray;)[Lio/radar/sdk/model/RadarGeofence;", "obj", "Lorg/json/JSONObject;", "toJson", "coordinates", "Lio/radar/sdk/model/RadarCoordinate;", "([Lio/radar/sdk/model/RadarCoordinate;)Lorg/json/JSONArray;", "geofences", "([Lio/radar/sdk/model/RadarGeofence;)Lorg/json/JSONArray;", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @JvmStatic
        @Nullable
        public final RadarGeofence fromJson(@Nullable JSONObject obj) {
            block22: {
                block21: {
                    if (obj == null) {
                        return null;
                    }
                    v0 = obj.optString("_id");
                    if (v0 == null) {
                        v0 = id = "";
                    }
                    if ((v1 = obj.optString("description")) == null) {
                        v1 = description = "";
                    }
                    if ((v2 = obj.optString("tag")) == null) {
                        v2 = tag = null;
                    }
                    if ((v3 = obj.optString("externalId")) == null) {
                        v3 = externalId = null;
                    }
                    if ((v4 = obj.optJSONObject("metadata")) == null) {
                        v4 = metadata = null;
                    }
                    if ((v5 = obj.optJSONObject("geometryCenter")) != null && (v5 = v5.optJSONArray("coordinates")) != null) {
                        coordinate = v5;
                        $i$a$-let-RadarGeofence$Companion$fromJson$center$1 = false;
                        v6 = new RadarCoordinate(coordinate.optDouble(1), coordinate.optDouble(0));
                    } else {
                        v6 = new RadarCoordinate(0.0, 0.0);
                    }
                    center = v6;
                    radius = obj.optDouble("geometryRadius");
                    var11_7 = obj.optString("type");
                    if (var11_7 == null) break block21;
                    switch (var11_7.hashCode()) {
                        case -397519558: {
                            if (var11_7.equals("polygon")) break;
                            ** break;
                        }
                        case 418067294: {
                            if (var11_7.equals("isochrone")) break;
                            ** break;
                        }
                        case -1360216880: {
                            if (!var11_7.equals("circle")) ** break;
                            v7 = new RadarCircleGeometry(center, radius);
                            break block22;
                        }
                    }
                    v8 = geometryObj = obj.optJSONObject("geometry");
                    v9 /* !! */  = coordinatesArr = v8 != null ? v8.optJSONArray("coordinates") : null;
                    if (coordinatesArr != null) {
                        v10 = coordinatesArr.optJSONArray(0);
                        if (v10 != null) {
                            coordinates = v10;
                            $i$a$-let-RadarGeofence$Companion$fromJson$geometry$1 = false;
                            var17_16 = coordinates.length();
                            var18_17 = new RadarCoordinate[var17_16];
                            for (var16_15 = 0; var16_15 < var17_16; ++var16_15) {
                                var19_18 = var16_15;
                                v11 = var18_17;
                                v12 = var19_18;
                                v13 = var20_19 = coordinates.optJSONArray(var19_18);
                                if (v13 != null) {
                                    Intrinsics.checkNotNullExpressionValue((Object)v13, (String)"optJSONArray(index)");
                                    var21_20 = var20_19;
                                    var22_21 = v12;
                                    var23_22 = v11;
                                    $i$a$-let-RadarGeofence$Companion$fromJson$geometry$1$polygonCoordinatesArr$1$1 = false;
                                    var25_24 = new RadarCoordinate(coordinate.optDouble(1), coordinate.optDouble(0));
                                    v11 = var23_22;
                                    v12 = var22_21;
                                    v14 = var25_24;
                                } else {
                                    v14 = new RadarCoordinate(0.0, 0.0);
                                }
                                v11[v12] = v14;
                            }
                            polygonCoordinatesArr = var18_17;
                            v15 = new RadarPolygonGeometry(polygonCoordinatesArr, center, radius);
                        } else {
                            v15 = null;
                        }
                    } else {
                        v15 = new RadarPolygonGeometry(null, center, radius);
                    }
                    v7 = v15;
                    break block22;
                }
                v7 = v16 = null;
            }
            if (v7 == null) {
                v16 = new RadarCircleGeometry(new RadarCoordinate(0.0, 0.0), 0.0);
            }
            geometry = v16;
            return new RadarGeofence(id, description, tag, externalId, metadata, geometry);
        }

        @JvmStatic
        @Nullable
        public final RadarGeofence[] fromJson(@Nullable JSONArray arr) {
            if (arr == null) {
                return null;
            }
            int n = 0;
            int n2 = arr.length();
            Object[] objectArray = new RadarGeofence[n2];
            while (n < n2) {
                int n3 = n++;
                objectArray[n3] = Companion.fromJson(arr.optJSONObject(n3));
            }
            Collection $this$toTypedArray$iv = ArraysKt.filterNotNull((Object[])objectArray);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            RadarGeofence[] radarGeofenceArray = thisCollection$iv.toArray(new RadarGeofence[0]);
            if (radarGeofenceArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            return radarGeofenceArray;
        }

        @JvmStatic
        @Nullable
        public final JSONArray toJson(@Nullable RadarGeofence[] geofences) {
            if (geofences == null) {
                return null;
            }
            JSONArray arr = new JSONArray();
            RadarGeofence[] $this$forEach$iv = geofences;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                RadarGeofence element$iv;
                RadarGeofence geofence = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                arr.put((Object)geofence.toJson());
            }
            return arr;
        }

        @JvmStatic
        private final JSONArray toJson(RadarCoordinate[] coordinates) {
            if (coordinates == null) {
                return null;
            }
            JSONArray arr = new JSONArray();
            RadarCoordinate[] $this$forEach$iv = coordinates;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                RadarCoordinate element$iv;
                RadarCoordinate coordinate = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                JSONArray coordinateArr = new JSONArray();
                coordinateArr.put(coordinate.getLongitude());
                coordinateArr.put(coordinate.getLatitude());
                arr.put((Object)coordinateArr);
            }
            return arr;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

