/*
 * Decompiled with CFR 0.152.
 */
package io.radar.sdk;

import android.content.Context;
import android.location.Location;
import android.os.Build;
import android.os.SystemClock;
import io.radar.sdk.Radar;
import io.radar.sdk.RadarApiHelper;
import io.radar.sdk.RadarLogger;
import io.radar.sdk.RadarSettings;
import io.radar.sdk.RadarState;
import io.radar.sdk.RadarTrackingOptions;
import io.radar.sdk.RadarTripOptions;
import io.radar.sdk.RadarUtils;
import io.radar.sdk.model.RadarAddress;
import io.radar.sdk.model.RadarBeacon;
import io.radar.sdk.model.RadarConfig;
import io.radar.sdk.model.RadarContext;
import io.radar.sdk.model.RadarEvent;
import io.radar.sdk.model.RadarGeofence;
import io.radar.sdk.model.RadarLog;
import io.radar.sdk.model.RadarPlace;
import io.radar.sdk.model.RadarRegion;
import io.radar.sdk.model.RadarReplay;
import io.radar.sdk.model.RadarRouteMatrix;
import io.radar.sdk.model.RadarRoutes;
import io.radar.sdk.model.RadarTrip;
import io.radar.sdk.model.RadarUser;
import io.radar.sdk.model.RadarVerifiedLocationToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008e\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0012\b\u0000\u0018\u00002\u00020\u0001:\u001e\u008d\u0001\u008e\u0001\u008f\u0001\u0090\u0001\u0091\u0001\u0092\u0001\u0093\u0001\u0094\u0001\u0095\u0001\u0096\u0001\u0097\u0001\u0098\u0001\u0099\u0001\u009a\u0001\u009b\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJa\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0010\b\u0002\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00162\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0000\u00a2\u0006\u0004\b\u001c\u0010\u001dJ!\u0010\u001e\u001a\u00020\u000e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010\u001a\u001a\u0004\u0018\u00010!H\u0000\u00a2\u0006\u0002\b\"JC\u0010#\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0010\b\u0002\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u00142\u0010\b\u0002\u0010$\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u00142\u0006\u0010\u001a\u001a\u00020\u001bH\u0000\u00a2\u0006\u0004\b%\u0010&J/\u0010'\u001a\u00020\u000e2\n\b\u0002\u0010(\u001a\u0004\u0018\u00010\u00102\b\b\u0002\u0010)\u001a\u00020\u00192\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010*H\u0000\u00a2\u0006\u0002\b+J\u001d\u0010,\u001a\u00020\u000e2\u0006\u0010-\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020.H\u0000\u00a2\u0006\u0002\b/JC\u00100\u001a\u00020\u000e2\u0006\u00101\u001a\u00020\u00122\u0006\u00102\u001a\u00020\u00122\f\u00103\u001a\b\u0012\u0004\u0012\u000205042\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u000209H\u0000\u00a2\u0006\u0002\b:JC\u0010;\u001a\u00020\u000e2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00120\u00142\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00120\u00142\u0006\u0010>\u001a\u0002052\u0006\u00106\u001a\u0002072\u0006\u0010\u001a\u001a\u00020?H\u0000\u00a2\u0006\u0004\b@\u0010AJ\u001c\u0010B\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100C2\u0006\u0010D\u001a\u00020\u0010H\u0002J\u0015\u0010E\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020FH\u0000\u00a2\u0006\u0002\bGJ%\u0010H\u001a\u00020\u000e2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020K0J2\b\u0010\u001a\u001a\u0004\u0018\u00010LH\u0000\u00a2\u0006\u0002\bMJ%\u0010N\u001a\u00020\u000e2\f\u0010O\u001a\b\u0012\u0004\u0012\u00020P0J2\b\u0010\u001a\u001a\u0004\u0018\u00010QH\u0000\u00a2\u0006\u0002\bRJ1\u0010S\u001a\u00020\u000e2\u0006\u0010-\u001a\u00020\u00122\u0010\b\u0002\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u00142\u0006\u0010\u001a\u001a\u00020\u001bH\u0000\u00a2\u0006\u0004\bT\u0010UJ9\u0010V\u001a\u00020\u000e2\u0006\u0010-\u001a\u00020\u00122\u0006\u0010W\u001a\u00020\u00162\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001a\u001a\u00020X2\u0006\u0010Y\u001a\u00020\u0019H\u0000\u00a2\u0006\u0004\bZ\u0010[JW\u0010\\\u001a\u00020\u000e2\u0006\u0010-\u001a\u00020\u00122\b\u0010W\u001a\u0004\u0018\u00010\u00162\u000e\u0010]\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u00142\b\u0010^\u001a\u0004\u0018\u00010_2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010`\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020aH\u0000\u00a2\u0006\u0004\bb\u0010cJw\u0010d\u001a\u00020\u000e2\u0006\u0010-\u001a\u00020\u00122\u0006\u0010W\u001a\u00020\u00162\u000e\u0010e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u00142\u0014\u0010f\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0010\u0018\u00010C2\u000e\u0010g\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u00142\u000e\u0010h\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001a\u001a\u00020iH\u0000\u00a2\u0006\u0004\bj\u0010kJ'\u0010l\u001a\u00020\u000e2\u0006\u0010m\u001a\u00020\u00102\b\u0010^\u001a\u0004\u0018\u00010_2\u0006\u0010\u001a\u001a\u00020nH\u0000\u00a2\u0006\u0002\boJ\u0081\u0001\u0010p\u001a\u00020\u000e2\u0006\u0010-\u001a\u00020\u00122\u0006\u0010q\u001a\u00020\u00192\u0006\u0010r\u001a\u00020\u00192\u0006\u0010s\u001a\u00020t2\u0006\u0010u\u001a\u00020\u00192\u000e\u0010v\u001a\n\u0012\u0004\u0012\u00020w\u0018\u00010\u00142\b\b\u0002\u0010)\u001a\u00020\u00192\n\b\u0002\u0010x\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010y\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010z\u001a\u0004\u0018\u00010\u00192\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010{H\u0000\u00a2\u0006\u0004\b|\u0010}J-\u0010~\u001a\u00020\u000e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\t\u0010\u007f\u001a\u0005\u0018\u00010\u0080\u00012\b\u0010\u001a\u001a\u0004\u0018\u00010!H\u0000\u00a2\u0006\u0003\b\u0081\u0001J\"\u0010\u0082\u0001\u001a\u00020\u000e2\b\u0010\u0083\u0001\u001a\u00030\u0084\u00012\u0007\u0010\u001a\u001a\u00030\u0085\u0001H\u0000\u00a2\u0006\u0003\b\u0086\u0001J/\u0010\u0087\u0001\u001a\u00020\u000e2\u0007\u0010\u0088\u0001\u001a\u00020\u00102\b\u0010\u0089\u0001\u001a\u00030\u008a\u00012\u000b\b\u0002\u0010\u008b\u0001\u001a\u0004\u0018\u00010\u0010H\u0000\u00a2\u0006\u0003\b\u008c\u0001R\u001a\u0010\u0006\u001a\u00020\u0007X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u009c\u0001"}, d2={"Lio/radar/sdk/RadarApiClient;", "", "context", "Landroid/content/Context;", "logger", "Lio/radar/sdk/RadarLogger;", "apiHelper", "Lio/radar/sdk/RadarApiHelper;", "(Landroid/content/Context;Lio/radar/sdk/RadarLogger;Lio/radar/sdk/RadarApiHelper;)V", "getApiHelper$sdk_release", "()Lio/radar/sdk/RadarApiHelper;", "setApiHelper$sdk_release", "(Lio/radar/sdk/RadarApiHelper;)V", "autocomplete", "", "query", "", "near", "Landroid/location/Location;", "layers", "", "limit", "", "country", "mailable", "", "callback", "Lio/radar/sdk/RadarApiClient$RadarGeocodeApiCallback;", "autocomplete$sdk_release", "(Ljava/lang/String;Landroid/location/Location;[Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/Boolean;Lio/radar/sdk/RadarApiClient$RadarGeocodeApiCallback;)V", "createTrip", "options", "Lio/radar/sdk/RadarTripOptions;", "Lio/radar/sdk/RadarApiClient$RadarTripApiCallback;", "createTrip$sdk_release", "geocode", "countries", "geocode$sdk_release", "(Ljava/lang/String;[Ljava/lang/String;[Ljava/lang/String;Lio/radar/sdk/RadarApiClient$RadarGeocodeApiCallback;)V", "getConfig", "usage", "verified", "Lio/radar/sdk/RadarApiClient$RadarGetConfigApiCallback;", "getConfig$sdk_release", "getContext", "location", "Lio/radar/sdk/RadarApiClient$RadarContextApiCallback;", "getContext$sdk_release", "getDistance", "origin", "destination", "modes", "Ljava/util/EnumSet;", "Lio/radar/sdk/Radar$RadarRouteMode;", "units", "Lio/radar/sdk/Radar$RadarRouteUnits;", "geometryPoints", "Lio/radar/sdk/RadarApiClient$RadarDistanceApiCallback;", "getDistance$sdk_release", "getMatrix", "origins", "destinations", "mode", "Lio/radar/sdk/RadarApiClient$RadarMatrixApiCallback;", "getMatrix$sdk_release", "([Landroid/location/Location;[Landroid/location/Location;Lio/radar/sdk/Radar$RadarRouteMode;Lio/radar/sdk/Radar$RadarRouteUnits;Lio/radar/sdk/RadarApiClient$RadarMatrixApiCallback;)V", "headers", "", "publishableKey", "ipGeocode", "Lio/radar/sdk/RadarApiClient$RadarIpGeocodeApiCallback;", "ipGeocode$sdk_release", "log", "logs", "", "Lio/radar/sdk/model/RadarLog;", "Lio/radar/sdk/RadarApiClient$RadarLogCallback;", "log$sdk_release", "replay", "replays", "Lio/radar/sdk/model/RadarReplay;", "Lio/radar/sdk/RadarApiClient$RadarReplayApiCallback;", "replay$sdk_release", "reverseGeocode", "reverseGeocode$sdk_release", "(Landroid/location/Location;[Ljava/lang/String;Lio/radar/sdk/RadarApiClient$RadarGeocodeApiCallback;)V", "searchBeacons", "radius", "Lio/radar/sdk/RadarApiClient$RadarSearchBeaconsApiCallback;", "cache", "searchBeacons$sdk_release", "(Landroid/location/Location;ILjava/lang/Integer;Lio/radar/sdk/RadarApiClient$RadarSearchBeaconsApiCallback;Z)V", "searchGeofences", "tags", "metadata", "Lorg/json/JSONObject;", "includeGeometry", "Lio/radar/sdk/RadarApiClient$RadarSearchGeofencesApiCallback;", "searchGeofences$sdk_release", "(Landroid/location/Location;Ljava/lang/Integer;[Ljava/lang/String;Lorg/json/JSONObject;Ljava/lang/Integer;Ljava/lang/Boolean;Lio/radar/sdk/RadarApiClient$RadarSearchGeofencesApiCallback;)V", "searchPlaces", "chains", "chainMetadata", "categories", "groups", "Lio/radar/sdk/RadarApiClient$RadarSearchPlacesApiCallback;", "searchPlaces$sdk_release", "(Landroid/location/Location;I[Ljava/lang/String;Ljava/util/Map;[Ljava/lang/String;[Ljava/lang/String;Ljava/lang/Integer;Lio/radar/sdk/RadarApiClient$RadarSearchPlacesApiCallback;)V", "sendEvent", "name", "Lio/radar/sdk/RadarApiClient$RadarSendEventApiCallback;", "sendEvent$sdk_release", "track", "stopped", "foreground", "source", "Lio/radar/sdk/Radar$RadarLocationSource;", "replayed", "beacons", "Lio/radar/sdk/model/RadarBeacon;", "integrityToken", "integrityException", "encrypted", "Lio/radar/sdk/RadarApiClient$RadarTrackApiCallback;", "track$sdk_release", "(Landroid/location/Location;ZZLio/radar/sdk/Radar$RadarLocationSource;Z[Lio/radar/sdk/model/RadarBeacon;ZLjava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;Lio/radar/sdk/RadarApiClient$RadarTrackApiCallback;)V", "updateTrip", "status", "Lio/radar/sdk/model/RadarTrip$RadarTripStatus;", "updateTrip$sdk_release", "validateAddress", "address", "Lio/radar/sdk/model/RadarAddress;", "Lio/radar/sdk/RadarApiClient$RadarValidateAddressAPICallback;", "validateAddress$sdk_release", "verifyEvent", "eventId", "verification", "Lio/radar/sdk/model/RadarEvent$RadarEventVerification;", "verifiedPlaceId", "verifyEvent$sdk_release", "RadarContextApiCallback", "RadarDistanceApiCallback", "RadarGeocodeApiCallback", "RadarGetConfigApiCallback", "RadarIpGeocodeApiCallback", "RadarLogCallback", "RadarMatrixApiCallback", "RadarReplayApiCallback", "RadarSearchBeaconsApiCallback", "RadarSearchGeofencesApiCallback", "RadarSearchPlacesApiCallback", "RadarSendEventApiCallback", "RadarTrackApiCallback", "RadarTripApiCallback", "RadarValidateAddressAPICallback", "sdk_release"})
public final class RadarApiClient {
    @NotNull
    private final Context context;
    @NotNull
    private RadarLogger logger;
    @NotNull
    private RadarApiHelper apiHelper;

    public RadarApiClient(@NotNull Context context, @NotNull RadarLogger logger, @NotNull RadarApiHelper apiHelper) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)apiHelper, (String)"apiHelper");
        this.context = context;
        this.logger = logger;
        this.apiHelper = apiHelper;
    }

    public /* synthetic */ RadarApiClient(Context context, RadarLogger radarLogger, RadarApiHelper radarApiHelper, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            radarApiHelper = new RadarApiHelper(radarLogger);
        }
        this(context, radarLogger, radarApiHelper);
    }

    @NotNull
    public final RadarApiHelper getApiHelper$sdk_release() {
        return this.apiHelper;
    }

    public final void setApiHelper$sdk_release(@NotNull RadarApiHelper radarApiHelper) {
        Intrinsics.checkNotNullParameter((Object)radarApiHelper, (String)"<set-?>");
        this.apiHelper = radarApiHelper;
    }

    private final Map<String, String> headers(String publishableKey) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"Authorization", (Object)publishableKey), TuplesKt.to((Object)"Content-Type", (Object)"application/json"), TuplesKt.to((Object)"X-Radar-Config", (Object)"true"), TuplesKt.to((Object)"X-Radar-Device-Make", (Object)RadarUtils.INSTANCE.getDeviceMake$sdk_release()), TuplesKt.to((Object)"X-Radar-Device-Model", (Object)RadarUtils.INSTANCE.getDeviceModel$sdk_release()), TuplesKt.to((Object)"X-Radar-Device-OS", (Object)RadarUtils.INSTANCE.getDeviceOS$sdk_release()), TuplesKt.to((Object)"X-Radar-Device-Type", (Object)"Android"), TuplesKt.to((Object)"X-Radar-SDK-Version", (Object)"3.13.1"), TuplesKt.to((Object)"X-Radar-Mobile-Origin", (Object)this.context.getPackageName())};
        Map headers = MapsKt.mutableMapOf((Pair[])pairArray);
        if (RadarSettings.INSTANCE.isXPlatform$sdk_release(this.context)) {
            headers.put("X-Radar-X-Platform-SDK-Type", RadarSettings.INSTANCE.getXPlatformSDKType$sdk_release(this.context));
            headers.put("X-Radar-X-Platform-SDK-Version", RadarSettings.INSTANCE.getXPlatformSDKVersion$sdk_release(this.context));
        } else {
            headers.put("X-Radar-X-Platform-SDK-Type", "Native");
        }
        return headers;
    }

    public final void getConfig$sdk_release(@Nullable String usage, boolean verified, @Nullable RadarGetConfigApiCallback callback) {
        String string = RadarSettings.INSTANCE.getPublishableKey$sdk_release(this.context);
        if (string == null) {
            return;
        }
        String publishableKey = string;
        StringBuilder queryParams = new StringBuilder();
        queryParams.append("installId=" + RadarSettings.INSTANCE.getInstallId$sdk_release(this.context));
        queryParams.append("&sessionId=" + RadarSettings.INSTANCE.getSessionId$sdk_release(this.context));
        String id = RadarSettings.INSTANCE.getId$sdk_release(this.context);
        if (id != null) {
            queryParams.append("&id=" + id);
        }
        queryParams.append("&locationAuthorization=" + RadarUtils.INSTANCE.getLocationAuthorization$sdk_release(this.context));
        queryParams.append("&locationAccuracyAuthorization=" + RadarUtils.INSTANCE.getLocationAccuracyAuthorization$sdk_release(this.context));
        queryParams.append("&verified=" + verified);
        if (usage != null) {
            queryParams.append("&usage=" + usage);
        }
        String path = "v1/config?" + queryParams;
        Map<String, String> headers = this.headers(publishableKey);
        RadarApiHelper.request$sdk_release$default(this.apiHelper, this.context, "GET", path, headers, null, false, new RadarApiHelper.RadarApiCallback(callback){
            final /* synthetic */ RadarGetConfigApiCallback $callback;
            {
                this.$callback = $callback;
            }

            public void onComplete(@NotNull Radar.RadarStatus status, @Nullable JSONObject res) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
                    if (status == Radar.RadarStatus.SUCCESS) {
                        Radar.flushLogs$sdk_release();
                    }
                    RadarGetConfigApiCallback radarGetConfigApiCallback = this.$callback;
                    if (radarGetConfigApiCallback == null) break block1;
                    radarGetConfigApiCallback.onComplete(status, RadarConfig.Companion.fromJson(res));
                }
            }
        }, false, true, verified, false, 1024, null);
    }

    public static /* synthetic */ void getConfig$sdk_release$default(RadarApiClient radarApiClient, String string, boolean bl, RadarGetConfigApiCallback radarGetConfigApiCallback, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            radarGetConfigApiCallback = null;
        }
        radarApiClient.getConfig$sdk_release(string, bl, radarGetConfigApiCallback);
    }

    public final void log$sdk_release(@NotNull List<RadarLog> logs, @Nullable RadarLogCallback callback) {
        Intrinsics.checkNotNullParameter(logs, (String)"logs");
        String publishableKey = RadarSettings.INSTANCE.getPublishableKey$sdk_release(this.context);
        if (publishableKey == null) {
            RadarLogCallback radarLogCallback = callback;
            if (radarLogCallback != null) {
                RadarLogCallback.DefaultImpls.onComplete$default(radarLogCallback, Radar.RadarStatus.ERROR_PUBLISHABLE_KEY, null, 2, null);
            }
            return;
        }
        JSONObject params = new JSONObject();
        try {
            params.putOpt("id", (Object)RadarSettings.INSTANCE.getId$sdk_release(this.context));
            params.putOpt("deviceId", (Object)RadarUtils.INSTANCE.getDeviceId$sdk_release(this.context));
            params.putOpt("installId", (Object)RadarSettings.INSTANCE.getInstallId$sdk_release(this.context));
            params.putOpt("sessionId", (Object)RadarSettings.INSTANCE.getSessionId$sdk_release(this.context));
            JSONArray array = new JSONArray();
            Iterable $this$forEach$iv = logs;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RadarLog log2 = (RadarLog)element$iv;
                boolean bl = false;
                array.put((Object)log2.toJson());
            }
            params.putOpt("logs", (Object)array);
        }
        catch (JSONException e) {
            RadarLogCallback radarLogCallback = callback;
            if (radarLogCallback != null) {
                RadarLogCallback.DefaultImpls.onComplete$default(radarLogCallback, Radar.RadarStatus.ERROR_BAD_REQUEST, null, 2, null);
            }
            return;
        }
        String path = "v1/logs";
        RadarApiHelper.request$sdk_release$default(this.apiHelper, this.context, "POST", path, this.headers(publishableKey), params, false, new RadarApiHelper.RadarApiCallback(callback){
            final /* synthetic */ RadarLogCallback $callback;
            {
                this.$callback = $callback;
            }

            public void onComplete(@NotNull Radar.RadarStatus status, @Nullable JSONObject res) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
                    RadarLogCallback radarLogCallback = this.$callback;
                    if (radarLogCallback == null) break block0;
                    radarLogCallback.onComplete(status, res);
                }
            }
        }, false, true, false, false, 1024, null);
    }

    public final void replay$sdk_release(@NotNull List<RadarReplay> replays, @Nullable RadarReplayApiCallback callback) {
        Intrinsics.checkNotNullParameter(replays, (String)"replays");
        String publishableKey = RadarSettings.INSTANCE.getPublishableKey$sdk_release(this.context);
        if (publishableKey == null) {
            RadarReplayApiCallback radarReplayApiCallback = callback;
            if (radarReplayApiCallback != null) {
                RadarReplayApiCallback.DefaultImpls.onComplete$default(radarReplayApiCallback, Radar.RadarStatus.ERROR_PUBLISHABLE_KEY, null, 2, null);
            }
            return;
        }
        JSONObject params = new JSONObject();
        List replaysList = new ArrayList();
        for (RadarReplay replay2 : replays) {
            replaysList.add(replay2.getReplayParams());
        }
        params.putOpt("replays", (Object)new JSONArray((Collection)replaysList));
        String path = "v1/track/replay";
        RadarApiHelper.request$sdk_release$default(this.apiHelper, this.context, "POST", path, this.headers(publishableKey), params, false, new RadarApiHelper.RadarApiCallback(callback){
            final /* synthetic */ RadarReplayApiCallback $callback;
            {
                this.$callback = $callback;
            }

            public void onComplete(@NotNull Radar.RadarStatus status, @Nullable JSONObject res) {
                block6: {
                    RadarUser user;
                    RadarUser radarUser;
                    JSONObject jSONObject;
                    RadarEvent[] events;
                    RadarEvent[] radarEventArray;
                    JSONObject jSONObject2;
                    Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
                    if (status != Radar.RadarStatus.SUCCESS) {
                        Radar.INSTANCE.sendError$sdk_release(status);
                    }
                    if ((jSONObject2 = res) != null && (jSONObject2 = jSONObject2.optJSONArray("events")) != null) {
                        JSONObject eventsArr = jSONObject2;
                        boolean bl = false;
                        radarEventArray = RadarEvent.Companion.fromJson((JSONArray)eventsArr);
                    } else {
                        radarEventArray = events = null;
                    }
                    if ((jSONObject = res) != null && (jSONObject = jSONObject.optJSONObject("user")) != null) {
                        JSONObject userObj = jSONObject;
                        boolean bl = false;
                        radarUser = RadarUser.Companion.fromJson(userObj);
                    } else {
                        radarUser = user = null;
                    }
                    if (events != null && !(events.length == 0)) {
                        Radar.INSTANCE.sendEvents$sdk_release(events, user);
                    }
                    RadarReplayApiCallback radarReplayApiCallback = this.$callback;
                    if (radarReplayApiCallback == null) break block6;
                    radarReplayApiCallback.onComplete(status, res);
                }
            }
        }, true, false, false, false, 1024, null);
    }

    public final void track$sdk_release(@NotNull Location location, boolean stopped, boolean foreground, @NotNull Radar.RadarLocationSource source, boolean replayed, @Nullable RadarBeacon[] beacons, boolean verified, @Nullable String integrityToken, @Nullable String integrityException, @Nullable Boolean encrypted, @Nullable RadarTrackApiCallback callback) {
        boolean replaying;
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
        String publishableKey = RadarSettings.INSTANCE.getPublishableKey$sdk_release(this.context);
        if (publishableKey == null) {
            RadarTrackApiCallback radarTrackApiCallback = callback;
            if (radarTrackApiCallback != null) {
                RadarTrackApiCallback.DefaultImpls.onComplete$default(radarTrackApiCallback, Radar.RadarStatus.ERROR_PUBLISHABLE_KEY, null, null, null, null, null, null, 126, null);
            }
            return;
        }
        JSONObject params = new JSONObject();
        RadarTrackingOptions options = Radar.getTrackingOptions();
        RadarTripOptions tripOptions = RadarSettings.INSTANCE.getTripOptions$sdk_release(this.context);
        boolean anonymous = RadarSettings.INSTANCE.getAnonymousTrackingEnabled$sdk_release(this.context);
        try {
            params.putOpt("anonymous", (Object)anonymous);
            if (anonymous) {
                params.putOpt("deviceId", (Object)"anonymous");
                params.putOpt("geofenceIds", (Object)new JSONArray((Collection)RadarState.INSTANCE.getGeofenceIds$sdk_release(this.context)));
                params.putOpt("placeId", (Object)RadarState.INSTANCE.getPlaceId$sdk_release(this.context));
                params.putOpt("regionIds", (Object)new JSONArray((Collection)RadarState.INSTANCE.getRegionIds$sdk_release(this.context)));
                params.putOpt("beaconIds", (Object)new JSONArray((Collection)RadarState.INSTANCE.getBeaconIds$sdk_release(this.context)));
            } else {
                params.putOpt("id", (Object)RadarSettings.INSTANCE.getId$sdk_release(this.context));
                params.putOpt("installId", (Object)RadarSettings.INSTANCE.getInstallId$sdk_release(this.context));
                params.putOpt("userId", (Object)RadarSettings.INSTANCE.getUserId$sdk_release(this.context));
                params.putOpt("deviceId", (Object)RadarUtils.INSTANCE.getDeviceId$sdk_release(this.context));
                params.putOpt("description", (Object)RadarSettings.INSTANCE.getDescription$sdk_release(this.context));
                params.putOpt("metadata", (Object)RadarSettings.INSTANCE.getMetadata$sdk_release(this.context));
                params.putOpt("sessionId", (Object)RadarSettings.INSTANCE.getSessionId$sdk_release(this.context));
            }
            params.putOpt("latitude", (Object)location.getLatitude());
            params.putOpt("longitude", (Object)location.getLongitude());
            float accuracy = location.getAccuracy();
            if (!location.hasAccuracy() || Float.isNaN(location.getAccuracy()) || accuracy <= 0.0f) {
                accuracy = 1.0f;
            }
            params.putOpt("accuracy", (Object)Float.valueOf(accuracy));
            if (location.hasSpeed() && !Float.isNaN(location.getSpeed())) {
                params.putOpt("speed", (Object)Float.valueOf(location.getSpeed()));
            }
            if (location.hasBearing() && !Float.isNaN(location.getBearing())) {
                params.putOpt("course", (Object)Float.valueOf(location.getBearing()));
            }
            if (Build.VERSION.SDK_INT >= 26) {
                if (location.hasVerticalAccuracy() && !Float.isNaN(location.getVerticalAccuracyMeters())) {
                    params.putOpt("verticalAccuracy", (Object)Float.valueOf(location.getVerticalAccuracyMeters()));
                }
                if (location.hasSpeedAccuracy() && !Float.isNaN(location.getSpeedAccuracyMetersPerSecond())) {
                    params.putOpt("speedAccuracy", (Object)Float.valueOf(location.getSpeedAccuracyMetersPerSecond()));
                }
                if (location.hasBearingAccuracy() && !Float.isNaN(location.getBearingAccuracyDegrees())) {
                    params.putOpt("courseAccuracy", (Object)Float.valueOf(location.getBearingAccuracyDegrees()));
                }
            }
            if (!foreground && Build.VERSION.SDK_INT >= 17) {
                long updatedAtMsDiff = (SystemClock.elapsedRealtimeNanos() - location.getElapsedRealtimeNanos()) / (long)1000000;
                params.putOpt("updatedAtMsDiff", (Object)updatedAtMsDiff);
            }
            params.putOpt("foreground", (Object)foreground);
            params.putOpt("stopped", (Object)stopped);
            params.putOpt("replayed", (Object)replayed);
            params.putOpt("deviceType", (Object)"Android");
            params.putOpt("deviceMake", (Object)RadarUtils.INSTANCE.getDeviceMake$sdk_release());
            params.putOpt("sdkVersion", (Object)"3.13.1");
            params.putOpt("deviceModel", (Object)RadarUtils.INSTANCE.getDeviceModel$sdk_release());
            params.putOpt("deviceOS", (Object)RadarUtils.INSTANCE.getDeviceOS$sdk_release());
            params.putOpt("deviceType", (Object)"Android");
            params.putOpt("deviceMake", (Object)RadarUtils.INSTANCE.getDeviceMake$sdk_release());
            params.putOpt("country", (Object)RadarUtils.INSTANCE.getCountry$sdk_release());
            params.putOpt("timeZoneOffset", (Object)RadarUtils.INSTANCE.getTimeZoneOffset$sdk_release());
            params.putOpt("source", (Object)Radar.stringForSource(source));
            if (RadarSettings.INSTANCE.isXPlatform$sdk_release(this.context)) {
                params.putOpt("xPlatformType", (Object)RadarSettings.INSTANCE.getXPlatformSDKType$sdk_release(this.context));
                params.putOpt("xPlatformSDKVersion", (Object)RadarSettings.INSTANCE.getXPlatformSDKVersion$sdk_release(this.context));
            } else {
                params.putOpt("xPlatformType", (Object)"Native");
            }
            if (Build.VERSION.SDK_INT >= 18) {
                boolean mocked = location.isFromMockProvider();
                params.putOpt("mocked", (Object)mocked);
            }
            if (tripOptions != null) {
                JSONObject tripOptionsObj = new JSONObject();
                tripOptionsObj.putOpt("version", (Object)"2");
                tripOptionsObj.putOpt("externalId", (Object)tripOptions.getExternalId());
                tripOptionsObj.putOpt("metadata", (Object)tripOptions.getMetadata());
                tripOptionsObj.putOpt("destinationGeofenceTag", (Object)tripOptions.getDestinationGeofenceTag());
                tripOptionsObj.putOpt("destinationGeofenceExternalId", (Object)tripOptions.getDestinationGeofenceExternalId());
                tripOptionsObj.putOpt("mode", (Object)Radar.stringForMode(tripOptions.getMode()));
                params.putOpt("tripOptions", (Object)tripOptionsObj);
            }
            if (options.getSyncGeofences()) {
                params.putOpt("nearbyGeofences", (Object)true);
                params.putOpt("nearbyGeofencesLimit", (Object)options.getSyncGeofencesLimit());
            }
            if (beacons != null) {
                params.putOpt("beacons", (Object)RadarBeacon.Companion.toJson(beacons));
            }
            params.putOpt("locationAuthorization", (Object)RadarUtils.INSTANCE.getLocationAuthorization$sdk_release(this.context));
            params.putOpt("locationAccuracyAuthorization", (Object)RadarUtils.INSTANCE.getLocationAccuracyAuthorization$sdk_release(this.context));
            params.putOpt("trackingOptions", (Object)Radar.getTrackingOptions().toJson());
            boolean usingRemoteTrackingOptions = RadarSettings.INSTANCE.getTracking$sdk_release(this.context) && RadarSettings.INSTANCE.getRemoteTrackingOptions$sdk_release(this.context) != null;
            params.putOpt("usingRemoteTrackingOptions", (Object)usingRemoteTrackingOptions);
            params.putOpt("locationServicesProvider", (Object)RadarSettings.INSTANCE.getLocationServicesProvider$sdk_release(this.context));
            params.putOpt("verified", (Object)verified);
            if (verified) {
                params.putOpt("integrityToken", (Object)integrityToken);
                params.putOpt("integrityException", (Object)integrityException);
                params.putOpt("sharing", (Object)RadarUtils.INSTANCE.isScreenSharing$sdk_release(this.context));
                params.putOpt("encrypted", (Object)encrypted);
            }
            params.putOpt("appId", (Object)this.context.getPackageName());
        }
        catch (JSONException e) {
            RadarTrackApiCallback radarTrackApiCallback = callback;
            if (radarTrackApiCallback != null) {
                RadarTrackApiCallback.DefaultImpls.onComplete$default(radarTrackApiCallback, Radar.RadarStatus.ERROR_BAD_REQUEST, null, null, null, null, null, null, 126, null);
            }
            return;
        }
        String path = "v1/track";
        Map<String, String> headers = this.headers(publishableKey);
        if (anonymous) {
            String usage = "track";
            RadarApiClient.getConfig$sdk_release$default(this, usage, false, null, 6, null);
        }
        boolean hasReplays = Radar.hasReplays$sdk_release();
        JSONObject requestParams = params;
        long nowMS = System.currentTimeMillis();
        boolean bl = replaying = options.getReplay() == RadarTrackingOptions.RadarTrackingOptionsReplay.ALL && hasReplays && !verified;
        if (replaying) {
            Radar.flushReplays$sdk_release(params, new Radar.RadarTrackCallback(callback){
                final /* synthetic */ RadarTrackApiCallback $callback;
                {
                    this.$callback = $callback;
                }

                public void onComplete(@NotNull Radar.RadarStatus status, @Nullable Location location, @Nullable RadarEvent[] events, @Nullable RadarUser user) {
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
                        RadarTrackApiCallback radarTrackApiCallback = this.$callback;
                        if (radarTrackApiCallback == null) break block0;
                        RadarTrackApiCallback.DefaultImpls.onComplete$default(radarTrackApiCallback, status, null, null, null, null, null, null, 126, null);
                    }
                }
            });
            return;
        }
        this.apiHelper.request$sdk_release(this.context, "POST", path, headers, requestParams, true, new RadarApiHelper.RadarApiCallback(options, params, nowMS, stopped, source, this, location, callback){
            final /* synthetic */ RadarTrackingOptions $options;
            final /* synthetic */ JSONObject $params;
            final /* synthetic */ long $nowMS;
            final /* synthetic */ boolean $stopped;
            final /* synthetic */ Radar.RadarLocationSource $source;
            final /* synthetic */ RadarApiClient this$0;
            final /* synthetic */ Location $location;
            final /* synthetic */ RadarTrackApiCallback $callback;
            {
                this.$options = $options;
                this.$params = $params;
                this.$nowMS = $nowMS;
                this.$stopped = $stopped;
                this.$source = $source;
                this.this$0 = $receiver;
                this.$location = $location;
                this.$callback = $callback;
            }

            public void onComplete(@NotNull Radar.RadarStatus status, @Nullable JSONObject res) {
                block25: {
                    RadarGeofence[] radarGeofenceArray;
                    RadarUser radarUser;
                    RadarEvent[] radarEventArray;
                    Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
                    if (status != Radar.RadarStatus.SUCCESS || res == null) {
                        if (this.$options.getReplay() == RadarTrackingOptions.RadarTrackingOptionsReplay.ALL) {
                            this.$params.putOpt("replayed", (Object)true);
                            this.$params.putOpt("updatedAtMs", (Object)this.$nowMS);
                            this.$params.remove("updatedAtMsDiff");
                            Radar.addReplay$sdk_release(this.$params);
                        } else if (this.$options.getReplay() == RadarTrackingOptions.RadarTrackingOptionsReplay.STOPS && this.$stopped && this.$source != Radar.RadarLocationSource.FOREGROUND_LOCATION && this.$source != Radar.RadarLocationSource.BACKGROUND_LOCATION) {
                            RadarState.INSTANCE.setLastFailedStoppedLocation$sdk_release(RadarApiClient.access$getContext$p(this.this$0), this.$location);
                        }
                        Radar.INSTANCE.sendError$sdk_release(status);
                        RadarTrackApiCallback radarTrackApiCallback = this.$callback;
                        if (radarTrackApiCallback != null) {
                            RadarTrackApiCallback.DefaultImpls.onComplete$default(radarTrackApiCallback, status, null, null, null, null, null, null, 126, null);
                        }
                        return;
                    }
                    RadarState.INSTANCE.setLastFailedStoppedLocation$sdk_release(RadarApiClient.access$getContext$p(this.this$0), null);
                    Radar.flushLogs$sdk_release();
                    RadarSettings.INSTANCE.updateLastTrackedTime$sdk_release(RadarApiClient.access$getContext$p(this.this$0));
                    RadarConfig config = RadarConfig.Companion.fromJson(res);
                    JSONArray jSONArray = res.optJSONArray("events");
                    if (jSONArray != null) {
                        JSONArray eventsArr = jSONArray;
                        boolean bl = false;
                        radarEventArray = RadarEvent.Companion.fromJson(eventsArr);
                    } else {
                        radarEventArray = null;
                    }
                    RadarEvent[] events = radarEventArray;
                    JSONObject jSONObject = res.optJSONObject("user");
                    if (jSONObject != null) {
                        JSONObject userObj = jSONObject;
                        boolean bl = false;
                        radarUser = RadarUser.Companion.fromJson(userObj);
                    } else {
                        radarUser = null;
                    }
                    RadarUser user = radarUser;
                    JSONArray jSONArray2 = res.optJSONArray("nearbyGeofences");
                    if (jSONArray2 != null) {
                        JSONArray nearbyGeofencesArr = jSONArray2;
                        boolean bl = false;
                        radarGeofenceArray = RadarGeofence.Companion.fromJson(nearbyGeofencesArr);
                    } else {
                        radarGeofenceArray = null;
                    }
                    RadarGeofence[] nearbyGeofences = radarGeofenceArray;
                    RadarVerifiedLocationToken token = RadarVerifiedLocationToken.Companion.fromJson(res);
                    if (user != null) {
                        boolean inGeofences = user.getGeofences() != null && !(user.getGeofences().length == 0);
                        boolean atPlace = user.getPlace() != null;
                        boolean canExit = inGeofences || atPlace;
                        RadarState.INSTANCE.setCanExit$sdk_release(RadarApiClient.access$getContext$p(this.this$0), canExit);
                        Set geofenceIds = new LinkedHashSet<E>();
                        RadarGeofence[] radarGeofenceArray2 = user.getGeofences();
                        if (radarGeofenceArray2 != null) {
                            RadarGeofence[] $this$forEach$iv = radarGeofenceArray2;
                            boolean $i$f$forEach = false;
                            int n = $this$forEach$iv.length;
                            for (int i = 0; i < n; ++i) {
                                RadarGeofence element$iv;
                                RadarGeofence geofence = element$iv = $this$forEach$iv[i];
                                boolean bl = false;
                                geofenceIds.add(geofence.get_id());
                            }
                        }
                        RadarState.INSTANCE.setGeofenceIds$sdk_release(RadarApiClient.access$getContext$p(this.this$0), geofenceIds);
                        RadarPlace radarPlace = user.getPlace();
                        String placeId = radarPlace != null ? radarPlace.get_id() : null;
                        RadarState.INSTANCE.setPlaceId$sdk_release(RadarApiClient.access$getContext$p(this.this$0), placeId);
                        Set regionIds = new LinkedHashSet<E>();
                        RadarRegion radarRegion = user.getCountry();
                        if (radarRegion != null) {
                            RadarRegion country = radarRegion;
                            boolean bl = false;
                            regionIds.add(country.get_id());
                        }
                        RadarRegion radarRegion2 = user.getState();
                        if (radarRegion2 != null) {
                            RadarRegion state = radarRegion2;
                            boolean bl = false;
                            regionIds.add(state.get_id());
                        }
                        RadarRegion radarRegion3 = user.getDma();
                        if (radarRegion3 != null) {
                            RadarRegion dma = radarRegion3;
                            boolean bl = false;
                            regionIds.add(dma.get_id());
                        }
                        RadarRegion radarRegion4 = user.getPostalCode();
                        if (radarRegion4 != null) {
                            RadarRegion postalCode = radarRegion4;
                            boolean bl = false;
                            regionIds.add(postalCode.get_id());
                        }
                        RadarState.INSTANCE.setRegionIds$sdk_release(RadarApiClient.access$getContext$p(this.this$0), regionIds);
                        Set beaconIds = new LinkedHashSet<E>();
                        RadarBeacon[] radarBeaconArray = user.getBeacons();
                        if (radarBeaconArray != null) {
                            RadarBeacon[] $this$forEach$iv = radarBeaconArray;
                            boolean $i$f$forEach = false;
                            int n = $this$forEach$iv.length;
                            for (int i = 0; i < n; ++i) {
                                String _id;
                                RadarBeacon element$iv;
                                RadarBeacon beacon = element$iv = $this$forEach$iv[i];
                                boolean bl = false;
                                if (beacon.get_id() == null) continue;
                                boolean bl2 = false;
                                beaconIds.add(_id);
                            }
                        }
                        RadarState.INSTANCE.setBeaconIds$sdk_release(RadarApiClient.access$getContext$p(this.this$0), beaconIds);
                    }
                    if (events != null && user != null) {
                        RadarTripOptions tripOptions;
                        RadarSettings.INSTANCE.setId$sdk_release(RadarApiClient.access$getContext$p(this.this$0), user.get_id());
                        if (user.getTrip() == null && (tripOptions = RadarSettings.INSTANCE.getTripOptions$sdk_release(RadarApiClient.access$getContext$p(this.this$0))) != null) {
                            Radar.INSTANCE.getLocationManager$sdk_release().restartPreviousTrackingOptions$sdk_release();
                            RadarSettings.INSTANCE.setTripOptions$sdk_release(RadarApiClient.access$getContext$p(this.this$0), null);
                        }
                        RadarSettings.INSTANCE.setUserDebug$sdk_release(RadarApiClient.access$getContext$p(this.this$0), user.getDebug());
                        Radar.INSTANCE.sendLocation$sdk_release(this.$location, user);
                        if (!(events.length == 0)) {
                            Radar.INSTANCE.sendEvents$sdk_release(events, user);
                        }
                        if (token != null) {
                            Radar.INSTANCE.sendToken$sdk_release(token);
                        }
                        RadarTrackApiCallback radarTrackApiCallback = this.$callback;
                        if (radarTrackApiCallback != null) {
                            radarTrackApiCallback.onComplete(Radar.RadarStatus.SUCCESS, res, events, user, nearbyGeofences, config, token);
                        }
                        return;
                    }
                    Radar.INSTANCE.sendError$sdk_release(status);
                    RadarTrackApiCallback radarTrackApiCallback = this.$callback;
                    if (radarTrackApiCallback == null) break block25;
                    RadarTrackApiCallback.DefaultImpls.onComplete$default(radarTrackApiCallback, Radar.RadarStatus.ERROR_SERVER, null, null, null, null, null, null, 126, null);
                }
            }
        }, replaying, false, !replaying, verified);
    }

    public static /* synthetic */ void track$sdk_release$default(RadarApiClient radarApiClient, Location location, boolean bl, boolean bl2, Radar.RadarLocationSource radarLocationSource, boolean bl3, RadarBeacon[] radarBeaconArray, boolean bl4, String string, String string2, Boolean bl5, RadarTrackApiCallback radarTrackApiCallback, int n, Object object) {
        if ((n & 0x40) != 0) {
            bl4 = false;
        }
        if ((n & 0x80) != 0) {
            string = null;
        }
        if ((n & 0x100) != 0) {
            string2 = null;
        }
        if ((n & 0x200) != 0) {
            bl5 = false;
        }
        if ((n & 0x400) != 0) {
            radarTrackApiCallback = null;
        }
        radarApiClient.track$sdk_release(location, bl, bl2, radarLocationSource, bl3, radarBeaconArray, bl4, string, string2, bl5, radarTrackApiCallback);
    }

    public final void verifyEvent$sdk_release(@NotNull String eventId, @NotNull RadarEvent.RadarEventVerification verification, @Nullable String verifiedPlaceId) {
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        Intrinsics.checkNotNullParameter((Object)((Object)verification), (String)"verification");
        String string = RadarSettings.INSTANCE.getPublishableKey$sdk_release(this.context);
        if (string == null) {
            return;
        }
        String publishableKey = string;
        JSONObject params = new JSONObject();
        params.putOpt("verification", (Object)verification);
        params.putOpt("verifiedPlaceId", (Object)verifiedPlaceId);
        String path = "v1/events/" + eventId + "/verification";
        Map<String, String> headers = this.headers(publishableKey);
        RadarApiHelper.request$sdk_release$default(this.apiHelper, this.context, "PUT", path, headers, params, false, null, false, false, false, false, 1984, null);
    }

    public static /* synthetic */ void verifyEvent$sdk_release$default(RadarApiClient radarApiClient, String string, RadarEvent.RadarEventVerification radarEventVerification, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        radarApiClient.verifyEvent$sdk_release(string, radarEventVerification, string2);
    }

    public final void createTrip$sdk_release(@Nullable RadarTripOptions options, @Nullable RadarTripApiCallback callback) {
        String externalId;
        String publishableKey = RadarSettings.INSTANCE.getPublishableKey$sdk_release(this.context);
        if (publishableKey == null) {
            RadarTripApiCallback radarTripApiCallback = callback;
            if (radarTripApiCallback != null) {
                RadarTripApiCallback.DefaultImpls.onComplete$default(radarTripApiCallback, Radar.RadarStatus.ERROR_PUBLISHABLE_KEY, null, null, null, 14, null);
            }
            return;
        }
        RadarTripOptions radarTripOptions = options;
        String string = externalId = radarTripOptions != null ? radarTripOptions.getExternalId() : null;
        if (externalId == null) {
            RadarTripApiCallback radarTripApiCallback = callback;
            if (radarTripApiCallback != null) {
                RadarTripApiCallback.DefaultImpls.onComplete$default(radarTripApiCallback, Radar.RadarStatus.ERROR_BAD_REQUEST, null, null, null, 14, null);
            }
            return;
        }
        JSONObject params = new JSONObject();
        params.putOpt("userId", (Object)RadarSettings.INSTANCE.getUserId$sdk_release(this.context));
        params.putOpt("externalId", (Object)externalId);
        if (options.getMetadata() != null) {
            params.putOpt("metadata", (Object)options.getMetadata());
        }
        if (options.getDestinationGeofenceTag() != null) {
            params.putOpt("destinationGeofenceTag", (Object)options.getDestinationGeofenceTag());
        }
        if (options.getDestinationGeofenceExternalId() != null) {
            params.putOpt("destinationGeofenceExternalId", (Object)options.getDestinationGeofenceExternalId());
        }
        params.putOpt("mode", (Object)Radar.stringForMode(options.getMode()));
        params.putOpt("scheduledArrivalAt", (Object)RadarUtils.INSTANCE.dateToISOString$sdk_release(options.getScheduledArrivalAt()));
        if (options.getApproachingThreshold() > 0) {
            params.put("approachingThreshold", options.getApproachingThreshold());
        }
        String path = "v1/trips";
        Map<String, String> headers = this.headers(publishableKey);
        RadarApiHelper.request$sdk_release$default(this.apiHelper, this.context, "POST", path, headers, params, false, new RadarApiHelper.RadarApiCallback(callback){
            final /* synthetic */ RadarTripApiCallback $callback;
            {
                this.$callback = $callback;
            }

            public void onComplete(@NotNull Radar.RadarStatus status, @Nullable JSONObject res) {
                block7: {
                    RadarEvent[] events;
                    RadarEvent[] radarEventArray;
                    RadarTrip radarTrip;
                    Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
                    if (status != Radar.RadarStatus.SUCCESS || res == null) {
                        RadarTripApiCallback radarTripApiCallback = this.$callback;
                        if (radarTripApiCallback != null) {
                            RadarTripApiCallback.DefaultImpls.onComplete$default(radarTripApiCallback, status, null, null, null, 14, null);
                        }
                        return;
                    }
                    JSONObject jSONObject = res.optJSONObject("trip");
                    if (jSONObject != null) {
                        JSONObject tripObj = jSONObject;
                        boolean bl = false;
                        radarTrip = RadarTrip.Companion.fromJson(tripObj);
                    } else {
                        radarTrip = null;
                    }
                    RadarTrip trip = radarTrip;
                    JSONArray jSONArray = res.optJSONArray("events");
                    if (jSONArray != null) {
                        JSONArray eventsArr = jSONArray;
                        boolean bl = false;
                        radarEventArray = RadarEvent.Companion.fromJson(eventsArr);
                    } else {
                        radarEventArray = events = null;
                    }
                    if (events != null && !(events.length == 0)) {
                        Radar.sendEvents$sdk_release$default(Radar.INSTANCE, events, null, 2, null);
                    }
                    RadarTripApiCallback radarTripApiCallback = this.$callback;
                    if (radarTripApiCallback == null) break block7;
                    radarTripApiCallback.onComplete(Radar.RadarStatus.SUCCESS, res, trip, events);
                }
            }
        }, false, false, false, false, 1920, null);
    }

    public final void updateTrip$sdk_release(@Nullable RadarTripOptions options, @Nullable RadarTrip.RadarTripStatus status, @Nullable RadarTripApiCallback callback) {
        String externalId;
        String publishableKey = RadarSettings.INSTANCE.getPublishableKey$sdk_release(this.context);
        if (publishableKey == null) {
            RadarTripApiCallback radarTripApiCallback = callback;
            if (radarTripApiCallback != null) {
                RadarTripApiCallback.DefaultImpls.onComplete$default(radarTripApiCallback, Radar.RadarStatus.ERROR_PUBLISHABLE_KEY, null, null, null, 14, null);
            }
            return;
        }
        RadarTripOptions radarTripOptions = options;
        String string = externalId = radarTripOptions != null ? radarTripOptions.getExternalId() : null;
        if (externalId == null) {
            RadarTripApiCallback radarTripApiCallback = callback;
            if (radarTripApiCallback != null) {
                RadarTripApiCallback.DefaultImpls.onComplete$default(radarTripApiCallback, Radar.RadarStatus.ERROR_BAD_REQUEST, null, null, null, 14, null);
            }
            return;
        }
        JSONObject params = new JSONObject();
        params.putOpt("userId", (Object)RadarSettings.INSTANCE.getUserId$sdk_release(this.context));
        if (status != null && status != RadarTrip.RadarTripStatus.UNKNOWN) {
            params.putOpt("status", (Object)Radar.stringForTripStatus(status));
        }
        if (options.getMetadata() != null) {
            params.putOpt("metadata", (Object)options.getMetadata());
        }
        if (options.getDestinationGeofenceTag() != null) {
            params.putOpt("destinationGeofenceTag", (Object)options.getDestinationGeofenceTag());
        }
        if (options.getDestinationGeofenceExternalId() != null) {
            params.putOpt("destinationGeofenceExternalId", (Object)options.getDestinationGeofenceExternalId());
        }
        params.putOpt("mode", (Object)Radar.stringForMode(options.getMode()));
        params.putOpt("scheduledArrivalAt", (Object)RadarUtils.INSTANCE.dateToISOString$sdk_release(options.getScheduledArrivalAt()));
        if (options.getApproachingThreshold() > 0) {
            params.put("approachingThreshold", options.getApproachingThreshold());
        }
        String path = "v1/trips/" + externalId + "/update";
        Map<String, String> headers = this.headers(publishableKey);
        RadarApiHelper.request$sdk_release$default(this.apiHelper, this.context, "PATCH", path, headers, params, false, new RadarApiHelper.RadarApiCallback(callback){
            final /* synthetic */ RadarTripApiCallback $callback;
            {
                this.$callback = $callback;
            }

            public void onComplete(@NotNull Radar.RadarStatus status, @Nullable JSONObject res) {
                block7: {
                    RadarEvent[] events;
                    RadarEvent[] radarEventArray;
                    RadarTrip radarTrip;
                    Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
                    if (status != Radar.RadarStatus.SUCCESS || res == null) {
                        RadarTripApiCallback radarTripApiCallback = this.$callback;
                        if (radarTripApiCallback != null) {
                            RadarTripApiCallback.DefaultImpls.onComplete$default(radarTripApiCallback, status, null, null, null, 14, null);
                        }
                        return;
                    }
                    JSONObject jSONObject = res.optJSONObject("trip");
                    if (jSONObject != null) {
                        JSONObject tripObj = jSONObject;
                        boolean bl = false;
                        radarTrip = RadarTrip.Companion.fromJson(tripObj);
                    } else {
                        radarTrip = null;
                    }
                    RadarTrip trip = radarTrip;
                    JSONArray jSONArray = res.optJSONArray("events");
                    if (jSONArray != null) {
                        JSONArray eventsArr = jSONArray;
                        boolean bl = false;
                        radarEventArray = RadarEvent.Companion.fromJson(eventsArr);
                    } else {
                        radarEventArray = events = null;
                    }
                    if (events != null && !(events.length == 0)) {
                        Radar.sendEvents$sdk_release$default(Radar.INSTANCE, events, null, 2, null);
                    }
                    RadarTripApiCallback radarTripApiCallback = this.$callback;
                    if (radarTripApiCallback == null) break block7;
                    radarTripApiCallback.onComplete(Radar.RadarStatus.SUCCESS, res, trip, events);
                }
            }
        }, false, false, false, false, 1920, null);
    }

    public final void getContext$sdk_release(@NotNull Location location, @NotNull RadarContextApiCallback callback) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        String publishableKey = RadarSettings.INSTANCE.getPublishableKey$sdk_release(this.context);
        if (publishableKey == null) {
            RadarContextApiCallback.DefaultImpls.onComplete$default(callback, Radar.RadarStatus.ERROR_PUBLISHABLE_KEY, null, null, 6, null);
            return;
        }
        StringBuilder queryParams = new StringBuilder();
        queryParams.append("coordinates=" + location.getLatitude() + ',' + location.getLongitude());
        String path = "v1/context?" + queryParams;
        Map<String, String> headers = this.headers(publishableKey);
        RadarApiHelper.request$sdk_release$default(this.apiHelper, this.context, "GET", path, headers, null, false, new RadarApiHelper.RadarApiCallback(callback){
            final /* synthetic */ RadarContextApiCallback $callback;
            {
                this.$callback = $callback;
            }

            public void onComplete(@NotNull Radar.RadarStatus status, @Nullable JSONObject res) {
                RadarContext context;
                RadarContext radarContext;
                Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
                if (status != Radar.RadarStatus.SUCCESS || res == null) {
                    RadarContextApiCallback.DefaultImpls.onComplete$default(this.$callback, status, null, null, 6, null);
                    return;
                }
                JSONObject jSONObject = res.optJSONObject("context");
                if (jSONObject != null) {
                    JSONObject contextObj = jSONObject;
                    boolean bl = false;
                    radarContext = RadarContext.Companion.fromJson(contextObj);
                } else {
                    radarContext = context = null;
                }
                if (context != null) {
                    this.$callback.onComplete(Radar.RadarStatus.SUCCESS, res, context);
                    return;
                }
                RadarContextApiCallback.DefaultImpls.onComplete$default(this.$callback, Radar.RadarStatus.ERROR_SERVER, null, null, 6, null);
            }
        }, false, false, false, false, 1920, null);
    }

    public final void searchPlaces$sdk_release(@NotNull Location location, int radius, @Nullable String[] chains, @Nullable Map<String, String> chainMetadata, @Nullable String[] categories, @Nullable String[] groups, @Nullable Integer limit, @NotNull RadarSearchPlacesApiCallback callback) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        String publishableKey = RadarSettings.INSTANCE.getPublishableKey$sdk_release(this.context);
        if (publishableKey == null) {
            RadarSearchPlacesApiCallback.DefaultImpls.onComplete$default(callback, Radar.RadarStatus.ERROR_PUBLISHABLE_KEY, null, null, 6, null);
            return;
        }
        StringBuilder queryParams = new StringBuilder();
        queryParams.append("near=" + location.getLatitude() + ',' + location.getLongitude());
        queryParams.append("&radius=" + radius);
        queryParams.append("&limit=" + limit);
        boolean bl = chains != null ? !(chains.length == 0) : false;
        if (bl) {
            queryParams.append("&chains=" + ArraysKt.joinToString$default((Object[])chains, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
        }
        boolean bl2 = categories != null ? !(categories.length == 0) : false;
        if (bl2) {
            queryParams.append("&categories=" + ArraysKt.joinToString$default((Object[])categories, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
        }
        boolean bl3 = groups != null ? !(groups.length == 0) : false;
        if (bl3) {
            queryParams.append("&groups=" + ArraysKt.joinToString$default((Object[])groups, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
        }
        if ((object = chainMetadata) != null && (object = object.entrySet()) != null) {
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry it = (Map.Entry)element$iv;
                boolean bl4 = false;
                queryParams.append("&chainMetadata[" + (String)it.getKey() + "]=\"" + (String)it.getValue() + '\"');
            }
        }
        String path = "v1/search/places?" + queryParams;
        Map<String, String> headers = this.headers(publishableKey);
        RadarApiHelper.request$sdk_release$default(this.apiHelper, this.context, "GET", path, headers, null, false, new RadarApiHelper.RadarApiCallback(callback){
            final /* synthetic */ RadarSearchPlacesApiCallback $callback;
            {
                this.$callback = $callback;
            }

            public void onComplete(@NotNull Radar.RadarStatus status, @Nullable JSONObject res) {
                RadarPlace[] places;
                RadarPlace[] radarPlaceArray;
                Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
                if (status != Radar.RadarStatus.SUCCESS || res == null) {
                    RadarSearchPlacesApiCallback.DefaultImpls.onComplete$default(this.$callback, status, null, null, 6, null);
                    return;
                }
                JSONArray jSONArray = res.optJSONArray("places");
                if (jSONArray != null) {
                    JSONArray placesArr = jSONArray;
                    boolean bl = false;
                    radarPlaceArray = RadarPlace.Companion.fromJson(placesArr);
                } else {
                    radarPlaceArray = places = null;
                }
                if (places != null) {
                    this.$callback.onComplete(Radar.RadarStatus.SUCCESS, res, places);
                    return;
                }
                RadarSearchPlacesApiCallback.DefaultImpls.onComplete$default(this.$callback, Radar.RadarStatus.ERROR_SERVER, null, null, 6, null);
            }
        }, false, false, false, false, 1920, null);
    }

    public final void searchGeofences$sdk_release(@NotNull Location location, @Nullable Integer radius, @Nullable String[] tags, @Nullable JSONObject metadata, @Nullable Integer limit, @Nullable Boolean includeGeometry, @NotNull RadarSearchGeofencesApiCallback callback) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        String publishableKey = RadarSettings.INSTANCE.getPublishableKey$sdk_release(this.context);
        if (publishableKey == null) {
            RadarSearchGeofencesApiCallback.DefaultImpls.onComplete$default(callback, Radar.RadarStatus.ERROR_PUBLISHABLE_KEY, null, null, 6, null);
            return;
        }
        StringBuilder queryParams = new StringBuilder();
        queryParams.append("near=" + location.getLatitude() + ',' + location.getLongitude());
        if (radius != null) {
            queryParams.append("&radius=" + radius);
        }
        queryParams.append("&limit=" + limit);
        boolean bl = tags != null ? !(tags.length == 0) : false;
        if (bl) {
            queryParams.append("&tags=" + ArraysKt.joinToString$default((Object[])tags, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
        }
        if ((object = metadata) != null && (object = object.keys()) != null) {
            Object $this$forEach$iv = object;
            boolean $i$f$forEach = false;
            Object object2 = $this$forEach$iv;
            while (object2.hasNext()) {
                Object element$iv = object2.next();
                String key = (String)element$iv;
                boolean bl2 = false;
                Object value = metadata.get(key);
                queryParams.append("&metadata[" + key + "]=" + value);
            }
        }
        if (includeGeometry != null) {
            queryParams.append("&includeGeometry=" + includeGeometry);
        }
        String path = "v1/search/geofences?" + queryParams;
        Map<String, String> headers = this.headers(publishableKey);
        RadarApiHelper.request$sdk_release$default(this.apiHelper, this.context, "GET", path, headers, null, false, new RadarApiHelper.RadarApiCallback(callback){
            final /* synthetic */ RadarSearchGeofencesApiCallback $callback;
            {
                this.$callback = $callback;
            }

            public void onComplete(@NotNull Radar.RadarStatus status, @Nullable JSONObject res) {
                RadarGeofence[] geofences;
                RadarGeofence[] radarGeofenceArray;
                Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
                if (status != Radar.RadarStatus.SUCCESS || res == null) {
                    RadarSearchGeofencesApiCallback.DefaultImpls.onComplete$default(this.$callback, status, null, null, 6, null);
                    return;
                }
                JSONArray jSONArray = res.optJSONArray("geofences");
                if (jSONArray != null) {
                    JSONArray geofencesArr = jSONArray;
                    boolean bl = false;
                    radarGeofenceArray = RadarGeofence.Companion.fromJson(geofencesArr);
                } else {
                    radarGeofenceArray = geofences = null;
                }
                if (geofences != null) {
                    this.$callback.onComplete(Radar.RadarStatus.SUCCESS, res, geofences);
                    return;
                }
                RadarSearchGeofencesApiCallback.DefaultImpls.onComplete$default(this.$callback, Radar.RadarStatus.ERROR_SERVER, null, null, 6, null);
            }
        }, false, false, false, false, 1920, null);
    }

    public final void searchBeacons$sdk_release(@NotNull Location location, int radius, @Nullable Integer limit, @NotNull RadarSearchBeaconsApiCallback callback, boolean cache) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        String publishableKey = RadarSettings.INSTANCE.getPublishableKey$sdk_release(this.context);
        if (publishableKey == null) {
            RadarSearchBeaconsApiCallback.DefaultImpls.onComplete$default(callback, Radar.RadarStatus.ERROR_PUBLISHABLE_KEY, null, null, null, null, 30, null);
            return;
        }
        if (cache && Build.VERSION.SDK_INT >= 26) {
            RadarBeacon[] lastBeacons = RadarState.INSTANCE.getLastBeacons$sdk_release(this.context);
            Object[] lastBeaconUUIDs = RadarState.INSTANCE.getLastBeaconUUIDs$sdk_release(this.context);
            Object[] lastBeaconUIDs = RadarState.INSTANCE.getLastBeaconUIDs$sdk_release(this.context);
            RadarLogger.d$default(this.logger, "Using cached search beacons response | lastBeaconUUIDs = " + (lastBeaconUUIDs != null ? ArraysKt.joinToString$default((Object[])lastBeaconUUIDs, (CharSequence)",", null, null, (int)0, null, null, (int)62, null) : null) + "; lastBeaconUIDs = " + (lastBeaconUIDs != null ? ArraysKt.joinToString$default((Object[])lastBeaconUIDs, (CharSequence)",", null, null, (int)0, null, null, (int)62, null) : null), null, null, 6, null);
            callback.onComplete(Radar.RadarStatus.SUCCESS, null, lastBeacons, (String[])lastBeaconUUIDs, (String[])lastBeaconUIDs);
            return;
        }
        StringBuilder queryParams = new StringBuilder();
        queryParams.append("near=" + location.getLatitude() + ',' + location.getLongitude());
        queryParams.append("&radius=" + radius);
        queryParams.append("&limit=" + limit);
        queryParams.append("&installId=" + RadarSettings.INSTANCE.getInstallId$sdk_release(this.context));
        String path = "v1/search/beacons?" + queryParams;
        Map<String, String> headers = this.headers(publishableKey);
        RadarApiHelper.request$sdk_release$default(this.apiHelper, this.context, "GET", path, headers, null, false, new RadarApiHelper.RadarApiCallback(this, callback){
            final /* synthetic */ RadarApiClient this$0;
            final /* synthetic */ RadarSearchBeaconsApiCallback $callback;
            {
                this.this$0 = $receiver;
                this.$callback = $callback;
            }

            /*
             * WARNING - void declaration
             */
            public void onComplete(@NotNull Radar.RadarStatus status, @Nullable JSONObject res) {
                String[] uids;
                String[] stringArray;
                JSONObject jSONObject;
                String[] uuids;
                String[] stringArray2;
                int $i$f$toTypedArray22;
                int n;
                int $i$f$filterTo;
                Object destination$iv$iv;
                JSONObject jSONObject2;
                RadarBeacon[] beacons;
                RadarBeacon[] radarBeaconArray;
                Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
                if (status != Radar.RadarStatus.SUCCESS || res == null) {
                    RadarBeacon[] lastBeacons = null;
                    String[] lastBeaconUUIDs = null;
                    String[] lastBeaconUIDs = null;
                    if (Build.VERSION.SDK_INT >= 26) {
                        lastBeacons = RadarState.INSTANCE.getLastBeacons$sdk_release(RadarApiClient.access$getContext$p(this.this$0));
                        lastBeaconUUIDs = RadarState.INSTANCE.getLastBeaconUUIDs$sdk_release(RadarApiClient.access$getContext$p(this.this$0));
                        lastBeaconUIDs = RadarState.INSTANCE.getLastBeaconUIDs$sdk_release(RadarApiClient.access$getContext$p(this.this$0));
                    }
                    this.$callback.onComplete(status, res, lastBeacons, lastBeaconUUIDs, lastBeaconUIDs);
                    return;
                }
                JSONArray jSONArray = res.optJSONArray("beacons");
                if (jSONArray != null) {
                    JSONArray beaconsArr = jSONArray;
                    boolean bl = false;
                    radarBeaconArray = RadarBeacon.Companion.fromJson(beaconsArr);
                } else {
                    radarBeaconArray = beacons = null;
                }
                if ((jSONObject2 = res.optJSONObject("meta")) != null && (jSONObject2 = jSONObject2.optJSONObject("settings")) != null && (jSONObject2 = jSONObject2.optJSONObject("beacons")) != null && (jSONObject2 = jSONObject2.optJSONArray("uuids")) != null) {
                    void $this$toTypedArray$iv;
                    void $this$filterTo$iv$iv;
                    Collection $this$filter$iv;
                    JSONObject uuids2 = jSONObject2;
                    boolean bl = false;
                    int n2 = 0;
                    int n3 = uuids2.length();
                    String[] stringArray3 = new String[n3];
                    while (n2 < n3) {
                        int n4 = n2++;
                        stringArray3[n4] = uuids2.getString(n4);
                    }
                    String[] stringArray4 = stringArray3;
                    boolean $i$f$filter = false;
                    stringArray3 = $this$filter$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterTo = 0;
                    n = ((void)$this$filterTo$iv$iv).length;
                    for (int i = 0; i < n; ++i) {
                        void element$iv$iv;
                        void uuid = element$iv$iv = $this$filterTo$iv$iv[i];
                        boolean bl2 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)uuid, (String)"uuid");
                        boolean bl3 = ((CharSequence)uuid).length() > 0;
                        if (!bl3) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    $i$f$toTypedArray22 = 0;
                    void thisCollection$iv = $this$toTypedArray$iv;
                    String[] stringArray5 = thisCollection$iv.toArray(new String[0]);
                    if (stringArray5 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                    }
                    stringArray2 = stringArray5;
                } else {
                    stringArray2 = uuids = null;
                }
                if ((jSONObject = res.optJSONObject("meta")) != null && (jSONObject = jSONObject.optJSONObject("settings")) != null && (jSONObject = jSONObject.optJSONObject("beacons")) != null && (jSONObject = jSONObject.optJSONArray("uids")) != null) {
                    void $this$toTypedArray$iv;
                    void $this$filterTo$iv$iv;
                    Collection $this$filter$iv;
                    JSONObject uids2 = jSONObject;
                    boolean bl = false;
                    $i$f$toTypedArray22 = 0;
                    int thisCollection$iv = uids2.length();
                    destination$iv$iv = new String[thisCollection$iv];
                    while ($i$f$toTypedArray22 < thisCollection$iv) {
                        $i$f$filterTo = $i$f$toTypedArray22++;
                        destination$iv$iv[$i$f$filterTo] = uids2.getString($i$f$filterTo);
                    }
                    String[] $i$f$toTypedArray22 = destination$iv$iv;
                    boolean $i$f$filter = false;
                    destination$iv$iv = $this$filter$iv;
                    Collection destination$iv$iv2 = new ArrayList<E>();
                    boolean $i$f$filterTo2 = false;
                    int n5 = ((void)$this$filterTo$iv$iv).length;
                    for (n = 0; n < n5; ++n) {
                        void element$iv$iv;
                        void uid = element$iv$iv = $this$filterTo$iv$iv[n];
                        boolean bl4 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)uid, (String)"uid");
                        boolean bl5 = ((CharSequence)uid).length() > 0;
                        if (!bl5) continue;
                        destination$iv$iv2.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv2;
                    boolean $i$f$toTypedArray = false;
                    void thisCollection$iv2 = $this$toTypedArray$iv;
                    String[] stringArray6 = thisCollection$iv2.toArray(new String[0]);
                    if (stringArray6 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                    }
                    stringArray = stringArray6;
                } else {
                    stringArray = uids = null;
                }
                if (Build.VERSION.SDK_INT >= 26) {
                    RadarState.INSTANCE.setLastBeacons$sdk_release(RadarApiClient.access$getContext$p(this.this$0), beacons);
                    RadarState.INSTANCE.setLastBeaconUUIDs$sdk_release(RadarApiClient.access$getContext$p(this.this$0), uuids);
                    RadarState.INSTANCE.setLastBeaconUIDs$sdk_release(RadarApiClient.access$getContext$p(this.this$0), uids);
                }
                this.$callback.onComplete(Radar.RadarStatus.SUCCESS, res, beacons, uuids, uids);
            }
        }, false, false, false, false, 1920, null);
    }

    public final void autocomplete$sdk_release(@NotNull String query, @Nullable Location near, @Nullable String[] layers, @Nullable Integer limit, @Nullable String country, @Nullable Boolean mailable, @NotNull RadarGeocodeApiCallback callback) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        String publishableKey = RadarSettings.INSTANCE.getPublishableKey$sdk_release(this.context);
        if (publishableKey == null) {
            RadarGeocodeApiCallback.DefaultImpls.onComplete$default(callback, Radar.RadarStatus.ERROR_PUBLISHABLE_KEY, null, null, 6, null);
            return;
        }
        StringBuilder queryParams = new StringBuilder();
        queryParams.append("query=" + query);
        if (near != null) {
            queryParams.append("&near=" + near.getLatitude() + ',' + near.getLongitude());
        }
        boolean bl = layers != null ? !(layers.length == 0) : false;
        if (bl) {
            queryParams.append("&layers=" + ArraysKt.joinToString$default((Object[])layers, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
        }
        queryParams.append("&limit=" + limit);
        if (country != null) {
            queryParams.append("&country=" + country);
        }
        if (mailable != null) {
            queryParams.append("&mailable=" + mailable);
        }
        String path = "v1/search/autocomplete?" + queryParams;
        Map<String, String> headers = this.headers(publishableKey);
        RadarApiHelper.request$sdk_release$default(this.apiHelper, this.context, "GET", path, headers, null, false, new RadarApiHelper.RadarApiCallback(callback){
            final /* synthetic */ RadarGeocodeApiCallback $callback;
            {
                this.$callback = $callback;
            }

            public void onComplete(@NotNull Radar.RadarStatus status, @Nullable JSONObject res) {
                RadarAddress[] addresses;
                RadarAddress[] radarAddressArray;
                Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
                if (status != Radar.RadarStatus.SUCCESS || res == null) {
                    RadarGeocodeApiCallback.DefaultImpls.onComplete$default(this.$callback, status, null, null, 6, null);
                    return;
                }
                JSONArray jSONArray = res.optJSONArray("addresses");
                if (jSONArray != null) {
                    JSONArray addressesArr = jSONArray;
                    boolean bl = false;
                    radarAddressArray = RadarAddress.Companion.fromJson(addressesArr);
                } else {
                    radarAddressArray = addresses = null;
                }
                if (addresses != null) {
                    this.$callback.onComplete(Radar.RadarStatus.SUCCESS, res, addresses);
                    return;
                }
                RadarGeocodeApiCallback.DefaultImpls.onComplete$default(this.$callback, Radar.RadarStatus.ERROR_SERVER, null, null, 6, null);
            }
        }, false, false, false, false, 1920, null);
    }

    public static /* synthetic */ void autocomplete$sdk_release$default(RadarApiClient radarApiClient, String string, Location location, String[] stringArray, Integer n, String string2, Boolean bl, RadarGeocodeApiCallback radarGeocodeApiCallback, int n2, Object object) {
        if ((n2 & 2) != 0) {
            location = null;
        }
        if ((n2 & 4) != 0) {
            stringArray = null;
        }
        if ((n2 & 8) != 0) {
            n = null;
        }
        if ((n2 & 0x10) != 0) {
            string2 = null;
        }
        if ((n2 & 0x20) != 0) {
            bl = null;
        }
        radarApiClient.autocomplete$sdk_release(string, location, stringArray, n, string2, bl, radarGeocodeApiCallback);
    }

    public final void validateAddress$sdk_release(@NotNull RadarAddress address, @NotNull RadarValidateAddressAPICallback callback) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        String publishableKey = RadarSettings.INSTANCE.getPublishableKey$sdk_release(this.context);
        if (publishableKey == null) {
            RadarValidateAddressAPICallback.DefaultImpls.onComplete$default(callback, Radar.RadarStatus.ERROR_PUBLISHABLE_KEY, null, null, null, 14, null);
            return;
        }
        StringBuilder queryParams = new StringBuilder();
        queryParams.append("countryCode=" + address.getCountryCode());
        queryParams.append("&stateCode=" + address.getStateCode());
        queryParams.append("&city=" + address.getCity());
        queryParams.append("&number=" + address.getNumber());
        queryParams.append("&street=" + address.getStreet());
        queryParams.append("&postalCode=" + address.getPostalCode());
        if (address.getUnit() != null) {
            queryParams.append("&unit=" + address.getUnit());
        }
        String path = "v1/addresses/validate?" + queryParams;
        Map<String, String> headers = this.headers(publishableKey);
        RadarApiHelper.request$sdk_release$default(this.apiHelper, this.context, "GET", path, headers, null, false, new RadarApiHelper.RadarApiCallback(callback){
            final /* synthetic */ RadarValidateAddressAPICallback $callback;
            {
                this.$callback = $callback;
            }

            /*
             * Unable to fully structure code
             */
            public void onComplete(@NotNull Radar.RadarStatus status, @Nullable JSONObject res) {
                block15: {
                    block12: {
                        block14: {
                            block13: {
                                Intrinsics.checkNotNullParameter((Object)status, (String)"status");
                                if (status != Radar.RadarStatus.SUCCESS || res == null) {
                                    RadarValidateAddressAPICallback.DefaultImpls.onComplete$default(this.$callback, status, null, null, null, 14, null);
                                    return;
                                }
                                v0 = res.optJSONObject("address");
                                if (v0 != null) {
                                    address = v0;
                                    $i$a$-let-RadarApiClient$validateAddress$1$onComplete$address$1 = false;
                                    v1 = RadarAddress.Companion.fromJson(address);
                                } else {
                                    v1 = null;
                                }
                                address = v1;
                                var5_6 = res.optString("verificationStatus");
                                if (var5_6 == null) break block12;
                                switch (var5_6.hashCode()) {
                                    case 80: {
                                        if (var5_6.equals("P")) break;
                                        ** break;
                                    }
                                    case 65: {
                                        if (!var5_6.equals("A")) {
                                            ** break;
                                        }
                                        break block13;
                                    }
                                    case 85: {
                                        if (!var5_6.equals("U")) {
                                            ** break;
                                        }
                                        break block14;
                                    }
                                    case 86: {
                                        if (!var5_6.equals("V")) ** break;
                                        v2 = Radar.RadarAddressVerificationStatus.VERIFIED;
                                        break block15;
                                    }
                                }
                                v2 = Radar.RadarAddressVerificationStatus.PARTIALLY_VERIFIED;
                                break block15;
                            }
                            v2 = Radar.RadarAddressVerificationStatus.AMBIGUOUS;
                            break block15;
                        }
                        v2 = Radar.RadarAddressVerificationStatus.UNVERIFIED;
                        break block15;
                    }
                    v2 = verificationStatus = Radar.RadarAddressVerificationStatus.NONE;
                }
                if (address != null) {
                    this.$callback.onComplete(Radar.RadarStatus.SUCCESS, res, address, verificationStatus);
                    return;
                }
                RadarValidateAddressAPICallback.DefaultImpls.onComplete$default(this.$callback, Radar.RadarStatus.ERROR_SERVER, null, null, null, 14, null);
            }
        }, false, false, false, false, 1920, null);
    }

    public final void geocode$sdk_release(@NotNull String query, @Nullable String[] layers, @Nullable String[] countries, @NotNull RadarGeocodeApiCallback callback) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        String publishableKey = RadarSettings.INSTANCE.getPublishableKey$sdk_release(this.context);
        if (publishableKey == null) {
            RadarGeocodeApiCallback.DefaultImpls.onComplete$default(callback, Radar.RadarStatus.ERROR_PUBLISHABLE_KEY, null, null, 6, null);
            return;
        }
        StringBuilder queryParams = new StringBuilder();
        queryParams.append("query=" + query);
        boolean bl = layers != null ? !(layers.length == 0) : false;
        if (bl) {
            queryParams.append("&layers=" + ArraysKt.joinToString$default((Object[])layers, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
        }
        boolean bl2 = countries != null ? !(countries.length == 0) : false;
        if (bl2) {
            queryParams.append("&country=" + ArraysKt.joinToString$default((Object[])countries, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
        }
        String path = "v1/geocode/forward?" + queryParams;
        Map<String, String> headers = this.headers(publishableKey);
        RadarApiHelper.request$sdk_release$default(this.apiHelper, this.context, "GET", path, headers, null, false, new RadarApiHelper.RadarApiCallback(callback){
            final /* synthetic */ RadarGeocodeApiCallback $callback;
            {
                this.$callback = $callback;
            }

            public void onComplete(@NotNull Radar.RadarStatus status, @Nullable JSONObject res) {
                RadarAddress[] addresses;
                RadarAddress[] radarAddressArray;
                Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
                if (status != Radar.RadarStatus.SUCCESS || res == null) {
                    RadarGeocodeApiCallback.DefaultImpls.onComplete$default(this.$callback, status, null, null, 6, null);
                    return;
                }
                JSONArray jSONArray = res.optJSONArray("addresses");
                if (jSONArray != null) {
                    JSONArray addressesArr = jSONArray;
                    boolean bl = false;
                    radarAddressArray = RadarAddress.Companion.fromJson(addressesArr);
                } else {
                    radarAddressArray = addresses = null;
                }
                if (addresses != null) {
                    this.$callback.onComplete(Radar.RadarStatus.SUCCESS, res, addresses);
                    return;
                }
                RadarGeocodeApiCallback.DefaultImpls.onComplete$default(this.$callback, Radar.RadarStatus.ERROR_SERVER, null, null, 6, null);
            }
        }, false, false, false, false, 1920, null);
    }

    public static /* synthetic */ void geocode$sdk_release$default(RadarApiClient radarApiClient, String string, String[] stringArray, String[] stringArray2, RadarGeocodeApiCallback radarGeocodeApiCallback, int n, Object object) {
        if ((n & 2) != 0) {
            stringArray = null;
        }
        if ((n & 4) != 0) {
            stringArray2 = null;
        }
        radarApiClient.geocode$sdk_release(string, stringArray, stringArray2, radarGeocodeApiCallback);
    }

    public final void reverseGeocode$sdk_release(@NotNull Location location, @Nullable String[] layers, @NotNull RadarGeocodeApiCallback callback) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        String publishableKey = RadarSettings.INSTANCE.getPublishableKey$sdk_release(this.context);
        if (publishableKey == null) {
            RadarGeocodeApiCallback.DefaultImpls.onComplete$default(callback, Radar.RadarStatus.ERROR_PUBLISHABLE_KEY, null, null, 6, null);
            return;
        }
        StringBuilder queryParams = new StringBuilder();
        queryParams.append("coordinates=" + location.getLatitude() + ',' + location.getLongitude());
        boolean bl = layers != null ? !(layers.length == 0) : false;
        if (bl) {
            queryParams.append("&layers=" + ArraysKt.joinToString$default((Object[])layers, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
        }
        String path = "v1/geocode/reverse?" + queryParams;
        Map<String, String> headers = this.headers(publishableKey);
        RadarApiHelper.request$sdk_release$default(this.apiHelper, this.context, "GET", path, headers, null, false, new RadarApiHelper.RadarApiCallback(callback){
            final /* synthetic */ RadarGeocodeApiCallback $callback;
            {
                this.$callback = $callback;
            }

            public void onComplete(@NotNull Radar.RadarStatus status, @Nullable JSONObject res) {
                RadarAddress[] addresses;
                RadarAddress[] radarAddressArray;
                Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
                if (status != Radar.RadarStatus.SUCCESS || res == null) {
                    RadarGeocodeApiCallback.DefaultImpls.onComplete$default(this.$callback, status, null, null, 6, null);
                    return;
                }
                JSONArray jSONArray = res.optJSONArray("addresses");
                if (jSONArray != null) {
                    JSONArray addressesArr = jSONArray;
                    boolean bl = false;
                    radarAddressArray = RadarAddress.Companion.fromJson(addressesArr);
                } else {
                    radarAddressArray = addresses = null;
                }
                if (addresses != null) {
                    this.$callback.onComplete(Radar.RadarStatus.SUCCESS, res, addresses);
                    return;
                }
                RadarGeocodeApiCallback.DefaultImpls.onComplete$default(this.$callback, Radar.RadarStatus.ERROR_SERVER, null, null, 6, null);
            }
        }, false, false, false, false, 1920, null);
    }

    public static /* synthetic */ void reverseGeocode$sdk_release$default(RadarApiClient radarApiClient, Location location, String[] stringArray, RadarGeocodeApiCallback radarGeocodeApiCallback, int n, Object object) {
        if ((n & 2) != 0) {
            stringArray = null;
        }
        radarApiClient.reverseGeocode$sdk_release(location, stringArray, radarGeocodeApiCallback);
    }

    public final void ipGeocode$sdk_release(@NotNull RadarIpGeocodeApiCallback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        String publishableKey = RadarSettings.INSTANCE.getPublishableKey$sdk_release(this.context);
        if (publishableKey == null) {
            RadarIpGeocodeApiCallback.DefaultImpls.onComplete$default(callback, Radar.RadarStatus.ERROR_PUBLISHABLE_KEY, null, null, false, 14, null);
            return;
        }
        String path = "v1/geocode/ip";
        Map<String, String> headers = this.headers(publishableKey);
        RadarApiHelper.request$sdk_release$default(this.apiHelper, this.context, "GET", path, headers, null, false, new RadarApiHelper.RadarApiCallback(callback){
            final /* synthetic */ RadarIpGeocodeApiCallback $callback;
            {
                this.$callback = $callback;
            }

            public void onComplete(@NotNull Radar.RadarStatus status, @Nullable JSONObject res) {
                RadarAddress radarAddress;
                Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
                if (status != Radar.RadarStatus.SUCCESS || res == null) {
                    RadarIpGeocodeApiCallback.DefaultImpls.onComplete$default(this.$callback, status, null, null, false, 14, null);
                    return;
                }
                JSONObject jSONObject = res.optJSONObject("address");
                if (jSONObject != null) {
                    JSONObject addressObj = jSONObject;
                    boolean bl = false;
                    radarAddress = RadarAddress.Companion.fromJson(addressObj);
                } else {
                    radarAddress = null;
                }
                RadarAddress address = radarAddress;
                boolean proxy = res.optBoolean("proxy");
                if (address != null) {
                    this.$callback.onComplete(Radar.RadarStatus.SUCCESS, res, address, proxy);
                    return;
                }
                RadarIpGeocodeApiCallback.DefaultImpls.onComplete$default(this.$callback, Radar.RadarStatus.ERROR_SERVER, null, null, false, 14, null);
            }
        }, false, false, false, false, 1920, null);
    }

    public final void getDistance$sdk_release(@NotNull Location origin, @NotNull Location destination, @NotNull EnumSet<Radar.RadarRouteMode> modes, @NotNull Radar.RadarRouteUnits units, int geometryPoints, @NotNull RadarDistanceApiCallback callback) {
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Intrinsics.checkNotNullParameter(modes, (String)"modes");
        Intrinsics.checkNotNullParameter((Object)((Object)units), (String)"units");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        String publishableKey = RadarSettings.INSTANCE.getPublishableKey$sdk_release(this.context);
        if (publishableKey == null) {
            RadarDistanceApiCallback.DefaultImpls.onComplete$default(callback, Radar.RadarStatus.ERROR_PUBLISHABLE_KEY, null, null, 6, null);
            return;
        }
        StringBuilder queryParams = new StringBuilder();
        queryParams.append("origin=" + origin.getLatitude() + ',' + origin.getLongitude());
        queryParams.append("&destination=" + destination.getLatitude() + ',' + destination.getLongitude());
        List modesList = new ArrayList();
        if (modes.contains((Object)Radar.RadarRouteMode.FOOT)) {
            modesList.add("foot");
        }
        if (modes.contains((Object)Radar.RadarRouteMode.BIKE)) {
            modesList.add("bike");
        }
        if (modes.contains((Object)Radar.RadarRouteMode.CAR)) {
            modesList.add("car");
        }
        if (modes.contains((Object)Radar.RadarRouteMode.TRUCK)) {
            modesList.add("truck");
        }
        if (modes.contains((Object)Radar.RadarRouteMode.MOTORBIKE)) {
            modesList.add("motorbike");
        }
        queryParams.append("&modes=" + CollectionsKt.joinToString$default((Iterable)modesList, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
        if (units == Radar.RadarRouteUnits.METRIC) {
            queryParams.append("&units=metric");
        } else {
            queryParams.append("&units=imperial");
        }
        if (geometryPoints > 1) {
            queryParams.append("&geometryPoints=" + geometryPoints);
        }
        queryParams.append("&geometry=linestring");
        String path = "v1/route/distance?" + queryParams;
        Map<String, String> headers = this.headers(publishableKey);
        RadarApiHelper.request$sdk_release$default(this.apiHelper, this.context, "GET", path, headers, null, false, new RadarApiHelper.RadarApiCallback(callback){
            final /* synthetic */ RadarDistanceApiCallback $callback;
            {
                this.$callback = $callback;
            }

            public void onComplete(@NotNull Radar.RadarStatus status, @Nullable JSONObject res) {
                RadarRoutes routes;
                RadarRoutes radarRoutes;
                Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
                if (status != Radar.RadarStatus.SUCCESS || res == null) {
                    RadarDistanceApiCallback.DefaultImpls.onComplete$default(this.$callback, status, null, null, 6, null);
                    return;
                }
                JSONObject jSONObject = res.optJSONObject("routes");
                if (jSONObject != null) {
                    JSONObject routesObj = jSONObject;
                    boolean bl = false;
                    radarRoutes = RadarRoutes.Companion.fromJson(routesObj);
                } else {
                    radarRoutes = routes = null;
                }
                if (routes != null) {
                    this.$callback.onComplete(Radar.RadarStatus.SUCCESS, res, routes);
                    return;
                }
                RadarDistanceApiCallback.DefaultImpls.onComplete$default(this.$callback, Radar.RadarStatus.ERROR_SERVER, null, null, 6, null);
            }
        }, false, false, false, false, 1920, null);
    }

    public final void getMatrix$sdk_release(@NotNull Location[] origins, @NotNull Location[] destinations, @NotNull Radar.RadarRouteMode mode, @NotNull Radar.RadarRouteUnits units, @NotNull RadarMatrixApiCallback callback) {
        int i;
        Intrinsics.checkNotNullParameter((Object)origins, (String)"origins");
        Intrinsics.checkNotNullParameter((Object)destinations, (String)"destinations");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Intrinsics.checkNotNullParameter((Object)((Object)units), (String)"units");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        String publishableKey = RadarSettings.INSTANCE.getPublishableKey$sdk_release(this.context);
        if (publishableKey == null) {
            RadarMatrixApiCallback.DefaultImpls.onComplete$default(callback, Radar.RadarStatus.ERROR_PUBLISHABLE_KEY, null, null, 6, null);
            return;
        }
        StringBuilder queryParams = new StringBuilder();
        queryParams.append("origins=");
        int n = origins.length;
        for (i = 0; i < n; ++i) {
            queryParams.append("" + origins[i].getLatitude() + ',' + origins[i].getLongitude());
            if (i >= origins.length - 1) continue;
            queryParams.append("|");
        }
        queryParams.append("&destinations=");
        n = destinations.length;
        for (i = 0; i < n; ++i) {
            queryParams.append("" + destinations[i].getLatitude() + ',' + destinations[i].getLongitude());
            if (i >= destinations.length - 1) continue;
            queryParams.append("|");
        }
        if (mode == Radar.RadarRouteMode.FOOT) {
            queryParams.append("&mode=foot");
        } else if (mode == Radar.RadarRouteMode.BIKE) {
            queryParams.append("&mode=bike");
        } else if (mode == Radar.RadarRouteMode.CAR) {
            queryParams.append("&mode=car");
        } else if (mode == Radar.RadarRouteMode.TRUCK) {
            queryParams.append("&mode=truck");
        } else if (mode == Radar.RadarRouteMode.MOTORBIKE) {
            queryParams.append("&mode=motorbike");
        }
        if (units == Radar.RadarRouteUnits.METRIC) {
            queryParams.append("&units=metric");
        } else {
            queryParams.append("&units=imperial");
        }
        String path = "v1/route/matrix?" + queryParams;
        Map<String, String> headers = this.headers(publishableKey);
        RadarApiHelper.request$sdk_release$default(this.apiHelper, this.context, "GET", path, headers, null, false, new RadarApiHelper.RadarApiCallback(callback){
            final /* synthetic */ RadarMatrixApiCallback $callback;
            {
                this.$callback = $callback;
            }

            public void onComplete(@NotNull Radar.RadarStatus status, @Nullable JSONObject res) {
                RadarRouteMatrix matrix;
                RadarRouteMatrix radarRouteMatrix;
                Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
                if (status != Radar.RadarStatus.SUCCESS || res == null) {
                    RadarMatrixApiCallback.DefaultImpls.onComplete$default(this.$callback, status, null, null, 6, null);
                    return;
                }
                JSONArray jSONArray = res.optJSONArray("matrix");
                if (jSONArray != null) {
                    JSONArray matrixObj = jSONArray;
                    boolean bl = false;
                    radarRouteMatrix = RadarRouteMatrix.Companion.fromJson(matrixObj);
                } else {
                    radarRouteMatrix = matrix = null;
                }
                if (matrix != null) {
                    this.$callback.onComplete(Radar.RadarStatus.SUCCESS, res, matrix);
                    return;
                }
                RadarMatrixApiCallback.DefaultImpls.onComplete$default(this.$callback, Radar.RadarStatus.ERROR_SERVER, null, null, 6, null);
            }
        }, false, false, false, false, 1920, null);
    }

    public final void sendEvent$sdk_release(@NotNull String name, @Nullable JSONObject metadata, @NotNull RadarSendEventApiCallback callback) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        String publishableKey = RadarSettings.INSTANCE.getPublishableKey$sdk_release(this.context);
        if (publishableKey == null) {
            RadarSendEventApiCallback.DefaultImpls.onComplete$default(callback, Radar.RadarStatus.ERROR_PUBLISHABLE_KEY, null, null, 6, null);
            return;
        }
        JSONObject params = new JSONObject();
        try {
            params.putOpt("id", (Object)RadarSettings.INSTANCE.getId$sdk_release(this.context));
            params.putOpt("installId", (Object)RadarSettings.INSTANCE.getInstallId$sdk_release(this.context));
            params.putOpt("userId", (Object)RadarSettings.INSTANCE.getUserId$sdk_release(this.context));
            params.putOpt("deviceId", (Object)RadarUtils.INSTANCE.getDeviceId$sdk_release(this.context));
            params.putOpt("type", (Object)name);
            params.putOpt("metadata", (Object)metadata);
        }
        catch (JSONException e) {
            RadarSendEventApiCallback.DefaultImpls.onComplete$default(callback, Radar.RadarStatus.ERROR_BAD_REQUEST, null, null, 6, null);
            return;
        }
        String path = "v1/events";
        Map<String, String> headers = this.headers(publishableKey);
        RadarApiHelper.request$sdk_release$default(this.apiHelper, this.context, "POST", path, headers, params, false, new RadarApiHelper.RadarApiCallback(callback){
            final /* synthetic */ RadarSendEventApiCallback $callback;
            {
                this.$callback = $callback;
            }

            public void onComplete(@NotNull Radar.RadarStatus status, @Nullable JSONObject res) {
                RadarEvent conversionEvent;
                RadarEvent radarEvent;
                Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
                if (status != Radar.RadarStatus.SUCCESS || res == null) {
                    RadarSendEventApiCallback.DefaultImpls.onComplete$default(this.$callback, status, null, null, 6, null);
                    return;
                }
                JSONObject jSONObject = res.optJSONObject("event");
                if (jSONObject != null) {
                    JSONObject eventObj = jSONObject;
                    boolean bl = false;
                    radarEvent = RadarEvent.Companion.fromJson(eventObj);
                } else {
                    radarEvent = conversionEvent = null;
                }
                if (conversionEvent == null) {
                    RadarSendEventApiCallback.DefaultImpls.onComplete$default(this.$callback, Radar.RadarStatus.ERROR_SERVER, null, null, 6, null);
                    return;
                }
                this.$callback.onComplete(Radar.RadarStatus.SUCCESS, res, conversionEvent);
            }
        }, false, false, false, false, 1920, null);
    }

    public static final /* synthetic */ Context access$getContext$p(RadarApiClient $this) {
        return $this.context;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001Ji\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0010\b\u0002\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0010\b\u0002\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\t2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012H&\u00a2\u0006\u0002\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lio/radar/sdk/RadarApiClient$RadarTrackApiCallback;", "", "onComplete", "", "status", "Lio/radar/sdk/Radar$RadarStatus;", "res", "Lorg/json/JSONObject;", "events", "", "Lio/radar/sdk/model/RadarEvent;", "user", "Lio/radar/sdk/model/RadarUser;", "nearbyGeofences", "Lio/radar/sdk/model/RadarGeofence;", "config", "Lio/radar/sdk/model/RadarConfig;", "token", "Lio/radar/sdk/model/RadarVerifiedLocationToken;", "(Lio/radar/sdk/Radar$RadarStatus;Lorg/json/JSONObject;[Lio/radar/sdk/model/RadarEvent;Lio/radar/sdk/model/RadarUser;[Lio/radar/sdk/model/RadarGeofence;Lio/radar/sdk/model/RadarConfig;Lio/radar/sdk/model/RadarVerifiedLocationToken;)V", "sdk_release"})
    public static interface RadarTrackApiCallback {
        public void onComplete(@NotNull Radar.RadarStatus var1, @Nullable JSONObject var2, @Nullable RadarEvent[] var3, @Nullable RadarUser var4, @Nullable RadarGeofence[] var5, @Nullable RadarConfig var6, @Nullable RadarVerifiedLocationToken var7);

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            public static /* synthetic */ void onComplete$default(RadarTrackApiCallback radarTrackApiCallback, Radar.RadarStatus radarStatus, JSONObject jSONObject, RadarEvent[] radarEventArray, RadarUser radarUser, RadarGeofence[] radarGeofenceArray, RadarConfig radarConfig, RadarVerifiedLocationToken radarVerifiedLocationToken, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: onComplete");
                }
                if ((n & 2) != 0) {
                    jSONObject = null;
                }
                if ((n & 4) != 0) {
                    radarEventArray = null;
                }
                if ((n & 8) != 0) {
                    radarUser = null;
                }
                if ((n & 0x10) != 0) {
                    radarGeofenceArray = null;
                }
                if ((n & 0x20) != 0) {
                    radarConfig = null;
                }
                if ((n & 0x40) != 0) {
                    radarVerifiedLocationToken = null;
                }
                radarTrackApiCallback.onComplete(radarStatus, jSONObject, radarEventArray, radarUser, radarGeofenceArray, radarConfig, radarVerifiedLocationToken);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Lio/radar/sdk/RadarApiClient$RadarGetConfigApiCallback;", "", "onComplete", "", "status", "Lio/radar/sdk/Radar$RadarStatus;", "config", "Lio/radar/sdk/model/RadarConfig;", "sdk_release"})
    public static interface RadarGetConfigApiCallback {
        public void onComplete(@NotNull Radar.RadarStatus var1, @NotNull RadarConfig var2);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J?\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bH&\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lio/radar/sdk/RadarApiClient$RadarTripApiCallback;", "", "onComplete", "", "status", "Lio/radar/sdk/Radar$RadarStatus;", "res", "Lorg/json/JSONObject;", "trip", "Lio/radar/sdk/model/RadarTrip;", "events", "", "Lio/radar/sdk/model/RadarEvent;", "(Lio/radar/sdk/Radar$RadarStatus;Lorg/json/JSONObject;Lio/radar/sdk/model/RadarTrip;[Lio/radar/sdk/model/RadarEvent;)V", "sdk_release"})
    public static interface RadarTripApiCallback {
        public void onComplete(@NotNull Radar.RadarStatus var1, @Nullable JSONObject var2, @Nullable RadarTrip var3, @Nullable RadarEvent[] var4);

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            public static /* synthetic */ void onComplete$default(RadarTripApiCallback radarTripApiCallback, Radar.RadarStatus radarStatus, JSONObject jSONObject, RadarTrip radarTrip, RadarEvent[] radarEventArray, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: onComplete");
                }
                if ((n & 2) != 0) {
                    jSONObject = null;
                }
                if ((n & 4) != 0) {
                    radarTrip = null;
                }
                if ((n & 8) != 0) {
                    radarEventArray = null;
                }
                radarTripApiCallback.onComplete(radarStatus, jSONObject, radarTrip, radarEventArray);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J(\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH&\u00a8\u0006\n"}, d2={"Lio/radar/sdk/RadarApiClient$RadarContextApiCallback;", "", "onComplete", "", "status", "Lio/radar/sdk/Radar$RadarStatus;", "res", "Lorg/json/JSONObject;", "context", "Lio/radar/sdk/model/RadarContext;", "sdk_release"})
    public static interface RadarContextApiCallback {
        public void onComplete(@NotNull Radar.RadarStatus var1, @Nullable JSONObject var2, @Nullable RadarContext var3);

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            public static /* synthetic */ void onComplete$default(RadarContextApiCallback radarContextApiCallback, Radar.RadarStatus radarStatus, JSONObject jSONObject, RadarContext radarContext, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: onComplete");
                }
                if ((n & 2) != 0) {
                    jSONObject = null;
                }
                if ((n & 4) != 0) {
                    radarContext = null;
                }
                radarContextApiCallback.onComplete(radarStatus, jSONObject, radarContext);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J3\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0010\b\u0002\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tH&\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lio/radar/sdk/RadarApiClient$RadarSearchPlacesApiCallback;", "", "onComplete", "", "status", "Lio/radar/sdk/Radar$RadarStatus;", "res", "Lorg/json/JSONObject;", "places", "", "Lio/radar/sdk/model/RadarPlace;", "(Lio/radar/sdk/Radar$RadarStatus;Lorg/json/JSONObject;[Lio/radar/sdk/model/RadarPlace;)V", "sdk_release"})
    public static interface RadarSearchPlacesApiCallback {
        public void onComplete(@NotNull Radar.RadarStatus var1, @Nullable JSONObject var2, @Nullable RadarPlace[] var3);

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            public static /* synthetic */ void onComplete$default(RadarSearchPlacesApiCallback radarSearchPlacesApiCallback, Radar.RadarStatus radarStatus, JSONObject jSONObject, RadarPlace[] radarPlaceArray, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: onComplete");
                }
                if ((n & 2) != 0) {
                    jSONObject = null;
                }
                if ((n & 4) != 0) {
                    radarPlaceArray = null;
                }
                radarSearchPlacesApiCallback.onComplete(radarStatus, jSONObject, radarPlaceArray);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J3\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0010\b\u0002\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tH&\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lio/radar/sdk/RadarApiClient$RadarSearchGeofencesApiCallback;", "", "onComplete", "", "status", "Lio/radar/sdk/Radar$RadarStatus;", "res", "Lorg/json/JSONObject;", "geofences", "", "Lio/radar/sdk/model/RadarGeofence;", "(Lio/radar/sdk/Radar$RadarStatus;Lorg/json/JSONObject;[Lio/radar/sdk/model/RadarGeofence;)V", "sdk_release"})
    public static interface RadarSearchGeofencesApiCallback {
        public void onComplete(@NotNull Radar.RadarStatus var1, @Nullable JSONObject var2, @Nullable RadarGeofence[] var3);

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            public static /* synthetic */ void onComplete$default(RadarSearchGeofencesApiCallback radarSearchGeofencesApiCallback, Radar.RadarStatus radarStatus, JSONObject jSONObject, RadarGeofence[] radarGeofenceArray, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: onComplete");
                }
                if ((n & 2) != 0) {
                    jSONObject = null;
                }
                if ((n & 4) != 0) {
                    radarGeofenceArray = null;
                }
                radarSearchGeofencesApiCallback.onComplete(radarStatus, jSONObject, radarGeofenceArray);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001JW\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0010\b\u0002\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0010\b\u0002\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\t2\u0010\b\u0002\u0010\r\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\tH&\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lio/radar/sdk/RadarApiClient$RadarSearchBeaconsApiCallback;", "", "onComplete", "", "status", "Lio/radar/sdk/Radar$RadarStatus;", "res", "Lorg/json/JSONObject;", "beacons", "", "Lio/radar/sdk/model/RadarBeacon;", "uuids", "", "uids", "(Lio/radar/sdk/Radar$RadarStatus;Lorg/json/JSONObject;[Lio/radar/sdk/model/RadarBeacon;[Ljava/lang/String;[Ljava/lang/String;)V", "sdk_release"})
    public static interface RadarSearchBeaconsApiCallback {
        public void onComplete(@NotNull Radar.RadarStatus var1, @Nullable JSONObject var2, @Nullable RadarBeacon[] var3, @Nullable String[] var4, @Nullable String[] var5);

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            public static /* synthetic */ void onComplete$default(RadarSearchBeaconsApiCallback radarSearchBeaconsApiCallback, Radar.RadarStatus radarStatus, JSONObject jSONObject, RadarBeacon[] radarBeaconArray, String[] stringArray, String[] stringArray2, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: onComplete");
                }
                if ((n & 2) != 0) {
                    jSONObject = null;
                }
                if ((n & 4) != 0) {
                    radarBeaconArray = null;
                }
                if ((n & 8) != 0) {
                    stringArray = null;
                }
                if ((n & 0x10) != 0) {
                    stringArray2 = null;
                }
                radarSearchBeaconsApiCallback.onComplete(radarStatus, jSONObject, radarBeaconArray, stringArray, stringArray2);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J4\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bH&\u00a8\u0006\f"}, d2={"Lio/radar/sdk/RadarApiClient$RadarValidateAddressAPICallback;", "", "onComplete", "", "status", "Lio/radar/sdk/Radar$RadarStatus;", "res", "Lorg/json/JSONObject;", "address", "Lio/radar/sdk/model/RadarAddress;", "verificationStatus", "Lio/radar/sdk/Radar$RadarAddressVerificationStatus;", "sdk_release"})
    public static interface RadarValidateAddressAPICallback {
        public void onComplete(@NotNull Radar.RadarStatus var1, @Nullable JSONObject var2, @Nullable RadarAddress var3, @Nullable Radar.RadarAddressVerificationStatus var4);

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            public static /* synthetic */ void onComplete$default(RadarValidateAddressAPICallback radarValidateAddressAPICallback, Radar.RadarStatus radarStatus, JSONObject jSONObject, RadarAddress radarAddress, Radar.RadarAddressVerificationStatus radarAddressVerificationStatus, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: onComplete");
                }
                if ((n & 2) != 0) {
                    jSONObject = null;
                }
                if ((n & 4) != 0) {
                    radarAddress = null;
                }
                if ((n & 8) != 0) {
                    radarAddressVerificationStatus = null;
                }
                radarValidateAddressAPICallback.onComplete(radarStatus, jSONObject, radarAddress, radarAddressVerificationStatus);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J3\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0010\b\u0002\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tH&\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lio/radar/sdk/RadarApiClient$RadarGeocodeApiCallback;", "", "onComplete", "", "status", "Lio/radar/sdk/Radar$RadarStatus;", "res", "Lorg/json/JSONObject;", "addresses", "", "Lio/radar/sdk/model/RadarAddress;", "(Lio/radar/sdk/Radar$RadarStatus;Lorg/json/JSONObject;[Lio/radar/sdk/model/RadarAddress;)V", "sdk_release"})
    public static interface RadarGeocodeApiCallback {
        public void onComplete(@NotNull Radar.RadarStatus var1, @Nullable JSONObject var2, @Nullable RadarAddress[] var3);

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            public static /* synthetic */ void onComplete$default(RadarGeocodeApiCallback radarGeocodeApiCallback, Radar.RadarStatus radarStatus, JSONObject jSONObject, RadarAddress[] radarAddressArray, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: onComplete");
                }
                if ((n & 2) != 0) {
                    jSONObject = null;
                }
                if ((n & 4) != 0) {
                    radarAddressArray = null;
                }
                radarGeocodeApiCallback.onComplete(radarStatus, jSONObject, radarAddressArray);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\bf\u0018\u00002\u00020\u0001J2\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH&\u00a8\u0006\f"}, d2={"Lio/radar/sdk/RadarApiClient$RadarIpGeocodeApiCallback;", "", "onComplete", "", "status", "Lio/radar/sdk/Radar$RadarStatus;", "res", "Lorg/json/JSONObject;", "address", "Lio/radar/sdk/model/RadarAddress;", "proxy", "", "sdk_release"})
    public static interface RadarIpGeocodeApiCallback {
        public void onComplete(@NotNull Radar.RadarStatus var1, @Nullable JSONObject var2, @Nullable RadarAddress var3, boolean var4);

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            public static /* synthetic */ void onComplete$default(RadarIpGeocodeApiCallback radarIpGeocodeApiCallback, Radar.RadarStatus radarStatus, JSONObject jSONObject, RadarAddress radarAddress, boolean bl, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: onComplete");
                }
                if ((n & 2) != 0) {
                    jSONObject = null;
                }
                if ((n & 4) != 0) {
                    radarAddress = null;
                }
                if ((n & 8) != 0) {
                    bl = false;
                }
                radarIpGeocodeApiCallback.onComplete(radarStatus, jSONObject, radarAddress, bl);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J(\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH&\u00a8\u0006\n"}, d2={"Lio/radar/sdk/RadarApiClient$RadarDistanceApiCallback;", "", "onComplete", "", "status", "Lio/radar/sdk/Radar$RadarStatus;", "res", "Lorg/json/JSONObject;", "routes", "Lio/radar/sdk/model/RadarRoutes;", "sdk_release"})
    public static interface RadarDistanceApiCallback {
        public void onComplete(@NotNull Radar.RadarStatus var1, @Nullable JSONObject var2, @Nullable RadarRoutes var3);

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            public static /* synthetic */ void onComplete$default(RadarDistanceApiCallback radarDistanceApiCallback, Radar.RadarStatus radarStatus, JSONObject jSONObject, RadarRoutes radarRoutes, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: onComplete");
                }
                if ((n & 2) != 0) {
                    jSONObject = null;
                }
                if ((n & 4) != 0) {
                    radarRoutes = null;
                }
                radarDistanceApiCallback.onComplete(radarStatus, jSONObject, radarRoutes);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J(\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH&\u00a8\u0006\n"}, d2={"Lio/radar/sdk/RadarApiClient$RadarMatrixApiCallback;", "", "onComplete", "", "status", "Lio/radar/sdk/Radar$RadarStatus;", "res", "Lorg/json/JSONObject;", "matrix", "Lio/radar/sdk/model/RadarRouteMatrix;", "sdk_release"})
    public static interface RadarMatrixApiCallback {
        public void onComplete(@NotNull Radar.RadarStatus var1, @Nullable JSONObject var2, @Nullable RadarRouteMatrix var3);

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            public static /* synthetic */ void onComplete$default(RadarMatrixApiCallback radarMatrixApiCallback, Radar.RadarStatus radarStatus, JSONObject jSONObject, RadarRouteMatrix radarRouteMatrix, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: onComplete");
                }
                if ((n & 2) != 0) {
                    jSONObject = null;
                }
                if ((n & 4) != 0) {
                    radarRouteMatrix = null;
                }
                radarMatrixApiCallback.onComplete(radarStatus, jSONObject, radarRouteMatrix);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J(\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH&\u00a8\u0006\n"}, d2={"Lio/radar/sdk/RadarApiClient$RadarSendEventApiCallback;", "", "onComplete", "", "status", "Lio/radar/sdk/Radar$RadarStatus;", "res", "Lorg/json/JSONObject;", "event", "Lio/radar/sdk/model/RadarEvent;", "sdk_release"})
    public static interface RadarSendEventApiCallback {
        public void onComplete(@NotNull Radar.RadarStatus var1, @Nullable JSONObject var2, @Nullable RadarEvent var3);

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            public static /* synthetic */ void onComplete$default(RadarSendEventApiCallback radarSendEventApiCallback, Radar.RadarStatus radarStatus, JSONObject jSONObject, RadarEvent radarEvent, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: onComplete");
                }
                if ((n & 2) != 0) {
                    jSONObject = null;
                }
                if ((n & 4) != 0) {
                    radarEvent = null;
                }
                radarSendEventApiCallback.onComplete(radarStatus, jSONObject, radarEvent);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b`\u0018\u00002\u00020\u0001J\u001c\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00a8\u0006\b"}, d2={"Lio/radar/sdk/RadarApiClient$RadarLogCallback;", "", "onComplete", "", "status", "Lio/radar/sdk/Radar$RadarStatus;", "res", "Lorg/json/JSONObject;", "sdk_release"})
    public static interface RadarLogCallback {
        public void onComplete(@NotNull Radar.RadarStatus var1, @Nullable JSONObject var2);

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            public static /* synthetic */ void onComplete$default(RadarLogCallback radarLogCallback, Radar.RadarStatus radarStatus, JSONObject jSONObject, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: onComplete");
                }
                if ((n & 2) != 0) {
                    jSONObject = null;
                }
                radarLogCallback.onComplete(radarStatus, jSONObject);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b`\u0018\u00002\u00020\u0001J\u001c\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00a8\u0006\b"}, d2={"Lio/radar/sdk/RadarApiClient$RadarReplayApiCallback;", "", "onComplete", "", "status", "Lio/radar/sdk/Radar$RadarStatus;", "res", "Lorg/json/JSONObject;", "sdk_release"})
    public static interface RadarReplayApiCallback {
        public void onComplete(@NotNull Radar.RadarStatus var1, @Nullable JSONObject var2);

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            public static /* synthetic */ void onComplete$default(RadarReplayApiCallback radarReplayApiCallback, Radar.RadarStatus radarStatus, JSONObject jSONObject, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: onComplete");
                }
                if ((n & 2) != 0) {
                    jSONObject = null;
                }
                radarReplayApiCallback.onComplete(radarStatus, jSONObject);
            }
        }
    }
}

