/*
 * Decompiled with CFR 0.152.
 */
package io.radar.sdk.model;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import androidx.core.app.ActivityCompat;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 &2\u00020\u0001:\u0002&'B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010$\u001a\u00020%R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001a\u0010\f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u0006\"\u0004\b\u000e\u0010\bR\u001a\u0010\u000f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0006\"\u0004\b\u0011\u0010\bR\u001a\u0010\u0012\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0006\"\u0004\b\u0014\u0010\bR\u001a\u0010\u0015\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0006\"\u0004\b\u0017\u0010\bR\u001a\u0010\u0018\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0006\"\u0004\b\u001a\u0010\bR\u001a\u0010\u001b\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0006\"\u0004\b\u001d\u0010\bR\u001a\u0010\u001e\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#\u00a8\u0006("}, d2={"Lio/radar/sdk/model/RadarLocationPermissionStatus;", "", "()V", "approximatePermissionResult", "", "getApproximatePermissionResult", "()Z", "setApproximatePermissionResult", "(Z)V", "backgroundPermissionResult", "getBackgroundPermissionResult", "setBackgroundPermissionResult", "foregroundPermissionResult", "getForegroundPermissionResult", "setForegroundPermissionResult", "inLocationPopup", "getInLocationPopup", "setInLocationPopup", "previouslyDeniedBackground", "getPreviouslyDeniedBackground", "setPreviouslyDeniedBackground", "previouslyDeniedForeground", "getPreviouslyDeniedForeground", "setPreviouslyDeniedForeground", "shouldShowRequestPermissionRationaleBG", "getShouldShowRequestPermissionRationaleBG", "setShouldShowRequestPermissionRationaleBG", "shouldShowRequestPermissionRationaleFG", "getShouldShowRequestPermissionRationaleFG", "setShouldShowRequestPermissionRationaleFG", "status", "Lio/radar/sdk/model/RadarLocationPermissionStatus$LocationPermissionState;", "getStatus", "()Lio/radar/sdk/model/RadarLocationPermissionStatus$LocationPermissionState;", "setStatus", "(Lio/radar/sdk/model/RadarLocationPermissionStatus$LocationPermissionState;)V", "toJson", "Lorg/json/JSONObject;", "Companion", "LocationPermissionState", "sdk_release"})
public final class RadarLocationPermissionStatus {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private LocationPermissionState status = LocationPermissionState.UNKNOWN;
    private boolean foregroundPermissionResult;
    private boolean backgroundPermissionResult;
    private boolean shouldShowRequestPermissionRationaleFG;
    private boolean shouldShowRequestPermissionRationaleBG;
    private boolean previouslyDeniedForeground;
    private boolean inLocationPopup;
    private boolean approximatePermissionResult;
    private boolean previouslyDeniedBackground;
    @NotNull
    private static final String PREFS_NAME = "RadarLocationPermissionStatus";
    @NotNull
    public static final String KEY_STATUS = "status";
    @NotNull
    public static final String KEY_FOREGROUND_PERMISSION_RESULT = "foregroundPermissionResult";
    @NotNull
    public static final String KEY_BACKGROUND_PERMISSION_RESULT = "backgroundPermissionResult";
    @NotNull
    public static final String KEY_SHOULD_SHOW_REQUEST_PERMISSION_RATIONALE_FG = "shouldShowRequestPermissionRationale";
    @NotNull
    public static final String KEY_PREVIOUSLY_DENIED_FOREGROUND = "previouslyDeniedForeground";
    @NotNull
    public static final String KEY_PREVIOUSLY_DENIED_BACKGROUND = "previouslyDeniedBackground";
    @NotNull
    public static final String KEY_APPROXIMATE_PERMISSION_REQUEST = "approximatePermissionRequest";
    @NotNull
    public static final String KEY_SHOULD_SHOW_REQUEST_PERMISSION_RATIONALE_BG = "backgroundPermissionAvailable";
    @NotNull
    public static final String KEY_IN_LOCATION_POPUP = "inLocationPopup";

    @NotNull
    public final JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(KEY_STATUS, (Object)this.status.name());
        jsonObject.put(KEY_FOREGROUND_PERMISSION_RESULT, this.foregroundPermissionResult);
        jsonObject.put(KEY_BACKGROUND_PERMISSION_RESULT, this.backgroundPermissionResult);
        jsonObject.put(KEY_SHOULD_SHOW_REQUEST_PERMISSION_RATIONALE_FG, this.shouldShowRequestPermissionRationaleFG);
        jsonObject.put(KEY_PREVIOUSLY_DENIED_FOREGROUND, this.previouslyDeniedForeground);
        jsonObject.put(KEY_APPROXIMATE_PERMISSION_REQUEST, this.approximatePermissionResult);
        jsonObject.put(KEY_SHOULD_SHOW_REQUEST_PERMISSION_RATIONALE_BG, this.shouldShowRequestPermissionRationaleBG);
        jsonObject.put(KEY_PREVIOUSLY_DENIED_BACKGROUND, this.previouslyDeniedBackground);
        jsonObject.put(KEY_IN_LOCATION_POPUP, this.inLocationPopup);
        return jsonObject;
    }

    @NotNull
    public final LocationPermissionState getStatus() {
        return this.status;
    }

    public final void setStatus(@NotNull LocationPermissionState locationPermissionState) {
        Intrinsics.checkNotNullParameter((Object)((Object)locationPermissionState), (String)"<set-?>");
        this.status = locationPermissionState;
    }

    public final boolean getForegroundPermissionResult() {
        return this.foregroundPermissionResult;
    }

    public final void setForegroundPermissionResult(boolean bl) {
        this.foregroundPermissionResult = bl;
    }

    public final boolean getBackgroundPermissionResult() {
        return this.backgroundPermissionResult;
    }

    public final void setBackgroundPermissionResult(boolean bl) {
        this.backgroundPermissionResult = bl;
    }

    public final boolean getShouldShowRequestPermissionRationaleFG() {
        return this.shouldShowRequestPermissionRationaleFG;
    }

    public final void setShouldShowRequestPermissionRationaleFG(boolean bl) {
        this.shouldShowRequestPermissionRationaleFG = bl;
    }

    public final boolean getShouldShowRequestPermissionRationaleBG() {
        return this.shouldShowRequestPermissionRationaleBG;
    }

    public final void setShouldShowRequestPermissionRationaleBG(boolean bl) {
        this.shouldShowRequestPermissionRationaleBG = bl;
    }

    public final boolean getPreviouslyDeniedForeground() {
        return this.previouslyDeniedForeground;
    }

    public final void setPreviouslyDeniedForeground(boolean bl) {
        this.previouslyDeniedForeground = bl;
    }

    public final boolean getInLocationPopup() {
        return this.inLocationPopup;
    }

    public final void setInLocationPopup(boolean bl) {
        this.inLocationPopup = bl;
    }

    public final boolean getApproximatePermissionResult() {
        return this.approximatePermissionResult;
    }

    public final void setApproximatePermissionResult(boolean bl) {
        this.approximatePermissionResult = bl;
    }

    public final boolean getPreviouslyDeniedBackground() {
        return this.previouslyDeniedBackground;
    }

    public final void setPreviouslyDeniedBackground(boolean bl) {
        this.previouslyDeniedBackground = bl;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000fH\u0002J\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u0015J\u0016\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u0015J\u000e\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lio/radar/sdk/model/RadarLocationPermissionStatus$Companion;", "", "()V", "KEY_APPROXIMATE_PERMISSION_REQUEST", "", "KEY_BACKGROUND_PERMISSION_RESULT", "KEY_FOREGROUND_PERMISSION_RESULT", "KEY_IN_LOCATION_POPUP", "KEY_PREVIOUSLY_DENIED_BACKGROUND", "KEY_PREVIOUSLY_DENIED_FOREGROUND", "KEY_SHOULD_SHOW_REQUEST_PERMISSION_RATIONALE_BG", "KEY_SHOULD_SHOW_REQUEST_PERMISSION_RATIONALE_FG", "KEY_STATUS", "PREFS_NAME", "initWithStatus", "Lio/radar/sdk/model/RadarLocationPermissionStatus;", "context", "Landroid/content/Context;", "activity", "Landroid/app/Activity;", "inLocationPopup", "", "locationPermissionStateForLocationManagerStatus", "Lio/radar/sdk/model/RadarLocationPermissionStatus$LocationPermissionState;", "status", "savePreviouslyDeniedBackground", "", "previouslyDeniedBackground", "savePreviouslyDeniedForeground", "previouslyDeniedForeground", "stringForLocationPermissionState", "state", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RadarLocationPermissionStatus initWithStatus(@NotNull Context context, @NotNull Activity activity, boolean inLocationPopup) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            RadarLocationPermissionStatus newStatus = new RadarLocationPermissionStatus();
            newStatus.setForegroundPermissionResult(ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_FINE_LOCATION") == 0);
            newStatus.setApproximatePermissionResult(ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_COARSE_LOCATION") == 0);
            if (Build.VERSION.SDK_INT >= 29) {
                newStatus.setBackgroundPermissionResult(ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_BACKGROUND_LOCATION") == 0);
            } else {
                newStatus.setBackgroundPermissionResult(false);
            }
            newStatus.setShouldShowRequestPermissionRationaleFG(ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, (String)"android.permission.ACCESS_FINE_LOCATION"));
            newStatus.setShouldShowRequestPermissionRationaleBG(Build.VERSION.SDK_INT >= 29 ? ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, (String)"android.permission.ACCESS_BACKGROUND_LOCATION") : false);
            SharedPreferences sharedPreferences = context.getSharedPreferences(RadarLocationPermissionStatus.PREFS_NAME, 0);
            Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"context.getSharedPrefere\u2026ME, Context.MODE_PRIVATE)");
            SharedPreferences prefs = sharedPreferences;
            if (newStatus.getForegroundPermissionResult()) {
                this.savePreviouslyDeniedForeground(context, false);
            }
            newStatus.setPreviouslyDeniedForeground(prefs.getBoolean(RadarLocationPermissionStatus.KEY_FOREGROUND_PERMISSION_RESULT, false));
            if (newStatus.getBackgroundPermissionResult()) {
                this.savePreviouslyDeniedBackground(context, false);
            }
            newStatus.setPreviouslyDeniedBackground(prefs.getBoolean(RadarLocationPermissionStatus.KEY_PREVIOUSLY_DENIED_BACKGROUND, false));
            newStatus.setInLocationPopup(inLocationPopup);
            newStatus.setStatus(this.locationPermissionStateForLocationManagerStatus(newStatus));
            return newStatus;
        }

        public static /* synthetic */ RadarLocationPermissionStatus initWithStatus$default(Companion companion, Context context, Activity activity, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            return companion.initWithStatus(context, activity, bl);
        }

        public final void savePreviouslyDeniedForeground(@NotNull Context context, boolean previouslyDeniedForeground) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            SharedPreferences sharedPreferences = context.getSharedPreferences(RadarLocationPermissionStatus.PREFS_NAME, 0);
            Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"context.getSharedPrefere\u2026ME, Context.MODE_PRIVATE)");
            SharedPreferences prefs = sharedPreferences;
            SharedPreferences.Editor editor = prefs.edit();
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"prefs.edit()");
            SharedPreferences.Editor editor2 = editor;
            editor2.putBoolean(RadarLocationPermissionStatus.KEY_FOREGROUND_PERMISSION_RESULT, previouslyDeniedForeground);
            editor2.apply();
        }

        public final void savePreviouslyDeniedBackground(@NotNull Context context, boolean previouslyDeniedBackground) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            SharedPreferences sharedPreferences = context.getSharedPreferences(RadarLocationPermissionStatus.PREFS_NAME, 0);
            Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"context.getSharedPrefere\u2026ME, Context.MODE_PRIVATE)");
            SharedPreferences prefs = sharedPreferences;
            SharedPreferences.Editor editor = prefs.edit();
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"prefs.edit()");
            SharedPreferences.Editor editor2 = editor;
            editor2.putBoolean(RadarLocationPermissionStatus.KEY_PREVIOUSLY_DENIED_BACKGROUND, previouslyDeniedBackground);
            editor2.apply();
        }

        private final LocationPermissionState locationPermissionStateForLocationManagerStatus(RadarLocationPermissionStatus status) {
            if (status.getBackgroundPermissionResult()) {
                return LocationPermissionState.BACKGROUND_PERMISSION_GRANTED;
            }
            if (status.getPreviouslyDeniedBackground() && status.getForegroundPermissionResult()) {
                return status.getShouldShowRequestPermissionRationaleBG() ? LocationPermissionState.BACKGROUND_PERMISSION_REJECTED_ONCE : LocationPermissionState.BACKGROUND_PERMISSION_REJECTED;
            }
            if (status.getForegroundPermissionResult()) {
                return LocationPermissionState.FOREGROUND_PERMISSION_GRANTED;
            }
            if (status.getInLocationPopup()) {
                return LocationPermissionState.FOREGROUND_PERMISSION_PENDING;
            }
            if (status.getApproximatePermissionResult()) {
                return LocationPermissionState.APPROXIMATE_PERMISSION_GRANTED;
            }
            return status.getShouldShowRequestPermissionRationaleFG() ? LocationPermissionState.FOREGROUND_PERMISSION_REJECTED_ONCE : (status.getPreviouslyDeniedForeground() ? LocationPermissionState.FOREGROUND_PERMISSION_REJECTED : LocationPermissionState.NO_PERMISSION_GRANTED);
        }

        @NotNull
        public final String stringForLocationPermissionState(@NotNull LocationPermissionState state) {
            String string;
            Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
            switch (WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
                case 1: {
                    string = "NO_PERMISSION_GRANTED";
                    break;
                }
                case 2: {
                    string = "FOREGROUND_PERMISSION_GRANTED";
                    break;
                }
                case 3: {
                    string = "APPROXIMATE_PERMISSION_GRANTED";
                    break;
                }
                case 4: {
                    string = "FOREGROUND_PERMISSION_REJECTED_ONCE";
                    break;
                }
                case 5: {
                    string = "FOREGROUND_PERMISSION_REJECTED";
                    break;
                }
                case 6: {
                    string = "FOREGROUND_PERMISSION_PENDING";
                    break;
                }
                case 7: {
                    string = "BACKGROUND_PERMISSION_GRANTED";
                    break;
                }
                case 8: {
                    string = "BACKGROUND_PERMISSION_REJECTED";
                    break;
                }
                case 9: {
                    string = "BACKGROUND_PERMISSION_REJECTED_ONCE";
                    break;
                }
                case 10: {
                    string = "UNKNOWN";
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[LocationPermissionState.values().length];
                nArray[LocationPermissionState.NO_PERMISSION_GRANTED.ordinal()] = 1;
                nArray[LocationPermissionState.FOREGROUND_PERMISSION_GRANTED.ordinal()] = 2;
                nArray[LocationPermissionState.APPROXIMATE_PERMISSION_GRANTED.ordinal()] = 3;
                nArray[LocationPermissionState.FOREGROUND_PERMISSION_REJECTED_ONCE.ordinal()] = 4;
                nArray[LocationPermissionState.FOREGROUND_PERMISSION_REJECTED.ordinal()] = 5;
                nArray[LocationPermissionState.FOREGROUND_PERMISSION_PENDING.ordinal()] = 6;
                nArray[LocationPermissionState.BACKGROUND_PERMISSION_GRANTED.ordinal()] = 7;
                nArray[LocationPermissionState.BACKGROUND_PERMISSION_REJECTED.ordinal()] = 8;
                nArray[LocationPermissionState.BACKGROUND_PERMISSION_REJECTED_ONCE.ordinal()] = 9;
                nArray[LocationPermissionState.UNKNOWN.ordinal()] = 10;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\f\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\r"}, d2={"Lio/radar/sdk/model/RadarLocationPermissionStatus$LocationPermissionState;", "", "(Ljava/lang/String;I)V", "NO_PERMISSION_GRANTED", "FOREGROUND_PERMISSION_GRANTED", "APPROXIMATE_PERMISSION_GRANTED", "FOREGROUND_PERMISSION_REJECTED_ONCE", "FOREGROUND_PERMISSION_REJECTED", "FOREGROUND_PERMISSION_PENDING", "BACKGROUND_PERMISSION_GRANTED", "BACKGROUND_PERMISSION_REJECTED", "BACKGROUND_PERMISSION_REJECTED_ONCE", "UNKNOWN", "sdk_release"})
    public static final class LocationPermissionState
    extends Enum<LocationPermissionState> {
        public static final /* enum */ LocationPermissionState NO_PERMISSION_GRANTED = new LocationPermissionState();
        public static final /* enum */ LocationPermissionState FOREGROUND_PERMISSION_GRANTED = new LocationPermissionState();
        public static final /* enum */ LocationPermissionState APPROXIMATE_PERMISSION_GRANTED = new LocationPermissionState();
        public static final /* enum */ LocationPermissionState FOREGROUND_PERMISSION_REJECTED_ONCE = new LocationPermissionState();
        public static final /* enum */ LocationPermissionState FOREGROUND_PERMISSION_REJECTED = new LocationPermissionState();
        public static final /* enum */ LocationPermissionState FOREGROUND_PERMISSION_PENDING = new LocationPermissionState();
        public static final /* enum */ LocationPermissionState BACKGROUND_PERMISSION_GRANTED = new LocationPermissionState();
        public static final /* enum */ LocationPermissionState BACKGROUND_PERMISSION_REJECTED = new LocationPermissionState();
        public static final /* enum */ LocationPermissionState BACKGROUND_PERMISSION_REJECTED_ONCE = new LocationPermissionState();
        public static final /* enum */ LocationPermissionState UNKNOWN = new LocationPermissionState();
        private static final /* synthetic */ LocationPermissionState[] $VALUES;

        public static LocationPermissionState[] values() {
            return (LocationPermissionState[])$VALUES.clone();
        }

        public static LocationPermissionState valueOf(String value) {
            return Enum.valueOf(LocationPermissionState.class, value);
        }

        static {
            $VALUES = locationPermissionStateArray = new LocationPermissionState[]{LocationPermissionState.NO_PERMISSION_GRANTED, LocationPermissionState.FOREGROUND_PERMISSION_GRANTED, LocationPermissionState.APPROXIMATE_PERMISSION_GRANTED, LocationPermissionState.FOREGROUND_PERMISSION_REJECTED_ONCE, LocationPermissionState.FOREGROUND_PERMISSION_REJECTED, LocationPermissionState.FOREGROUND_PERMISSION_PENDING, LocationPermissionState.BACKGROUND_PERMISSION_GRANTED, LocationPermissionState.BACKGROUND_PERMISSION_REJECTED, LocationPermissionState.BACKGROUND_PERMISSION_REJECTED_ONCE, LocationPermissionState.UNKNOWN};
        }
    }
}

