/*
 * Decompiled with CFR 0.152.
 */
package io.radar.sdk.model;

import android.content.Context;
import io.radar.sdk.Radar;
import io.radar.sdk.RadarApiClient;
import io.radar.sdk.RadarSettings;
import io.radar.sdk.model.RadarConfig;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0080\b\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J1\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00052\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\u0006\u0010\u0018\u001a\u00020\u0019J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u001d"}, d2={"Lio/radar/sdk/model/RadarSdkConfiguration;", "", "logLevel", "Lio/radar/sdk/Radar$RadarLogLevel;", "startTrackingOnInitialize", "", "trackOnceOnInitialize", "trackOnceOnResume", "(Lio/radar/sdk/Radar$RadarLogLevel;ZZZ)V", "getLogLevel", "()Lio/radar/sdk/Radar$RadarLogLevel;", "getStartTrackingOnInitialize", "()Z", "getTrackOnceOnInitialize", "getTrackOnceOnResume", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toJson", "Lorg/json/JSONObject;", "toString", "", "Companion", "sdk_release"})
public final class RadarSdkConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Radar.RadarLogLevel logLevel;
    private final boolean startTrackingOnInitialize;
    private final boolean trackOnceOnInitialize;
    private final boolean trackOnceOnResume;
    @NotNull
    private static final String LOG_LEVEL = "logLevel";
    @NotNull
    private static final String START_TRACKING_ON_INITIALIZE = "startTrackingOnInitialize";
    @NotNull
    private static final String TRACK_ONCE_ON_INITIALIZE = "trackOnceOnInitialize";
    @NotNull
    private static final String TRACK_ONCE_ON_RESUME = "trackOnceOnResume";

    public RadarSdkConfiguration(@NotNull Radar.RadarLogLevel logLevel, boolean startTrackingOnInitialize, boolean trackOnceOnInitialize, boolean trackOnceOnResume) {
        Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)LOG_LEVEL);
        this.logLevel = logLevel;
        this.startTrackingOnInitialize = startTrackingOnInitialize;
        this.trackOnceOnInitialize = trackOnceOnInitialize;
        this.trackOnceOnResume = trackOnceOnResume;
    }

    @NotNull
    public final Radar.RadarLogLevel getLogLevel() {
        return this.logLevel;
    }

    public final boolean getStartTrackingOnInitialize() {
        return this.startTrackingOnInitialize;
    }

    public final boolean getTrackOnceOnInitialize() {
        return this.trackOnceOnInitialize;
    }

    public final boolean getTrackOnceOnResume() {
        return this.trackOnceOnResume;
    }

    @NotNull
    public final JSONObject toJson() {
        JSONObject jSONObject;
        JSONObject $this$toJson_u24lambda_u2d0 = jSONObject = new JSONObject();
        boolean bl = false;
        String string = this.logLevel.toString().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        $this$toJson_u24lambda_u2d0.putOpt(LOG_LEVEL, (Object)string);
        $this$toJson_u24lambda_u2d0.putOpt(START_TRACKING_ON_INITIALIZE, (Object)this.startTrackingOnInitialize);
        $this$toJson_u24lambda_u2d0.putOpt(TRACK_ONCE_ON_INITIALIZE, (Object)this.trackOnceOnInitialize);
        $this$toJson_u24lambda_u2d0.putOpt(TRACK_ONCE_ON_RESUME, (Object)this.trackOnceOnResume);
        return jSONObject;
    }

    @NotNull
    public final Radar.RadarLogLevel component1() {
        return this.logLevel;
    }

    public final boolean component2() {
        return this.startTrackingOnInitialize;
    }

    public final boolean component3() {
        return this.trackOnceOnInitialize;
    }

    public final boolean component4() {
        return this.trackOnceOnResume;
    }

    @NotNull
    public final RadarSdkConfiguration copy(@NotNull Radar.RadarLogLevel logLevel, boolean startTrackingOnInitialize, boolean trackOnceOnInitialize, boolean trackOnceOnResume) {
        Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)LOG_LEVEL);
        return new RadarSdkConfiguration(logLevel, startTrackingOnInitialize, trackOnceOnInitialize, trackOnceOnResume);
    }

    public static /* synthetic */ RadarSdkConfiguration copy$default(RadarSdkConfiguration radarSdkConfiguration, Radar.RadarLogLevel radarLogLevel, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 1) != 0) {
            radarLogLevel = radarSdkConfiguration.logLevel;
        }
        if ((n & 2) != 0) {
            bl = radarSdkConfiguration.startTrackingOnInitialize;
        }
        if ((n & 4) != 0) {
            bl2 = radarSdkConfiguration.trackOnceOnInitialize;
        }
        if ((n & 8) != 0) {
            bl3 = radarSdkConfiguration.trackOnceOnResume;
        }
        return radarSdkConfiguration.copy(radarLogLevel, bl, bl2, bl3);
    }

    @NotNull
    public String toString() {
        return "RadarSdkConfiguration(logLevel=" + (Object)((Object)this.logLevel) + ", startTrackingOnInitialize=" + this.startTrackingOnInitialize + ", trackOnceOnInitialize=" + this.trackOnceOnInitialize + ", trackOnceOnResume=" + this.trackOnceOnResume + ')';
    }

    public int hashCode() {
        int result = this.logLevel.hashCode();
        int n = this.startTrackingOnInitialize ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result = result * 31 + n;
        int n2 = this.trackOnceOnInitialize ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        result = result * 31 + n2;
        int n3 = this.trackOnceOnResume ? 1 : 0;
        if (n3 != 0) {
            n3 = 1;
        }
        result = result * 31 + n3;
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RadarSdkConfiguration)) {
            return false;
        }
        RadarSdkConfiguration radarSdkConfiguration = (RadarSdkConfiguration)other;
        if (this.logLevel != radarSdkConfiguration.logLevel) {
            return false;
        }
        if (this.startTrackingOnInitialize != radarSdkConfiguration.startTrackingOnInitialize) {
            return false;
        }
        if (this.trackOnceOnInitialize != radarSdkConfiguration.trackOnceOnInitialize) {
            return false;
        }
        return this.trackOnceOnResume == radarSdkConfiguration.trackOnceOnResume;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/radar/sdk/model/RadarSdkConfiguration$Companion;", "", "()V", "LOG_LEVEL", "", "START_TRACKING_ON_INITIALIZE", "TRACK_ONCE_ON_INITIALIZE", "TRACK_ONCE_ON_RESUME", "fromJson", "Lio/radar/sdk/model/RadarSdkConfiguration;", "json", "Lorg/json/JSONObject;", "updateSdkConfigurationFromServer", "", "context", "Landroid/content/Context;", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final RadarSdkConfiguration fromJson(@Nullable JSONObject json) {
            Radar.RadarLogLevel radarLogLevel;
            if (json == null) {
                return null;
            }
            String logLevelString = json.optString(RadarSdkConfiguration.LOG_LEVEL);
            boolean startTrackingOnInitialize = json.optBoolean(RadarSdkConfiguration.START_TRACKING_ON_INITIALIZE);
            boolean trackOnceOnInitialize = json.optBoolean(RadarSdkConfiguration.TRACK_ONCE_ON_INITIALIZE);
            boolean trackOnceOnResume = json.optBoolean(RadarSdkConfiguration.TRACK_ONCE_ON_RESUME);
            CharSequence charSequence = logLevelString;
            if (!(charSequence == null || charSequence.length() == 0)) {
                Intrinsics.checkNotNullExpressionValue((Object)logLevelString, (String)"logLevelString");
                String string = logLevelString.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
                radarLogLevel = Radar.RadarLogLevel.valueOf(string);
            } else {
                radarLogLevel = Radar.RadarLogLevel.INFO;
            }
            return new RadarSdkConfiguration(radarLogLevel, startTrackingOnInitialize, trackOnceOnInitialize, trackOnceOnResume);
        }

        public final void updateSdkConfigurationFromServer(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Radar.INSTANCE.getApiClient$sdk_release().getConfig$sdk_release("sdkConfigUpdate", false, new RadarApiClient.RadarGetConfigApiCallback(context){
                final /* synthetic */ Context $context;
                {
                    this.$context = $context;
                }

                public void onComplete(@NotNull Radar.RadarStatus status, @NotNull RadarConfig config) {
                    Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
                    Intrinsics.checkNotNullParameter((Object)config, (String)"config");
                    RadarSettings.INSTANCE.setSdkConfiguration(this.$context, config.getMeta().getSdkConfiguration());
                }
            });
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

