/*
 * Decompiled with CFR 0.152.
 */
package io.radar.sdk.model;

import android.content.Context;
import io.radar.sdk.Radar;
import io.radar.sdk.RadarApiClient;
import io.radar.sdk.RadarSettings;
import io.radar.sdk.model.RadarConfig;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u001d\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0080\b\u0018\u0000 ,2\u00020\u0001:\u0001,BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u0005\u0012\u0006\u0010\r\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010 \u001a\u00020\u0005H\u00c6\u0003J\t\u0010!\u001a\u00020\u000bH\u00c6\u0003J\t\u0010\"\u001a\u00020\u0005H\u00c6\u0003J\t\u0010#\u001a\u00020\u0005H\u00c6\u0003Jc\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\u00052\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u00052\b\b\u0002\u0010\r\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010%\u001a\u00020\u00052\b\u0010&\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010'\u001a\u00020\u0003H\u00d6\u0001J\u0006\u0010(\u001a\u00020)J\t\u0010*\u001a\u00020+H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010R\u0011\u0010\r\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0010R\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0010\u00a8\u0006-"}, d2={"Lio/radar/sdk/model/RadarSdkConfiguration;", "", "maxConcurrentJobs", "", "schedulerRequiresNetwork", "", "usePersistence", "extendFlushReplays", "useLogPersistence", "useRadarModifiedBeacon", "logLevel", "Lio/radar/sdk/Radar$RadarLogLevel;", "startTrackingOnInitialize", "trackOnceOnAppOpen", "(IZZZZZLio/radar/sdk/Radar$RadarLogLevel;ZZ)V", "getExtendFlushReplays", "()Z", "getLogLevel", "()Lio/radar/sdk/Radar$RadarLogLevel;", "getMaxConcurrentJobs", "()I", "getSchedulerRequiresNetwork", "getStartTrackingOnInitialize", "getTrackOnceOnAppOpen", "getUseLogPersistence", "getUsePersistence", "getUseRadarModifiedBeacon", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "hashCode", "toJson", "Lorg/json/JSONObject;", "toString", "", "Companion", "sdk_release"})
public final class RadarSdkConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int maxConcurrentJobs;
    private final boolean schedulerRequiresNetwork;
    private final boolean usePersistence;
    private final boolean extendFlushReplays;
    private final boolean useLogPersistence;
    private final boolean useRadarModifiedBeacon;
    @NotNull
    private final Radar.RadarLogLevel logLevel;
    private final boolean startTrackingOnInitialize;
    private final boolean trackOnceOnAppOpen;
    @NotNull
    private static final String MAX_CONCURRENT_JOBS = "maxConcurrentJobs";
    private static final int DEFAULT_MAX_CONCURRENT_JOBS = 1;
    @NotNull
    private static final String USE_PERSISTENCE = "usePersistence";
    @NotNull
    private static final String SCHEDULER_REQUIRES_NETWORK = "networkAny";
    @NotNull
    private static final String EXTEND_FLUSH_REPLAYS = "extendFlushReplays";
    @NotNull
    private static final String USE_LOG_PERSISTENCE = "useLogPersistence";
    @NotNull
    private static final String USE_RADAR_MODIFIED_BEACON = "useRadarModifiedBeacon";
    @NotNull
    private static final String LOG_LEVEL = "logLevel";
    @NotNull
    private static final String START_TRACKING_ON_INITIALIZE = "startTrackingOnInitialize";
    @NotNull
    private static final String TRACK_ONCE_ON_APP_OPEN = "trackOnceOnAppOpen";

    public RadarSdkConfiguration(int maxConcurrentJobs, boolean schedulerRequiresNetwork, boolean usePersistence, boolean extendFlushReplays, boolean useLogPersistence, boolean useRadarModifiedBeacon, @NotNull Radar.RadarLogLevel logLevel, boolean startTrackingOnInitialize, boolean trackOnceOnAppOpen) {
        Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)LOG_LEVEL);
        this.maxConcurrentJobs = maxConcurrentJobs;
        this.schedulerRequiresNetwork = schedulerRequiresNetwork;
        this.usePersistence = usePersistence;
        this.extendFlushReplays = extendFlushReplays;
        this.useLogPersistence = useLogPersistence;
        this.useRadarModifiedBeacon = useRadarModifiedBeacon;
        this.logLevel = logLevel;
        this.startTrackingOnInitialize = startTrackingOnInitialize;
        this.trackOnceOnAppOpen = trackOnceOnAppOpen;
    }

    public final int getMaxConcurrentJobs() {
        return this.maxConcurrentJobs;
    }

    public final boolean getSchedulerRequiresNetwork() {
        return this.schedulerRequiresNetwork;
    }

    public final boolean getUsePersistence() {
        return this.usePersistence;
    }

    public final boolean getExtendFlushReplays() {
        return this.extendFlushReplays;
    }

    public final boolean getUseLogPersistence() {
        return this.useLogPersistence;
    }

    public final boolean getUseRadarModifiedBeacon() {
        return this.useRadarModifiedBeacon;
    }

    @NotNull
    public final Radar.RadarLogLevel getLogLevel() {
        return this.logLevel;
    }

    public final boolean getStartTrackingOnInitialize() {
        return this.startTrackingOnInitialize;
    }

    public final boolean getTrackOnceOnAppOpen() {
        return this.trackOnceOnAppOpen;
    }

    @NotNull
    public final JSONObject toJson() {
        JSONObject jSONObject;
        JSONObject $this$toJson_u24lambda_u2d0 = jSONObject = new JSONObject();
        boolean bl = false;
        $this$toJson_u24lambda_u2d0.putOpt(SCHEDULER_REQUIRES_NETWORK, (Object)this.schedulerRequiresNetwork);
        $this$toJson_u24lambda_u2d0.putOpt(MAX_CONCURRENT_JOBS, (Object)this.maxConcurrentJobs);
        $this$toJson_u24lambda_u2d0.putOpt(USE_PERSISTENCE, (Object)this.usePersistence);
        $this$toJson_u24lambda_u2d0.putOpt(EXTEND_FLUSH_REPLAYS, (Object)this.extendFlushReplays);
        $this$toJson_u24lambda_u2d0.putOpt(USE_LOG_PERSISTENCE, (Object)this.useLogPersistence);
        $this$toJson_u24lambda_u2d0.putOpt(USE_RADAR_MODIFIED_BEACON, (Object)this.useRadarModifiedBeacon);
        String string = this.logLevel.toString().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        $this$toJson_u24lambda_u2d0.putOpt(LOG_LEVEL, (Object)string);
        $this$toJson_u24lambda_u2d0.putOpt(START_TRACKING_ON_INITIALIZE, (Object)this.startTrackingOnInitialize);
        $this$toJson_u24lambda_u2d0.putOpt(TRACK_ONCE_ON_APP_OPEN, (Object)this.trackOnceOnAppOpen);
        return jSONObject;
    }

    public final int component1() {
        return this.maxConcurrentJobs;
    }

    public final boolean component2() {
        return this.schedulerRequiresNetwork;
    }

    public final boolean component3() {
        return this.usePersistence;
    }

    public final boolean component4() {
        return this.extendFlushReplays;
    }

    public final boolean component5() {
        return this.useLogPersistence;
    }

    public final boolean component6() {
        return this.useRadarModifiedBeacon;
    }

    @NotNull
    public final Radar.RadarLogLevel component7() {
        return this.logLevel;
    }

    public final boolean component8() {
        return this.startTrackingOnInitialize;
    }

    public final boolean component9() {
        return this.trackOnceOnAppOpen;
    }

    @NotNull
    public final RadarSdkConfiguration copy(int maxConcurrentJobs, boolean schedulerRequiresNetwork, boolean usePersistence, boolean extendFlushReplays, boolean useLogPersistence, boolean useRadarModifiedBeacon, @NotNull Radar.RadarLogLevel logLevel, boolean startTrackingOnInitialize, boolean trackOnceOnAppOpen) {
        Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)LOG_LEVEL);
        return new RadarSdkConfiguration(maxConcurrentJobs, schedulerRequiresNetwork, usePersistence, extendFlushReplays, useLogPersistence, useRadarModifiedBeacon, logLevel, startTrackingOnInitialize, trackOnceOnAppOpen);
    }

    public static /* synthetic */ RadarSdkConfiguration copy$default(RadarSdkConfiguration radarSdkConfiguration, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, Radar.RadarLogLevel radarLogLevel, boolean bl6, boolean bl7, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = radarSdkConfiguration.maxConcurrentJobs;
        }
        if ((n2 & 2) != 0) {
            bl = radarSdkConfiguration.schedulerRequiresNetwork;
        }
        if ((n2 & 4) != 0) {
            bl2 = radarSdkConfiguration.usePersistence;
        }
        if ((n2 & 8) != 0) {
            bl3 = radarSdkConfiguration.extendFlushReplays;
        }
        if ((n2 & 0x10) != 0) {
            bl4 = radarSdkConfiguration.useLogPersistence;
        }
        if ((n2 & 0x20) != 0) {
            bl5 = radarSdkConfiguration.useRadarModifiedBeacon;
        }
        if ((n2 & 0x40) != 0) {
            radarLogLevel = radarSdkConfiguration.logLevel;
        }
        if ((n2 & 0x80) != 0) {
            bl6 = radarSdkConfiguration.startTrackingOnInitialize;
        }
        if ((n2 & 0x100) != 0) {
            bl7 = radarSdkConfiguration.trackOnceOnAppOpen;
        }
        return radarSdkConfiguration.copy(n, bl, bl2, bl3, bl4, bl5, radarLogLevel, bl6, bl7);
    }

    @NotNull
    public String toString() {
        return "RadarSdkConfiguration(maxConcurrentJobs=" + this.maxConcurrentJobs + ", schedulerRequiresNetwork=" + this.schedulerRequiresNetwork + ", usePersistence=" + this.usePersistence + ", extendFlushReplays=" + this.extendFlushReplays + ", useLogPersistence=" + this.useLogPersistence + ", useRadarModifiedBeacon=" + this.useRadarModifiedBeacon + ", logLevel=" + (Object)((Object)this.logLevel) + ", startTrackingOnInitialize=" + this.startTrackingOnInitialize + ", trackOnceOnAppOpen=" + this.trackOnceOnAppOpen + ')';
    }

    public int hashCode() {
        int result = Integer.hashCode(this.maxConcurrentJobs);
        int n = this.schedulerRequiresNetwork ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result = result * 31 + n;
        int n2 = this.usePersistence ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        result = result * 31 + n2;
        int n3 = this.extendFlushReplays ? 1 : 0;
        if (n3 != 0) {
            n3 = 1;
        }
        result = result * 31 + n3;
        int n4 = this.useLogPersistence ? 1 : 0;
        if (n4 != 0) {
            n4 = 1;
        }
        result = result * 31 + n4;
        int n5 = this.useRadarModifiedBeacon ? 1 : 0;
        if (n5 != 0) {
            n5 = 1;
        }
        result = result * 31 + n5;
        result = result * 31 + this.logLevel.hashCode();
        int n6 = this.startTrackingOnInitialize ? 1 : 0;
        if (n6 != 0) {
            n6 = 1;
        }
        result = result * 31 + n6;
        int n7 = this.trackOnceOnAppOpen ? 1 : 0;
        if (n7 != 0) {
            n7 = 1;
        }
        result = result * 31 + n7;
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RadarSdkConfiguration)) {
            return false;
        }
        RadarSdkConfiguration radarSdkConfiguration = (RadarSdkConfiguration)other;
        if (this.maxConcurrentJobs != radarSdkConfiguration.maxConcurrentJobs) {
            return false;
        }
        if (this.schedulerRequiresNetwork != radarSdkConfiguration.schedulerRequiresNetwork) {
            return false;
        }
        if (this.usePersistence != radarSdkConfiguration.usePersistence) {
            return false;
        }
        if (this.extendFlushReplays != radarSdkConfiguration.extendFlushReplays) {
            return false;
        }
        if (this.useLogPersistence != radarSdkConfiguration.useLogPersistence) {
            return false;
        }
        if (this.useRadarModifiedBeacon != radarSdkConfiguration.useRadarModifiedBeacon) {
            return false;
        }
        if (this.logLevel != radarSdkConfiguration.logLevel) {
            return false;
        }
        if (this.startTrackingOnInitialize != radarSdkConfiguration.startTrackingOnInitialize) {
            return false;
        }
        return this.trackOnceOnAppOpen == radarSdkConfiguration.trackOnceOnAppOpen;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/radar/sdk/model/RadarSdkConfiguration$Companion;", "", "()V", "DEFAULT_MAX_CONCURRENT_JOBS", "", "EXTEND_FLUSH_REPLAYS", "", "LOG_LEVEL", "MAX_CONCURRENT_JOBS", "SCHEDULER_REQUIRES_NETWORK", "START_TRACKING_ON_INITIALIZE", "TRACK_ONCE_ON_APP_OPEN", "USE_LOG_PERSISTENCE", "USE_PERSISTENCE", "USE_RADAR_MODIFIED_BEACON", "fromJson", "Lio/radar/sdk/model/RadarSdkConfiguration;", "json", "Lorg/json/JSONObject;", "updateSdkConfigurationFromServer", "", "context", "Landroid/content/Context;", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RadarSdkConfiguration fromJson(@Nullable JSONObject json) {
            JSONObject jSONObject = json;
            if (jSONObject == null) {
                jSONObject = new JSONObject();
            }
            JSONObject config = jSONObject;
            int n = config.optInt(RadarSdkConfiguration.MAX_CONCURRENT_JOBS, 1);
            boolean bl = config.optBoolean(RadarSdkConfiguration.SCHEDULER_REQUIRES_NETWORK, false);
            boolean bl2 = config.optBoolean(RadarSdkConfiguration.USE_PERSISTENCE, false);
            boolean bl3 = config.optBoolean(RadarSdkConfiguration.EXTEND_FLUSH_REPLAYS, false);
            boolean bl4 = config.optBoolean(RadarSdkConfiguration.USE_LOG_PERSISTENCE, false);
            boolean bl5 = config.optBoolean(RadarSdkConfiguration.USE_RADAR_MODIFIED_BEACON, false);
            String string = config.optString(RadarSdkConfiguration.LOG_LEVEL, "info");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"config.optString(LOG_LEVEL, \"info\")");
            String string2 = string.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            return new RadarSdkConfiguration(n, bl, bl2, bl3, bl4, bl5, Radar.RadarLogLevel.valueOf(string2), config.optBoolean(RadarSdkConfiguration.START_TRACKING_ON_INITIALIZE, false), config.optBoolean(RadarSdkConfiguration.TRACK_ONCE_ON_APP_OPEN, false));
        }

        public final void updateSdkConfigurationFromServer(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Radar.INSTANCE.getApiClient$sdk_release().getConfig$sdk_release("sdkConfigUpdate", false, new RadarApiClient.RadarGetConfigApiCallback(context){
                final /* synthetic */ Context $context;
                {
                    this.$context = $context;
                }

                public void onComplete(@NotNull Radar.RadarStatus status, @NotNull RadarConfig config) {
                    Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
                    Intrinsics.checkNotNullParameter((Object)config, (String)"config");
                    RadarSettings.INSTANCE.setSdkConfiguration(this.$context, config.getMeta().getSdkConfiguration());
                }
            });
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

