/*
 * Decompiled with CFR 0.152.
 */
package io.radar.sdk;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import androidx.core.content.ContextCompat;
import com.google.android.gms.location.ActivityRecognition;
import com.google.android.gms.location.ActivityRecognitionClient;
import com.google.android.gms.location.ActivityTransition;
import com.google.android.gms.location.ActivityTransitionRequest;
import com.google.android.gms.tasks.Task;
import io.radar.sdk.Radar;
import io.radar.sdk.RadarLocationReceiver;
import io.radar.sdk.RadarLogger;
import io.radar.sdk.SensorSnapshotManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0001\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0012J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00110\u0014H\u0000\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\r\u0010\u0017\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0018R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u001a"}, d2={"Lio/radar/sdk/RadarActivityManager;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "activityClient", "Lcom/google/android/gms/location/ActivityRecognitionClient;", "request", "Lcom/google/android/gms/location/ActivityTransitionRequest;", "getRequest", "()Lcom/google/android/gms/location/ActivityTransitionRequest;", "sensorSnapshotManager", "Lio/radar/sdk/SensorSnapshotManager;", "transitions", "", "Lcom/google/android/gms/location/ActivityTransition;", "requestMotionUpdates", "", "requestMotionUpdates$sdk_release", "startActivityUpdates", "Lkotlin/Result;", "startActivityUpdates-d1pmJ48$sdk_release", "()Ljava/lang/Object;", "stopActivityUpdates", "stopActivityUpdates$sdk_release", "Companion", "sdk_release"})
@SuppressLint(value={"MissingPermission"})
public final class RadarActivityManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final List<ActivityTransition> transitions;
    @NotNull
    private final ActivityTransitionRequest request;
    @NotNull
    private final SensorSnapshotManager sensorSnapshotManager;
    @NotNull
    private final ActivityRecognitionClient activityClient;
    private static boolean isActivityUpdatesStarted;

    public RadarActivityManager(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.transitions = new ArrayList();
        ((Collection)this.transitions).add(new ActivityTransition.Builder().setActivityType(0).setActivityTransition(0).build());
        ((Collection)this.transitions).add(new ActivityTransition.Builder().setActivityType(1).setActivityTransition(0).build());
        ((Collection)this.transitions).add(new ActivityTransition.Builder().setActivityType(8).setActivityTransition(0).build());
        ((Collection)this.transitions).add(new ActivityTransition.Builder().setActivityType(3).setActivityTransition(0).build());
        ((Collection)this.transitions).add(new ActivityTransition.Builder().setActivityType(7).setActivityTransition(0).build());
        this.request = new ActivityTransitionRequest(this.transitions);
        this.sensorSnapshotManager = new SensorSnapshotManager(this.context);
        ActivityRecognitionClient activityRecognitionClient = ActivityRecognition.getClient((Context)this.context);
        Intrinsics.checkNotNullExpressionValue((Object)activityRecognitionClient, (String)"getClient(context)");
        this.activityClient = activityRecognitionClient;
    }

    @NotNull
    public final ActivityTransitionRequest getRequest() {
        return this.request;
    }

    @NotNull
    public final Object startActivityUpdates-d1pmJ48$sdk_release() {
        Object object;
        try {
            boolean hasPermission;
            boolean bl = false;
            boolean bl2 = Build.VERSION.SDK_INT >= 29 ? ContextCompat.checkSelfPermission((Context)this.context, (String)"android.permission.ACTIVITY_RECOGNITION") == 0 : (hasPermission = false);
            if (!hasPermission) {
                RadarLogger.d$default(Radar.INSTANCE.getLogger$sdk_release(), "Permission for activity recognition not granted", null, null, 6, null);
            } else if (!isActivityUpdatesStarted) {
                RadarLogger.d$default(Radar.INSTANCE.getLogger$sdk_release(), "trying to start activity updates", null, null, 6, null);
                Task task = this.activityClient.requestActivityTransitionUpdates(this.request, RadarLocationReceiver.Companion.getActivityPendingIntent$sdk_release(this.context));
                Intrinsics.checkNotNullExpressionValue((Object)task, (String)"activityClient.requestAc\u2026nt(context)\n            )");
                Task task2 = task;
                task2.addOnSuccessListener(RadarActivityManager::startActivityUpdates_d1pmJ48$lambda-2$lambda-0);
                task2.addOnFailureListener(RadarActivityManager::startActivityUpdates_d1pmJ48$lambda-2$lambda-1);
            } else {
                RadarLogger.d$default(Radar.INSTANCE.getLogger$sdk_release(), "Activity updates already started", null, null, 6, null);
            }
            object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return object;
    }

    public final void stopActivityUpdates$sdk_release() {
        if (!isActivityUpdatesStarted) {
            return;
        }
        this.activityClient.removeActivityUpdates(RadarLocationReceiver.Companion.getActivityPendingIntent$sdk_release(this.context));
        isActivityUpdatesStarted = false;
    }

    public final void requestMotionUpdates$sdk_release() {
        this.sensorSnapshotManager.getSensorSnapshot();
    }

    private static final void startActivityUpdates_d1pmJ48$lambda-2$lambda-0(Void it) {
        isActivityUpdatesStarted = true;
        RadarLogger.d$default(Radar.INSTANCE.getLogger$sdk_release(), "Activity updates started", null, null, 6, null);
    }

    private static final void startActivityUpdates_d1pmJ48$lambda-2$lambda-1(Exception e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        RadarLogger.e$default(Radar.INSTANCE.getLogger$sdk_release(), "Activity updates failed to start", null, null, 6, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/radar/sdk/RadarActivityManager$Companion;", "", "()V", "isActivityUpdatesStarted", "", "getActivityType", "Lio/radar/sdk/Radar$RadarActivityType;", "int", "", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Radar.RadarActivityType getActivityType(int n) {
            Radar.RadarActivityType radarActivityType;
            switch (n) {
                case 0: {
                    radarActivityType = Radar.RadarActivityType.CAR;
                    break;
                }
                case 1: {
                    radarActivityType = Radar.RadarActivityType.BIKE;
                    break;
                }
                case 3: {
                    radarActivityType = Radar.RadarActivityType.STATIONARY;
                    break;
                }
                case 7: {
                    radarActivityType = Radar.RadarActivityType.FOOT;
                    break;
                }
                case 8: {
                    radarActivityType = Radar.RadarActivityType.RUN;
                    break;
                }
                default: {
                    radarActivityType = Radar.RadarActivityType.UNKNOWN;
                }
            }
            return radarActivityType;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

