/*
 * Decompiled with CFR 0.152.
 */
package io.radar.sdk;

import android.content.Context;
import android.content.SharedPreferences;
import android.location.Location;
import androidx.annotation.RequiresApi;
import io.radar.sdk.RadarBeaconUtils;
import io.radar.sdk.RadarUtils;
import io.radar.sdk.model.RadarBeacon;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u001f\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b6\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010#\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020&H\u0000\u00a2\u0006\u0002\b'J\u0015\u0010(\u001a\u00020)2\u0006\u0010%\u001a\u00020&H\u0000\u00a2\u0006\u0002\b*J\u001d\u0010+\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020&H\u0000\u00a2\u0006\u0002\b,J\u0017\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010%\u001a\u00020&H\u0000\u00a2\u0006\u0002\b/J\u001f\u00100\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u0001012\u0006\u0010%\u001a\u00020&H\u0001\u00a2\u0006\u0004\b2\u00103J\u001f\u00104\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u0001012\u0006\u0010%\u001a\u00020&H\u0001\u00a2\u0006\u0004\b5\u00103J\u001f\u00106\u001a\n\u0012\u0004\u0012\u000207\u0018\u0001012\u0006\u0010%\u001a\u00020&H\u0001\u00a2\u0006\u0004\b8\u00109J\u0017\u0010:\u001a\u0004\u0018\u00010;2\u0006\u0010%\u001a\u00020&H\u0000\u00a2\u0006\u0002\b<J\u0017\u0010=\u001a\u0004\u0018\u00010.2\u0006\u0010%\u001a\u00020&H\u0000\u00a2\u0006\u0002\b>J\u0017\u0010?\u001a\u0004\u0018\u00010;2\u0006\u0010%\u001a\u00020&H\u0000\u00a2\u0006\u0002\b@J\u0017\u0010A\u001a\u0004\u0018\u00010.2\u0006\u0010%\u001a\u00020&H\u0000\u00a2\u0006\u0002\bBJ\u0017\u0010C\u001a\u0004\u0018\u00010.2\u0006\u0010%\u001a\u00020&H\u0000\u00a2\u0006\u0002\bDJ\u0015\u0010E\u001a\u00020F2\u0006\u0010%\u001a\u00020&H\u0000\u00a2\u0006\u0002\bGJ\u0017\u0010H\u001a\u0004\u0018\u00010;2\u0006\u0010%\u001a\u00020&H\u0000\u00a2\u0006\u0002\bIJ\u0015\u0010J\u001a\u00020F2\u0006\u0010%\u001a\u00020&H\u0000\u00a2\u0006\u0002\bKJ\u0017\u0010L\u001a\u0004\u0018\u00010\u00042\u0006\u0010%\u001a\u00020&H\u0000\u00a2\u0006\u0002\bMJ\u001d\u0010N\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020&H\u0000\u00a2\u0006\u0002\bOJ\u0010\u0010P\u001a\u00020Q2\u0006\u0010%\u001a\u00020&H\u0002J\u0015\u0010R\u001a\u00020)2\u0006\u0010%\u001a\u00020&H\u0000\u00a2\u0006\u0002\bSJ\u0014\u0010T\u001a\u0004\u0018\u00010\u00042\b\u0010U\u001a\u0004\u0018\u00010.H\u0002J%\u0010V\u001a\u00020W2\u0006\u0010%\u001a\u00020&2\u000e\u0010X\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010YH\u0000\u00a2\u0006\u0002\bZJ\u001d\u0010[\u001a\u00020W2\u0006\u0010%\u001a\u00020&2\u0006\u0010\\\u001a\u00020)H\u0000\u00a2\u0006\u0002\b]J%\u0010^\u001a\u00020W2\u0006\u0010%\u001a\u00020&2\u000e\u0010_\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010YH\u0000\u00a2\u0006\u0002\b`J\u001f\u0010a\u001a\u00020W2\u0006\u0010%\u001a\u00020&2\b\u0010b\u001a\u0004\u0018\u00010.H\u0000\u00a2\u0006\u0002\bcJ'\u0010d\u001a\u00020W2\u0006\u0010%\u001a\u00020&2\u000e\u0010e\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u000101H\u0001\u00a2\u0006\u0004\bf\u0010gJ'\u0010h\u001a\u00020W2\u0006\u0010%\u001a\u00020&2\u000e\u0010i\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u000101H\u0001\u00a2\u0006\u0004\bj\u0010gJ'\u0010k\u001a\u00020W2\u0006\u0010%\u001a\u00020&2\u000e\u0010l\u001a\n\u0012\u0004\u0012\u000207\u0018\u000101H\u0001\u00a2\u0006\u0004\bm\u0010nJ\u001f\u0010o\u001a\u00020W2\u0006\u0010%\u001a\u00020&2\b\u0010p\u001a\u0004\u0018\u00010;H\u0000\u00a2\u0006\u0002\bqJ\u001f\u0010r\u001a\u00020W2\u0006\u0010%\u001a\u00020&2\b\u0010s\u001a\u0004\u0018\u00010.H\u0000\u00a2\u0006\u0002\btJ\u001f\u0010u\u001a\u00020W2\u0006\u0010%\u001a\u00020&2\b\u0010p\u001a\u0004\u0018\u00010;H\u0000\u00a2\u0006\u0002\bvJ\u001f\u0010w\u001a\u00020W2\u0006\u0010%\u001a\u00020&2\b\u0010x\u001a\u0004\u0018\u00010.H\u0000\u00a2\u0006\u0002\byJ\u001f\u0010z\u001a\u00020W2\u0006\u0010%\u001a\u00020&2\b\u0010{\u001a\u0004\u0018\u00010.H\u0000\u00a2\u0006\u0002\b|J\u001d\u0010}\u001a\u00020W2\u0006\u0010%\u001a\u00020&2\u0006\u0010~\u001a\u00020FH\u0000\u00a2\u0006\u0002\b\u007fJ!\u0010\u0080\u0001\u001a\u00020W2\u0006\u0010%\u001a\u00020&2\b\u0010p\u001a\u0004\u0018\u00010;H\u0000\u00a2\u0006\u0003\b\u0081\u0001J\"\u0010\u0082\u0001\u001a\u00020W2\u0006\u0010%\u001a\u00020&2\t\u0010\u0083\u0001\u001a\u0004\u0018\u00010\u0004H\u0000\u00a2\u0006\u0003\b\u0084\u0001J(\u0010\u0085\u0001\u001a\u00020W2\u0006\u0010%\u001a\u00020&2\u000f\u0010\u0086\u0001\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010YH\u0000\u00a2\u0006\u0003\b\u0087\u0001J \u0010\u0088\u0001\u001a\u00020W2\u0006\u0010%\u001a\u00020&2\u0007\u0010\u0089\u0001\u001a\u00020)H\u0000\u00a2\u0006\u0003\b\u008a\u0001J\u0016\u0010\u008b\u0001\u001a\u0004\u0018\u00010.2\t\u0010\u008c\u0001\u001a\u0004\u0018\u00010\u0004H\u0002J\u0017\u0010\u008d\u0001\u001a\u00020W2\u0006\u0010%\u001a\u00020&H\u0000\u00a2\u0006\u0003\b\u008e\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u008f\u0001"}, d2={"Lio/radar/sdk/RadarState;", "", "()V", "KEY_BEACON_IDS", "", "KEY_CAN_EXIT", "KEY_GEOFENCE_IDS", "KEY_LAST_ACCELEROMETER", "KEY_LAST_BEACONS", "KEY_LAST_BEACON_UIDS", "KEY_LAST_BEACON_UUIDS", "KEY_LAST_FAILED_STOPPED_LOCATION_ACCURACY", "KEY_LAST_FAILED_STOPPED_LOCATION_LATITUDE", "KEY_LAST_FAILED_STOPPED_LOCATION_LONGITUDE", "KEY_LAST_FAILED_STOPPED_LOCATION_PROVIDER", "KEY_LAST_FAILED_STOPPED_LOCATION_TIME", "KEY_LAST_GYROSCOPE", "KEY_LAST_LOCATION_ACCURACY", "KEY_LAST_LOCATION_LATITUDE", "KEY_LAST_LOCATION_LONGITUDE", "KEY_LAST_LOCATION_PROVIDER", "KEY_LAST_LOCATION_TIME", "KEY_LAST_MAGNETOMETER", "KEY_LAST_MOTION_ACTIVITY", "KEY_LAST_MOVED_AT", "KEY_LAST_MOVED_LOCATION_ACCURACY", "KEY_LAST_MOVED_LOCATION_LATITUDE", "KEY_LAST_MOVED_LOCATION_LONGITUDE", "KEY_LAST_MOVED_LOCATION_PROVIDER", "KEY_LAST_MOVED_LOCATION_TIME", "KEY_LAST_SENT_AT", "KEY_PLACE_ID", "KEY_REGION_IDS", "KEY_STARTED", "KEY_STOPPED", "getBeaconIds", "", "context", "Landroid/content/Context;", "getBeaconIds$sdk_release", "getCanExit", "", "getCanExit$sdk_release", "getGeofenceIds", "getGeofenceIds$sdk_release", "getLastAccelerometer", "Lorg/json/JSONObject;", "getLastAccelerometer$sdk_release", "getLastBeaconUIDs", "", "getLastBeaconUIDs$sdk_release", "(Landroid/content/Context;)[Ljava/lang/String;", "getLastBeaconUUIDs", "getLastBeaconUUIDs$sdk_release", "getLastBeacons", "Lio/radar/sdk/model/RadarBeacon;", "getLastBeacons$sdk_release", "(Landroid/content/Context;)[Lio/radar/sdk/model/RadarBeacon;", "getLastFailedStoppedLocation", "Landroid/location/Location;", "getLastFailedStoppedLocation$sdk_release", "getLastGyro", "getLastGyro$sdk_release", "getLastLocation", "getLastLocation$sdk_release", "getLastMagnetometer", "getLastMagnetometer$sdk_release", "getLastMotionActivity", "getLastMotionActivity$sdk_release", "getLastMovedAt", "", "getLastMovedAt$sdk_release", "getLastMovedLocation", "getLastMovedLocation$sdk_release", "getLastSentAt", "getLastSentAt$sdk_release", "getPlaceId", "getPlaceId$sdk_release", "getRegionIds", "getRegionIds$sdk_release", "getSharedPreferences", "Landroid/content/SharedPreferences;", "getStopped", "getStopped$sdk_release", "jsonObjectToString", "jsonObject", "setBeaconIds", "", "beaconIds", "", "setBeaconIds$sdk_release", "setCanExit", "canExit", "setCanExit$sdk_release", "setGeofenceIds", "geofenceIds", "setGeofenceIds$sdk_release", "setLastAccelerometer", "accelerometerJson", "setLastAccelerometer$sdk_release", "setLastBeaconUIDs", "uids", "setLastBeaconUIDs$sdk_release", "(Landroid/content/Context;[Ljava/lang/String;)V", "setLastBeaconUUIDs", "uuids", "setLastBeaconUUIDs$sdk_release", "setLastBeacons", "beacons", "setLastBeacons$sdk_release", "(Landroid/content/Context;[Lio/radar/sdk/model/RadarBeacon;)V", "setLastFailedStoppedLocation", "location", "setLastFailedStoppedLocation$sdk_release", "setLastGyro", "gyroJson", "setLastGyro$sdk_release", "setLastLocation", "setLastLocation$sdk_release", "setLastMagnetometer", "magnetometerJson", "setLastMagnetometer$sdk_release", "setLastMotionActivity", "motionJson", "setLastMotionActivity$sdk_release", "setLastMovedAt", "lastMovedAt", "setLastMovedAt$sdk_release", "setLastMovedLocation", "setLastMovedLocation$sdk_release", "setPlaceId", "placeId", "setPlaceId$sdk_release", "setRegionIds", "regionIds", "setRegionIds$sdk_release", "setStopped", "stopped", "setStopped$sdk_release", "stringToJsonObject", "jsonString", "updateLastSentAt", "updateLastSentAt$sdk_release", "sdk_release"})
public final class RadarState {
    @NotNull
    public static final RadarState INSTANCE = new RadarState();
    @NotNull
    private static final String KEY_STARTED = "has_started";
    @NotNull
    private static final String KEY_LAST_LOCATION_LATITUDE = "last_location_latitude";
    @NotNull
    private static final String KEY_LAST_LOCATION_LONGITUDE = "last_location_longitude";
    @NotNull
    private static final String KEY_LAST_LOCATION_ACCURACY = "last_location_accuracy";
    @NotNull
    private static final String KEY_LAST_LOCATION_PROVIDER = "last_location_provider";
    @NotNull
    private static final String KEY_LAST_LOCATION_TIME = "last_location_time";
    @NotNull
    private static final String KEY_LAST_MOVED_LOCATION_LATITUDE = "last_moved_location_latitude";
    @NotNull
    private static final String KEY_LAST_MOVED_LOCATION_LONGITUDE = "last_moved_location_longitude";
    @NotNull
    private static final String KEY_LAST_MOVED_LOCATION_ACCURACY = "last_moved_location_accuracy";
    @NotNull
    private static final String KEY_LAST_MOVED_LOCATION_PROVIDER = "last_moved_location_provider";
    @NotNull
    private static final String KEY_LAST_MOVED_LOCATION_TIME = "last_moved_location_time";
    @NotNull
    private static final String KEY_LAST_MOVED_AT = "last_moved_at";
    @NotNull
    private static final String KEY_STOPPED = "stopped";
    @NotNull
    private static final String KEY_LAST_SENT_AT = "last_sent_at";
    @NotNull
    private static final String KEY_CAN_EXIT = "can_exit";
    @NotNull
    private static final String KEY_LAST_FAILED_STOPPED_LOCATION_LATITUDE = "last_failed_stopped_location_latitude";
    @NotNull
    private static final String KEY_LAST_FAILED_STOPPED_LOCATION_LONGITUDE = "last_failed_stopped_location_longitude";
    @NotNull
    private static final String KEY_LAST_FAILED_STOPPED_LOCATION_ACCURACY = "last_failed_stopped_location_accuracy";
    @NotNull
    private static final String KEY_LAST_FAILED_STOPPED_LOCATION_PROVIDER = "last_failed_stopped_location_provider";
    @NotNull
    private static final String KEY_LAST_FAILED_STOPPED_LOCATION_TIME = "last_failed_stopped_location_time";
    @NotNull
    private static final String KEY_GEOFENCE_IDS = "geofence_ids";
    @NotNull
    private static final String KEY_PLACE_ID = "place_id";
    @NotNull
    private static final String KEY_REGION_IDS = "region_ids";
    @NotNull
    private static final String KEY_BEACON_IDS = "beacon_ids";
    @NotNull
    private static final String KEY_LAST_BEACONS = "last_beacons";
    @NotNull
    private static final String KEY_LAST_BEACON_UUIDS = "last_beacon_uuids";
    @NotNull
    private static final String KEY_LAST_BEACON_UIDS = "last_beacon_uids";
    @NotNull
    private static final String KEY_LAST_MOTION_ACTIVITY = "last_motion_activity";
    @NotNull
    private static final String KEY_LAST_ACCELEROMETER = "last_accelerometer";
    @NotNull
    private static final String KEY_LAST_GYROSCOPE = "last_gyroscope";
    @NotNull
    private static final String KEY_LAST_MAGNETOMETER = "last_magnetometer";

    private RadarState() {
    }

    private final SharedPreferences getSharedPreferences(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("RadarSDK", 0);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"context.getSharedPrefere\u2026K\", Context.MODE_PRIVATE)");
        return sharedPreferences;
    }

    @Nullable
    public final Location getLastLocation$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        float lastLocationLatitude = this.getSharedPreferences(context).getFloat(KEY_LAST_LOCATION_LATITUDE, 0.0f);
        float lastLocationLongitude = this.getSharedPreferences(context).getFloat(KEY_LAST_LOCATION_LONGITUDE, 0.0f);
        float lastLocationAccuracy = this.getSharedPreferences(context).getFloat(KEY_LAST_LOCATION_ACCURACY, 0.0f);
        String lastLocationProvider = this.getSharedPreferences(context).getString(KEY_LAST_LOCATION_PROVIDER, "RadarSDK");
        long lastLocationTime = this.getSharedPreferences(context).getLong(KEY_LAST_LOCATION_TIME, 0L);
        Location location = new Location(lastLocationProvider);
        location.setLatitude((double)lastLocationLatitude);
        location.setLongitude((double)lastLocationLongitude);
        location.setAccuracy(lastLocationAccuracy);
        location.setTime(lastLocationTime);
        if (!RadarUtils.INSTANCE.valid$sdk_release(location)) {
            return null;
        }
        return location;
    }

    public final void setLastLocation$sdk_release(@NotNull Context context, @Nullable Location location) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (location == null || !RadarUtils.INSTANCE.valid$sdk_release(location)) {
            SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
            boolean commit$iv = false;
            boolean $i$f$edit = false;
            SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
            Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
            SharedPreferences.Editor $this$setLastLocation_u24lambda_u2d0 = editor$iv;
            boolean bl = false;
            $this$setLastLocation_u24lambda_u2d0.remove(KEY_LAST_LOCATION_LATITUDE);
            $this$setLastLocation_u24lambda_u2d0.remove(KEY_LAST_LOCATION_LONGITUDE);
            $this$setLastLocation_u24lambda_u2d0.remove(KEY_LAST_LOCATION_ACCURACY);
            $this$setLastLocation_u24lambda_u2d0.remove(KEY_LAST_LOCATION_PROVIDER);
            $this$setLastLocation_u24lambda_u2d0.remove(KEY_LAST_LOCATION_TIME);
            editor$iv.apply();
            return;
        }
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$setLastLocation_u24lambda_u2d1 = editor$iv;
        boolean bl = false;
        $this$setLastLocation_u24lambda_u2d1.putFloat(KEY_LAST_LOCATION_LATITUDE, (float)location.getLatitude());
        $this$setLastLocation_u24lambda_u2d1.putFloat(KEY_LAST_LOCATION_LONGITUDE, (float)location.getLongitude());
        $this$setLastLocation_u24lambda_u2d1.putFloat(KEY_LAST_LOCATION_ACCURACY, location.getAccuracy());
        $this$setLastLocation_u24lambda_u2d1.putString(KEY_LAST_LOCATION_PROVIDER, location.getProvider());
        $this$setLastLocation_u24lambda_u2d1.putLong(KEY_LAST_LOCATION_TIME, location.getTime());
        editor$iv.apply();
    }

    @Nullable
    public final Location getLastMovedLocation$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        float lastMovedLocationLatitude = this.getSharedPreferences(context).getFloat(KEY_LAST_MOVED_LOCATION_LATITUDE, 0.0f);
        float lastMovedLocationLongitude = this.getSharedPreferences(context).getFloat(KEY_LAST_MOVED_LOCATION_LONGITUDE, 0.0f);
        float lastMovedLocationAccuracy = this.getSharedPreferences(context).getFloat(KEY_LAST_MOVED_LOCATION_ACCURACY, 0.0f);
        String lastMovedLocationProvider = this.getSharedPreferences(context).getString(KEY_LAST_MOVED_LOCATION_PROVIDER, "RadarSDK");
        long lastMovedLocationTime = this.getSharedPreferences(context).getLong(KEY_LAST_MOVED_LOCATION_TIME, 0L);
        Location location = new Location(lastMovedLocationProvider);
        location.setLatitude((double)lastMovedLocationLatitude);
        location.setLongitude((double)lastMovedLocationLongitude);
        location.setAccuracy(lastMovedLocationAccuracy);
        location.setTime(lastMovedLocationTime);
        if (!RadarUtils.INSTANCE.valid$sdk_release(location)) {
            return null;
        }
        return location;
    }

    public final void setLastMovedLocation$sdk_release(@NotNull Context context, @Nullable Location location) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (location == null || !RadarUtils.INSTANCE.valid$sdk_release(location)) {
            return;
        }
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$setLastMovedLocation_u24lambda_u2d2 = editor$iv;
        boolean bl = false;
        $this$setLastMovedLocation_u24lambda_u2d2.putFloat(KEY_LAST_MOVED_LOCATION_LATITUDE, (float)location.getLatitude());
        $this$setLastMovedLocation_u24lambda_u2d2.putFloat(KEY_LAST_MOVED_LOCATION_LONGITUDE, (float)location.getLongitude());
        $this$setLastMovedLocation_u24lambda_u2d2.putFloat(KEY_LAST_MOVED_LOCATION_ACCURACY, location.getAccuracy());
        $this$setLastMovedLocation_u24lambda_u2d2.putString(KEY_LAST_MOVED_LOCATION_PROVIDER, location.getProvider());
        $this$setLastMovedLocation_u24lambda_u2d2.putLong(KEY_LAST_MOVED_LOCATION_TIME, location.getTime());
        editor$iv.apply();
    }

    public final long getLastMovedAt$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.getSharedPreferences(context).getLong(KEY_LAST_MOVED_AT, 0L);
    }

    public final void setLastMovedAt$sdk_release(@NotNull Context context, long lastMovedAt) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$setLastMovedAt_u24lambda_u2d3 = editor$iv;
        boolean bl = false;
        $this$setLastMovedAt_u24lambda_u2d3.putLong(KEY_LAST_MOVED_AT, lastMovedAt);
        editor$iv.apply();
    }

    public final boolean getStopped$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.getSharedPreferences(context).getBoolean(KEY_STOPPED, false);
    }

    public final void setStopped$sdk_release(@NotNull Context context, boolean stopped) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$setStopped_u24lambda_u2d4 = editor$iv;
        boolean bl = false;
        $this$setStopped_u24lambda_u2d4.putBoolean(KEY_STOPPED, stopped);
        editor$iv.apply();
    }

    public final void updateLastSentAt$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$updateLastSentAt_u24lambda_u2d5 = editor$iv;
        boolean bl = false;
        $this$updateLastSentAt_u24lambda_u2d5.putLong(KEY_LAST_SENT_AT, System.currentTimeMillis());
        editor$iv.apply();
    }

    public final long getLastSentAt$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.getSharedPreferences(context).getLong(KEY_LAST_SENT_AT, 0L);
    }

    public final boolean getCanExit$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.getSharedPreferences(context).getBoolean(KEY_CAN_EXIT, true);
    }

    public final void setCanExit$sdk_release(@NotNull Context context, boolean canExit) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$setCanExit_u24lambda_u2d6 = editor$iv;
        boolean bl = false;
        $this$setCanExit_u24lambda_u2d6.putBoolean(KEY_CAN_EXIT, canExit);
        editor$iv.apply();
    }

    @Nullable
    public final Location getLastFailedStoppedLocation$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        float lastFailedStoppedLocationLatitude = this.getSharedPreferences(context).getFloat(KEY_LAST_FAILED_STOPPED_LOCATION_LATITUDE, 0.0f);
        float lastFailedStoppedLocationLongitude = this.getSharedPreferences(context).getFloat(KEY_LAST_FAILED_STOPPED_LOCATION_LONGITUDE, 0.0f);
        float lastFailedStoppedLocationAccuracy = this.getSharedPreferences(context).getFloat(KEY_LAST_FAILED_STOPPED_LOCATION_ACCURACY, 0.0f);
        String lastFailedStoppedLocationProvider = this.getSharedPreferences(context).getString(KEY_LAST_FAILED_STOPPED_LOCATION_PROVIDER, "RadarSDK");
        long lastFailedStoppedLocationTime = this.getSharedPreferences(context).getLong(KEY_LAST_FAILED_STOPPED_LOCATION_TIME, 0L);
        Location location = new Location(lastFailedStoppedLocationProvider);
        location.setLatitude((double)lastFailedStoppedLocationLatitude);
        location.setLongitude((double)lastFailedStoppedLocationLongitude);
        location.setAccuracy(lastFailedStoppedLocationAccuracy);
        location.setTime(lastFailedStoppedLocationTime);
        if (!RadarUtils.INSTANCE.valid$sdk_release(location)) {
            return null;
        }
        return location;
    }

    public final void setLastFailedStoppedLocation$sdk_release(@NotNull Context context, @Nullable Location location) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (location == null || !RadarUtils.INSTANCE.valid$sdk_release(location)) {
            SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
            boolean commit$iv = false;
            boolean $i$f$edit = false;
            SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
            Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
            SharedPreferences.Editor $this$setLastFailedStoppedLocation_u24lambda_u2d7 = editor$iv;
            boolean bl = false;
            $this$setLastFailedStoppedLocation_u24lambda_u2d7.remove(KEY_LAST_FAILED_STOPPED_LOCATION_LATITUDE);
            $this$setLastFailedStoppedLocation_u24lambda_u2d7.remove(KEY_LAST_FAILED_STOPPED_LOCATION_LONGITUDE);
            $this$setLastFailedStoppedLocation_u24lambda_u2d7.remove(KEY_LAST_FAILED_STOPPED_LOCATION_ACCURACY);
            $this$setLastFailedStoppedLocation_u24lambda_u2d7.remove(KEY_LAST_FAILED_STOPPED_LOCATION_PROVIDER);
            $this$setLastFailedStoppedLocation_u24lambda_u2d7.remove(KEY_LAST_FAILED_STOPPED_LOCATION_TIME);
            editor$iv.apply();
            return;
        }
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$setLastFailedStoppedLocation_u24lambda_u2d8 = editor$iv;
        boolean bl = false;
        $this$setLastFailedStoppedLocation_u24lambda_u2d8.putFloat(KEY_LAST_FAILED_STOPPED_LOCATION_LATITUDE, (float)location.getLatitude());
        $this$setLastFailedStoppedLocation_u24lambda_u2d8.putFloat(KEY_LAST_FAILED_STOPPED_LOCATION_LONGITUDE, (float)location.getLongitude());
        $this$setLastFailedStoppedLocation_u24lambda_u2d8.putFloat(KEY_LAST_FAILED_STOPPED_LOCATION_ACCURACY, location.getAccuracy());
        $this$setLastFailedStoppedLocation_u24lambda_u2d8.putString(KEY_LAST_FAILED_STOPPED_LOCATION_PROVIDER, location.getProvider());
        $this$setLastFailedStoppedLocation_u24lambda_u2d8.putLong(KEY_LAST_FAILED_STOPPED_LOCATION_TIME, location.getTime());
        editor$iv.apply();
    }

    @Nullable
    public final Set<String> getGeofenceIds$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.getSharedPreferences(context).getStringSet(KEY_GEOFENCE_IDS, null);
    }

    public final void setGeofenceIds$sdk_release(@NotNull Context context, @Nullable Set<String> geofenceIds) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$setGeofenceIds_u24lambda_u2d9 = editor$iv;
        boolean bl = false;
        $this$setGeofenceIds_u24lambda_u2d9.putStringSet(KEY_GEOFENCE_IDS, geofenceIds);
        editor$iv.apply();
    }

    @Nullable
    public final String getPlaceId$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.getSharedPreferences(context).getString(KEY_PLACE_ID, null);
    }

    public final void setPlaceId$sdk_release(@NotNull Context context, @Nullable String placeId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$setPlaceId_u24lambda_u2d10 = editor$iv;
        boolean bl = false;
        $this$setPlaceId_u24lambda_u2d10.putString(KEY_PLACE_ID, placeId);
        editor$iv.apply();
    }

    @Nullable
    public final Set<String> getRegionIds$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.getSharedPreferences(context).getStringSet(KEY_REGION_IDS, null);
    }

    public final void setRegionIds$sdk_release(@NotNull Context context, @Nullable Set<String> regionIds) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$setRegionIds_u24lambda_u2d11 = editor$iv;
        boolean bl = false;
        $this$setRegionIds_u24lambda_u2d11.putStringSet(KEY_REGION_IDS, regionIds);
        editor$iv.apply();
    }

    @Nullable
    public final Set<String> getBeaconIds$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.getSharedPreferences(context).getStringSet(KEY_BEACON_IDS, null);
    }

    public final void setBeaconIds$sdk_release(@NotNull Context context, @Nullable Set<String> beaconIds) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$setBeaconIds_u24lambda_u2d12 = editor$iv;
        boolean bl = false;
        $this$setBeaconIds_u24lambda_u2d12.putStringSet(KEY_BEACON_IDS, beaconIds);
        editor$iv.apply();
    }

    @RequiresApi(value=21)
    @Nullable
    public final RadarBeacon[] getLastBeacons$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Set set = this.getSharedPreferences(context).getStringSet(KEY_LAST_BEACONS, null);
        return RadarBeaconUtils.INSTANCE.beaconsForStringSet(set);
    }

    @RequiresApi(value=21)
    public final void setLastBeacons$sdk_release(@NotNull Context context, @Nullable RadarBeacon[] beacons) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Set<String> set = RadarBeaconUtils.INSTANCE.stringSetForBeacons(beacons);
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$setLastBeacons_u24lambda_u2d13 = editor$iv;
        boolean bl = false;
        $this$setLastBeacons_u24lambda_u2d13.putStringSet(KEY_LAST_BEACONS, set);
        editor$iv.apply();
    }

    @RequiresApi(value=21)
    @Nullable
    public final String[] getLastBeaconUUIDs$sdk_release(@NotNull Context context) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Set set = this.getSharedPreferences(context).getStringSet(KEY_LAST_BEACON_UUIDS, null);
        if (set != null) {
            Collection $this$toTypedArray$iv = set;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
            if (stringArray2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            stringArray = stringArray2;
        } else {
            stringArray = null;
        }
        return stringArray;
    }

    @RequiresApi(value=21)
    public final void setLastBeaconUUIDs$sdk_release(@NotNull Context context, @Nullable String[] uuids) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$setLastBeaconUUIDs_u24lambda_u2d14 = editor$iv;
        boolean bl = false;
        $this$setLastBeaconUUIDs_u24lambda_u2d14.putStringSet(KEY_LAST_BEACON_UUIDS, uuids != null ? ArraysKt.toSet((Object[])uuids) : null);
        editor$iv.apply();
    }

    @RequiresApi(value=21)
    @Nullable
    public final String[] getLastBeaconUIDs$sdk_release(@NotNull Context context) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Set set = this.getSharedPreferences(context).getStringSet(KEY_LAST_BEACON_UIDS, null);
        if (set != null) {
            Collection $this$toTypedArray$iv = set;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
            if (stringArray2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            stringArray = stringArray2;
        } else {
            stringArray = null;
        }
        return stringArray;
    }

    @RequiresApi(value=21)
    public final void setLastBeaconUIDs$sdk_release(@NotNull Context context, @Nullable String[] uids) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$setLastBeaconUIDs_u24lambda_u2d15 = editor$iv;
        boolean bl = false;
        $this$setLastBeaconUIDs_u24lambda_u2d15.putStringSet(KEY_LAST_BEACON_UIDS, uids != null ? ArraysKt.toSet((Object[])uids) : null);
        editor$iv.apply();
    }

    private final String jsonObjectToString(JSONObject jsonObject) {
        JSONObject jSONObject = jsonObject;
        return jSONObject != null ? jSONObject.toString() : null;
    }

    private final JSONObject stringToJsonObject(String jsonString) {
        JSONObject jSONObject;
        String string = jsonString;
        if (string != null) {
            JSONObject jSONObject2;
            String it = string;
            boolean bl = false;
            try {
                jSONObject2 = new JSONObject(it);
            }
            catch (Exception e) {
                jSONObject2 = null;
            }
            jSONObject = jSONObject2;
        } else {
            jSONObject = null;
        }
        return jSONObject;
    }

    @Nullable
    public final JSONObject getLastMotionActivity$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String jsonString = this.getSharedPreferences(context).getString(KEY_LAST_MOTION_ACTIVITY, null);
        return this.stringToJsonObject(jsonString);
    }

    public final void setLastMotionActivity$sdk_release(@NotNull Context context, @Nullable JSONObject motionJson) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String jsonString = this.jsonObjectToString(motionJson);
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$setLastMotionActivity_u24lambda_u2d17 = editor$iv;
        boolean bl = false;
        $this$setLastMotionActivity_u24lambda_u2d17.putString(KEY_LAST_MOTION_ACTIVITY, jsonString);
        editor$iv.apply();
    }

    @Nullable
    public final JSONObject getLastAccelerometer$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String jsonString = this.getSharedPreferences(context).getString(KEY_LAST_ACCELEROMETER, null);
        return this.stringToJsonObject(jsonString);
    }

    public final void setLastAccelerometer$sdk_release(@NotNull Context context, @Nullable JSONObject accelerometerJson) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String jsonString = this.jsonObjectToString(accelerometerJson);
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$setLastAccelerometer_u24lambda_u2d18 = editor$iv;
        boolean bl = false;
        $this$setLastAccelerometer_u24lambda_u2d18.putString(KEY_LAST_ACCELEROMETER, jsonString);
        editor$iv.apply();
    }

    @Nullable
    public final JSONObject getLastGyro$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String jsonString = this.getSharedPreferences(context).getString(KEY_LAST_GYROSCOPE, null);
        return this.stringToJsonObject(jsonString);
    }

    public final void setLastGyro$sdk_release(@NotNull Context context, @Nullable JSONObject gyroJson) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String jsonString = this.jsonObjectToString(gyroJson);
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$setLastGyro_u24lambda_u2d19 = editor$iv;
        boolean bl = false;
        $this$setLastGyro_u24lambda_u2d19.putString(KEY_LAST_GYROSCOPE, jsonString);
        editor$iv.apply();
    }

    @Nullable
    public final JSONObject getLastMagnetometer$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String jsonString = this.getSharedPreferences(context).getString(KEY_LAST_MAGNETOMETER, null);
        return this.stringToJsonObject(jsonString);
    }

    public final void setLastMagnetometer$sdk_release(@NotNull Context context, @Nullable JSONObject magnetometerJson) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String jsonString = this.jsonObjectToString(magnetometerJson);
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$setLastMagnetometer_u24lambda_u2d20 = editor$iv;
        boolean bl = false;
        $this$setLastMagnetometer_u24lambda_u2d20.putString(KEY_LAST_MAGNETOMETER, jsonString);
        editor$iv.apply();
    }
}

