/*
 * Decompiled with CFR 0.152.
 */
package io.radar.sdk;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import io.radar.sdk.Radar;
import io.radar.sdk.RadarLogger;
import io.radar.sdk.RadarState;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000f\u001a\u00020\u0010R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/radar/sdk/SensorSnapshotManager;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "accelerometerSensor", "Landroid/hardware/Sensor;", "accelerometerSensorEventListener", "Landroid/hardware/SensorEventListener;", "gyroscopeSensor", "gyroscopeSensorEventListener", "magnetometerSensor", "magnetometerSensorEventListener", "sensorManager", "Landroid/hardware/SensorManager;", "getSensorSnapshot", "", "sdk_release"})
public final class SensorSnapshotManager {
    @NotNull
    private final Context context;
    @NotNull
    private final SensorManager sensorManager;
    @Nullable
    private Sensor accelerometerSensor;
    @Nullable
    private Sensor gyroscopeSensor;
    @Nullable
    private Sensor magnetometerSensor;
    @Nullable
    private SensorEventListener accelerometerSensorEventListener;
    @Nullable
    private SensorEventListener gyroscopeSensorEventListener;
    @Nullable
    private SensorEventListener magnetometerSensorEventListener;

    public SensorSnapshotManager(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        Object object = this.context.getSystemService("sensor");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.hardware.SensorManager");
        }
        this.sensorManager = (SensorManager)object;
        this.accelerometerSensor = this.sensorManager.getDefaultSensor(1);
        this.gyroscopeSensor = this.sensorManager.getDefaultSensor(4);
        this.magnetometerSensor = this.sensorManager.getDefaultSensor(2);
    }

    public final void getSensorSnapshot() {
        if (this.accelerometerSensor == null) {
            RadarLogger.i$default(Radar.INSTANCE.getLogger$sdk_release(), "accelerometer_sensor not available", null, null, 6, null);
        } else {
            this.accelerometerSensorEventListener = new SensorEventListener(this){
                final /* synthetic */ SensorSnapshotManager this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onSensorChanged(@NotNull SensorEvent event) {
                    JSONObject jSONObject;
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    float[] sensorData = event.values;
                    RadarLogger radarLogger = Radar.INSTANCE.getLogger$sdk_release();
                    StringBuilder stringBuilder = new StringBuilder().append("accelerometerSensor data: ");
                    Intrinsics.checkNotNullExpressionValue((Object)sensorData, (String)"sensorData");
                    RadarLogger.d$default(radarLogger, stringBuilder.append(ArraysKt.joinToString$default((float[])sensorData, null, null, null, (int)0, null, null, (int)63, null)).toString(), null, null, 6, null);
                    JSONObject $this$onSensorChanged_u24lambda_u2d0 = jSONObject = new JSONObject();
                    boolean bl = false;
                    $this$onSensorChanged_u24lambda_u2d0.put("x", (Object)Float.valueOf(sensorData[0]));
                    $this$onSensorChanged_u24lambda_u2d0.put("y", (Object)Float.valueOf(sensorData[1]));
                    $this$onSensorChanged_u24lambda_u2d0.put("z", (Object)Float.valueOf(sensorData[2]));
                    JSONObject jsonObject = jSONObject;
                    RadarState.INSTANCE.setLastAccelerometer$sdk_release(SensorSnapshotManager.access$getContext$p(this.this$0), jsonObject);
                    SensorSnapshotManager.access$getSensorManager$p(this.this$0).unregisterListener((SensorEventListener)this);
                }

                public void onAccuracyChanged(@NotNull Sensor sensor, int accuracy) {
                    Intrinsics.checkNotNullParameter((Object)sensor, (String)"sensor");
                }
            };
        }
        if (this.gyroscopeSensor == null) {
            RadarLogger.d$default(Radar.INSTANCE.getLogger$sdk_release(), "gyroscope_sensor not available", null, null, 6, null);
        } else {
            this.gyroscopeSensorEventListener = new SensorEventListener(this){
                final /* synthetic */ SensorSnapshotManager this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onSensorChanged(@NotNull SensorEvent event) {
                    JSONObject jSONObject;
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    float[] sensorData = event.values;
                    RadarLogger radarLogger = Radar.INSTANCE.getLogger$sdk_release();
                    StringBuilder stringBuilder = new StringBuilder().append("gyroscopeSensor data: ");
                    Intrinsics.checkNotNullExpressionValue((Object)sensorData, (String)"sensorData");
                    RadarLogger.d$default(radarLogger, stringBuilder.append(ArraysKt.joinToString$default((float[])sensorData, null, null, null, (int)0, null, null, (int)63, null)).toString(), null, null, 6, null);
                    JSONObject $this$onSensorChanged_u24lambda_u2d0 = jSONObject = new JSONObject();
                    boolean bl = false;
                    $this$onSensorChanged_u24lambda_u2d0.put("x", (Object)Float.valueOf(sensorData[0]));
                    $this$onSensorChanged_u24lambda_u2d0.put("y", (Object)Float.valueOf(sensorData[1]));
                    $this$onSensorChanged_u24lambda_u2d0.put("z", (Object)Float.valueOf(sensorData[2]));
                    JSONObject jsonObject = jSONObject;
                    RadarState.INSTANCE.setLastGyro$sdk_release(SensorSnapshotManager.access$getContext$p(this.this$0), jsonObject);
                    SensorSnapshotManager.access$getSensorManager$p(this.this$0).unregisterListener((SensorEventListener)this);
                }

                public void onAccuracyChanged(@NotNull Sensor sensor, int accuracy) {
                    Intrinsics.checkNotNullParameter((Object)sensor, (String)"sensor");
                }
            };
        }
        if (this.magnetometerSensor == null) {
            RadarLogger.i$default(Radar.INSTANCE.getLogger$sdk_release(), "magnetometer_sensor not available", null, null, 6, null);
        } else {
            this.magnetometerSensorEventListener = new SensorEventListener(this){
                final /* synthetic */ SensorSnapshotManager this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onSensorChanged(@NotNull SensorEvent event) {
                    JSONObject jSONObject;
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    float[] sensorData = event.values;
                    RadarLogger radarLogger = Radar.INSTANCE.getLogger$sdk_release();
                    StringBuilder stringBuilder = new StringBuilder().append("magnetometerSensor data: ");
                    Intrinsics.checkNotNullExpressionValue((Object)sensorData, (String)"sensorData");
                    RadarLogger.d$default(radarLogger, stringBuilder.append(ArraysKt.joinToString$default((float[])sensorData, null, null, null, (int)0, null, null, (int)63, null)).toString(), null, null, 6, null);
                    JSONObject $this$onSensorChanged_u24lambda_u2d0 = jSONObject = new JSONObject();
                    boolean bl = false;
                    $this$onSensorChanged_u24lambda_u2d0.put("x", (Object)Float.valueOf(sensorData[0]));
                    $this$onSensorChanged_u24lambda_u2d0.put("y", (Object)Float.valueOf(sensorData[1]));
                    $this$onSensorChanged_u24lambda_u2d0.put("z", (Object)Float.valueOf(sensorData[2]));
                    JSONObject jsonObject = jSONObject;
                    RadarState.INSTANCE.setLastMagnetometer$sdk_release(SensorSnapshotManager.access$getContext$p(this.this$0), jsonObject);
                    SensorSnapshotManager.access$getSensorManager$p(this.this$0).unregisterListener((SensorEventListener)this);
                }

                public void onAccuracyChanged(@NotNull Sensor sensor, int accuracy) {
                    Intrinsics.checkNotNullParameter((Object)sensor, (String)"sensor");
                }
            };
        }
        if (this.accelerometerSensor != null) {
            this.sensorManager.registerListener(this.accelerometerSensorEventListener, this.accelerometerSensor, 3);
        }
        if (this.gyroscopeSensor != null) {
            this.sensorManager.registerListener(this.gyroscopeSensorEventListener, this.gyroscopeSensor, 3);
        }
        if (this.magnetometerSensor != null) {
            this.sensorManager.registerListener(this.magnetometerSensorEventListener, this.magnetometerSensor, 3);
        }
    }

    public static final /* synthetic */ Context access$getContext$p(SensorSnapshotManager $this) {
        return $this.context;
    }

    public static final /* synthetic */ SensorManager access$getSensorManager$p(SensorSnapshotManager $this) {
        return $this.sensorManager;
    }
}

