/*
 * Decompiled with CFR 0.152.
 */
package io.radar.sdk;

import android.content.Context;
import android.location.Location;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkRequest;
import android.os.Build;
import android.os.Handler;
import android.os.SystemClock;
import androidx.annotation.RequiresApi;
import com.google.android.gms.tasks.Task;
import com.google.android.play.core.integrity.IntegrityManagerFactory;
import com.google.android.play.core.integrity.StandardIntegrityManager;
import io.radar.sdk.Radar;
import io.radar.sdk.RadarActivityLifecycleCallbacks;
import io.radar.sdk.RadarApiClient;
import io.radar.sdk.RadarLogger;
import io.radar.sdk.RadarSettings;
import io.radar.sdk.RadarState;
import io.radar.sdk.RadarTrackingOptions;
import io.radar.sdk.RadarUtils;
import io.radar.sdk.RadarVerificationManager;
import io.radar.sdk.model.RadarBeacon;
import io.radar.sdk.model.RadarConfig;
import io.radar.sdk.model.RadarEvent;
import io.radar.sdk.model.RadarGeofence;
import io.radar.sdk.model.RadarUser;
import io.radar.sdk.model.RadarVerifiedLocationToken;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0006\b\u0001\u0018\u0000 :2\u00020\u0001:\u0001:B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006JN\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\n2:\u0010\u001f\u001a6\u0012\u0015\u0012\u0013\u0018\u00010\n\u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b(#\u0012\u0015\u0012\u0013\u0018\u00010\n\u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b($\u0012\u0004\u0012\u00020\u001d0 H\u0002J\u0006\u0010%\u001a\u00020\nJ[\u0010&\u001a\u00020\u001d2\b\u0010'\u001a\u0004\u0018\u00010\u00142\b\u0010\u001e\u001a\u0004\u0018\u00010\n2:\u0010\u001f\u001a6\u0012\u0015\u0012\u0013\u0018\u00010\n\u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b(#\u0012\u0015\u0012\u0013\u0018\u00010\n\u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b($\u0012\u0004\u0012\u00020\u001d0 \u00a2\u0006\u0002\u0010(J\u000e\u0010)\u001a\u00020\n2\u0006\u0010*\u001a\u00020+J\u0012\u0010,\u001a\u00020\u001d2\n\b\u0002\u0010-\u001a\u0004\u0018\u00010.J\b\u0010/\u001a\u00020\u0012H\u0002J\u001a\u00100\u001a\u00020\u001d2\b\u00101\u001a\u0004\u0018\u00010\n2\b\u00102\u001a\u0004\u0018\u00010\nJ\u0016\u00103\u001a\u00020\u001d2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u0012J\u0006\u00107\u001a\u00020\u001dJ\u001c\u00108\u001a\u00020\u001d2\b\b\u0002\u00106\u001a\u00020\u00122\n\b\u0002\u0010-\u001a\u0004\u0018\u00010.JV\u00109\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020\u00142\b\u0010\u001e\u001a\u0004\u0018\u00010\n2:\u0010\u001f\u001a6\u0012\u0015\u0012\u0013\u0018\u00010\n\u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b(#\u0012\u0015\u0012\u0013\u0018\u00010\n\u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b($\u0012\u0004\u0012\u00020\u001d0 H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lio/radar/sdk/RadarVerificationManager;", "", "context", "Landroid/content/Context;", "logger", "Lio/radar/sdk/RadarLogger;", "(Landroid/content/Context;Lio/radar/sdk/RadarLogger;)V", "connectivityManager", "Landroid/net/ConnectivityManager;", "expectedCountryCode", "", "expectedStateCode", "handler", "Landroid/os/Handler;", "lastIPs", "lastToken", "Lio/radar/sdk/model/RadarVerifiedLocationToken;", "lastTokenBeacons", "", "lastTokenElapsedRealtime", "", "lastWarmUpTimestampSeconds", "networkCallback", "Landroid/net/ConnectivityManager$NetworkCallback;", "scheduled", "standardIntegrityTokenProvider", "Lcom/google/android/play/core/integrity/StandardIntegrityManager$StandardIntegrityTokenProvider;", "started", "fetchTokenFromGoogle", "", "requestHash", "block", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "integrityToken", "integrityException", "getIPs", "getIntegrityToken", "googlePlayProjectNumber", "(Ljava/lang/Long;Ljava/lang/String;Lkotlin/jvm/functions/Function2;)V", "getRequestHash", "location", "Landroid/location/Location;", "getVerifiedLocationToken", "callback", "Lio/radar/sdk/Radar$RadarTrackVerifiedCallback;", "isIntegrityApiIncluded", "setExpectedJurisdiction", "countryCode", "stateCode", "startTrackingVerified", "interval", "", "beacons", "stopTrackingVerified", "trackVerified", "warmUpProviderAndFetchTokenFromGoogle", "Companion", "sdk_release"})
@RequiresApi(value=21)
public final class RadarVerificationManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final RadarLogger logger;
    private StandardIntegrityManager.StandardIntegrityTokenProvider standardIntegrityTokenProvider;
    private long lastWarmUpTimestampSeconds;
    @NotNull
    private final Handler handler;
    @NotNull
    private final ConnectivityManager connectivityManager;
    @Nullable
    private ConnectivityManager.NetworkCallback networkCallback;
    private boolean started;
    private boolean scheduled;
    @Nullable
    private RadarVerifiedLocationToken lastToken;
    private long lastTokenElapsedRealtime;
    private boolean lastTokenBeacons;
    @Nullable
    private String lastIPs;
    @Nullable
    private String expectedCountryCode;
    @Nullable
    private String expectedStateCode;
    private static final int WARM_UP_WINDOW_SECONDS = 43200;

    public RadarVerificationManager(@NotNull Context context, @NotNull RadarLogger logger) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.context = context;
        this.logger = logger;
        this.handler = new Handler(this.context.getMainLooper());
        Object object = this.context.getSystemService("connectivity");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.net.ConnectivityManager");
        }
        this.connectivityManager = (ConnectivityManager)object;
    }

    private final boolean isIntegrityApiIncluded() {
        boolean bl;
        try {
            Class.forName("com.google.android.play.core.integrity.StandardIntegrityManager");
            bl = true;
        }
        catch (ClassNotFoundException e) {
            bl = false;
        }
        return bl;
    }

    public final void trackVerified(boolean beacons, @Nullable Radar.RadarTrackVerifiedCallback callback) {
        RadarVerificationManager verificationManager = this;
        boolean lastTokenBeacons = beacons;
        String usage = "trackVerified";
        Radar.INSTANCE.getApiClient$sdk_release().getConfig$sdk_release(usage, true, new RadarApiClient.RadarGetConfigApiCallback(callback, verificationManager, beacons, lastTokenBeacons){
            final /* synthetic */ Radar.RadarTrackVerifiedCallback $callback;
            final /* synthetic */ RadarVerificationManager $verificationManager;
            final /* synthetic */ boolean $beacons;
            final /* synthetic */ boolean $lastTokenBeacons;
            {
                this.$callback = $callback;
                this.$verificationManager = $verificationManager;
                this.$beacons = $beacons;
                this.$lastTokenBeacons = $lastTokenBeacons;
            }

            public void onComplete(@NotNull Radar.RadarStatus status, @Nullable RadarConfig config) {
                Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
                if (status != Radar.RadarStatus.SUCCESS || config == null) {
                    Radar.INSTANCE.getHandler$sdk_release().post(() -> trackVerified.1.onComplete$lambda-0(this.$callback, status));
                    return;
                }
                Long googlePlayProjectNumber = config.getGooglePlayProjectNumber();
                Radar.INSTANCE.getLocationManager$sdk_release().getLocation(RadarTrackingOptions.RadarTrackingOptionsDesiredAccuracy.MEDIUM, Radar.RadarLocationSource.FOREGROUND_LOCATION, new Radar.RadarLocationCallback(this.$verificationManager, googlePlayProjectNumber, this.$callback, this.$beacons, this.$lastTokenBeacons){
                    final /* synthetic */ RadarVerificationManager $verificationManager;
                    final /* synthetic */ Long $googlePlayProjectNumber;
                    final /* synthetic */ Radar.RadarTrackVerifiedCallback $callback;
                    final /* synthetic */ boolean $beacons;
                    final /* synthetic */ boolean $lastTokenBeacons;
                    {
                        this.$verificationManager = $verificationManager;
                        this.$googlePlayProjectNumber = $googlePlayProjectNumber;
                        this.$callback = $callback;
                        this.$beacons = $beacons;
                        this.$lastTokenBeacons = $lastTokenBeacons;
                    }

                    public void onComplete(@NotNull Radar.RadarStatus status, @Nullable Location location, boolean stopped) {
                        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
                        if (status != Radar.RadarStatus.SUCCESS || location == null) {
                            Radar.INSTANCE.getHandler$sdk_release().post(() -> trackVerified.onComplete.2.onComplete$lambda-0(this.$callback, status));
                            return;
                        }
                        String requestHash = this.$verificationManager.getRequestHash(location);
                        this.$verificationManager.getIntegrityToken(this.$googlePlayProjectNumber, requestHash, (Function2<? super String, ? super String, Unit>)((Function2)new Function2<String, String, Unit>(this.$beacons, location, this.$verificationManager, this.$lastTokenBeacons, this.$callback){
                            final /* synthetic */ boolean $beacons;
                            final /* synthetic */ Location $location;
                            final /* synthetic */ RadarVerificationManager $verificationManager;
                            final /* synthetic */ boolean $lastTokenBeacons;
                            final /* synthetic */ Radar.RadarTrackVerifiedCallback $callback;
                            {
                                this.$beacons = $beacons;
                                this.$location = $location;
                                this.$verificationManager = $verificationManager;
                                this.$lastTokenBeacons = $lastTokenBeacons;
                                this.$callback = $callback;
                                super(2);
                            }

                            public final void invoke(@Nullable String integrityToken, @Nullable String integrityException) {
                                Function1 callTrackApi2 = (Function1)new Function1<RadarBeacon[], Unit>(this.$location, this.$verificationManager, integrityToken, integrityException, this.$lastTokenBeacons, this.$callback){
                                    final /* synthetic */ Location $location;
                                    final /* synthetic */ RadarVerificationManager $verificationManager;
                                    final /* synthetic */ String $integrityToken;
                                    final /* synthetic */ String $integrityException;
                                    final /* synthetic */ boolean $lastTokenBeacons;
                                    final /* synthetic */ Radar.RadarTrackVerifiedCallback $callback;
                                    {
                                        this.$location = $location;
                                        this.$verificationManager = $verificationManager;
                                        this.$integrityToken = $integrityToken;
                                        this.$integrityException = $integrityException;
                                        this.$lastTokenBeacons = $lastTokenBeacons;
                                        this.$callback = $callback;
                                        super(1);
                                    }

                                    public final void invoke(@Nullable RadarBeacon[] beacons) {
                                        Radar.INSTANCE.getApiClient$sdk_release().track$sdk_release(this.$location, RadarState.INSTANCE.getStopped$sdk_release(RadarVerificationManager.access$getContext$p(this.$verificationManager)), RadarActivityLifecycleCallbacks.Companion.getForeground(), Radar.RadarLocationSource.FOREGROUND_LOCATION, false, beacons, true, this.$integrityToken, this.$integrityException, false, RadarVerificationManager.access$getExpectedCountryCode$p(this.$verificationManager), RadarVerificationManager.access$getExpectedStateCode$p(this.$verificationManager), new RadarApiClient.RadarTrackApiCallback(this.$verificationManager, this.$lastTokenBeacons, this.$callback){
                                            final /* synthetic */ RadarVerificationManager $verificationManager;
                                            final /* synthetic */ boolean $lastTokenBeacons;
                                            final /* synthetic */ Radar.RadarTrackVerifiedCallback $callback;
                                            {
                                                this.$verificationManager = $verificationManager;
                                                this.$lastTokenBeacons = $lastTokenBeacons;
                                                this.$callback = $callback;
                                            }

                                            public void onComplete(@NotNull Radar.RadarStatus status, @Nullable JSONObject res, @Nullable RadarEvent[] events, @Nullable RadarUser user, @Nullable RadarGeofence[] nearbyGeofences, @Nullable RadarConfig config, @Nullable RadarVerifiedLocationToken token) {
                                                Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
                                                if (status == Radar.RadarStatus.SUCCESS) {
                                                    RadarConfig radarConfig = config;
                                                    Radar.INSTANCE.getLocationManager$sdk_release().updateTrackingFromMeta$sdk_release(radarConfig != null ? radarConfig.getMeta() : null);
                                                }
                                                if (token != null) {
                                                    RadarVerificationManager.access$setLastToken$p(this.$verificationManager, token);
                                                    RadarVerificationManager.access$setLastTokenElapsedRealtime$p(this.$verificationManager, SystemClock.elapsedRealtime());
                                                    RadarVerificationManager.access$setLastTokenBeacons$p(this.$verificationManager, this.$lastTokenBeacons);
                                                }
                                                Radar.INSTANCE.getHandler$sdk_release().post(() -> trackVerified.onComplete.onComplete.callTrackApi.1.onComplete$lambda-0(this.$callback, status, token));
                                            }

                                            private static final void onComplete$lambda-0(Radar.RadarTrackVerifiedCallback $callback, Radar.RadarStatus $status, RadarVerifiedLocationToken $token) {
                                                block0: {
                                                    Intrinsics.checkNotNullParameter((Object)((Object)$status), (String)"$status");
                                                    Radar.RadarTrackVerifiedCallback radarTrackVerifiedCallback = $callback;
                                                    if (radarTrackVerifiedCallback == null) break block0;
                                                    radarTrackVerifiedCallback.onComplete($status, $token);
                                                }
                                            }
                                        });
                                    }
                                };
                                if (this.$beacons && Build.VERSION.SDK_INT >= 26) {
                                    Radar.INSTANCE.getApiClient$sdk_release().searchBeacons$sdk_release(this.$location, 1000, 10, new RadarApiClient.RadarSearchBeaconsApiCallback((Function1<? super RadarBeacon[], Unit>)callTrackApi2){
                                        final /* synthetic */ Function1<RadarBeacon[], Unit> $callTrackApi;
                                        {
                                            this.$callTrackApi = $callTrackApi;
                                        }

                                        public void onComplete(@NotNull Radar.RadarStatus status, @Nullable JSONObject res, @Nullable RadarBeacon[] beacons, @Nullable String[] uuids, @Nullable String[] uids) {
                                            Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
                                            String[] stringArray = uuids;
                                            if (!(stringArray == null || stringArray.length == 0) || !((stringArray = uids) == null || stringArray.length == 0)) {
                                                Radar.INSTANCE.getBeaconManager$sdk_release().startMonitoringBeaconUUIDs(uuids, uids);
                                                Radar.INSTANCE.getBeaconManager$sdk_release().rangeBeaconUUIDs(uuids, uids, false, new Radar.RadarBeaconCallback(this.$callTrackApi){
                                                    final /* synthetic */ Function1<RadarBeacon[], Unit> $callTrackApi;
                                                    {
                                                        this.$callTrackApi = $callTrackApi;
                                                    }

                                                    public void onComplete(@NotNull Radar.RadarStatus status, @Nullable RadarBeacon[] beacons) {
                                                        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
                                                        if (status != Radar.RadarStatus.SUCCESS || beacons == null) {
                                                            this.$callTrackApi.invoke(null);
                                                            return;
                                                        }
                                                        this.$callTrackApi.invoke((Object)beacons);
                                                    }
                                                });
                                            } else if (beacons != null) {
                                                Radar.INSTANCE.getBeaconManager$sdk_release().startMonitoringBeacons(beacons);
                                                Radar.INSTANCE.getBeaconManager$sdk_release().rangeBeacons(beacons, false, new Radar.RadarBeaconCallback(this.$callTrackApi){
                                                    final /* synthetic */ Function1<RadarBeacon[], Unit> $callTrackApi;
                                                    {
                                                        this.$callTrackApi = $callTrackApi;
                                                    }

                                                    public void onComplete(@NotNull Radar.RadarStatus status, @Nullable RadarBeacon[] beacons) {
                                                        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
                                                        if (status != Radar.RadarStatus.SUCCESS || beacons == null) {
                                                            this.$callTrackApi.invoke(null);
                                                            return;
                                                        }
                                                        this.$callTrackApi.invoke((Object)beacons);
                                                    }
                                                });
                                            } else {
                                                this.$callTrackApi.invoke((Object)new RadarBeacon[0]);
                                            }
                                        }
                                    }, false);
                                } else {
                                    callTrackApi2.invoke(null);
                                }
                            }
                        }));
                    }

                    private static final void onComplete$lambda-0(Radar.RadarTrackVerifiedCallback $callback, Radar.RadarStatus $status) {
                        block0: {
                            Intrinsics.checkNotNullParameter((Object)((Object)$status), (String)"$status");
                            Radar.RadarTrackVerifiedCallback radarTrackVerifiedCallback = $callback;
                            if (radarTrackVerifiedCallback == null) break block0;
                            Radar.RadarTrackVerifiedCallback.DefaultImpls.onComplete$default(radarTrackVerifiedCallback, $status, null, 2, null);
                        }
                    }
                });
            }

            private static final void onComplete$lambda-0(Radar.RadarTrackVerifiedCallback $callback, Radar.RadarStatus $status) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)((Object)$status), (String)"$status");
                    Radar.RadarTrackVerifiedCallback radarTrackVerifiedCallback = $callback;
                    if (radarTrackVerifiedCallback == null) break block0;
                    Radar.RadarTrackVerifiedCallback.DefaultImpls.onComplete$default(radarTrackVerifiedCallback, $status, null, 2, null);
                }
            }
        });
    }

    public static /* synthetic */ void trackVerified$default(RadarVerificationManager radarVerificationManager, boolean bl, Radar.RadarTrackVerifiedCallback radarTrackVerifiedCallback, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            radarTrackVerifiedCallback = null;
        }
        radarVerificationManager.trackVerified(bl, radarTrackVerifiedCallback);
    }

    public final void startTrackingVerified(int interval, boolean beacons) {
        RadarVerificationManager verificationManager = this;
        verificationManager.started = true;
        verificationManager.scheduled = false;
        Function0 trackVerified2 = (Function0)new Function0<Unit>(verificationManager, beacons, interval, this){
            final /* synthetic */ RadarVerificationManager $verificationManager;
            final /* synthetic */ boolean $beacons;
            final /* synthetic */ int $interval;
            final /* synthetic */ RadarVerificationManager this$0;
            {
                this.$verificationManager = $verificationManager;
                this.$beacons = $beacons;
                this.$interval = $interval;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.$verificationManager.trackVerified(this.$beacons, new Radar.RadarTrackVerifiedCallback(this.$interval, this.$verificationManager, this.this$0){
                    final /* synthetic */ int $interval;
                    final /* synthetic */ RadarVerificationManager $verificationManager;
                    final /* synthetic */ RadarVerificationManager this$0;
                    {
                        this.$interval = $interval;
                        this.$verificationManager = $verificationManager;
                        this.this$0 = $receiver;
                    }

                    public void onComplete(@NotNull Radar.RadarStatus status, @Nullable RadarVerifiedLocationToken token) {
                        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
                        int expiresIn = 0;
                        int minInterval = 0;
                        minInterval = this.$interval;
                        RadarVerifiedLocationToken radarVerifiedLocationToken = token;
                        if (radarVerifiedLocationToken != null) {
                            RadarVerifiedLocationToken radarVerifiedLocationToken2 = radarVerifiedLocationToken;
                            int n = this.$interval;
                            RadarVerifiedLocationToken it = radarVerifiedLocationToken2;
                            boolean bl = false;
                            expiresIn = it.getExpiresIn();
                            minInterval = Math.min(it.getExpiresIn(), n);
                        }
                        if (minInterval > 20) {
                            minInterval -= 10;
                        }
                        if (minInterval < 10) {
                            minInterval = 10;
                        }
                        if (RadarVerificationManager.access$getScheduled$p(this.$verificationManager)) {
                            RadarLogger.d$default(RadarVerificationManager.access$getLogger$p(this.$verificationManager), "Token request already scheduled", null, null, 6, null);
                            return;
                        }
                        RadarLogger.d$default(RadarVerificationManager.access$getLogger$p(this.$verificationManager), "Requesting token again in " + minInterval + " seconds | minInterval = " + minInterval + "; expiresIn = " + expiresIn + "; interval = " + this.$interval, null, null, 6, null);
                        RadarVerificationManager.access$setScheduled$p(this.$verificationManager, true);
                        RadarVerificationManager.access$getHandler$p(this.this$0).postDelayed(new Runnable(this.$verificationManager, this.this$0){
                            final /* synthetic */ RadarVerificationManager $verificationManager;
                            final /* synthetic */ RadarVerificationManager this$0;
                            {
                                this.$verificationManager = $verificationManager;
                                this.this$0 = $receiver;
                            }

                            public void run() {
                                if (RadarVerificationManager.access$getStarted$p(this.$verificationManager)) {
                                    RadarLogger.d$default(RadarVerificationManager.access$getLogger$p(this.$verificationManager), "Token request interval fired", null, null, 6, null);
                                    RadarVerificationManager.trackVerified$default(this.this$0, false, null, 3, null);
                                    RadarVerificationManager.access$setScheduled$p(this.$verificationManager, false);
                                }
                            }
                        }, (long)minInterval * 1000L);
                    }
                });
            }
        };
        NetworkRequest request = new NetworkRequest.Builder().addTransportType(3).addTransportType(0).addTransportType(2).addTransportType(1).removeCapability(15).build();
        Function0 handleNetworkChange2 = (Function0)new Function0<Unit>(verificationManager, (Function0<Unit>)trackVerified2){
            final /* synthetic */ RadarVerificationManager $verificationManager;
            final /* synthetic */ Function0<Unit> $trackVerified;
            {
                this.$verificationManager = $verificationManager;
                this.$trackVerified = $trackVerified;
                super(0);
            }

            public final void invoke() {
                String ips = this.$verificationManager.getIPs();
                boolean changed = false;
                if (RadarVerificationManager.access$getLastIPs$p(this.$verificationManager) == null) {
                    RadarLogger.d$default(RadarVerificationManager.access$getLogger$p(this.$verificationManager), "First time getting IPs", null, null, 6, null);
                    changed = false;
                } else if (Intrinsics.areEqual((Object)ips, (Object)"error")) {
                    RadarLogger.d$default(RadarVerificationManager.access$getLogger$p(this.$verificationManager), "Error getting IPs", null, null, 6, null);
                    changed = true;
                } else if (!Intrinsics.areEqual((Object)ips, (Object)RadarVerificationManager.access$getLastIPs$p(this.$verificationManager))) {
                    RadarLogger.d$default(RadarVerificationManager.access$getLogger$p(this.$verificationManager), "IPs changed | ips = " + ips + "; lastIPs = " + RadarVerificationManager.access$getLastIPs$p(this.$verificationManager), null, null, 6, null);
                    changed = true;
                } else {
                    RadarLogger.d$default(RadarVerificationManager.access$getLogger$p(this.$verificationManager), "IPs unchanged", null, null, 6, null);
                }
                RadarVerificationManager.access$setLastIPs$p(this.$verificationManager, ips);
                if (changed) {
                    this.$trackVerified.invoke();
                }
            }
        };
        ConnectivityManager.NetworkCallback networkCallback = this.networkCallback = (ConnectivityManager.NetworkCallback)new ConnectivityManager.NetworkCallback(verificationManager, (Function0<Unit>)handleNetworkChange2){
            final /* synthetic */ RadarVerificationManager $verificationManager;
            final /* synthetic */ Function0<Unit> $handleNetworkChange;
            {
                this.$verificationManager = $verificationManager;
                this.$handleNetworkChange = $handleNetworkChange;
            }

            public void onAvailable(@NotNull Network network) {
                Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                super.onAvailable(network);
                RadarLogger.d$default(RadarVerificationManager.access$getLogger$p(this.$verificationManager), "Network connected", null, null, 6, null);
                this.$handleNetworkChange.invoke();
            }

            public void onLost(@NotNull Network network) {
                Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                super.onLost(network);
                RadarLogger.d$default(RadarVerificationManager.access$getLogger$p(this.$verificationManager), "Network lost", null, null, 6, null);
                this.$handleNetworkChange.invoke();
            }
        };
        if (networkCallback != null) {
            ConnectivityManager.NetworkCallback it = networkCallback;
            boolean bl = false;
            this.connectivityManager.registerNetworkCallback(request, it);
        }
        trackVerified2.invoke();
    }

    public final void stopTrackingVerified() {
        block0: {
            this.started = false;
            ConnectivityManager.NetworkCallback networkCallback = this.networkCallback;
            if (networkCallback == null) break block0;
            ConnectivityManager.NetworkCallback it = networkCallback;
            boolean bl = false;
            this.connectivityManager.unregisterNetworkCallback(it);
        }
    }

    public final void getVerifiedLocationToken(@Nullable Radar.RadarTrackVerifiedCallback callback) {
        long lastTokenElapsed = (SystemClock.elapsedRealtime() - this.lastTokenElapsedRealtime) / (long)1000;
        if (this.lastToken != null) {
            RadarVerifiedLocationToken radarVerifiedLocationToken = this.lastToken;
            if (radarVerifiedLocationToken != null) {
                RadarVerifiedLocationToken it = radarVerifiedLocationToken;
                boolean bl = false;
                if (lastTokenElapsed < (long)it.getExpiresIn()) {
                    RadarLogger.d$default(Radar.INSTANCE.getLogger$sdk_release(), "Last token valid | lastToken.expiresIn = " + it.getExpiresIn() + "; lastTokenElapsed = " + lastTokenElapsed, null, null, 6, null);
                    Radar.flushLogs$sdk_release();
                    Radar.RadarTrackVerifiedCallback radarTrackVerifiedCallback = callback;
                    if (radarTrackVerifiedCallback != null) {
                        radarTrackVerifiedCallback.onComplete(Radar.RadarStatus.SUCCESS, it);
                    }
                    return;
                }
                RadarLogger.d$default(Radar.INSTANCE.getLogger$sdk_release(), "Last token invalid | lastToken.expiresIn = " + it.getExpiresIn() + "; lastTokenElapsed = " + lastTokenElapsed, null, null, 6, null);
            }
        } else {
            RadarLogger.d$default(Radar.INSTANCE.getLogger$sdk_release(), "No last token", null, null, 6, null);
        }
        this.trackVerified(this.lastTokenBeacons, callback);
    }

    public static /* synthetic */ void getVerifiedLocationToken$default(RadarVerificationManager radarVerificationManager, Radar.RadarTrackVerifiedCallback radarTrackVerifiedCallback, int n, Object object) {
        if ((n & 1) != 0) {
            radarTrackVerifiedCallback = null;
        }
        radarVerificationManager.getVerifiedLocationToken(radarTrackVerifiedCallback);
    }

    public final void setExpectedJurisdiction(@Nullable String countryCode, @Nullable String stateCode) {
        this.expectedCountryCode = countryCode;
        this.expectedStateCode = stateCode;
    }

    @NotNull
    public final String getRequestHash(@NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        StringBuilder stringBuffer = new StringBuilder();
        stringBuffer.append(RadarSettings.INSTANCE.getInstallId$sdk_release(this.context));
        stringBuffer.append(location.getLatitude());
        stringBuffer.append(location.getLongitude());
        stringBuffer.append(location.isFromMockProvider());
        stringBuffer.append(RadarUtils.INSTANCE.isScreenSharing$sdk_release(this.context));
        String string = stringBuffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stringBuffer.toString()");
        return RadarUtils.INSTANCE.hashSHA256(string);
    }

    private final void warmUpProviderAndFetchTokenFromGoogle(long googlePlayProjectNumber, String requestHash, Function2<? super String, ? super String, Unit> block) {
        if (!this.isIntegrityApiIncluded()) {
            String integrityException = "Integrity API not included";
            RadarLogger.w$default(this.logger, integrityException, null, null, 6, null);
            block.invoke(null, (Object)integrityException);
            return;
        }
        StandardIntegrityManager standardIntegrityManager = IntegrityManagerFactory.createStandard((Context)this.context);
        Intrinsics.checkNotNullExpressionValue((Object)standardIntegrityManager, (String)"createStandard(this.context)");
        StandardIntegrityManager standardIntegrityManager2 = standardIntegrityManager;
        standardIntegrityManager2.prepareIntegrityToken(StandardIntegrityManager.PrepareIntegrityTokenRequest.builder().setCloudProjectNumber(googlePlayProjectNumber).build()).addOnSuccessListener(arg_0 -> RadarVerificationManager.warmUpProviderAndFetchTokenFromGoogle$lambda-3(this, requestHash, block, arg_0)).addOnFailureListener(arg_0 -> RadarVerificationManager.warmUpProviderAndFetchTokenFromGoogle$lambda-4(block, arg_0));
    }

    public final void getIntegrityToken(@Nullable Long googlePlayProjectNumber, @Nullable String requestHash, @NotNull Function2<? super String, ? super String, Unit> block) {
        boolean warmUpProvider;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if (!this.isIntegrityApiIncluded()) {
            String integrityException = "Integrity API not included";
            RadarLogger.w$default(this.logger, integrityException, null, null, 6, null);
            block.invoke(null, (Object)integrityException);
            return;
        }
        if (requestHash == null) {
            String integrityException = "Missing request hash";
            RadarLogger.d$default(this.logger, integrityException, null, null, 6, null);
            block.invoke(null, (Object)integrityException);
            return;
        }
        if (googlePlayProjectNumber == null) {
            String integrityException = "Google Play project number is null";
            RadarLogger.d$default(this.logger, "Error warming up integrity token provider: Google Play project number is null", null, null, 6, null);
            block.invoke(null, (Object)integrityException);
            return;
        }
        long nowSeconds = System.currentTimeMillis() / (long)1000;
        boolean bl = warmUpProvider = this.standardIntegrityTokenProvider == null || this.lastWarmUpTimestampSeconds == 0L || nowSeconds - this.lastWarmUpTimestampSeconds > 43200L;
        if (warmUpProvider) {
            this.warmUpProviderAndFetchTokenFromGoogle(googlePlayProjectNumber, requestHash, block);
            return;
        }
        this.fetchTokenFromGoogle(requestHash, block);
    }

    private final void fetchTokenFromGoogle(String requestHash, Function2<? super String, ? super String, Unit> block) {
        if (!this.isIntegrityApiIncluded()) {
            String integrityException = "Integrity API not included";
            RadarLogger.w$default(this.logger, integrityException, null, null, 6, null);
            block.invoke(null, (Object)integrityException);
            return;
        }
        RadarLogger.d$default(this.logger, "Requesting integrity token", null, null, 6, null);
        StandardIntegrityManager.StandardIntegrityTokenProvider standardIntegrityTokenProvider = this.standardIntegrityTokenProvider;
        if (standardIntegrityTokenProvider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"standardIntegrityTokenProvider");
            standardIntegrityTokenProvider = null;
        }
        Task task = standardIntegrityTokenProvider.request(StandardIntegrityManager.StandardIntegrityTokenRequest.builder().setRequestHash(requestHash).build());
        Intrinsics.checkNotNullExpressionValue((Object)task, (String)"this.standardIntegrityTo\u2026       .build()\n        )");
        Task integrityTokenResponse = task;
        integrityTokenResponse.addOnSuccessListener(arg_0 -> RadarVerificationManager.fetchTokenFromGoogle$lambda-5(this, block, arg_0)).addOnFailureListener(arg_0 -> RadarVerificationManager.fetchTokenFromGoogle$lambda-6(this, block, arg_0));
    }

    @NotNull
    public final String getIPs() {
        List ips = new ArrayList();
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"getNetworkInterfaces()");
            Enumeration<NetworkInterface> interfaces = enumeration;
            while (interfaces.hasMoreElements()) {
                Enumeration<InetAddress> addresses;
                NetworkInterface networkInterface;
                Intrinsics.checkNotNullExpressionValue((Object)interfaces.nextElement(), (String)"interfaces.nextElement()");
                Intrinsics.checkNotNullExpressionValue(networkInterface.getInetAddresses(), (String)"networkInterface.inetAddresses");
                while (addresses.hasMoreElements()) {
                    String it;
                    InetAddress address;
                    Intrinsics.checkNotNullExpressionValue((Object)addresses.nextElement(), (String)"addresses.nextElement()");
                    if (address.getHostAddress() == null) continue;
                    boolean bl = false;
                    ips.add(it);
                }
            }
        }
        catch (Exception e) {
            RadarLogger.d$default(this.logger, "Error getting IPs | e = " + e.getLocalizedMessage(), null, null, 6, null);
            return "error";
        }
        if (ips.size() > 0) {
            return CollectionsKt.joinToString$default((Iterable)ips, (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
        }
        return "error";
    }

    private static final void warmUpProviderAndFetchTokenFromGoogle$lambda-3(RadarVerificationManager this$0, String $requestHash, Function2 $block, StandardIntegrityManager.StandardIntegrityTokenProvider tokenProvider) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$block, (String)"$block");
        Intrinsics.checkNotNullExpressionValue((Object)tokenProvider, (String)"tokenProvider");
        this$0.standardIntegrityTokenProvider = tokenProvider;
        RadarLogger.d$default(Radar.INSTANCE.getLogger$sdk_release(), "Successfully warmed up integrity token provider", null, null, 6, null);
        this$0.lastWarmUpTimestampSeconds = System.currentTimeMillis() / (long)1000;
        this$0.fetchTokenFromGoogle($requestHash, (Function2<? super String, ? super String, Unit>)$block);
    }

    private static final void warmUpProviderAndFetchTokenFromGoogle$lambda-4(Function2 $block, Exception exception) {
        Intrinsics.checkNotNullParameter((Object)$block, (String)"$block");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        String warmupException = exception.getMessage();
        Radar.INSTANCE.getLogger$sdk_release().e("Error warming up integrity token provider | warmupException = " + warmupException, Radar.RadarLogType.SDK_ERROR, exception);
        $block.invoke(null, (Object)warmupException);
    }

    private static final void fetchTokenFromGoogle$lambda-5(RadarVerificationManager this$0, Function2 $block, StandardIntegrityManager.StandardIntegrityToken response) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$block, (String)"$block");
        String integrityToken = response.token();
        RadarLogger.d$default(this$0.logger, "Successfully requested integrity token | integrityToken = " + integrityToken, null, null, 6, null);
        $block.invoke((Object)integrityToken, null);
    }

    private static final void fetchTokenFromGoogle$lambda-6(RadarVerificationManager this$0, Function2 $block, Exception exception) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$block, (String)"$block");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        String integrityException = exception.getMessage();
        RadarLogger.d$default(this$0.logger, "Error requesting integrity token | integrityException = " + integrityException, null, null, 6, null);
        $block.invoke(null, (Object)integrityException);
    }

    public static final /* synthetic */ Context access$getContext$p(RadarVerificationManager $this) {
        return $this.context;
    }

    public static final /* synthetic */ String access$getExpectedCountryCode$p(RadarVerificationManager $this) {
        return $this.expectedCountryCode;
    }

    public static final /* synthetic */ String access$getExpectedStateCode$p(RadarVerificationManager $this) {
        return $this.expectedStateCode;
    }

    public static final /* synthetic */ void access$setLastToken$p(RadarVerificationManager $this, RadarVerifiedLocationToken radarVerifiedLocationToken) {
        $this.lastToken = radarVerifiedLocationToken;
    }

    public static final /* synthetic */ void access$setLastTokenElapsedRealtime$p(RadarVerificationManager $this, long l) {
        $this.lastTokenElapsedRealtime = l;
    }

    public static final /* synthetic */ void access$setLastTokenBeacons$p(RadarVerificationManager $this, boolean bl) {
        $this.lastTokenBeacons = bl;
    }

    public static final /* synthetic */ boolean access$getScheduled$p(RadarVerificationManager $this) {
        return $this.scheduled;
    }

    public static final /* synthetic */ RadarLogger access$getLogger$p(RadarVerificationManager $this) {
        return $this.logger;
    }

    public static final /* synthetic */ void access$setScheduled$p(RadarVerificationManager $this, boolean bl) {
        $this.scheduled = bl;
    }

    public static final /* synthetic */ Handler access$getHandler$p(RadarVerificationManager $this) {
        return $this.handler;
    }

    public static final /* synthetic */ boolean access$getStarted$p(RadarVerificationManager $this) {
        return $this.started;
    }

    public static final /* synthetic */ String access$getLastIPs$p(RadarVerificationManager $this) {
        return $this.lastIPs;
    }

    public static final /* synthetic */ void access$setLastIPs$p(RadarVerificationManager $this, String string) {
        $this.lastIPs = string;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/radar/sdk/RadarVerificationManager$Companion;", "", "()V", "WARM_UP_WINDOW_SECONDS", "", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

