/*
 * Decompiled with CFR 0.152.
 */
package io.radar.sdk;

import android.content.Context;
import android.location.Location;
import io.radar.sdk.Radar;
import io.radar.sdk.RadarLogger;
import io.radar.sdk.RadarSettings;
import io.radar.sdk.RadarState;
import io.radar.sdk.RadarTrackingOptions;
import io.radar.sdk.RadarTripOptions;
import io.radar.sdk.model.RadarCircleGeometry;
import io.radar.sdk.model.RadarConfig;
import io.radar.sdk.model.RadarCoordinate;
import io.radar.sdk.model.RadarGeofence;
import io.radar.sdk.model.RadarPolygonGeometry;
import io.radar.sdk.model.RadarRemoteTrackingOptions;
import io.radar.sdk.model.RadarSdkConfiguration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u000bJ \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\bH\u0002\u00a8\u0006\u0014"}, d2={"Lio/radar/sdk/RadarOfflineManager;", "", "()V", "contextualizeLocation", "", "context", "Landroid/content/Context;", "location", "Landroid/location/Location;", "callback", "Lio/radar/sdk/RadarOfflineManager$RadarOfflineCallback;", "contextualizeLocation$sdk_release", "isPointInsideCircle", "", "center", "Lio/radar/sdk/model/RadarCoordinate;", "radius", "", "point", "RadarOfflineCallback", "sdk_release"})
public final class RadarOfflineManager {
    public final void contextualizeLocation$sdk_release(@NotNull Context context, @NotNull Location location, @NotNull RadarOfflineCallback callback) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        Set newGeofenceIds = new LinkedHashSet();
        Set newGeofenceTags = new LinkedHashSet();
        Object[] nearbyGeofences = RadarState.INSTANCE.getNearbyGeofences$sdk_release(context);
        if (nearbyGeofences == null) {
            RadarLogger.d$default(Radar.INSTANCE.getLogger$sdk_release(), "skipping as no synced nearby geofence", null, null, 6, null);
            callback.onComplete(null);
            return;
        }
        Iterator iterator = ArrayIteratorKt.iterator((Object[])nearbyGeofences);
        while (iterator.hasNext()) {
            RadarGeofence geofence = (RadarGeofence)iterator.next();
            RadarCoordinate center = null;
            double radius = 100.0;
            if (geofence.getGeometry() instanceof RadarCircleGeometry) {
                center = ((RadarCircleGeometry)geofence.getGeometry()).getCenter();
                radius = ((RadarCircleGeometry)geofence.getGeometry()).getRadius();
            } else if (geofence.getGeometry() instanceof RadarPolygonGeometry) {
                center = ((RadarPolygonGeometry)geofence.getGeometry()).getCenter();
                radius = ((RadarPolygonGeometry)geofence.getGeometry()).getRadius();
            } else {
                RadarLogger.e$default(Radar.INSTANCE.getLogger$sdk_release(), "Unsupported geofence geometry type", null, null, 6, null);
                continue;
            }
            if (!this.isPointInsideCircle(center, radius, location)) continue;
            newGeofenceIds.add(geofence.get_id());
            if (geofence.getTag() == null) continue;
            newGeofenceTags.add(geofence.getTag());
        }
        RadarState.INSTANCE.setGeofenceIds$sdk_release(context, newGeofenceIds);
        RadarSdkConfiguration sdkConfiguration = RadarSettings.INSTANCE.getSdkConfiguration(context);
        Object[] rampUpGeofenceTags = RadarRemoteTrackingOptions.Companion.getGeofenceTagsWithKey(sdkConfiguration.getRemoteTrackingOptions(), "inGeofence");
        boolean isRampedUp = false;
        Object radius = rampUpGeofenceTags;
        if (!(radius == null || ((String[])radius).length == 0)) {
            radius = ArrayIteratorKt.iterator((Object[])rampUpGeofenceTags);
            while (radius.hasNext()) {
                String tag = (String)radius.next();
                if (!newGeofenceTags.contains(tag)) continue;
                isRampedUp = true;
                break;
            }
        }
        RadarTrackingOptions newTrackingOptions = null;
        if (isRampedUp) {
            RadarLogger.d$default(Radar.INSTANCE.getLogger$sdk_release(), "Ramp up geofences with trackingOptions: " + sdkConfiguration + ".inGeofenceTrackingOptions", null, null, 6, null);
            newTrackingOptions = RadarRemoteTrackingOptions.Companion.getRemoteTrackingOptionsWithKey(sdkConfiguration.getRemoteTrackingOptions(), "inGeofence");
        } else {
            RadarTripOptions tripOptions = RadarSettings.INSTANCE.getTripOptions$sdk_release(context);
            if (tripOptions != null && RadarRemoteTrackingOptions.Companion.getRemoteTrackingOptionsWithKey(sdkConfiguration.getRemoteTrackingOptions(), "onTrip") != null) {
                RadarLogger.d$default(Radar.INSTANCE.getLogger$sdk_release(), "Ramp down geofences with trackingOptions: " + sdkConfiguration + ".6onTripTrackingOptions", null, null, 6, null);
                newTrackingOptions = RadarRemoteTrackingOptions.Companion.getRemoteTrackingOptionsWithKey(sdkConfiguration.getRemoteTrackingOptions(), "onTrip");
            } else {
                RadarLogger.d$default(Radar.INSTANCE.getLogger$sdk_release(), "Ramp down geofences with trackingOptions: " + sdkConfiguration + ".defaultTrackingOptions", null, null, 6, null);
                newTrackingOptions = RadarRemoteTrackingOptions.Companion.getRemoteTrackingOptionsWithKey(sdkConfiguration.getRemoteTrackingOptions(), "default");
            }
        }
        if (newTrackingOptions != null) {
            JSONObject metaDict = new JSONObject();
            metaDict.put("trackingOptions", (Object)newTrackingOptions.toJson());
            JSONObject configDict = new JSONObject();
            configDict.put("meta", (Object)metaDict);
            callback.onComplete(RadarConfig.Companion.fromJson(configDict));
            return;
        }
        callback.onComplete(null);
    }

    private final boolean isPointInsideCircle(RadarCoordinate center, double radius, Location point) {
        Location centerLocation = new Location("centerLocation");
        centerLocation.setLatitude(center.getLatitude());
        centerLocation.setLongitude(center.getLongitude());
        float distanceBetween = point.distanceTo(centerLocation);
        return (double)distanceBetween <= radius;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&\u00a8\u0006\u0006"}, d2={"Lio/radar/sdk/RadarOfflineManager$RadarOfflineCallback;", "", "onComplete", "", "config", "Lio/radar/sdk/model/RadarConfig;", "sdk_release"})
    public static interface RadarOfflineCallback {
        public void onComplete(@Nullable RadarConfig var1);
    }
}

