/*
 * Decompiled with CFR 0.152.
 */
package io.radar.sdk.model;

import io.radar.sdk.RadarTrackingOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0010\u001a\u00020\u0011R\u001b\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0007\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0013"}, d2={"Lio/radar/sdk/model/RadarRemoteTrackingOptions;", "", "type", "", "trackingOptions", "Lio/radar/sdk/RadarTrackingOptions;", "geofenceTags", "", "(Ljava/lang/String;Lio/radar/sdk/RadarTrackingOptions;[Ljava/lang/String;)V", "getGeofenceTags", "()[Ljava/lang/String;", "[Ljava/lang/String;", "getTrackingOptions", "()Lio/radar/sdk/RadarTrackingOptions;", "getType", "()Ljava/lang/String;", "toJson", "Lorg/json/JSONObject;", "Companion", "sdk_release"})
public final class RadarRemoteTrackingOptions {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String type;
    @NotNull
    private final RadarTrackingOptions trackingOptions;
    @Nullable
    private final String[] geofenceTags;
    @NotNull
    private static final String TYPE_ID = "type";
    @NotNull
    private static final String TRACKING_OPTIONS = "trackingOptions";
    @NotNull
    private static final String GEOFENCE_TAGS = "geofenceTags";

    public RadarRemoteTrackingOptions(@NotNull String type, @NotNull RadarTrackingOptions trackingOptions, @Nullable String[] geofenceTags) {
        Intrinsics.checkNotNullParameter((Object)type, (String)TYPE_ID);
        Intrinsics.checkNotNullParameter((Object)trackingOptions, (String)TRACKING_OPTIONS);
        this.type = type;
        this.trackingOptions = trackingOptions;
        this.geofenceTags = geofenceTags;
    }

    @NotNull
    public final String getType() {
        return this.type;
    }

    @NotNull
    public final RadarTrackingOptions getTrackingOptions() {
        return this.trackingOptions;
    }

    @Nullable
    public final String[] getGeofenceTags() {
        return this.geofenceTags;
    }

    @NotNull
    public final JSONObject toJson() {
        JSONObject obj = new JSONObject();
        obj.putOpt(TYPE_ID, (Object)this.type);
        obj.putOpt(TRACKING_OPTIONS, (Object)this.trackingOptions.toJson());
        JSONArray geofenceTagsArr = new JSONArray();
        if (this.geofenceTags != null) {
            String[] $this$forEach$iv = this.geofenceTags;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                String geofenceTag = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                geofenceTagsArr.put((Object)geofenceTag);
            }
            obj.putOpt(GEOFENCE_TAGS, (Object)geofenceTagsArr);
        }
        return obj;
    }

    @JvmStatic
    @Nullable
    public static final RadarRemoteTrackingOptions fromJson(@Nullable JSONObject obj) {
        return Companion.fromJson(obj);
    }

    @JvmStatic
    @Nullable
    public static final RadarRemoteTrackingOptions[] fromJson(@Nullable JSONArray arr) {
        return Companion.fromJson(arr);
    }

    @JvmStatic
    @Nullable
    public static final JSONArray toJson(@Nullable RadarRemoteTrackingOptions[] remoteTrackingOptions) {
        return Companion.toJson(remoteTrackingOptions);
    }

    @JvmStatic
    @Nullable
    public static final RadarTrackingOptions getRemoteTrackingOptionsWithKey(@Nullable RadarRemoteTrackingOptions[] remoteTrackingOptions, @NotNull String key) {
        return Companion.getRemoteTrackingOptionsWithKey(remoteTrackingOptions, key);
    }

    @JvmStatic
    @Nullable
    public static final String[] getGeofenceTagsWithKey(@Nullable RadarRemoteTrackingOptions[] remoteTrackingOptions, @NotNull String key) {
        return Companion.getGeofenceTagsWithKey(remoteTrackingOptions, key);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007\u00a2\u0006\u0002\u0010\fJ\u0014\u0010\u0007\u001a\u0004\u0018\u00010\t2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007J-\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\b2\u000e\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\u0006\u0010\u0011\u001a\u00020\u0004H\u0007\u00a2\u0006\u0002\u0010\u0012J'\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u000e\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\u0006\u0010\u0011\u001a\u00020\u0004H\u0007\u00a2\u0006\u0002\u0010\u0015J\u001f\u0010\u0016\u001a\u0004\u0018\u00010\u000b2\u000e\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bH\u0007\u00a2\u0006\u0002\u0010\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/radar/sdk/model/RadarRemoteTrackingOptions$Companion;", "", "()V", "GEOFENCE_TAGS", "", "TRACKING_OPTIONS", "TYPE_ID", "fromJson", "", "Lio/radar/sdk/model/RadarRemoteTrackingOptions;", "arr", "Lorg/json/JSONArray;", "(Lorg/json/JSONArray;)[Lio/radar/sdk/model/RadarRemoteTrackingOptions;", "obj", "Lorg/json/JSONObject;", "getGeofenceTagsWithKey", "remoteTrackingOptions", "key", "([Lio/radar/sdk/model/RadarRemoteTrackingOptions;Ljava/lang/String;)[Ljava/lang/String;", "getRemoteTrackingOptionsWithKey", "Lio/radar/sdk/RadarTrackingOptions;", "([Lio/radar/sdk/model/RadarRemoteTrackingOptions;Ljava/lang/String;)Lio/radar/sdk/RadarTrackingOptions;", "toJson", "([Lio/radar/sdk/model/RadarRemoteTrackingOptions;)Lorg/json/JSONArray;", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @Nullable
        public final RadarRemoteTrackingOptions fromJson(@Nullable JSONObject obj) {
            String[] stringArray;
            if (obj == null) {
                return null;
            }
            String type = obj.optString(RadarRemoteTrackingOptions.TYPE_ID);
            JSONObject jSONObject = obj.optJSONObject(RadarRemoteTrackingOptions.TRACKING_OPTIONS);
            Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"obj.optJSONObject(TRACKING_OPTIONS)");
            RadarTrackingOptions trackingOptions = RadarTrackingOptions.Companion.fromJson(jSONObject);
            JSONArray jSONArray = obj.optJSONArray(RadarRemoteTrackingOptions.GEOFENCE_TAGS);
            if (jSONArray != null) {
                void $this$toTypedArray$iv;
                void $this$mapTo$iv$iv;
                JSONArray tags = jSONArray;
                boolean bl = false;
                Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)tags.length());
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    void index;
                    int item$iv$iv;
                    int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(tags.getString((int)index));
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
                if (stringArray2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                }
                stringArray = stringArray2;
            } else {
                stringArray = null;
            }
            String[] geofenceTags = stringArray;
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)RadarRemoteTrackingOptions.TYPE_ID);
            return new RadarRemoteTrackingOptions(type, trackingOptions, geofenceTags);
        }

        @JvmStatic
        @Nullable
        public final RadarRemoteTrackingOptions[] fromJson(@Nullable JSONArray arr) {
            if (arr == null) {
                return null;
            }
            int n = 0;
            int n2 = arr.length();
            Object[] objectArray = new RadarRemoteTrackingOptions[n2];
            while (n < n2) {
                int n3 = n++;
                objectArray[n3] = Companion.fromJson(arr.optJSONObject(n3));
            }
            Collection $this$toTypedArray$iv = ArraysKt.filterNotNull((Object[])objectArray);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            RadarRemoteTrackingOptions[] radarRemoteTrackingOptionsArray = thisCollection$iv.toArray(new RadarRemoteTrackingOptions[0]);
            if (radarRemoteTrackingOptionsArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            return radarRemoteTrackingOptionsArray;
        }

        @JvmStatic
        @Nullable
        public final JSONArray toJson(@Nullable RadarRemoteTrackingOptions[] remoteTrackingOptions) {
            if (remoteTrackingOptions == null) {
                return null;
            }
            JSONArray arr = new JSONArray();
            RadarRemoteTrackingOptions[] $this$forEach$iv = remoteTrackingOptions;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                RadarRemoteTrackingOptions element$iv;
                RadarRemoteTrackingOptions remoteTrackingOption = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                arr.put((Object)remoteTrackingOption.toJson());
            }
            return arr;
        }

        @JvmStatic
        @Nullable
        public final RadarTrackingOptions getRemoteTrackingOptionsWithKey(@Nullable RadarRemoteTrackingOptions[] remoteTrackingOptions, @NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            if (remoteTrackingOptions == null) {
                return null;
            }
            Iterator iterator = ArrayIteratorKt.iterator((Object[])remoteTrackingOptions);
            while (iterator.hasNext()) {
                RadarRemoteTrackingOptions remoteTrackingOption = (RadarRemoteTrackingOptions)iterator.next();
                if (!Intrinsics.areEqual((Object)remoteTrackingOption.getType(), (Object)key)) continue;
                return remoteTrackingOption.getTrackingOptions();
            }
            return null;
        }

        @JvmStatic
        @Nullable
        public final String[] getGeofenceTagsWithKey(@Nullable RadarRemoteTrackingOptions[] remoteTrackingOptions, @NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            if (remoteTrackingOptions == null) {
                return null;
            }
            String[] geofenceTags = null;
            Iterator iterator = ArrayIteratorKt.iterator((Object[])remoteTrackingOptions);
            while (iterator.hasNext()) {
                RadarRemoteTrackingOptions remoteTrackingOption = (RadarRemoteTrackingOptions)iterator.next();
                if (!Intrinsics.areEqual((Object)remoteTrackingOption.getType(), (Object)key)) continue;
                geofenceTags = remoteTrackingOption.getGeofenceTags();
            }
            return geofenceTags;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

