/*
 * Decompiled with CFR 0.152.
 */
package io.radar.sdk;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.provider.Settings;
import androidx.annotation.RequiresApi;
import fi.iki.elonen.NanoHTTPD;
import io.radar.sdk.Radar;
import io.radar.sdk.RadarForegroundService;
import io.radar.sdk.RadarLogger;
import io.radar.sdk.model.RadarVerifiedLocationToken;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0003J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\bH\u0016J\b\u0010\u0011\u001a\u00020\bH\u0002J\b\u0010\u0012\u001a\u00020\bH\u0016J\b\u0010\u0013\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/radar/sdk/RadarVerifyServer;", "Lfi/iki/elonen/NanoHTTPD;", "context", "Landroid/content/Context;", "logger", "Lio/radar/sdk/RadarLogger;", "(Landroid/content/Context;Lio/radar/sdk/RadarLogger;)V", "addHeaders", "", "response", "Lfi/iki/elonen/NanoHTTPD$Response;", "isAdbEnabled", "", "serve", "session", "Lfi/iki/elonen/NanoHTTPD$IHTTPSession;", "start", "startForegroundService", "stop", "stopForegroundService", "sdk_release"})
@RequiresApi(value=21)
public final class RadarVerifyServer
extends NanoHTTPD {
    @NotNull
    private final Context context;
    @NotNull
    private final RadarLogger logger;

    public RadarVerifyServer(@NotNull Context context, @NotNull RadarLogger logger) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        super(52516);
        this.context = context;
        this.logger = logger;
    }

    private final void addHeaders(NanoHTTPD.Response response) {
        block2: {
            NanoHTTPD.Response response2 = response;
            if (response2 != null) {
                response2.addHeader("Access-Control-Allow-Headers", "Content-Type, Accept, Authorization, X-Radar-Device-Type, X-Radar-SDK-Version");
            }
            NanoHTTPD.Response response3 = response;
            if (response3 != null) {
                response3.addHeader("Access-Control-Allow-Origin", "*");
            }
            NanoHTTPD.Response response4 = response;
            if (response4 == null) break block2;
            response4.addHeader("Access-Control-Allow-Methods", "GET, OPTIONS");
        }
    }

    public final boolean isAdbEnabled(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int adb = 0;
        try {
            adb = Settings.Secure.getInt((ContentResolver)context.getContentResolver(), (String)"adb_enabled");
        }
        catch (Settings.SettingNotFoundException settingNotFoundException) {
            // empty catch block
        }
        return adb == 1;
    }

    @NotNull
    public NanoHTTPD.Response serve(@NotNull NanoHTTPD.IHTTPSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        NanoHTTPD.Method method = session.getMethod();
        String uri = session.getUri();
        if (NanoHTTPD.Method.OPTIONS == method) {
            NanoHTTPD.Response response = NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK), (String)"application/json", null);
            this.addHeaders(response);
            Intrinsics.checkNotNullExpressionValue((Object)response, (String)"response");
            return response;
        }
        if (NanoHTTPD.Method.GET == method && Intrinsics.areEqual((Object)"/v1/verify", (Object)uri)) {
            String publishableKey = (String)session.getHeaders().get("authorization");
            if (publishableKey == null) {
                NanoHTTPD.Response response = NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.FORBIDDEN), (String)"application/json", null);
                this.addHeaders(response);
                Intrinsics.checkNotNullExpressionValue((Object)response, (String)"response");
                return response;
            }
            List list = (List)session.getParameters().get("Authorization");
            String userId = list != null ? (String)list.get(0) : null;
            List list2 = (List)session.getParameters().get("Authorization");
            String description = list2 != null ? (String)list2.get(0) : null;
            Radar.initialize(this.context, publishableKey);
            Radar.setUserId(userId);
            Radar.setDescription(description);
            CountDownLatch latch = new CountDownLatch(1);
            Ref.ObjectRef response = new Ref.ObjectRef();
            response.element = NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.INTERNAL_ERROR), (String)"application/json", null);
            Radar.trackVerified$default(false, (Function2)new Function2<Radar.RadarStatus, RadarVerifiedLocationToken, Unit>((Ref.ObjectRef<NanoHTTPD.Response>)response, latch){
                final /* synthetic */ Ref.ObjectRef<NanoHTTPD.Response> $response;
                final /* synthetic */ CountDownLatch $latch;
                {
                    this.$response = $response;
                    this.$latch = $latch;
                    super(2);
                }

                public final void invoke(@NotNull Radar.RadarStatus status, @Nullable RadarVerifiedLocationToken token) {
                    Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
                    if (status == Radar.RadarStatus.SUCCESS) {
                        RadarVerifiedLocationToken radarVerifiedLocationToken = token;
                        if (radarVerifiedLocationToken != null && (radarVerifiedLocationToken = radarVerifiedLocationToken.toRawJson()) != null) {
                            RadarVerifiedLocationToken radarVerifiedLocationToken2 = radarVerifiedLocationToken;
                            Ref.ObjectRef<NanoHTTPD.Response> objectRef = this.$response;
                            RadarVerifiedLocationToken it = radarVerifiedLocationToken2;
                            boolean bl = false;
                            it.putOpt("meta", new JSONObject().put("code", 200));
                            String string = it.toString();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.toString()");
                            String resStr = string;
                            objectRef.element = NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK), (String)"application/json", (String)resStr);
                        }
                    } else if (status == Radar.RadarStatus.ERROR_UNAUTHORIZED) {
                        this.$response.element = NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.UNAUTHORIZED), (String)"application/json", null);
                    } else if (status == Radar.RadarStatus.ERROR_FORBIDDEN) {
                        this.$response.element = NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.FORBIDDEN), (String)"application/json", null);
                    } else if (status == Radar.RadarStatus.ERROR_PERMISSIONS) {
                        String resStr = "{\"meta\":{\"code\":400,\"error\":\"ERROR_PERMISSIONS\"}}";
                        this.$response.element = NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.BAD_REQUEST), (String)"application/json", (String)resStr);
                    } else if (status == Radar.RadarStatus.ERROR_LOCATION) {
                        String resStr = "{\"meta\":{\"code\":400,\"error\":\"ERROR_LOCATION\"}}";
                        this.$response.element = NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.BAD_REQUEST), (String)"application/json", (String)resStr);
                    } else if (status == Radar.RadarStatus.ERROR_NETWORK) {
                        String resStr = "{\"meta\":{\"code\":400,\"error\":\"ERROR_NETWORK\"}}";
                        this.$response.element = NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.BAD_REQUEST), (String)"application/json", (String)resStr);
                    }
                    this.$latch.countDown();
                }
            }, 1, null);
            latch.await();
            this.addHeaders((NanoHTTPD.Response)response.element);
            Object object = response.element;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"response");
            return (NanoHTTPD.Response)object;
        }
        NanoHTTPD.Response response = NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.NOT_FOUND), (String)"application/json", null);
        this.addHeaders(response);
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"response");
        return response;
    }

    public void start() {
        super.start();
        this.startForegroundService();
    }

    public void stop() {
        super.stop();
        this.stopForegroundService();
    }

    private final void startForegroundService() {
        if (Build.VERSION.SDK_INT >= 26) {
            Intent intent;
            Intent $this$startForegroundService_u24lambda_u2d0 = intent = new Intent(this.context, RadarForegroundService.class);
            boolean bl = false;
            $this$startForegroundService_u24lambda_u2d0.setAction("start");
            $this$startForegroundService_u24lambda_u2d0.putExtra("title", "Location checks started");
            $this$startForegroundService_u24lambda_u2d0.putExtra("text", "Please return to the browser to continue");
            Intent intent2 = intent;
            this.context.startForegroundService(intent2);
        }
    }

    private final void stopForegroundService() {
        if (Build.VERSION.SDK_INT >= 26) {
            Intent intent;
            Intent $this$stopForegroundService_u24lambda_u2d1 = intent = new Intent(this.context, RadarForegroundService.class);
            boolean bl = false;
            $this$stopForegroundService_u24lambda_u2d1.setAction("stop");
            Intent stopIntent = intent;
            this.context.startService(stopIntent);
        }
    }
}

