/*
 * Decompiled with CFR 0.152.
 */
package io.radar.sdk;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import androidx.activity.ComponentActivity;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.annotation.RequiresApi;
import androidx.core.app.ActivityCompat;
import io.radar.sdk.Radar;
import io.radar.sdk.model.RadarLocationPermissionStatus;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000f\u001a\u00020\u0010J\u001a\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00052\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005H\u0016J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005H\u0016J\u0010\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005H\u0016J\u0006\u0010\u001c\u001a\u00020\u0012J\b\u0010\u001d\u001a\u00020\u0012H\u0007J\u0006\u0010\u001e\u001a\u00020\u0012R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lio/radar/sdk/RadarLocationPermissionManager;", "Landroid/app/Application$ActivityLifecycleCallbacks;", "context", "Landroid/content/Context;", "activity", "Landroid/app/Activity;", "(Landroid/content/Context;Landroid/app/Activity;)V", "danglingBackgroundPermissionRequest", "", "danglingForegroundPermissionRequest", "danglingSettingsPermissionRequest", "requestBackgroundLocationPermissionLauncher", "Landroidx/activity/result/ActivityResultLauncher;", "", "requestForegroundLocationPermissionLauncher", "getLocationPermissionStatus", "Lio/radar/sdk/model/RadarLocationPermissionStatus;", "onActivityCreated", "", "p0", "p1", "Landroid/os/Bundle;", "onActivityDestroyed", "onActivityPaused", "onActivityResumed", "onActivitySaveInstanceState", "onActivityStarted", "onActivityStopped", "openAppSettings", "requestBackgroundLocationPermission", "requestForegroundLocationPermission", "sdk_release"})
public final class RadarLocationPermissionManager
implements Application.ActivityLifecycleCallbacks {
    @NotNull
    private final Context context;
    @Nullable
    private final Activity activity;
    private boolean danglingSettingsPermissionRequest;
    private boolean danglingForegroundPermissionRequest;
    private boolean danglingBackgroundPermissionRequest;
    private ActivityResultLauncher<String> requestForegroundLocationPermissionLauncher;
    private ActivityResultLauncher<String> requestBackgroundLocationPermissionLauncher;

    public RadarLocationPermissionManager(@NotNull Context context, @Nullable Activity activity) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.activity = activity;
        if (this.activity instanceof ComponentActivity) {
            Log.d((String)"LocPermissionManager", (String)"Activity is a ComponentActivity");
            ActivityResultLauncher activityResultLauncher = ((ComponentActivity)this.activity).registerForActivityResult((ActivityResultContract)new ActivityResultContracts.RequestPermission(), arg_0 -> RadarLocationPermissionManager._init_$lambda-0(this, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)activityResultLauncher, (String)"activity.registerForActi\u2026status here\n            }");
            this.requestForegroundLocationPermissionLauncher = activityResultLauncher;
            ActivityResultLauncher activityResultLauncher2 = ((ComponentActivity)this.activity).registerForActivityResult((ActivityResultContract)new ActivityResultContracts.RequestPermission(), arg_0 -> RadarLocationPermissionManager._init_$lambda-1(this, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)activityResultLauncher2, (String)"activity.registerForActi\u2026status here\n            }");
            this.requestBackgroundLocationPermissionLauncher = activityResultLauncher2;
        } else {
            Log.d((String)"LocPermissionManager", (String)"Activity is not a ComponentActivity");
        }
    }

    @RequiresApi(value=29)
    public final void requestBackgroundLocationPermission() {
        Log.d((String)"LocPermissionManager", (String)"requesting background");
        if (this.activity instanceof ComponentActivity) {
            ActivityResultLauncher<String> activityResultLauncher;
            Log.d((String)"LocPermissionManager", (String)"calling activity");
            String string = this.context.getSharedPreferences("RadarSDK", 0).getString("x_platform_sdk_type", null);
            if (string != null) {
                String it = string;
                boolean bl = false;
                Log.d((String)"LocPermissionManager", (String)"x platform side channel");
                this.danglingBackgroundPermissionRequest = true;
            }
            if ((activityResultLauncher = this.requestBackgroundLocationPermissionLauncher) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"requestBackgroundLocationPermissionLauncher");
                activityResultLauncher = null;
            }
            activityResultLauncher.launch((Object)"android.permission.ACCESS_BACKGROUND_LOCATION");
        }
    }

    public final void requestForegroundLocationPermission() {
        Log.d((String)"LocPermissionManager", (String)"requesting foreground");
        if (this.activity instanceof ComponentActivity) {
            Log.d((String)"LocPermissionManager", (String)"calling activity");
            String string = this.context.getSharedPreferences("RadarSDK", 0).getString("x_platform_sdk_type", null);
            if (string != null) {
                String it = string;
                boolean bl = false;
                Log.d((String)"LocPermissionManager", (String)"x platform side channel");
                this.danglingForegroundPermissionRequest = true;
            }
            Radar.INSTANCE.sendLocationPermissionStatus$sdk_release(RadarLocationPermissionStatus.Companion.initWithStatus(this.context, this.activity, true));
            ActivityResultLauncher<String> activityResultLauncher = this.requestForegroundLocationPermissionLauncher;
            if (activityResultLauncher == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"requestForegroundLocationPermissionLauncher");
                activityResultLauncher = null;
            }
            activityResultLauncher.launch((Object)"android.permission.ACCESS_FINE_LOCATION");
        }
    }

    public final void openAppSettings() {
        Intent intent;
        this.danglingSettingsPermissionRequest = true;
        Intent $this$openAppSettings_u24lambda_u2d4 = intent = new Intent();
        boolean bl = false;
        $this$openAppSettings_u24lambda_u2d4.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
        Uri uri = Uri.fromParts((String)"package", (String)this.context.getPackageName(), null);
        $this$openAppSettings_u24lambda_u2d4.setData(uri);
        $this$openAppSettings_u24lambda_u2d4.setFlags(0x10000000);
        Intent intent2 = intent;
        this.context.startActivity(intent2);
    }

    @NotNull
    public final RadarLocationPermissionStatus getLocationPermissionStatus() {
        if (this.activity instanceof ComponentActivity) {
            return RadarLocationPermissionStatus.Companion.initWithStatus$default(RadarLocationPermissionStatus.Companion, this.context, this.activity, false, 4, null);
        }
        return new RadarLocationPermissionStatus();
    }

    public void onActivityPaused(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    public void onActivityStopped(@NotNull Activity p0) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
    }

    public void onActivitySaveInstanceState(@NotNull Activity p0, @NotNull Bundle p1) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
    }

    public void onActivityDestroyed(@NotNull Activity p0) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
    }

    public void onActivityCreated(@NotNull Activity p0, @Nullable Bundle p1) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
    }

    public void onActivityStarted(@NotNull Activity p0) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
    }

    public void onActivityResumed(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (this.danglingSettingsPermissionRequest) {
            Radar.INSTANCE.sendLocationPermissionStatus$sdk_release(RadarLocationPermissionStatus.Companion.initWithStatus$default(RadarLocationPermissionStatus.Companion, this.context, activity, false, 4, null));
        }
        if (this.danglingForegroundPermissionRequest) {
            if (ActivityCompat.checkSelfPermission((Context)this.context, (String)"android.permission.ACCESS_FINE_LOCATION") != 0) {
                RadarLocationPermissionStatus.Companion.savePreviouslyDeniedForeground(this.context, true);
            }
            Radar.INSTANCE.sendLocationPermissionStatus$sdk_release(RadarLocationPermissionStatus.Companion.initWithStatus$default(RadarLocationPermissionStatus.Companion, this.context, activity, false, 4, null));
        }
        if (this.danglingBackgroundPermissionRequest) {
            if (ActivityCompat.checkSelfPermission((Context)this.context, (String)"android.permission.ACCESS_BACKGROUND_LOCATION") != 0) {
                RadarLocationPermissionStatus.Companion.savePreviouslyDeniedBackground(this.context, true);
            }
            Radar.INSTANCE.sendLocationPermissionStatus$sdk_release(RadarLocationPermissionStatus.Companion.initWithStatus$default(RadarLocationPermissionStatus.Companion, this.context, activity, false, 4, null));
        }
        this.danglingSettingsPermissionRequest = false;
        this.danglingBackgroundPermissionRequest = false;
        this.danglingForegroundPermissionRequest = false;
    }

    private static final void _init_$lambda-0(RadarLocationPermissionManager this$0, boolean isGranted) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (!isGranted) {
            RadarLocationPermissionStatus.Companion.savePreviouslyDeniedForeground(this$0.context, true);
        }
        Radar.INSTANCE.sendLocationPermissionStatus$sdk_release(RadarLocationPermissionStatus.Companion.initWithStatus$default(RadarLocationPermissionStatus.Companion, this$0.context, this$0.activity, false, 4, null));
    }

    private static final void _init_$lambda-1(RadarLocationPermissionManager this$0, boolean isGranted) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (!isGranted) {
            RadarLocationPermissionStatus.Companion.savePreviouslyDeniedBackground(this$0.context, true);
        }
        Radar.INSTANCE.sendLocationPermissionStatus$sdk_release(RadarLocationPermissionStatus.Companion.initWithStatus$default(RadarLocationPermissionStatus.Companion, this$0.context, this$0.activity, false, 4, null));
    }
}

