/*
 * Decompiled with CFR 0.152.
 */
package io.radar.sdk;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import io.radar.sdk.Radar;
import io.radar.sdk.RadarLogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u00002\u00020\u0001:\u0001\u001dB\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004JY\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0014\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0010\u00a2\u0006\u0002\b\u001aJ\u000e\u0010\u001b\u001a\u0004\u0018\u00010\u000f*\u00020\u001cH\u0002R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lio/radar/sdk/RadarApiHelper;", "", "logger", "Lio/radar/sdk/RadarLogger;", "(Lio/radar/sdk/RadarLogger;)V", "executor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "handler", "Landroid/os/Handler;", "request", "", "context", "Landroid/content/Context;", "method", "", "url", "Ljava/net/URL;", "headers", "", "params", "Lorg/json/JSONObject;", "sleep", "", "callback", "Lio/radar/sdk/RadarApiHelper$RadarApiCallback;", "request$sdk_release", "readAll", "Ljava/io/InputStream;", "RadarApiCallback", "sdk_release"})
public class RadarApiHelper {
    @Nullable
    private RadarLogger logger;
    private final ExecutorService executor;
    @NotNull
    private final Handler handler;

    public RadarApiHelper(@Nullable RadarLogger logger) {
        this.logger = logger;
        this.executor = Executors.newSingleThreadExecutor();
        this.handler = new Handler(Looper.getMainLooper());
    }

    public /* synthetic */ RadarApiHelper(RadarLogger radarLogger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            radarLogger = null;
        }
        this(radarLogger);
    }

    public void request$sdk_release(@NotNull Context context, @NotNull String method, @NotNull URL url, @Nullable Map<String, String> headers, @Nullable JSONObject params, boolean sleep, @Nullable RadarApiCallback callback) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        RadarLogger radarLogger = this.logger;
        if (radarLogger != null) {
            RadarLogger.d$default(radarLogger, "\ud83d\udccd Radar API request | method = " + method + "; url = " + url + "; headers = " + headers + "; params = " + params, null, 2, null);
        }
        this.executor.execute(() -> RadarApiHelper.request$lambda-6(url, headers, method, params, this, callback, sleep));
    }

    public static /* synthetic */ void request$sdk_release$default(RadarApiHelper radarApiHelper, Context context, String string, URL uRL, Map map, JSONObject jSONObject, boolean bl, RadarApiCallback radarApiCallback, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: request");
        }
        if ((n & 0x40) != 0) {
            radarApiCallback = null;
        }
        radarApiHelper.request$sdk_release(context, string, uRL, map, jSONObject, bl, radarApiCallback);
    }

    private final String readAll(InputStream $this$readAll) {
        Scanner scanner = new Scanner($this$readAll, "UTF-8").useDelimiter("\\A");
        String body = scanner.hasNext() ? scanner.next() : (String)null;
        $this$readAll.close();
        return body;
    }

    private static final void request$lambda-6$lambda-0(RadarApiCallback $callback) {
        RadarApiCallback radarApiCallback = $callback;
        if (radarApiCallback != null) {
            RadarApiCallback.DefaultImpls.onComplete$default(radarApiCallback, Radar.RadarStatus.ERROR_SERVER, null, 2, null);
        }
    }

    private static final void request$lambda-6$lambda-1(RadarApiCallback $callback, JSONObject $res) {
        Intrinsics.checkNotNullParameter((Object)$res, (String)"$res");
        RadarApiCallback radarApiCallback = $callback;
        if (radarApiCallback != null) {
            radarApiCallback.onComplete(Radar.RadarStatus.SUCCESS, $res);
        }
    }

    private static final void request$lambda-6$lambda-2(RadarApiCallback $callback, Radar.RadarStatus $status) {
        Intrinsics.checkNotNullParameter((Object)((Object)$status), (String)"$status");
        RadarApiCallback radarApiCallback = $callback;
        if (radarApiCallback != null) {
            RadarApiCallback.DefaultImpls.onComplete$default(radarApiCallback, $status, null, 2, null);
        }
    }

    private static final void request$lambda-6$lambda-3(RadarApiCallback $callback) {
        RadarApiCallback radarApiCallback = $callback;
        if (radarApiCallback != null) {
            RadarApiCallback.DefaultImpls.onComplete$default(radarApiCallback, Radar.RadarStatus.ERROR_NETWORK, null, 2, null);
        }
    }

    private static final void request$lambda-6$lambda-4(RadarApiCallback $callback) {
        RadarApiCallback radarApiCallback = $callback;
        if (radarApiCallback != null) {
            RadarApiCallback.DefaultImpls.onComplete$default(radarApiCallback, Radar.RadarStatus.ERROR_SERVER, null, 2, null);
        }
    }

    private static final void request$lambda-6$lambda-5(RadarApiCallback $callback) {
        RadarApiCallback radarApiCallback = $callback;
        if (radarApiCallback != null) {
            RadarApiCallback.DefaultImpls.onComplete$default(radarApiCallback, Radar.RadarStatus.ERROR_UNKNOWN, null, 2, null);
        }
    }

    private static final void request$lambda-6(URL $url, Map $headers, String $method, JSONObject $params, RadarApiHelper this$0, RadarApiCallback $callback, boolean $sleep) {
        Intrinsics.checkNotNullParameter((Object)$url, (String)"$url");
        Intrinsics.checkNotNullParameter((Object)$method, (String)"$method");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            HttpURLConnection urlConnection;
            block17: {
                Object object;
                block16: {
                    int outputStreamWriter2;
                    Object object2;
                    Object object3 = $url.openConnection();
                    if (object3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.net.HttpURLConnection");
                    }
                    urlConnection = (HttpURLConnection)object3;
                    if ($headers != null) {
                        object2 = $headers;
                        boolean bl = false;
                        object3 = object2.entrySet().iterator();
                        while (object3.hasNext()) {
                            object = object2 = (Map.Entry)object3.next();
                            boolean bl2 = false;
                            String key = (String)object.getKey();
                            Object object4 = object2;
                            boolean bl3 = false;
                            String value = (String)object4.getValue();
                            try {
                                urlConnection.setRequestProperty(key, value);
                            }
                            catch (Exception exception) {}
                        }
                    }
                    urlConnection.setRequestMethod($method);
                    urlConnection.setConnectTimeout(10000);
                    urlConnection.setReadTimeout(10000);
                    if ($params != null) {
                        urlConnection.setDoOutput(true);
                        OutputStreamWriter outputStreamWriter2 = new OutputStreamWriter(urlConnection.getOutputStream());
                        outputStreamWriter2.write($params.toString());
                        outputStreamWriter2.close();
                    }
                    boolean bl = 200 <= (outputStreamWriter2 = urlConnection.getResponseCode()) ? outputStreamWriter2 < 400 : false;
                    if (!bl) break block16;
                    object2 = urlConnection.getInputStream();
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"urlConnection.inputStream");
                    String body = this$0.readAll((InputStream)object2);
                    if (body == null) {
                        this$0.handler.post(() -> RadarApiHelper.request$lambda-6$lambda-0($callback));
                        return;
                    }
                    JSONObject res = new JSONObject(body);
                    RadarLogger key = this$0.logger;
                    if (key != null) {
                        RadarLogger.d$default(key, "\ud83d\udccd Radar API response | method = " + $method + "; url = " + $url + "; responseCode = " + urlConnection.getResponseCode() + "; res = " + res, null, 2, null);
                    }
                    this$0.handler.post(() -> RadarApiHelper.request$lambda-6$lambda-1($callback, res));
                    break block17;
                }
                int res = urlConnection.getResponseCode();
                Radar.RadarStatus status = res == 400 ? Radar.RadarStatus.ERROR_BAD_REQUEST : (res == 401 ? Radar.RadarStatus.ERROR_UNAUTHORIZED : (res == 402 ? Radar.RadarStatus.ERROR_PAYMENT_REQUIRED : (res == 403 ? Radar.RadarStatus.ERROR_FORBIDDEN : (res == 404 ? Radar.RadarStatus.ERROR_NOT_FOUND : (res == 429 ? Radar.RadarStatus.ERROR_RATE_LIMIT : ((500 <= res ? res < 600 : false) ? Radar.RadarStatus.ERROR_SERVER : Radar.RadarStatus.ERROR_UNKNOWN))))));
                Object key = urlConnection.getErrorStream();
                Intrinsics.checkNotNullExpressionValue((Object)key, (String)"urlConnection.errorStream");
                String body = this$0.readAll((InputStream)key);
                if (body == null) {
                    key = $callback;
                    if (key != null) {
                        RadarApiCallback.DefaultImpls.onComplete$default((RadarApiCallback)key, Radar.RadarStatus.ERROR_SERVER, null, 2, null);
                    }
                    return;
                }
                JSONObject res2 = new JSONObject(body);
                object = this$0.logger;
                if (object != null) {
                    RadarLogger.d$default((RadarLogger)object, "\ud83d\udccd Radar API response | responseCode = " + urlConnection.getResponseCode() + "; res = " + res2, null, 2, null);
                }
                this$0.handler.post(() -> RadarApiHelper.request$lambda-6$lambda-2($callback, status));
            }
            urlConnection.disconnect();
        }
        catch (IOException e) {
            this$0.handler.post(() -> RadarApiHelper.request$lambda-6$lambda-3($callback));
        }
        catch (JSONException e) {
            this$0.handler.post(() -> RadarApiHelper.request$lambda-6$lambda-4($callback));
        }
        catch (Exception e) {
            this$0.handler.post(() -> RadarApiHelper.request$lambda-6$lambda-5($callback));
        }
        if ($sleep) {
            Thread.sleep(1000L);
        }
    }

    public RadarApiHelper() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u001c\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00a8\u0006\b"}, d2={"Lio/radar/sdk/RadarApiHelper$RadarApiCallback;", "", "onComplete", "", "status", "Lio/radar/sdk/Radar$RadarStatus;", "res", "Lorg/json/JSONObject;", "sdk_release"})
    public static interface RadarApiCallback {
        public void onComplete(@NotNull Radar.RadarStatus var1, @Nullable JSONObject var2);

        @Metadata(mv={1, 5, 1}, k=3, xi=48)
        public static final class DefaultImpls {
            public static /* synthetic */ void onComplete$default(RadarApiCallback radarApiCallback, Radar.RadarStatus radarStatus, JSONObject jSONObject, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: onComplete");
                }
                if ((n & 2) != 0) {
                    jSONObject = null;
                }
                radarApiCallback.onComplete(radarStatus, jSONObject);
            }
        }
    }
}

