/*
 * Decompiled with CFR 0.152.
 */
package io.radar.sdk;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.location.Location;
import android.location.LocationManager;
import android.os.Build;
import android.provider.Settings;
import androidx.core.content.ContextCompat;
import androidx.core.hardware.display.DisplayManagerCompat;
import io.radar.sdk.RadarSettings;
import java.security.MessageDigest;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0016\u001a\u0004\u0018\u00010\u00062\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0000\u00a2\u0006\u0002\b\u0019J\u0017\u0010\u001a\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001b\u001a\u00020\u001cH\u0001\u00a2\u0006\u0002\b\u001dJ\u0015\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001fJ\u0015\u0010 \u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b!J\u0015\u0010\"\u001a\u00020#2\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b$J\u0010\u0010%\u001a\u00020&2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0015\u0010'\u001a\u00020#2\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b(J\u0015\u0010)\u001a\u00020#2\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b*J\u000e\u0010+\u001a\u00020\u00062\u0006\u0010,\u001a\u00020\u0006J\r\u0010-\u001a\u00020#H\u0000\u00a2\u0006\u0002\b.J\u0018\u0010/\u001a\u00020#2\u0006\u00100\u001a\u00020\u00042\u0006\u00101\u001a\u00020\u0004H\u0002J\u0019\u00102\u001a\u0004\u0018\u00010\u00182\b\u00103\u001a\u0004\u0018\u00010\u0006H\u0000\u00a2\u0006\u0002\b4J\u0015\u00105\u001a\u00020#2\u0006\u00106\u001a\u000207H\u0000\u00a2\u0006\u0002\b8R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\n \n*\u0004\u0018\u00010\u00060\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u001c\u0010\f\u001a\n \n*\u0004\u0018\u00010\u00060\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\bR\u001c\u0010\u000e\u001a\n \n*\u0004\u0018\u00010\u00060\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\bR\u000e\u0010\u0010\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00138@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u00069"}, d2={"Lio/radar/sdk/RadarUtils;", "", "()V", "DEGREE_EPSILON", "", "country", "", "getCountry$sdk_release", "()Ljava/lang/String;", "deviceMake", "kotlin.jvm.PlatformType", "getDeviceMake$sdk_release", "deviceModel", "getDeviceModel$sdk_release", "deviceOS", "getDeviceOS$sdk_release", "deviceType", "sdkVersion", "timeZoneOffset", "", "getTimeZoneOffset$sdk_release", "()I", "dateToISOString", "date", "Ljava/util/Date;", "dateToISOString$sdk_release", "getDeviceId", "context", "Landroid/content/Context;", "getDeviceId$sdk_release", "getLocationAccuracyAuthorization", "getLocationAccuracyAuthorization$sdk_release", "getLocationAuthorization", "getLocationAuthorization$sdk_release", "getLocationEnabled", "", "getLocationEnabled$sdk_release", "getSharedPreferences", "Landroid/content/SharedPreferences;", "hasMultipleDisplays", "hasMultipleDisplays$sdk_release", "hasVirtualInputDevice", "hasVirtualInputDevice$sdk_release", "hashSHA256", "input", "isEmulator", "isEmulator$sdk_release", "isWithinDegreeEpsilon", "firstValue", "secondValue", "isoStringToDate", "str", "isoStringToDate$sdk_release", "valid", "location", "Landroid/location/Location;", "valid$sdk_release", "sdk_release"})
public final class RadarUtils {
    @NotNull
    public static final RadarUtils INSTANCE = new RadarUtils();
    private static final String deviceModel = Build.MODEL;
    private static final String deviceOS = Build.VERSION.RELEASE;
    @NotNull
    public static final String sdkVersion = "3.21.1";
    @NotNull
    public static final String deviceType = "Android";
    private static final String deviceMake = Build.MANUFACTURER;
    private static final double DEGREE_EPSILON = 1.0E-8;

    private RadarUtils() {
    }

    private final SharedPreferences getSharedPreferences(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("RadarSDK", 0);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"context.getSharedPrefere\u2026K\", Context.MODE_PRIVATE)");
        return sharedPreferences;
    }

    public final String getDeviceModel$sdk_release() {
        return deviceModel;
    }

    public final String getDeviceOS$sdk_release() {
        return deviceOS;
    }

    @NotNull
    public final String getCountry$sdk_release() {
        String string = Locale.getDefault().getCountry();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDefault().country");
        return string;
    }

    public final int getTimeZoneOffset$sdk_release() {
        TimeZone timeZone = Calendar.getInstance().getTimeZone();
        int offset = timeZone.getRawOffset();
        if (timeZone.inDaylightTime(new Date())) {
            offset += timeZone.getDSTSavings();
        }
        return offset / 1000;
    }

    @SuppressLint(value={"HardwareIds"})
    @Nullable
    public final String getDeviceId$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
    }

    public final String getDeviceMake$sdk_release() {
        return deviceMake;
    }

    @NotNull
    public final String getLocationAuthorization$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String locationAuthorization = "NOT_DETERMINED";
        if (RadarSettings.INSTANCE.getPermissionsDenied$sdk_release(context)) {
            locationAuthorization = "DENIED";
        }
        if (ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_FINE_LOCATION") == 0 || ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_COARSE_LOCATION") == 0) {
            locationAuthorization = "GRANTED_FOREGROUND";
        }
        if (Build.VERSION.SDK_INT >= 29 && ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_BACKGROUND_LOCATION") == 0) {
            locationAuthorization = "GRANTED_BACKGROUND";
        }
        return locationAuthorization;
    }

    @NotNull
    public final String getLocationAccuracyAuthorization$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        boolean olderThanAndroidS = Build.VERSION.SDK_INT < 31;
        boolean fineLocationGranted = ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_FINE_LOCATION") == 0;
        return olderThanAndroidS || fineLocationGranted ? "FULL" : "REDUCED";
    }

    public final boolean getLocationEnabled$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("location");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.location.LocationManager");
        }
        LocationManager manager = (LocationManager)object;
        return manager.isProviderEnabled("gps") || manager.isProviderEnabled("network");
    }

    public final boolean valid$sdk_release(@NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        boolean latitudeValid = !this.isWithinDegreeEpsilon(location.getLatitude(), 0.0) && location.getLatitude() > -90.0 && location.getLatitude() < 90.0;
        boolean longitudeValid = !this.isWithinDegreeEpsilon(location.getLongitude(), 0.0) && location.getLongitude() > -180.0 && location.getLongitude() < 180.0;
        boolean accuracyValid = location.getAccuracy() > 0.0f;
        return latitudeValid && longitudeValid && accuracyValid;
    }

    private final boolean isWithinDegreeEpsilon(double firstValue, double secondValue) {
        return Math.abs(firstValue - secondValue) < 1.0E-8;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isEmulator$sdk_release() {
        String string = Build.BRAND;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"BRAND");
        if (StringsKt.startsWith$default((String)string, (String)"generic", (boolean)false, (int)2, null)) {
            String string2 = Build.DEVICE;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"DEVICE");
            if (StringsKt.startsWith$default((String)string2, (String)"generic", (boolean)false, (int)2, null)) return true;
        }
        String string3 = Build.FINGERPRINT;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"FINGERPRINT");
        if (StringsKt.startsWith$default((String)string3, (String)"generic", (boolean)false, (int)2, null)) return true;
        String string4 = Build.FINGERPRINT;
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"FINGERPRINT");
        if (StringsKt.startsWith$default((String)string4, (String)"unknown", (boolean)false, (int)2, null)) return true;
        String string5 = Build.HARDWARE;
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"HARDWARE");
        if (StringsKt.contains$default((CharSequence)string5, (CharSequence)"goldfish", (boolean)false, (int)2, null)) return true;
        String string6 = Build.HARDWARE;
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"HARDWARE");
        if (StringsKt.contains$default((CharSequence)string6, (CharSequence)"ranchu", (boolean)false, (int)2, null)) return true;
        String string7 = Build.MODEL;
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"MODEL");
        if (StringsKt.contains$default((CharSequence)string7, (CharSequence)"google_sdk", (boolean)false, (int)2, null)) return true;
        String string8 = Build.MODEL;
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"MODEL");
        if (StringsKt.contains$default((CharSequence)string8, (CharSequence)"Emulator", (boolean)false, (int)2, null)) return true;
        String string9 = Build.MODEL;
        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"MODEL");
        if (StringsKt.contains$default((CharSequence)string9, (CharSequence)"Android SDK built for x86", (boolean)false, (int)2, null)) return true;
        String string10 = Build.MANUFACTURER;
        Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"MANUFACTURER");
        if (StringsKt.contains$default((CharSequence)string10, (CharSequence)"Genymotion", (boolean)false, (int)2, null)) return true;
        String string11 = Build.PRODUCT;
        Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"PRODUCT");
        if (StringsKt.contains$default((CharSequence)string11, (CharSequence)"sdk_google", (boolean)false, (int)2, null)) return true;
        String string12 = Build.PRODUCT;
        Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"PRODUCT");
        if (StringsKt.contains$default((CharSequence)string12, (CharSequence)"google_sdk", (boolean)false, (int)2, null)) return true;
        String string13 = Build.PRODUCT;
        Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"PRODUCT");
        if (StringsKt.contains$default((CharSequence)string13, (CharSequence)"sdk", (boolean)false, (int)2, null)) return true;
        String string14 = Build.PRODUCT;
        Intrinsics.checkNotNullExpressionValue((Object)string14, (String)"PRODUCT");
        if (StringsKt.contains$default((CharSequence)string14, (CharSequence)"sdk_x86", (boolean)false, (int)2, null)) return true;
        String string15 = Build.PRODUCT;
        Intrinsics.checkNotNullExpressionValue((Object)string15, (String)"PRODUCT");
        if (StringsKt.contains$default((CharSequence)string15, (CharSequence)"vbox86p", (boolean)false, (int)2, null)) return true;
        String string16 = Build.PRODUCT;
        Intrinsics.checkNotNullExpressionValue((Object)string16, (String)"PRODUCT");
        if (StringsKt.contains$default((CharSequence)string16, (CharSequence)"emulator", (boolean)false, (int)2, null)) return true;
        String string17 = Build.PRODUCT;
        Intrinsics.checkNotNullExpressionValue((Object)string17, (String)"PRODUCT");
        if (!StringsKt.contains$default((CharSequence)string17, (CharSequence)"simulator", (boolean)false, (int)2, null)) return false;
        return true;
    }

    public final boolean hasMultipleDisplays$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        DisplayManagerCompat displayManagerCompat = DisplayManagerCompat.getInstance((Context)context);
        Intrinsics.checkNotNullExpressionValue((Object)displayManagerCompat, (String)"getInstance(context)");
        DisplayManagerCompat displayManager = displayManagerCompat;
        return displayManager.getDisplays().length > 1;
    }

    public final boolean hasVirtualInputDevice$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return RadarSettings.INSTANCE.getSharing$sdk_release(context);
    }

    @Nullable
    public final Date isoStringToDate$sdk_release(@Nullable String str) {
        if (str == null) {
            return null;
        }
        try {
            return Date.from(ZonedDateTime.parse(str).toInstant());
        }
        catch (Exception e) {
            Date date;
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US);
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            try {
                date = dateFormat.parse(str);
            }
            catch (ParseException pe) {
                date = null;
            }
            return date;
        }
    }

    @Nullable
    public final String dateToISOString$sdk_release(@Nullable Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat.format(date);
    }

    @NotNull
    public final String hashSHA256(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        String string = input;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        byte[] bytes = messageDigest.digest(byArray);
        StringBuilder hexString = new StringBuilder(2 * bytes.length);
        Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"bytes");
        for (byte by : bytes) {
            String hex = Integer.toHexString(0xFF & by);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        String string2 = hexString.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"hexString.toString()");
        return string2;
    }
}

