/*
 * Decompiled with CFR 0.152.
 */
package io.radar.sdk;

import android.app.ActivityManager;
import android.app.ApplicationExitInfo;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.util.Log;
import androidx.annotation.RequiresApi;
import io.radar.sdk.Radar;
import io.radar.sdk.RadarSettings;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0007\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fJ&\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u0006\u0010\u000e\u001a\u00020\u000fJ&\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u0006\u0010\u0011\u001a\u00020\u0006J\b\u0010\u0012\u001a\u00020\u0006H\u0007J\u0006\u0010\u0013\u001a\u00020\u0006J&\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/radar/sdk/RadarLogger;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "d", "", "message", "", "type", "Lio/radar/sdk/Radar$RadarLogType;", "throwable", "", "e", "getBatteryLevel", "", "i", "logBackgrounding", "logPastTermination", "logResigningActive", "w", "Companion", "sdk_release"})
public final class RadarLogger {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private static final String TAG = "RadarLogger";

    public RadarLogger(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    public final void d(@NotNull String message, @Nullable Radar.RadarLogType type, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Radar.RadarLogLevel level = RadarSettings.INSTANCE.getLogLevel$sdk_release(this.context);
        if (level.compareTo((Enum)Radar.RadarLogLevel.DEBUG) >= 0) {
            Log.d((String)TAG, (String)message, (Throwable)throwable);
            Radar.sendLog$sdk_release$default(Radar.INSTANCE, Radar.RadarLogLevel.DEBUG, message, type, null, 8, null);
        }
    }

    public static /* synthetic */ void d$default(RadarLogger radarLogger, String string, Radar.RadarLogType radarLogType, Throwable throwable, int n, Object object) {
        if ((n & 2) != 0) {
            radarLogType = null;
        }
        if ((n & 4) != 0) {
            throwable = null;
        }
        radarLogger.d(string, radarLogType, throwable);
    }

    public final void i(@NotNull String message, @Nullable Radar.RadarLogType type, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Radar.RadarLogLevel level = RadarSettings.INSTANCE.getLogLevel$sdk_release(this.context);
        if (level.compareTo((Enum)Radar.RadarLogLevel.INFO) >= 0) {
            Log.i((String)TAG, (String)message, (Throwable)throwable);
            Radar.sendLog$sdk_release$default(Radar.INSTANCE, Radar.RadarLogLevel.INFO, message, type, null, 8, null);
        }
    }

    public static /* synthetic */ void i$default(RadarLogger radarLogger, String string, Radar.RadarLogType radarLogType, Throwable throwable, int n, Object object) {
        if ((n & 2) != 0) {
            radarLogType = null;
        }
        if ((n & 4) != 0) {
            throwable = null;
        }
        radarLogger.i(string, radarLogType, throwable);
    }

    public final void w(@NotNull String message, @Nullable Radar.RadarLogType type, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Radar.RadarLogLevel level = RadarSettings.INSTANCE.getLogLevel$sdk_release(this.context);
        if (level.compareTo((Enum)Radar.RadarLogLevel.WARNING) >= 0) {
            Log.w((String)TAG, (String)message, (Throwable)throwable);
            Radar.sendLog$sdk_release$default(Radar.INSTANCE, Radar.RadarLogLevel.WARNING, message, type, null, 8, null);
        }
    }

    public static /* synthetic */ void w$default(RadarLogger radarLogger, String string, Radar.RadarLogType radarLogType, Throwable throwable, int n, Object object) {
        if ((n & 2) != 0) {
            radarLogType = null;
        }
        if ((n & 4) != 0) {
            throwable = null;
        }
        radarLogger.w(string, radarLogType, throwable);
    }

    public final void e(@NotNull String message, @Nullable Radar.RadarLogType type, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Radar.RadarLogLevel level = RadarSettings.INSTANCE.getLogLevel$sdk_release(this.context);
        if (level.compareTo((Enum)Radar.RadarLogLevel.ERROR) >= 0) {
            Log.e((String)TAG, (String)message, (Throwable)throwable);
            Radar.sendLog$sdk_release$default(Radar.INSTANCE, Radar.RadarLogLevel.ERROR, message, type, null, 8, null);
        }
    }

    public static /* synthetic */ void e$default(RadarLogger radarLogger, String string, Radar.RadarLogType radarLogType, Throwable throwable, int n, Object object) {
        if ((n & 2) != 0) {
            radarLogType = null;
        }
        if ((n & 4) != 0) {
            throwable = null;
        }
        radarLogger.e(string, radarLogType, throwable);
    }

    @RequiresApi(value=30)
    public final void logPastTermination() {
        boolean isForeground;
        ActivityManager activityManager;
        block10: {
            boolean bl;
            List appProcesses;
            Radar.RadarLogLevel level = RadarSettings.INSTANCE.getLogLevel$sdk_release(this.context);
            if (level != Radar.RadarLogLevel.DEBUG) {
                return;
            }
            Object object = this.context.getSystemService("activity");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.app.ActivityManager");
            }
            activityManager = (ActivityManager)object;
            List list = appProcesses = activityManager.getRunningAppProcesses();
            if (list != null) {
                Iterable $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ActivityManager.RunningAppProcessInfo it = (ActivityManager.RunningAppProcessInfo)element$iv;
                        boolean bl2 = false;
                        if (!(it.importance == 100 && Intrinsics.areEqual((Object)it.processName, (Object)this.context.getPackageName()))) continue;
                        bl = true;
                        break block10;
                    }
                    bl = false;
                }
            } else {
                bl = isForeground = false;
            }
        }
        if (!isForeground) {
            return;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
        SharedPreferences sharedPreferences = this.context.getSharedPreferences("RadarSDK", 0);
        long previousTimestamp = sharedPreferences.getLong("last_timestamp", 0L);
        long currentTimestamp = System.currentTimeMillis();
        SharedPreferences.Editor $this$logPastTermination_u24lambda_u2d1 = sharedPreferences.edit();
        boolean bl = false;
        $this$logPastTermination_u24lambda_u2d1.putLong("last_timestamp", currentTimestamp);
        $this$logPastTermination_u24lambda_u2d1.apply();
        float batteryLevel = this.getBatteryLevel();
        List list = activityManager.getHistoricalProcessExitReasons(null, 0, 10);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"activityManager.getHisto\u2026sExitReasons(null, 0, 10)");
        List crashLists = list;
        if (!((Collection)crashLists).isEmpty()) {
            for (ApplicationExitInfo crashInfo : crashLists) {
                if (crashInfo.getTimestamp() <= previousTimestamp) continue;
                Radar.INSTANCE.sendLog$sdk_release(Radar.RadarLogLevel.DEBUG, "App terminating | with reason: " + crashInfo.getDescription() + " | at " + dateFormat.format(new Date(crashInfo.getTimestamp())) + " | with " + batteryLevel * (float)100 + "% battery", null, new Date(crashInfo.getTimestamp()));
                break;
            }
        }
    }

    public final float getBatteryLevel() {
        Intent batteryStatus;
        IntentFilter ifilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        boolean bl = false;
        Intent intent = batteryStatus = this.context.registerReceiver(null, ifilter);
        int level = intent != null ? intent.getIntExtra("level", -1) : -1;
        Intent intent2 = batteryStatus;
        int scale = intent2 != null ? intent2.getIntExtra("scale", -1) : -1;
        float batteryPct = (float)level / (float)scale;
        return batteryPct;
    }

    public final void logBackgrounding() {
        float batteryLevel = this.getBatteryLevel();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
        RadarLogger.d$default(this, "App entering background | at " + dateFormat.format(new Date()) + " | with " + batteryLevel * (float)100 + "% battery", null, null, 6, null);
    }

    public final void logResigningActive() {
        float batteryLevel = this.getBatteryLevel();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
        RadarLogger.d$default(this, "App resigning active | at " + dateFormat.format(new Date()) + " | with " + batteryLevel * (float)100 + "% battery", null, null, 6, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/radar/sdk/RadarLogger$Companion;", "", "()V", "TAG", "", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

