/*
 * Decompiled with CFR 0.152.
 */
package io.radar.sdk;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import io.radar.sdk.Radar;
import io.radar.sdk.RadarLogger;
import io.radar.sdk.RadarState;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0016J\u0006\u0010\u000e\u001a\u00020\nJ\u0006\u0010\u000f\u001a\u00020\nJ\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/radar/sdk/RadarSensorsManager;", "Landroid/hardware/SensorEventListener;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "pressure", "Landroid/hardware/Sensor;", "sensorManager", "Landroid/hardware/SensorManager;", "onAccuracyChanged", "", "sensor", "accuracy", "", "onPause", "onResume", "onSensorChanged", "event", "Landroid/hardware/SensorEvent;", "sdk_release"})
public final class RadarSensorsManager
implements SensorEventListener {
    @NotNull
    private SensorManager sensorManager;
    @Nullable
    private Sensor pressure;
    @NotNull
    private final Context context;

    /*
     * WARNING - void declaration
     */
    public RadarSensorsManager(@NotNull Context context) {
        Object object;
        StringBuilder stringBuilder;
        RadarLogger radarLogger;
        block5: {
            block4: {
                void it;
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                this.context = context;
                Object object2 = context.getSystemService("sensor");
                if (object2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type android.hardware.SensorManager");
                }
                this.sensorManager = (SensorManager)object2;
                this.pressure = this.sensorManager.getDefaultSensor(6);
                RadarLogger.d$default(Radar.INSTANCE.getLogger$sdk_release(), "SensorManager initialized: " + this.sensorManager, null, null, 6, null);
                radarLogger = Radar.INSTANCE.getLogger$sdk_release();
                stringBuilder = new StringBuilder().append("Pressure sensor: ");
                object = this.pressure;
                if (object == null) break block4;
                Sensor sensor = object;
                StringBuilder stringBuilder2 = stringBuilder;
                RadarLogger radarLogger2 = radarLogger;
                boolean bl = false;
                String string = "Found - Name: " + it.getName() + ", Vendor: " + it.getVendor() + ", Power: " + it.getPower() + ", Resolution: " + it.getResolution();
                radarLogger = radarLogger2;
                stringBuilder = stringBuilder2;
                String string2 = string;
                object = string2;
                if (string2 != null) break block5;
            }
            object = "Not available on device";
        }
        RadarLogger.d$default(radarLogger, stringBuilder.append((String)object).toString(), null, null, 6, null);
    }

    public void onAccuracyChanged(@NotNull Sensor sensor, int accuracy) {
        Intrinsics.checkNotNullParameter((Object)sensor, (String)"sensor");
    }

    public void onSensorChanged(@NotNull SensorEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        float millibarsOfPressure = event.values[0];
        int accuracy = event.accuracy;
        JSONObject pressureJson = new JSONObject();
        pressureJson.put("pressure", (Object)Float.valueOf(millibarsOfPressure));
        pressureJson.put("accuracy", accuracy);
        pressureJson.put("relativeAltitudeTimestamp", System.currentTimeMillis());
        RadarState.INSTANCE.setLastPressure$sdk_release(this.context, pressureJson);
    }

    public final void onResume() {
        if (this.pressure != null) {
            this.sensorManager.registerListener((SensorEventListener)this, this.pressure, 3);
        }
    }

    public final void onPause() {
        if (this.pressure != null) {
            this.sensorManager.unregisterListener((SensorEventListener)this);
        }
    }
}

