/*
 * Decompiled with CFR 0.152.
 */
package io.radar.sdk;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import io.radar.sdk.Radar;
import io.radar.sdk.RadarLogger;
import io.radar.sdk.RadarState;
import java.io.Closeable;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.HttpsURLConnection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00192\u0006\u0010+\u001a\u00020\u0013H\u0016J\u0006\u0010,\u001a\u00020)J\u0006\u0010-\u001a\u00020)J\u0010\u0010.\u001a\u00020)2\u0006\u0010/\u001a\u000200H\u0016J\u0018\u00101\u001a\u00020)2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u000eH\u0002J\b\u00105\u001a\u00020)H\u0002J\u0018\u00106\u001a\u00020)2\u0006\u00107\u001a\u00020\u00062\u0006\u00104\u001a\u00020\u000eH\u0002J\u0018\u00108\u001a\u00020)2\u0006\u00109\u001a\u00020\u00062\u0006\u00104\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R \u0010\u001f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e0 0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0013X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0017X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lio/radar/sdk/RadarSensorsManager;", "Landroid/hardware/SensorEventListener;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "estimatedError", "", "estimatedPressure", "executor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "isRawDataSending", "Ljava/util/concurrent/atomic/AtomicBoolean;", "lastNgrokSendTime", "", "lastPressure", "lastRawDataSendTime", "lastTimestamp", "maxHistorySize", "", "measurementNoise", "ngrokSendInterval", "ngrokUrl", "", "pressure", "Landroid/hardware/Sensor;", "pressureHistory", "", "", "processNoise", "rawDataSendInterval", "rawReadings", "Lkotlin/Pair;", "sensorManager", "Landroid/hardware/SensorManager;", "shortTermSize", "shortTermWindow", "smoothedPressure", "smoothingFactor", "userAgent", "onAccuracyChanged", "", "sensor", "accuracy", "onPause", "onResume", "onSensorChanged", "event", "Landroid/hardware/SensorEvent;", "sendPressureDataToNgrok", "pressureJson", "Lorg/json/JSONObject;", "timestamp", "sendRawDataToNgrok", "updateExponentialDecay", "newPressure", "updateKalmanFilter", "measurement", "sdk_release"})
public final class RadarSensorsManager
implements SensorEventListener {
    @NotNull
    private SensorManager sensorManager;
    @Nullable
    private Sensor pressure;
    @NotNull
    private final Context context;
    @NotNull
    private final List<Float> pressureHistory;
    private final int maxHistorySize;
    @NotNull
    private final List<Float> shortTermWindow;
    private final int shortTermSize;
    @NotNull
    private final String ngrokUrl;
    private long lastNgrokSendTime;
    private final long ngrokSendInterval;
    private long lastRawDataSendTime;
    private final long rawDataSendInterval;
    @NotNull
    private final String userAgent;
    private final ExecutorService executor;
    @NotNull
    private final List<Pair<Double, Long>> rawReadings;
    @NotNull
    private final AtomicBoolean isRawDataSending;
    private final double smoothingFactor;
    private double smoothedPressure;
    private double estimatedPressure;
    private double estimatedError;
    private final double measurementNoise;
    private final double processNoise;
    private double lastPressure;
    private long lastTimestamp;

    /*
     * WARNING - void declaration
     */
    public RadarSensorsManager(@NotNull Context context) {
        Object object;
        StringBuilder stringBuilder;
        RadarLogger radarLogger;
        block5: {
            block4: {
                void it;
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                this.context = context;
                this.pressureHistory = new ArrayList();
                this.maxHistorySize = 400;
                this.shortTermWindow = new ArrayList();
                this.shortTermSize = 50;
                this.ngrokUrl = "https://arriving-eagle-magnetic.ngrok-free.app";
                this.ngrokSendInterval = 5000L;
                this.rawDataSendInterval = 5000L;
                this.userAgent = "RadarSDK/Android/4.0.0";
                this.executor = Executors.newSingleThreadExecutor();
                this.rawReadings = new ArrayList();
                this.isRawDataSending = new AtomicBoolean(false);
                this.smoothingFactor = 0.2;
                this.estimatedPressure = 1000.0;
                this.estimatedError = 1.0;
                this.measurementNoise = 1.0;
                this.processNoise = 0.01;
                Object object2 = context.getSystemService("sensor");
                if (object2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type android.hardware.SensorManager");
                }
                this.sensorManager = (SensorManager)object2;
                this.pressure = this.sensorManager.getDefaultSensor(6);
                RadarLogger.d$default(Radar.INSTANCE.getLogger$sdk_release(), "SensorManager initialized: " + this.sensorManager, null, null, 6, null);
                radarLogger = Radar.INSTANCE.getLogger$sdk_release();
                stringBuilder = new StringBuilder().append("Pressure sensor: ");
                object = this.pressure;
                if (object == null) break block4;
                Sensor sensor = object;
                StringBuilder stringBuilder2 = stringBuilder;
                RadarLogger radarLogger2 = radarLogger;
                boolean bl = false;
                String string = "Found - Name: " + it.getName() + ", Vendor: " + it.getVendor() + ", Power: " + it.getPower() + ", Resolution: " + it.getResolution();
                radarLogger = radarLogger2;
                stringBuilder = stringBuilder2;
                String string2 = string;
                object = string2;
                if (string2 != null) break block5;
            }
            object = "Not available on device";
        }
        RadarLogger.d$default(radarLogger, stringBuilder.append((String)object).toString(), null, null, 6, null);
    }

    private final void updateExponentialDecay(double newPressure, long timestamp) {
        long currentTime = System.currentTimeMillis();
        this.smoothedPressure = this.smoothingFactor * this.smoothedPressure + (1.0 - this.smoothingFactor) * newPressure;
    }

    private final void sendRawDataToNgrok() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastRawDataSendTime < this.rawDataSendInterval) {
            return;
        }
        this.executor.execute(() -> RadarSensorsManager.sendRawDataToNgrok$lambda-3(this, currentTime));
    }

    private final void sendPressureDataToNgrok(JSONObject pressureJson, long timestamp) {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastNgrokSendTime < this.ngrokSendInterval) {
            return;
        }
        if (!this.isRawDataSending.compareAndSet(false, true)) {
            RadarLogger.d$default(Radar.INSTANCE.getLogger$sdk_release(), "Raw data send already in progress, skipping", null, null, 6, null);
            return;
        }
        this.executor.execute(() -> RadarSensorsManager.sendPressureDataToNgrok$lambda-5(this, currentTime, pressureJson));
    }

    private final void updateKalmanFilter(double measurement, long timestamp) {
        double dt = this.lastTimestamp == 0L ? 0.1 : (double)(timestamp - this.lastTimestamp) / 1000.0;
        this.lastTimestamp = timestamp;
        double predictedPressure = this.estimatedPressure;
        double predictedError = this.estimatedError + this.processNoise * dt;
        double kalmanGain = predictedError / (predictedError + this.measurementNoise);
        this.estimatedPressure = predictedPressure + kalmanGain * (measurement - predictedPressure);
        this.estimatedError = (1.0 - kalmanGain) * predictedError;
        RadarLogger.d$default(Radar.INSTANCE.getLogger$sdk_release(), "Kalman filter | Measurement: " + measurement + ", Estimated: " + this.estimatedPressure + ", Gain: " + kalmanGain + ", Error: " + this.estimatedError, null, null, 6, null);
    }

    public void onAccuracyChanged(@NotNull Sensor sensor, int accuracy) {
        Intrinsics.checkNotNullParameter((Object)sensor, (String)"sensor");
    }

    public void onSensorChanged(@NotNull SensorEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        float millibarsOfPressure = event.values[0];
        int accuracy = event.accuracy;
        long timestamp = System.currentTimeMillis();
        this.rawReadings.add((Pair<Double, Long>)new Pair((Object)millibarsOfPressure, (Object)(timestamp / (long)1000)));
        this.updateExponentialDecay(millibarsOfPressure, timestamp);
        this.updateKalmanFilter(millibarsOfPressure, timestamp);
        this.pressureHistory.add(Float.valueOf(millibarsOfPressure));
        if (this.pressureHistory.size() > this.maxHistorySize) {
            this.pressureHistory.remove(0);
        }
        this.shortTermWindow.add(Float.valueOf(millibarsOfPressure));
        if (this.shortTermWindow.size() > this.shortTermSize) {
            this.shortTermWindow.remove(0);
        }
        double longTermAverage = CollectionsKt.averageOfFloat((Iterable)this.pressureHistory);
        double shortTermAverage = CollectionsKt.averageOfFloat((Iterable)this.shortTermWindow);
        JSONObject pressureJson = new JSONObject();
        pressureJson.put("shortTermPressure", shortTermAverage);
        pressureJson.put("longTermPressure", longTermAverage);
        pressureJson.put("kalmanPressure", this.estimatedPressure);
        pressureJson.put("exponentialPressure", this.smoothedPressure);
        pressureJson.put("accuracy", accuracy);
        pressureJson.put("pressure", shortTermAverage);
        pressureJson.put("absoluteAltitudeTimestamp", timestamp / (long)1000);
        RadarState.INSTANCE.setLastPressure$sdk_release(this.context, pressureJson);
    }

    public final void onResume() {
        if (this.pressure != null) {
            this.sensorManager.registerListener((SensorEventListener)this, this.pressure, 3);
        }
    }

    public final void onPause() {
        if (this.pressure != null) {
            this.sensorManager.unregisterListener((SensorEventListener)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void sendRawDataToNgrok$lambda-3(RadarSensorsManager this$0, long $currentTime) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            URL url = new URL(this$0.ngrokUrl + "/raw");
            RadarLogger.d$default(Radar.INSTANCE.getLogger$sdk_release(), "Sending raw data to ngrok: " + url, null, null, 6, null);
            JSONObject readingsJson = new JSONObject();
            JSONArray readingsArray = new JSONArray();
            Iterable $this$forEach$iv = this$0.rawReadings;
            boolean $i$f$forEach22 = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair pair = (Pair)element$iv;
                boolean bl = false;
                double pressure = ((Number)pair.component1()).doubleValue();
                long timestamp = ((Number)pair.component2()).longValue();
                JSONObject reading = new JSONObject();
                reading.put("pressure", pressure);
                reading.put("timestamp", timestamp);
                readingsArray.put((Object)reading);
            }
            readingsJson.put("readings", (Object)readingsArray);
            URLConnection uRLConnection = url.openConnection();
            if (uRLConnection == null) {
                throw new NullPointerException("null cannot be cast to non-null type javax.net.ssl.HttpsURLConnection");
            }
            HttpsURLConnection connection = (HttpsURLConnection)uRLConnection;
            connection.setRequestMethod("POST");
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            connection.setRequestProperty("User-Agent", this$0.userAgent);
            connection.setRequestProperty("ngrok-skip-browser-warning", "true");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setDoOutput(true);
            Closeable $i$f$forEach22 = new OutputStreamWriter(connection.getOutputStream());
            Object object = null;
            try {
                OutputStreamWriter writer = (OutputStreamWriter)$i$f$forEach22;
                boolean bl = false;
                writer.write(readingsJson.toString());
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                try {
                    object = throwable;
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    CloseableKt.closeFinally((Closeable)$i$f$forEach22, object);
                    throw throwable2;
                }
            }
            CloseableKt.closeFinally((Closeable)$i$f$forEach22, (Throwable)object);
            int responseCode = connection.getResponseCode();
            RadarLogger.d$default(Radar.INSTANCE.getLogger$sdk_release(), "Raw data ngrok response code: " + responseCode, null, null, 6, null);
            connection.disconnect();
            this$0.lastRawDataSendTime = $currentTime;
            this$0.rawReadings.clear();
        }
        catch (Exception e) {
            RadarLogger.e$default(Radar.INSTANCE.getLogger$sdk_release(), "Error sending raw data to ngrok: " + e, null, null, 6, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void sendPressureDataToNgrok$lambda-5(RadarSensorsManager this$0, long $currentTime, JSONObject $pressureJson) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$pressureJson, (String)"$pressureJson");
        try {
            URL url = new URL(this$0.ngrokUrl);
            RadarLogger.d$default(Radar.INSTANCE.getLogger$sdk_release(), "Sending data to ngrok: " + url, null, null, 6, null);
            URLConnection uRLConnection = url.openConnection();
            if (uRLConnection == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.net.HttpURLConnection");
            }
            HttpURLConnection connection = (HttpURLConnection)uRLConnection;
            connection.setRequestMethod("POST");
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            connection.setRequestProperty("User-Agent", this$0.userAgent);
            connection.setRequestProperty("ngrok-skip-browser-warning", "true");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setDoOutput(true);
            Closeable closeable = new OutputStreamWriter(connection.getOutputStream());
            Throwable throwable = null;
            try {
                OutputStreamWriter writer = (OutputStreamWriter)closeable;
                boolean bl = false;
                writer.write($pressureJson.toString());
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            int responseCode = connection.getResponseCode();
            RadarLogger.d$default(Radar.INSTANCE.getLogger$sdk_release(), "Ngrok response code: " + responseCode, null, null, 6, null);
            connection.disconnect();
            this$0.lastNgrokSendTime = $currentTime;
        }
        catch (Exception e) {
            RadarLogger.e$default(Radar.INSTANCE.getLogger$sdk_release(), "Error sending data to ngrok: " + e, null, null, 6, null);
        }
        finally {
            this$0.isRawDataSending.set(false);
        }
    }
}

