/*
 * Decompiled with CFR 0.152.
 */
package io.radar.sdk;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanRecord;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import androidx.annotation.RequiresApi;
import io.radar.sdk.Radar;
import io.radar.sdk.RadarBeaconUtils;
import io.radar.sdk.RadarLocationReceiver;
import io.radar.sdk.RadarLogger;
import io.radar.sdk.RadarPermissionsHelper;
import io.radar.sdk.RadarSettings;
import io.radar.sdk.model.RadarBeacon;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010#\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0001\u0018\u0000 E2\u00020\u0001:\u0001EB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0003\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010\u0015H\u0002J\u001f\u0010)\u001a\u00020'2\u0010\b\u0002\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\fH\u0002\u00a2\u0006\u0002\u0010*J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002J'\u0010/\u001a\u00020'2\u000e\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\f2\u0006\u00100\u001a\u000201H\u0000\u00a2\u0006\u0004\b2\u00103J)\u00104\u001a\u00020'2\u0006\u00105\u001a\u00020.2\b\u00106\u001a\u0004\u0018\u0001072\b\b\u0002\u00108\u001a\u00020%H\u0000\u00a2\u0006\u0002\b9J\u0010\u0010:\u001a\u00020%2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J=\u0010;\u001a\u00020'2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010<\u001a\u00020%2\b\u0010(\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\u0002\u0010=J+\u0010>\u001a\u00020'2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\f2\u0006\u0010<\u001a\u00020%2\b\u0010(\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\u0002\u0010?J+\u0010@\u001a\u00020'2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f\u00a2\u0006\u0002\u0010AJ\u0019\u0010B\u001a\u00020'2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\f\u00a2\u0006\u0002\u0010*J\u0006\u0010C\u001a\u00020'J\b\u0010D\u001a\u00020'H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0012R2\u0010\u0013\u001a&\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u00150\u0015 \u0016*\u0012\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u00150\u0015\u0018\u00010\u00170\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\r0\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00110\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lio/radar/sdk/RadarBeaconManager;", "", "context", "Landroid/content/Context;", "logger", "Lio/radar/sdk/RadarLogger;", "permissionsHelper", "Lio/radar/sdk/RadarPermissionsHelper;", "(Landroid/content/Context;Lio/radar/sdk/RadarLogger;Lio/radar/sdk/RadarPermissionsHelper;)V", "adapter", "Landroid/bluetooth/BluetoothAdapter;", "beaconUIDs", "", "", "[Ljava/lang/String;", "beaconUUIDs", "beacons", "Lio/radar/sdk/model/RadarBeacon;", "[Lio/radar/sdk/model/RadarBeacon;", "callbacks", "", "Lio/radar/sdk/Radar$RadarBeaconCallback;", "kotlin.jvm.PlatformType", "", "handler", "Landroid/os/Handler;", "monitoredBeaconIdentifiers", "", "nearbyBeacons", "", "getPermissionsHelper$sdk_release", "()Lio/radar/sdk/RadarPermissionsHelper;", "setPermissionsHelper$sdk_release", "(Lio/radar/sdk/RadarPermissionsHelper;)V", "scanCallback", "Landroid/bluetooth/le/ScanCallback;", "started", "", "addCallback", "", "callback", "callCallbacks", "([Lio/radar/sdk/model/RadarBeacon;)V", "getScanSettings", "Landroid/bluetooth/le/ScanSettings;", "scanMode", "", "handleBeacons", "source", "Lio/radar/sdk/Radar$RadarLocationSource;", "handleBeacons$sdk_release", "([Lio/radar/sdk/model/RadarBeacon;Lio/radar/sdk/Radar$RadarLocationSource;)V", "handleScanResult", "callbackType", "result", "Landroid/bluetooth/le/ScanResult;", "ranging", "handleScanResult$sdk_release", "isBluetoothSupported", "rangeBeaconUUIDs", "background", "([Ljava/lang/String;[Ljava/lang/String;ZLio/radar/sdk/Radar$RadarBeaconCallback;)V", "rangeBeacons", "([Lio/radar/sdk/model/RadarBeacon;ZLio/radar/sdk/Radar$RadarBeaconCallback;)V", "startMonitoringBeaconUUIDs", "([Ljava/lang/String;[Ljava/lang/String;)V", "startMonitoringBeacons", "stopMonitoringBeacons", "stopRanging", "Companion", "sdk_release"})
@RequiresApi(value=26)
@SuppressLint(value={"MissingPermission"})
public final class RadarBeaconManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final RadarLogger logger;
    @NotNull
    private RadarPermissionsHelper permissionsHelper;
    private BluetoothAdapter adapter;
    private boolean started;
    private final List<Radar.RadarBeaconCallback> callbacks;
    @NotNull
    private Set<String> monitoredBeaconIdentifiers;
    @NotNull
    private Set<RadarBeacon> nearbyBeacons;
    @NotNull
    private RadarBeacon[] beacons;
    @NotNull
    private String[] beaconUUIDs;
    @NotNull
    private String[] beaconUIDs;
    @Nullable
    private ScanCallback scanCallback;
    @NotNull
    private final Handler handler;
    @NotNull
    private static final String TIMEOUT_TOKEN = "timeout";

    public RadarBeaconManager(@NotNull Context context, @NotNull RadarLogger logger, @SuppressLint(value={"VisibleForTests"}) @NotNull RadarPermissionsHelper permissionsHelper) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)permissionsHelper, (String)"permissionsHelper");
        this.context = context;
        this.logger = logger;
        this.permissionsHelper = permissionsHelper;
        this.callbacks = Collections.synchronizedList(new ArrayList());
        this.monitoredBeaconIdentifiers = SetsKt.emptySet();
        this.nearbyBeacons = new LinkedHashSet();
        this.beacons = new RadarBeacon[0];
        this.beaconUUIDs = new String[0];
        this.beaconUIDs = new String[0];
        this.handler = new Handler(Looper.getMainLooper());
    }

    public /* synthetic */ RadarBeaconManager(Context context, RadarLogger radarLogger, RadarPermissionsHelper radarPermissionsHelper, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            radarPermissionsHelper = new RadarPermissionsHelper();
        }
        this(context, radarLogger, radarPermissionsHelper);
    }

    @NotNull
    public final RadarPermissionsHelper getPermissionsHelper$sdk_release() {
        return this.permissionsHelper;
    }

    public final void setPermissionsHelper$sdk_release(@NotNull RadarPermissionsHelper radarPermissionsHelper) {
        Intrinsics.checkNotNullParameter((Object)radarPermissionsHelper, (String)"<set-?>");
        this.permissionsHelper = radarPermissionsHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addCallback(Radar.RadarBeaconCallback callback) {
        if (callback == null) {
            return;
        }
        List<Radar.RadarBeaconCallback> list = this.callbacks;
        Intrinsics.checkNotNullExpressionValue(list, (String)"callbacks");
        List<Radar.RadarBeaconCallback> list2 = list;
        synchronized (list2) {
            boolean bl = false;
            boolean bl2 = this.callbacks.add(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void callCallbacks(RadarBeacon[] nearbyBeacons) {
        List<Radar.RadarBeaconCallback> list = this.callbacks;
        Intrinsics.checkNotNullExpressionValue(list, (String)"callbacks");
        List<Radar.RadarBeaconCallback> list2 = list;
        synchronized (list2) {
            boolean bl = false;
            if (this.callbacks.isEmpty()) {
                return;
            }
            RadarLogger.d$default(this.logger, "Calling callbacks | callbacks.size = " + this.callbacks.size(), null, null, 6, null);
            for (Radar.RadarBeaconCallback callback : this.callbacks) {
                callback.onComplete(Radar.RadarStatus.SUCCESS, nearbyBeacons);
            }
            this.callbacks.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    static /* synthetic */ void callCallbacks$default(RadarBeaconManager radarBeaconManager, RadarBeacon[] radarBeaconArray, int n, Object object) {
        if ((n & 1) != 0) {
            radarBeaconArray = null;
        }
        radarBeaconManager.callCallbacks(radarBeaconArray);
    }

    /*
     * WARNING - void declaration
     */
    public final void startMonitoringBeacons(@NotNull RadarBeacon[] beacons) {
        void $this$mapNotNullTo$iv$iv;
        BluetoothAdapter bluetoothAdapter;
        Intrinsics.checkNotNullParameter((Object)beacons, (String)"beacons");
        if (RadarSettings.INSTANCE.getSdkConfiguration(this.context).getUseRadarModifiedBeacon()) {
            return;
        }
        if (!this.permissionsHelper.bluetoothPermissionsGranted$sdk_release(this.context)) {
            RadarLogger.d$default(this.logger, "Bluetooth permissions not granted", null, null, 6, null);
            return;
        }
        if (!this.isBluetoothSupported(this.context)) {
            RadarLogger.d$default(this.logger, "Bluetooth not supported", null, null, 6, null);
            return;
        }
        if (this.adapter == null) {
            BluetoothAdapter bluetoothAdapter2 = BluetoothAdapter.getDefaultAdapter();
            Intrinsics.checkNotNullExpressionValue((Object)bluetoothAdapter2, (String)"getDefaultAdapter()");
            this.adapter = bluetoothAdapter2;
        }
        if ((bluetoothAdapter = this.adapter) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
            bluetoothAdapter = null;
        }
        if (!bluetoothAdapter.isEnabled()) {
            RadarLogger.d$default(this.logger, "Bluetooth not enabled", null, null, 6, null);
            return;
        }
        RadarBeacon[] $this$mapNotNull$iv = beacons;
        int $i$f$mapNotNull = 0;
        RadarBeacon[] radarBeaconArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            String it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            if (it.get_id() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set newBeaconIdentifiers = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        if (Intrinsics.areEqual(this.monitoredBeaconIdentifiers, (Object)newBeaconIdentifiers)) {
            RadarLogger.d$default(this.logger, "Already monitoring beacons", null, null, 6, null);
            return;
        }
        this.stopMonitoringBeacons();
        if (beacons.length == 0) {
            RadarLogger.d$default(this.logger, "No beacons to monitor", null, null, 6, null);
            return;
        }
        this.monitoredBeaconIdentifiers = newBeaconIdentifiers;
        List scanFilters = new ArrayList();
        for (RadarBeacon beacon : beacons) {
            ScanFilter scanFilter = null;
            try {
                RadarLogger.d$default(this.logger, "Building scan filter for monitoring | _id = " + beacon.get_id(), null, null, 6, null);
                scanFilter = RadarBeaconUtils.INSTANCE.getScanFilterForBeacon(beacon);
            }
            catch (Exception e) {
                this.logger.d("Error building scan filter for monitoring | _id = " + beacon.get_id(), Radar.RadarLogType.SDK_EXCEPTION, e);
            }
            if (scanFilter == null) continue;
            RadarLogger.d$default(this.logger, "Starting monitoring beacon | _id = " + beacon.get_id() + "; uuid = " + beacon.getUuid() + "; major = " + beacon.getMajor() + "; minor = " + beacon.getMinor(), null, null, 6, null);
            scanFilters.add(scanFilter);
        }
        if (scanFilters.size() == 0) {
            RadarLogger.d$default(this.logger, "No scan filters for monitoring", null, null, 6, null);
            return;
        }
        try {
            ScanSettings scanSettings = this.getScanSettings(0);
            RadarLogger.d$default(this.logger, "Starting monitoring beacons", null, null, 6, null);
            BluetoothAdapter bluetoothAdapter3 = this.adapter;
            if (bluetoothAdapter3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
                bluetoothAdapter3 = null;
            }
            bluetoothAdapter3.getBluetoothLeScanner().startScan(scanFilters, scanSettings, RadarLocationReceiver.Companion.getBeaconPendingIntent$sdk_release(this.context));
        }
        catch (Exception e) {
            this.logger.e("Error starting monitoring beacons", Radar.RadarLogType.SDK_EXCEPTION, e);
        }
    }

    public final void startMonitoringBeaconUUIDs(@Nullable String[] beaconUUIDs, @Nullable String[] beaconUIDs) {
        ScanFilter scanFilter;
        Iterator iterator;
        BluetoothAdapter bluetoothAdapter;
        if (RadarSettings.INSTANCE.getSdkConfiguration(this.context).getUseRadarModifiedBeacon()) {
            return;
        }
        if (!this.permissionsHelper.bluetoothPermissionsGranted$sdk_release(this.context)) {
            RadarLogger.d$default(this.logger, "Bluetooth permissions not granted", null, null, 6, null);
            return;
        }
        if (!this.isBluetoothSupported(this.context)) {
            RadarLogger.d$default(this.logger, "Bluetooth not supported", null, null, 6, null);
            return;
        }
        if (this.adapter == null) {
            BluetoothAdapter bluetoothAdapter2 = BluetoothAdapter.getDefaultAdapter();
            Intrinsics.checkNotNullExpressionValue((Object)bluetoothAdapter2, (String)"getDefaultAdapter()");
            this.adapter = bluetoothAdapter2;
        }
        if ((bluetoothAdapter = this.adapter) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
            bluetoothAdapter = null;
        }
        if (!bluetoothAdapter.isEnabled()) {
            RadarLogger.d$default(this.logger, "Bluetooth not enabled", null, null, 6, null);
            return;
        }
        Set newBeaconIdentifiers = new LinkedHashSet();
        if (beaconUUIDs != null) {
            CollectionsKt.addAll((Collection)newBeaconIdentifiers, (Object[])beaconUUIDs);
        }
        if (beaconUIDs != null) {
            CollectionsKt.addAll((Collection)newBeaconIdentifiers, (Object[])beaconUIDs);
        }
        if (Intrinsics.areEqual(this.monitoredBeaconIdentifiers, (Object)newBeaconIdentifiers)) {
            RadarLogger.d$default(this.logger, "Already monitoring beacons", null, null, 6, null);
            return;
        }
        this.stopMonitoringBeacons();
        String[] stringArray = beaconUUIDs;
        if ((stringArray == null || stringArray.length == 0) && ((stringArray = beaconUIDs) == null || stringArray.length == 0)) {
            RadarLogger.d$default(this.logger, "No beacon UUIDs or UIDs to monitor", null, null, 6, null);
            return;
        }
        this.monitoredBeaconIdentifiers = newBeaconIdentifiers;
        List scanFilters = new ArrayList();
        if (beaconUUIDs != null) {
            iterator = ArrayIteratorKt.iterator((Object[])beaconUUIDs);
            while (iterator.hasNext()) {
                String beaconUUID = (String)iterator.next();
                scanFilter = null;
                try {
                    RadarLogger.d$default(this.logger, "Building scan filter for monitoring | beaconUUID = " + beaconUUID, null, null, 6, null);
                    scanFilter = RadarBeaconUtils.INSTANCE.getScanFilterForBeacon(beaconUUID);
                }
                catch (Exception e) {
                    this.logger.d("Error building scan filter for monitoring | beaconUUID = " + beaconUUID, Radar.RadarLogType.SDK_EXCEPTION, e);
                }
                if (scanFilter == null) continue;
                RadarLogger.d$default(this.logger, "Starting monitoring beacon UUID | beaconUUID = " + beaconUUID, null, null, 6, null);
                scanFilters.add(scanFilter);
            }
        }
        if (beaconUIDs != null) {
            iterator = ArrayIteratorKt.iterator((Object[])beaconUIDs);
            while (iterator.hasNext()) {
                String beaconUID = (String)iterator.next();
                scanFilter = null;
                try {
                    RadarLogger.d$default(this.logger, "Building scan filter for monitoring | beaconUID = " + beaconUID, null, null, 6, null);
                    scanFilter = RadarBeaconUtils.INSTANCE.getScanFilterForBeaconUID(beaconUID);
                }
                catch (Exception e) {
                    this.logger.d("Error building scan filter for monitoring | beaconUID = " + beaconUID, Radar.RadarLogType.SDK_EXCEPTION, e);
                }
                if (scanFilter == null) continue;
                RadarLogger.d$default(this.logger, "Starting monitoring beacon UID | beaconUID = " + beaconUID, null, null, 6, null);
                scanFilters.add(scanFilter);
            }
        }
        if (scanFilters.size() == 0) {
            RadarLogger.d$default(this.logger, "No scan filters for monitoring", null, null, 6, null);
            return;
        }
        try {
            ScanSettings scanSettings = this.getScanSettings(0);
            RadarLogger.d$default(this.logger, "Starting monitoring beacon UUIDs", null, null, 6, null);
            BluetoothAdapter bluetoothAdapter3 = this.adapter;
            if (bluetoothAdapter3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
                bluetoothAdapter3 = null;
            }
            bluetoothAdapter3.getBluetoothLeScanner().startScan(scanFilters, scanSettings, RadarLocationReceiver.Companion.getBeaconPendingIntent$sdk_release(this.context));
        }
        catch (Exception e) {
            this.logger.e("Error starting monitoring beacon UUIDs", Radar.RadarLogType.SDK_EXCEPTION, e);
        }
    }

    public final void stopMonitoringBeacons() {
        BluetoothAdapter bluetoothAdapter;
        if (RadarSettings.INSTANCE.getSdkConfiguration(this.context).getUseRadarModifiedBeacon()) {
            return;
        }
        if (!this.permissionsHelper.bluetoothPermissionsGranted$sdk_release(this.context)) {
            return;
        }
        if (!this.isBluetoothSupported(this.context)) {
            return;
        }
        if (this.adapter == null) {
            BluetoothAdapter bluetoothAdapter2 = BluetoothAdapter.getDefaultAdapter();
            Intrinsics.checkNotNullExpressionValue((Object)bluetoothAdapter2, (String)"getDefaultAdapter()");
            this.adapter = bluetoothAdapter2;
        }
        if ((bluetoothAdapter = this.adapter) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
            bluetoothAdapter = null;
        }
        if (!bluetoothAdapter.isEnabled()) {
            RadarLogger.d$default(this.logger, "Bluetooth not enabled", null, null, 6, null);
            return;
        }
        RadarLogger.d$default(this.logger, "Stopping monitoring beacons", null, null, 6, null);
        try {
            BluetoothAdapter bluetoothAdapter3 = this.adapter;
            if (bluetoothAdapter3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
                bluetoothAdapter3 = null;
            }
            bluetoothAdapter3.getBluetoothLeScanner().stopScan(RadarLocationReceiver.Companion.getBeaconPendingIntent$sdk_release(this.context));
        }
        catch (Exception e) {
            this.logger.d("Error stopping monitoring beacons", Radar.RadarLogType.SDK_EXCEPTION, e);
        }
        this.monitoredBeaconIdentifiers = SetsKt.emptySet();
    }

    public final void rangeBeacons(@NotNull RadarBeacon[] beacons, boolean background, @Nullable Radar.RadarBeaconCallback callback) {
        BluetoothAdapter bluetoothAdapter;
        Intrinsics.checkNotNullParameter((Object)beacons, (String)"beacons");
        if (!this.permissionsHelper.bluetoothPermissionsGranted$sdk_release(this.context)) {
            RadarLogger.d$default(this.logger, "Bluetooth permissions not granted", null, null, 6, null);
            Radar.sendError$sdk_release$default(Radar.INSTANCE, Radar.RadarStatus.ERROR_PERMISSIONS, null, 2, null);
            Radar.RadarBeaconCallback radarBeaconCallback = callback;
            if (radarBeaconCallback != null) {
                Radar.RadarBeaconCallback.DefaultImpls.onComplete$default(radarBeaconCallback, Radar.RadarStatus.ERROR_PERMISSIONS, null, 2, null);
            }
            return;
        }
        if (!this.isBluetoothSupported(this.context)) {
            RadarLogger.d$default(this.logger, "Bluetooth not supported", null, null, 6, null);
            Radar.sendError$sdk_release$default(Radar.INSTANCE, Radar.RadarStatus.ERROR_BLUETOOTH, null, 2, null);
            Radar.RadarBeaconCallback radarBeaconCallback = callback;
            if (radarBeaconCallback != null) {
                Radar.RadarBeaconCallback.DefaultImpls.onComplete$default(radarBeaconCallback, Radar.RadarStatus.ERROR_BLUETOOTH, null, 2, null);
            }
            return;
        }
        if (this.adapter == null) {
            BluetoothAdapter bluetoothAdapter2 = BluetoothAdapter.getDefaultAdapter();
            Intrinsics.checkNotNullExpressionValue((Object)bluetoothAdapter2, (String)"getDefaultAdapter()");
            this.adapter = bluetoothAdapter2;
        }
        if ((bluetoothAdapter = this.adapter) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
            bluetoothAdapter = null;
        }
        if (!bluetoothAdapter.isEnabled()) {
            RadarLogger.d$default(this.logger, "Bluetooth not enabled", null, null, 6, null);
            Radar.sendError$sdk_release$default(Radar.INSTANCE, Radar.RadarStatus.ERROR_BLUETOOTH, null, 2, null);
            Radar.RadarBeaconCallback radarBeaconCallback = callback;
            if (radarBeaconCallback != null) {
                Radar.RadarBeaconCallback.DefaultImpls.onComplete$default(radarBeaconCallback, Radar.RadarStatus.ERROR_BLUETOOTH, null, 2, null);
            }
            return;
        }
        if (beacons.length == 0) {
            RadarLogger.d$default(this.logger, "No beacons to range", null, null, 6, null);
            Radar.RadarBeaconCallback radarBeaconCallback = callback;
            if (radarBeaconCallback != null) {
                boolean $i$f$emptyArray = false;
                radarBeaconCallback.onComplete(Radar.RadarStatus.SUCCESS, (RadarBeacon[])((Object[])new RadarBeacon[0]));
            }
            return;
        }
        this.addCallback(callback);
        if (this.started) {
            RadarLogger.d$default(this.logger, "Already ranging beacons", null, null, 6, null);
            return;
        }
        this.beacons = beacons;
        this.started = true;
        List scanFilters = new ArrayList();
        for (RadarBeacon beacon : beacons) {
            ScanFilter scanFilter = null;
            try {
                RadarLogger.d$default(this.logger, "Building scan filter for ranging | _id = " + beacon.get_id(), null, null, 6, null);
                scanFilter = RadarBeaconUtils.INSTANCE.getScanFilterForBeacon(beacon);
            }
            catch (Exception e) {
                this.logger.d("Error building scan filter for ranging | _id = " + beacon.get_id(), Radar.RadarLogType.SDK_EXCEPTION, e);
            }
            if (scanFilter == null) continue;
            RadarLogger.d$default(this.logger, "Starting ranging beacon | type = " + (Object)((Object)beacon.getType()) + "; _id = " + beacon.get_id() + "; uuid = " + beacon.getUuid() + "; major = " + beacon.getMajor() + "; minor = " + beacon.getMinor(), null, null, 6, null);
            scanFilters.add(scanFilter);
        }
        if (scanFilters.size() == 0) {
            RadarLogger.d$default(this.logger, "No scan filters for ranging", null, null, 6, null);
            RadarBeaconManager.callCallbacks$default(this, null, 1, null);
            return;
        }
        int scanMode = background ? 0 : 2;
        ScanSettings scanSettings = this.getScanSettings(scanMode);
        RadarBeaconManager beaconManager = this;
        this.scanCallback = new ScanCallback(beaconManager, this){
            final /* synthetic */ RadarBeaconManager $beaconManager;
            final /* synthetic */ RadarBeaconManager this$0;
            {
                this.$beaconManager = $beaconManager;
                this.this$0 = $receiver;
            }

            public void onScanResult(int callbackType, @Nullable ScanResult result) {
                super.onScanResult(callbackType, result);
                RadarBeaconManager.handleScanResult$sdk_release$default(this.$beaconManager, callbackType, result, false, 4, null);
            }

            /*
             * WARNING - void declaration
             */
            public void onBatchScanResults(@Nullable List<ScanResult> results) {
                block1: {
                    void $this$forEach$iv;
                    super.onBatchScanResults(results);
                    List<ScanResult> list = results;
                    if (list == null) break block1;
                    Iterable iterable = list;
                    RadarBeaconManager radarBeaconManager = this.$beaconManager;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        ScanResult result = (ScanResult)element$iv;
                        boolean bl = false;
                        RadarBeaconManager.handleScanResult$sdk_release$default(radarBeaconManager, 2, result, false, 4, null);
                    }
                }
            }

            public void onScanFailed(int errorCode) {
                super.onScanFailed(errorCode);
                RadarLogger.d$default(RadarBeaconManager.access$getLogger$p(this.this$0), "Scan failed", null, null, 6, null);
                RadarBeaconManager.access$stopRanging(this.$beaconManager);
            }
        };
        try {
            BluetoothAdapter bluetoothAdapter3 = this.adapter;
            if (bluetoothAdapter3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
                bluetoothAdapter3 = null;
            }
            bluetoothAdapter3.getBluetoothLeScanner().startScan(scanFilters, scanSettings, this.scanCallback);
        }
        catch (Exception e) {
            this.logger.e("Error starting ranging beacons", Radar.RadarLogType.SDK_EXCEPTION, e);
        }
        this.handler.postAtTime(() -> RadarBeaconManager.rangeBeacons$lambda-3(this), (Object)TIMEOUT_TOKEN, SystemClock.uptimeMillis() + 5000L);
    }

    public final void rangeBeaconUUIDs(@Nullable String[] beaconUUIDs, @Nullable String[] beaconUIDs, boolean background, @Nullable Radar.RadarBeaconCallback callback) {
        ScanFilter scanFilter;
        Iterator iterator;
        BluetoothAdapter bluetoothAdapter;
        if (!this.permissionsHelper.bluetoothPermissionsGranted$sdk_release(this.context)) {
            RadarLogger.d$default(this.logger, "Bluetooth permissions not granted", null, null, 6, null);
            Radar.sendError$sdk_release$default(Radar.INSTANCE, Radar.RadarStatus.ERROR_PERMISSIONS, null, 2, null);
            Radar.RadarBeaconCallback radarBeaconCallback = callback;
            if (radarBeaconCallback != null) {
                Radar.RadarBeaconCallback.DefaultImpls.onComplete$default(radarBeaconCallback, Radar.RadarStatus.ERROR_PERMISSIONS, null, 2, null);
            }
            return;
        }
        if (!this.isBluetoothSupported(this.context)) {
            RadarLogger.d$default(this.logger, "Bluetooth not supported", null, null, 6, null);
            Radar.sendError$sdk_release$default(Radar.INSTANCE, Radar.RadarStatus.ERROR_BLUETOOTH, null, 2, null);
            Radar.RadarBeaconCallback radarBeaconCallback = callback;
            if (radarBeaconCallback != null) {
                Radar.RadarBeaconCallback.DefaultImpls.onComplete$default(radarBeaconCallback, Radar.RadarStatus.ERROR_BLUETOOTH, null, 2, null);
            }
            return;
        }
        if (this.adapter == null) {
            BluetoothAdapter bluetoothAdapter2 = BluetoothAdapter.getDefaultAdapter();
            Intrinsics.checkNotNullExpressionValue((Object)bluetoothAdapter2, (String)"getDefaultAdapter()");
            this.adapter = bluetoothAdapter2;
        }
        if ((bluetoothAdapter = this.adapter) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
            bluetoothAdapter = null;
        }
        if (!bluetoothAdapter.isEnabled()) {
            RadarLogger.d$default(this.logger, "Bluetooth not enabled", null, null, 6, null);
            Radar.sendError$sdk_release$default(Radar.INSTANCE, Radar.RadarStatus.ERROR_BLUETOOTH, null, 2, null);
            Radar.RadarBeaconCallback radarBeaconCallback = callback;
            if (radarBeaconCallback != null) {
                Radar.RadarBeaconCallback.DefaultImpls.onComplete$default(radarBeaconCallback, Radar.RadarStatus.ERROR_BLUETOOTH, null, 2, null);
            }
            return;
        }
        String[] stringArray = beaconUUIDs;
        if ((stringArray == null || stringArray.length == 0) && ((stringArray = beaconUIDs) == null || stringArray.length == 0)) {
            RadarLogger.d$default(this.logger, "No beacon UUIDs or UIDs to range", null, null, 6, null);
            Radar.RadarBeaconCallback radarBeaconCallback = callback;
            if (radarBeaconCallback != null) {
                boolean $i$f$emptyArray = false;
                radarBeaconCallback.onComplete(Radar.RadarStatus.SUCCESS, (RadarBeacon[])((Object[])new RadarBeacon[0]));
            }
            return;
        }
        this.addCallback(callback);
        if (this.started) {
            RadarLogger.d$default(this.logger, "Already ranging beacons", null, null, 6, null);
            return;
        }
        String[] stringArray2 = beaconUUIDs;
        if (beaconUUIDs == null) {
            stringArray2 = new String[]{};
        }
        this.beaconUUIDs = stringArray2;
        String[] stringArray3 = beaconUIDs;
        if (beaconUIDs == null) {
            stringArray3 = new String[]{};
        }
        this.beaconUIDs = stringArray3;
        this.started = true;
        List scanFilters = new ArrayList();
        if (beaconUUIDs != null) {
            iterator = ArrayIteratorKt.iterator((Object[])beaconUUIDs);
            while (iterator.hasNext()) {
                String beaconUUID = (String)iterator.next();
                scanFilter = null;
                try {
                    RadarLogger.d$default(this.logger, "Building scan filter for ranging | beaconUUID = " + beaconUUID, null, null, 6, null);
                    scanFilter = RadarBeaconUtils.INSTANCE.getScanFilterForBeacon(beaconUUID);
                }
                catch (Exception e) {
                    this.logger.d("Error building scan filter for ranging | beaconUUID = " + beaconUUID, Radar.RadarLogType.SDK_EXCEPTION, e);
                }
                if (scanFilter == null) continue;
                RadarLogger.d$default(this.logger, "Starting ranging beacon UUID | beaconUUID = " + beaconUUID, null, null, 6, null);
                scanFilters.add(scanFilter);
            }
        }
        if (beaconUIDs != null) {
            iterator = ArrayIteratorKt.iterator((Object[])beaconUIDs);
            while (iterator.hasNext()) {
                String beaconUID = (String)iterator.next();
                scanFilter = null;
                try {
                    RadarLogger.d$default(this.logger, "Building scan filter for ranging | beaconUID = " + beaconUID, null, null, 6, null);
                    scanFilter = RadarBeaconUtils.INSTANCE.getScanFilterForBeaconUID(beaconUID);
                }
                catch (Exception e) {
                    this.logger.d("Error building scan filter for ranging | beaconUID = " + beaconUID, Radar.RadarLogType.SDK_EXCEPTION, e);
                }
                if (scanFilter == null) continue;
                RadarLogger.d$default(this.logger, "Starting ranging beacon UID | beaconUID = " + beaconUID, null, null, 6, null);
                scanFilters.add(scanFilter);
            }
        }
        if (scanFilters.size() == 0) {
            RadarLogger.d$default(this.logger, "No scan filters for ranging", null, null, 6, null);
            RadarBeaconManager.callCallbacks$default(this, null, 1, null);
            return;
        }
        int scanMode = background ? 0 : 2;
        ScanSettings scanSettings = this.getScanSettings(scanMode);
        RadarBeaconManager beaconManager = this;
        this.scanCallback = new ScanCallback(beaconManager, this){
            final /* synthetic */ RadarBeaconManager $beaconManager;
            final /* synthetic */ RadarBeaconManager this$0;
            {
                this.$beaconManager = $beaconManager;
                this.this$0 = $receiver;
            }

            public void onScanResult(int callbackType, @Nullable ScanResult result) {
                super.onScanResult(callbackType, result);
                RadarBeaconManager.handleScanResult$sdk_release$default(this.$beaconManager, callbackType, result, false, 4, null);
            }

            /*
             * WARNING - void declaration
             */
            public void onBatchScanResults(@Nullable List<ScanResult> results) {
                block1: {
                    void $this$forEach$iv;
                    super.onBatchScanResults(results);
                    List<ScanResult> list = results;
                    if (list == null) break block1;
                    Iterable iterable = list;
                    RadarBeaconManager radarBeaconManager = this.$beaconManager;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        ScanResult result = (ScanResult)element$iv;
                        boolean bl = false;
                        RadarBeaconManager.handleScanResult$sdk_release$default(radarBeaconManager, 2, result, false, 4, null);
                    }
                }
            }

            public void onScanFailed(int errorCode) {
                super.onScanFailed(errorCode);
                RadarLogger.d$default(RadarBeaconManager.access$getLogger$p(this.this$0), "Scan failed", null, null, 6, null);
                RadarBeaconManager.access$stopRanging(this.$beaconManager);
            }
        };
        try {
            BluetoothAdapter bluetoothAdapter3 = this.adapter;
            if (bluetoothAdapter3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
                bluetoothAdapter3 = null;
            }
            bluetoothAdapter3.getBluetoothLeScanner().startScan(scanFilters, scanSettings, this.scanCallback);
        }
        catch (Exception e) {
            this.logger.e("Error starting ranging beacon UUIDs", Radar.RadarLogType.SDK_EXCEPTION, e);
        }
        this.handler.postAtTime(() -> RadarBeaconManager.rangeBeaconUUIDs$lambda-4(this), (Object)TIMEOUT_TOKEN, SystemClock.uptimeMillis() + 5000L);
    }

    private final void stopRanging() {
        if (!this.permissionsHelper.bluetoothPermissionsGranted$sdk_release(this.context)) {
            return;
        }
        if (!this.isBluetoothSupported(this.context)) {
            return;
        }
        if (this.adapter == null) {
            BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
            Intrinsics.checkNotNullExpressionValue((Object)bluetoothAdapter, (String)"getDefaultAdapter()");
            this.adapter = bluetoothAdapter;
        }
        RadarLogger.d$default(this.logger, "Stopping ranging", null, null, 6, null);
        this.handler.removeCallbacksAndMessages((Object)TIMEOUT_TOKEN);
        try {
            BluetoothAdapter bluetoothAdapter = this.adapter;
            if (bluetoothAdapter == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
                bluetoothAdapter = null;
            }
            bluetoothAdapter.getBluetoothLeScanner().stopScan(this.scanCallback);
        }
        catch (Exception e) {
            this.logger.d("Error stopping ranging beacons", Radar.RadarLogType.SDK_EXCEPTION, e);
        }
        this.scanCallback = null;
        Collection $this$toTypedArray$iv = this.nearbyBeacons;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        RadarBeacon[] radarBeaconArray = thisCollection$iv.toArray(new RadarBeacon[0]);
        if (radarBeaconArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        this.callCallbacks(radarBeaconArray);
        this.beacons = new RadarBeacon[0];
        this.started = false;
        this.nearbyBeacons.clear();
    }

    public final void handleBeacons$sdk_release(@Nullable RadarBeacon[] beacons, @NotNull Radar.RadarLocationSource source) {
        Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
        RadarBeacon[] radarBeaconArray = beacons;
        if (radarBeaconArray == null || radarBeaconArray.length == 0) {
            RadarLogger.d$default(this.logger, "No beacons to handle", null, null, 6, null);
            return;
        }
        RadarBeacon[] $this$forEach$iv = beacons;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            RadarBeacon element$iv;
            RadarBeacon beacon = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            if (source == Radar.RadarLocationSource.BEACON_EXIT) {
                RadarLogger.d$default(this.logger, "Handling beacon exit | beacon.type = " + (Object)((Object)beacon.getType()) + "; beacon.uuid = " + beacon.getUuid() + "; beacon.major = " + beacon.getMajor() + "; beacon.minor = " + beacon.getMinor() + "; beacon.rssi = " + beacon.getRssi(), null, null, 6, null);
                this.nearbyBeacons.remove(beacon);
                continue;
            }
            RadarLogger.d$default(this.logger, "Handling beacon entry | beacon.type = " + (Object)((Object)beacon.getType()) + "; beacon.uuid = " + beacon.getUuid() + "; beacon.major = " + beacon.getMajor() + "; beacon.minor = " + beacon.getMinor() + "; beacon.rssi = " + beacon.getRssi(), null, null, 6, null);
            this.nearbyBeacons.add(beacon);
        }
    }

    public final void handleScanResult$sdk_release(int callbackType, @Nullable ScanResult result, boolean ranging) {
        RadarLogger.d$default(this.logger, "Handling scan result", null, null, 6, null);
        try {
            Object object = result;
            if (object != null && (object = object.getScanRecord()) != null) {
                ScanResult scanRecord = object;
                boolean bl = false;
                RadarBeacon radarBeacon = RadarBeaconUtils.INSTANCE.getBeacon(result, (ScanRecord)scanRecord);
                object = radarBeacon;
                if (radarBeacon != null) {
                    boolean bl2;
                    Object beacon = object;
                    boolean bl3 = false;
                    RadarLogger.d$default(this.logger, "Ranged beacon | beacon.type = " + (Object)((Object)((RadarBeacon)beacon).getType()) + "; beacon.uuid = " + ((RadarBeacon)beacon).getUuid() + "; beacon.major = " + ((RadarBeacon)beacon).getMajor() + "; beacon.minor = " + ((RadarBeacon)beacon).getMinor() + "; beacon.rssi = " + ((RadarBeacon)beacon).getRssi(), null, null, 6, null);
                    if (callbackType == 4) {
                        RadarLogger.d$default(this.logger, "Handling beacon exit | beacon.type = " + (Object)((Object)((RadarBeacon)beacon).getType()) + "; beacon.uuid = " + ((RadarBeacon)beacon).getUuid() + "; beacon.major = " + ((RadarBeacon)beacon).getMajor() + "; beacon.minor = " + ((RadarBeacon)beacon).getMinor() + "; beacon.rssi = " + ((RadarBeacon)beacon).getRssi(), null, null, 6, null);
                        bl2 = this.nearbyBeacons.remove(beacon);
                    } else {
                        RadarLogger.d$default(this.logger, "Handling beacon entry | beacon.type = " + (Object)((Object)((RadarBeacon)beacon).getType()) + "; beacon.uuid = " + ((RadarBeacon)beacon).getUuid() + "; beacon.major = " + ((RadarBeacon)beacon).getMajor() + "; beacon.minor = " + ((RadarBeacon)beacon).getMinor() + "; beacon.rssi = " + ((RadarBeacon)beacon).getRssi(), null, null, 6, null);
                        bl2 = this.nearbyBeacons.add((RadarBeacon)beacon);
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.e("Error handling scan result", Radar.RadarLogType.SDK_EXCEPTION, e);
        }
        if (this.nearbyBeacons.size() == this.beacons.length && ranging) {
            RadarLogger.d$default(this.logger, "Finished ranging", null, null, 6, null);
            this.stopRanging();
        }
    }

    public static /* synthetic */ void handleScanResult$sdk_release$default(RadarBeaconManager radarBeaconManager, int n, ScanResult scanResult, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = true;
        }
        radarBeaconManager.handleScanResult$sdk_release(n, scanResult, bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isBluetoothSupported(Context context) {
        BluetoothAdapter bluetoothAdapter;
        BluetoothAdapter defaultAdapter;
        if (this.adapter == null && (defaultAdapter = BluetoothAdapter.getDefaultAdapter()) != null) {
            this.adapter = defaultAdapter;
        }
        if (!context.getPackageManager().hasSystemFeature("android.hardware.bluetooth")) return false;
        BluetoothAdapter bluetoothAdapter2 = this.adapter;
        if (bluetoothAdapter2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
            bluetoothAdapter2 = null;
        }
        if ((bluetoothAdapter = this.adapter) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
            bluetoothAdapter = null;
        }
        if (bluetoothAdapter.getBluetoothLeScanner() == null) return false;
        return true;
    }

    private final ScanSettings getScanSettings(int scanMode) {
        ScanSettings scanSettings = new ScanSettings.Builder().setScanMode(scanMode).build();
        Intrinsics.checkNotNullExpressionValue((Object)scanSettings, (String)"Builder()\n            .s\u2026ode)\n            .build()");
        return scanSettings;
    }

    private static final void rangeBeacons$lambda-3(RadarBeaconManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        RadarLogger.d$default(this$0.logger, "Beacon ranging timeout", null, null, 6, null);
        this$0.stopRanging();
    }

    private static final void rangeBeaconUUIDs$lambda-4(RadarBeaconManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        RadarLogger.d$default(this$0.logger, "Beacon ranging timeout", null, null, 6, null);
        this$0.stopRanging();
    }

    public static final /* synthetic */ RadarLogger access$getLogger$p(RadarBeaconManager $this) {
        return $this.logger;
    }

    public static final /* synthetic */ void access$stopRanging(RadarBeaconManager $this) {
        $this.stopRanging();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/radar/sdk/RadarBeaconManager$Companion;", "", "()V", "TIMEOUT_TOKEN", "", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

