/*
 * Decompiled with CFR 0.152.
 */
package io.radar.sdk;

import android.content.Context;
import android.content.SharedPreferences;
import io.radar.sdk.Radar;
import io.radar.sdk.RadarLogger;
import io.radar.sdk.RadarNotificationOptions;
import io.radar.sdk.RadarTrackingOptions;
import io.radar.sdk.RadarTripOptions;
import io.radar.sdk.model.RadarSdkConfiguration;
import java.text.DecimalFormat;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b3\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0000\u00a2\u0006\u0002\b+J\u0015\u0010,\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0000\u00a2\u0006\u0002\b-J\u000e\u0010.\u001a\u00020/2\u0006\u0010)\u001a\u00020*J\u0017\u00100\u001a\u0004\u0018\u00010\u00042\u0006\u0010)\u001a\u00020*H\u0000\u00a2\u0006\u0002\b1J\u0015\u00102\u001a\u0002032\u0006\u0010)\u001a\u00020*H\u0000\u00a2\u0006\u0002\b4J\u0015\u00105\u001a\u00020\u00042\u0006\u0010)\u001a\u00020*H\u0000\u00a2\u0006\u0002\b6J\u0017\u00107\u001a\u0004\u0018\u00010\u00042\u0006\u0010)\u001a\u00020*H\u0000\u00a2\u0006\u0002\b8J\u0015\u00109\u001a\u00020\u00042\u0006\u0010)\u001a\u00020*H\u0000\u00a2\u0006\u0002\b:J\u0015\u0010;\u001a\u00020<2\u0006\u0010)\u001a\u00020*H\u0000\u00a2\u0006\u0002\b=J\u0015\u0010>\u001a\u00020<2\u0006\u0010)\u001a\u00020*H\u0000\u00a2\u0006\u0002\b?J\u0017\u0010@\u001a\u0004\u0018\u00010\u00042\u0006\u0010)\u001a\u00020*H\u0000\u00a2\u0006\u0002\bAJ\u0015\u0010B\u001a\u00020C2\u0006\u0010)\u001a\u00020*H\u0000\u00a2\u0006\u0002\bDJ\u0017\u0010E\u001a\u0004\u0018\u00010/2\u0006\u0010)\u001a\u00020*H\u0000\u00a2\u0006\u0002\bFJ\u0017\u0010G\u001a\u0004\u0018\u00010H2\u0006\u0010)\u001a\u00020*H\u0000\u00a2\u0006\u0002\bIJ\u0015\u0010J\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0000\u00a2\u0006\u0002\bKJ\u0017\u0010L\u001a\u0004\u0018\u00010M2\u0006\u0010)\u001a\u00020*H\u0000\u00a2\u0006\u0002\bNJ\u0017\u0010O\u001a\u0004\u0018\u00010\u00042\u0006\u0010)\u001a\u00020*H\u0000\u00a2\u0006\u0002\bPJ\u0017\u0010Q\u001a\u0004\u0018\u00010\u00042\u0006\u0010)\u001a\u00020*H\u0000\u00a2\u0006\u0002\bRJ\u0017\u0010S\u001a\u0004\u0018\u00010M2\u0006\u0010)\u001a\u00020*H\u0000\u00a2\u0006\u0002\bTJ\u000e\u0010U\u001a\u00020V2\u0006\u0010)\u001a\u00020*J\u0015\u0010W\u001a\u00020\u00042\u0006\u0010)\u001a\u00020*H\u0000\u00a2\u0006\u0002\bXJ\u0010\u0010Y\u001a\u00020Z2\u0006\u0010)\u001a\u00020*H\u0002J\u0015\u0010[\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0000\u00a2\u0006\u0002\b\\J\u0015\u0010]\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0000\u00a2\u0006\u0002\b^J\u0015\u0010_\u001a\u00020M2\u0006\u0010)\u001a\u00020*H\u0000\u00a2\u0006\u0002\b`J\u0018\u0010a\u001a\u00020M2\u0006\u0010)\u001a\u00020*2\u0006\u0010b\u001a\u00020\u0004H\u0002J\u0017\u0010c\u001a\u0004\u0018\u00010d2\u0006\u0010)\u001a\u00020*H\u0000\u00a2\u0006\u0002\beJ\u0015\u0010f\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0000\u00a2\u0006\u0002\bgJ\u0017\u0010h\u001a\u0004\u0018\u00010\u00042\u0006\u0010)\u001a\u00020*H\u0000\u00a2\u0006\u0002\biJ\u0015\u0010j\u001a\u00020\u00042\u0006\u0010)\u001a\u00020*H\u0000\u00a2\u0006\u0002\bkJ\u0017\u0010l\u001a\u0004\u0018\u00010\u00042\u0006\u0010)\u001a\u00020*H\u0000\u00a2\u0006\u0002\bmJ\u0017\u0010n\u001a\u0004\u0018\u00010\u00042\u0006\u0010)\u001a\u00020*H\u0000\u00a2\u0006\u0002\boJ\u0015\u0010p\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0000\u00a2\u0006\u0002\bqJ\u0015\u0010r\u001a\u00020s2\u0006\u0010)\u001a\u00020*H\u0000\u00a2\u0006\u0002\btJ\u0015\u0010u\u001a\u00020s2\u0006\u0010)\u001a\u00020*H\u0000\u00a2\u0006\u0002\bvJ\u001d\u0010w\u001a\u00020s2\u0006\u0010)\u001a\u00020*2\u0006\u0010x\u001a\u00020(H\u0000\u00a2\u0006\u0002\byJ\u001d\u0010z\u001a\u00020s2\u0006\u0010)\u001a\u00020*2\u0006\u0010x\u001a\u00020(H\u0000\u00a2\u0006\u0002\b{J\u0018\u0010|\u001a\u00020s2\u0006\u0010)\u001a\u00020*2\b\u0010}\u001a\u0004\u0018\u00010/J \u0010~\u001a\u00020s2\u0006\u0010)\u001a\u00020*2\b\u0010\u007f\u001a\u0004\u0018\u00010\u0004H\u0000\u00a2\u0006\u0003\b\u0080\u0001J \u0010\u0081\u0001\u001a\u00020s2\u0006\u0010)\u001a\u00020*2\u0007\u0010\u0082\u0001\u001a\u000203H\u0000\u00a2\u0006\u0003\b\u0083\u0001J\"\u0010\u0084\u0001\u001a\u00020s2\u0006\u0010)\u001a\u00020*2\t\u0010\u0085\u0001\u001a\u0004\u0018\u00010\u0004H\u0000\u00a2\u0006\u0003\b\u0086\u0001J!\u0010\u0087\u0001\u001a\u00020s2\u0006\u0010)\u001a\u00020*2\b\u0010\u0088\u0001\u001a\u00030\u0089\u0001H\u0000\u00a2\u0006\u0003\b\u008a\u0001J \u0010\u008b\u0001\u001a\u00020s2\u0006\u0010)\u001a\u00020*2\u0007\u0010\u008c\u0001\u001a\u00020CH\u0000\u00a2\u0006\u0003\b\u008d\u0001J\"\u0010\u008e\u0001\u001a\u00020s2\u0006\u0010)\u001a\u00020*2\t\u0010\u008f\u0001\u001a\u0004\u0018\u00010/H\u0000\u00a2\u0006\u0003\b\u0090\u0001J \u0010\u0091\u0001\u001a\u00020s2\u0006\u0010)\u001a\u00020*2\u0007\u0010\u0092\u0001\u001a\u00020HH\u0000\u00a2\u0006\u0003\b\u0093\u0001J \u0010\u0094\u0001\u001a\u00020s2\u0006\u0010)\u001a\u00020*2\u0007\u0010\u0095\u0001\u001a\u00020(H\u0000\u00a2\u0006\u0003\b\u0096\u0001J \u0010\u0097\u0001\u001a\u00020s2\u0006\u0010)\u001a\u00020*2\u0007\u0010\u0098\u0001\u001a\u00020MH\u0000\u00a2\u0006\u0003\b\u0099\u0001J\"\u0010\u009a\u0001\u001a\u00020s2\u0006\u0010)\u001a\u00020*2\t\u0010\u009b\u0001\u001a\u0004\u0018\u00010\u0004H\u0000\u00a2\u0006\u0003\b\u009c\u0001J\"\u0010\u009d\u0001\u001a\u00020s2\u0006\u0010)\u001a\u00020*2\t\u0010\u009e\u0001\u001a\u0004\u0018\u00010\u0004H\u0000\u00a2\u0006\u0003\b\u009f\u0001J \u0010\u00a0\u0001\u001a\u00020s2\u0006\u0010)\u001a\u00020*2\u0007\u0010\u0098\u0001\u001a\u00020MH\u0000\u00a2\u0006\u0003\b\u00a1\u0001J\u001a\u0010\u00a2\u0001\u001a\u00020s2\u0006\u0010)\u001a\u00020*2\t\u0010\u00a3\u0001\u001a\u0004\u0018\u00010VJ \u0010\u00a4\u0001\u001a\u00020s2\u0006\u0010)\u001a\u00020*2\u0007\u0010\u00a5\u0001\u001a\u00020(H\u0000\u00a2\u0006\u0003\b\u00a6\u0001J \u0010\u00a7\u0001\u001a\u00020s2\u0006\u0010)\u001a\u00020*2\u0007\u0010\u00a8\u0001\u001a\u00020(H\u0000\u00a2\u0006\u0003\b\u00a9\u0001J \u0010\u00aa\u0001\u001a\u00020s2\u0006\u0010)\u001a\u00020*2\u0007\u0010\u0098\u0001\u001a\u00020MH\u0000\u00a2\u0006\u0003\b\u00ab\u0001J\"\u0010\u00ac\u0001\u001a\u00020s2\u0006\u0010)\u001a\u00020*2\t\u0010\u0098\u0001\u001a\u0004\u0018\u00010dH\u0000\u00a2\u0006\u0003\b\u00ad\u0001J \u0010\u00ae\u0001\u001a\u00020s2\u0006\u0010)\u001a\u00020*2\u0007\u0010\u00af\u0001\u001a\u00020(H\u0000\u00a2\u0006\u0003\b\u00b0\u0001J\"\u0010\u00b1\u0001\u001a\u00020s2\u0006\u0010)\u001a\u00020*2\t\u0010\u00b2\u0001\u001a\u0004\u0018\u00010\u0004H\u0000\u00a2\u0006\u0003\b\u00b3\u0001J\u0017\u0010\u00b4\u0001\u001a\u00020s2\u0006\u0010)\u001a\u00020*H\u0000\u00a2\u0006\u0003\b\u00b5\u0001J\u0017\u0010\u00b6\u0001\u001a\u00020s2\u0006\u0010)\u001a\u00020*H\u0000\u00a2\u0006\u0003\b\u00b7\u0001J\u0017\u0010\u00b8\u0001\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0000\u00a2\u0006\u0003\b\u00b9\u0001J\u0017\u0010\u00ba\u0001\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0000\u00a2\u0006\u0003\b\u00bb\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00bc\u0001"}, d2={"Lio/radar/sdk/RadarSettings;", "", "()V", "KEY_AD_ID_ENABLED", "", "KEY_ANONYMOUS", "KEY_CLIENT_SDK_CONFIGURATION", "KEY_DESCRIPTION", "KEY_FOREGROUND_SERVICE", "KEY_HOST", "KEY_ID", "KEY_INSTALL_ID", "KEY_LAST_APP_OPEN_TIME", "KEY_LAST_TRACKED_TIME", "KEY_LOCATION_SERVICES_PROVIDER", "KEY_LOG_LEVEL", "KEY_METADATA", "KEY_NOTIFICATION_OPTIONS", "KEY_OLD_OFFLINE_MODE", "KEY_OLD_SYNC_MODE", "KEY_OLD_UPDATE_INTERVAL", "KEY_OLD_UPDATE_INTERVAL_RESPONSIVE", "", "KEY_PERMISSIONS_DENIED", "KEY_PREVIOUS_TRACKING_OPTIONS", "KEY_PRODUCT", "KEY_PUBLISHABLE_KEY", "KEY_REMOTE_TRACKING_OPTIONS", "KEY_SDK_CONFIGURATION", "KEY_SESSION_ID", "KEY_SHARING", "KEY_TRACKING", "KEY_TRACKING_OPTIONS", "KEY_TRIP_OPTIONS", "KEY_USER_DEBUG", "KEY_USER_ID", "KEY_VERIFIED_HOST", "KEY_X_PLATFORM_SDK_TYPE", "KEY_X_PLATFORM_SDK_VERSION", "getAdIdEnabled", "", "context", "Landroid/content/Context;", "getAdIdEnabled$sdk_release", "getAnonymousTrackingEnabled", "getAnonymousTrackingEnabled$sdk_release", "getClientSdkConfiguration", "Lorg/json/JSONObject;", "getDescription", "getDescription$sdk_release", "getForegroundService", "Lio/radar/sdk/RadarTrackingOptions$RadarTrackingOptionsForegroundService;", "getForegroundService$sdk_release", "getHost", "getHost$sdk_release", "getId", "getId$sdk_release", "getInstallId", "getInstallId$sdk_release", "getLastAppOpenTimeMillis", "", "getLastAppOpenTimeMillis$sdk_release", "getLastTrackedTime", "getLastTrackedTime$sdk_release", "getLocationServicesProvider", "getLocationServicesProvider$sdk_release", "getLogLevel", "Lio/radar/sdk/Radar$RadarLogLevel;", "getLogLevel$sdk_release", "getMetadata", "getMetadata$sdk_release", "getNotificationOptions", "Lio/radar/sdk/RadarNotificationOptions;", "getNotificationOptions$sdk_release", "getPermissionsDenied", "getPermissionsDenied$sdk_release", "getPreviousTrackingOptions", "Lio/radar/sdk/RadarTrackingOptions;", "getPreviousTrackingOptions$sdk_release", "getProduct", "getProduct$sdk_release", "getPublishableKey", "getPublishableKey$sdk_release", "getRemoteTrackingOptions", "getRemoteTrackingOptions$sdk_release", "getSdkConfiguration", "Lio/radar/sdk/model/RadarSdkConfiguration;", "getSessionId", "getSessionId$sdk_release", "getSharedPreferences", "Landroid/content/SharedPreferences;", "getSharing", "getSharing$sdk_release", "getTracking", "getTracking$sdk_release", "getTrackingOptions", "getTrackingOptions$sdk_release", "getTrackingOptionsByKey", "key", "getTripOptions", "Lio/radar/sdk/RadarTripOptions;", "getTripOptions$sdk_release", "getUserDebug", "getUserDebug$sdk_release", "getUserId", "getUserId$sdk_release", "getVerifiedHost", "getVerifiedHost$sdk_release", "getXPlatformSDKType", "getXPlatformSDKType$sdk_release", "getXPlatformSDKVersion", "getXPlatformSDKVersion$sdk_release", "isXPlatform", "isXPlatform$sdk_release", "removePreviousTrackingOptions", "", "removePreviousTrackingOptions$sdk_release", "removeRemoteTrackingOptions", "removeRemoteTrackingOptions$sdk_release", "setAdIdEnabled", "enabled", "setAdIdEnabled$sdk_release", "setAnonymousTrackingEnabled", "setAnonymousTrackingEnabled$sdk_release", "setClientSdkConfiguration", "sdkConfiguration", "setDescription", "description", "setDescription$sdk_release", "setForegroundService", "foregroundService", "setForegroundService$sdk_release", "setId", "_id", "setId$sdk_release", "setLocationServicesProvider", "provider", "Lio/radar/sdk/Radar$RadarLocationServicesProvider;", "setLocationServicesProvider$sdk_release", "setLogLevel", "level", "setLogLevel$sdk_release", "setMetadata", "metadata", "setMetadata$sdk_release", "setNotificationOptions", "notificationOptions", "setNotificationOptions$sdk_release", "setPermissionsDenied", "denied", "setPermissionsDenied$sdk_release", "setPreviousTrackingOptions", "options", "setPreviousTrackingOptions$sdk_release", "setProduct", "product", "setProduct$sdk_release", "setPublishableKey", "publishableKey", "setPublishableKey$sdk_release", "setRemoteTrackingOptions", "setRemoteTrackingOptions$sdk_release", "setSdkConfiguration", "configuration", "setSharing", "sharing", "setSharing$sdk_release", "setTracking", "tracking", "setTracking$sdk_release", "setTrackingOptions", "setTrackingOptions$sdk_release", "setTripOptions", "setTripOptions$sdk_release", "setUserDebug", "userDebug", "setUserDebug$sdk_release", "setUserId", "userId", "setUserId$sdk_release", "updateLastAppOpenTimeMillis", "updateLastAppOpenTimeMillis$sdk_release", "updateLastTrackedTime", "updateLastTrackedTime$sdk_release", "updateSessionId", "updateSessionId$sdk_release", "useLocationMetaData", "useLocationMetaData$sdk_release", "sdk_release"})
public final class RadarSettings {
    @NotNull
    public static final RadarSettings INSTANCE = new RadarSettings();
    @NotNull
    private static final String KEY_PUBLISHABLE_KEY = "publishable_key";
    @NotNull
    private static final String KEY_LOCATION_SERVICES_PROVIDER = "provider";
    @NotNull
    private static final String KEY_INSTALL_ID = "install_id";
    @NotNull
    private static final String KEY_SESSION_ID = "session_id";
    @NotNull
    private static final String KEY_ID = "radar_user_id";
    @NotNull
    private static final String KEY_USER_ID = "user_id";
    @NotNull
    private static final String KEY_DESCRIPTION = "user_description";
    @NotNull
    private static final String KEY_PRODUCT = "product";
    @NotNull
    private static final String KEY_METADATA = "user_metadata";
    @NotNull
    private static final String KEY_ANONYMOUS = "anonymous";
    @NotNull
    private static final String KEY_AD_ID_ENABLED = "ad_id_enabled";
    @NotNull
    private static final String KEY_TRACKING = "background_tracking";
    @NotNull
    private static final String KEY_TRACKING_OPTIONS = "tracking_options";
    @NotNull
    private static final String KEY_PREVIOUS_TRACKING_OPTIONS = "previous_tracking_options";
    @NotNull
    private static final String KEY_REMOTE_TRACKING_OPTIONS = "remote_tracking_options";
    @NotNull
    private static final String KEY_FOREGROUND_SERVICE = "foreground_service";
    @NotNull
    private static final String KEY_NOTIFICATION_OPTIONS = "notification_options";
    @NotNull
    private static final String KEY_CLIENT_SDK_CONFIGURATION = "client_sdk_configuration";
    @NotNull
    private static final String KEY_SDK_CONFIGURATION = "sdk_configuration";
    @NotNull
    private static final String KEY_TRIP_OPTIONS = "trip_options";
    @NotNull
    private static final String KEY_LOG_LEVEL = "log_level";
    @NotNull
    private static final String KEY_HOST = "host";
    @NotNull
    private static final String KEY_PERMISSIONS_DENIED = "permissions_denied";
    @NotNull
    private static final String KEY_LAST_TRACKED_TIME = "last_tracked_time";
    @NotNull
    private static final String KEY_VERIFIED_HOST = "verified_host";
    @NotNull
    private static final String KEY_LAST_APP_OPEN_TIME = "last_app_open_time";
    @NotNull
    private static final String KEY_SHARING = "sharing";
    @NotNull
    private static final String KEY_X_PLATFORM_SDK_TYPE = "x_platform_sdk_type";
    @NotNull
    private static final String KEY_X_PLATFORM_SDK_VERSION = "x_platform_sdk_version";
    @NotNull
    private static final String KEY_OLD_UPDATE_INTERVAL = "dwell_delay";
    private static final int KEY_OLD_UPDATE_INTERVAL_RESPONSIVE = 60000;
    @NotNull
    private static final String KEY_OLD_SYNC_MODE = "sync_mode";
    @NotNull
    private static final String KEY_OLD_OFFLINE_MODE = "offline_mode";
    @NotNull
    private static final String KEY_USER_DEBUG = "user_debug";

    private RadarSettings() {
    }

    private final SharedPreferences getSharedPreferences(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("RadarSDK", 0);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"context.getSharedPrefere\u2026K\", Context.MODE_PRIVATE)");
        return sharedPreferences;
    }

    @Nullable
    public final String getPublishableKey$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.getSharedPreferences(context).getString(KEY_PUBLISHABLE_KEY, null);
    }

    public final void setPublishableKey$sdk_release(@NotNull Context context, @Nullable String publishableKey) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$setPublishableKey_u24lambda_u2d0 = editor$iv;
        boolean bl = false;
        $this$setPublishableKey_u24lambda_u2d0.putString(KEY_PUBLISHABLE_KEY, publishableKey);
        editor$iv.apply();
    }

    @Nullable
    public final String getLocationServicesProvider$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.getSharedPreferences(context).getString(KEY_LOCATION_SERVICES_PROVIDER, null);
    }

    public final void setLocationServicesProvider$sdk_release(@NotNull Context context, @NotNull Radar.RadarLocationServicesProvider provider) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)provider), (String)KEY_LOCATION_SERVICES_PROVIDER);
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$setLocationServicesProvider_u24lambda_u2d1 = editor$iv;
        boolean bl = false;
        $this$setLocationServicesProvider_u24lambda_u2d1.putString(KEY_LOCATION_SERVICES_PROVIDER, provider.name());
        editor$iv.apply();
    }

    @NotNull
    public final String getInstallId$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String installId = null;
        installId = this.getSharedPreferences(context).getString(KEY_INSTALL_ID, null);
        if (installId == null) {
            installId = UUID.randomUUID().toString();
            SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
            boolean commit$iv = false;
            boolean $i$f$edit = false;
            SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
            Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
            SharedPreferences.Editor $this$getInstallId_u24lambda_u2d2 = editor$iv;
            boolean bl = false;
            $this$getInstallId_u24lambda_u2d2.putString(KEY_INSTALL_ID, installId);
            editor$iv.apply();
        }
        return installId;
    }

    @NotNull
    public final String getSessionId$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string = new DecimalFormat("#").format(this.getSharedPreferences(context).getLong(KEY_SESSION_ID, 0L));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DecimalFormat(\"#\").forma\u2026tLong(KEY_SESSION_ID, 0))");
        return string;
    }

    public final boolean updateSessionId$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        long timestampSeconds = System.currentTimeMillis() / (long)1000;
        long sessionIdSeconds = this.getSharedPreferences(context).getLong(KEY_SESSION_ID, 0L);
        RadarSdkConfiguration settings = this.getSdkConfiguration(context);
        if (settings.getExtendFlushReplays()) {
            RadarLogger.d$default(Radar.INSTANCE.getLogger$sdk_release(), "Flushing replays from updateSessionId()", null, null, 6, null);
            Radar.flushReplays$sdk_release$default(null, null, 3, null);
        }
        if (timestampSeconds - sessionIdSeconds > 300L) {
            SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
            boolean commit$iv = false;
            boolean $i$f$edit = false;
            SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
            Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
            SharedPreferences.Editor $this$updateSessionId_u24lambda_u2d3 = editor$iv;
            boolean bl = false;
            $this$updateSessionId_u24lambda_u2d3.putLong(KEY_SESSION_ID, timestampSeconds);
            editor$iv.apply();
            Radar.INSTANCE.logOpenedAppConversion$sdk_release();
            RadarLogger.d$default(Radar.INSTANCE.getLogger$sdk_release(), "New session | sessionId = " + this.getSessionId$sdk_release(context), null, null, 6, null);
            this.setSharing$sdk_release(context, false);
            return true;
        }
        return false;
    }

    @Nullable
    public final String getId$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.getSharedPreferences(context).getString(KEY_ID, null);
    }

    public final void setId$sdk_release(@NotNull Context context, @Nullable String _id) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$setId_u24lambda_u2d4 = editor$iv;
        boolean bl = false;
        $this$setId_u24lambda_u2d4.putString(KEY_ID, _id);
        editor$iv.apply();
    }

    @Nullable
    public final String getUserId$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.getSharedPreferences(context).getString(KEY_USER_ID, null);
    }

    public final void setUserId$sdk_release(@NotNull Context context, @Nullable String userId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$setUserId_u24lambda_u2d5 = editor$iv;
        boolean bl = false;
        $this$setUserId_u24lambda_u2d5.putString(KEY_USER_ID, userId);
        editor$iv.apply();
    }

    @Nullable
    public final String getDescription$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.getSharedPreferences(context).getString(KEY_DESCRIPTION, null);
    }

    public final void setDescription$sdk_release(@NotNull Context context, @Nullable String description) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$setDescription_u24lambda_u2d6 = editor$iv;
        boolean bl = false;
        $this$setDescription_u24lambda_u2d6.putString(KEY_DESCRIPTION, description);
        editor$iv.apply();
    }

    @Nullable
    public final String getProduct$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.getSharedPreferences(context).getString(KEY_PRODUCT, null);
    }

    public final void setProduct$sdk_release(@NotNull Context context, @Nullable String product) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$setProduct_u24lambda_u2d7 = editor$iv;
        boolean bl = false;
        $this$setProduct_u24lambda_u2d7.putString(KEY_PRODUCT, product);
        editor$iv.apply();
    }

    @Nullable
    public final JSONObject getMetadata$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string = this.getSharedPreferences(context).getString(KEY_METADATA, null);
        if (string == null) {
            return null;
        }
        String metadataJson = string;
        return new JSONObject(metadataJson);
    }

    public final void setMetadata$sdk_release(@NotNull Context context, @Nullable JSONObject metadata) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        JSONObject jSONObject = metadata;
        String metadataJSON = jSONObject != null ? jSONObject.toString() : null;
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$setMetadata_u24lambda_u2d8 = editor$iv;
        boolean bl = false;
        $this$setMetadata_u24lambda_u2d8.putString(KEY_METADATA, metadataJSON);
        editor$iv.apply();
    }

    public final boolean getAnonymousTrackingEnabled$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.getSharedPreferences(context).getBoolean(KEY_ANONYMOUS, false);
    }

    public final void setAnonymousTrackingEnabled$sdk_release(@NotNull Context context, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$setAnonymousTrackingEnabled_u24lambda_u2d9 = editor$iv;
        boolean bl = false;
        $this$setAnonymousTrackingEnabled_u24lambda_u2d9.putBoolean(KEY_ANONYMOUS, enabled);
        editor$iv.apply();
    }

    public final boolean getAdIdEnabled$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.getSharedPreferences(context).getBoolean(KEY_AD_ID_ENABLED, false);
    }

    public final void setAdIdEnabled$sdk_release(@NotNull Context context, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$setAdIdEnabled_u24lambda_u2d10 = editor$iv;
        boolean bl = false;
        $this$setAdIdEnabled_u24lambda_u2d10.putBoolean(KEY_AD_ID_ENABLED, enabled);
        editor$iv.apply();
    }

    public final boolean getTracking$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.getSharedPreferences(context).getBoolean(KEY_TRACKING, false);
    }

    public final void setTracking$sdk_release(@NotNull Context context, boolean tracking) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$setTracking_u24lambda_u2d11 = editor$iv;
        boolean bl = false;
        $this$setTracking_u24lambda_u2d11.putBoolean(KEY_TRACKING, tracking);
        editor$iv.apply();
    }

    @NotNull
    public final RadarTrackingOptions getTrackingOptions$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.getTrackingOptionsByKey(context, KEY_TRACKING_OPTIONS);
    }

    private final RadarTrackingOptions getTrackingOptionsByKey(Context context, String key) {
        String optionsJson = this.getSharedPreferences(context).getString(key, null);
        RadarTrackingOptions options = null;
        if (optionsJson != null) {
            JSONObject optionsObj = new JSONObject(optionsJson);
            options = RadarTrackingOptions.Companion.fromJson(optionsObj);
        } else {
            int oldInterval = this.getSharedPreferences(context).getInt(KEY_OLD_UPDATE_INTERVAL, 0);
            if (oldInterval > 0) {
                int oldOffline;
                options = oldInterval == 60000 ? RadarTrackingOptions.RESPONSIVE : RadarTrackingOptions.EFFICIENT;
                int oldSync = this.getSharedPreferences(context).getInt(KEY_OLD_SYNC_MODE, 0);
                if (oldSync == -1) {
                    options.setSync(RadarTrackingOptions.RadarTrackingOptionsSync.ALL);
                }
                if ((oldOffline = this.getSharedPreferences(context).getInt(KEY_OLD_OFFLINE_MODE, 0)) == -1) {
                    options.setReplay(RadarTrackingOptions.RadarTrackingOptionsReplay.NONE);
                }
            } else {
                options = RadarTrackingOptions.EFFICIENT;
            }
        }
        return options;
    }

    public final void setTrackingOptions$sdk_release(@NotNull Context context, @NotNull RadarTrackingOptions options) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        JSONObject optionsObj = options.toJson();
        String string = optionsObj.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"optionsObj.toString()");
        String optionsJson = string;
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$setTrackingOptions_u24lambda_u2d12 = editor$iv;
        boolean bl = false;
        $this$setTrackingOptions_u24lambda_u2d12.putString(KEY_TRACKING_OPTIONS, optionsJson);
        editor$iv.apply();
    }

    @Nullable
    public final RadarTrackingOptions getPreviousTrackingOptions$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        boolean keyExists = this.getSharedPreferences(context).contains(KEY_PREVIOUS_TRACKING_OPTIONS);
        return keyExists ? this.getTrackingOptionsByKey(context, KEY_PREVIOUS_TRACKING_OPTIONS) : null;
    }

    public final void setPreviousTrackingOptions$sdk_release(@NotNull Context context, @NotNull RadarTrackingOptions options) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        JSONObject optionsObj = options.toJson();
        String string = optionsObj.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"optionsObj.toString()");
        String optionsJson = string;
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$setPreviousTrackingOptions_u24lambda_u2d13 = editor$iv;
        boolean bl = false;
        $this$setPreviousTrackingOptions_u24lambda_u2d13.putString(KEY_PREVIOUS_TRACKING_OPTIONS, optionsJson);
        editor$iv.apply();
    }

    public final void removePreviousTrackingOptions$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$removePreviousTrackingOptions_u24lambda_u2d14 = editor$iv;
        boolean bl = false;
        $this$removePreviousTrackingOptions_u24lambda_u2d14.remove(KEY_PREVIOUS_TRACKING_OPTIONS);
        editor$iv.apply();
    }

    @Nullable
    public final RadarTrackingOptions getRemoteTrackingOptions$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        boolean keyExists = this.getSharedPreferences(context).contains(KEY_REMOTE_TRACKING_OPTIONS);
        return keyExists ? this.getTrackingOptionsByKey(context, KEY_REMOTE_TRACKING_OPTIONS) : null;
    }

    public final void setRemoteTrackingOptions$sdk_release(@NotNull Context context, @NotNull RadarTrackingOptions options) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        String string = options.toJson().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"options.toJson().toString()");
        String optionsJson = string;
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$setRemoteTrackingOptions_u24lambda_u2d15 = editor$iv;
        boolean bl = false;
        $this$setRemoteTrackingOptions_u24lambda_u2d15.putString(KEY_REMOTE_TRACKING_OPTIONS, optionsJson);
        editor$iv.apply();
    }

    public final void removeRemoteTrackingOptions$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$removeRemoteTrackingOptions_u24lambda_u2d16 = editor$iv;
        boolean bl = false;
        $this$removeRemoteTrackingOptions_u24lambda_u2d16.remove(KEY_REMOTE_TRACKING_OPTIONS);
        editor$iv.apply();
    }

    public final void setNotificationOptions$sdk_release(@NotNull Context context, @NotNull RadarNotificationOptions notificationOptions) {
        String string;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)notificationOptions, (String)"notificationOptions");
        String string2 = notificationOptions.toJson().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"notificationOptions.toJson().toString()");
        String notificationOptionsJson = string2;
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$setNotificationOptions_u24lambda_u2d17 = editor$iv;
        boolean bl = false;
        $this$setNotificationOptions_u24lambda_u2d17.putString(KEY_NOTIFICATION_OPTIONS, notificationOptionsJson);
        editor$iv.apply();
        RadarTrackingOptions.RadarTrackingOptionsForegroundService previousValue = this.getForegroundService$sdk_release(context);
        String string3 = previousValue.getText();
        String string4 = previousValue.getTitle();
        Integer n = previousValue.getIcon();
        boolean bl2 = previousValue.getUpdatesOnly();
        String string5 = previousValue.getActivity();
        Integer n2 = previousValue.getImportance();
        Integer n3 = previousValue.getId();
        String string6 = previousValue.getChannelName();
        String string7 = notificationOptions.getForegroundServiceIcon();
        if (string7 == null) {
            string7 = previousValue.getIconString();
        }
        if ((string = notificationOptions.getForegroundServiceColor()) == null) {
            string = previousValue.getIconColor();
        }
        this.setForegroundService$sdk_release(context, new RadarTrackingOptions.RadarTrackingOptionsForegroundService(string3, string4, n, bl2, string5, n2, n3, string6, string7, string, notificationOptions.getDeepLink()));
    }

    @Nullable
    public final RadarNotificationOptions getNotificationOptions$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string = this.getSharedPreferences(context).getString(KEY_NOTIFICATION_OPTIONS, null);
        if (string == null) {
            return null;
        }
        String optionsJson = string;
        JSONObject optionsObj = new JSONObject(optionsJson);
        return RadarNotificationOptions.Companion.fromJson(optionsObj);
    }

    @NotNull
    public final RadarTrackingOptions.RadarTrackingOptionsForegroundService getForegroundService$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String foregroundJson = this.getSharedPreferences(context).getString(KEY_FOREGROUND_SERVICE, null);
        RadarTrackingOptions.RadarTrackingOptionsForegroundService foregroundService = null;
        if (foregroundJson != null) {
            JSONObject foregroundObj = new JSONObject(foregroundJson);
            foregroundService = RadarTrackingOptions.RadarTrackingOptionsForegroundService.Companion.fromJson(foregroundObj);
        }
        if (foregroundService == null) {
            foregroundService = new RadarTrackingOptions.RadarTrackingOptionsForegroundService(null, null, null, false, null, null, null, null, null, null, null, 2047, null);
        }
        return foregroundService;
    }

    public final void setForegroundService$sdk_release(@NotNull Context context, @NotNull RadarTrackingOptions.RadarTrackingOptionsForegroundService foregroundService) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)foregroundService, (String)"foregroundService");
        RadarTrackingOptions.RadarTrackingOptionsForegroundService previousValue = this.getForegroundService$sdk_release(context);
        if (foregroundService.getIconString() == null) {
            foregroundService.setIconString(previousValue.getIconString());
        }
        if (foregroundService.getIconColor() == null) {
            foregroundService.setIconColor(previousValue.getIconColor());
        }
        String string = foregroundService.toJson().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"foregroundService.toJson().toString()");
        String foregroundJson = string;
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$setForegroundService_u24lambda_u2d18 = editor$iv;
        boolean bl = false;
        $this$setForegroundService_u24lambda_u2d18.putString(KEY_FOREGROUND_SERVICE, foregroundJson);
        editor$iv.apply();
    }

    @Nullable
    public final RadarTripOptions getTripOptions$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string = this.getSharedPreferences(context).getString(KEY_TRIP_OPTIONS, null);
        if (string == null) {
            return null;
        }
        String optionsJson = string;
        JSONObject optionsObj = new JSONObject(optionsJson);
        return RadarTripOptions.Companion.fromJson(optionsObj);
    }

    public final void setTripOptions$sdk_release(@NotNull Context context, @Nullable RadarTripOptions options) {
        JSONObject optionsObj;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        RadarTripOptions radarTripOptions = options;
        JSONObject jSONObject = optionsObj = radarTripOptions != null ? radarTripOptions.toJson() : null;
        String optionsJson = jSONObject != null ? jSONObject.toString() : null;
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$setTripOptions_u24lambda_u2d19 = editor$iv;
        boolean bl = false;
        $this$setTripOptions_u24lambda_u2d19.putString(KEY_TRIP_OPTIONS, optionsJson);
        editor$iv.apply();
    }

    public final void setSdkConfiguration(@NotNull Context context, @Nullable RadarSdkConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        RadarLogger.d$default(Radar.INSTANCE.getLogger$sdk_release(), "Setting SDK configuration | sdkConfiguration = " + configuration, null, null, 6, null);
        if (configuration != null) {
            Radar.INSTANCE.setLogPersistenceFeatureFlag$sdk_release(configuration.getUseLogPersistence());
            this.setLogLevel$sdk_release(context, configuration.getLogLevel());
            String string = configuration.toJson().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"configuration.toJson().toString()");
            String sdkConfigurationString = string;
            SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
            boolean commit$iv = false;
            boolean $i$f$edit = false;
            SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
            Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
            SharedPreferences.Editor $this$setSdkConfiguration_u24lambda_u2d20 = editor$iv;
            boolean bl = false;
            $this$setSdkConfiguration_u24lambda_u2d20.putString(KEY_SDK_CONFIGURATION, sdkConfigurationString);
            editor$iv.apply();
        } else {
            SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
            boolean commit$iv = false;
            boolean $i$f$edit = false;
            SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
            Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
            SharedPreferences.Editor $this$setSdkConfiguration_u24lambda_u2d21 = editor$iv;
            boolean bl = false;
            $this$setSdkConfiguration_u24lambda_u2d21.remove(KEY_SDK_CONFIGURATION);
            editor$iv.apply();
        }
    }

    @NotNull
    public final RadarSdkConfiguration getSdkConfiguration(@NotNull Context context) {
        JSONObject jSONObject;
        String sdkConfigurationString;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string = sdkConfigurationString = this.getSharedPreferences(context).getString(KEY_SDK_CONFIGURATION, null);
        if (string != null) {
            String it = string;
            boolean bl = false;
            jSONObject = new JSONObject(it);
        } else {
            jSONObject = null;
        }
        JSONObject sdkConfigurationJSON = jSONObject;
        return RadarSdkConfiguration.Companion.fromJson(sdkConfigurationJSON);
    }

    @NotNull
    public final JSONObject getClientSdkConfiguration(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String sharedPrefClientSdkConfig = this.getSharedPreferences(context).getString(KEY_CLIENT_SDK_CONFIGURATION, null);
        return sharedPrefClientSdkConfig != null ? new JSONObject(sharedPrefClientSdkConfig) : new JSONObject();
    }

    public final void setClientSdkConfiguration(@NotNull Context context, @Nullable JSONObject sdkConfiguration) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        JSONObject jSONObject = sdkConfiguration;
        String sdkConfigurationString = jSONObject != null ? jSONObject.toString() : null;
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$setClientSdkConfiguration_u24lambda_u2d23 = editor$iv;
        boolean bl = false;
        $this$setClientSdkConfiguration_u24lambda_u2d23.putString(KEY_CLIENT_SDK_CONFIGURATION, sdkConfigurationString);
        editor$iv.apply();
    }

    @NotNull
    public final Radar.RadarLogLevel getLogLevel$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int defaultLogLevelInt = this.getUserDebug$sdk_release(context) ? Radar.RadarLogLevel.DEBUG.getValue() : Radar.RadarLogLevel.NONE.getValue();
        int logLevelInt = this.getSharedPreferences(context).getInt(KEY_LOG_LEVEL, defaultLogLevelInt);
        return Radar.RadarLogLevel.Companion.fromInt(logLevelInt);
    }

    public final void setLogLevel$sdk_release(@NotNull Context context, @NotNull Radar.RadarLogLevel level) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$setLogLevel_u24lambda_u2d24 = editor$iv;
        boolean bl = false;
        $this$setLogLevel_u24lambda_u2d24.putInt(KEY_LOG_LEVEL, level.getValue());
        editor$iv.apply();
    }

    @NotNull
    public final String getHost$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string = this.getSharedPreferences(context).getString(KEY_HOST, null);
        if (string == null) {
            string = "https://api.radar.io";
        }
        return string;
    }

    public final void setPermissionsDenied$sdk_release(@NotNull Context context, boolean denied) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$setPermissionsDenied_u24lambda_u2d25 = editor$iv;
        boolean bl = false;
        $this$setPermissionsDenied_u24lambda_u2d25.putBoolean(KEY_PERMISSIONS_DENIED, denied);
        editor$iv.apply();
    }

    public final boolean getPermissionsDenied$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.getSharedPreferences(context).getBoolean(KEY_PERMISSIONS_DENIED, false);
    }

    public final void updateLastTrackedTime$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        long timestampSeconds = System.currentTimeMillis() / (long)1000;
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$updateLastTrackedTime_u24lambda_u2d26 = editor$iv;
        boolean bl = false;
        $this$updateLastTrackedTime_u24lambda_u2d26.putLong(KEY_LAST_TRACKED_TIME, timestampSeconds);
        editor$iv.apply();
    }

    public final long getLastTrackedTime$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.getSharedPreferences(context).getLong(KEY_LAST_TRACKED_TIME, 0L);
    }

    @NotNull
    public final String getVerifiedHost$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string = this.getSharedPreferences(context).getString(KEY_VERIFIED_HOST, null);
        if (string == null) {
            string = "https://api-verified.radar.io";
        }
        return string;
    }

    public final boolean getUserDebug$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.getSharedPreferences(context).getBoolean(KEY_USER_DEBUG, false);
    }

    public final void setUserDebug$sdk_release(@NotNull Context context, boolean userDebug) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$setUserDebug_u24lambda_u2d27 = editor$iv;
        boolean bl = false;
        $this$setUserDebug_u24lambda_u2d27.putBoolean(KEY_USER_DEBUG, userDebug);
        editor$iv.apply();
    }

    public final long getLastAppOpenTimeMillis$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.getSharedPreferences(context).getLong(KEY_LAST_APP_OPEN_TIME, 0L);
    }

    public final void updateLastAppOpenTimeMillis$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        long timestampSeconds = System.currentTimeMillis();
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$updateLastAppOpenTimeMillis_u24lambda_u2d28 = editor$iv;
        boolean bl = false;
        $this$updateLastAppOpenTimeMillis_u24lambda_u2d28.putLong(KEY_LAST_APP_OPEN_TIME, timestampSeconds);
        editor$iv.apply();
    }

    public final boolean getSharing$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.getSharedPreferences(context).getBoolean(KEY_SHARING, false);
    }

    public final void setSharing$sdk_release(@NotNull Context context, boolean sharing) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$setSharing_u24lambda_u2d29 = editor$iv;
        boolean bl = false;
        $this$setSharing_u24lambda_u2d29.putBoolean(KEY_SHARING, sharing);
        editor$iv.apply();
    }

    public final boolean isXPlatform$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.getSharedPreferences(context).contains(KEY_X_PLATFORM_SDK_TYPE) && this.getSharedPreferences(context).contains(KEY_X_PLATFORM_SDK_VERSION);
    }

    @Nullable
    public final String getXPlatformSDKType$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.getSharedPreferences(context).getString(KEY_X_PLATFORM_SDK_TYPE, null);
    }

    @Nullable
    public final String getXPlatformSDKVersion$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.getSharedPreferences(context).getString(KEY_X_PLATFORM_SDK_VERSION, null);
    }

    public final boolean useLocationMetaData$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.getSdkConfiguration(context).getUseLocationMetadata();
    }
}

