/*
 * Decompiled with CFR 0.152.
 */
package io.radar.sdk.util;

import android.content.Context;
import io.radar.sdk.Radar;
import io.radar.sdk.RadarSettings;
import io.radar.sdk.model.RadarLog;
import io.radar.sdk.util.Flushable;
import io.radar.sdk.util.RadarFileStorage;
import io.radar.sdk.util.RadarLogBuffer;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\b\u0000\u0018\u0000 *2\u00020\u0001:\u0001*B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012H\u0016J\u0015\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0014H\u0002\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001bH\u0002J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0010\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\f\u001a\u00020\rH\u0016J*\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020\u00192\u0006\u0010%\u001a\u00020&H\u0016J\u0016\u0010'\u001a\u00020\u001b2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000b0)H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lio/radar/sdk/util/RadarSimpleLogBuffer;", "Lio/radar/sdk/util/RadarLogBuffer;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "getContext", "()Landroid/content/Context;", "lock", "", "logBuffer", "Ljava/util/concurrent/LinkedBlockingDeque;", "Lio/radar/sdk/model/RadarLog;", "persistentLogFeatureFlag", "", "timer", "Ljava/util/concurrent/ScheduledExecutorService;", "kotlin.jvm.PlatformType", "getFlushableLogs", "Lio/radar/sdk/util/Flushable;", "getLogFilesInTimeOrder", "", "Ljava/io/File;", "()[Ljava/io/File;", "isValidJson", "json", "", "persistLogs", "", "purgeOldestLogs", "readFromFileStorage", "setPersistentLogFeatureFlag", "write", "level", "Lio/radar/sdk/Radar$RadarLogLevel;", "type", "Lio/radar/sdk/Radar$RadarLogType;", "message", "createdAt", "Ljava/util/Date;", "writeToFileStorage", "logs", "", "Companion", "sdk_release"})
public final class RadarSimpleLogBuffer
implements RadarLogBuffer {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    private boolean persistentLogFeatureFlag;
    @NotNull
    private final Object lock;
    private final ScheduledExecutorService timer;
    @NotNull
    private final LinkedBlockingDeque<RadarLog> logBuffer;
    @Deprecated
    public static final int MAX_MEMORY_BUFFER_SIZE = 200;
    @Deprecated
    public static final int MAX_PERSISTED_BUFFER_SIZE = 500;
    @Deprecated
    public static final int PURGE_AMOUNT = 250;
    @Deprecated
    @NotNull
    public static final String logFileDir = "radar_logs";
    @Deprecated
    private static int fileCounter;
    @Deprecated
    @NotNull
    public static final String KEY_PURGED_LOG_LINE = "----- purged oldest logs -----";

    public RadarSimpleLogBuffer(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.lock = new Object();
        this.timer = Executors.newScheduledThreadPool(1);
        this.logBuffer = new LinkedBlockingDeque();
        this.persistentLogFeatureFlag = RadarSettings.INSTANCE.getSdkConfiguration(this.getContext()).getUseLogPersistence();
        File file = new File(this.getContext().getFilesDir(), logFileDir);
        if (!file.exists()) {
            file.mkdir();
        }
        this.timer.scheduleAtFixedRate(() -> RadarSimpleLogBuffer._init_$lambda-0(this), 2L, 2L, TimeUnit.SECONDS);
    }

    @Override
    @NotNull
    public Context getContext() {
        return this.context;
    }

    @Override
    public void setPersistentLogFeatureFlag(boolean persistentLogFeatureFlag) {
        this.persistentLogFeatureFlag = persistentLogFeatureFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(@NotNull Radar.RadarLogLevel level, @Nullable Radar.RadarLogType type, @NotNull String message, @NotNull Date createdAt) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)createdAt, (String)"createdAt");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            RadarLog radarLog = new RadarLog(level, message, type, createdAt);
            this.logBuffer.put(radarLog);
            if (this.persistentLogFeatureFlag) {
                if (this.logBuffer.size() > 200) {
                    this.persistLogs();
                }
            } else if (this.logBuffer.size() > 500) {
                this.purgeOldestLogs();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void persistLogs() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (this.persistentLogFeatureFlag && this.logBuffer.size() > 0) {
                this.writeToFileStorage((Collection<RadarLog>)this.logBuffer);
                this.logBuffer.clear();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final File[] getLogFilesInTimeOrder() {
        Comparator compareTimeStamps = RadarSimpleLogBuffer::getLogFilesInTimeOrder$lambda-3;
        return new RadarFileStorage(this.getContext()).sortedFilesInDirectory(logFileDir, compareTimeStamps);
    }

    private final boolean isValidJson(String json) {
        boolean bl;
        try {
            new JSONObject(json);
            bl = true;
        }
        catch (JSONException ex) {
            bl = false;
        }
        return bl;
    }

    private final LinkedBlockingDeque<RadarLog> readFromFileStorage() {
        Object[] files = this.getLogFilesInTimeOrder();
        LinkedBlockingDeque<RadarLog> logs = new LinkedBlockingDeque<RadarLog>();
        Object object = files;
        if (object == null || ((File[])object).length == 0) {
            return logs;
        }
        object = ArrayIteratorKt.iterator((Object[])files);
        while (object.hasNext()) {
            File file = (File)object.next();
            RadarFileStorage radarFileStorage = new RadarFileStorage(this.getContext());
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
            String jsonString = radarFileStorage.readFileAtPath(logFileDir, string);
            CharSequence charSequence = jsonString;
            if (charSequence == null || charSequence.length() == 0 || !this.isValidJson(jsonString)) {
                file.delete();
                continue;
            }
            RadarLog log2 = RadarLog.Companion.fromJson(new JSONObject(jsonString));
            if (log2 == null) continue;
            logs.add(log2);
        }
        return logs;
    }

    private final void writeToFileStorage(Collection<RadarLog> logs) {
        for (RadarLog log2 : logs) {
            String counterString;
            String string = "%04d";
            Object[] objectArray = new Object[1];
            int n = fileCounter;
            fileCounter = n + 1;
            objectArray[0] = n;
            Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray, objectArray.length)), (String)"format(format, *args)");
            String fileName = "" + log2.getCreatedAt().getTime() / (long)1000 + '_' + counterString;
            RadarFileStorage radarFileStorage = new RadarFileStorage(this.getContext());
            String string2 = log2.toJson().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"log.toJson().toString()");
            radarFileStorage.writeData(logFileDir, fileName, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Flushable<RadarLog> getFlushableLogs() {
        List logs = new ArrayList();
        Object object = this.lock;
        synchronized (object) {
            Integer n;
            boolean bl = false;
            if (this.persistentLogFeatureFlag) {
                this.persistLogs();
                this.purgeOldestLogs();
                this.readFromFileStorage().drainTo(logs);
                File[] files = this.getLogFilesInTimeOrder();
                int n2 = Integer.min(logs.size(), files != null ? files.length : 0);
                for (int i = 0; i < n2; ++i) {
                    Object object2 = files;
                    if (files == null || (object2 = object2[i]) == null) continue;
                    ((File)object2).delete();
                }
                n = Unit.INSTANCE;
            } else {
                n = this.logBuffer.drainTo(logs);
            }
            Integer n3 = n;
        }
        return new Flushable<RadarLog>((List<RadarLog>)logs, this){
            final /* synthetic */ List<RadarLog> $logs;
            final /* synthetic */ RadarSimpleLogBuffer this$0;
            {
                this.$logs = $logs;
                this.this$0 = $receiver;
            }

            @NotNull
            public List<RadarLog> get() {
                return this.$logs;
            }

            /*
             * WARNING - void declaration
             */
            public void onFlush(boolean success) {
                if (!success) {
                    if (RadarSimpleLogBuffer.access$getPersistentLogFeatureFlag$p(this.this$0)) {
                        RadarSimpleLogBuffer.access$writeToFileStorage(this.this$0, this.$logs);
                        RadarSimpleLogBuffer.access$purgeOldestLogs(this.this$0);
                    } else {
                        void $this$forEach$iv;
                        CollectionsKt.reverse(this.$logs);
                        Iterable iterable = this.$logs;
                        RadarSimpleLogBuffer radarSimpleLogBuffer = this.this$0;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            RadarLog it = (RadarLog)element$iv;
                            boolean bl = false;
                            if (RadarSimpleLogBuffer.access$getLogBuffer$p(radarSimpleLogBuffer).offerFirst(it)) continue;
                            RadarSimpleLogBuffer.access$purgeOldestLogs(radarSimpleLogBuffer);
                        }
                    }
                }
            }
        };
    }

    private final void purgeOldestLogs() {
        if (this.persistentLogFeatureFlag) {
            File[] files = this.getLogFilesInTimeOrder();
            File[] fileArray = files;
            if (fileArray == null || fileArray.length == 0) {
                return;
            }
            boolean printedPurgedLogs = false;
            while ((files != null ? files.length : 0) > 500) {
                int numberToPurge = Integer.min(250, files != null ? files.length : 0);
                for (int i = 0; i < numberToPurge; ++i) {
                    Object object = files;
                    if (files == null || (object = object[i]) == null) continue;
                    ((File)object).delete();
                }
                if (!printedPurgedLogs) {
                    this.writeToFileStorage(CollectionsKt.listOf((Object)new RadarLog(Radar.RadarLogLevel.DEBUG, KEY_PURGED_LOG_LINE, null, null, 8, null)));
                    printedPurgedLogs = true;
                }
                files = this.getLogFilesInTimeOrder();
            }
        } else {
            List oldLogs = new ArrayList();
            this.logBuffer.drainTo(oldLogs, 250);
            RadarLogBuffer.DefaultImpls.write$default(this, Radar.RadarLogLevel.DEBUG, null, KEY_PURGED_LOG_LINE, null, 8, null);
        }
    }

    private static final void _init_$lambda-0(RadarSimpleLogBuffer this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.persistLogs();
    }

    private static final int getLogFilesInTimeOrder$lambda-3(File file1, File file2) {
        String string = file1.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file1.name");
        Long l = StringsKt.toLongOrNull((String)StringsKt.replace$default((String)string, (String)"_", (String)"", (boolean)false, (int)4, null));
        long number1 = l != null ? l : 0L;
        String string2 = file2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file2.name");
        Long l2 = StringsKt.toLongOrNull((String)StringsKt.replace$default((String)string2, (String)"_", (String)"", (boolean)false, (int)4, null));
        long number2 = l2 != null ? l2 : 0L;
        return Intrinsics.compare((long)number1, (long)number2);
    }

    public static final /* synthetic */ boolean access$getPersistentLogFeatureFlag$p(RadarSimpleLogBuffer $this) {
        return $this.persistentLogFeatureFlag;
    }

    public static final /* synthetic */ void access$writeToFileStorage(RadarSimpleLogBuffer $this, Collection logs) {
        $this.writeToFileStorage(logs);
    }

    public static final /* synthetic */ void access$purgeOldestLogs(RadarSimpleLogBuffer $this) {
        $this.purgeOldestLogs();
    }

    public static final /* synthetic */ LinkedBlockingDeque access$getLogBuffer$p(RadarSimpleLogBuffer $this) {
        return $this.logBuffer;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/radar/sdk/util/RadarSimpleLogBuffer$Companion;", "", "()V", "KEY_PURGED_LOG_LINE", "", "MAX_MEMORY_BUFFER_SIZE", "", "MAX_PERSISTED_BUFFER_SIZE", "PURGE_AMOUNT", "fileCounter", "getFileCounter", "()I", "setFileCounter", "(I)V", "logFileDir", "sdk_release"})
    private static final class Companion {
        private Companion() {
        }

        public final int getFileCounter() {
            return fileCounter;
        }

        public final void setFileCounter(int n) {
            fileCounter = n;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

