/*
 * Decompiled with CFR 0.152.
 */
package io.radar.sdk.util;

import io.radar.sdk.RadarBatteryManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0080\b\u0018\u00002\u00020\u0001:\u0001&B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0016J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003JL\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u001fJ\u0013\u0010 \u001a\u00020\u00032\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0006\u0010\"\u001a\u00020#J\t\u0010$\u001a\u00020\tH\u00d6\u0001J\t\u0010%\u001a\u00020#H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\fR\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\fR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u0017\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006'"}, d2={"Lio/radar/sdk/util/BatteryState;", "", "isCharging", "", "percent", "", "powerSaveMode", "isIgnoringBatteryOptimizations", "locationPowerSaveMode", "", "isDeviceIdleMode", "(ZFLjava/lang/Boolean;ZIZ)V", "()Z", "getLocationPowerSaveMode", "()I", "getPercent", "()F", "performanceState", "Lio/radar/sdk/util/BatteryState$PerformanceState;", "getPerformanceState", "()Lio/radar/sdk/util/BatteryState$PerformanceState;", "getPowerSaveMode", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "(ZFLjava/lang/Boolean;ZIZ)Lio/radar/sdk/util/BatteryState;", "equals", "other", "getPowerLocationPowerSaveModeString", "", "hashCode", "toString", "PerformanceState", "sdk_release"})
public final class BatteryState {
    private final boolean isCharging;
    private final float percent;
    @Nullable
    private final Boolean powerSaveMode;
    private final boolean isIgnoringBatteryOptimizations;
    private final int locationPowerSaveMode;
    private final boolean isDeviceIdleMode;
    @NotNull
    private final PerformanceState performanceState;

    public BatteryState(boolean isCharging, float percent, @Nullable Boolean powerSaveMode, boolean isIgnoringBatteryOptimizations, int locationPowerSaveMode, boolean isDeviceIdleMode) {
        this.isCharging = isCharging;
        this.percent = percent;
        this.powerSaveMode = powerSaveMode;
        this.isIgnoringBatteryOptimizations = isIgnoringBatteryOptimizations;
        this.locationPowerSaveMode = locationPowerSaveMode;
        this.isDeviceIdleMode = isDeviceIdleMode;
        if (this.powerSaveMode != null) {
            boolean isAffectedByPowerSaver = this.powerSaveMode != false && !this.isIgnoringBatteryOptimizations;
            boolean isLocationAffectedByPowerSaver = this.locationPowerSaveMode != RadarBatteryManager.Companion.getLocationUnaffected();
            this.performanceState = this.isDeviceIdleMode ? (isAffectedByPowerSaver ? (isLocationAffectedByPowerSaver ? PerformanceState.LOWEST : PerformanceState.LOW) : PerformanceState.IDLE) : (isAffectedByPowerSaver ? (isLocationAffectedByPowerSaver ? PerformanceState.LOCATIONS_LOW_PERFORMANCE : PerformanceState.OPTIMIZED) : PerformanceState.OK);
        } else {
            this.performanceState = PerformanceState.OK;
        }
    }

    public final boolean isCharging() {
        return this.isCharging;
    }

    public final float getPercent() {
        return this.percent;
    }

    @Nullable
    public final Boolean getPowerSaveMode() {
        return this.powerSaveMode;
    }

    public final boolean isIgnoringBatteryOptimizations() {
        return this.isIgnoringBatteryOptimizations;
    }

    public final int getLocationPowerSaveMode() {
        return this.locationPowerSaveMode;
    }

    public final boolean isDeviceIdleMode() {
        return this.isDeviceIdleMode;
    }

    @NotNull
    public final PerformanceState getPerformanceState() {
        return this.performanceState;
    }

    @NotNull
    public final String getPowerLocationPowerSaveModeString() {
        String string;
        switch (this.locationPowerSaveMode) {
            case 0: {
                string = "LOCATION_MODE_NO_CHANGE";
                break;
            }
            case 1: {
                string = "LOCATION_MODE_GPS_DISABLED_WHEN_SCREEN_OFF";
                break;
            }
            case 2: {
                string = "LOCATION_MODE_ALL_DISABLED_WHEN_SCREEN_OFF";
                break;
            }
            case 3: {
                string = "LOCATION_MODE_FOREGROUND_ONLY";
                break;
            }
            case 4: {
                string = "LOCATION_MODE_THROTTLE_REQUESTS_WHEN_SCREEN_OFF";
                break;
            }
            default: {
                string = String.valueOf(this.locationPowerSaveMode);
            }
        }
        return string;
    }

    public final boolean component1() {
        return this.isCharging;
    }

    public final float component2() {
        return this.percent;
    }

    @Nullable
    public final Boolean component3() {
        return this.powerSaveMode;
    }

    public final boolean component4() {
        return this.isIgnoringBatteryOptimizations;
    }

    public final int component5() {
        return this.locationPowerSaveMode;
    }

    public final boolean component6() {
        return this.isDeviceIdleMode;
    }

    @NotNull
    public final BatteryState copy(boolean isCharging, float percent, @Nullable Boolean powerSaveMode, boolean isIgnoringBatteryOptimizations, int locationPowerSaveMode, boolean isDeviceIdleMode) {
        return new BatteryState(isCharging, percent, powerSaveMode, isIgnoringBatteryOptimizations, locationPowerSaveMode, isDeviceIdleMode);
    }

    public static /* synthetic */ BatteryState copy$default(BatteryState batteryState, boolean bl, float f, Boolean bl2, boolean bl3, int n, boolean bl4, int n2, Object object) {
        if ((n2 & 1) != 0) {
            bl = batteryState.isCharging;
        }
        if ((n2 & 2) != 0) {
            f = batteryState.percent;
        }
        if ((n2 & 4) != 0) {
            bl2 = batteryState.powerSaveMode;
        }
        if ((n2 & 8) != 0) {
            bl3 = batteryState.isIgnoringBatteryOptimizations;
        }
        if ((n2 & 0x10) != 0) {
            n = batteryState.locationPowerSaveMode;
        }
        if ((n2 & 0x20) != 0) {
            bl4 = batteryState.isDeviceIdleMode;
        }
        return batteryState.copy(bl, f, bl2, bl3, n, bl4);
    }

    @NotNull
    public String toString() {
        return "BatteryState(isCharging=" + this.isCharging + ", percent=" + this.percent + ", powerSaveMode=" + this.powerSaveMode + ", isIgnoringBatteryOptimizations=" + this.isIgnoringBatteryOptimizations + ", locationPowerSaveMode=" + this.locationPowerSaveMode + ", isDeviceIdleMode=" + this.isDeviceIdleMode + ')';
    }

    public int hashCode() {
        int n = this.isCharging ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        int result = n;
        result = result * 31 + Float.hashCode(this.percent);
        result = result * 31 + (this.powerSaveMode == null ? 0 : ((Object)this.powerSaveMode).hashCode());
        int n2 = this.isIgnoringBatteryOptimizations ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        result = result * 31 + n2;
        result = result * 31 + Integer.hashCode(this.locationPowerSaveMode);
        int n3 = this.isDeviceIdleMode ? 1 : 0;
        if (n3 != 0) {
            n3 = 1;
        }
        result = result * 31 + n3;
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BatteryState)) {
            return false;
        }
        BatteryState batteryState = (BatteryState)other;
        if (this.isCharging != batteryState.isCharging) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.percent), (Object)Float.valueOf(batteryState.percent))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.powerSaveMode, (Object)batteryState.powerSaveMode)) {
            return false;
        }
        if (this.isIgnoringBatteryOptimizations != batteryState.isIgnoringBatteryOptimizations) {
            return false;
        }
        if (this.locationPowerSaveMode != batteryState.locationPowerSaveMode) {
            return false;
        }
        return this.isDeviceIdleMode == batteryState.isDeviceIdleMode;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lio/radar/sdk/util/BatteryState$PerformanceState;", "", "(Ljava/lang/String;I)V", "OK", "OPTIMIZED", "LOCATIONS_LOW_PERFORMANCE", "IDLE", "LOW", "LOWEST", "sdk_release"})
    public static final class PerformanceState
    extends Enum<PerformanceState> {
        public static final /* enum */ PerformanceState OK = new PerformanceState();
        public static final /* enum */ PerformanceState OPTIMIZED = new PerformanceState();
        public static final /* enum */ PerformanceState LOCATIONS_LOW_PERFORMANCE = new PerformanceState();
        public static final /* enum */ PerformanceState IDLE = new PerformanceState();
        public static final /* enum */ PerformanceState LOW = new PerformanceState();
        public static final /* enum */ PerformanceState LOWEST = new PerformanceState();
        private static final /* synthetic */ PerformanceState[] $VALUES;

        public static PerformanceState[] values() {
            return (PerformanceState[])$VALUES.clone();
        }

        public static PerformanceState valueOf(String value) {
            return Enum.valueOf(PerformanceState.class, value);
        }

        static {
            $VALUES = performanceStateArray = new PerformanceState[]{PerformanceState.OK, PerformanceState.OPTIMIZED, PerformanceState.LOCATIONS_LOW_PERFORMANCE, PerformanceState.IDLE, PerformanceState.LOW, PerformanceState.LOWEST};
        }
    }
}

