/*
 * Decompiled with CFR 0.152.
 */
package io.radar.sdk;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import io.radar.sdk.Radar;
import io.radar.sdk.RadarLogger;
import io.radar.sdk.RadarSettings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.ssl.HttpsURLConnection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0010\u0018\u00002\u00020\u0001:\u0002$%B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0081\u0001\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u00162\b\b\u0002\u0010\u001a\u001a\u00020\u00162\b\b\u0002\u0010\u001b\u001a\u00020\u00162\b\b\u0002\u0010\u001c\u001a\u00020\u0016H\u0010\u00a2\u0006\u0002\b\u001dJG\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u000f2\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u00122\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010 H\u0010\u00a2\u0006\u0002\b!J\u000e\u0010\"\u001a\u0004\u0018\u00010\u000f*\u00020#H\u0002R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lio/radar/sdk/RadarApiHelper;", "", "logger", "Lio/radar/sdk/RadarLogger;", "(Lio/radar/sdk/RadarLogger;)V", "executor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "handler", "Landroid/os/Handler;", "request", "", "context", "Landroid/content/Context;", "method", "", "path", "headers", "", "params", "Lorg/json/JSONObject;", "sleep", "", "callback", "Lio/radar/sdk/RadarApiHelper$RadarApiCallback;", "extendedTimeout", "stream", "logPayload", "verified", "request$sdk_release", "requestImage", "urlString", "Lio/radar/sdk/RadarApiHelper$RadarImageApiCallback;", "requestImage$sdk_release", "readAll", "Ljava/io/InputStream;", "RadarApiCallback", "RadarImageApiCallback", "sdk_release"})
public class RadarApiHelper {
    @Nullable
    private RadarLogger logger;
    private final ExecutorService executor;
    @NotNull
    private final Handler handler;

    public RadarApiHelper(@Nullable RadarLogger logger) {
        this.logger = logger;
        this.executor = Executors.newSingleThreadExecutor();
        this.handler = new Handler(Looper.getMainLooper());
    }

    public /* synthetic */ RadarApiHelper(RadarLogger radarLogger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            radarLogger = null;
        }
        this(radarLogger);
    }

    public void request$sdk_release(@NotNull Context context, @NotNull String method, @NotNull String path, @Nullable Map<String, String> headers, @Nullable JSONObject params, boolean sleep, @Nullable RadarApiCallback callback, boolean extendedTimeout, boolean stream, boolean logPayload, boolean verified) {
        String host;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String $this$toUri$iv = host = verified ? RadarSettings.INSTANCE.getVerifiedHost$sdk_release(context) : RadarSettings.INSTANCE.getHost$sdk_release(context);
        boolean $i$f$toUri = false;
        Uri uri = Uri.parse((String)$this$toUri$iv);
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"parse(this)");
        Uri uri2 = uri.buildUpon().appendEncodedPath(path).build();
        URL url = new URL(uri2.toString());
        if (logPayload) {
            RadarLogger radarLogger = this.logger;
            if (radarLogger != null) {
                RadarLogger.d$default(radarLogger, "\ud83d\udccd Radar API request | method = " + method + "; url = " + url + "; headers = " + headers + "; params = " + params, null, null, 6, null);
            }
        } else {
            RadarLogger radarLogger = this.logger;
            if (radarLogger != null) {
                RadarLogger.d$default(radarLogger, "\ud83d\udccd Radar API request | method = " + method + "; url = " + url + "; headers = " + headers, null, null, 6, null);
            }
        }
        this.executor.execute(() -> RadarApiHelper.request$lambda-7(url, headers, this, method, extendedTimeout, stream, params, callback, sleep));
    }

    public static /* synthetic */ void request$sdk_release$default(RadarApiHelper radarApiHelper, Context context, String string, String string2, Map map, JSONObject jSONObject, boolean bl, RadarApiCallback radarApiCallback, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: request");
        }
        if ((n & 0x40) != 0) {
            radarApiCallback = null;
        }
        if ((n & 0x80) != 0) {
            bl2 = false;
        }
        if ((n & 0x100) != 0) {
            bl3 = false;
        }
        if ((n & 0x200) != 0) {
            bl4 = true;
        }
        if ((n & 0x400) != 0) {
            bl5 = false;
        }
        radarApiHelper.request$sdk_release(context, string, string2, map, jSONObject, bl, radarApiCallback, bl2, bl3, bl4, bl5);
    }

    private final String readAll(InputStream $this$readAll) {
        Scanner scanner = new Scanner($this$readAll, "UTF-8").useDelimiter("\\A");
        String body = scanner.hasNext() ? scanner.next() : (String)null;
        $this$readAll.close();
        return body;
    }

    public void requestImage$sdk_release(@NotNull Context context, @NotNull String method, @NotNull String urlString, @Nullable Map<String, String> headers, @Nullable RadarImageApiCallback callback) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
        URL url = new URL(urlString);
        RadarLogger radarLogger = this.logger;
        if (radarLogger != null) {
            RadarLogger.d$default(radarLogger, "\ud83d\udccd Radar API image request | method = " + method + "; url = " + url + "; headers = " + headers, null, null, 6, null);
        }
        this.executor.execute(() -> RadarApiHelper.requestImage$lambda-12(url, headers, this, method, callback));
    }

    public static /* synthetic */ void requestImage$sdk_release$default(RadarApiHelper radarApiHelper, Context context, String string, String string2, Map map, RadarImageApiCallback radarImageApiCallback, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: requestImage");
        }
        if ((n & 0x10) != 0) {
            radarImageApiCallback = null;
        }
        radarApiHelper.requestImage$sdk_release(context, string, string2, map, radarImageApiCallback);
    }

    private static final void request$lambda-7$lambda-1(RadarApiCallback $callback) {
        block0: {
            RadarApiCallback radarApiCallback = $callback;
            if (radarApiCallback == null) break block0;
            RadarApiCallback.DefaultImpls.onComplete$default(radarApiCallback, Radar.RadarStatus.ERROR_SERVER, null, 2, null);
        }
    }

    private static final void request$lambda-7$lambda-2(RadarApiCallback $callback, JSONObject $res) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$res, (String)"$res");
            RadarApiCallback radarApiCallback = $callback;
            if (radarApiCallback == null) break block0;
            radarApiCallback.onComplete(Radar.RadarStatus.SUCCESS, $res);
        }
    }

    private static final void request$lambda-7$lambda-3(RadarApiCallback $callback, Radar.RadarStatus $status) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)$status), (String)"$status");
            RadarApiCallback radarApiCallback = $callback;
            if (radarApiCallback == null) break block0;
            RadarApiCallback.DefaultImpls.onComplete$default(radarApiCallback, $status, null, 2, null);
        }
    }

    private static final void request$lambda-7$lambda-4(RadarApiHelper this$0, IOException $e, RadarApiCallback $callback) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$e, (String)"$e");
            RadarLogger radarLogger = this$0.logger;
            if (radarLogger != null) {
                RadarLogger.d$default(radarLogger, "Error calling API | e = " + $e.getLocalizedMessage(), null, null, 6, null);
            }
            RadarApiCallback radarApiCallback = $callback;
            if (radarApiCallback == null) break block1;
            RadarApiCallback.DefaultImpls.onComplete$default(radarApiCallback, Radar.RadarStatus.ERROR_NETWORK, null, 2, null);
        }
    }

    private static final void request$lambda-7$lambda-5(RadarApiCallback $callback) {
        block0: {
            RadarApiCallback radarApiCallback = $callback;
            if (radarApiCallback == null) break block0;
            RadarApiCallback.DefaultImpls.onComplete$default(radarApiCallback, Radar.RadarStatus.ERROR_SERVER, null, 2, null);
        }
    }

    private static final void request$lambda-7$lambda-6(RadarApiCallback $callback) {
        block0: {
            RadarApiCallback radarApiCallback = $callback;
            if (radarApiCallback == null) break block0;
            RadarApiCallback.DefaultImpls.onComplete$default(radarApiCallback, Radar.RadarStatus.ERROR_UNKNOWN, null, 2, null);
        }
    }

    private static final void request$lambda-7(URL $url, Map $headers, RadarApiHelper this$0, String $method, boolean $extendedTimeout, boolean $stream, JSONObject $params, RadarApiCallback $callback, boolean $sleep) {
        Intrinsics.checkNotNullParameter((Object)$url, (String)"$url");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$method, (String)"$method");
        try {
            HttpsURLConnection urlConnection;
            block27: {
                block26: {
                    int prevUpdatedAtMsDiff2;
                    URLConnection uRLConnection = $url.openConnection();
                    Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type javax.net.ssl.HttpsURLConnection");
                    urlConnection = (HttpsURLConnection)uRLConnection;
                    if ($headers != null) {
                        for (Map.Entry entry : $headers.entrySet()) {
                            String key = (String)entry.getKey();
                            String value = (String)entry.getValue();
                            try {
                                urlConnection.setRequestProperty(key, value);
                            }
                            catch (Exception e) {
                                RadarLogger radarLogger = this$0.logger;
                                if (radarLogger != null) {
                                    RadarLogger.d$default(radarLogger, "Error setting request property | key = " + key + "; value = " + value, null, null, 6, null);
                                }
                            }
                        }
                    }
                    urlConnection.setRequestMethod($method);
                    urlConnection.setConnectTimeout(10000);
                    if ($extendedTimeout) {
                        urlConnection.setReadTimeout(25000);
                    } else {
                        urlConnection.setReadTimeout(10000);
                    }
                    if ($stream) {
                        urlConnection.setChunkedStreamingMode(1024);
                    }
                    if ($params != null) {
                        long prevUpdatedAtMsDiff2 = $params.optLong("updatedAtMsDiff", -1L);
                        JSONArray replays = $params.optJSONArray("replays");
                        if (Build.VERSION.SDK_INT >= 17 && (prevUpdatedAtMsDiff2 != -1L || replays != null)) {
                            long nowMs = SystemClock.elapsedRealtimeNanos() / (long)1000000;
                            long locationMs = $params.optLong("locationMs", -1L);
                            if (prevUpdatedAtMsDiff2 != -1L && locationMs != -1L) {
                                long updatedAtMsDiff = nowMs - locationMs;
                                $params.put("updatedAtMsDiff", updatedAtMsDiff);
                            }
                            if (replays != null) {
                                List updatedReplays = new ArrayList();
                                int n = replays.length();
                                for (int i = 0; i < n; ++i) {
                                    JSONObject it;
                                    JSONObject replay2 = replays.optJSONObject(i);
                                    if (replay2 == null) continue;
                                    boolean bl = false;
                                    long replayLocationMs = it.optLong("locationMs", -1L);
                                    if (replayLocationMs != -1L) {
                                        long replayUpdatedAtMsDiff = nowMs - replayLocationMs;
                                        it.put("updatedAtMsDiff", replayUpdatedAtMsDiff);
                                    }
                                    updatedReplays.add(it);
                                }
                                $params.put("replays", (Object)new JSONArray((Collection)updatedReplays));
                            }
                        }
                        urlConnection.setDoOutput(true);
                        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(urlConnection.getOutputStream());
                        outputStreamWriter.write($params.toString());
                        outputStreamWriter.close();
                    }
                    boolean bl = 200 <= (prevUpdatedAtMsDiff2 = urlConnection.getResponseCode()) ? prevUpdatedAtMsDiff2 < 400 : false;
                    if (!bl) break block26;
                    InputStream inputStream = urlConnection.getInputStream();
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"urlConnection.inputStream");
                    String body = this$0.readAll(inputStream);
                    if (body == null) {
                        this$0.handler.post(() -> RadarApiHelper.request$lambda-7$lambda-1($callback));
                        return;
                    }
                    JSONObject res = new JSONObject(body);
                    RadarLogger radarLogger = this$0.logger;
                    if (radarLogger != null) {
                        RadarLogger.d$default(radarLogger, "\ud83d\udccd Radar API response | method = " + $method + "; url = " + $url + "; responseCode = " + urlConnection.getResponseCode() + "; res = " + res, null, null, 6, null);
                    }
                    this$0.handler.post(() -> RadarApiHelper.request$lambda-7$lambda-2($callback, res));
                    break block27;
                }
                int res = urlConnection.getResponseCode();
                Radar.RadarStatus status = res == 400 ? Radar.RadarStatus.ERROR_BAD_REQUEST : (res == 401 ? Radar.RadarStatus.ERROR_UNAUTHORIZED : (res == 402 ? Radar.RadarStatus.ERROR_PAYMENT_REQUIRED : (res == 403 ? Radar.RadarStatus.ERROR_FORBIDDEN : (res == 404 ? Radar.RadarStatus.ERROR_NOT_FOUND : (res == 429 ? Radar.RadarStatus.ERROR_RATE_LIMIT : ((500 <= res ? res < 600 : false) ? Radar.RadarStatus.ERROR_SERVER : Radar.RadarStatus.ERROR_UNKNOWN))))));
                InputStream inputStream = urlConnection.getErrorStream();
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"urlConnection.errorStream");
                String body = this$0.readAll(inputStream);
                if (body == null) {
                    RadarApiCallback radarApiCallback = $callback;
                    if (radarApiCallback != null) {
                        RadarApiCallback.DefaultImpls.onComplete$default(radarApiCallback, Radar.RadarStatus.ERROR_SERVER, null, 2, null);
                    }
                    return;
                }
                JSONObject res2 = new JSONObject(body);
                RadarLogger radarLogger = this$0.logger;
                if (radarLogger != null) {
                    RadarLogger.e$default(radarLogger, "\ud83d\udccd Radar API response | method = " + $method + "; url = " + $url + "; responseCode = " + urlConnection.getResponseCode() + "; res = " + res2, Radar.RadarLogType.SDK_ERROR, null, 4, null);
                }
                this$0.handler.post(() -> RadarApiHelper.request$lambda-7$lambda-3($callback, status));
            }
            urlConnection.disconnect();
        }
        catch (IOException e) {
            this$0.handler.post(() -> RadarApiHelper.request$lambda-7$lambda-4(this$0, e, $callback));
        }
        catch (JSONException e) {
            RadarLogger radarLogger = this$0.logger;
            if (radarLogger != null) {
                RadarLogger.d$default(radarLogger, "Error calling API | e = " + e.getLocalizedMessage(), null, null, 6, null);
            }
            this$0.handler.post(() -> RadarApiHelper.request$lambda-7$lambda-5($callback));
        }
        catch (Exception e) {
            RadarLogger radarLogger = this$0.logger;
            if (radarLogger != null) {
                RadarLogger.d$default(radarLogger, "Error calling API | e = " + e.getLocalizedMessage(), null, null, 6, null);
            }
            this$0.handler.post(() -> RadarApiHelper.request$lambda-7$lambda-6($callback));
        }
        if ($sleep) {
            Thread.sleep(1000L);
        }
    }

    private static final void requestImage$lambda-12$lambda-8(RadarImageApiCallback $callback, Bitmap $bitmap) {
        block0: {
            RadarImageApiCallback radarImageApiCallback = $callback;
            if (radarImageApiCallback == null) break block0;
            radarImageApiCallback.onComplete(Radar.RadarStatus.SUCCESS, $bitmap);
        }
    }

    private static final void requestImage$lambda-12$lambda-9(RadarImageApiCallback $callback, Radar.RadarStatus $status) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)$status), (String)"$status");
            RadarImageApiCallback radarImageApiCallback = $callback;
            if (radarImageApiCallback == null) break block0;
            RadarImageApiCallback.DefaultImpls.onComplete$default(radarImageApiCallback, $status, null, 2, null);
        }
    }

    private static final void requestImage$lambda-12$lambda-10(RadarApiHelper this$0, IOException $e, RadarImageApiCallback $callback) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$e, (String)"$e");
            RadarLogger radarLogger = this$0.logger;
            if (radarLogger != null) {
                RadarLogger.d$default(radarLogger, "Error calling image API | e = " + $e.getLocalizedMessage(), null, null, 6, null);
            }
            RadarImageApiCallback radarImageApiCallback = $callback;
            if (radarImageApiCallback == null) break block1;
            RadarImageApiCallback.DefaultImpls.onComplete$default(radarImageApiCallback, Radar.RadarStatus.ERROR_NETWORK, null, 2, null);
        }
    }

    private static final void requestImage$lambda-12$lambda-11(RadarImageApiCallback $callback) {
        block0: {
            RadarImageApiCallback radarImageApiCallback = $callback;
            if (radarImageApiCallback == null) break block0;
            RadarImageApiCallback.DefaultImpls.onComplete$default(radarImageApiCallback, Radar.RadarStatus.ERROR_UNKNOWN, null, 2, null);
        }
    }

    private static final void requestImage$lambda-12(URL $url, Map $headers, RadarApiHelper this$0, String $method, RadarImageApiCallback $callback) {
        Intrinsics.checkNotNullParameter((Object)$url, (String)"$url");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$method, (String)"$method");
        try {
            HttpsURLConnection urlConnection;
            block12: {
                block11: {
                    URLConnection uRLConnection = $url.openConnection();
                    Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type javax.net.ssl.HttpsURLConnection");
                    urlConnection = (HttpsURLConnection)uRLConnection;
                    if ($headers != null) {
                        for (Map.Entry entry : $headers.entrySet()) {
                            String key = (String)entry.getKey();
                            String value = (String)entry.getValue();
                            try {
                                urlConnection.setRequestProperty(key, value);
                            }
                            catch (Exception e) {
                                RadarLogger radarLogger = this$0.logger;
                                if (radarLogger != null) {
                                    RadarLogger.d$default(radarLogger, "Error setting request property | key = " + key + "; value = " + value, null, null, 6, null);
                                }
                            }
                        }
                    }
                    urlConnection.setRequestMethod($method);
                    urlConnection.setConnectTimeout(10000);
                    urlConnection.setReadTimeout(10000);
                    int n = urlConnection.getResponseCode();
                    boolean bl = 200 <= n ? n < 400 : false;
                    if (!bl) break block11;
                    InputStream inputStream = urlConnection.getInputStream();
                    Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream);
                    inputStream.close();
                    RadarLogger radarLogger = this$0.logger;
                    if (radarLogger != null) {
                        RadarLogger.d$default(radarLogger, "\ud83d\udccd Radar API image response | method = " + $method + "; url = " + $url + "; responseCode = " + urlConnection.getResponseCode(), null, null, 6, null);
                    }
                    this$0.handler.post(() -> RadarApiHelper.requestImage$lambda-12$lambda-8($callback, bitmap));
                    break block12;
                }
                int n = urlConnection.getResponseCode();
                Radar.RadarStatus status = n == 400 ? Radar.RadarStatus.ERROR_BAD_REQUEST : (n == 401 ? Radar.RadarStatus.ERROR_UNAUTHORIZED : (n == 402 ? Radar.RadarStatus.ERROR_PAYMENT_REQUIRED : (n == 403 ? Radar.RadarStatus.ERROR_FORBIDDEN : (n == 404 ? Radar.RadarStatus.ERROR_NOT_FOUND : (n == 429 ? Radar.RadarStatus.ERROR_RATE_LIMIT : ((500 <= n ? n < 600 : false) ? Radar.RadarStatus.ERROR_SERVER : Radar.RadarStatus.ERROR_UNKNOWN))))));
                RadarLogger radarLogger = this$0.logger;
                if (radarLogger != null) {
                    RadarLogger.e$default(radarLogger, "\ud83d\udccd Radar API image response | method = " + $method + "; url = " + $url + "; responseCode = " + urlConnection.getResponseCode(), Radar.RadarLogType.SDK_ERROR, null, 4, null);
                }
                this$0.handler.post(() -> RadarApiHelper.requestImage$lambda-12$lambda-9($callback, status));
            }
            urlConnection.disconnect();
        }
        catch (IOException e) {
            this$0.handler.post(() -> RadarApiHelper.requestImage$lambda-12$lambda-10(this$0, e, $callback));
        }
        catch (Exception e) {
            RadarLogger radarLogger = this$0.logger;
            if (radarLogger != null) {
                RadarLogger.d$default(radarLogger, "Error calling image API | e = " + e.getLocalizedMessage(), null, null, 6, null);
            }
            this$0.handler.post(() -> RadarApiHelper.requestImage$lambda-12$lambda-11($callback));
        }
    }

    public RadarApiHelper() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u001c\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00a8\u0006\b"}, d2={"Lio/radar/sdk/RadarApiHelper$RadarApiCallback;", "", "onComplete", "", "status", "Lio/radar/sdk/Radar$RadarStatus;", "res", "Lorg/json/JSONObject;", "sdk_release"})
    public static interface RadarApiCallback {
        public void onComplete(@NotNull Radar.RadarStatus var1, @Nullable JSONObject var2);

        @Metadata(mv={1, 7, 1}, k=3, xi=48)
        public static final class DefaultImpls {
            public static /* synthetic */ void onComplete$default(RadarApiCallback radarApiCallback, Radar.RadarStatus radarStatus, JSONObject jSONObject, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: onComplete");
                }
                if ((n & 2) != 0) {
                    jSONObject = null;
                }
                radarApiCallback.onComplete(radarStatus, jSONObject);
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u001c\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00a8\u0006\b"}, d2={"Lio/radar/sdk/RadarApiHelper$RadarImageApiCallback;", "", "onComplete", "", "status", "Lio/radar/sdk/Radar$RadarStatus;", "bitmap", "Landroid/graphics/Bitmap;", "sdk_release"})
    public static interface RadarImageApiCallback {
        public void onComplete(@NotNull Radar.RadarStatus var1, @Nullable Bitmap var2);

        @Metadata(mv={1, 7, 1}, k=3, xi=48)
        public static final class DefaultImpls {
            public static /* synthetic */ void onComplete$default(RadarImageApiCallback radarImageApiCallback, Radar.RadarStatus radarStatus, Bitmap bitmap, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: onComplete");
                }
                if ((n & 2) != 0) {
                    bitmap = null;
                }
                radarImageApiCallback.onComplete(radarStatus, bitmap);
            }
        }
    }
}

