/*
 * Decompiled with CFR 0.152.
 */
package io.radar.sdk;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import io.radar.sdk.Radar;
import io.radar.sdk.RadarInAppMessageOperation;
import io.radar.sdk.RadarInAppMessageReceiver;
import io.radar.sdk.RadarLogger;
import io.radar.sdk.model.RadarEvent;
import io.radar.sdk.model.RadarInAppMessage;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0017\u0010\u0014\u001a\u00020\u000f2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0000\u00a2\u0006\u0002\b\u0015J\u001d\u0010\u0016\u001a\u00020\u000f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00130\u0018H\u0000\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/radar/sdk/RadarInAppMessageManager;", "", "activity", "Landroid/app/Activity;", "context", "Landroid/content/Context;", "(Landroid/app/Activity;Landroid/content/Context;)V", "currentView", "Landroid/view/View;", "inAppMessageReceiver", "Lio/radar/sdk/RadarInAppMessageReceiver;", "modalDismissTime", "", "modalShowTime", "dismiss", "", "makeConversionMetadata", "Lorg/json/JSONObject;", "payload", "Lio/radar/sdk/model/RadarInAppMessage;", "setInAppMessageReceiver", "setInAppMessageReceiver$sdk_release", "showInAppMessages", "inAppMessages", "", "showInAppMessages$sdk_release", "([Lio/radar/sdk/model/RadarInAppMessage;)V", "showModal", "sdk_release"})
public final class RadarInAppMessageManager {
    @NotNull
    private final Activity activity;
    @NotNull
    private final Context context;
    @Nullable
    private View currentView;
    @Nullable
    private RadarInAppMessageReceiver inAppMessageReceiver;
    private long modalShowTime;
    private long modalDismissTime;

    public RadarInAppMessageManager(@NotNull Activity activity, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.activity = activity;
        this.context = context;
    }

    private final void showModal(RadarInAppMessage payload) {
        if (this.currentView != null) {
            return;
        }
        if (this.activity == null) {
            RadarLogger.e$default(Radar.INSTANCE.getLogger$sdk_release(), "Activity is null, cannot show in-app message", null, null, 6, null);
            return;
        }
        Window window = this.activity.getWindow();
        View view = window != null ? window.getDecorView() : null;
        ViewGroup viewGroup = view instanceof ViewGroup ? (ViewGroup)view : null;
        if (viewGroup == null) {
            return;
        }
        ViewGroup rootView = viewGroup;
        this.modalShowTime = System.currentTimeMillis();
        JSONObject metadata = this.makeConversionMetadata(payload);
        Radar.sendLogConversionRequest$sdk_release("in_app_message_displayed", metadata, new Radar.RadarLogConversionCallback(){

            public void onComplete(@NotNull Radar.RadarStatus status, @Nullable RadarEvent event) {
                Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
                RadarEvent radarEvent = event;
                RadarLogger.i$default(Radar.INSTANCE.getLogger$sdk_release(), "Conversion name = " + (radarEvent != null ? radarEvent.getConversionName() : null) + ": status = " + (Object)((Object)status) + "; event = " + event, null, null, 6, null);
            }
        });
        RadarInAppMessageReceiver radarInAppMessageReceiver = this.inAppMessageReceiver;
        View modal2 = radarInAppMessageReceiver != null ? radarInAppMessageReceiver.createInAppMessageView(this.context, payload, (Function0<Unit>)((Function0)new Function0<Unit>(this, metadata, payload){
            final /* synthetic */ RadarInAppMessageManager this$0;
            final /* synthetic */ JSONObject $metadata;
            final /* synthetic */ RadarInAppMessage $payload;
            {
                this.this$0 = $receiver;
                this.$metadata = $metadata;
                this.$payload = $payload;
                super(0);
            }

            public final void invoke() {
                RadarInAppMessageManager.access$setModalDismissTime$p(this.this$0, System.currentTimeMillis());
                long displayDuration = System.currentTimeMillis() - RadarInAppMessageManager.access$getModalShowTime$p(this.this$0);
                this.$metadata.put("display_duration", displayDuration);
                Radar.sendLogConversionRequest$sdk_release("in_app_message_dismissed", this.$metadata, new Radar.RadarLogConversionCallback(){

                    public void onComplete(@NotNull Radar.RadarStatus status, @Nullable RadarEvent event) {
                        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
                        RadarEvent radarEvent = event;
                        RadarLogger.i$default(Radar.INSTANCE.getLogger$sdk_release(), "Conversion name = " + (radarEvent != null ? radarEvent.getConversionName() : null) + ": status = " + (Object)((Object)status) + "; event = " + event, null, null, 6, null);
                    }
                });
                RadarInAppMessageReceiver radarInAppMessageReceiver = RadarInAppMessageManager.access$getInAppMessageReceiver$p(this.this$0);
                if (radarInAppMessageReceiver != null) {
                    radarInAppMessageReceiver.onInAppMessageDismissed(this.$payload);
                }
                RadarInAppMessageManager.access$dismiss(this.this$0);
            }
        }), (Function0<Unit>)((Function0)new Function0<Unit>(this, payload){
            final /* synthetic */ RadarInAppMessageManager this$0;
            final /* synthetic */ RadarInAppMessage $payload;
            {
                this.this$0 = $receiver;
                this.$payload = $payload;
                super(0);
            }

            public final void invoke() {
                RadarInAppMessageManager.access$setModalDismissTime$p(this.this$0, System.currentTimeMillis());
                JSONObject metadata = RadarInAppMessageManager.access$makeConversionMetadata(this.this$0, this.$payload);
                long displayDuration = System.currentTimeMillis() - RadarInAppMessageManager.access$getModalShowTime$p(this.this$0);
                metadata.put("display_duration", displayDuration);
                Radar.sendLogConversionRequest$sdk_release("in_app_message_clicked", metadata, new Radar.RadarLogConversionCallback(){

                    public void onComplete(@NotNull Radar.RadarStatus status, @Nullable RadarEvent event) {
                        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
                        RadarEvent radarEvent = event;
                        RadarLogger.i$default(Radar.INSTANCE.getLogger$sdk_release(), "Conversion name = " + (radarEvent != null ? radarEvent.getConversionName() : null) + ": status = " + (Object)((Object)status) + "; event = " + event, null, null, 6, null);
                    }
                });
                RadarInAppMessageReceiver radarInAppMessageReceiver = RadarInAppMessageManager.access$getInAppMessageReceiver$p(this.this$0);
                if (radarInAppMessageReceiver != null) {
                    radarInAppMessageReceiver.onInAppMessageButtonClicked(this.$payload);
                }
                RadarInAppMessage.Button button = this.$payload.getButton();
                if ((button != null ? button.getUrl() : null) != null && !Intrinsics.areEqual((Object)this.$payload.getButton().getUrl(), (Object)"null")) {
                    String string = this.$payload.getButton().getUrl();
                    RadarInAppMessageManager radarInAppMessageManager = this.this$0;
                    String url = string;
                    boolean bl = false;
                    if (StringsKt.isBlank((CharSequence)url)) {
                        RadarLogger.d$default(Radar.INSTANCE.getLogger$sdk_release(), "Button URL is blank, skipping URL opening", null, null, 6, null);
                    } else {
                        try {
                            String $this$toUri$iv = url;
                            boolean $i$f$toUri = false;
                            Uri uri = Uri.parse((String)$this$toUri$iv);
                            Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"parse(this)");
                            Uri uri2 = uri;
                            RadarLogger.d$default(Radar.INSTANCE.getLogger$sdk_release(), "Opening URL: " + url + " -> URI: " + uri2, null, null, 6, null);
                            Intent intent = new Intent("android.intent.action.VIEW", uri2);
                            RadarInAppMessageManager.access$getActivity$p(radarInAppMessageManager).startActivity(intent);
                        }
                        catch (Exception e) {
                            RadarLogger.e$default(Radar.INSTANCE.getLogger$sdk_release(), "Error opening URL '" + url + "': " + e.getMessage(), null, null, 6, null);
                        }
                    }
                } else {
                    RadarLogger.d$default(Radar.INSTANCE.getLogger$sdk_release(), "Button URL is null or 'null' string, skipping URL opening", null, null, 6, null);
                }
                RadarInAppMessageManager.access$dismiss(this.this$0);
            }
        })) : null;
        rootView.addView(modal2);
        this.currentView = modal2;
    }

    private final void dismiss() {
        block1: {
            View view = this.currentView;
            if (view == null) break block1;
            View modal2 = view;
            boolean bl = false;
            ViewParent viewParent = modal2.getParent();
            ViewGroup viewGroup = viewParent instanceof ViewGroup ? (ViewGroup)viewParent : null;
            if (viewGroup != null) {
                viewGroup.removeView(modal2);
            }
            this.currentView = null;
        }
    }

    private final JSONObject makeConversionMetadata(RadarInAppMessage payload) {
        JSONObject metadata = new JSONObject();
        JSONObject payloadMetadata = payload.getMetadata();
        if (payloadMetadata != null) {
            JSONObject payloadMetadataJson = new JSONObject(payloadMetadata.toString());
            metadata.put("campaignId", (Object)payloadMetadataJson.optString("radar:campaignId"));
            metadata.put("geofenceId", (Object)payloadMetadataJson.optString("radar:geofenceId"));
            metadata.put("campaignMetadata", (Object)payloadMetadataJson.optString("radar:campaignMetadata"));
        }
        return metadata;
    }

    public final void setInAppMessageReceiver$sdk_release(@Nullable RadarInAppMessageReceiver inAppMessageReceiver2) {
        this.inAppMessageReceiver = inAppMessageReceiver2;
    }

    public final void showInAppMessages$sdk_release(@NotNull RadarInAppMessage[] inAppMessages) {
        Intrinsics.checkNotNullParameter((Object)inAppMessages, (String)"inAppMessages");
        for (RadarInAppMessage inAppMessage : inAppMessages) {
            if (this.inAppMessageReceiver != null) {
                RadarInAppMessageOperation result;
                RadarInAppMessageReceiver radarInAppMessageReceiver = this.inAppMessageReceiver;
                RadarInAppMessageOperation radarInAppMessageOperation = result = radarInAppMessageReceiver != null ? radarInAppMessageReceiver.onNewInAppMessage(inAppMessage) : null;
                if (result == RadarInAppMessageOperation.DISCARD) continue;
            }
            this.showModal(inAppMessage);
        }
    }

    public static final /* synthetic */ void access$setModalDismissTime$p(RadarInAppMessageManager $this, long l) {
        $this.modalDismissTime = l;
    }

    public static final /* synthetic */ long access$getModalShowTime$p(RadarInAppMessageManager $this) {
        return $this.modalShowTime;
    }

    public static final /* synthetic */ RadarInAppMessageReceiver access$getInAppMessageReceiver$p(RadarInAppMessageManager $this) {
        return $this.inAppMessageReceiver;
    }

    public static final /* synthetic */ void access$dismiss(RadarInAppMessageManager $this) {
        $this.dismiss();
    }

    public static final /* synthetic */ JSONObject access$makeConversionMetadata(RadarInAppMessageManager $this, RadarInAppMessage payload) {
        return $this.makeConversionMetadata(payload);
    }

    public static final /* synthetic */ Activity access$getActivity$p(RadarInAppMessageManager $this) {
        return $this.activity;
    }
}

