/*
 * Decompiled with CFR 0.152.
 */
package io.radar.sdk.util;

import android.content.Context;
import androidx.annotation.VisibleForTesting;
import io.radar.sdk.Radar;
import io.radar.sdk.model.RadarLog;
import io.radar.sdk.util.Flushable;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 '2\u00020\u0001:\u0001'B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\u0013\u001a\u0002H\u0014\"\u0004\b\u0000\u0010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0016H\u0082\b\u00a2\u0006\u0002\u0010\u0017J\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\nH\u0007J\b\u0010\u001e\u001a\u00020\bH\u0002J\b\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020\"H\u0002J\u0016\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\bR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006("}, d2={"Lio/radar/sdk/util/RadarLogBuffer;", "", "context", "Landroid/content/Context;", "executor", "Ljava/util/concurrent/ExecutorService;", "(Landroid/content/Context;Ljava/util/concurrent/ExecutorService;)V", "currentFile", "", "directory", "Ljava/io/File;", "kotlin.jvm.PlatformType", "directoryLock", "Ljava/util/concurrent/locks/ReentrantLock;", "<set-?>", "", "size", "getSize", "()I", "fileOp", "T", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "getFlushableLogsStash", "Lio/radar/sdk/util/Flushable;", "Lio/radar/sdk/model/RadarLog;", "getLastModified", "", "file", "getNewFilePath", "isFull", "", "purgeInactiveFiles", "", "write", "level", "Lio/radar/sdk/Radar$RadarLogLevel;", "message", "Companion", "sdk_release"})
public final class RadarLogBuffer {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ExecutorService executor;
    private final File directory;
    @NotNull
    private final ReentrantLock directoryLock;
    @NotNull
    private String currentFile;
    private int size;
    @Deprecated
    @NotNull
    public static final String DIRECTORY = "RadarLogs";
    @Deprecated
    public static final int LOG_BUFFER_SIZE_LIMIT = 500;

    /*
     * WARNING - void declaration
     */
    public RadarLogBuffer(@NotNull Context context, @NotNull ExecutorService executor) {
        int n;
        Object object;
        boolean bl;
        Object object2;
        boolean bl2;
        File[] files;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.executor = executor;
        this.directory = context.getDir(DIRECTORY, 0);
        this.directoryLock = new ReentrantLock();
        Object object3 = files = this.directory.listFiles();
        if (object3 == null) {
            bl2 = false;
        } else {
            object2 = object3;
            bl = false;
            object = object2;
            n = 0;
            bl2 = !(((File[])object).length == 0);
        }
        if (bl2) {
            File file;
            File file2;
            void $this$maxByOrNull$iv;
            Intrinsics.checkNotNullExpressionValue((Object)files, (String)"files");
            object2 = files;
            RadarLogBuffer radarLogBuffer = this;
            boolean $i$f$maxByOrNull = false;
            object = $this$maxByOrNull$iv;
            n = 0;
            if (((File[])object).length == 0) {
                file2 = null;
            } else {
                void maxElem$iv = $this$maxByOrNull$iv[0];
                int lastIndex$iv = ArraysKt.getLastIndex((Object[])$this$maxByOrNull$iv);
                if (lastIndex$iv == 0) {
                    file2 = maxElem$iv;
                } else {
                    void it = maxElem$iv;
                    int n2 = 0;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    long maxValue$iv = this.getLastModified((File)it);
                    n2 = 1;
                    int n3 = lastIndex$iv;
                    if (n2 <= n3) {
                        while (true) {
                            void i$iv;
                            void e$iv;
                            void it2 = e$iv = $this$maxByOrNull$iv[i$iv];
                            boolean bl3 = false;
                            Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"it");
                            long v$iv = this.getLastModified((File)it2);
                            if (maxValue$iv < v$iv) {
                                maxElem$iv = e$iv;
                                maxValue$iv = v$iv;
                            }
                            if (i$iv == n3) break;
                            ++i$iv;
                        }
                    }
                    file2 = maxElem$iv;
                }
            }
            File file3 = file = file2;
            Intrinsics.checkNotNull(file3);
            object3 = file3.getName();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"files.maxByOrNull { getLastModified(it) }!!.name");
            radarLogBuffer.currentFile = object3;
            object3 = new FileInputStream(new File(this.directory, this.currentFile));
            object2 = Charsets.UTF_8;
            bl = false;
            object = object3;
            n = 0;
            object = new InputStreamReader((InputStream)object, (Charset)object2);
            n = 8192;
            boolean bl4 = false;
            this.size = TextStreamsKt.readLines((Reader)(object instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, n))).size();
            if (files.length > 2) {
                this.purgeInactiveFiles();
            }
        } else {
            this.currentFile = this.getNewFilePath();
            this.size = 0;
        }
    }

    public /* synthetic */ RadarLogBuffer(Context context, ExecutorService executorService, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            ExecutorService executorService2 = Executors.newSingleThreadExecutor();
            Intrinsics.checkNotNullExpressionValue((Object)executorService2, (String)"newSingleThreadExecutor()");
            executorService = executorService2;
        }
        this(context, executorService);
    }

    public final int getSize() {
        return this.size;
    }

    public final void write(@NotNull Radar.RadarLogLevel level, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.executor.submit(() -> RadarLogBuffer.write$lambda-3(this, level, message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Flushable<RadarLog> getFlushableLogsStash() {
        Pair pair;
        RadarLogBuffer this_$iv = this;
        boolean $i$f$fileOp = false;
        this_$iv.directoryLock.lock();
        try {
            boolean bl = false;
            File[] files = this.directory.listFiles();
            boolean bl2 = false;
            List list = new ArrayList();
            File[] fileArray = files;
            if (fileArray != null) {
                File[] $this$forEach$iv = fileArray;
                boolean $i$f$forEach = false;
                File[] fileArray2 = $this$forEach$iv;
                int n = fileArray2.length;
                for (int i = 0; i < n; ++i) {
                    File element$iv;
                    File file = element$iv = fileArray2[i];
                    boolean bl3 = false;
                    InputStream inputStream = new FileInputStream(file);
                    Charset charset = Charsets.UTF_8;
                    boolean bl4 = false;
                    Closeable closeable = inputStream;
                    int n2 = 0;
                    closeable = new InputStreamReader((InputStream)closeable, charset);
                    n2 = 8192;
                    boolean bl5 = false;
                    TextStreamsKt.forEachLine((Reader)(closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n2)), (Function1)((Function1)new Function1<String, Unit>((List<RadarLog>)list){
                        final /* synthetic */ List<RadarLog> $list;
                        {
                            this.$list = $list;
                            super(1);
                        }

                        public final void invoke(@NotNull String line) {
                            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                            this.$list.add(RadarLog.Companion.fromJson(new JSONObject(line)));
                        }
                    }));
                }
            }
            this.currentFile = this.getNewFilePath();
            pair = TuplesKt.to((Object)files, (Object)list);
        }
        finally {
            this_$iv.directoryLock.unlock();
        }
        Pair pair2 = pair;
        File[] files = (File[])pair2.component1();
        List list = (List)pair2.component2();
        return new Flushable<RadarLog>((List<RadarLog>)list, this, files){
            final /* synthetic */ List<RadarLog> $list;
            final /* synthetic */ RadarLogBuffer this$0;
            final /* synthetic */ File[] $files;
            {
                this.$list = $list;
                this.this$0 = $receiver;
                this.$files = $files;
            }

            @NotNull
            public List<RadarLog> get() {
                return this.$list;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void onFlush(boolean success) {
                if (success) {
                    void this_$iv;
                    RadarLogBuffer radarLogBuffer = this.this$0;
                    File[] fileArray = this.$files;
                    RadarLogBuffer radarLogBuffer2 = this.this$0;
                    List<RadarLog> list = this.$list;
                    boolean $i$f$fileOp = false;
                    RadarLogBuffer.access$getDirectoryLock$p((RadarLogBuffer)this_$iv).lock();
                    try {
                        boolean bl = false;
                        Object object = fileArray;
                        if (object != null) {
                            File[] $this$forEach$iv = object;
                            boolean $i$f$forEach = false;
                            File[] fileArray2 = $this$forEach$iv;
                            int n = fileArray2.length;
                            for (int i = 0; i < n; ++i) {
                                File element$iv;
                                File it = element$iv = fileArray2[i];
                                boolean bl2 = false;
                                it.delete();
                            }
                        }
                        object = radarLogBuffer2;
                        RadarLogBuffer.access$setSize$p((RadarLogBuffer)object, ((RadarLogBuffer)object).getSize() - list.size() % 500);
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        RadarLogBuffer.access$getDirectoryLock$p((RadarLogBuffer)this_$iv).unlock();
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean isFull() {
        boolean bl;
        RadarLogBuffer this_$iv = this;
        boolean $i$f$fileOp = false;
        this_$iv.directoryLock.lock();
        try {
            boolean bl2 = false;
            bl = this.getSize() >= 500;
        }
        finally {
            this_$iv.directoryLock.unlock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void purgeInactiveFiles() {
        RadarLogBuffer this_$iv = this;
        boolean $i$f$fileOp = false;
        this_$iv.directoryLock.lock();
        try {
            boolean bl = false;
            Object[] files = this.directory.listFiles();
            if (files != null) {
                Object[] objectArray = files;
                boolean bl2 = false;
                Object[] objectArray2 = objectArray;
                boolean bl3 = false;
                if (!(objectArray2.length == 0)) {
                    if (files.length > 2) {
                        List otherFiles = ArraysKt.toMutableList((Object[])files);
                        for (File file : otherFiles) {
                            if (!Intrinsics.areEqual((Object)file.getName(), (Object)this.currentFile)) continue;
                            otherFiles.remove(file);
                            break;
                        }
                        Iterable $this$forEach$iv = otherFiles;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            File it = (File)element$iv;
                            boolean bl4 = false;
                            it.delete();
                        }
                    }
                    this.currentFile = this.getNewFilePath();
                }
            }
            this.size = 0;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv.directoryLock.unlock();
        }
        this.write(Radar.RadarLogLevel.DEBUG, "------ purged oldest logs -----");
    }

    private final String getNewFilePath() {
        String name = UUID.randomUUID() + ".log";
        new File(this.directory, name).createNewFile();
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T fileOp(Function0<? extends T> block) {
        boolean $i$f$fileOp = false;
        this.directoryLock.lock();
        try {
            Object object = block.invoke();
            return (T)object;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this.directoryLock.unlock();
            InlineMarker.finallyEnd((int)1);
        }
    }

    @VisibleForTesting
    public final long getLastModified(@NotNull File file) {
        long l;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        try {
            l = file.lastModified();
        }
        catch (SecurityException ignored) {
            l = 0L;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void write$lambda-3(RadarLogBuffer this$0, Radar.RadarLogLevel $level, String $message) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$level), (String)"$level");
        Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
        if (this$0.isFull()) {
            this$0.purgeInactiveFiles();
        }
        JSONObject radarLog = new RadarLog($level, StringsKt.replace$default((String)$message, (char)'\n', (char)'\t', (boolean)false, (int)4, null), null, 4, null).toJson();
        RadarLogBuffer this_$iv = this$0;
        boolean $i$f$fileOp = false;
        this_$iv.directoryLock.lock();
        try {
            boolean bl = false;
            Object object = new FileOutputStream(new File(this$0.directory, this$0.currentFile), true);
            int n = 0;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                FileOutputStream fileOutputStream = (FileOutputStream)object;
                boolean bl3 = false;
                String string = "" + radarLog + '\n';
                Charset charset = Charsets.UTF_8;
                boolean bl4 = false;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray = string2.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                fileOutputStream.write(byArray);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = this$0;
            n = ((RadarLogBuffer)object).getSize();
            ((RadarLogBuffer)object).size = n + 1;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv.directoryLock.unlock();
        }
    }

    public static final /* synthetic */ void access$setSize$p(RadarLogBuffer $this, int n) {
        $this.size = n;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/radar/sdk/util/RadarLogBuffer$Companion;", "", "()V", "DIRECTORY", "", "LOG_BUFFER_SIZE_LIMIT", "", "sdk_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

