/*
 * Decompiled with CFR 0.152.
 */
package io.radar.sdk;

import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanRecord;
import androidx.annotation.RequiresApi;
import io.radar.sdk.model.RadarBeacon;
import java.nio.ByteBuffer;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c1\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J#\u0010\u0005\u001a\u0004\u0018\u00010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/radar/sdk/RadarBeaconUtils;", "", "()V", "MANUFACTURER_ID", "", "getBeacon", "Lio/radar/sdk/model/RadarBeacon;", "beacons", "", "scanRecord", "Landroid/bluetooth/le/ScanRecord;", "([Lio/radar/sdk/model/RadarBeacon;Landroid/bluetooth/le/ScanRecord;)Lio/radar/sdk/model/RadarBeacon;", "getScanFilter", "Landroid/bluetooth/le/ScanFilter;", "beacon", "sdk_release"})
@RequiresApi(value=21)
public final class RadarBeaconUtils {
    @NotNull
    public static final RadarBeaconUtils INSTANCE = new RadarBeaconUtils();
    private static final int MANUFACTURER_ID = 76;

    private RadarBeaconUtils() {
    }

    @Nullable
    public final ScanFilter getScanFilter(@NotNull RadarBeacon beacon) {
        int n;
        int n2;
        Intrinsics.checkNotNullParameter((Object)beacon, (String)"beacon");
        UUID uuid = UUID.fromString(beacon.getUuid());
        String string = beacon.getMajor();
        boolean bl = false;
        int major = Integer.parseInt(string);
        String string2 = beacon.getMinor();
        int n3 = 0;
        int minor = Integer.parseInt(string2);
        n3 = 0;
        byte[] byArray = new byte[2];
        ByteBuffer byteBuffer = ByteBuffer.allocate(23);
        while (n3 < 2) {
            n2 = n3++;
            byArray[n2] = 0;
        }
        ByteBuffer byteBuffer2 = byteBuffer.put(byArray).putLong(uuid.getMostSignificantBits()).putLong(uuid.getLeastSignificantBits()).put((byte)(major / 256)).put((byte)(major % 256)).put((byte)(minor / 256)).put((byte)(minor % 256));
        n3 = 0;
        byArray = new byte[1];
        byteBuffer = byteBuffer2;
        while (n3 < 1) {
            n2 = n3++;
            byArray[n2] = 0;
        }
        byte[] manufacturerData = byteBuffer.put(byArray).array();
        int n4 = 0;
        byte[] byArray2 = new byte[2];
        byteBuffer = ByteBuffer.allocate(23);
        while (n4 < 2) {
            n = n4++;
            byArray2[n] = 0;
        }
        ByteBuffer byteBuffer3 = byteBuffer.put(byArray2);
        n4 = 0;
        byArray2 = new byte[20];
        byteBuffer = byteBuffer3;
        while (n4 < 20) {
            n = n4++;
            byArray2[n] = -1;
        }
        ByteBuffer byteBuffer4 = byteBuffer.put(byArray2);
        n4 = 0;
        byArray2 = new byte[1];
        byteBuffer = byteBuffer4;
        while (n4 < 1) {
            n = n4++;
            byArray2[n] = 0;
        }
        byte[] manufacturerDataMask = byteBuffer.put(byArray2).array();
        return new ScanFilter.Builder().setManufacturerData(76, manufacturerData, manufacturerDataMask).build();
    }

    @Nullable
    public final RadarBeacon getBeacon(@NotNull RadarBeacon[] beacons, @NotNull ScanRecord scanRecord) {
        RadarBeacon radarBeacon;
        block4: {
            Intrinsics.checkNotNullParameter((Object)beacons, (String)"beacons");
            Intrinsics.checkNotNullParameter((Object)scanRecord, (String)"scanRecord");
            byte[] bytes = scanRecord.getBytes();
            int startByte = 2;
            boolean iBeacon = false;
            while (startByte <= 5) {
                if ((bytes[startByte + 2] & 0xFF) == 2 && (bytes[startByte + 3] & 0xFF) == 21) {
                    iBeacon = true;
                    break;
                }
                int n = startByte;
                startByte = n + 1;
            }
            if (!iBeacon) {
                return null;
            }
            ByteBuffer buf = ByteBuffer.wrap(bytes, startByte + 4, 20);
            UUID uuid = new UUID(buf.getLong(), buf.getLong());
            String major = String.valueOf((buf.get() & 0xFF) * 256 + (buf.get() & 0xFF));
            String minor = String.valueOf((buf.get() & 0xFF) * 256 + (buf.get() & 0xFF));
            RadarBeacon[] radarBeaconArray = beacons;
            boolean bl = false;
            RadarBeacon[] radarBeaconArray2 = radarBeaconArray;
            boolean bl2 = false;
            RadarBeacon[] radarBeaconArray3 = radarBeaconArray2;
            int n = radarBeaconArray3.length;
            for (int i = 0; i < n; ++i) {
                RadarBeacon radarBeacon2;
                RadarBeacon it = radarBeacon2 = radarBeaconArray3[i];
                boolean bl3 = false;
                if (!(UUID.fromString(it.getUuid()).equals(uuid) && Intrinsics.areEqual((Object)it.getMajor(), (Object)major) && Intrinsics.areEqual((Object)it.getMinor(), (Object)minor))) continue;
                radarBeacon = radarBeacon2;
                break block4;
            }
            radarBeacon = null;
        }
        return radarBeacon;
    }
}

