/*
 * Decompiled with CFR 0.152.
 */
package io.radar.sdk;

import android.app.job.JobInfo;
import android.app.job.JobParameters;
import android.app.job.JobScheduler;
import android.app.job.JobService;
import android.content.ComponentName;
import android.content.Context;
import android.location.Location;
import android.os.Handler;
import android.os.Looper;
import android.os.PersistableBundle;
import androidx.annotation.RequiresApi;
import io.radar.sdk.Radar;
import io.radar.sdk.RadarLogger;
import io.radar.sdk.util.BatteryState;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lio/radar/sdk/RadarJobScheduler;", "Landroid/app/job/JobService;", "()V", "onStartJob", "", "params", "Landroid/app/job/JobParameters;", "onStopJob", "Companion", "sdk_release"})
@RequiresApi(value=21)
public final class RadarJobScheduler
extends JobService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String EXTRA_LATITUDE = "latitude";
    @NotNull
    private static final String EXTRA_LONGITUDE = "longitude";
    @NotNull
    private static final String EXTRA_ACCURACY = "accuracy";
    @NotNull
    private static final String EXTRA_PROVIDER = "provider";
    @NotNull
    private static final String EXTRA_TIME = "time";
    @NotNull
    private static final String EXTRA_SOURCE = "source";
    private static final int JOB_ID = 20160525;
    @NotNull
    private static final AtomicInteger counter = new AtomicInteger(0);

    public boolean onStartJob(@NotNull JobParameters params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        PersistableBundle persistableBundle = params.getExtras();
        Intrinsics.checkNotNullExpressionValue((Object)persistableBundle, (String)"params.extras");
        PersistableBundle extras = persistableBundle;
        double latitude = extras.getDouble(EXTRA_LATITUDE);
        double longitude = extras.getDouble(EXTRA_LONGITUDE);
        float accuracy = (float)extras.getDouble(EXTRA_ACCURACY);
        String provider = extras.getString(EXTRA_PROVIDER);
        long time = extras.getLong(EXTRA_TIME);
        Location location = new Location(provider);
        boolean bl = false;
        boolean bl2 = false;
        Location $this$onStartJob_u24lambda_u2d0 = location;
        boolean bl3 = false;
        $this$onStartJob_u24lambda_u2d0.setLatitude(latitude);
        $this$onStartJob_u24lambda_u2d0.setLongitude(longitude);
        $this$onStartJob_u24lambda_u2d0.setAccuracy(accuracy);
        $this$onStartJob_u24lambda_u2d0.setTime(time);
        Location location2 = location;
        String sourceStr = extras.getString(EXTRA_SOURCE);
        if (Radar.isTestKey$sdk_release()) {
            BatteryState batteryState = Radar.INSTANCE.getBatteryManager$sdk_release().getBatteryState();
            RadarLogger.d$default(Radar.INSTANCE.getLogger$sdk_release(), "Starting Location Job | location = " + location2 + "; source = " + sourceStr + "; requestNumber = " + counter.get() + "; standbyBucket = " + Radar.INSTANCE.getBatteryManager$sdk_release().getAppStandbyBucket() + "; performanceState = " + batteryState.getPerformanceState().name() + "; isCharging = " + batteryState.isCharging() + "; batteryPercentage = " + batteryState.getPercent() + "; isPowerSaveMode = " + batteryState.getPowerSaveMode() + "; isIgnoringBatteryOptimizations = " + batteryState.isIgnoringBatteryOptimizations() + "; locationPowerSaveMode = " + batteryState.getPowerLocationPowerSaveModeString() + "; isDozeMode = " + batteryState.isDeviceIdleMode(), null, 2, null);
        }
        if (sourceStr == null) {
            return false;
        }
        Radar.RadarLocationSource source = Radar.RadarLocationSource.valueOf(sourceStr);
        Context context = this.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"this.applicationContext");
        Radar.INSTANCE.handleLocation$sdk_release(context, location2, source);
        new Handler(Looper.getMainLooper()).postDelayed(() -> RadarJobScheduler.onStartJob$lambda-1(this, params), 10000L);
        counter.set(0);
        return true;
    }

    public boolean onStopJob(@NotNull JobParameters params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        if (Radar.isTestKey$sdk_release()) {
            PersistableBundle persistableBundle = params.getExtras();
            Intrinsics.checkNotNullExpressionValue((Object)persistableBundle, (String)"params.extras");
            PersistableBundle extras = persistableBundle;
            double latitude = extras.getDouble(EXTRA_LATITUDE);
            double longitude = extras.getDouble(EXTRA_LONGITUDE);
            float accuracy = (float)extras.getDouble(EXTRA_ACCURACY);
            String provider = extras.getString(EXTRA_PROVIDER);
            long time = extras.getLong(EXTRA_TIME);
            Location location = new Location(provider);
            boolean bl = false;
            boolean bl2 = false;
            Location $this$onStopJob_u24lambda_u2d2 = location;
            boolean bl3 = false;
            $this$onStopJob_u24lambda_u2d2.setLatitude(latitude);
            $this$onStopJob_u24lambda_u2d2.setLongitude(longitude);
            $this$onStopJob_u24lambda_u2d2.setAccuracy(accuracy);
            $this$onStopJob_u24lambda_u2d2.setTime(time);
            Location location2 = location;
            String source = extras.getString(EXTRA_SOURCE);
            RadarLogger.d$default(Radar.INSTANCE.getLogger$sdk_release(), "Stopping Location Job | location = " + location2 + "; source = " + source, null, 2, null);
        }
        return false;
    }

    private static final void onStartJob$lambda-1(RadarJobScheduler this$0, JobParameters $params) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$params, (String)"$params");
        this$0.jobFinished($params, false);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/radar/sdk/RadarJobScheduler$Companion;", "", "()V", "EXTRA_ACCURACY", "", "EXTRA_LATITUDE", "EXTRA_LONGITUDE", "EXTRA_PROVIDER", "EXTRA_SOURCE", "EXTRA_TIME", "JOB_ID", "", "counter", "Ljava/util/concurrent/atomic/AtomicInteger;", "scheduleJob", "", "context", "Landroid/content/Context;", "location", "Landroid/location/Location;", "source", "Lio/radar/sdk/Radar$RadarLocationSource;", "scheduleJob$sdk_release", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public final void scheduleJob$sdk_release(@NotNull Context context, @NotNull Location location, @NotNull Radar.RadarLocationSource source) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            Intrinsics.checkNotNullParameter((Object)((Object)source), (String)RadarJobScheduler.EXTRA_SOURCE);
            ComponentName componentName = new ComponentName(context, RadarJobScheduler.class);
            PersistableBundle persistableBundle = new PersistableBundle();
            boolean bl = false;
            boolean bl2 = false;
            PersistableBundle $this$scheduleJob_u24lambda_u2d0 = persistableBundle;
            boolean bl3 = false;
            $this$scheduleJob_u24lambda_u2d0.putDouble(RadarJobScheduler.EXTRA_LATITUDE, location.getLatitude());
            $this$scheduleJob_u24lambda_u2d0.putDouble(RadarJobScheduler.EXTRA_LONGITUDE, location.getLongitude());
            $this$scheduleJob_u24lambda_u2d0.putDouble(RadarJobScheduler.EXTRA_ACCURACY, (double)location.getAccuracy());
            $this$scheduleJob_u24lambda_u2d0.putString(RadarJobScheduler.EXTRA_PROVIDER, location.getProvider());
            $this$scheduleJob_u24lambda_u2d0.putLong(RadarJobScheduler.EXTRA_TIME, location.getTime());
            $this$scheduleJob_u24lambda_u2d0.putString(RadarJobScheduler.EXTRA_SOURCE, source.name());
            PersistableBundle extras = persistableBundle;
            JobInfo jobInfo = new JobInfo.Builder(20160525, componentName).setExtras(extras).setMinimumLatency(0L).setOverrideDeadline(0L).build();
            Object object = context.getSystemService("jobscheduler");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.app.job.JobScheduler");
            }
            JobScheduler jobScheduler = (JobScheduler)object;
            int result = jobScheduler.schedule(jobInfo);
            if (result == 1) {
                RadarLogger.d$default(Radar.INSTANCE.getLogger$sdk_release(), "Scheduling Location Job | location = " + location + "; source = " + Radar.stringForSource(source) + "; success = true; overwrites = " + counter.getAndIncrement(), null, 2, null);
            } else {
                RadarLogger.d$default(Radar.INSTANCE.getLogger$sdk_release(), "Failed to Schedule Location Job | location = " + location + "; source = " + Radar.stringForSource(source) + ';', null, 2, null);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

