/*
 * Decompiled with CFR 0.152.
 */
package io.radar.sdk;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanRecord;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import androidx.annotation.RequiresApi;
import io.radar.sdk.Radar;
import io.radar.sdk.RadarBeaconUtils;
import io.radar.sdk.RadarLocationReceiver;
import io.radar.sdk.RadarLogger;
import io.radar.sdk.RadarPermissionsHelper;
import io.radar.sdk.RadarUtils;
import io.radar.sdk.model.RadarBeacon;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010#\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\b\u0001\u0018\u0000 22\u00020\u0001:\u00012B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0003\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u0011H\u0002J\u001f\u0010&\u001a\u00020$2\u0010\b\u0002\u0010'\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\fH\u0002\u00a2\u0006\u0002\u0010(J\u0012\u0010)\u001a\u00020$2\b\u0010*\u001a\u0004\u0018\u00010+H\u0002J#\u0010,\u001a\u00020$2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\u0010%\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0002\u0010-J\u001b\u0010.\u001a\u00020$2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0007\u00a2\u0006\u0002\u0010/J\b\u00100\u001a\u00020$H\u0007J\b\u00101\u001a\u00020$H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR2\u0010\u000f\u001a&\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u0011 \u0012*\u0012\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u0011\u0018\u00010\u00130\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lio/radar/sdk/RadarBeaconManager;", "", "context", "Landroid/content/Context;", "logger", "Lio/radar/sdk/RadarLogger;", "permissionsHelper", "Lio/radar/sdk/RadarPermissionsHelper;", "(Landroid/content/Context;Lio/radar/sdk/RadarLogger;Lio/radar/sdk/RadarPermissionsHelper;)V", "adapter", "Landroid/bluetooth/BluetoothAdapter;", "beacons", "", "Lio/radar/sdk/model/RadarBeacon;", "[Lio/radar/sdk/model/RadarBeacon;", "callbacks", "", "Lio/radar/sdk/Radar$RadarBeaconCallback;", "kotlin.jvm.PlatformType", "", "handler", "Landroid/os/Handler;", "monitoredBeaconIdentifiers", "", "", "nearbyBeaconIdentifiers", "", "getPermissionsHelper$sdk_release", "()Lio/radar/sdk/RadarPermissionsHelper;", "setPermissionsHelper$sdk_release", "(Lio/radar/sdk/RadarPermissionsHelper;)V", "scanCallback", "Landroid/bluetooth/le/ScanCallback;", "started", "", "addCallback", "", "callback", "callCallbacks", "nearbyBeacons", "([Ljava/lang/String;)V", "handleScanResult", "result", "Landroid/bluetooth/le/ScanResult;", "rangeBeacons", "([Lio/radar/sdk/model/RadarBeacon;Lio/radar/sdk/Radar$RadarBeaconCallback;)V", "startMonitoringBeacons", "([Lio/radar/sdk/model/RadarBeacon;)V", "stopMonitoringBeacons", "stopRanging", "Companion", "sdk_release"})
@RequiresApi(value=21)
@SuppressLint(value={"MissingPermission"})
public final class RadarBeaconManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final RadarLogger logger;
    @NotNull
    private RadarPermissionsHelper permissionsHelper;
    private BluetoothAdapter adapter;
    private boolean started;
    private final List<Radar.RadarBeaconCallback> callbacks;
    @NotNull
    private Set<String> nearbyBeaconIdentifiers;
    @NotNull
    private Set<String> monitoredBeaconIdentifiers;
    @NotNull
    private RadarBeacon[] beacons;
    @Nullable
    private ScanCallback scanCallback;
    @NotNull
    private final Handler handler;
    @NotNull
    private static final String TIMEOUT_TOKEN = "timeout";

    public RadarBeaconManager(@NotNull Context context, @NotNull RadarLogger logger, @SuppressLint(value={"VisibleForTests"}) @NotNull RadarPermissionsHelper permissionsHelper) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)permissionsHelper, (String)"permissionsHelper");
        this.context = context;
        this.logger = logger;
        this.permissionsHelper = permissionsHelper;
        boolean bl = false;
        this.callbacks = Collections.synchronizedList(new ArrayList());
        bl = false;
        this.nearbyBeaconIdentifiers = new LinkedHashSet();
        bl = false;
        this.monitoredBeaconIdentifiers = SetsKt.emptySet();
        this.beacons = new RadarBeacon[0];
        this.handler = new Handler(Looper.getMainLooper());
    }

    public /* synthetic */ RadarBeaconManager(Context context, RadarLogger radarLogger, RadarPermissionsHelper radarPermissionsHelper, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            radarPermissionsHelper = new RadarPermissionsHelper();
        }
        this(context, radarLogger, radarPermissionsHelper);
    }

    @NotNull
    public final RadarPermissionsHelper getPermissionsHelper$sdk_release() {
        return this.permissionsHelper;
    }

    public final void setPermissionsHelper$sdk_release(@NotNull RadarPermissionsHelper radarPermissionsHelper) {
        Intrinsics.checkNotNullParameter((Object)radarPermissionsHelper, (String)"<set-?>");
        this.permissionsHelper = radarPermissionsHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addCallback(Radar.RadarBeaconCallback callback) {
        if (callback == null) {
            return;
        }
        List<Radar.RadarBeaconCallback> list = this.callbacks;
        Intrinsics.checkNotNullExpressionValue(list, (String)"callbacks");
        boolean bl = false;
        boolean bl2 = false;
        synchronized (list) {
            boolean bl3 = false;
            bl2 = this.callbacks.add(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void callCallbacks(String[] nearbyBeacons) {
        List<Radar.RadarBeaconCallback> list = this.callbacks;
        Intrinsics.checkNotNullExpressionValue(list, (String)"callbacks");
        boolean bl = false;
        boolean bl2 = false;
        synchronized (list) {
            boolean bl3 = false;
            if (this.callbacks.isEmpty()) {
                return;
            }
            RadarLogger.d$default(this.logger, Intrinsics.stringPlus((String)"Calling callbacks | callbacks.size = ", (Object)this.callbacks.size()), null, 2, null);
            for (Radar.RadarBeaconCallback callback : this.callbacks) {
                callback.onComplete(Radar.RadarStatus.SUCCESS, nearbyBeacons);
            }
            this.callbacks.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    static /* synthetic */ void callCallbacks$default(RadarBeaconManager radarBeaconManager, String[] stringArray, int n, Object object) {
        if ((n & 1) != 0) {
            stringArray = null;
        }
        radarBeaconManager.callCallbacks(stringArray);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresApi(value=26)
    public final void startMonitoringBeacons(@NotNull RadarBeacon[] beacons) {
        void $this$mapTo$iv$iv;
        BluetoothAdapter bluetoothAdapter;
        Intrinsics.checkNotNullParameter((Object)beacons, (String)"beacons");
        if (!this.permissionsHelper.bluetoothPermissionsGranted$sdk_release(this.context)) {
            RadarLogger.d$default(this.logger, "Bluetooth permissions not granted", null, 2, null);
            return;
        }
        if (!RadarUtils.INSTANCE.getBluetoothSupported$sdk_release(this.context)) {
            RadarLogger.d$default(this.logger, "Bluetooth not supported", null, 2, null);
            return;
        }
        if (this.adapter == null) {
            bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
            Intrinsics.checkNotNullExpressionValue((Object)bluetoothAdapter, (String)"getDefaultAdapter()");
            this.adapter = bluetoothAdapter;
        }
        if ((bluetoothAdapter = this.adapter) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
            throw null;
        }
        if (!bluetoothAdapter.isEnabled()) {
            RadarLogger.d$default(this.logger, "Bluetooth not enabled", null, 2, null);
            return;
        }
        RadarBeacon[] $this$map$iv = beacons;
        boolean $i$f$map22 = false;
        RadarBeacon[] radarBeaconArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        void var8_14 = $this$mapTo$iv$iv;
        int n = ((void)var8_14).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var12_19 = item$iv$iv = var8_14[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.get_id();
            collection.add(string);
        }
        Set newBeaconIdentifiers = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        if (Intrinsics.areEqual(this.monitoredBeaconIdentifiers, (Object)newBeaconIdentifiers)) {
            RadarLogger.i$default(this.logger, "Already monitoring beacons", null, 2, null);
            return;
        }
        this.stopMonitoringBeacons();
        $this$map$iv = beacons;
        $i$f$map22 = false;
        if ($this$map$iv.length == 0) {
            RadarLogger.d$default(this.logger, "No beacons to monitor", null, 2, null);
            return;
        }
        this.monitoredBeaconIdentifiers = newBeaconIdentifiers;
        $i$f$map22 = false;
        List scanFilters = new ArrayList();
        RadarBeacon[] $i$f$map22 = beacons;
        int n2 = 0;
        int n3 = $i$f$map22.length;
        while (n2 < n3) {
            RadarBeacon beacon = $i$f$map22[n2];
            ++n2;
            ScanFilter scanFilter = null;
            try {
                RadarLogger.d$default(this.logger, Intrinsics.stringPlus((String)"Building scan filter for monitoring | _id = ", (Object)beacon.get_id()), null, 2, null);
                scanFilter = RadarBeaconUtils.INSTANCE.getScanFilter(beacon);
            }
            catch (Exception e) {
                this.logger.d(Intrinsics.stringPlus((String)"Error building scan filter for monitoring | _id = ", (Object)beacon.get_id()), e);
            }
            if (scanFilter == null) continue;
            RadarLogger.d$default(this.logger, "Starting monitoring beacon | _id = " + beacon.get_id() + "; uuid = " + beacon.getUuid() + "; major = " + beacon.getMajor() + "; minor = " + beacon.getMinor(), null, 2, null);
            scanFilters.add(scanFilter);
        }
        if (scanFilters.size() == 0) {
            RadarLogger.d$default(this.logger, "No scan filters for monitoring", null, 2, null);
            return;
        }
        try {
            ScanSettings scanSettings = new ScanSettings.Builder().setScanMode(0).setCallbackType(2).setReportDelay(30000L).setMatchMode(2).setNumOfMatches(1).build();
            RadarLogger.d$default(this.logger, "Starting monitoring beacons", null, 2, null);
            BluetoothAdapter bluetoothAdapter2 = this.adapter;
            if (bluetoothAdapter2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
                throw null;
            }
            bluetoothAdapter2.getBluetoothLeScanner().startScan(scanFilters, scanSettings, RadarLocationReceiver.Companion.getBeaconPendingIntent$sdk_release(this.context));
        }
        catch (SecurityException e) {
            this.logger.e("Error starting monitoring beacons", e);
        }
    }

    @RequiresApi(value=26)
    public final void stopMonitoringBeacons() {
        BluetoothAdapter bluetoothAdapter;
        if (!this.permissionsHelper.bluetoothPermissionsGranted$sdk_release(this.context)) {
            return;
        }
        if (!RadarUtils.INSTANCE.getBluetoothSupported$sdk_release(this.context)) {
            return;
        }
        if (this.adapter == null) {
            bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
            Intrinsics.checkNotNullExpressionValue((Object)bluetoothAdapter, (String)"getDefaultAdapter()");
            this.adapter = bluetoothAdapter;
        }
        if ((bluetoothAdapter = this.adapter) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
            throw null;
        }
        if (!bluetoothAdapter.isEnabled()) {
            RadarLogger.d$default(this.logger, "Bluetooth not enabled", null, 2, null);
            return;
        }
        RadarLogger.d$default(this.logger, "Stopping monitoring beacons", null, 2, null);
        bluetoothAdapter = this.adapter;
        if (bluetoothAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
            throw null;
        }
        bluetoothAdapter.getBluetoothLeScanner().stopScan(RadarLocationReceiver.Companion.getBeaconPendingIntent$sdk_release(this.context));
    }

    public final void rangeBeacons(@NotNull RadarBeacon[] beacons, @Nullable Radar.RadarBeaconCallback callback) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)beacons, (String)"beacons");
        if (!this.permissionsHelper.bluetoothPermissionsGranted$sdk_release(this.context)) {
            RadarLogger.d$default(this.logger, "Bluetooth permissions not granted", null, 2, null);
            Radar.INSTANCE.sendError$sdk_release(Radar.RadarStatus.ERROR_PERMISSIONS);
            Radar.RadarBeaconCallback radarBeaconCallback = callback;
            if (radarBeaconCallback != null) {
                Radar.RadarBeaconCallback.DefaultImpls.onComplete$default(radarBeaconCallback, Radar.RadarStatus.ERROR_PERMISSIONS, null, 2, null);
            }
            return;
        }
        if (!RadarUtils.INSTANCE.getBluetoothSupported$sdk_release(this.context)) {
            RadarLogger.d$default(this.logger, "Bluetooth not supported", null, 2, null);
            Radar.INSTANCE.sendError$sdk_release(Radar.RadarStatus.ERROR_BLUETOOTH);
            Radar.RadarBeaconCallback radarBeaconCallback = callback;
            if (radarBeaconCallback != null) {
                Radar.RadarBeaconCallback.DefaultImpls.onComplete$default(radarBeaconCallback, Radar.RadarStatus.ERROR_BLUETOOTH, null, 2, null);
            }
            return;
        }
        if (this.adapter == null) {
            object = BluetoothAdapter.getDefaultAdapter();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getDefaultAdapter()");
            this.adapter = object;
        }
        if ((object = this.adapter) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
            throw null;
        }
        if (!object.isEnabled()) {
            RadarLogger.d$default(this.logger, "Bluetooth not enabled", null, 2, null);
            Radar.INSTANCE.sendError$sdk_release(Radar.RadarStatus.ERROR_BLUETOOTH);
            object = callback;
            if (object != null) {
                Radar.RadarBeaconCallback.DefaultImpls.onComplete$default((Radar.RadarBeaconCallback)object, Radar.RadarStatus.ERROR_BLUETOOTH, null, 2, null);
            }
            return;
        }
        object = beacons;
        boolean bl = false;
        if (((RadarBeacon[])object).length == 0) {
            RadarLogger.d$default(this.logger, "No beacons to range", null, 2, null);
            object = callback;
            if (object != null) {
                Radar.RadarBeaconCallback.DefaultImpls.onComplete$default((Radar.RadarBeaconCallback)object, Radar.RadarStatus.SUCCESS, null, 2, null);
            }
            return;
        }
        this.addCallback(callback);
        if (this.started) {
            RadarLogger.d$default(this.logger, "Already ranging beacons", null, 2, null);
            return;
        }
        this.beacons = beacons;
        this.started = true;
        bl = false;
        List scanFilters = new ArrayList();
        RadarBeacon[] radarBeaconArray = beacons;
        int n = 0;
        int n2 = radarBeaconArray.length;
        while (n < n2) {
            RadarBeacon beacon = radarBeaconArray[n];
            ++n;
            ScanFilter scanFilter = null;
            try {
                RadarLogger.d$default(this.logger, Intrinsics.stringPlus((String)"Building scan filter for ranging | _id = ", (Object)beacon.get_id()), null, 2, null);
                scanFilter = RadarBeaconUtils.INSTANCE.getScanFilter(beacon);
            }
            catch (Exception e) {
                this.logger.d(Intrinsics.stringPlus((String)"Error building scan filter for ranging | _id = ", (Object)beacon.get_id()), e);
            }
            if (scanFilter == null) continue;
            RadarLogger.d$default(this.logger, "Starting ranging beacon | _id = " + beacon.get_id() + "; uuid = " + beacon.getUuid() + "; major = " + beacon.getMajor() + "; minor = " + beacon.getMinor(), null, 2, null);
            scanFilters.add(scanFilter);
        }
        if (scanFilters.size() == 0) {
            RadarLogger.d$default(this.logger, "No scan filters for ranging", null, 2, null);
            RadarBeaconManager.callCallbacks$default(this, null, 1, null);
            return;
        }
        ScanSettings scanSettings = new ScanSettings.Builder().setScanMode(1).setReportDelay(0L).build();
        RadarBeaconManager beaconManager = this;
        this.scanCallback = new ScanCallback(beaconManager, this){
            final /* synthetic */ RadarBeaconManager $beaconManager;
            final /* synthetic */ RadarBeaconManager this$0;
            {
                this.$beaconManager = $beaconManager;
                this.this$0 = $receiver;
            }

            public void onScanResult(int callbackType, @Nullable ScanResult result) {
                super.onScanResult(callbackType, result);
                RadarBeaconManager.access$handleScanResult(this.$beaconManager, result);
            }

            /*
             * WARNING - void declaration
             */
            public void onBatchScanResults(@Nullable List<ScanResult> results) {
                super.onBatchScanResults(results);
                List<ScanResult> list = results;
                if (list != null) {
                    void $this$forEach$iv;
                    Iterable iterable = list;
                    RadarBeaconManager radarBeaconManager = this.$beaconManager;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        ScanResult result = (ScanResult)element$iv;
                        boolean bl = false;
                        RadarBeaconManager.access$handleScanResult(radarBeaconManager, result);
                    }
                }
            }

            public void onScanFailed(int errorCode) {
                super.onScanFailed(errorCode);
                RadarLogger.d$default(RadarBeaconManager.access$getLogger$p(this.this$0), "Scan failed", null, 2, null);
                RadarBeaconManager.access$stopRanging(this.$beaconManager);
            }
        };
        BluetoothAdapter bluetoothAdapter = this.adapter;
        if (bluetoothAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
            throw null;
        }
        bluetoothAdapter.getBluetoothLeScanner().startScan(scanFilters, scanSettings, this.scanCallback);
        this.handler.postAtTime(() -> RadarBeaconManager.rangeBeacons$lambda-3(this), (Object)TIMEOUT_TOKEN, SystemClock.uptimeMillis() + 5000L);
    }

    private final void stopRanging() {
        BluetoothAdapter bluetoothAdapter;
        if (!this.permissionsHelper.bluetoothPermissionsGranted$sdk_release(this.context)) {
            return;
        }
        if (!RadarUtils.INSTANCE.getBluetoothSupported$sdk_release(this.context)) {
            return;
        }
        if (this.adapter == null) {
            bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
            Intrinsics.checkNotNullExpressionValue((Object)bluetoothAdapter, (String)"getDefaultAdapter()");
            this.adapter = bluetoothAdapter;
        }
        RadarLogger.d$default(this.logger, "Stopping ranging", null, 2, null);
        this.handler.removeCallbacksAndMessages((Object)TIMEOUT_TOKEN);
        bluetoothAdapter = this.adapter;
        if (bluetoothAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
            throw null;
        }
        bluetoothAdapter.getBluetoothLeScanner().stopScan(this.scanCallback);
        this.scanCallback = null;
        Collection $this$toTypedArray$iv = this.nearbyBeaconIdentifiers;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        this.callCallbacks(stringArray);
        this.beacons = new RadarBeacon[0];
        this.started = false;
        this.nearbyBeaconIdentifiers.clear();
    }

    private final void handleScanResult(ScanResult result) {
        ScanRecord scanRecord;
        RadarLogger.d$default(this.logger, "Handling scan result", null, 2, null);
        ScanResult scanResult = result;
        if (scanResult != null && (scanRecord = scanResult.getScanRecord()) != null) {
            Object object = scanRecord;
            boolean bl = false;
            boolean bl2 = false;
            ScanRecord scanRecord2 = object;
            boolean bl3 = false;
            RadarBeacon radarBeacon = RadarBeaconUtils.INSTANCE.getBeacon(this.beacons, scanRecord2);
            if (radarBeacon != null) {
                object = radarBeacon;
                bl = false;
                bl2 = false;
                Object beacon = object;
                boolean bl4 = false;
                RadarLogger.d$default(this.logger, Intrinsics.stringPlus((String)"Ranged beacon | beacon._id = ", (Object)((RadarBeacon)beacon).get_id()), null, 2, null);
                this.nearbyBeaconIdentifiers.add(((RadarBeacon)beacon).get_id());
            }
        }
        if (this.nearbyBeaconIdentifiers.size() == this.beacons.length) {
            RadarLogger.d$default(this.logger, "Finished ranging", null, 2, null);
            this.stopRanging();
        }
    }

    private static final void rangeBeacons$lambda-3(RadarBeaconManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        RadarLogger.d$default(this$0.logger, "Beacon ranging timeout", null, 2, null);
        this$0.stopRanging();
    }

    public static final /* synthetic */ void access$handleScanResult(RadarBeaconManager $this, ScanResult result) {
        $this.handleScanResult(result);
    }

    public static final /* synthetic */ RadarLogger access$getLogger$p(RadarBeaconManager $this) {
        return $this.logger;
    }

    public static final /* synthetic */ void access$stopRanging(RadarBeaconManager $this) {
        $this.stopRanging();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/radar/sdk/RadarBeaconManager$Companion;", "", "()V", "TIMEOUT_TOKEN", "", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

