/*
 * Decompiled with CFR 0.152.
 */
package io.radar.sdk;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.location.Location;
import android.os.Build;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.GeofencingClient;
import com.google.android.gms.location.GeofencingRequest;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.tasks.Task;
import io.radar.sdk.Radar;
import io.radar.sdk.RadarActivityLifecycleCallbacks;
import io.radar.sdk.RadarApiClient;
import io.radar.sdk.RadarBatteryManager;
import io.radar.sdk.RadarForegroundService;
import io.radar.sdk.RadarLocationReceiver;
import io.radar.sdk.RadarLogger;
import io.radar.sdk.RadarPermissionsHelper;
import io.radar.sdk.RadarSettings;
import io.radar.sdk.RadarState;
import io.radar.sdk.RadarTrackingOptions;
import io.radar.sdk.RadarUtils;
import io.radar.sdk.model.RadarBeacon;
import io.radar.sdk.model.RadarCircleGeometry;
import io.radar.sdk.model.RadarConfig;
import io.radar.sdk.model.RadarCoordinate;
import io.radar.sdk.model.RadarEvent;
import io.radar.sdk.model.RadarGeofence;
import io.radar.sdk.model.RadarMeta;
import io.radar.sdk.model.RadarPolygonGeometry;
import io.radar.sdk.model.RadarUser;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 W2\u00020\u0001:\u0001WB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0012\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010\u000fH\u0002J\u001c\u0010+\u001a\u00020)2\u0006\u0010,\u001a\u00020-2\n\b\u0002\u0010.\u001a\u0004\u0018\u00010/H\u0002J\u0012\u00100\u001a\u00020)2\n\b\u0002\u0010*\u001a\u0004\u0018\u00010\u000fJ\"\u00100\u001a\u00020)2\u0006\u00101\u001a\u00020$2\u0006\u00102\u001a\u0002032\n\b\u0002\u0010*\u001a\u0004\u0018\u00010\u000fJ\u0015\u00104\u001a\u00020)2\u0006\u00102\u001a\u000203H\u0000\u00a2\u0006\u0002\b5J\r\u00106\u001a\u00020)H\u0000\u00a2\u0006\u0002\b7J\u0018\u00108\u001a\u00020)2\b\u0010.\u001a\u0004\u0018\u00010/2\u0006\u00102\u001a\u000203J\b\u00109\u001a\u00020)H\u0002J\b\u0010:\u001a\u00020)H\u0002J\b\u0010;\u001a\u00020)H\u0002J\u001a\u0010<\u001a\u00020)2\b\u0010.\u001a\u0004\u0018\u00010/2\u0006\u0010=\u001a\u00020\"H\u0002J\u001d\u0010>\u001a\u00020)2\u000e\u0010?\u001a\n\u0012\u0004\u0012\u00020A\u0018\u00010@H\u0002\u00a2\u0006\u0002\u0010BJ(\u0010C\u001a\u00020)2\u0006\u0010.\u001a\u00020/2\u0006\u0010=\u001a\u00020\"2\u0006\u00102\u001a\u0002032\u0006\u0010D\u001a\u00020\"H\u0002J\u0010\u0010E\u001a\u00020)2\u0006\u0010F\u001a\u00020GH\u0002J \u0010H\u001a\u00020)2\u0006\u00101\u001a\u00020$2\u0006\u0010I\u001a\u00020&2\u0006\u0010J\u001a\u00020&H\u0002J\u0010\u0010K\u001a\u00020)2\b\b\u0002\u0010L\u001a\u00020MJ\b\u0010N\u001a\u00020)H\u0002J\b\u0010O\u001a\u00020)H\u0002J\u0006\u0010P\u001a\u00020)J\u0019\u0010Q\u001a\u00020)2\n\b\u0002\u0010.\u001a\u0004\u0018\u00010/H\u0000\u00a2\u0006\u0002\bRJ\u0017\u0010S\u001a\u00020)2\b\u0010T\u001a\u0004\u0018\u00010UH\u0000\u00a2\u0006\u0002\bVR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\u000ej\b\u0012\u0004\u0012\u00020\u000f`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u00020\u00128\u0000@\u0000X\u0081\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001e\u0010\u0017\u001a\u00020\u00188\u0000@\u0000X\u0081\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006X"}, d2={"Lio/radar/sdk/RadarLocationManager;", "", "context", "Landroid/content/Context;", "apiClient", "Lio/radar/sdk/RadarApiClient;", "logger", "Lio/radar/sdk/RadarLogger;", "batteryManager", "Lio/radar/sdk/RadarBatteryManager;", "permissionsHelper", "Lio/radar/sdk/RadarPermissionsHelper;", "(Landroid/content/Context;Lio/radar/sdk/RadarApiClient;Lio/radar/sdk/RadarLogger;Lio/radar/sdk/RadarBatteryManager;Lio/radar/sdk/RadarPermissionsHelper;)V", "callbacks", "Ljava/util/ArrayList;", "Lio/radar/sdk/Radar$RadarLocationCallback;", "Lkotlin/collections/ArrayList;", "geofencingClient", "Lcom/google/android/gms/location/GeofencingClient;", "getGeofencingClient$sdk_release", "()Lcom/google/android/gms/location/GeofencingClient;", "setGeofencingClient$sdk_release", "(Lcom/google/android/gms/location/GeofencingClient;)V", "locationClient", "Lcom/google/android/gms/location/FusedLocationProviderClient;", "getLocationClient$sdk_release", "()Lcom/google/android/gms/location/FusedLocationProviderClient;", "setLocationClient$sdk_release", "(Lcom/google/android/gms/location/FusedLocationProviderClient;)V", "getPermissionsHelper$sdk_release", "()Lio/radar/sdk/RadarPermissionsHelper;", "setPermissionsHelper$sdk_release", "(Lio/radar/sdk/RadarPermissionsHelper;)V", "started", "", "startedDesiredAccuracy", "Lio/radar/sdk/RadarTrackingOptions$RadarTrackingOptionsDesiredAccuracy;", "startedFastestInterval", "", "startedInterval", "addCallback", "", "callback", "callCallbacks", "status", "Lio/radar/sdk/Radar$RadarStatus;", "location", "Landroid/location/Location;", "getLocation", "desiredAccuracy", "source", "Lio/radar/sdk/Radar$RadarLocationSource;", "handleBeacon", "handleBeacon$sdk_release", "handleBootCompleted", "handleBootCompleted$sdk_release", "handleLocation", "removeAllGeofences", "removeBubbleGeofences", "removeSyncedGeofences", "replaceBubbleGeofence", "stopped", "replaceSyncedGeofences", "radarGeofences", "", "Lio/radar/sdk/model/RadarGeofence;", "([Lio/radar/sdk/model/RadarGeofence;)V", "sendLocation", "replayed", "startForegroundService", "foregroundService", "Lio/radar/sdk/RadarTrackingOptions$RadarTrackingOptionsForegroundService;", "startLocationUpdates", "interval", "fastestInterval", "startTracking", "options", "Lio/radar/sdk/RadarTrackingOptions;", "stopForegroundService", "stopLocationUpdates", "stopTracking", "updateTracking", "updateTracking$sdk_release", "updateTrackingFromMeta", "meta", "Lio/radar/sdk/model/RadarMeta;", "updateTrackingFromMeta$sdk_release", "Companion", "sdk_release"})
@SuppressLint(value={"MissingPermission"})
public final class RadarLocationManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final RadarApiClient apiClient;
    @NotNull
    private final RadarLogger logger;
    @NotNull
    private final RadarBatteryManager batteryManager;
    @NotNull
    private RadarPermissionsHelper permissionsHelper;
    @SuppressLint(value={"VisibleForTests"})
    @NotNull
    private FusedLocationProviderClient locationClient;
    @SuppressLint(value={"VisibleForTests"})
    @NotNull
    private GeofencingClient geofencingClient;
    private boolean started;
    @NotNull
    private RadarTrackingOptions.RadarTrackingOptionsDesiredAccuracy startedDesiredAccuracy;
    private int startedInterval;
    private int startedFastestInterval;
    @NotNull
    private final ArrayList<Radar.RadarLocationCallback> callbacks;
    @NotNull
    private static final String BUBBLE_MOVING_GEOFENCE_REQUEST_ID = "radar_moving";
    @NotNull
    private static final String BUBBLE_STOPPED_GEOFENCE_REQUEST_ID = "radar_stopped";
    @NotNull
    private static final String SYNCED_GEOFENCES_REQUEST_ID_PREFIX = "radar_sync";

    public RadarLocationManager(@NotNull Context context, @NotNull RadarApiClient apiClient, @NotNull RadarLogger logger, @NotNull RadarBatteryManager batteryManager, @NotNull RadarPermissionsHelper permissionsHelper) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)apiClient, (String)"apiClient");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)batteryManager, (String)"batteryManager");
        Intrinsics.checkNotNullParameter((Object)permissionsHelper, (String)"permissionsHelper");
        this.context = context;
        this.apiClient = apiClient;
        this.logger = logger;
        this.batteryManager = batteryManager;
        this.permissionsHelper = permissionsHelper;
        this.locationClient = new FusedLocationProviderClient(this.context);
        this.geofencingClient = new GeofencingClient(this.context);
        this.startedDesiredAccuracy = RadarTrackingOptions.RadarTrackingOptionsDesiredAccuracy.NONE;
        this.callbacks = new ArrayList();
    }

    public /* synthetic */ RadarLocationManager(Context context, RadarApiClient radarApiClient, RadarLogger radarLogger, RadarBatteryManager radarBatteryManager, RadarPermissionsHelper radarPermissionsHelper, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            radarPermissionsHelper = new RadarPermissionsHelper();
        }
        this(context, radarApiClient, radarLogger, radarBatteryManager, radarPermissionsHelper);
    }

    @NotNull
    public final RadarPermissionsHelper getPermissionsHelper$sdk_release() {
        return this.permissionsHelper;
    }

    public final void setPermissionsHelper$sdk_release(@NotNull RadarPermissionsHelper radarPermissionsHelper) {
        Intrinsics.checkNotNullParameter((Object)radarPermissionsHelper, (String)"<set-?>");
        this.permissionsHelper = radarPermissionsHelper;
    }

    @NotNull
    public final FusedLocationProviderClient getLocationClient$sdk_release() {
        return this.locationClient;
    }

    public final void setLocationClient$sdk_release(@NotNull FusedLocationProviderClient fusedLocationProviderClient) {
        Intrinsics.checkNotNullParameter((Object)fusedLocationProviderClient, (String)"<set-?>");
        this.locationClient = fusedLocationProviderClient;
    }

    @NotNull
    public final GeofencingClient getGeofencingClient$sdk_release() {
        return this.geofencingClient;
    }

    public final void setGeofencingClient$sdk_release(@NotNull GeofencingClient geofencingClient) {
        Intrinsics.checkNotNullParameter((Object)geofencingClient, (String)"<set-?>");
        this.geofencingClient = geofencingClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addCallback(Radar.RadarLocationCallback callback) {
        if (callback == null) {
            return;
        }
        ArrayList<Radar.RadarLocationCallback> arrayList = this.callbacks;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (arrayList) {
            boolean bl3 = false;
            bl2 = this.callbacks.add(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void callCallbacks(Radar.RadarStatus status, Location location) {
        ArrayList<Radar.RadarLocationCallback> arrayList = this.callbacks;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (arrayList) {
            boolean bl3 = false;
            if (this.callbacks.isEmpty()) {
                return;
            }
            RadarLogger.d$default(this.logger, Intrinsics.stringPlus((String)"Calling callbacks | callbacks.size = ", (Object)this.callbacks.size()), null, 2, null);
            for (Radar.RadarLocationCallback callback : this.callbacks) {
                callback.onComplete(status, location, RadarState.INSTANCE.getStopped$sdk_release(this.context));
            }
            this.callbacks.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    static /* synthetic */ void callCallbacks$default(RadarLocationManager radarLocationManager, Radar.RadarStatus radarStatus, Location location, int n, Object object) {
        if ((n & 2) != 0) {
            location = null;
        }
        radarLocationManager.callCallbacks(radarStatus, location);
    }

    public final void getLocation(@Nullable Radar.RadarLocationCallback callback) {
        this.getLocation(RadarTrackingOptions.RadarTrackingOptionsDesiredAccuracy.MEDIUM, Radar.RadarLocationSource.FOREGROUND_LOCATION, callback);
    }

    public static /* synthetic */ void getLocation$default(RadarLocationManager radarLocationManager, Radar.RadarLocationCallback radarLocationCallback, int n, Object object) {
        if ((n & 1) != 0) {
            radarLocationCallback = null;
        }
        radarLocationManager.getLocation(radarLocationCallback);
    }

    public final void getLocation(@NotNull RadarTrackingOptions.RadarTrackingOptionsDesiredAccuracy desiredAccuracy, @NotNull Radar.RadarLocationSource source, @Nullable Radar.RadarLocationCallback callback) {
        int n;
        Intrinsics.checkNotNullParameter((Object)((Object)desiredAccuracy), (String)"desiredAccuracy");
        Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
        if (!this.permissionsHelper.fineLocationPermissionGranted$sdk_release(this.context) && !this.permissionsHelper.coarseLocationPermissionGranted$sdk_release(this.context)) {
            Radar.INSTANCE.sendError$sdk_release(Radar.RadarStatus.ERROR_PERMISSIONS);
            Radar.RadarLocationCallback radarLocationCallback = callback;
            if (radarLocationCallback != null) {
                Radar.RadarLocationCallback.DefaultImpls.onComplete$default(radarLocationCallback, Radar.RadarStatus.ERROR_PERMISSIONS, null, false, 6, null);
            }
            return;
        }
        this.addCallback(callback);
        RadarLocationManager locationManager = this;
        RadarTrackingOptions.RadarTrackingOptionsDesiredAccuracy radarTrackingOptionsDesiredAccuracy = desiredAccuracy;
        int n2 = WhenMappings.$EnumSwitchMapping$0[radarTrackingOptionsDesiredAccuracy.ordinal()];
        switch (n2) {
            case 1: {
                n = 100;
                break;
            }
            case 2: {
                n = 102;
                break;
            }
            case 3: {
                n = 104;
                break;
            }
            case 4: {
                n = 105;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        int desiredPriority = n;
        RadarLogger.d$default(this.logger, "Requesting location", null, 2, null);
        this.locationClient.getCurrentLocation(desiredPriority, null).addOnSuccessListener(arg_0 -> RadarLocationManager.getLocation$lambda-2(this, locationManager, source, arg_0)).addOnCanceledListener(() -> RadarLocationManager.getLocation$lambda-3(this));
    }

    public static /* synthetic */ void getLocation$default(RadarLocationManager radarLocationManager, RadarTrackingOptions.RadarTrackingOptionsDesiredAccuracy radarTrackingOptionsDesiredAccuracy, Radar.RadarLocationSource radarLocationSource, Radar.RadarLocationCallback radarLocationCallback, int n, Object object) {
        if ((n & 4) != 0) {
            radarLocationCallback = null;
        }
        radarLocationManager.getLocation(radarTrackingOptionsDesiredAccuracy, radarLocationSource, radarLocationCallback);
    }

    public final void startTracking(@NotNull RadarTrackingOptions options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.stopLocationUpdates();
        if (!this.permissionsHelper.fineLocationPermissionGranted$sdk_release(this.context) && !this.permissionsHelper.coarseLocationPermissionGranted$sdk_release(this.context)) {
            Radar.INSTANCE.sendError$sdk_release(Radar.RadarStatus.ERROR_PERMISSIONS);
            return;
        }
        RadarSettings.INSTANCE.setTracking$sdk_release(this.context, true);
        RadarSettings.INSTANCE.setTrackingOptions$sdk_release(this.context, options);
        RadarLocationManager.updateTracking$sdk_release$default(this, null, 1, null);
    }

    public static /* synthetic */ void startTracking$default(RadarLocationManager radarLocationManager, RadarTrackingOptions radarTrackingOptions, int n, Object object) {
        if ((n & 1) != 0) {
            radarTrackingOptions = RadarTrackingOptions.EFFICIENT;
        }
        radarLocationManager.startTracking(radarTrackingOptions);
    }

    public final void stopTracking() {
        this.started = false;
        RadarSettings.INSTANCE.setTracking$sdk_release(this.context, false);
        RadarLocationManager.updateTracking$sdk_release$default(this, null, 1, null);
    }

    private final void startLocationUpdates(RadarTrackingOptions.RadarTrackingOptionsDesiredAccuracy desiredAccuracy, int interval, int fastestInterval) {
        if (!this.started || desiredAccuracy != this.startedDesiredAccuracy || interval != this.startedInterval || fastestInterval != this.startedFastestInterval) {
            int n;
            RadarTrackingOptions.RadarTrackingOptionsDesiredAccuracy radarTrackingOptionsDesiredAccuracy = desiredAccuracy;
            int n2 = WhenMappings.$EnumSwitchMapping$0[radarTrackingOptionsDesiredAccuracy.ordinal()];
            switch (n2) {
                case 1: {
                    n = 100;
                    break;
                }
                case 2: {
                    n = 102;
                    break;
                }
                case 3: {
                    n = 104;
                    break;
                }
                default: {
                    n = 102;
                }
            }
            int priority = n;
            LocationRequest locationRequest = new LocationRequest();
            boolean bl = false;
            boolean bl2 = false;
            LocationRequest $this$startLocationUpdates_u24lambda_u2d4 = locationRequest;
            boolean bl3 = false;
            $this$startLocationUpdates_u24lambda_u2d4.setPriority(priority);
            $this$startLocationUpdates_u24lambda_u2d4.setInterval((long)interval * 1000L);
            $this$startLocationUpdates_u24lambda_u2d4.setFastestInterval((long)fastestInterval * 1000L);
            LocationRequest locationRequest2 = locationRequest;
            this.locationClient.requestLocationUpdates(locationRequest2, RadarLocationReceiver.Companion.getLocationPendingIntent$sdk_release(this.context));
            this.started = true;
            this.startedDesiredAccuracy = desiredAccuracy;
            this.startedInterval = interval;
            this.startedFastestInterval = fastestInterval;
        }
    }

    private final void stopLocationUpdates() {
        this.locationClient.removeLocationUpdates(RadarLocationReceiver.Companion.getLocationPendingIntent$sdk_release(this.context));
        this.started = false;
    }

    public final void handleBeacon$sdk_release(@NotNull Radar.RadarLocationSource source) {
        Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
        RadarLogger.d$default(this.logger, Intrinsics.stringPlus((String)"Handling beacon | source = ", (Object)((Object)source)), null, 2, null);
        RadarLocationManager.getLocation$default(this, RadarTrackingOptions.RadarTrackingOptionsDesiredAccuracy.MEDIUM, source, null, 4, null);
    }

    public final void handleBootCompleted$sdk_release() {
        RadarLogger.d$default(this.logger, "Handling boot completed", null, 2, null);
        this.started = false;
        RadarState.INSTANCE.setStopped$sdk_release(this.context, false);
        this.locationClient.getLastLocation().addOnSuccessListener(arg_0 -> RadarLocationManager.handleBootCompleted$lambda-5(this, arg_0)).addOnFailureListener(arg_0 -> RadarLocationManager.handleBootCompleted$lambda-6(this, arg_0));
    }

    /*
     * Unable to fully structure code
     */
    public final void updateTracking$sdk_release(@Nullable Location location) {
        tracking = RadarSettings.INSTANCE.getTracking$sdk_release(this.context);
        options = Radar.getTrackingOptions();
        RadarLogger.d$default(this.logger, "Updating tracking | options = " + options + "; location = " + location, null, 2, null);
        now = new Date();
        if (tracking || options.getStartTrackingAfter() == null) ** GOTO lbl-1000
        v0 = options.getStartTrackingAfter();
        Intrinsics.checkNotNull((Object)v0);
        if (v0.before(now)) {
            RadarLogger.d$default(this.logger, Intrinsics.stringPlus((String)"Starting time-based tracking | startTrackingAfter = ", (Object)options.getStartTrackingAfter()), null, 2, null);
            tracking = true;
            RadarSettings.INSTANCE.setTracking$sdk_release(this.context, true);
        } else if (tracking && options.getStopTrackingAfter() != null) {
            v1 = options.getStopTrackingAfter();
            Intrinsics.checkNotNull((Object)v1);
            if (v1.before(now)) {
                RadarLogger.d$default(this.logger, Intrinsics.stringPlus((String)"Stopping time-based tracking | startTrackingAfter = ", (Object)options.getStartTrackingAfter()), null, 2, null);
                tracking = false;
                RadarSettings.INSTANCE.setTracking$sdk_release(this.context, false);
            }
        }
        if (tracking) {
            if (options.getForegroundServiceEnabled()) {
                var6_5 = RadarSettings.INSTANCE.getForegroundService$sdk_release(this.context);
                v2 = foregroundService = var6_5 == null ? new RadarTrackingOptions.RadarTrackingOptionsForegroundService(null, null, null, false, null, null, null, null, 255, null) : var6_5;
                if (!foregroundService.getUpdatesOnly()) {
                    this.startForegroundService(foregroundService);
                }
            } else if (RadarForegroundService.Companion.getStarted$sdk_release()) {
                this.stopForegroundService();
            }
            if (stopped = RadarState.INSTANCE.getStopped$sdk_release(this.context)) {
                if (options.getDesiredStoppedUpdateInterval() == 0) {
                    this.stopLocationUpdates();
                } else {
                    this.startLocationUpdates(options.getDesiredAccuracy(), options.getDesiredStoppedUpdateInterval(), options.getFastestStoppedUpdateInterval());
                }
                if (options.getUseStoppedGeofence()) {
                    if (location != null) {
                        this.replaceBubbleGeofence(location, true);
                    }
                } else {
                    this.removeBubbleGeofences();
                }
            } else {
                if (options.getDesiredMovingUpdateInterval() == 0) {
                    this.stopLocationUpdates();
                } else {
                    this.startLocationUpdates(options.getDesiredAccuracy(), options.getDesiredMovingUpdateInterval(), options.getFastestMovingUpdateInterval());
                }
                if (options.getUseMovingGeofence() && location != null) {
                    this.replaceBubbleGeofence(location, false);
                } else {
                    this.removeBubbleGeofences();
                }
            }
        } else {
            if (RadarForegroundService.Companion.getStarted$sdk_release()) {
                this.stopForegroundService();
            }
            this.stopLocationUpdates();
            this.removeAllGeofences();
            if (Build.VERSION.SDK_INT >= 26) {
                Radar.INSTANCE.getBeaconManager$sdk_release().stopMonitoringBeacons();
            }
        }
    }

    public static /* synthetic */ void updateTracking$sdk_release$default(RadarLocationManager radarLocationManager, Location location, int n, Object object) {
        if ((n & 1) != 0) {
            location = null;
        }
        radarLocationManager.updateTracking$sdk_release(location);
    }

    public final void updateTrackingFromMeta$sdk_release(@Nullable RadarMeta meta) {
        RadarMeta radarMeta = meta;
        if ((radarMeta == null ? null : radarMeta.getRemoteTrackingOptions()) != null) {
            RadarLogger.d$default(this.logger, Intrinsics.stringPlus((String)"Setting remote tracking options | trackingOptions = ", (Object)meta.getRemoteTrackingOptions()), null, 2, null);
            RadarSettings.INSTANCE.setRemoteTrackingOptions$sdk_release(this.context, meta.getRemoteTrackingOptions());
        } else {
            RadarSettings.INSTANCE.removeRemoteTrackingOptions$sdk_release(this.context);
            RadarLogger.d$default(this.logger, Intrinsics.stringPlus((String)"Removed remote tracking options | trackingOptions = ", (Object)Radar.getTrackingOptions()), null, 2, null);
        }
        RadarLocationManager.updateTracking$sdk_release$default(this, null, 1, null);
    }

    private final void replaceBubbleGeofence(Location location, boolean stopped) {
        if (location == null) {
            return;
        }
        this.removeBubbleGeofences();
        RadarTrackingOptions options = Radar.getTrackingOptions();
        if (stopped && options.getUseStoppedGeofence()) {
            String identifier = BUBBLE_STOPPED_GEOFENCE_REQUEST_ID;
            float radius = options.getStoppedGeofenceRadius();
            Geofence geofence = new Geofence.Builder().setRequestId(identifier).setCircularRegion(location.getLatitude(), location.getLongitude(), radius).setExpirationDuration(-1L).setTransitionTypes(2).build();
            GeofencingRequest request = new GeofencingRequest.Builder().addGeofence(geofence).setInitialTrigger(2).build();
            RadarLogger.d$default(this.logger, "Adding stopped bubble geofence | latitude = " + location.getLatitude() + "; longitude = " + location.getLongitude() + "; radius = " + radius + "; identifier = " + identifier, null, 2, null);
            Task task = this.geofencingClient.addGeofences(request, RadarLocationReceiver.Companion.getBubbleGeofencePendingIntent$sdk_release(this.context));
            boolean bl = false;
            boolean bl2 = false;
            Task $this$replaceBubbleGeofence_u24lambda_u2d9 = task;
            boolean bl3 = false;
            $this$replaceBubbleGeofence_u24lambda_u2d9.addOnSuccessListener(arg_0 -> RadarLocationManager.replaceBubbleGeofence$lambda-9$lambda-7(this, arg_0));
            $this$replaceBubbleGeofence_u24lambda_u2d9.addOnFailureListener(arg_0 -> RadarLocationManager.replaceBubbleGeofence$lambda-9$lambda-8(this, arg_0));
        } else if (!stopped && options.getUseMovingGeofence()) {
            String identifier = BUBBLE_MOVING_GEOFENCE_REQUEST_ID;
            float radius = options.getMovingGeofenceRadius();
            Geofence geofence = new Geofence.Builder().setRequestId(identifier).setCircularRegion(location.getLatitude(), location.getLongitude(), radius).setExpirationDuration(-1L).setLoiteringDelay(options.getStopDuration() * 1000 + 10000).setTransitionTypes(6).build();
            GeofencingRequest request = new GeofencingRequest.Builder().addGeofence(geofence).setInitialTrigger(6).build();
            RadarLogger.d$default(this.logger, "Adding moving bubble geofence | latitude = " + location.getLatitude() + "; longitude = " + location.getLongitude() + "; radius = " + radius + "; identifier = " + identifier, null, 2, null);
            Task task = this.geofencingClient.addGeofences(request, RadarLocationReceiver.Companion.getBubbleGeofencePendingIntent$sdk_release(this.context));
            boolean bl = false;
            boolean bl4 = false;
            Task $this$replaceBubbleGeofence_u24lambda_u2d12 = task;
            boolean bl5 = false;
            $this$replaceBubbleGeofence_u24lambda_u2d12.addOnSuccessListener(arg_0 -> RadarLocationManager.replaceBubbleGeofence$lambda-12$lambda-10(this, arg_0));
            $this$replaceBubbleGeofence_u24lambda_u2d12.addOnFailureListener(arg_0 -> RadarLocationManager.replaceBubbleGeofence$lambda-12$lambda-11(this, arg_0));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void replaceSyncedGeofences(RadarGeofence[] radarGeofences) {
        this.removeSyncedGeofences();
        RadarTrackingOptions options = Radar.getTrackingOptions();
        if (!options.getSyncGeofences() || radarGeofences == null) {
            return;
        }
        boolean bl = false;
        List geofences = new ArrayList();
        RadarGeofence[] $this$forEachIndexed$iv = radarGeofences;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (RadarGeofence item$iv : $this$forEachIndexed$iv) {
            void radarGeofence;
            int n = index$iv++;
            RadarGeofence radarGeofence2 = item$iv;
            int i = n;
            boolean bl2 = false;
            RadarCoordinate center = null;
            double radius = 100.0;
            if (radarGeofence.getGeometry() instanceof RadarCircleGeometry) {
                center = ((RadarCircleGeometry)radarGeofence.getGeometry()).getCenter();
                radius = ((RadarCircleGeometry)radarGeofence.getGeometry()).getRadius();
            } else if (radarGeofence.getGeometry() instanceof RadarPolygonGeometry) {
                center = ((RadarPolygonGeometry)radarGeofence.getGeometry()).getCenter();
                radius = ((RadarPolygonGeometry)radarGeofence.getGeometry()).getRadius();
            }
            if (center == null) continue;
            try {
                String identifier = Intrinsics.stringPlus((String)"radar_sync_", (Object)i);
                Geofence geofence = new Geofence.Builder().setRequestId(identifier).setCircularRegion(center.getLatitude(), center.getLongitude(), (float)radius).setExpirationDuration(-1L).setLoiteringDelay(options.getStopDuration() * 1000 + 10000).setTransitionTypes(7).build();
                Intrinsics.checkNotNullExpressionValue((Object)geofence, (String)"geofence");
                geofences.add(geofence);
                RadarLogger.d$default(this.logger, "Adding synced geofence | latitude = " + center.getLatitude() + "; longitude = " + center.getLongitude() + "; radius = " + radius + "; identifier = " + identifier, null, 2, null);
            }
            catch (Exception e) {
                RadarLogger.d$default(this.logger, "Error building synced geofence | latitude = " + center.getLatitude() + "; longitude = " + center.getLongitude() + "; radius = " + radius, null, 2, null);
            }
        }
        if (geofences.size() == 0) {
            RadarLogger.d$default(this.logger, "No synced geofences", null, 2, null);
            return;
        }
        GeofencingRequest request = new GeofencingRequest.Builder().addGeofences(geofences).setInitialTrigger(0).build();
        Task task = this.geofencingClient.addGeofences(request, RadarLocationReceiver.Companion.getSyncedGeofencesPendingIntent$sdk_release(this.context));
        boolean bl3 = false;
        boolean bl4 = false;
        Task $this$replaceSyncedGeofences_u24lambda_u2d16 = task;
        boolean bl5 = false;
        $this$replaceSyncedGeofences_u24lambda_u2d16.addOnSuccessListener(arg_0 -> RadarLocationManager.replaceSyncedGeofences$lambda-16$lambda-14(this, arg_0));
        $this$replaceSyncedGeofences_u24lambda_u2d16.addOnFailureListener(arg_0 -> RadarLocationManager.replaceSyncedGeofences$lambda-16$lambda-15(this, arg_0));
    }

    private final void removeBubbleGeofences() {
        this.geofencingClient.removeGeofences(RadarLocationReceiver.Companion.getBubbleGeofencePendingIntent$sdk_release(this.context));
        RadarLogger.d$default(this.logger, "Removed bubble geofences", null, 2, null);
    }

    private final void removeSyncedGeofences() {
        this.geofencingClient.removeGeofences(RadarLocationReceiver.Companion.getSyncedGeofencesPendingIntent$sdk_release(this.context));
        RadarLogger.d$default(this.logger, "Removed synced geofences", null, 2, null);
    }

    private final void removeAllGeofences() {
        this.removeBubbleGeofences();
        this.removeSyncedGeofences();
    }

    /*
     * Unable to fully structure code
     */
    public final void handleLocation(@Nullable Location location, @NotNull Radar.RadarLocationSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (Radar.isTestKey$sdk_release()) {
            latency = location == null ? -1L : new Date().getTime() - location.getTime();
            standbyBucket = this.batteryManager.getAppStandbyBucket();
            batteryState = this.batteryManager.getBatteryState();
            RadarLogger.d$default(this.logger, "Handling location | location = " + location + "; latency = " + latency + "; standbyBucket = " + standbyBucket + "; performanceState = " + batteryState.getPerformanceState().name() + "; isCharging = " + batteryState.isCharging() + "; batteryPercentage = " + batteryState.getPercent() + "; isPowerSaveMode = " + batteryState.getPowerSaveMode() + "; isIgnoringBatteryOptimizations = " + batteryState.isIgnoringBatteryOptimizations() + "; locationPowerSaveMode = " + batteryState.getPowerLocationPowerSaveModeString() + "; isDozeMode = " + batteryState.isDeviceIdleMode(), null, 2, null);
        } else {
            RadarLogger.d$default(this.logger, Intrinsics.stringPlus((String)"Handling location | location = ", (Object)location), null, 2, null);
        }
        if (location == null || !RadarUtils.INSTANCE.valid$sdk_release(location)) {
            RadarLogger.d$default(this.logger, "Invalid location | source = " + (Object)source + "; location = " + location, null, 2, null);
            Radar.INSTANCE.sendError$sdk_release(Radar.RadarStatus.ERROR_LOCATION);
            RadarLocationManager.callCallbacks$default(this, Radar.RadarStatus.ERROR_LOCATION, null, 2, null);
            return;
        }
        options = Radar.getTrackingOptions();
        wasStopped = RadarState.INSTANCE.getStopped$sdk_release(this.context);
        stopped = false;
        v0 = force = source == Radar.RadarLocationSource.FOREGROUND_LOCATION || source == Radar.RadarLocationSource.MANUAL_LOCATION || source == Radar.RadarLocationSource.BEACON_ENTER;
        if (!force && location.getAccuracy() > 1000.0f && options.getDesiredAccuracy() != RadarTrackingOptions.RadarTrackingOptionsDesiredAccuracy.LOW) {
            RadarLogger.d$default(this.logger, Intrinsics.stringPlus((String)"Skipping location: inaccurate | accuracy = ", (Object)Float.valueOf(location.getAccuracy())), null, 2, null);
            this.updateTracking$sdk_release(location);
            return;
        }
        distance = 3.4028235E38f;
        duration = 0L;
        if (options.getStopDistance() > 0 && options.getStopDuration() > 0) {
            lastMovedLocation = RadarState.INSTANCE.getLastMovedLocation$sdk_release(this.context);
            if (lastMovedLocation == null) {
                lastMovedLocation = location;
                RadarState.INSTANCE.setLastMovedLocation$sdk_release(this.context, lastMovedLocation);
            }
            if ((lastMovedAt = RadarState.INSTANCE.getLastMovedAt$sdk_release(this.context)) == 0L) {
                lastMovedAt = location.getTime();
                RadarState.INSTANCE.setLastMovedAt$sdk_release(this.context, lastMovedAt);
            }
            if (!force && lastMovedAt > location.getTime()) {
                RadarLogger.d$default(this.logger, "Skipping location: old | lastMovedAt = " + lastMovedAt + "; location.time = " + location + ".time", null, 2, null);
                return;
            }
            distance = location.distanceTo(lastMovedLocation);
            duration = (location.getTime() - lastMovedAt) / (long)1000;
            stopped = distance < (float)options.getStopDistance() && duration > (long)options.getStopDuration();
            RadarLogger.d$default(this.logger, "Calculating stopped | stopped = " + stopped + "; distance = " + distance + "; duration = " + duration + "; location.time = " + location.getTime() + "; lastMovedAt = " + lastMovedAt, null, 2, null);
            if (distance > (float)options.getStopDistance()) {
                RadarState.INSTANCE.setLastMovedLocation$sdk_release(this.context, location);
                if (!stopped) {
                    RadarState.INSTANCE.setLastMovedAt$sdk_release(this.context, location.getTime());
                }
            }
        } else {
            stopped = force != false || source == Radar.RadarLocationSource.GEOFENCE_DWELL;
        }
        justStopped = stopped != false && wasStopped == false;
        RadarState.INSTANCE.setStopped$sdk_release(this.context, stopped);
        Radar.INSTANCE.sendClientLocation$sdk_release(location, stopped, source);
        if (source != Radar.RadarLocationSource.MANUAL_LOCATION) {
            this.updateTracking$sdk_release(location);
        }
        this.callCallbacks(Radar.RadarStatus.SUCCESS, location);
        sendLocation = location;
        lastFailedStoppedLocation = RadarState.INSTANCE.getLastFailedStoppedLocation$sdk_release(this.context);
        replayed = false;
        if (options.getReplay() == RadarTrackingOptions.RadarTrackingOptionsReplay.STOPS && lastFailedStoppedLocation != null && !justStopped) {
            sendLocation = lastFailedStoppedLocation;
            stopped = true;
            replayed = true;
            RadarState.INSTANCE.setLastFailedStoppedLocation$sdk_release(this.context, null);
            RadarLogger.d$default(this.logger, "Replaying location | location = " + location + "; stopped = " + stopped, null, 2, null);
        }
        if ((lastSentAt = RadarState.INSTANCE.getLastSentAt$sdk_release(this.context)) == 0L) ** GOTO lbl-1000
        var17_19 = this.callbacks;
        var18_21 = false;
        if (var17_19.size() > 0 || justStopped || replayed) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else {
            v1 = false;
        }
        ignoreSync = v1;
        now = System.currentTimeMillis();
        lastSyncInterval = (now - lastSentAt) / 1000L;
        if (!ignoreSync) {
            if (!force && stopped && wasStopped && distance < (float)options.getStopDistance() && (options.getDesiredStoppedUpdateInterval() == 0 || options.getSync() != RadarTrackingOptions.RadarTrackingOptionsSync.ALL)) {
                RadarLogger.d$default(this.logger, "Skipping sync: already stopped | stopped = " + stopped + "; wasStopped = " + wasStopped, null, 2, null);
                return;
            }
            if (lastSyncInterval < (long)options.getDesiredSyncInterval()) {
                RadarLogger.d$default(this.logger, "Skipping sync: desired sync interval | desiredSyncInterval = " + options.getDesiredSyncInterval() + "; lastSyncInterval = " + lastSyncInterval, null, 2, null);
                return;
            }
            if (!force && !justStopped && lastSyncInterval < 1L) {
                RadarLogger.d$default(this.logger, "Skipping sync: rate limit | justStopped = " + justStopped + "; lastSyncInterval = " + lastSyncInterval, null, 2, null);
                return;
            }
            if (options.getSync() == RadarTrackingOptions.RadarTrackingOptionsSync.NONE) {
                RadarLogger.d$default(this.logger, Intrinsics.stringPlus((String)"Skipping sync: sync mode | sync = ", (Object)options.getSync()), null, 2, null);
                return;
            }
            canExit = RadarState.INSTANCE.getCanExit$sdk_release(this.context);
            if (!canExit && options.getSync() == RadarTrackingOptions.RadarTrackingOptionsSync.STOPS_AND_EXITS) {
                RadarLogger.d$default(this.logger, "Skipping sync: can't exit | sync = " + (Object)options.getSync() + "; canExit = " + canExit, null, 2, null);
                return;
            }
        }
        RadarState.INSTANCE.updateLastSentAt$sdk_release(this.context);
        if (source == Radar.RadarLocationSource.FOREGROUND_LOCATION) {
            return;
        }
        this.sendLocation(sendLocation, stopped, source, replayed);
    }

    private final void sendLocation(Location location, boolean stopped, Radar.RadarLocationSource source, boolean replayed) {
        RadarTrackingOptions options = Radar.getTrackingOptions();
        RadarTrackingOptions.RadarTrackingOptionsForegroundService foregroundService = RadarSettings.INSTANCE.getForegroundService$sdk_release(this.context);
        if (foregroundService != null && foregroundService.getUpdatesOnly()) {
            this.startForegroundService(foregroundService);
        }
        RadarLogger.d$default(this.logger, "Sending location | source = " + (Object)((Object)source) + "; location = " + location + "; stopped = " + stopped + "; replayed = " + replayed, null, 2, null);
        RadarLocationManager locationManager = this;
        Function1 callTrackApi2 = (Function1)new Function1<String[], Unit>(this, location, stopped, source, replayed, locationManager, foregroundService){
            final /* synthetic */ RadarLocationManager this$0;
            final /* synthetic */ Location $location;
            final /* synthetic */ boolean $stopped;
            final /* synthetic */ Radar.RadarLocationSource $source;
            final /* synthetic */ boolean $replayed;
            final /* synthetic */ RadarLocationManager $locationManager;
            final /* synthetic */ RadarTrackingOptions.RadarTrackingOptionsForegroundService $foregroundService;
            {
                this.this$0 = $receiver;
                this.$location = $location;
                this.$stopped = $stopped;
                this.$source = $source;
                this.$replayed = $replayed;
                this.$locationManager = $locationManager;
                this.$foregroundService = $foregroundService;
                super(1);
            }

            public final void invoke(@Nullable String[] nearbyBeacons) {
                RadarLocationManager.access$getApiClient$p(this.this$0).track$sdk_release(this.$location, this.$stopped, RadarActivityLifecycleCallbacks.Companion.getForeground(), this.$source, this.$replayed, nearbyBeacons, new RadarApiClient.RadarTrackApiCallback(this.this$0, this.$locationManager, this.$foregroundService){
                    final /* synthetic */ RadarLocationManager this$0;
                    final /* synthetic */ RadarLocationManager $locationManager;
                    final /* synthetic */ RadarTrackingOptions.RadarTrackingOptionsForegroundService $foregroundService;
                    {
                        this.this$0 = $receiver;
                        this.$locationManager = $locationManager;
                        this.$foregroundService = $foregroundService;
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public void onComplete(@NotNull Radar.RadarStatus status, @Nullable JSONObject res, @Nullable RadarEvent[] events, @Nullable RadarUser user, @Nullable RadarGeofence[] nearbyGeofences, @Nullable RadarConfig config) {
                        block3: {
                            Intrinsics.checkNotNullParameter((Object)status, (String)"status");
                            if (user == null) break block3;
                            if (user.getGeofences() == null) ** GOTO lbl-1000
                            var8_7 = user.getGeofences();
                            var9_9 = false;
                            var10_10 = var8_7;
                            var11_11 = false;
                            if (var10_10.length == 0 == false) {
                                v0 = true;
                            } else lbl-1000:
                            // 2 sources

                            {
                                v0 = false;
                            }
                            inGeofences = v0;
                            atPlace = user.getPlace() != null;
                            canExit = inGeofences != false || atPlace != false;
                            RadarState.INSTANCE.setCanExit$sdk_release(RadarLocationManager.access$getContext$p(this.this$0), canExit);
                        }
                        RadarLocationManager.access$replaceSyncedGeofences(this.$locationManager, nearbyGeofences);
                        if (this.$foregroundService != null && this.$foregroundService.getUpdatesOnly()) {
                            RadarLocationManager.access$stopForegroundService(this.$locationManager);
                        }
                        this.this$0.updateTrackingFromMeta$sdk_release((var7_13 = config) == null ? null : var7_13.getMeta());
                    }
                });
            }
        };
        if (options.getBeacons() && Build.VERSION.SDK_INT >= 21 && this.permissionsHelper.bluetoothPermissionsGranted$sdk_release(this.context)) {
            Radar.INSTANCE.getApiClient$sdk_release().searchBeacons$sdk_release(location, 1000, 10, new RadarApiClient.RadarSearchBeaconsApiCallback((Function1<? super String[], Unit>)callTrackApi2){
                final /* synthetic */ Function1<String[], Unit> $callTrackApi;
                {
                    this.$callTrackApi = $callTrackApi;
                }

                public void onComplete(@NotNull Radar.RadarStatus status, @Nullable JSONObject res, @Nullable RadarBeacon[] beacons) {
                    Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
                    if (status != Radar.RadarStatus.SUCCESS || beacons == null) {
                        this.$callTrackApi.invoke(null);
                        return;
                    }
                    if (Build.VERSION.SDK_INT >= 26) {
                        Radar.INSTANCE.getBeaconManager$sdk_release().startMonitoringBeacons(beacons);
                    }
                    Radar.INSTANCE.getBeaconManager$sdk_release().rangeBeacons(beacons, new Radar.RadarBeaconCallback(this.$callTrackApi){
                        final /* synthetic */ Function1<String[], Unit> $callTrackApi;
                        {
                            this.$callTrackApi = $callTrackApi;
                        }

                        public void onComplete(@NotNull Radar.RadarStatus status, @Nullable String[] nearbyBeacons) {
                            Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
                            if (status != Radar.RadarStatus.SUCCESS || nearbyBeacons == null) {
                                this.$callTrackApi.invoke(null);
                                return;
                            }
                            this.$callTrackApi.invoke((Object)nearbyBeacons);
                        }
                    });
                }
            });
        } else {
            callTrackApi2.invoke(null);
        }
    }

    private final void startForegroundService(RadarTrackingOptions.RadarTrackingOptionsForegroundService foregroundService) {
        if (Build.VERSION.SDK_INT >= 26) {
            try {
                if (RadarForegroundService.Companion.getStarted$sdk_release()) {
                    RadarLogger.d$default(this.logger, "Already started foreground service", null, 2, null);
                } else {
                    Intent intent = new Intent(this.context, RadarForegroundService.class);
                    intent.setAction("start");
                    Integer n = foregroundService.getImportance();
                    intent.putExtra("id", (Serializable)foregroundService.getId()).putExtra("importance", n == null ? 3 : n).putExtra("title", foregroundService.getTitle()).putExtra("text", foregroundService.getText()).putExtra("icon", (Serializable)foregroundService.getIcon()).putExtra("activity", foregroundService.getActivity());
                    RadarLogger.d$default(this.logger, Intrinsics.stringPlus((String)"Starting foreground service with intent | intent = ", (Object)intent), null, 2, null);
                    this.context.getApplicationContext().startForegroundService(intent);
                    RadarForegroundService.Companion.setStarted$sdk_release(true);
                }
            }
            catch (Exception e) {
                this.logger.e("Error starting foreground service with intent", e);
            }
        }
    }

    private final void stopForegroundService() {
        if (Build.VERSION.SDK_INT >= 26) {
            try {
                Intent intent = new Intent(this.context, RadarForegroundService.class);
                intent.setAction("stop");
                RadarLogger.d$default(this.logger, "Stopping foreground service with intent", null, 2, null);
                this.context.getApplicationContext().startService(intent);
                RadarForegroundService.Companion.setStarted$sdk_release(false);
            }
            catch (Exception e) {
                this.logger.e("Error stopping foreground service with intent", e);
            }
        }
    }

    private static final void getLocation$lambda-2(RadarLocationManager this$0, RadarLocationManager $locationManager, Radar.RadarLocationSource $source, Location location) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$locationManager, (String)"$locationManager");
        Intrinsics.checkNotNullParameter((Object)((Object)$source), (String)"$source");
        if (location == null) {
            RadarLogger.d$default(this$0.logger, "Location timeout", null, 2, null);
            RadarLocationManager.callCallbacks$default(this$0, Radar.RadarStatus.ERROR_LOCATION, null, 2, null);
        } else {
            RadarLogger.d$default(this$0.logger, "Successfully requested location", null, 2, null);
            $locationManager.handleLocation(location, $source);
        }
    }

    private static final void getLocation$lambda-3(RadarLocationManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        RadarLogger.d$default(this$0.logger, "Location request canceled", null, 2, null);
        RadarLocationManager.callCallbacks$default(this$0, Radar.RadarStatus.ERROR_LOCATION, null, 2, null);
    }

    private static final void handleBootCompleted$lambda-5(RadarLocationManager this$0, Location location) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.updateTracking$sdk_release(location);
    }

    private static final void handleBootCompleted$lambda-6(RadarLocationManager this$0, Exception it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        RadarLocationManager.updateTracking$sdk_release$default(this$0, null, 1, null);
    }

    private static final void replaceBubbleGeofence$lambda-9$lambda-7(RadarLocationManager this$0, Void it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        RadarLogger.d$default(this$0.logger, "Successfully added stopped bubble geofence", null, 2, null);
    }

    private static final void replaceBubbleGeofence$lambda-9$lambda-8(RadarLocationManager this$0, Exception it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        RadarLogger.d$default(this$0.logger, Intrinsics.stringPlus((String)"Error adding stopped bubble geofence | message = ", (Object)it.getMessage()), null, 2, null);
    }

    private static final void replaceBubbleGeofence$lambda-12$lambda-10(RadarLocationManager this$0, Void it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        RadarLogger.d$default(this$0.logger, "Successfully added moving bubble geofence", null, 2, null);
    }

    private static final void replaceBubbleGeofence$lambda-12$lambda-11(RadarLocationManager this$0, Exception it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        RadarLogger.d$default(this$0.logger, Intrinsics.stringPlus((String)"Error adding moving bubble geofence | message = ", (Object)it.getMessage()), null, 2, null);
    }

    private static final void replaceSyncedGeofences$lambda-16$lambda-14(RadarLocationManager this$0, Void it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        RadarLogger.d$default(this$0.logger, "Successfully added synced geofences", null, 2, null);
    }

    private static final void replaceSyncedGeofences$lambda-16$lambda-15(RadarLocationManager this$0, Exception it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        RadarLogger.d$default(this$0.logger, Intrinsics.stringPlus((String)"Error adding synced geofences | message = ", (Object)it.getMessage()), null, 2, null);
    }

    public static final /* synthetic */ RadarApiClient access$getApiClient$p(RadarLocationManager $this) {
        return $this.apiClient;
    }

    public static final /* synthetic */ Context access$getContext$p(RadarLocationManager $this) {
        return $this.context;
    }

    public static final /* synthetic */ void access$replaceSyncedGeofences(RadarLocationManager $this, RadarGeofence[] radarGeofences) {
        $this.replaceSyncedGeofences(radarGeofences);
    }

    public static final /* synthetic */ void access$stopForegroundService(RadarLocationManager $this) {
        $this.stopForegroundService();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/radar/sdk/RadarLocationManager$Companion;", "", "()V", "BUBBLE_MOVING_GEOFENCE_REQUEST_ID", "", "BUBBLE_STOPPED_GEOFENCE_REQUEST_ID", "SYNCED_GEOFENCES_REQUEST_ID_PREFIX", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RadarTrackingOptions.RadarTrackingOptionsDesiredAccuracy.values().length];
            nArray[RadarTrackingOptions.RadarTrackingOptionsDesiredAccuracy.HIGH.ordinal()] = 1;
            nArray[RadarTrackingOptions.RadarTrackingOptionsDesiredAccuracy.MEDIUM.ordinal()] = 2;
            nArray[RadarTrackingOptions.RadarTrackingOptionsDesiredAccuracy.LOW.ordinal()] = 3;
            nArray[RadarTrackingOptions.RadarTrackingOptionsDesiredAccuracy.NONE.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

