/*
 * Decompiled with CFR 0.152.
 */
package io.radar.sdk;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanRecord;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import androidx.annotation.RequiresApi;
import io.radar.sdk.Radar;
import io.radar.sdk.RadarBeaconUtils;
import io.radar.sdk.RadarLocationReceiver;
import io.radar.sdk.RadarLogger;
import io.radar.sdk.RadarPermissionsHelper;
import io.radar.sdk.RadarUtils;
import io.radar.sdk.model.RadarBeacon;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010#\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\b\u0001\u0018\u0000 <2\u00020\u0001:\u0001<B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0003\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010\u0014H\u0002J\u001f\u0010(\u001a\u00020&2\u0010\b\u0002\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\fH\u0002\u00a2\u0006\u0002\u0010)J!\u0010*\u001a\u00020&2\b\u0010+\u001a\u0004\u0018\u00010,2\b\b\u0002\u0010-\u001a\u00020$H\u0000\u00a2\u0006\u0002\b.J\u001d\u0010/\u001a\u00020&2\u000e\u00100\u001a\n\u0012\u0004\u0012\u00020,\u0018\u000101H\u0000\u00a2\u0006\u0002\b2J#\u00103\u001a\u00020&2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\u0010'\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\u0002\u00104J#\u00105\u001a\u00020&2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\f2\b\u0010'\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\u0002\u00106J\u001b\u00107\u001a\u00020&2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0007\u00a2\u0006\u0002\u00108J\u001b\u00109\u001a\u00020&2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\fH\u0007\u00a2\u0006\u0002\u0010)J\b\u0010:\u001a\u00020&H\u0007J\b\u0010;\u001a\u00020&H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0011R2\u0010\u0012\u001a&\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00140\u0014 \u0015*\u0012\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00140\u0014\u0018\u00010\u00160\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00100\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0010\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lio/radar/sdk/RadarBeaconManager;", "", "context", "Landroid/content/Context;", "logger", "Lio/radar/sdk/RadarLogger;", "permissionsHelper", "Lio/radar/sdk/RadarPermissionsHelper;", "(Landroid/content/Context;Lio/radar/sdk/RadarLogger;Lio/radar/sdk/RadarPermissionsHelper;)V", "adapter", "Landroid/bluetooth/BluetoothAdapter;", "beaconUUIDs", "", "", "[Ljava/lang/String;", "beacons", "Lio/radar/sdk/model/RadarBeacon;", "[Lio/radar/sdk/model/RadarBeacon;", "callbacks", "", "Lio/radar/sdk/Radar$RadarBeaconCallback;", "kotlin.jvm.PlatformType", "", "handler", "Landroid/os/Handler;", "monitoredBeaconIdentifiers", "", "nearbyBeacons", "", "getPermissionsHelper$sdk_release", "()Lio/radar/sdk/RadarPermissionsHelper;", "setPermissionsHelper$sdk_release", "(Lio/radar/sdk/RadarPermissionsHelper;)V", "scanCallback", "Landroid/bluetooth/le/ScanCallback;", "started", "", "addCallback", "", "callback", "callCallbacks", "([Lio/radar/sdk/model/RadarBeacon;)V", "handleScanResult", "result", "Landroid/bluetooth/le/ScanResult;", "ranging", "handleScanResult$sdk_release", "handleScanResults", "scanResults", "Ljava/util/ArrayList;", "handleScanResults$sdk_release", "rangeBeaconUUIDs", "([Ljava/lang/String;Lio/radar/sdk/Radar$RadarBeaconCallback;)V", "rangeBeacons", "([Lio/radar/sdk/model/RadarBeacon;Lio/radar/sdk/Radar$RadarBeaconCallback;)V", "startMonitoringBeaconUUIDs", "([Ljava/lang/String;)V", "startMonitoringBeacons", "stopMonitoringBeacons", "stopRanging", "Companion", "sdk_release"})
@RequiresApi(value=21)
@SuppressLint(value={"MissingPermission"})
public final class RadarBeaconManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final RadarLogger logger;
    @NotNull
    private RadarPermissionsHelper permissionsHelper;
    private BluetoothAdapter adapter;
    private boolean started;
    private final List<Radar.RadarBeaconCallback> callbacks;
    @NotNull
    private Set<String> monitoredBeaconIdentifiers;
    @NotNull
    private Set<RadarBeacon> nearbyBeacons;
    @NotNull
    private RadarBeacon[] beacons;
    @NotNull
    private String[] beaconUUIDs;
    @Nullable
    private ScanCallback scanCallback;
    @NotNull
    private final Handler handler;
    @NotNull
    private static final String TIMEOUT_TOKEN = "timeout";

    public RadarBeaconManager(@NotNull Context context, @NotNull RadarLogger logger, @SuppressLint(value={"VisibleForTests"}) @NotNull RadarPermissionsHelper permissionsHelper) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)permissionsHelper, (String)"permissionsHelper");
        this.context = context;
        this.logger = logger;
        this.permissionsHelper = permissionsHelper;
        boolean bl = false;
        this.callbacks = Collections.synchronizedList(new ArrayList());
        bl = false;
        this.monitoredBeaconIdentifiers = SetsKt.emptySet();
        bl = false;
        this.nearbyBeacons = new LinkedHashSet();
        this.beacons = new RadarBeacon[0];
        this.beaconUUIDs = new String[0];
        this.handler = new Handler(Looper.getMainLooper());
    }

    public /* synthetic */ RadarBeaconManager(Context context, RadarLogger radarLogger, RadarPermissionsHelper radarPermissionsHelper, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            radarPermissionsHelper = new RadarPermissionsHelper();
        }
        this(context, radarLogger, radarPermissionsHelper);
    }

    @NotNull
    public final RadarPermissionsHelper getPermissionsHelper$sdk_release() {
        return this.permissionsHelper;
    }

    public final void setPermissionsHelper$sdk_release(@NotNull RadarPermissionsHelper radarPermissionsHelper) {
        Intrinsics.checkNotNullParameter((Object)radarPermissionsHelper, (String)"<set-?>");
        this.permissionsHelper = radarPermissionsHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addCallback(Radar.RadarBeaconCallback callback) {
        if (callback == null) {
            return;
        }
        List<Radar.RadarBeaconCallback> list = this.callbacks;
        Intrinsics.checkNotNullExpressionValue(list, (String)"callbacks");
        boolean bl = false;
        boolean bl2 = false;
        synchronized (list) {
            boolean bl3 = false;
            bl2 = this.callbacks.add(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void callCallbacks(RadarBeacon[] nearbyBeacons) {
        List<Radar.RadarBeaconCallback> list = this.callbacks;
        Intrinsics.checkNotNullExpressionValue(list, (String)"callbacks");
        boolean bl = false;
        boolean bl2 = false;
        synchronized (list) {
            boolean bl3 = false;
            if (this.callbacks.isEmpty()) {
                return;
            }
            RadarLogger.d$default(this.logger, Intrinsics.stringPlus((String)"Calling callbacks | callbacks.size = ", (Object)this.callbacks.size()), null, 2, null);
            for (Radar.RadarBeaconCallback callback : this.callbacks) {
                callback.onComplete(Radar.RadarStatus.SUCCESS, nearbyBeacons);
            }
            this.callbacks.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    static /* synthetic */ void callCallbacks$default(RadarBeaconManager radarBeaconManager, RadarBeacon[] radarBeaconArray, int n, Object object) {
        if ((n & 1) != 0) {
            radarBeaconArray = null;
        }
        radarBeaconManager.callCallbacks(radarBeaconArray);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresApi(value=26)
    public final void startMonitoringBeacons(@NotNull RadarBeacon[] beacons) {
        void $this$mapNotNullTo$iv$iv;
        BluetoothAdapter bluetoothAdapter;
        Intrinsics.checkNotNullParameter((Object)beacons, (String)"beacons");
        if (!this.permissionsHelper.bluetoothPermissionsGranted$sdk_release(this.context)) {
            RadarLogger.d$default(this.logger, "Bluetooth permissions not granted", null, 2, null);
            return;
        }
        if (!RadarUtils.INSTANCE.getBluetoothSupported$sdk_release(this.context)) {
            RadarLogger.d$default(this.logger, "Bluetooth not supported", null, 2, null);
            return;
        }
        if (this.adapter == null) {
            bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
            Intrinsics.checkNotNullExpressionValue((Object)bluetoothAdapter, (String)"getDefaultAdapter()");
            this.adapter = bluetoothAdapter;
        }
        if ((bluetoothAdapter = this.adapter) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
            throw null;
        }
        if (!bluetoothAdapter.isEnabled()) {
            RadarLogger.d$default(this.logger, "Bluetooth not enabled", null, 2, null);
            return;
        }
        RadarBeacon[] $this$mapNotNull$iv = beacons;
        boolean $i$f$mapNotNull22 = false;
        RadarBeacon[] radarBeaconArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        void var10_17 = $this$forEach$iv$iv$iv;
        int n = ((void)var10_17).length;
        for (int i = 0; i < n; ++i) {
            String string;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = var10_17[i];
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            if (it.get_id() == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            String it$iv$iv = string;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set newBeaconIdentifiers = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        if (Intrinsics.areEqual(this.monitoredBeaconIdentifiers, (Object)newBeaconIdentifiers)) {
            RadarLogger.i$default(this.logger, "Already monitoring beacons", null, 2, null);
            return;
        }
        this.stopMonitoringBeacons();
        $this$mapNotNull$iv = beacons;
        $i$f$mapNotNull22 = false;
        if ($this$mapNotNull$iv.length == 0) {
            RadarLogger.d$default(this.logger, "No beacons to monitor", null, 2, null);
            return;
        }
        this.monitoredBeaconIdentifiers = newBeaconIdentifiers;
        $i$f$mapNotNull22 = false;
        List scanFilters = new ArrayList();
        RadarBeacon[] $i$f$mapNotNull22 = beacons;
        int n2 = 0;
        int n3 = $i$f$mapNotNull22.length;
        while (n2 < n3) {
            RadarBeacon beacon = $i$f$mapNotNull22[n2];
            ++n2;
            ScanFilter scanFilter = null;
            try {
                RadarLogger.d$default(this.logger, Intrinsics.stringPlus((String)"Building scan filter for monitoring | _id = ", (Object)beacon.get_id()), null, 2, null);
                scanFilter = RadarBeaconUtils.INSTANCE.getScanFilter(beacon);
            }
            catch (Exception e) {
                this.logger.d(Intrinsics.stringPlus((String)"Error building scan filter for monitoring | _id = ", (Object)beacon.get_id()), e);
            }
            if (scanFilter == null) continue;
            RadarLogger.d$default(this.logger, "Starting monitoring beacon | _id = " + beacon.get_id() + "; uuid = " + beacon.getUuid() + "; major = " + beacon.getMajor() + "; minor = " + beacon.getMinor(), null, 2, null);
            scanFilters.add(scanFilter);
        }
        if (scanFilters.size() == 0) {
            RadarLogger.d$default(this.logger, "No scan filters for monitoring", null, 2, null);
            return;
        }
        try {
            ScanSettings scanSettings = new ScanSettings.Builder().setScanMode(0).setCallbackType(2).setReportDelay(30000L).setMatchMode(2).setNumOfMatches(1).build();
            RadarLogger.d$default(this.logger, "Starting monitoring beacons", null, 2, null);
            BluetoothAdapter bluetoothAdapter2 = this.adapter;
            if (bluetoothAdapter2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
                throw null;
            }
            bluetoothAdapter2.getBluetoothLeScanner().startScan(scanFilters, scanSettings, RadarLocationReceiver.Companion.getBeaconPendingIntent$sdk_release(this.context));
        }
        catch (SecurityException e) {
            this.logger.e("Error starting monitoring beacons", e);
        }
    }

    @RequiresApi(value=26)
    public final void startMonitoringBeaconUUIDs(@NotNull String[] beaconUUIDs) {
        BluetoothAdapter bluetoothAdapter;
        Intrinsics.checkNotNullParameter((Object)beaconUUIDs, (String)"beaconUUIDs");
        if (!this.permissionsHelper.bluetoothPermissionsGranted$sdk_release(this.context)) {
            RadarLogger.d$default(this.logger, "Bluetooth permissions not granted", null, 2, null);
            return;
        }
        if (!RadarUtils.INSTANCE.getBluetoothSupported$sdk_release(this.context)) {
            RadarLogger.d$default(this.logger, "Bluetooth not supported", null, 2, null);
            return;
        }
        if (this.adapter == null) {
            bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
            Intrinsics.checkNotNullExpressionValue((Object)bluetoothAdapter, (String)"getDefaultAdapter()");
            this.adapter = bluetoothAdapter;
        }
        if ((bluetoothAdapter = this.adapter) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
            throw null;
        }
        if (!bluetoothAdapter.isEnabled()) {
            RadarLogger.d$default(this.logger, "Bluetooth not enabled", null, 2, null);
            return;
        }
        Set newBeaconIdentifiers = ArraysKt.toSet((Object[])beaconUUIDs);
        if (Intrinsics.areEqual(this.monitoredBeaconIdentifiers, (Object)newBeaconIdentifiers)) {
            RadarLogger.i$default(this.logger, "Already monitoring beacons", null, 2, null);
            return;
        }
        this.stopMonitoringBeacons();
        RadarBeacon[] radarBeaconArray = this.beacons;
        boolean bl = false;
        if (radarBeaconArray.length == 0) {
            RadarLogger.d$default(this.logger, "No beacon UUIDs to monitor", null, 2, null);
            return;
        }
        this.monitoredBeaconIdentifiers = newBeaconIdentifiers;
        bl = false;
        List scanFilters = new ArrayList();
        String[] stringArray = beaconUUIDs;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String beaconUUID = stringArray[n];
            ++n;
            ScanFilter scanFilter = null;
            try {
                RadarLogger.d$default(this.logger, Intrinsics.stringPlus((String)"Building scan filter for monitoring | beaconUUID = ", (Object)beaconUUID), null, 2, null);
                scanFilter = RadarBeaconUtils.INSTANCE.getScanFilter(beaconUUID);
            }
            catch (Exception e) {
                this.logger.d(Intrinsics.stringPlus((String)"Error building scan filter for monitoring | beaconUUID = ", (Object)beaconUUID), e);
            }
            if (scanFilter == null) continue;
            RadarLogger.d$default(this.logger, Intrinsics.stringPlus((String)"Starting monitoring beacon UUID | beaconUUID = ", (Object)beaconUUID), null, 2, null);
            scanFilters.add(scanFilter);
        }
        if (scanFilters.size() == 0) {
            RadarLogger.d$default(this.logger, "No scan filters for monitoring", null, 2, null);
            return;
        }
        try {
            ScanSettings scanSettings = new ScanSettings.Builder().setScanMode(0).setCallbackType(2).setReportDelay(30000L).setMatchMode(2).setNumOfMatches(1).build();
            RadarLogger.d$default(this.logger, "Starting monitoring beacon UUIDs", null, 2, null);
            BluetoothAdapter bluetoothAdapter2 = this.adapter;
            if (bluetoothAdapter2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
                throw null;
            }
            bluetoothAdapter2.getBluetoothLeScanner().startScan(scanFilters, scanSettings, RadarLocationReceiver.Companion.getBeaconPendingIntent$sdk_release(this.context));
        }
        catch (SecurityException e) {
            this.logger.e("Error starting monitoring beacon UUIDs", e);
        }
    }

    @RequiresApi(value=26)
    public final void stopMonitoringBeacons() {
        BluetoothAdapter bluetoothAdapter;
        if (!this.permissionsHelper.bluetoothPermissionsGranted$sdk_release(this.context)) {
            return;
        }
        if (!RadarUtils.INSTANCE.getBluetoothSupported$sdk_release(this.context)) {
            return;
        }
        if (this.adapter == null) {
            bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
            Intrinsics.checkNotNullExpressionValue((Object)bluetoothAdapter, (String)"getDefaultAdapter()");
            this.adapter = bluetoothAdapter;
        }
        if ((bluetoothAdapter = this.adapter) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
            throw null;
        }
        if (!bluetoothAdapter.isEnabled()) {
            RadarLogger.d$default(this.logger, "Bluetooth not enabled", null, 2, null);
            return;
        }
        RadarLogger.d$default(this.logger, "Stopping monitoring beacons", null, 2, null);
        bluetoothAdapter = this.adapter;
        if (bluetoothAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
            throw null;
        }
        bluetoothAdapter.getBluetoothLeScanner().stopScan(RadarLocationReceiver.Companion.getBeaconPendingIntent$sdk_release(this.context));
    }

    public final void rangeBeacons(@NotNull RadarBeacon[] beacons, @Nullable Radar.RadarBeaconCallback callback) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)beacons, (String)"beacons");
        if (!this.permissionsHelper.bluetoothPermissionsGranted$sdk_release(this.context)) {
            RadarLogger.d$default(this.logger, "Bluetooth permissions not granted", null, 2, null);
            Radar.INSTANCE.sendError$sdk_release(Radar.RadarStatus.ERROR_PERMISSIONS);
            Radar.RadarBeaconCallback radarBeaconCallback = callback;
            if (radarBeaconCallback != null) {
                Radar.RadarBeaconCallback.DefaultImpls.onComplete$default(radarBeaconCallback, Radar.RadarStatus.ERROR_PERMISSIONS, null, 2, null);
            }
            return;
        }
        if (!RadarUtils.INSTANCE.getBluetoothSupported$sdk_release(this.context)) {
            RadarLogger.d$default(this.logger, "Bluetooth not supported", null, 2, null);
            Radar.INSTANCE.sendError$sdk_release(Radar.RadarStatus.ERROR_BLUETOOTH);
            Radar.RadarBeaconCallback radarBeaconCallback = callback;
            if (radarBeaconCallback != null) {
                Radar.RadarBeaconCallback.DefaultImpls.onComplete$default(radarBeaconCallback, Radar.RadarStatus.ERROR_BLUETOOTH, null, 2, null);
            }
            return;
        }
        if (this.adapter == null) {
            object = BluetoothAdapter.getDefaultAdapter();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getDefaultAdapter()");
            this.adapter = object;
        }
        if ((object = this.adapter) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
            throw null;
        }
        if (!object.isEnabled()) {
            RadarLogger.d$default(this.logger, "Bluetooth not enabled", null, 2, null);
            Radar.INSTANCE.sendError$sdk_release(Radar.RadarStatus.ERROR_BLUETOOTH);
            object = callback;
            if (object != null) {
                Radar.RadarBeaconCallback.DefaultImpls.onComplete$default((Radar.RadarBeaconCallback)object, Radar.RadarStatus.ERROR_BLUETOOTH, null, 2, null);
            }
            return;
        }
        object = beacons;
        boolean bl = false;
        if (((RadarBeacon[])object).length == 0) {
            RadarLogger.d$default(this.logger, "No beacons to range", null, 2, null);
            object = callback;
            if (object != null) {
                Radar.RadarBeaconCallback.DefaultImpls.onComplete$default((Radar.RadarBeaconCallback)object, Radar.RadarStatus.SUCCESS, null, 2, null);
            }
            return;
        }
        this.addCallback(callback);
        if (this.started) {
            RadarLogger.d$default(this.logger, "Already ranging beacons", null, 2, null);
            return;
        }
        this.beacons = beacons;
        this.started = true;
        bl = false;
        List scanFilters = new ArrayList();
        RadarBeacon[] radarBeaconArray = beacons;
        int n = 0;
        int n2 = radarBeaconArray.length;
        while (n < n2) {
            RadarBeacon beacon = radarBeaconArray[n];
            ++n;
            ScanFilter scanFilter = null;
            try {
                RadarLogger.d$default(this.logger, Intrinsics.stringPlus((String)"Building scan filter for ranging | _id = ", (Object)beacon.get_id()), null, 2, null);
                scanFilter = RadarBeaconUtils.INSTANCE.getScanFilter(beacon);
            }
            catch (Exception e) {
                this.logger.d(Intrinsics.stringPlus((String)"Error building scan filter for ranging | _id = ", (Object)beacon.get_id()), e);
            }
            if (scanFilter == null) continue;
            RadarLogger.d$default(this.logger, "Starting ranging beacon | _id = " + beacon.get_id() + "; uuid = " + beacon.getUuid() + "; major = " + beacon.getMajor() + "; minor = " + beacon.getMinor(), null, 2, null);
            scanFilters.add(scanFilter);
        }
        if (scanFilters.size() == 0) {
            RadarLogger.d$default(this.logger, "No scan filters for ranging", null, 2, null);
            RadarBeaconManager.callCallbacks$default(this, null, 1, null);
            return;
        }
        ScanSettings scanSettings = new ScanSettings.Builder().setScanMode(1).setReportDelay(0L).build();
        RadarBeaconManager beaconManager = this;
        this.scanCallback = new ScanCallback(beaconManager, this){
            final /* synthetic */ RadarBeaconManager $beaconManager;
            final /* synthetic */ RadarBeaconManager this$0;
            {
                this.$beaconManager = $beaconManager;
                this.this$0 = $receiver;
            }

            public void onScanResult(int callbackType, @Nullable ScanResult result) {
                super.onScanResult(callbackType, result);
                RadarBeaconManager.handleScanResult$sdk_release$default(this.$beaconManager, result, false, 2, null);
            }

            /*
             * WARNING - void declaration
             */
            public void onBatchScanResults(@Nullable List<ScanResult> results) {
                super.onBatchScanResults(results);
                List<ScanResult> list = results;
                if (list != null) {
                    void $this$forEach$iv;
                    Iterable iterable = list;
                    RadarBeaconManager radarBeaconManager = this.$beaconManager;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        ScanResult result = (ScanResult)element$iv;
                        boolean bl = false;
                        RadarBeaconManager.handleScanResult$sdk_release$default(radarBeaconManager, result, false, 2, null);
                    }
                }
            }

            public void onScanFailed(int errorCode) {
                super.onScanFailed(errorCode);
                RadarLogger.d$default(RadarBeaconManager.access$getLogger$p(this.this$0), "Scan failed", null, 2, null);
                RadarBeaconManager.access$stopRanging(this.$beaconManager);
            }
        };
        BluetoothAdapter bluetoothAdapter = this.adapter;
        if (bluetoothAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
            throw null;
        }
        bluetoothAdapter.getBluetoothLeScanner().startScan(scanFilters, scanSettings, this.scanCallback);
        this.handler.postAtTime(() -> RadarBeaconManager.rangeBeacons$lambda-3(this), (Object)TIMEOUT_TOKEN, SystemClock.uptimeMillis() + 5000L);
    }

    public final void rangeBeaconUUIDs(@NotNull String[] beaconUUIDs, @Nullable Radar.RadarBeaconCallback callback) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)beaconUUIDs, (String)"beaconUUIDs");
        if (!this.permissionsHelper.bluetoothPermissionsGranted$sdk_release(this.context)) {
            RadarLogger.d$default(this.logger, "Bluetooth permissions not granted", null, 2, null);
            Radar.INSTANCE.sendError$sdk_release(Radar.RadarStatus.ERROR_PERMISSIONS);
            Radar.RadarBeaconCallback radarBeaconCallback = callback;
            if (radarBeaconCallback != null) {
                Radar.RadarBeaconCallback.DefaultImpls.onComplete$default(radarBeaconCallback, Radar.RadarStatus.ERROR_PERMISSIONS, null, 2, null);
            }
            return;
        }
        if (!RadarUtils.INSTANCE.getBluetoothSupported$sdk_release(this.context)) {
            RadarLogger.d$default(this.logger, "Bluetooth not supported", null, 2, null);
            Radar.INSTANCE.sendError$sdk_release(Radar.RadarStatus.ERROR_BLUETOOTH);
            Radar.RadarBeaconCallback radarBeaconCallback = callback;
            if (radarBeaconCallback != null) {
                Radar.RadarBeaconCallback.DefaultImpls.onComplete$default(radarBeaconCallback, Radar.RadarStatus.ERROR_BLUETOOTH, null, 2, null);
            }
            return;
        }
        if (this.adapter == null) {
            object = BluetoothAdapter.getDefaultAdapter();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getDefaultAdapter()");
            this.adapter = object;
        }
        if ((object = this.adapter) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
            throw null;
        }
        if (!object.isEnabled()) {
            RadarLogger.d$default(this.logger, "Bluetooth not enabled", null, 2, null);
            Radar.INSTANCE.sendError$sdk_release(Radar.RadarStatus.ERROR_BLUETOOTH);
            object = callback;
            if (object != null) {
                Radar.RadarBeaconCallback.DefaultImpls.onComplete$default((Radar.RadarBeaconCallback)object, Radar.RadarStatus.ERROR_BLUETOOTH, null, 2, null);
            }
            return;
        }
        object = beaconUUIDs;
        boolean bl = false;
        if (((String[])object).length == 0) {
            RadarLogger.d$default(this.logger, "No UUIDs to range", null, 2, null);
            object = callback;
            if (object != null) {
                Radar.RadarBeaconCallback.DefaultImpls.onComplete$default((Radar.RadarBeaconCallback)object, Radar.RadarStatus.SUCCESS, null, 2, null);
            }
            return;
        }
        this.addCallback(callback);
        if (this.started) {
            RadarLogger.d$default(this.logger, "Already ranging beacons", null, 2, null);
            return;
        }
        this.beaconUUIDs = beaconUUIDs;
        this.started = true;
        bl = false;
        List scanFilters = new ArrayList();
        String[] stringArray = beaconUUIDs;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String beaconUUID = stringArray[n];
            ++n;
            ScanFilter scanFilter = null;
            try {
                RadarLogger.d$default(this.logger, Intrinsics.stringPlus((String)"Building scan filter for ranging | beaconUUID = ", (Object)beaconUUID), null, 2, null);
                scanFilter = RadarBeaconUtils.INSTANCE.getScanFilter(beaconUUID);
            }
            catch (Exception e) {
                this.logger.d(Intrinsics.stringPlus((String)"Error building scan filter for ranging | beaconUUID = ", (Object)beaconUUID), e);
            }
            if (scanFilter == null) continue;
            RadarLogger.d$default(this.logger, Intrinsics.stringPlus((String)"Starting ranging beacon UUID | uuid = ", (Object)beaconUUID), null, 2, null);
            scanFilters.add(scanFilter);
        }
        if (scanFilters.size() == 0) {
            RadarLogger.d$default(this.logger, "No scan filters for ranging", null, 2, null);
            RadarBeaconManager.callCallbacks$default(this, null, 1, null);
            return;
        }
        ScanSettings scanSettings = new ScanSettings.Builder().setScanMode(1).setReportDelay(0L).build();
        RadarBeaconManager beaconManager = this;
        this.scanCallback = new ScanCallback(beaconManager, this){
            final /* synthetic */ RadarBeaconManager $beaconManager;
            final /* synthetic */ RadarBeaconManager this$0;
            {
                this.$beaconManager = $beaconManager;
                this.this$0 = $receiver;
            }

            public void onScanResult(int callbackType, @Nullable ScanResult result) {
                super.onScanResult(callbackType, result);
                RadarBeaconManager.handleScanResult$sdk_release$default(this.$beaconManager, result, false, 2, null);
            }

            /*
             * WARNING - void declaration
             */
            public void onBatchScanResults(@Nullable List<ScanResult> results) {
                super.onBatchScanResults(results);
                List<ScanResult> list = results;
                if (list != null) {
                    void $this$forEach$iv;
                    Iterable iterable = list;
                    RadarBeaconManager radarBeaconManager = this.$beaconManager;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        ScanResult result = (ScanResult)element$iv;
                        boolean bl = false;
                        RadarBeaconManager.handleScanResult$sdk_release$default(radarBeaconManager, result, false, 2, null);
                    }
                }
            }

            public void onScanFailed(int errorCode) {
                super.onScanFailed(errorCode);
                RadarLogger.d$default(RadarBeaconManager.access$getLogger$p(this.this$0), "Scan failed", null, 2, null);
                RadarBeaconManager.access$stopRanging(this.$beaconManager);
            }
        };
        BluetoothAdapter bluetoothAdapter = this.adapter;
        if (bluetoothAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
            throw null;
        }
        bluetoothAdapter.getBluetoothLeScanner().startScan(scanFilters, scanSettings, this.scanCallback);
        this.handler.postAtTime(() -> RadarBeaconManager.rangeBeaconUUIDs$lambda-4(this), (Object)TIMEOUT_TOKEN, SystemClock.uptimeMillis() + 5000L);
    }

    private final void stopRanging() {
        if (!this.permissionsHelper.bluetoothPermissionsGranted$sdk_release(this.context)) {
            return;
        }
        if (!RadarUtils.INSTANCE.getBluetoothSupported$sdk_release(this.context)) {
            return;
        }
        RadarLogger.d$default(this.logger, "Stopping ranging", null, 2, null);
        this.handler.removeCallbacksAndMessages((Object)TIMEOUT_TOKEN);
        BluetoothAdapter bluetoothAdapter = this.adapter;
        if (bluetoothAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
            throw null;
        }
        bluetoothAdapter.getBluetoothLeScanner().stopScan(this.scanCallback);
        this.scanCallback = null;
        Collection $this$toTypedArray$iv = this.nearbyBeacons;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        RadarBeacon[] radarBeaconArray = thisCollection$iv.toArray(new RadarBeacon[0]);
        if (radarBeaconArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        this.callCallbacks(radarBeaconArray);
        this.beacons = new RadarBeacon[0];
        this.started = false;
        this.nearbyBeacons.clear();
    }

    public final void handleScanResults$sdk_release(@Nullable ArrayList<ScanResult> scanResults) {
        if (scanResults == null || scanResults.isEmpty()) {
            RadarLogger.d$default(this.logger, "No scan results to handle", null, 2, null);
            return;
        }
        Iterable $this$forEach$iv = scanResults;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ScanResult scanResult = (ScanResult)element$iv;
            boolean bl = false;
            this.handleScanResult$sdk_release(scanResult, false);
        }
    }

    public final void handleScanResult$sdk_release(@Nullable ScanResult result, boolean ranging) {
        ScanRecord scanRecord;
        RadarLogger.d$default(this.logger, "Handling scan result", null, 2, null);
        ScanResult scanResult = result;
        if (scanResult != null && (scanRecord = scanResult.getScanRecord()) != null) {
            Object object = scanRecord;
            boolean bl = false;
            boolean bl2 = false;
            ScanRecord scanRecord2 = object;
            boolean bl3 = false;
            RadarBeacon radarBeacon = RadarBeaconUtils.INSTANCE.getBeacon(result, scanRecord2);
            if (radarBeacon != null) {
                object = radarBeacon;
                bl = false;
                bl2 = false;
                Object beacon = object;
                boolean bl4 = false;
                RadarLogger.d$default(this.logger, "Ranged beacon | beacon.uuid = " + ((RadarBeacon)beacon).getUuid() + "; beacon.major = " + ((RadarBeacon)beacon).getMajor() + "; beacon.minor = " + ((RadarBeacon)beacon).getMinor() + "; beacon.rssi = " + ((RadarBeacon)beacon).getRssi(), null, 2, null);
                this.nearbyBeacons.add((RadarBeacon)beacon);
            }
        }
        if (this.nearbyBeacons.size() == this.beacons.length && ranging) {
            RadarLogger.d$default(this.logger, "Finished ranging", null, 2, null);
            this.stopRanging();
        }
    }

    public static /* synthetic */ void handleScanResult$sdk_release$default(RadarBeaconManager radarBeaconManager, ScanResult scanResult, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        radarBeaconManager.handleScanResult$sdk_release(scanResult, bl);
    }

    private static final void rangeBeacons$lambda-3(RadarBeaconManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        RadarLogger.d$default(this$0.logger, "Beacon ranging timeout", null, 2, null);
        this$0.stopRanging();
    }

    private static final void rangeBeaconUUIDs$lambda-4(RadarBeaconManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        RadarLogger.d$default(this$0.logger, "Beacon ranging timeout", null, 2, null);
        this$0.stopRanging();
    }

    public static final /* synthetic */ RadarLogger access$getLogger$p(RadarBeaconManager $this) {
        return $this.logger;
    }

    public static final /* synthetic */ void access$stopRanging(RadarBeaconManager $this) {
        $this.stopRanging();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/radar/sdk/RadarBeaconManager$Companion;", "", "()V", "TIMEOUT_TOKEN", "", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

