/*
 * Decompiled with CFR 0.152.
 */
package io.radar.sdk;

import io.radar.sdk.Radar;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001d\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\b\u0018\u0000 /2\u00020\u0001:\u0001/BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\"\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010#\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010$\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010%\u001a\u00020\tH\u00c6\u0003J\u000b\u0010&\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003JM\u0010'\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00c6\u0001J\u0013\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\t\u0010+\u001a\u00020,H\u00d6\u0001J\u0006\u0010-\u001a\u00020\u0005J\t\u0010.\u001a\u00020\u0003H\u00d6\u0001R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000e\"\u0004\b\u0012\u0010\u0010R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000e\"\u0004\b\u0014\u0010\u0010R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u00060"}, d2={"Lio/radar/sdk/RadarTripOptions;", "", "externalId", "", "metadata", "Lorg/json/JSONObject;", "destinationGeofenceTag", "destinationGeofenceExternalId", "mode", "Lio/radar/sdk/Radar$RadarRouteMode;", "scheduledArrivalAt", "Ljava/util/Date;", "(Ljava/lang/String;Lorg/json/JSONObject;Ljava/lang/String;Ljava/lang/String;Lio/radar/sdk/Radar$RadarRouteMode;Ljava/util/Date;)V", "getDestinationGeofenceExternalId", "()Ljava/lang/String;", "setDestinationGeofenceExternalId", "(Ljava/lang/String;)V", "getDestinationGeofenceTag", "setDestinationGeofenceTag", "getExternalId", "setExternalId", "getMetadata", "()Lorg/json/JSONObject;", "setMetadata", "(Lorg/json/JSONObject;)V", "getMode", "()Lio/radar/sdk/Radar$RadarRouteMode;", "setMode", "(Lio/radar/sdk/Radar$RadarRouteMode;)V", "getScheduledArrivalAt", "()Ljava/util/Date;", "setScheduledArrivalAt", "(Ljava/util/Date;)V", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "", "toJson", "toString", "Companion", "sdk_release"})
public final class RadarTripOptions {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String externalId;
    @Nullable
    private JSONObject metadata;
    @Nullable
    private String destinationGeofenceTag;
    @Nullable
    private String destinationGeofenceExternalId;
    @NotNull
    private Radar.RadarRouteMode mode;
    @Nullable
    private Date scheduledArrivalAt;
    @NotNull
    public static final String KEY_EXTERNAL_ID = "externalId";
    @NotNull
    public static final String KEY_METADATA = "metadata";
    @NotNull
    public static final String KEY_DESTINATION_GEOFENCE_TAG = "destinationGeofenceTag";
    @NotNull
    public static final String KEY_DESTINATION_GEOFENCE_EXTERNAL_ID = "destinationGeofenceExternalId";
    @NotNull
    public static final String KEY_MODE = "mode";
    @NotNull
    public static final String KEY_SCHEDULED_ARRIVAL_AT = "scheduledArrivalAt";

    public RadarTripOptions(@NotNull String externalId, @Nullable JSONObject metadata, @Nullable String destinationGeofenceTag, @Nullable String destinationGeofenceExternalId, @NotNull Radar.RadarRouteMode mode, @Nullable Date scheduledArrivalAt) {
        Intrinsics.checkNotNullParameter((Object)externalId, (String)KEY_EXTERNAL_ID);
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)KEY_MODE);
        this.externalId = externalId;
        this.metadata = metadata;
        this.destinationGeofenceTag = destinationGeofenceTag;
        this.destinationGeofenceExternalId = destinationGeofenceExternalId;
        this.mode = mode;
        this.scheduledArrivalAt = scheduledArrivalAt;
    }

    public /* synthetic */ RadarTripOptions(String string, JSONObject jSONObject, String string2, String string3, Radar.RadarRouteMode radarRouteMode, Date date, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            jSONObject = null;
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        if ((n & 8) != 0) {
            string3 = null;
        }
        if ((n & 0x10) != 0) {
            radarRouteMode = Radar.RadarRouteMode.CAR;
        }
        if ((n & 0x20) != 0) {
            date = null;
        }
        this(string, jSONObject, string2, string3, radarRouteMode, date);
    }

    @NotNull
    public final String getExternalId() {
        return this.externalId;
    }

    public final void setExternalId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.externalId = string;
    }

    @Nullable
    public final JSONObject getMetadata() {
        return this.metadata;
    }

    public final void setMetadata(@Nullable JSONObject jSONObject) {
        this.metadata = jSONObject;
    }

    @Nullable
    public final String getDestinationGeofenceTag() {
        return this.destinationGeofenceTag;
    }

    public final void setDestinationGeofenceTag(@Nullable String string) {
        this.destinationGeofenceTag = string;
    }

    @Nullable
    public final String getDestinationGeofenceExternalId() {
        return this.destinationGeofenceExternalId;
    }

    public final void setDestinationGeofenceExternalId(@Nullable String string) {
        this.destinationGeofenceExternalId = string;
    }

    @NotNull
    public final Radar.RadarRouteMode getMode() {
        return this.mode;
    }

    public final void setMode(@NotNull Radar.RadarRouteMode radarRouteMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)radarRouteMode), (String)"<set-?>");
        this.mode = radarRouteMode;
    }

    @Nullable
    public final Date getScheduledArrivalAt() {
        return this.scheduledArrivalAt;
    }

    public final void setScheduledArrivalAt(@Nullable Date date) {
        this.scheduledArrivalAt = date;
    }

    @NotNull
    public final JSONObject toJson() {
        JSONObject obj = new JSONObject();
        obj.put(KEY_EXTERNAL_ID, (Object)this.externalId);
        obj.put(KEY_METADATA, (Object)this.metadata);
        obj.put(KEY_DESTINATION_GEOFENCE_TAG, (Object)this.destinationGeofenceTag);
        obj.put(KEY_DESTINATION_GEOFENCE_EXTERNAL_ID, (Object)this.destinationGeofenceExternalId);
        obj.put(KEY_MODE, (Object)Radar.stringForMode(this.mode));
        Date date = this.scheduledArrivalAt;
        obj.put(KEY_SCHEDULED_ARRIVAL_AT, date == null ? null : Long.valueOf(date.getTime()));
        return obj;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        Object object;
        if (this == other) {
            return true;
        }
        if (!Intrinsics.areEqual(this.getClass(), (object = other) == null ? null : object.getClass())) {
            return false;
        }
        if (other == null) {
            throw new NullPointerException("null cannot be cast to non-null type io.radar.sdk.RadarTripOptions");
        }
        RadarTripOptions cfr_ignored_0 = (RadarTripOptions)other;
        if (!Intrinsics.areEqual((Object)this.externalId, (Object)((RadarTripOptions)other).externalId)) return false;
        object = this.metadata;
        String string = object == null ? null : object.toString();
        object = ((RadarTripOptions)other).metadata;
        if (!Intrinsics.areEqual((Object)string, (Object)(object == null ? null : object.toString()))) return false;
        if (!Intrinsics.areEqual((Object)this.destinationGeofenceTag, (Object)((RadarTripOptions)other).destinationGeofenceTag)) return false;
        if (!Intrinsics.areEqual((Object)this.destinationGeofenceExternalId, (Object)((RadarTripOptions)other).destinationGeofenceExternalId)) return false;
        if (this.mode != ((RadarTripOptions)other).mode) return false;
        object = this.scheduledArrivalAt;
        Long l = object == null ? null : Long.valueOf(((Date)object).getTime());
        object = ((RadarTripOptions)other).scheduledArrivalAt;
        if (!Intrinsics.areEqual((Object)l, object == null ? null : Long.valueOf(((Date)object).getTime()))) return false;
        return true;
    }

    @NotNull
    public final String component1() {
        return this.externalId;
    }

    @Nullable
    public final JSONObject component2() {
        return this.metadata;
    }

    @Nullable
    public final String component3() {
        return this.destinationGeofenceTag;
    }

    @Nullable
    public final String component4() {
        return this.destinationGeofenceExternalId;
    }

    @NotNull
    public final Radar.RadarRouteMode component5() {
        return this.mode;
    }

    @Nullable
    public final Date component6() {
        return this.scheduledArrivalAt;
    }

    @NotNull
    public final RadarTripOptions copy(@NotNull String externalId, @Nullable JSONObject metadata, @Nullable String destinationGeofenceTag, @Nullable String destinationGeofenceExternalId, @NotNull Radar.RadarRouteMode mode, @Nullable Date scheduledArrivalAt) {
        Intrinsics.checkNotNullParameter((Object)externalId, (String)KEY_EXTERNAL_ID);
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)KEY_MODE);
        return new RadarTripOptions(externalId, metadata, destinationGeofenceTag, destinationGeofenceExternalId, mode, scheduledArrivalAt);
    }

    public static /* synthetic */ RadarTripOptions copy$default(RadarTripOptions radarTripOptions, String string, JSONObject jSONObject, String string2, String string3, Radar.RadarRouteMode radarRouteMode, Date date, int n, Object object) {
        if ((n & 1) != 0) {
            string = radarTripOptions.externalId;
        }
        if ((n & 2) != 0) {
            jSONObject = radarTripOptions.metadata;
        }
        if ((n & 4) != 0) {
            string2 = radarTripOptions.destinationGeofenceTag;
        }
        if ((n & 8) != 0) {
            string3 = radarTripOptions.destinationGeofenceExternalId;
        }
        if ((n & 0x10) != 0) {
            radarRouteMode = radarTripOptions.mode;
        }
        if ((n & 0x20) != 0) {
            date = radarTripOptions.scheduledArrivalAt;
        }
        return radarTripOptions.copy(string, jSONObject, string2, string3, radarRouteMode, date);
    }

    @NotNull
    public String toString() {
        return "RadarTripOptions(externalId=" + this.externalId + ", metadata=" + this.metadata + ", destinationGeofenceTag=" + this.destinationGeofenceTag + ", destinationGeofenceExternalId=" + this.destinationGeofenceExternalId + ", mode=" + (Object)((Object)this.mode) + ", scheduledArrivalAt=" + this.scheduledArrivalAt + ')';
    }

    public int hashCode() {
        int result = this.externalId.hashCode();
        result = result * 31 + (this.metadata == null ? 0 : this.metadata.hashCode());
        result = result * 31 + (this.destinationGeofenceTag == null ? 0 : this.destinationGeofenceTag.hashCode());
        result = result * 31 + (this.destinationGeofenceExternalId == null ? 0 : this.destinationGeofenceExternalId.hashCode());
        result = result * 31 + this.mode.hashCode();
        result = result * 31 + (this.scheduledArrivalAt == null ? 0 : this.scheduledArrivalAt.hashCode());
        return result;
    }

    @JvmStatic
    @NotNull
    public static final RadarTripOptions fromJson(@NotNull JSONObject obj) {
        return Companion.fromJson(obj);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/radar/sdk/RadarTripOptions$Companion;", "", "()V", "KEY_DESTINATION_GEOFENCE_EXTERNAL_ID", "", "KEY_DESTINATION_GEOFENCE_TAG", "KEY_EXTERNAL_ID", "KEY_METADATA", "KEY_MODE", "KEY_SCHEDULED_ARRIVAL_AT", "fromJson", "Lio/radar/sdk/RadarTripOptions;", "obj", "Lorg/json/JSONObject;", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Unable to fully structure code
         */
        @JvmStatic
        @NotNull
        public final RadarTripOptions fromJson(@NotNull JSONObject obj) {
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            var2_2 = obj.optString("externalId");
            Intrinsics.checkNotNullExpressionValue((Object)var2_2, (String)"obj.optString(KEY_EXTERNAL_ID)");
            v0 = var2_2;
            v1 = obj.optJSONObject("metadata");
            v2 = obj.optString("destinationGeofenceTag");
            v3 = obj.optString("destinationGeofenceExternalId");
            var2_2 = obj.optString("mode");
            if (var2_2 == null) ** GOTO lbl-1000
            tmp = -1;
            switch (var2_2.hashCode()) {
                case -403236394: {
                    if (var2_2.equals("motorbike")) {
                        tmp = 1;
                    }
                    break;
                }
                case 110640223: {
                    if (var2_2.equals("truck")) {
                        tmp = 2;
                    }
                    break;
                }
                case 3148910: {
                    if (var2_2.equals("foot")) {
                        tmp = 3;
                    }
                    break;
                }
                case 3023841: {
                    if (var2_2.equals("bike")) {
                        tmp = 4;
                    }
                    break;
                }
            }
            switch (tmp) {
                case 3: {
                    v4 = Radar.RadarRouteMode.FOOT;
                    break;
                }
                case 4: {
                    v4 = Radar.RadarRouteMode.BIKE;
                    break;
                }
                case 2: {
                    v4 = Radar.RadarRouteMode.TRUCK;
                    break;
                }
                case 1: {
                    v4 = Radar.RadarRouteMode.MOTORBIKE;
                    break;
                }
                default: lbl-1000:
                // 2 sources

                {
                    v4 = Radar.RadarRouteMode.CAR;
                }
            }
            return new RadarTripOptions(v0, v1, v2, v3, v4, obj.has("scheduledArrivalAt") != false ? new Date(obj.optLong("scheduledArrivalAt")) : null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

