/*
 * Decompiled with CFR 0.152.
 */
package io.radar.sdk;

import android.annotation.SuppressLint;
import android.bluetooth.le.ScanResult;
import android.content.Context;
import android.content.Intent;
import android.location.Location;
import android.os.Build;
import io.radar.sdk.Radar;
import io.radar.sdk.RadarAbstractLocationClient;
import io.radar.sdk.RadarActivityLifecycleCallbacks;
import io.radar.sdk.RadarApiClient;
import io.radar.sdk.RadarBatteryManager;
import io.radar.sdk.RadarForegroundService;
import io.radar.sdk.RadarGoogleLocationClient;
import io.radar.sdk.RadarHuaweiLocationClient;
import io.radar.sdk.RadarLocationReceiver;
import io.radar.sdk.RadarLogger;
import io.radar.sdk.RadarPermissionsHelper;
import io.radar.sdk.RadarSettings;
import io.radar.sdk.RadarState;
import io.radar.sdk.RadarTrackingOptions;
import io.radar.sdk.RadarUtils;
import io.radar.sdk.model.RadarBeacon;
import io.radar.sdk.model.RadarCircleGeometry;
import io.radar.sdk.model.RadarConfig;
import io.radar.sdk.model.RadarCoordinate;
import io.radar.sdk.model.RadarEvent;
import io.radar.sdk.model.RadarGeofence;
import io.radar.sdk.model.RadarMeta;
import io.radar.sdk.model.RadarPolygonGeometry;
import io.radar.sdk.model.RadarUser;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 T2\u00020\u0001:\u0001TB7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0012\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u0011H\u0002J\u001c\u0010&\u001a\u00020$2\u0006\u0010'\u001a\u00020(2\n\b\u0002\u0010)\u001a\u0004\u0018\u00010*H\u0002J\u0012\u0010+\u001a\u00020$2\n\b\u0002\u0010%\u001a\u0004\u0018\u00010\u0011J\"\u0010+\u001a\u00020$2\u0006\u0010,\u001a\u00020\u001f2\u0006\u0010-\u001a\u00020.2\n\b\u0002\u0010%\u001a\u0004\u0018\u00010\u0011J\u001d\u0010/\u001a\u00020$2\u000e\u00100\u001a\n\u0012\u0004\u0012\u000201\u0018\u00010\u0010H\u0000\u00a2\u0006\u0002\b2J\r\u00103\u001a\u00020$H\u0000\u00a2\u0006\u0002\b4J\u0018\u00105\u001a\u00020$2\b\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010-\u001a\u00020.J\b\u00106\u001a\u00020$H\u0002J\b\u00107\u001a\u00020$H\u0002J\b\u00108\u001a\u00020$H\u0002J\u001a\u00109\u001a\u00020$2\b\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010:\u001a\u00020\u001dH\u0002J\u001d\u0010;\u001a\u00020$2\u000e\u0010<\u001a\n\u0012\u0004\u0012\u00020>\u0018\u00010=H\u0002\u00a2\u0006\u0002\u0010?J(\u0010@\u001a\u00020$2\u0006\u0010)\u001a\u00020*2\u0006\u0010:\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020.2\u0006\u0010A\u001a\u00020\u001dH\u0002J\u0010\u0010B\u001a\u00020$2\u0006\u0010C\u001a\u00020DH\u0002J \u0010E\u001a\u00020$2\u0006\u0010,\u001a\u00020\u001f2\u0006\u0010F\u001a\u00020!2\u0006\u0010G\u001a\u00020!H\u0002J\u0010\u0010H\u001a\u00020$2\b\b\u0002\u0010I\u001a\u00020JJ\b\u0010K\u001a\u00020$H\u0002J\b\u0010L\u001a\u00020$H\u0002J\u0006\u0010M\u001a\u00020$J\u0019\u0010N\u001a\u00020$2\n\b\u0002\u0010)\u001a\u0004\u0018\u00010*H\u0000\u00a2\u0006\u0002\bOJ\u0017\u0010P\u001a\u00020$2\b\u0010Q\u001a\u0004\u0018\u00010RH\u0000\u00a2\u0006\u0002\bSR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u00020\u00138\u0000@\u0000X\u0081\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006U"}, d2={"Lio/radar/sdk/RadarLocationManager;", "", "context", "Landroid/content/Context;", "apiClient", "Lio/radar/sdk/RadarApiClient;", "logger", "Lio/radar/sdk/RadarLogger;", "batteryManager", "Lio/radar/sdk/RadarBatteryManager;", "provider", "Lio/radar/sdk/Radar$RadarLocationServicesProvider;", "permissionsHelper", "Lio/radar/sdk/RadarPermissionsHelper;", "(Landroid/content/Context;Lio/radar/sdk/RadarApiClient;Lio/radar/sdk/RadarLogger;Lio/radar/sdk/RadarBatteryManager;Lio/radar/sdk/Radar$RadarLocationServicesProvider;Lio/radar/sdk/RadarPermissionsHelper;)V", "callbacks", "Ljava/util/ArrayList;", "Lio/radar/sdk/Radar$RadarLocationCallback;", "locationClient", "Lio/radar/sdk/RadarAbstractLocationClient;", "getLocationClient$sdk_release", "()Lio/radar/sdk/RadarAbstractLocationClient;", "setLocationClient$sdk_release", "(Lio/radar/sdk/RadarAbstractLocationClient;)V", "getPermissionsHelper$sdk_release", "()Lio/radar/sdk/RadarPermissionsHelper;", "setPermissionsHelper$sdk_release", "(Lio/radar/sdk/RadarPermissionsHelper;)V", "started", "", "startedDesiredAccuracy", "Lio/radar/sdk/RadarTrackingOptions$RadarTrackingOptionsDesiredAccuracy;", "startedFastestInterval", "", "startedInterval", "addCallback", "", "callback", "callCallbacks", "status", "Lio/radar/sdk/Radar$RadarStatus;", "location", "Landroid/location/Location;", "getLocation", "desiredAccuracy", "source", "Lio/radar/sdk/Radar$RadarLocationSource;", "handleBeacons", "scanResults", "Landroid/bluetooth/le/ScanResult;", "handleBeacons$sdk_release", "handleBootCompleted", "handleBootCompleted$sdk_release", "handleLocation", "removeAllGeofences", "removeBubbleGeofences", "removeSyncedGeofences", "replaceBubbleGeofence", "stopped", "replaceSyncedGeofences", "radarGeofences", "", "Lio/radar/sdk/model/RadarGeofence;", "([Lio/radar/sdk/model/RadarGeofence;)V", "sendLocation", "replayed", "startForegroundService", "foregroundService", "Lio/radar/sdk/RadarTrackingOptions$RadarTrackingOptionsForegroundService;", "startLocationUpdates", "interval", "fastestInterval", "startTracking", "options", "Lio/radar/sdk/RadarTrackingOptions;", "stopForegroundService", "stopLocationUpdates", "stopTracking", "updateTracking", "updateTracking$sdk_release", "updateTrackingFromMeta", "meta", "Lio/radar/sdk/model/RadarMeta;", "updateTrackingFromMeta$sdk_release", "Companion", "sdk_release"})
@SuppressLint(value={"MissingPermission"})
public final class RadarLocationManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final RadarApiClient apiClient;
    @NotNull
    private final RadarLogger logger;
    @NotNull
    private final RadarBatteryManager batteryManager;
    @NotNull
    private RadarPermissionsHelper permissionsHelper;
    @SuppressLint(value={"VisibleForTests"})
    @NotNull
    private RadarAbstractLocationClient locationClient;
    private boolean started;
    @NotNull
    private RadarTrackingOptions.RadarTrackingOptionsDesiredAccuracy startedDesiredAccuracy;
    private int startedInterval;
    private int startedFastestInterval;
    @NotNull
    private final ArrayList<Radar.RadarLocationCallback> callbacks;
    @NotNull
    private static final String BUBBLE_MOVING_GEOFENCE_REQUEST_ID = "radar_moving";
    @NotNull
    private static final String BUBBLE_STOPPED_GEOFENCE_REQUEST_ID = "radar_stopped";
    @NotNull
    private static final String SYNCED_GEOFENCES_REQUEST_ID_PREFIX = "radar_sync";

    public RadarLocationManager(@NotNull Context context, @NotNull RadarApiClient apiClient, @NotNull RadarLogger logger, @NotNull RadarBatteryManager batteryManager, @NotNull Radar.RadarLocationServicesProvider provider, @NotNull RadarPermissionsHelper permissionsHelper) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)apiClient, (String)"apiClient");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)batteryManager, (String)"batteryManager");
        Intrinsics.checkNotNullParameter((Object)((Object)provider), (String)"provider");
        Intrinsics.checkNotNullParameter((Object)permissionsHelper, (String)"permissionsHelper");
        this.context = context;
        this.apiClient = apiClient;
        this.logger = logger;
        this.batteryManager = batteryManager;
        this.permissionsHelper = permissionsHelper;
        this.locationClient = provider == Radar.RadarLocationServicesProvider.HUAWEI ? (RadarAbstractLocationClient)new RadarHuaweiLocationClient(this.context, this.logger) : (RadarAbstractLocationClient)new RadarGoogleLocationClient(this.context, this.logger);
        this.startedDesiredAccuracy = RadarTrackingOptions.RadarTrackingOptionsDesiredAccuracy.NONE;
        this.callbacks = new ArrayList();
    }

    public /* synthetic */ RadarLocationManager(Context context, RadarApiClient radarApiClient, RadarLogger radarLogger, RadarBatteryManager radarBatteryManager, Radar.RadarLocationServicesProvider radarLocationServicesProvider, RadarPermissionsHelper radarPermissionsHelper, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            radarPermissionsHelper = new RadarPermissionsHelper();
        }
        this(context, radarApiClient, radarLogger, radarBatteryManager, radarLocationServicesProvider, radarPermissionsHelper);
    }

    @NotNull
    public final RadarPermissionsHelper getPermissionsHelper$sdk_release() {
        return this.permissionsHelper;
    }

    public final void setPermissionsHelper$sdk_release(@NotNull RadarPermissionsHelper radarPermissionsHelper) {
        Intrinsics.checkNotNullParameter((Object)radarPermissionsHelper, (String)"<set-?>");
        this.permissionsHelper = radarPermissionsHelper;
    }

    @NotNull
    public final RadarAbstractLocationClient getLocationClient$sdk_release() {
        return this.locationClient;
    }

    public final void setLocationClient$sdk_release(@NotNull RadarAbstractLocationClient radarAbstractLocationClient) {
        Intrinsics.checkNotNullParameter((Object)radarAbstractLocationClient, (String)"<set-?>");
        this.locationClient = radarAbstractLocationClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addCallback(Radar.RadarLocationCallback callback) {
        if (callback == null) {
            return;
        }
        ArrayList<Radar.RadarLocationCallback> arrayList = this.callbacks;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (arrayList) {
            boolean bl3 = false;
            bl2 = this.callbacks.add(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void callCallbacks(Radar.RadarStatus status, Location location) {
        ArrayList<Radar.RadarLocationCallback> arrayList = this.callbacks;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (arrayList) {
            boolean bl3 = false;
            if (this.callbacks.isEmpty()) {
                return;
            }
            RadarLogger.d$default(this.logger, Intrinsics.stringPlus((String)"Calling callbacks | callbacks.size = ", (Object)this.callbacks.size()), null, 2, null);
            for (Radar.RadarLocationCallback callback : this.callbacks) {
                callback.onComplete(status, location, RadarState.INSTANCE.getStopped$sdk_release(this.context));
            }
            this.callbacks.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    static /* synthetic */ void callCallbacks$default(RadarLocationManager radarLocationManager, Radar.RadarStatus radarStatus, Location location, int n, Object object) {
        if ((n & 2) != 0) {
            location = null;
        }
        radarLocationManager.callCallbacks(radarStatus, location);
    }

    public final void getLocation(@Nullable Radar.RadarLocationCallback callback) {
        this.getLocation(RadarTrackingOptions.RadarTrackingOptionsDesiredAccuracy.MEDIUM, Radar.RadarLocationSource.FOREGROUND_LOCATION, callback);
    }

    public static /* synthetic */ void getLocation$default(RadarLocationManager radarLocationManager, Radar.RadarLocationCallback radarLocationCallback, int n, Object object) {
        if ((n & 1) != 0) {
            radarLocationCallback = null;
        }
        radarLocationManager.getLocation(radarLocationCallback);
    }

    public final void getLocation(@NotNull RadarTrackingOptions.RadarTrackingOptionsDesiredAccuracy desiredAccuracy, @NotNull Radar.RadarLocationSource source, @Nullable Radar.RadarLocationCallback callback) {
        Intrinsics.checkNotNullParameter((Object)((Object)desiredAccuracy), (String)"desiredAccuracy");
        Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
        if (!this.permissionsHelper.fineLocationPermissionGranted$sdk_release(this.context) && !this.permissionsHelper.coarseLocationPermissionGranted$sdk_release(this.context)) {
            Radar.INSTANCE.sendError$sdk_release(Radar.RadarStatus.ERROR_PERMISSIONS);
            Radar.RadarLocationCallback radarLocationCallback = callback;
            if (radarLocationCallback != null) {
                Radar.RadarLocationCallback.DefaultImpls.onComplete$default(radarLocationCallback, Radar.RadarStatus.ERROR_PERMISSIONS, null, false, 6, null);
            }
            return;
        }
        this.addCallback(callback);
        RadarLocationManager locationManager = this;
        RadarLogger.d$default(this.logger, "Requesting location", null, 2, null);
        this.locationClient.getCurrentLocation(desiredAccuracy, (Function1<? super Location, Unit>)((Function1)new Function1<Location, Unit>(this, locationManager, source){
            final /* synthetic */ RadarLocationManager this$0;
            final /* synthetic */ RadarLocationManager $locationManager;
            final /* synthetic */ Radar.RadarLocationSource $source;
            {
                this.this$0 = $receiver;
                this.$locationManager = $locationManager;
                this.$source = $source;
                super(1);
            }

            public final void invoke(@Nullable Location location) {
                if (location == null) {
                    RadarLogger.d$default(RadarLocationManager.access$getLogger$p(this.this$0), "Location timeout", null, 2, null);
                    RadarLocationManager.callCallbacks$default(this.this$0, Radar.RadarStatus.ERROR_LOCATION, null, 2, null);
                } else {
                    RadarLogger.d$default(RadarLocationManager.access$getLogger$p(this.this$0), "Successfully requested location", null, 2, null);
                    this.$locationManager.handleLocation(location, this.$source);
                }
            }
        }));
    }

    public static /* synthetic */ void getLocation$default(RadarLocationManager radarLocationManager, RadarTrackingOptions.RadarTrackingOptionsDesiredAccuracy radarTrackingOptionsDesiredAccuracy, Radar.RadarLocationSource radarLocationSource, Radar.RadarLocationCallback radarLocationCallback, int n, Object object) {
        if ((n & 4) != 0) {
            radarLocationCallback = null;
        }
        radarLocationManager.getLocation(radarTrackingOptionsDesiredAccuracy, radarLocationSource, radarLocationCallback);
    }

    public final void startTracking(@NotNull RadarTrackingOptions options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.stopLocationUpdates();
        if (!this.permissionsHelper.fineLocationPermissionGranted$sdk_release(this.context) && !this.permissionsHelper.coarseLocationPermissionGranted$sdk_release(this.context)) {
            Radar.INSTANCE.sendError$sdk_release(Radar.RadarStatus.ERROR_PERMISSIONS);
            return;
        }
        RadarSettings.INSTANCE.setTracking$sdk_release(this.context, true);
        RadarSettings.INSTANCE.setTrackingOptions$sdk_release(this.context, options);
        RadarLocationManager.updateTracking$sdk_release$default(this, null, 1, null);
    }

    public static /* synthetic */ void startTracking$default(RadarLocationManager radarLocationManager, RadarTrackingOptions radarTrackingOptions, int n, Object object) {
        if ((n & 1) != 0) {
            radarTrackingOptions = RadarTrackingOptions.EFFICIENT;
        }
        radarLocationManager.startTracking(radarTrackingOptions);
    }

    public final void stopTracking() {
        this.started = false;
        RadarSettings.INSTANCE.setTracking$sdk_release(this.context, false);
        RadarLocationManager.updateTracking$sdk_release$default(this, null, 1, null);
    }

    private final void startLocationUpdates(RadarTrackingOptions.RadarTrackingOptionsDesiredAccuracy desiredAccuracy, int interval, int fastestInterval) {
        if (!this.started || desiredAccuracy != this.startedDesiredAccuracy || interval != this.startedInterval || fastestInterval != this.startedFastestInterval) {
            this.locationClient.requestLocationUpdates(desiredAccuracy, interval, fastestInterval, RadarLocationReceiver.Companion.getLocationPendingIntent$sdk_release(this.context));
            this.started = true;
            this.startedDesiredAccuracy = desiredAccuracy;
            this.startedInterval = interval;
            this.startedFastestInterval = fastestInterval;
        }
    }

    private final void stopLocationUpdates() {
        this.locationClient.removeLocationUpdates(RadarLocationReceiver.Companion.getLocationPendingIntent$sdk_release(this.context));
        this.started = false;
    }

    public final void handleBeacons$sdk_release(@Nullable ArrayList<ScanResult> scanResults) {
        if (Build.VERSION.SDK_INT >= 26) {
            RadarLogger.d$default(this.logger, Intrinsics.stringPlus((String)"Handling beacons | scanResults = ", scanResults), null, 2, null);
            Radar.INSTANCE.getBeaconManager$sdk_release().handleScanResults$sdk_release(scanResults);
            Location lastLocation = RadarState.INSTANCE.getLastLocation$sdk_release(this.context);
            if (lastLocation == null) {
                RadarLogger.d$default(this.logger, "Not handling beacons, no last location", null, 2, null);
            }
            this.handleLocation(lastLocation, Radar.RadarLocationSource.BEACON_ENTER);
        }
    }

    public final void handleBootCompleted$sdk_release() {
        RadarLogger.d$default(this.logger, "Handling boot completed", null, 2, null);
        this.started = false;
        RadarState.INSTANCE.setStopped$sdk_release(this.context, false);
        this.locationClient.getLastLocation((Function1<? super Location, Unit>)((Function1)new Function1<Location, Unit>(this){
            final /* synthetic */ RadarLocationManager this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@Nullable Location location) {
                this.this$0.updateTracking$sdk_release(location);
            }
        }));
    }

    /*
     * Unable to fully structure code
     */
    public final void updateTracking$sdk_release(@Nullable Location location) {
        tracking = RadarSettings.INSTANCE.getTracking$sdk_release(this.context);
        options = Radar.getTrackingOptions();
        RadarLogger.d$default(this.logger, "Updating tracking | options = " + options + "; location = " + location, null, 2, null);
        now = new Date();
        if (tracking || options.getStartTrackingAfter() == null) ** GOTO lbl-1000
        v0 = options.getStartTrackingAfter();
        Intrinsics.checkNotNull((Object)v0);
        if (v0.before(now)) {
            RadarLogger.d$default(this.logger, Intrinsics.stringPlus((String)"Starting time-based tracking | startTrackingAfter = ", (Object)options.getStartTrackingAfter()), null, 2, null);
            tracking = true;
            RadarSettings.INSTANCE.setTracking$sdk_release(this.context, true);
        } else if (tracking && options.getStopTrackingAfter() != null) {
            v1 = options.getStopTrackingAfter();
            Intrinsics.checkNotNull((Object)v1);
            if (v1.before(now)) {
                RadarLogger.d$default(this.logger, Intrinsics.stringPlus((String)"Stopping time-based tracking | startTrackingAfter = ", (Object)options.getStartTrackingAfter()), null, 2, null);
                tracking = false;
                RadarSettings.INSTANCE.setTracking$sdk_release(this.context, false);
            }
        }
        if (tracking) {
            if (options.getForegroundServiceEnabled()) {
                var6_5 = RadarSettings.INSTANCE.getForegroundService$sdk_release(this.context);
                v2 = foregroundService = var6_5 == null ? new RadarTrackingOptions.RadarTrackingOptionsForegroundService(null, null, null, false, null, null, null, null, 255, null) : var6_5;
                if (!foregroundService.getUpdatesOnly()) {
                    this.startForegroundService(foregroundService);
                }
            } else if (RadarForegroundService.Companion.getStarted$sdk_release()) {
                this.stopForegroundService();
            }
            if (stopped = RadarState.INSTANCE.getStopped$sdk_release(this.context)) {
                if (options.getDesiredStoppedUpdateInterval() == 0) {
                    this.stopLocationUpdates();
                } else {
                    this.startLocationUpdates(options.getDesiredAccuracy(), options.getDesiredStoppedUpdateInterval(), options.getFastestStoppedUpdateInterval());
                }
                if (options.getUseStoppedGeofence()) {
                    if (location != null) {
                        this.replaceBubbleGeofence(location, true);
                    }
                } else {
                    this.removeBubbleGeofences();
                }
            } else {
                if (options.getDesiredMovingUpdateInterval() == 0) {
                    this.stopLocationUpdates();
                } else {
                    this.startLocationUpdates(options.getDesiredAccuracy(), options.getDesiredMovingUpdateInterval(), options.getFastestMovingUpdateInterval());
                }
                if (options.getUseMovingGeofence() && location != null) {
                    this.replaceBubbleGeofence(location, false);
                } else {
                    this.removeBubbleGeofences();
                }
            }
        } else {
            if (RadarForegroundService.Companion.getStarted$sdk_release()) {
                this.stopForegroundService();
            }
            this.stopLocationUpdates();
            this.removeAllGeofences();
            if (Build.VERSION.SDK_INT >= 26) {
                Radar.INSTANCE.getBeaconManager$sdk_release().stopMonitoringBeacons();
            }
        }
    }

    public static /* synthetic */ void updateTracking$sdk_release$default(RadarLocationManager radarLocationManager, Location location, int n, Object object) {
        if ((n & 1) != 0) {
            location = null;
        }
        radarLocationManager.updateTracking$sdk_release(location);
    }

    public final void updateTrackingFromMeta$sdk_release(@Nullable RadarMeta meta) {
        RadarMeta radarMeta = meta;
        if ((radarMeta == null ? null : radarMeta.getRemoteTrackingOptions()) != null) {
            RadarLogger.d$default(this.logger, Intrinsics.stringPlus((String)"Setting remote tracking options | trackingOptions = ", (Object)meta.getRemoteTrackingOptions()), null, 2, null);
            RadarSettings.INSTANCE.setRemoteTrackingOptions$sdk_release(this.context, meta.getRemoteTrackingOptions());
        } else {
            RadarSettings.INSTANCE.removeRemoteTrackingOptions$sdk_release(this.context);
            RadarLogger.d$default(this.logger, Intrinsics.stringPlus((String)"Removed remote tracking options | trackingOptions = ", (Object)Radar.getTrackingOptions()), null, 2, null);
        }
        RadarLocationManager.updateTracking$sdk_release$default(this, null, 1, null);
    }

    private final void replaceBubbleGeofence(Location location, boolean stopped) {
        if (location == null) {
            return;
        }
        this.removeBubbleGeofences();
        RadarTrackingOptions options = Radar.getTrackingOptions();
        if (stopped && options.getUseStoppedGeofence()) {
            String identifier = BUBBLE_STOPPED_GEOFENCE_REQUEST_ID;
            float radius = options.getStoppedGeofenceRadius();
            RadarAbstractLocationClient.RadarAbstractGeofence geofence = new RadarAbstractLocationClient.RadarAbstractGeofence(identifier, location.getLatitude(), location.getLongitude(), radius, false, true, false, 0, 208, null);
            RadarAbstractLocationClient.RadarAbstractGeofence[] radarAbstractGeofenceArray = new RadarAbstractLocationClient.RadarAbstractGeofence[]{geofence};
            RadarAbstractLocationClient.RadarAbstractGeofence[] geofences = radarAbstractGeofenceArray;
            RadarAbstractLocationClient.RadarAbstractGeofenceRequest request = new RadarAbstractLocationClient.RadarAbstractGeofenceRequest(false, true, false, 5, null);
            RadarLogger.d$default(this.logger, "Adding stopped bubble geofence | latitude = " + location.getLatitude() + "; longitude = " + location.getLongitude() + "; radius = " + radius + "; identifier = " + identifier, null, 2, null);
            this.locationClient.addGeofences(geofences, request, RadarLocationReceiver.Companion.getBubbleGeofencePendingIntent$sdk_release(this.context), (Function1<? super Boolean, Unit>)((Function1)new Function1<Boolean, Unit>(this){
                final /* synthetic */ RadarLocationManager this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(boolean success) {
                    if (success) {
                        RadarLogger.d$default(RadarLocationManager.access$getLogger$p(this.this$0), "Successfully added stopped bubble geofence", null, 2, null);
                    } else {
                        RadarLogger.d$default(RadarLocationManager.access$getLogger$p(this.this$0), "Error adding stopped bubble geofence", null, 2, null);
                    }
                }
            }));
        } else if (!stopped && options.getUseMovingGeofence()) {
            String identifier = BUBBLE_MOVING_GEOFENCE_REQUEST_ID;
            float radius = options.getMovingGeofenceRadius();
            RadarAbstractLocationClient.RadarAbstractGeofence geofence = new RadarAbstractLocationClient.RadarAbstractGeofence(identifier, location.getLatitude(), location.getLongitude(), radius, false, true, true, options.getStopDuration() * 1000 + 10000, 16, null);
            RadarAbstractLocationClient.RadarAbstractGeofenceRequest geofenceRequest = new RadarAbstractLocationClient.RadarAbstractGeofenceRequest(false, true, true, 1, null);
            RadarAbstractLocationClient.RadarAbstractGeofence[] radarAbstractGeofenceArray = new RadarAbstractLocationClient.RadarAbstractGeofence[]{geofence};
            RadarAbstractLocationClient.RadarAbstractGeofence[] geofences = radarAbstractGeofenceArray;
            RadarLogger.d$default(this.logger, "Adding moving bubble geofence | latitude = " + location.getLatitude() + "; longitude = " + location.getLongitude() + "; radius = " + radius + "; identifier = " + identifier, null, 2, null);
            this.locationClient.addGeofences(geofences, geofenceRequest, RadarLocationReceiver.Companion.getBubbleGeofencePendingIntent$sdk_release(this.context), (Function1<? super Boolean, Unit>)((Function1)new Function1<Boolean, Unit>(this){
                final /* synthetic */ RadarLocationManager this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(boolean success) {
                    if (success) {
                        RadarLogger.d$default(RadarLocationManager.access$getLogger$p(this.this$0), "Successfully added moving bubble geofence", null, 2, null);
                    } else {
                        RadarLogger.d$default(RadarLocationManager.access$getLogger$p(this.this$0), "Error adding moving bubble geofence", null, 2, null);
                    }
                }
            }));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void replaceSyncedGeofences(RadarGeofence[] radarGeofences) {
        this.removeSyncedGeofences();
        RadarTrackingOptions options = Radar.getTrackingOptions();
        if (!options.getSyncGeofences() || radarGeofences == null) {
            return;
        }
        boolean bl = false;
        List geofences = new ArrayList();
        RadarGeofence[] $this$forEachIndexed$iv = radarGeofences;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (RadarGeofence item$iv : $this$forEachIndexed$iv) {
            void radarGeofence;
            int n = index$iv++;
            RadarGeofence radarGeofence2 = item$iv;
            int i = n;
            boolean bl2 = false;
            RadarCoordinate center = null;
            double radius = 100.0;
            if (radarGeofence.getGeometry() instanceof RadarCircleGeometry) {
                center = ((RadarCircleGeometry)radarGeofence.getGeometry()).getCenter();
                radius = ((RadarCircleGeometry)radarGeofence.getGeometry()).getRadius();
            } else if (radarGeofence.getGeometry() instanceof RadarPolygonGeometry) {
                center = ((RadarPolygonGeometry)radarGeofence.getGeometry()).getCenter();
                radius = ((RadarPolygonGeometry)radarGeofence.getGeometry()).getRadius();
            }
            if (center == null) continue;
            try {
                String identifier = Intrinsics.stringPlus((String)"radar_sync_", (Object)i);
                RadarAbstractLocationClient.RadarAbstractGeofence geofence = new RadarAbstractLocationClient.RadarAbstractGeofence(identifier, center.getLatitude(), center.getLongitude(), (float)radius, true, true, true, options.getStopDuration() * 1000 + 10000);
                geofences.add(geofence);
                RadarLogger.d$default(this.logger, "Adding synced geofence | latitude = " + center.getLatitude() + "; longitude = " + center.getLongitude() + "; radius = " + radius + "; identifier = " + identifier, null, 2, null);
            }
            catch (Exception e) {
                RadarLogger.d$default(this.logger, "Error building synced geofence | latitude = " + center.getLatitude() + "; longitude = " + center.getLongitude() + "; radius = " + radius, null, 2, null);
            }
        }
        if (geofences.size() == 0) {
            RadarLogger.d$default(this.logger, "No synced geofences", null, 2, null);
            return;
        }
        RadarAbstractLocationClient.RadarAbstractGeofenceRequest request = new RadarAbstractLocationClient.RadarAbstractGeofenceRequest(false, false, false, 7, null);
        Collection $this$toTypedArray$iv = geofences;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        RadarAbstractLocationClient.RadarAbstractGeofence[] radarAbstractGeofenceArray = thisCollection$iv.toArray(new RadarAbstractLocationClient.RadarAbstractGeofence[0]);
        if (radarAbstractGeofenceArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        this.locationClient.addGeofences(radarAbstractGeofenceArray, request, RadarLocationReceiver.Companion.getSyncedGeofencesPendingIntent$sdk_release(this.context), (Function1<? super Boolean, Unit>)((Function1)new Function1<Boolean, Unit>(this){
            final /* synthetic */ RadarLocationManager this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(boolean success) {
                if (success) {
                    RadarLogger.d$default(RadarLocationManager.access$getLogger$p(this.this$0), "Successfully added synced geofences", null, 2, null);
                } else {
                    RadarLogger.d$default(RadarLocationManager.access$getLogger$p(this.this$0), "Error adding synced geofences", null, 2, null);
                }
            }
        }));
    }

    private final void removeBubbleGeofences() {
        this.locationClient.removeGeofences(RadarLocationReceiver.Companion.getBubbleGeofencePendingIntent$sdk_release(this.context));
        RadarLogger.d$default(this.logger, "Removed bubble geofences", null, 2, null);
    }

    private final void removeSyncedGeofences() {
        this.locationClient.removeGeofences(RadarLocationReceiver.Companion.getSyncedGeofencesPendingIntent$sdk_release(this.context));
        RadarLogger.d$default(this.logger, "Removed synced geofences", null, 2, null);
    }

    private final void removeAllGeofences() {
        this.removeBubbleGeofences();
        this.removeSyncedGeofences();
    }

    /*
     * Unable to fully structure code
     */
    public final void handleLocation(@Nullable Location location, @NotNull Radar.RadarLocationSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (Radar.isTestKey$sdk_release()) {
            latency = location == null ? -1L : new Date().getTime() - location.getTime();
            standbyBucket = this.batteryManager.getAppStandbyBucket();
            batteryState = this.batteryManager.getBatteryState();
            RadarLogger.d$default(this.logger, "Handling location | location = " + location + "; latency = " + latency + "; standbyBucket = " + standbyBucket + "; performanceState = " + batteryState.getPerformanceState().name() + "; isCharging = " + batteryState.isCharging() + "; batteryPercentage = " + batteryState.getPercent() + "; isPowerSaveMode = " + batteryState.getPowerSaveMode() + "; isIgnoringBatteryOptimizations = " + batteryState.isIgnoringBatteryOptimizations() + "; locationPowerSaveMode = " + batteryState.getPowerLocationPowerSaveModeString() + "; isDozeMode = " + batteryState.isDeviceIdleMode(), null, 2, null);
        } else {
            RadarLogger.d$default(this.logger, Intrinsics.stringPlus((String)"Handling location | location = ", (Object)location), null, 2, null);
        }
        if (location == null || !RadarUtils.INSTANCE.valid$sdk_release(location)) {
            RadarLogger.d$default(this.logger, "Invalid location | source = " + (Object)source + "; location = " + location, null, 2, null);
            Radar.INSTANCE.sendError$sdk_release(Radar.RadarStatus.ERROR_LOCATION);
            RadarLocationManager.callCallbacks$default(this, Radar.RadarStatus.ERROR_LOCATION, null, 2, null);
            return;
        }
        options = Radar.getTrackingOptions();
        wasStopped = RadarState.INSTANCE.getStopped$sdk_release(this.context);
        stopped = false;
        v0 = force = source == Radar.RadarLocationSource.FOREGROUND_LOCATION || source == Radar.RadarLocationSource.MANUAL_LOCATION || source == Radar.RadarLocationSource.BEACON_ENTER;
        if (!force && location.getAccuracy() > 1000.0f && options.getDesiredAccuracy() != RadarTrackingOptions.RadarTrackingOptionsDesiredAccuracy.LOW) {
            RadarLogger.d$default(this.logger, Intrinsics.stringPlus((String)"Skipping location: inaccurate | accuracy = ", (Object)Float.valueOf(location.getAccuracy())), null, 2, null);
            this.updateTracking$sdk_release(location);
            return;
        }
        distance = 3.4028235E38f;
        duration = 0L;
        if (options.getStopDistance() > 0 && options.getStopDuration() > 0) {
            lastMovedLocation = RadarState.INSTANCE.getLastMovedLocation$sdk_release(this.context);
            if (lastMovedLocation == null) {
                lastMovedLocation = location;
                RadarState.INSTANCE.setLastMovedLocation$sdk_release(this.context, lastMovedLocation);
            }
            if ((lastMovedAt = RadarState.INSTANCE.getLastMovedAt$sdk_release(this.context)) == 0L) {
                lastMovedAt = location.getTime();
                RadarState.INSTANCE.setLastMovedAt$sdk_release(this.context, lastMovedAt);
            }
            if (!force && lastMovedAt > location.getTime()) {
                RadarLogger.d$default(this.logger, "Skipping location: old | lastMovedAt = " + lastMovedAt + "; location.time = " + location + ".time", null, 2, null);
                return;
            }
            distance = location.distanceTo(lastMovedLocation);
            duration = (location.getTime() - lastMovedAt) / (long)1000;
            stopped = distance < (float)options.getStopDistance() && duration > (long)options.getStopDuration();
            RadarLogger.d$default(this.logger, "Calculating stopped | stopped = " + stopped + "; distance = " + distance + "; duration = " + duration + "; location.time = " + location.getTime() + "; lastMovedAt = " + lastMovedAt, null, 2, null);
            if (distance > (float)options.getStopDistance()) {
                RadarState.INSTANCE.setLastMovedLocation$sdk_release(this.context, location);
                if (!stopped) {
                    RadarState.INSTANCE.setLastMovedAt$sdk_release(this.context, location.getTime());
                }
            }
        } else {
            stopped = force != false || source == Radar.RadarLocationSource.GEOFENCE_DWELL;
        }
        justStopped = stopped != false && wasStopped == false;
        RadarState.INSTANCE.setStopped$sdk_release(this.context, stopped);
        RadarState.INSTANCE.setLastLocation$sdk_release(this.context, location);
        Radar.INSTANCE.sendClientLocation$sdk_release(location, stopped, source);
        if (source != Radar.RadarLocationSource.MANUAL_LOCATION) {
            this.updateTracking$sdk_release(location);
        }
        this.callCallbacks(Radar.RadarStatus.SUCCESS, location);
        sendLocation = location;
        lastFailedStoppedLocation = RadarState.INSTANCE.getLastFailedStoppedLocation$sdk_release(this.context);
        replayed = false;
        if (options.getReplay() == RadarTrackingOptions.RadarTrackingOptionsReplay.STOPS && lastFailedStoppedLocation != null && !justStopped) {
            sendLocation = lastFailedStoppedLocation;
            stopped = true;
            replayed = true;
            RadarState.INSTANCE.setLastFailedStoppedLocation$sdk_release(this.context, null);
            RadarLogger.d$default(this.logger, "Replaying location | location = " + location + "; stopped = " + stopped, null, 2, null);
        }
        if ((lastSentAt = RadarState.INSTANCE.getLastSentAt$sdk_release(this.context)) == 0L) ** GOTO lbl-1000
        var17_19 = this.callbacks;
        var18_21 = false;
        if (var17_19.size() > 0 || justStopped || replayed) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else {
            v1 = false;
        }
        ignoreSync = v1;
        now = System.currentTimeMillis();
        lastSyncInterval = (now - lastSentAt) / 1000L;
        if (!ignoreSync) {
            if (!force && stopped && wasStopped && distance < (float)options.getStopDistance() && (options.getDesiredStoppedUpdateInterval() == 0 || options.getSync() != RadarTrackingOptions.RadarTrackingOptionsSync.ALL)) {
                RadarLogger.d$default(this.logger, "Skipping sync: already stopped | stopped = " + stopped + "; wasStopped = " + wasStopped, null, 2, null);
                return;
            }
            if (lastSyncInterval < (long)options.getDesiredSyncInterval()) {
                RadarLogger.d$default(this.logger, "Skipping sync: desired sync interval | desiredSyncInterval = " + options.getDesiredSyncInterval() + "; lastSyncInterval = " + lastSyncInterval, null, 2, null);
                return;
            }
            if (!force && !justStopped && lastSyncInterval < 1L) {
                RadarLogger.d$default(this.logger, "Skipping sync: rate limit | justStopped = " + justStopped + "; lastSyncInterval = " + lastSyncInterval, null, 2, null);
                return;
            }
            if (options.getSync() == RadarTrackingOptions.RadarTrackingOptionsSync.NONE) {
                RadarLogger.d$default(this.logger, Intrinsics.stringPlus((String)"Skipping sync: sync mode | sync = ", (Object)options.getSync()), null, 2, null);
                return;
            }
            canExit = RadarState.INSTANCE.getCanExit$sdk_release(this.context);
            if (!canExit && options.getSync() == RadarTrackingOptions.RadarTrackingOptionsSync.STOPS_AND_EXITS) {
                RadarLogger.d$default(this.logger, "Skipping sync: can't exit | sync = " + (Object)options.getSync() + "; canExit = " + canExit, null, 2, null);
                return;
            }
        }
        RadarState.INSTANCE.updateLastSentAt$sdk_release(this.context);
        if (source == Radar.RadarLocationSource.FOREGROUND_LOCATION) {
            return;
        }
        this.sendLocation(sendLocation, stopped, source, replayed);
    }

    private final void sendLocation(Location location, boolean stopped, Radar.RadarLocationSource source, boolean replayed) {
        RadarTrackingOptions options = Radar.getTrackingOptions();
        RadarTrackingOptions.RadarTrackingOptionsForegroundService foregroundService = RadarSettings.INSTANCE.getForegroundService$sdk_release(this.context);
        if (foregroundService != null && foregroundService.getUpdatesOnly()) {
            this.startForegroundService(foregroundService);
        }
        RadarLogger.d$default(this.logger, "Sending location | source = " + (Object)((Object)source) + "; location = " + location + "; stopped = " + stopped + "; replayed = " + replayed, null, 2, null);
        RadarLocationManager locationManager = this;
        Function1 callTrackApi2 = (Function1)new Function1<RadarBeacon[], Unit>(this, location, stopped, source, replayed, locationManager, foregroundService){
            final /* synthetic */ RadarLocationManager this$0;
            final /* synthetic */ Location $location;
            final /* synthetic */ boolean $stopped;
            final /* synthetic */ Radar.RadarLocationSource $source;
            final /* synthetic */ boolean $replayed;
            final /* synthetic */ RadarLocationManager $locationManager;
            final /* synthetic */ RadarTrackingOptions.RadarTrackingOptionsForegroundService $foregroundService;
            {
                this.this$0 = $receiver;
                this.$location = $location;
                this.$stopped = $stopped;
                this.$source = $source;
                this.$replayed = $replayed;
                this.$locationManager = $locationManager;
                this.$foregroundService = $foregroundService;
                super(1);
            }

            public final void invoke(@Nullable RadarBeacon[] beacons) {
                RadarLocationManager.access$getApiClient$p(this.this$0).track$sdk_release(this.$location, this.$stopped, RadarActivityLifecycleCallbacks.Companion.getForeground(), this.$source, this.$replayed, beacons, new RadarApiClient.RadarTrackApiCallback(this.this$0, this.$locationManager, this.$foregroundService){
                    final /* synthetic */ RadarLocationManager this$0;
                    final /* synthetic */ RadarLocationManager $locationManager;
                    final /* synthetic */ RadarTrackingOptions.RadarTrackingOptionsForegroundService $foregroundService;
                    {
                        this.this$0 = $receiver;
                        this.$locationManager = $locationManager;
                        this.$foregroundService = $foregroundService;
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public void onComplete(@NotNull Radar.RadarStatus status, @Nullable JSONObject res, @Nullable RadarEvent[] events, @Nullable RadarUser user, @Nullable RadarGeofence[] nearbyGeofences, @Nullable RadarConfig config) {
                        block3: {
                            Intrinsics.checkNotNullParameter((Object)status, (String)"status");
                            if (user == null) break block3;
                            if (user.getGeofences() == null) ** GOTO lbl-1000
                            var8_7 = user.getGeofences();
                            var9_9 = false;
                            var10_10 = var8_7;
                            var11_11 = false;
                            if (var10_10.length == 0 == false) {
                                v0 = true;
                            } else lbl-1000:
                            // 2 sources

                            {
                                v0 = false;
                            }
                            inGeofences = v0;
                            atPlace = user.getPlace() != null;
                            canExit = inGeofences != false || atPlace != false;
                            RadarState.INSTANCE.setCanExit$sdk_release(RadarLocationManager.access$getContext$p(this.this$0), canExit);
                        }
                        RadarLocationManager.access$replaceSyncedGeofences(this.$locationManager, nearbyGeofences);
                        if (this.$foregroundService != null && this.$foregroundService.getUpdatesOnly()) {
                            RadarLocationManager.access$stopForegroundService(this.$locationManager);
                        }
                        this.this$0.updateTrackingFromMeta$sdk_release((var7_13 = config) == null ? null : var7_13.getMeta());
                    }
                });
            }
        };
        if (options.getBeacons() && Build.VERSION.SDK_INT >= 26 && this.permissionsHelper.bluetoothPermissionsGranted$sdk_release(this.context)) {
            Radar.INSTANCE.getApiClient$sdk_release().searchBeacons$sdk_release(location, 1000, 10, new RadarApiClient.RadarSearchBeaconsApiCallback((Function1<? super RadarBeacon[], Unit>)callTrackApi2){
                final /* synthetic */ Function1<RadarBeacon[], Unit> $callTrackApi;
                {
                    this.$callTrackApi = $callTrackApi;
                }

                /*
                 * Unable to fully structure code
                 */
                public void onComplete(@NotNull Radar.RadarStatus status, @Nullable JSONObject res, @Nullable RadarBeacon[] beacons, @Nullable String[] uuids, @Nullable String[] uids) {
                    Intrinsics.checkNotNullParameter((Object)status, (String)"status");
                    if (status != Radar.RadarStatus.SUCCESS || beacons == null) {
                        this.$callTrackApi.invoke(null);
                        return;
                    }
                    var6_6 = uuids;
                    var7_7 = false;
                    var8_8 = false;
                    if (var6_6 == null) ** GOTO lbl-1000
                    var8_9 = var6_6;
                    var9_11 = false;
                    if (var8_9.length == 0) lbl-1000:
                    // 2 sources

                    {
                        v0 = true;
                    } else {
                        v0 = false;
                    }
                    if (!v0) ** GOTO lbl-1000
                    var6_6 = uids;
                    var7_7 = false;
                    var8_8 = false;
                    if (var6_6 == null) ** GOTO lbl-1000
                    var8_10 = var6_6;
                    var9_11 = false;
                    if (var8_10.length == 0) lbl-1000:
                    // 2 sources

                    {
                        v1 = true;
                    } else {
                        v1 = false;
                    }
                    if (!v1) lbl-1000:
                    // 2 sources

                    {
                        Radar.INSTANCE.getBeaconManager$sdk_release().startMonitoringBeaconUUIDs(uuids, uids);
                    } else {
                        Radar.INSTANCE.getBeaconManager$sdk_release().startMonitoringBeacons(beacons);
                    }
                    Radar.INSTANCE.getBeaconManager$sdk_release().rangeBeacons(beacons, new Radar.RadarBeaconCallback(this.$callTrackApi){
                        final /* synthetic */ Function1<RadarBeacon[], Unit> $callTrackApi;
                        {
                            this.$callTrackApi = $callTrackApi;
                        }

                        public void onComplete(@NotNull Radar.RadarStatus status, @Nullable RadarBeacon[] beacons) {
                            Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
                            if (status != Radar.RadarStatus.SUCCESS || beacons == null) {
                                this.$callTrackApi.invoke(null);
                                return;
                            }
                            this.$callTrackApi.invoke((Object)beacons);
                        }
                    });
                }
            });
        } else {
            callTrackApi2.invoke(null);
        }
    }

    private final void startForegroundService(RadarTrackingOptions.RadarTrackingOptionsForegroundService foregroundService) {
        if (Build.VERSION.SDK_INT >= 26) {
            try {
                if (RadarForegroundService.Companion.getStarted$sdk_release()) {
                    RadarLogger.d$default(this.logger, "Already started foreground service", null, 2, null);
                } else {
                    Intent intent = new Intent(this.context, RadarForegroundService.class);
                    intent.setAction("start");
                    Integer n = foregroundService.getImportance();
                    intent.putExtra("id", (Serializable)foregroundService.getId()).putExtra("importance", n == null ? 3 : n).putExtra("title", foregroundService.getTitle()).putExtra("text", foregroundService.getText()).putExtra("icon", (Serializable)foregroundService.getIcon()).putExtra("activity", foregroundService.getActivity());
                    RadarLogger.d$default(this.logger, Intrinsics.stringPlus((String)"Starting foreground service with intent | intent = ", (Object)intent), null, 2, null);
                    this.context.getApplicationContext().startForegroundService(intent);
                    RadarForegroundService.Companion.setStarted$sdk_release(true);
                }
            }
            catch (Exception e) {
                this.logger.e("Error starting foreground service with intent", e);
            }
        }
    }

    private final void stopForegroundService() {
        if (Build.VERSION.SDK_INT >= 26) {
            try {
                Intent intent = new Intent(this.context, RadarForegroundService.class);
                intent.setAction("stop");
                RadarLogger.d$default(this.logger, "Stopping foreground service with intent", null, 2, null);
                this.context.getApplicationContext().startService(intent);
                RadarForegroundService.Companion.setStarted$sdk_release(false);
            }
            catch (Exception e) {
                this.logger.e("Error stopping foreground service with intent", e);
            }
        }
    }

    public static final /* synthetic */ RadarLogger access$getLogger$p(RadarLocationManager $this) {
        return $this.logger;
    }

    public static final /* synthetic */ RadarApiClient access$getApiClient$p(RadarLocationManager $this) {
        return $this.apiClient;
    }

    public static final /* synthetic */ Context access$getContext$p(RadarLocationManager $this) {
        return $this.context;
    }

    public static final /* synthetic */ void access$replaceSyncedGeofences(RadarLocationManager $this, RadarGeofence[] radarGeofences) {
        $this.replaceSyncedGeofences(radarGeofences);
    }

    public static final /* synthetic */ void access$stopForegroundService(RadarLocationManager $this) {
        $this.stopForegroundService();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/radar/sdk/RadarLocationManager$Companion;", "", "()V", "BUBBLE_MOVING_GEOFENCE_REQUEST_ID", "", "BUBBLE_STOPPED_GEOFENCE_REQUEST_ID", "SYNCED_GEOFENCES_REQUEST_ID_PREFIX", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

