/*
 * Decompiled with CFR 0.152.
 */
package io.radar.sdk;

import android.annotation.SuppressLint;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.location.Location;
import android.os.Build;
import io.radar.sdk.Radar;
import io.radar.sdk.RadarBeaconUtils;
import io.radar.sdk.RadarForegroundService;
import io.radar.sdk.RadarJobScheduler;
import io.radar.sdk.RadarLogger;
import io.radar.sdk.model.RadarBeacon;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0017\u00a8\u0006\n"}, d2={"Lio/radar/sdk/RadarLocationReceiver;", "Landroid/content/BroadcastReceiver;", "()V", "onReceive", "", "context", "Landroid/content/Context;", "intent", "Landroid/content/Intent;", "Companion", "sdk_release"})
public final class RadarLocationReceiver
extends BroadcastReceiver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String ACTION_LOCATION = "io.radar.sdk.LocationReceiver.LOCATION";
    @NotNull
    public static final String ACTION_BUBBLE_GEOFENCE = "io.radar.sdk.LocationReceiver.GEOFENCE";
    @NotNull
    public static final String ACTION_SYNCED_GEOFENCES = "io.radar.sdk.LocationReceiver.SYNCED_GEOFENCES";
    @NotNull
    public static final String ACTION_BEACON = "io.radar.sdk.LocationReceiver.BEACON";
    private static final int REQUEST_CODE_LOCATION = 201605250;
    private static final int REQUEST_CODE_BUBBLE_GEOFENCE = 201605251;
    private static final int REQUEST_CODE_SYNCED_GEOFENCES = 201605252;
    private static final int REQUEST_CODE_BEACON = 201605253;

    @SuppressLint(value={"MissingPermission"})
    public void onReceive(@NotNull Context context, @NotNull Intent intent) {
        block23: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
            if (!Radar.INSTANCE.getInitialized$sdk_release()) {
                Radar.initialize$default(context, null, 2, null);
            }
            RadarLogger.d$default(Radar.INSTANCE.getLogger$sdk_release(), Intrinsics.stringPlus((String)"Received broadcast | action = ", (Object)intent.getAction()), null, 2, null);
            String string = intent.getAction();
            if (string == null) break block23;
            int n = -1;
            switch (string.hashCode()) {
                case 1093389610: {
                    if (string.equals(ACTION_BEACON)) {
                        n = 1;
                    }
                    break;
                }
                case 798292259: {
                    if (string.equals("android.intent.action.BOOT_COMPLETED")) {
                        n = 2;
                    }
                    break;
                }
                case -992172314: {
                    if (string.equals(ACTION_BUBBLE_GEOFENCE)) {
                        n = 3;
                    }
                    break;
                }
                case -2035686220: {
                    if (string.equals(ACTION_SYNCED_GEOFENCES)) {
                        n = 3;
                    }
                    break;
                }
                case -930677989: {
                    if (string.equals(ACTION_LOCATION)) {
                        n = 4;
                    }
                    break;
                }
            }
            switch (n) {
                case 3: {
                    Location location = Radar.INSTANCE.getLocationManager$sdk_release().getLocationFromGeofenceIntent$sdk_release(intent);
                    Radar.RadarLocationSource source = Radar.INSTANCE.getLocationManager$sdk_release().getSourceFromGeofenceIntent$sdk_release(intent);
                    if (location == null || source == null) {
                        return;
                    }
                    if (Build.VERSION.SDK_INT >= 21 && !RadarForegroundService.Companion.getStarted$sdk_release()) {
                        RadarJobScheduler.Companion.scheduleJob$sdk_release(context, location, source);
                        break;
                    }
                    Radar.INSTANCE.handleLocation$sdk_release(context, location, source);
                    break;
                }
                case 4: {
                    Location location = Radar.INSTANCE.getLocationManager$sdk_release().getLocationFromLocationIntent$sdk_release(intent);
                    Radar.RadarLocationSource source = Radar.RadarLocationSource.BACKGROUND_LOCATION;
                    if (location == null) {
                        return;
                    }
                    if (Build.VERSION.SDK_INT >= 21 && !RadarForegroundService.Companion.getStarted$sdk_release()) {
                        RadarJobScheduler.Companion.scheduleJob$sdk_release(context, location, source);
                        break;
                    }
                    Radar.INSTANCE.handleLocation$sdk_release(context, location, source);
                    break;
                }
                case 1: {
                    int bleCallbackType;
                    if (Build.VERSION.SDK_INT < 26 || (bleCallbackType = intent.getIntExtra("android.bluetooth.le.extra.CALLBACK_TYPE", -1)) == -1) break;
                    Radar.RadarLocationSource source = bleCallbackType == 4 ? Radar.RadarLocationSource.BEACON_EXIT : Radar.RadarLocationSource.BEACON_ENTER;
                    ArrayList scanResults = intent.getParcelableArrayListExtra("android.bluetooth.le.extra.LIST_SCAN_RESULT");
                    RadarBeacon[] beacons = RadarBeaconUtils.INSTANCE.beaconsForScanResults(scanResults);
                    RadarJobScheduler.Companion.scheduleJob$sdk_release(context, beacons, source);
                    break;
                }
                case 2: {
                    Radar.INSTANCE.handleBootCompleted$sdk_release(context);
                }
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0015\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0013J\u0015\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0015J\u0015\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0017J\u0015\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0019R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lio/radar/sdk/RadarLocationReceiver$Companion;", "", "()V", "ACTION_BEACON", "", "ACTION_BUBBLE_GEOFENCE", "ACTION_LOCATION", "ACTION_SYNCED_GEOFENCES", "REQUEST_CODE_BEACON", "", "REQUEST_CODE_BUBBLE_GEOFENCE", "REQUEST_CODE_LOCATION", "REQUEST_CODE_SYNCED_GEOFENCES", "baseIntent", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "getBeaconPendingIntent", "Landroid/app/PendingIntent;", "getBeaconPendingIntent$sdk_release", "getBubbleGeofencePendingIntent", "getBubbleGeofencePendingIntent$sdk_release", "getLocationPendingIntent", "getLocationPendingIntent$sdk_release", "getSyncedGeofencesPendingIntent", "getSyncedGeofencesPendingIntent$sdk_release", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PendingIntent getLocationPendingIntent$sdk_release(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intent intent = this.baseIntent(context);
            boolean bl = false;
            boolean bl2 = false;
            Intent $this$getLocationPendingIntent_u24lambda_u2d0 = intent;
            boolean bl3 = false;
            $this$getLocationPendingIntent_u24lambda_u2d0.setAction(RadarLocationReceiver.ACTION_LOCATION);
            Intent intent2 = intent;
            int flags = Build.VERSION.SDK_INT >= 31 ? 0xA000000 : 0x8000000;
            PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)201605250, (Intent)intent2, (int)flags);
            Intrinsics.checkNotNullExpressionValue((Object)pendingIntent, (String)"getBroadcast(\n                context,\n                REQUEST_CODE_LOCATION,\n                intent,\n                flags\n            )");
            return pendingIntent;
        }

        @NotNull
        public final PendingIntent getBubbleGeofencePendingIntent$sdk_release(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intent intent = this.baseIntent(context);
            boolean bl = false;
            boolean bl2 = false;
            Intent $this$getBubbleGeofencePendingIntent_u24lambda_u2d1 = intent;
            boolean bl3 = false;
            $this$getBubbleGeofencePendingIntent_u24lambda_u2d1.setAction(RadarLocationReceiver.ACTION_BUBBLE_GEOFENCE);
            Intent intent2 = intent;
            int flags = Build.VERSION.SDK_INT >= 31 ? 0xA000000 : 0x8000000;
            PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)201605251, (Intent)intent2, (int)flags);
            Intrinsics.checkNotNullExpressionValue((Object)pendingIntent, (String)"getBroadcast(\n                context,\n                REQUEST_CODE_BUBBLE_GEOFENCE,\n                intent,\n                flags\n            )");
            return pendingIntent;
        }

        @NotNull
        public final PendingIntent getSyncedGeofencesPendingIntent$sdk_release(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intent intent = this.baseIntent(context);
            boolean bl = false;
            boolean bl2 = false;
            Intent $this$getSyncedGeofencesPendingIntent_u24lambda_u2d2 = intent;
            boolean bl3 = false;
            $this$getSyncedGeofencesPendingIntent_u24lambda_u2d2.setAction(RadarLocationReceiver.ACTION_SYNCED_GEOFENCES);
            Intent intent2 = intent;
            int flags = Build.VERSION.SDK_INT >= 31 ? 0xA000000 : 0x8000000;
            PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)201605252, (Intent)intent2, (int)flags);
            Intrinsics.checkNotNullExpressionValue((Object)pendingIntent, (String)"getBroadcast(\n                context,\n                REQUEST_CODE_SYNCED_GEOFENCES,\n                intent,\n                flags\n            )");
            return pendingIntent;
        }

        @NotNull
        public final PendingIntent getBeaconPendingIntent$sdk_release(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intent intent = this.baseIntent(context);
            boolean bl = false;
            boolean bl2 = false;
            Intent $this$getBeaconPendingIntent_u24lambda_u2d3 = intent;
            boolean bl3 = false;
            $this$getBeaconPendingIntent_u24lambda_u2d3.setAction(RadarLocationReceiver.ACTION_BEACON);
            Intent intent2 = intent;
            int flags = Build.VERSION.SDK_INT >= 31 ? 0xA000000 : 0x8000000;
            PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)201605253, (Intent)intent2, (int)flags);
            Intrinsics.checkNotNullExpressionValue((Object)pendingIntent, (String)"getBroadcast(\n                context,\n                REQUEST_CODE_BEACON,\n                intent,\n                flags\n            )");
            return pendingIntent;
        }

        private final Intent baseIntent(Context context) {
            return new Intent(context, RadarLocationReceiver.class);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

