/*
 * Decompiled with CFR 0.152.
 */
package io.radar.sdk;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanRecord;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import androidx.annotation.RequiresApi;
import io.radar.sdk.Radar;
import io.radar.sdk.RadarBeaconUtils;
import io.radar.sdk.RadarLocationReceiver;
import io.radar.sdk.RadarLogger;
import io.radar.sdk.RadarPermissionsHelper;
import io.radar.sdk.model.RadarBeacon;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010#\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0001\u0018\u0000 ?2\u00020\u0001:\u0001?B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0003\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010\u0015H\u0002J\u001f\u0010)\u001a\u00020'2\u0010\b\u0002\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\fH\u0002\u00a2\u0006\u0002\u0010*J!\u0010+\u001a\u00020'2\b\u0010,\u001a\u0004\u0018\u00010-2\b\b\u0002\u0010.\u001a\u00020%H\u0000\u00a2\u0006\u0002\b/J\u001d\u00100\u001a\u00020'2\u000e\u00101\u001a\n\u0012\u0004\u0012\u00020-\u0018\u000102H\u0000\u00a2\u0006\u0002\b3J\u0015\u00104\u001a\u00020%2\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b5J5\u00106\u001a\u00020'2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\b\u0010(\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\u0002\u00107J#\u00108\u001a\u00020'2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\f2\b\u0010(\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\u0002\u00109J+\u0010:\u001a\u00020'2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f\u00a2\u0006\u0002\u0010;J\u0019\u0010<\u001a\u00020'2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\f\u00a2\u0006\u0002\u0010*J\u0006\u0010=\u001a\u00020'J\b\u0010>\u001a\u00020'H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0012R2\u0010\u0013\u001a&\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u00150\u0015 \u0016*\u0012\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u00150\u0015\u0018\u00010\u00170\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\r0\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00110\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lio/radar/sdk/RadarBeaconManager;", "", "context", "Landroid/content/Context;", "logger", "Lio/radar/sdk/RadarLogger;", "permissionsHelper", "Lio/radar/sdk/RadarPermissionsHelper;", "(Landroid/content/Context;Lio/radar/sdk/RadarLogger;Lio/radar/sdk/RadarPermissionsHelper;)V", "adapter", "Landroid/bluetooth/BluetoothAdapter;", "beaconUIDs", "", "", "[Ljava/lang/String;", "beaconUUIDs", "beacons", "Lio/radar/sdk/model/RadarBeacon;", "[Lio/radar/sdk/model/RadarBeacon;", "callbacks", "", "Lio/radar/sdk/Radar$RadarBeaconCallback;", "kotlin.jvm.PlatformType", "", "handler", "Landroid/os/Handler;", "monitoredBeaconIdentifiers", "", "nearbyBeacons", "", "getPermissionsHelper$sdk_release", "()Lio/radar/sdk/RadarPermissionsHelper;", "setPermissionsHelper$sdk_release", "(Lio/radar/sdk/RadarPermissionsHelper;)V", "scanCallback", "Landroid/bluetooth/le/ScanCallback;", "started", "", "addCallback", "", "callback", "callCallbacks", "([Lio/radar/sdk/model/RadarBeacon;)V", "handleScanResult", "result", "Landroid/bluetooth/le/ScanResult;", "ranging", "handleScanResult$sdk_release", "handleScanResults", "scanResults", "Ljava/util/ArrayList;", "handleScanResults$sdk_release", "isBluetoothSupported", "isBluetoothSupported$sdk_release", "rangeBeaconUUIDs", "([Ljava/lang/String;[Ljava/lang/String;Lio/radar/sdk/Radar$RadarBeaconCallback;)V", "rangeBeacons", "([Lio/radar/sdk/model/RadarBeacon;Lio/radar/sdk/Radar$RadarBeaconCallback;)V", "startMonitoringBeaconUUIDs", "([Ljava/lang/String;[Ljava/lang/String;)V", "startMonitoringBeacons", "stopMonitoringBeacons", "stopRanging", "Companion", "sdk_release"})
@RequiresApi(value=26)
@SuppressLint(value={"MissingPermission"})
public final class RadarBeaconManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final RadarLogger logger;
    @NotNull
    private RadarPermissionsHelper permissionsHelper;
    private BluetoothAdapter adapter;
    private boolean started;
    private final List<Radar.RadarBeaconCallback> callbacks;
    @NotNull
    private Set<String> monitoredBeaconIdentifiers;
    @NotNull
    private Set<RadarBeacon> nearbyBeacons;
    @NotNull
    private RadarBeacon[] beacons;
    @NotNull
    private String[] beaconUUIDs;
    @NotNull
    private String[] beaconUIDs;
    @Nullable
    private ScanCallback scanCallback;
    @NotNull
    private final Handler handler;
    @NotNull
    private static final String TIMEOUT_TOKEN = "timeout";

    public RadarBeaconManager(@NotNull Context context, @NotNull RadarLogger logger, @SuppressLint(value={"VisibleForTests"}) @NotNull RadarPermissionsHelper permissionsHelper) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)permissionsHelper, (String)"permissionsHelper");
        this.context = context;
        this.logger = logger;
        this.permissionsHelper = permissionsHelper;
        boolean bl = false;
        this.callbacks = Collections.synchronizedList(new ArrayList());
        bl = false;
        this.monitoredBeaconIdentifiers = SetsKt.emptySet();
        bl = false;
        this.nearbyBeacons = new LinkedHashSet();
        this.beacons = new RadarBeacon[0];
        this.beaconUUIDs = new String[0];
        this.beaconUIDs = new String[0];
        this.handler = new Handler(Looper.getMainLooper());
    }

    public /* synthetic */ RadarBeaconManager(Context context, RadarLogger radarLogger, RadarPermissionsHelper radarPermissionsHelper, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            radarPermissionsHelper = new RadarPermissionsHelper();
        }
        this(context, radarLogger, radarPermissionsHelper);
    }

    @NotNull
    public final RadarPermissionsHelper getPermissionsHelper$sdk_release() {
        return this.permissionsHelper;
    }

    public final void setPermissionsHelper$sdk_release(@NotNull RadarPermissionsHelper radarPermissionsHelper) {
        Intrinsics.checkNotNullParameter((Object)radarPermissionsHelper, (String)"<set-?>");
        this.permissionsHelper = radarPermissionsHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addCallback(Radar.RadarBeaconCallback callback) {
        if (callback == null) {
            return;
        }
        List<Radar.RadarBeaconCallback> list = this.callbacks;
        Intrinsics.checkNotNullExpressionValue(list, (String)"callbacks");
        boolean bl = false;
        boolean bl2 = false;
        synchronized (list) {
            boolean bl3 = false;
            bl2 = this.callbacks.add(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void callCallbacks(RadarBeacon[] nearbyBeacons) {
        List<Radar.RadarBeaconCallback> list = this.callbacks;
        Intrinsics.checkNotNullExpressionValue(list, (String)"callbacks");
        boolean bl = false;
        boolean bl2 = false;
        synchronized (list) {
            boolean bl3 = false;
            if (this.callbacks.isEmpty()) {
                return;
            }
            RadarLogger.d$default(this.logger, Intrinsics.stringPlus((String)"Calling callbacks | callbacks.size = ", (Object)this.callbacks.size()), null, 2, null);
            for (Radar.RadarBeaconCallback callback : this.callbacks) {
                callback.onComplete(Radar.RadarStatus.SUCCESS, nearbyBeacons);
            }
            this.callbacks.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    static /* synthetic */ void callCallbacks$default(RadarBeaconManager radarBeaconManager, RadarBeacon[] radarBeaconArray, int n, Object object) {
        if ((n & 1) != 0) {
            radarBeaconArray = null;
        }
        radarBeaconManager.callCallbacks(radarBeaconArray);
    }

    /*
     * WARNING - void declaration
     */
    public final void startMonitoringBeacons(@NotNull RadarBeacon[] beacons) {
        void $this$mapNotNullTo$iv$iv;
        BluetoothAdapter bluetoothAdapter;
        Intrinsics.checkNotNullParameter((Object)beacons, (String)"beacons");
        if (!this.permissionsHelper.bluetoothPermissionsGranted$sdk_release(this.context)) {
            RadarLogger.d$default(this.logger, "Bluetooth permissions not granted", null, 2, null);
            return;
        }
        if (!this.isBluetoothSupported$sdk_release(this.context)) {
            RadarLogger.d$default(this.logger, "Bluetooth not supported", null, 2, null);
            return;
        }
        if (this.adapter == null) {
            bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
            Intrinsics.checkNotNullExpressionValue((Object)bluetoothAdapter, (String)"getDefaultAdapter()");
            this.adapter = bluetoothAdapter;
        }
        if ((bluetoothAdapter = this.adapter) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
            throw null;
        }
        if (!bluetoothAdapter.isEnabled()) {
            RadarLogger.d$default(this.logger, "Bluetooth not enabled", null, 2, null);
            return;
        }
        RadarBeacon[] $this$mapNotNull$iv = beacons;
        boolean $i$f$mapNotNull22 = false;
        RadarBeacon[] radarBeaconArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        void var10_17 = $this$forEach$iv$iv$iv;
        int n = ((void)var10_17).length;
        for (int i = 0; i < n; ++i) {
            String string;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = var10_17[i];
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            if (it.get_id() == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            String it$iv$iv = string;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set newBeaconIdentifiers = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        if (Intrinsics.areEqual(this.monitoredBeaconIdentifiers, (Object)newBeaconIdentifiers)) {
            RadarLogger.i$default(this.logger, "Already monitoring beacons", null, 2, null);
            return;
        }
        this.stopMonitoringBeacons();
        $this$mapNotNull$iv = beacons;
        $i$f$mapNotNull22 = false;
        if ($this$mapNotNull$iv.length == 0) {
            RadarLogger.d$default(this.logger, "No beacons to monitor", null, 2, null);
            return;
        }
        this.monitoredBeaconIdentifiers = newBeaconIdentifiers;
        $i$f$mapNotNull22 = false;
        List scanFilters = new ArrayList();
        RadarBeacon[] $i$f$mapNotNull22 = beacons;
        int n2 = 0;
        int n3 = $i$f$mapNotNull22.length;
        while (n2 < n3) {
            RadarBeacon beacon = $i$f$mapNotNull22[n2];
            ++n2;
            ScanFilter scanFilter = null;
            try {
                RadarLogger.d$default(this.logger, Intrinsics.stringPlus((String)"Building scan filter for monitoring | _id = ", (Object)beacon.get_id()), null, 2, null);
                scanFilter = RadarBeaconUtils.INSTANCE.getScanFilterForBeacon(beacon);
            }
            catch (Exception e) {
                this.logger.d(Intrinsics.stringPlus((String)"Error building scan filter for monitoring | _id = ", (Object)beacon.get_id()), e);
            }
            if (scanFilter == null) continue;
            RadarLogger.d$default(this.logger, "Starting monitoring beacon | _id = " + beacon.get_id() + "; uuid = " + beacon.getUuid() + "; major = " + beacon.getMajor() + "; minor = " + beacon.getMinor(), null, 2, null);
            scanFilters.add(scanFilter);
        }
        if (scanFilters.size() == 0) {
            RadarLogger.d$default(this.logger, "No scan filters for monitoring", null, 2, null);
            return;
        }
        try {
            ScanSettings scanSettings = new ScanSettings.Builder().setScanMode(0).setCallbackType(2).setReportDelay(30000L).setMatchMode(2).setNumOfMatches(1).build();
            RadarLogger.d$default(this.logger, "Starting monitoring beacons", null, 2, null);
            BluetoothAdapter bluetoothAdapter2 = this.adapter;
            if (bluetoothAdapter2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
                throw null;
            }
            bluetoothAdapter2.getBluetoothLeScanner().startScan(scanFilters, scanSettings, RadarLocationReceiver.Companion.getBeaconPendingIntent$sdk_release(this.context));
        }
        catch (Exception e) {
            this.logger.e("Error starting monitoring beacons", e);
        }
    }

    /*
     * Unable to fully structure code
     */
    public final void startMonitoringBeaconUUIDs(@Nullable String[] beaconUUIDs, @Nullable String[] beaconUIDs) {
        block25: {
            if (!this.permissionsHelper.bluetoothPermissionsGranted$sdk_release(this.context)) {
                RadarLogger.d$default(this.logger, "Bluetooth permissions not granted", null, 2, null);
                return;
            }
            if (!this.isBluetoothSupported$sdk_release(this.context)) {
                RadarLogger.d$default(this.logger, "Bluetooth not supported", null, 2, null);
                return;
            }
            if (this.adapter == null) {
                var3_3 = BluetoothAdapter.getDefaultAdapter();
                Intrinsics.checkNotNullExpressionValue((Object)var3_3, (String)"getDefaultAdapter()");
                this.adapter = var3_3;
            }
            if ((var3_3 = this.adapter) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
                throw null;
            }
            if (!var3_3.isEnabled()) {
                RadarLogger.d$default(this.logger, "Bluetooth not enabled", null, 2, null);
                return;
            }
            var4_4 = false;
            newBeaconIdentifiers = new LinkedHashSet<E>();
            if (beaconUUIDs != null) {
                CollectionsKt.addAll((Collection)newBeaconIdentifiers, (Object[])beaconUUIDs);
            }
            if (beaconUIDs != null) {
                CollectionsKt.addAll((Collection)newBeaconIdentifiers, (Object[])beaconUIDs);
            }
            if (Intrinsics.areEqual(this.monitoredBeaconIdentifiers, (Object)newBeaconIdentifiers)) {
                RadarLogger.i$default(this.logger, "Already monitoring beacons", null, 2, null);
                return;
            }
            this.stopMonitoringBeacons();
            var4_5 = beaconUUIDs;
            var5_6 = false;
            var6_11 = false;
            if (var4_5 == null) ** GOTO lbl-1000
            var6_12 = var4_5;
            var7_17 = false;
            if (var6_12.length == 0) lbl-1000:
            // 2 sources

            {
                v0 = true;
            } else {
                v0 = false;
            }
            if (!v0) break block25;
            var4_5 = beaconUIDs;
            var5_6 = false;
            var6_11 = false;
            if (var4_5 == null) ** GOTO lbl-1000
            var6_13 = var4_5;
            var7_17 = false;
            if (var6_13.length == 0) lbl-1000:
            // 2 sources

            {
                v1 = true;
            } else {
                v1 = false;
            }
            if (v1) {
                RadarLogger.d$default(this.logger, "No beacon UUIDs or UIDs to monitor", null, 2, null);
                return;
            }
        }
        this.monitoredBeaconIdentifiers = newBeaconIdentifiers;
        var5_6 = false;
        scanFilters = new ArrayList<E>();
        if (beaconUUIDs != null) {
            var5_7 = ArrayIteratorKt.iterator((Object[])beaconUUIDs);
            while (var5_7.hasNext()) {
                beaconUUID = (String)var5_7.next();
                scanFilter = null;
                try {
                    RadarLogger.d$default(this.logger, Intrinsics.stringPlus((String)"Building scan filter for monitoring | beaconUUID = ", (Object)beaconUUID), null, 2, null);
                    scanFilter = RadarBeaconUtils.INSTANCE.getScanFilterForBeacon(beaconUUID);
                }
                catch (Exception e) {
                    this.logger.d(Intrinsics.stringPlus((String)"Error building scan filter for monitoring | beaconUUID = ", (Object)beaconUUID), e);
                }
                if (scanFilter == null) continue;
                RadarLogger.d$default(this.logger, Intrinsics.stringPlus((String)"Starting monitoring beacon UUID | beaconUUID = ", (Object)beaconUUID), null, 2, null);
                scanFilters.add(scanFilter);
            }
        }
        if (beaconUIDs != null) {
            var5_8 = ArrayIteratorKt.iterator((Object[])beaconUIDs);
            while (var5_8.hasNext()) {
                beaconUID = (String)var5_8.next();
                scanFilter = null;
                try {
                    RadarLogger.d$default(this.logger, Intrinsics.stringPlus((String)"Building scan filter for monitoring | beaconUID = ", (Object)beaconUID), null, 2, null);
                    scanFilter = RadarBeaconUtils.INSTANCE.getScanFilterForBeaconUID(beaconUID);
                }
                catch (Exception e) {
                    this.logger.d(Intrinsics.stringPlus((String)"Error building scan filter for monitoring | beaconUID = ", (Object)beaconUID), e);
                }
                if (scanFilter == null) continue;
                RadarLogger.d$default(this.logger, Intrinsics.stringPlus((String)"Starting monitoring beacon UID | beaconUID = ", (Object)beaconUID), null, 2, null);
                scanFilters.add(scanFilter);
            }
        }
        if (scanFilters.size() == 0) {
            RadarLogger.d$default(this.logger, "No scan filters for monitoring", null, 2, null);
            return;
        }
        try {
            scanSettings = new ScanSettings.Builder().setScanMode(0).setCallbackType(2).setReportDelay(30000L).setMatchMode(2).setNumOfMatches(1).build();
            RadarLogger.d$default(this.logger, "Starting monitoring beacon UUIDs", null, 2, null);
            var6_16 = this.adapter;
            if (var6_16 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
                throw null;
            }
            var6_16.getBluetoothLeScanner().startScan(scanFilters, scanSettings, RadarLocationReceiver.Companion.getBeaconPendingIntent$sdk_release(this.context));
        }
        catch (Exception e) {
            this.logger.e("Error starting monitoring beacon UUIDs", e);
        }
    }

    public final void stopMonitoringBeacons() {
        BluetoothAdapter bluetoothAdapter;
        if (!this.permissionsHelper.bluetoothPermissionsGranted$sdk_release(this.context)) {
            return;
        }
        if (!this.isBluetoothSupported$sdk_release(this.context)) {
            return;
        }
        if (this.adapter == null) {
            bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
            Intrinsics.checkNotNullExpressionValue((Object)bluetoothAdapter, (String)"getDefaultAdapter()");
            this.adapter = bluetoothAdapter;
        }
        if ((bluetoothAdapter = this.adapter) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
            throw null;
        }
        if (!bluetoothAdapter.isEnabled()) {
            RadarLogger.d$default(this.logger, "Bluetooth not enabled", null, 2, null);
            return;
        }
        RadarLogger.d$default(this.logger, "Stopping monitoring beacons", null, 2, null);
        try {
            bluetoothAdapter = this.adapter;
            if (bluetoothAdapter == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
                throw null;
            }
            bluetoothAdapter.getBluetoothLeScanner().stopScan(RadarLocationReceiver.Companion.getBeaconPendingIntent$sdk_release(this.context));
        }
        catch (Exception e) {
            this.logger.d("Error stopping monitoring beacons", e);
        }
        boolean bl = false;
        this.monitoredBeaconIdentifiers = SetsKt.emptySet();
    }

    public final void rangeBeacons(@NotNull RadarBeacon[] beacons, @Nullable Radar.RadarBeaconCallback callback) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)beacons, (String)"beacons");
        if (!this.permissionsHelper.bluetoothPermissionsGranted$sdk_release(this.context)) {
            RadarLogger.d$default(this.logger, "Bluetooth permissions not granted", null, 2, null);
            Radar.INSTANCE.sendError$sdk_release(Radar.RadarStatus.ERROR_PERMISSIONS);
            Radar.RadarBeaconCallback radarBeaconCallback = callback;
            if (radarBeaconCallback != null) {
                Radar.RadarBeaconCallback.DefaultImpls.onComplete$default(radarBeaconCallback, Radar.RadarStatus.ERROR_PERMISSIONS, null, 2, null);
            }
            return;
        }
        if (!this.isBluetoothSupported$sdk_release(this.context)) {
            RadarLogger.d$default(this.logger, "Bluetooth not supported", null, 2, null);
            Radar.INSTANCE.sendError$sdk_release(Radar.RadarStatus.ERROR_BLUETOOTH);
            Radar.RadarBeaconCallback radarBeaconCallback = callback;
            if (radarBeaconCallback != null) {
                Radar.RadarBeaconCallback.DefaultImpls.onComplete$default(radarBeaconCallback, Radar.RadarStatus.ERROR_BLUETOOTH, null, 2, null);
            }
            return;
        }
        if (this.adapter == null) {
            object = BluetoothAdapter.getDefaultAdapter();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getDefaultAdapter()");
            this.adapter = object;
        }
        if ((object = this.adapter) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
            throw null;
        }
        if (!object.isEnabled()) {
            RadarLogger.d$default(this.logger, "Bluetooth not enabled", null, 2, null);
            Radar.INSTANCE.sendError$sdk_release(Radar.RadarStatus.ERROR_BLUETOOTH);
            object = callback;
            if (object != null) {
                Radar.RadarBeaconCallback.DefaultImpls.onComplete$default((Radar.RadarBeaconCallback)object, Radar.RadarStatus.ERROR_BLUETOOTH, null, 2, null);
            }
            return;
        }
        object = beacons;
        boolean bl = false;
        if (((RadarBeacon[])object).length == 0) {
            RadarLogger.d$default(this.logger, "No beacons to range", null, 2, null);
            object = callback;
            if (object != null) {
                Radar.RadarBeaconCallback.DefaultImpls.onComplete$default((Radar.RadarBeaconCallback)object, Radar.RadarStatus.SUCCESS, null, 2, null);
            }
            return;
        }
        this.addCallback(callback);
        if (this.started) {
            RadarLogger.d$default(this.logger, "Already ranging beacons", null, 2, null);
            return;
        }
        this.beacons = beacons;
        this.started = true;
        bl = false;
        List scanFilters = new ArrayList();
        RadarBeacon[] radarBeaconArray = beacons;
        int n = 0;
        int n2 = radarBeaconArray.length;
        while (n < n2) {
            RadarBeacon beacon = radarBeaconArray[n];
            ++n;
            ScanFilter scanFilter = null;
            try {
                RadarLogger.d$default(this.logger, Intrinsics.stringPlus((String)"Building scan filter for ranging | _id = ", (Object)beacon.get_id()), null, 2, null);
                scanFilter = RadarBeaconUtils.INSTANCE.getScanFilterForBeacon(beacon);
            }
            catch (Exception e) {
                this.logger.d(Intrinsics.stringPlus((String)"Error building scan filter for ranging | _id = ", (Object)beacon.get_id()), e);
            }
            if (scanFilter == null) continue;
            RadarLogger.d$default(this.logger, "Starting ranging beacon | type = " + (Object)((Object)beacon.getType()) + "; _id = " + beacon.get_id() + "; uuid = " + beacon.getUuid() + "; major = " + beacon.getMajor() + "; minor = " + beacon.getMinor(), null, 2, null);
            scanFilters.add(scanFilter);
        }
        if (scanFilters.size() == 0) {
            RadarLogger.d$default(this.logger, "No scan filters for ranging", null, 2, null);
            RadarBeaconManager.callCallbacks$default(this, null, 1, null);
            return;
        }
        ScanSettings scanSettings = new ScanSettings.Builder().setScanMode(1).setReportDelay(0L).build();
        RadarBeaconManager beaconManager = this;
        this.scanCallback = new ScanCallback(beaconManager, this){
            final /* synthetic */ RadarBeaconManager $beaconManager;
            final /* synthetic */ RadarBeaconManager this$0;
            {
                this.$beaconManager = $beaconManager;
                this.this$0 = $receiver;
            }

            public void onScanResult(int callbackType, @Nullable ScanResult result) {
                super.onScanResult(callbackType, result);
                RadarBeaconManager.handleScanResult$sdk_release$default(this.$beaconManager, result, false, 2, null);
            }

            /*
             * WARNING - void declaration
             */
            public void onBatchScanResults(@Nullable List<ScanResult> results) {
                super.onBatchScanResults(results);
                List<ScanResult> list = results;
                if (list != null) {
                    void $this$forEach$iv;
                    Iterable iterable = list;
                    RadarBeaconManager radarBeaconManager = this.$beaconManager;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        ScanResult result = (ScanResult)element$iv;
                        boolean bl = false;
                        RadarBeaconManager.handleScanResult$sdk_release$default(radarBeaconManager, result, false, 2, null);
                    }
                }
            }

            public void onScanFailed(int errorCode) {
                super.onScanFailed(errorCode);
                RadarLogger.d$default(RadarBeaconManager.access$getLogger$p(this.this$0), "Scan failed", null, 2, null);
                RadarBeaconManager.access$stopRanging(this.$beaconManager);
            }
        };
        try {
            BluetoothAdapter bluetoothAdapter = this.adapter;
            if (bluetoothAdapter == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
                throw null;
            }
            bluetoothAdapter.getBluetoothLeScanner().startScan(scanFilters, scanSettings, this.scanCallback);
        }
        catch (Exception e) {
            this.logger.e("Error starting ranging beacons", e);
        }
        this.handler.postAtTime(() -> RadarBeaconManager.rangeBeacons$lambda-3(this), (Object)TIMEOUT_TOKEN, SystemClock.uptimeMillis() + 5000L);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public final void rangeBeaconUUIDs(@Nullable String[] beaconUUIDs, @Nullable String[] beaconUIDs, @Nullable Radar.RadarBeaconCallback callback) {
        block27: {
            if (!this.permissionsHelper.bluetoothPermissionsGranted$sdk_release(this.context)) {
                RadarLogger.d$default(this.logger, "Bluetooth permissions not granted", null, 2, null);
                Radar.INSTANCE.sendError$sdk_release(Radar.RadarStatus.ERROR_PERMISSIONS);
                var4_4 = callback;
                if (var4_4 != null) {
                    Radar.RadarBeaconCallback.DefaultImpls.onComplete$default(var4_4, Radar.RadarStatus.ERROR_PERMISSIONS, null, 2, null);
                }
                return;
            }
            if (!this.isBluetoothSupported$sdk_release(this.context)) {
                RadarLogger.d$default(this.logger, "Bluetooth not supported", null, 2, null);
                Radar.INSTANCE.sendError$sdk_release(Radar.RadarStatus.ERROR_BLUETOOTH);
                var4_5 = callback;
                if (var4_5 != null) {
                    Radar.RadarBeaconCallback.DefaultImpls.onComplete$default(var4_5, Radar.RadarStatus.ERROR_BLUETOOTH, null, 2, null);
                }
                return;
            }
            if (this.adapter == null) {
                var4_6 /* !! */  = BluetoothAdapter.getDefaultAdapter();
                Intrinsics.checkNotNullExpressionValue((Object)var4_6 /* !! */ , (String)"getDefaultAdapter()");
                this.adapter = var4_6 /* !! */ ;
            }
            if ((var4_6 /* !! */  = this.adapter) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
                throw null;
            }
            if (!var4_6 /* !! */ .isEnabled()) {
                RadarLogger.d$default(this.logger, "Bluetooth not enabled", null, 2, null);
                Radar.INSTANCE.sendError$sdk_release(Radar.RadarStatus.ERROR_BLUETOOTH);
                var4_6 /* !! */  = callback;
                if (var4_6 /* !! */  != null) {
                    Radar.RadarBeaconCallback.DefaultImpls.onComplete$default((Radar.RadarBeaconCallback)var4_6 /* !! */ , Radar.RadarStatus.ERROR_BLUETOOTH, null, 2, null);
                }
                return;
            }
            var4_6 /* !! */  = beaconUUIDs;
            var5_7 = false;
            var6_11 = false;
            if (var4_6 /* !! */  == null) ** GOTO lbl-1000
            var6_12 = var4_6 /* !! */ ;
            var7_17 = false;
            if (var6_12.length == 0) lbl-1000:
            // 2 sources

            {
                v0 = true;
            } else {
                v0 = false;
            }
            if (!v0) break block27;
            var4_6 /* !! */  = beaconUIDs;
            var5_7 = false;
            var6_11 = false;
            if (var4_6 /* !! */  == null) ** GOTO lbl-1000
            var6_13 /* !! */  = var4_6 /* !! */ ;
            var7_17 = false;
            if (var6_13 /* !! */ .length == 0) lbl-1000:
            // 2 sources

            {
                v1 = true;
            } else {
                v1 = false;
            }
            if (v1) {
                RadarLogger.d$default(this.logger, "No beacon UUIDs or UIDs to range", null, 2, null);
                var4_6 /* !! */  = callback;
                if (var4_6 /* !! */  != null) {
                    Radar.RadarBeaconCallback.DefaultImpls.onComplete$default((Radar.RadarBeaconCallback)var4_6 /* !! */ , Radar.RadarStatus.SUCCESS, null, 2, null);
                }
                return;
            }
        }
        this.addCallback(callback);
        if (this.started) {
            RadarLogger.d$default(this.logger, "Already ranging beacons", null, 2, null);
            return;
        }
        var4_6 /* !! */  = beaconUUIDs;
        this.beaconUUIDs = var4_6 /* !! */  == null ? new String[]{} : var4_6 /* !! */ ;
        var4_6 /* !! */  = beaconUIDs;
        this.beaconUIDs = var4_6 /* !! */  == null ? new String[]{} : var4_6 /* !! */ ;
        this.started = true;
        var5_7 = false;
        scanFilters = new ArrayList<E>();
        if (beaconUUIDs != null) {
            var5_8 = ArrayIteratorKt.iterator((Object[])beaconUUIDs);
            while (var5_8.hasNext()) {
                beaconUUID = (String)var5_8.next();
                scanFilter = null;
                try {
                    RadarLogger.d$default(this.logger, Intrinsics.stringPlus((String)"Building scan filter for ranging | beaconUUID = ", (Object)beaconUUID), null, 2, null);
                    scanFilter = RadarBeaconUtils.INSTANCE.getScanFilterForBeacon(beaconUUID);
                }
                catch (Exception e) {
                    this.logger.d(Intrinsics.stringPlus((String)"Error building scan filter for ranging | beaconUUID = ", (Object)beaconUUID), e);
                }
                if (scanFilter == null) continue;
                RadarLogger.d$default(this.logger, Intrinsics.stringPlus((String)"Starting ranging beacon UUID | beaconUUID = ", (Object)beaconUUID), null, 2, null);
                scanFilters.add(scanFilter);
            }
        }
        if (beaconUIDs != null) {
            var5_9 = ArrayIteratorKt.iterator((Object[])beaconUIDs);
            while (var5_9.hasNext()) {
                beaconUID = (String)var5_9.next();
                scanFilter = null;
                try {
                    RadarLogger.d$default(this.logger, Intrinsics.stringPlus((String)"Building scan filter for ranging | beaconUID = ", (Object)beaconUID), null, 2, null);
                    scanFilter = RadarBeaconUtils.INSTANCE.getScanFilterForBeaconUID(beaconUID);
                }
                catch (Exception e) {
                    this.logger.d(Intrinsics.stringPlus((String)"Error building scan filter for ranging | beaconUID = ", (Object)beaconUID), e);
                }
                if (scanFilter == null) continue;
                RadarLogger.d$default(this.logger, Intrinsics.stringPlus((String)"Starting ranging beacon UID | beaconUID = ", (Object)beaconUID), null, 2, null);
                scanFilters.add(scanFilter);
            }
        }
        if (scanFilters.size() == 0) {
            RadarLogger.d$default(this.logger, "No scan filters for ranging", null, 2, null);
            RadarBeaconManager.callCallbacks$default(this, null, 1, null);
            return;
        }
        scanSettings = new ScanSettings.Builder().setScanMode(1).setReportDelay(0L).build();
        beaconManager = this;
        this.scanCallback = new ScanCallback(beaconManager, this){
            final /* synthetic */ RadarBeaconManager $beaconManager;
            final /* synthetic */ RadarBeaconManager this$0;
            {
                this.$beaconManager = $beaconManager;
                this.this$0 = $receiver;
            }

            public void onScanResult(int callbackType, @Nullable ScanResult result) {
                super.onScanResult(callbackType, result);
                RadarBeaconManager.handleScanResult$sdk_release$default(this.$beaconManager, result, false, 2, null);
            }

            /*
             * WARNING - void declaration
             */
            public void onBatchScanResults(@Nullable List<ScanResult> results) {
                super.onBatchScanResults(results);
                List<ScanResult> list = results;
                if (list != null) {
                    void $this$forEach$iv;
                    Iterable iterable = list;
                    RadarBeaconManager radarBeaconManager = this.$beaconManager;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        ScanResult result = (ScanResult)element$iv;
                        boolean bl = false;
                        RadarBeaconManager.handleScanResult$sdk_release$default(radarBeaconManager, result, false, 2, null);
                    }
                }
            }

            public void onScanFailed(int errorCode) {
                super.onScanFailed(errorCode);
                RadarLogger.d$default(RadarBeaconManager.access$getLogger$p(this.this$0), "Scan failed", null, 2, null);
                RadarBeaconManager.access$stopRanging(this.$beaconManager);
            }
        };
        try {
            scanFilter = this.adapter;
            if (scanFilter == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
                throw null;
            }
            scanFilter.getBluetoothLeScanner().startScan(scanFilters, scanSettings, this.scanCallback);
        }
        catch (Exception e) {
            this.logger.e("Error starting ranging beacon UUIDs", e);
        }
        this.handler.postAtTime((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, rangeBeaconUUIDs$lambda-4(io.radar.sdk.RadarBeaconManager ), ()V)((RadarBeaconManager)this), (Object)"timeout", SystemClock.uptimeMillis() + 5000L);
    }

    private final void stopRanging() {
        BluetoothAdapter bluetoothAdapter;
        if (!this.permissionsHelper.bluetoothPermissionsGranted$sdk_release(this.context)) {
            return;
        }
        if (!this.isBluetoothSupported$sdk_release(this.context)) {
            return;
        }
        if (this.adapter == null) {
            bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
            Intrinsics.checkNotNullExpressionValue((Object)bluetoothAdapter, (String)"getDefaultAdapter()");
            this.adapter = bluetoothAdapter;
        }
        RadarLogger.d$default(this.logger, "Stopping ranging", null, 2, null);
        this.handler.removeCallbacksAndMessages((Object)TIMEOUT_TOKEN);
        try {
            bluetoothAdapter = this.adapter;
            if (bluetoothAdapter == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
                throw null;
            }
            bluetoothAdapter.getBluetoothLeScanner().stopScan(this.scanCallback);
        }
        catch (Exception e) {
            this.logger.d("Error stopping ranging beacons", e);
        }
        this.scanCallback = null;
        Collection $this$toTypedArray$iv = this.nearbyBeacons;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        RadarBeacon[] radarBeaconArray = thisCollection$iv.toArray(new RadarBeacon[0]);
        if (radarBeaconArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        this.callCallbacks(radarBeaconArray);
        this.beacons = new RadarBeacon[0];
        this.started = false;
        this.nearbyBeacons.clear();
    }

    public final void handleScanResults$sdk_release(@Nullable ArrayList<ScanResult> scanResults) {
        if (scanResults == null || scanResults.isEmpty()) {
            RadarLogger.d$default(this.logger, "No scan results to handle", null, 2, null);
            return;
        }
        Iterable $this$forEach$iv = scanResults;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ScanResult scanResult = (ScanResult)element$iv;
            boolean bl = false;
            this.handleScanResult$sdk_release(scanResult, false);
        }
    }

    public final void handleScanResult$sdk_release(@Nullable ScanResult result, boolean ranging) {
        ScanRecord scanRecord;
        RadarLogger.d$default(this.logger, "Handling scan result", null, 2, null);
        ScanResult scanResult = result;
        if (scanResult != null && (scanRecord = scanResult.getScanRecord()) != null) {
            Object object = scanRecord;
            boolean bl = false;
            boolean bl2 = false;
            ScanRecord scanRecord2 = object;
            boolean bl3 = false;
            RadarBeacon radarBeacon = RadarBeaconUtils.INSTANCE.getBeacon(result, scanRecord2);
            if (radarBeacon != null) {
                object = radarBeacon;
                bl = false;
                bl2 = false;
                Object beacon = object;
                boolean bl4 = false;
                RadarLogger.d$default(this.logger, "Ranged beacon | beacon.type = " + (Object)((Object)((RadarBeacon)beacon).getType()) + "; beacon.uuid = " + ((RadarBeacon)beacon).getUuid() + "; beacon.major = " + ((RadarBeacon)beacon).getMajor() + "; beacon.minor = " + ((RadarBeacon)beacon).getMinor() + "; beacon.rssi = " + ((RadarBeacon)beacon).getRssi(), null, 2, null);
                this.nearbyBeacons.add((RadarBeacon)beacon);
            }
        }
        if (this.nearbyBeacons.size() == this.beacons.length && ranging) {
            RadarLogger.d$default(this.logger, "Finished ranging", null, 2, null);
            this.stopRanging();
        }
    }

    public static /* synthetic */ void handleScanResult$sdk_release$default(RadarBeaconManager radarBeaconManager, ScanResult scanResult, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        radarBeaconManager.handleScanResult$sdk_release(scanResult, bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isBluetoothSupported$sdk_release(@NotNull Context context) {
        BluetoothAdapter bluetoothAdapter;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.adapter == null) {
            bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
            Intrinsics.checkNotNullExpressionValue((Object)bluetoothAdapter, (String)"getDefaultAdapter()");
            this.adapter = bluetoothAdapter;
        }
        if (!context.getPackageManager().hasSystemFeature("android.hardware.bluetooth")) return false;
        bluetoothAdapter = this.adapter;
        if (bluetoothAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
            throw null;
        }
        bluetoothAdapter = this.adapter;
        if (bluetoothAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
            throw null;
        }
        if (bluetoothAdapter.getBluetoothLeScanner() == null) return false;
        return true;
    }

    private static final void rangeBeacons$lambda-3(RadarBeaconManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        RadarLogger.d$default(this$0.logger, "Beacon ranging timeout", null, 2, null);
        this$0.stopRanging();
    }

    private static final void rangeBeaconUUIDs$lambda-4(RadarBeaconManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        RadarLogger.d$default(this$0.logger, "Beacon ranging timeout", null, 2, null);
        this$0.stopRanging();
    }

    public static final /* synthetic */ RadarLogger access$getLogger$p(RadarBeaconManager $this) {
        return $this.logger;
    }

    public static final /* synthetic */ void access$stopRanging(RadarBeaconManager $this) {
        $this.stopRanging();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/radar/sdk/RadarBeaconManager$Companion;", "", "()V", "TIMEOUT_TOKEN", "", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

