/*
 * Decompiled with CFR 0.152.
 */
package io.radar.sdk.model;

import android.location.Location;
import io.radar.sdk.RadarUtils;
import io.radar.sdk.model.RadarBeacon;
import io.radar.sdk.model.RadarGeofence;
import io.radar.sdk.model.RadarPlace;
import io.radar.sdk.model.RadarRegion;
import io.radar.sdk.model.RadarTrip;
import java.util.Collection;
import java.util.Date;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b)\u0018\u0000 G2\u00020\u0001:\u0004GHIJB\u00ad\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u0012\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u0012\u000e\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u0017\u0012\b\u0010\u0018\u001a\u0004\u0018\u00010\u000f\u0012\u0006\u0010\u0019\u001a\u00020\u001a\u0012\u0006\u0010\u001b\u001a\u00020\u001c\u0012\u0006\u0010\u001d\u001a\u00020\u001e\u0012\u0006\u0010\u001f\u001a\u00020 \u0012\b\u0010!\u001a\u0004\u0018\u00010\"\u00a2\u0006\u0002\u0010#J\u0006\u0010F\u001a\u00020\"R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u001b\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u0017\u00a2\u0006\n\n\u0002\u0010*\u001a\u0004\b(\u0010)R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010'R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010%R\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0013\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u0011\u0010\u001f\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108R\u0013\u0010!\u001a\u0004\u0018\u00010\"\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010<R\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010>R\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010@R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010BR\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010DR\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010<\u00a8\u0006K"}, d2={"Lio/radar/sdk/model/RadarEvent;", "", "_id", "", "createdAt", "Ljava/util/Date;", "actualCreatedAt", "live", "", "type", "Lio/radar/sdk/model/RadarEvent$RadarEventType;", "customType", "geofence", "Lio/radar/sdk/model/RadarGeofence;", "place", "Lio/radar/sdk/model/RadarPlace;", "region", "Lio/radar/sdk/model/RadarRegion;", "beacon", "Lio/radar/sdk/model/RadarBeacon;", "trip", "Lio/radar/sdk/model/RadarTrip;", "alternatePlaces", "", "verifiedPlace", "verification", "Lio/radar/sdk/model/RadarEvent$RadarEventVerification;", "confidence", "Lio/radar/sdk/model/RadarEvent$RadarEventConfidence;", "duration", "", "location", "Landroid/location/Location;", "metadata", "Lorg/json/JSONObject;", "(Ljava/lang/String;Ljava/util/Date;Ljava/util/Date;ZLio/radar/sdk/model/RadarEvent$RadarEventType;Ljava/lang/String;Lio/radar/sdk/model/RadarGeofence;Lio/radar/sdk/model/RadarPlace;Lio/radar/sdk/model/RadarRegion;Lio/radar/sdk/model/RadarBeacon;Lio/radar/sdk/model/RadarTrip;[Lio/radar/sdk/model/RadarPlace;Lio/radar/sdk/model/RadarPlace;Lio/radar/sdk/model/RadarEvent$RadarEventVerification;Lio/radar/sdk/model/RadarEvent$RadarEventConfidence;FLandroid/location/Location;Lorg/json/JSONObject;)V", "get_id", "()Ljava/lang/String;", "getActualCreatedAt", "()Ljava/util/Date;", "getAlternatePlaces", "()[Lio/radar/sdk/model/RadarPlace;", "[Lio/radar/sdk/model/RadarPlace;", "getBeacon", "()Lio/radar/sdk/model/RadarBeacon;", "getConfidence", "()Lio/radar/sdk/model/RadarEvent$RadarEventConfidence;", "getCreatedAt", "getCustomType", "getDuration", "()F", "getGeofence", "()Lio/radar/sdk/model/RadarGeofence;", "getLive", "()Z", "getLocation", "()Landroid/location/Location;", "getMetadata", "()Lorg/json/JSONObject;", "getPlace", "()Lio/radar/sdk/model/RadarPlace;", "getRegion", "()Lio/radar/sdk/model/RadarRegion;", "getTrip", "()Lio/radar/sdk/model/RadarTrip;", "getType", "()Lio/radar/sdk/model/RadarEvent$RadarEventType;", "getVerification", "()Lio/radar/sdk/model/RadarEvent$RadarEventVerification;", "getVerifiedPlace", "toJson", "Companion", "RadarEventConfidence", "RadarEventType", "RadarEventVerification", "sdk_release"})
public final class RadarEvent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String _id;
    @NotNull
    private final Date createdAt;
    @NotNull
    private final Date actualCreatedAt;
    private final boolean live;
    @NotNull
    private final RadarEventType type;
    @Nullable
    private final String customType;
    @Nullable
    private final RadarGeofence geofence;
    @Nullable
    private final RadarPlace place;
    @Nullable
    private final RadarRegion region;
    @Nullable
    private final RadarBeacon beacon;
    @Nullable
    private final RadarTrip trip;
    @Nullable
    private final RadarPlace[] alternatePlaces;
    @Nullable
    private final RadarPlace verifiedPlace;
    @NotNull
    private final RadarEventVerification verification;
    @NotNull
    private final RadarEventConfidence confidence;
    private final float duration;
    @NotNull
    private final Location location;
    @Nullable
    private final JSONObject metadata;
    @NotNull
    private static final String FIELD_ID = "_id";
    @NotNull
    private static final String FIELD_CREATED_AT = "createdAt";
    @NotNull
    private static final String FIELD_ACTUAL_CREATED_AT = "actualCreatedAt";
    @NotNull
    private static final String FIELD_LIVE = "live";
    @NotNull
    private static final String FIELD_TYPE = "type";
    @NotNull
    private static final String FIELD_CUSTOM_TYPE = "customType";
    @NotNull
    private static final String FIELD_GEOFENCE = "geofence";
    @NotNull
    private static final String FIELD_PLACE = "place";
    @NotNull
    private static final String FIELD_REGION = "region";
    @NotNull
    private static final String FIELD_BEACON = "beacon";
    @NotNull
    private static final String FIELD_TRIP = "trip";
    @NotNull
    private static final String FIELD_ALTERNATE_PLACES = "alternatePlaces";
    @NotNull
    private static final String FIELD_VERIFIED_PLACE = "verifiedPlace";
    @NotNull
    private static final String FIELD_VERIFICATION = "verification";
    @NotNull
    private static final String FIELD_CONFIDENCE = "confidence";
    @NotNull
    private static final String FIELD_DURATION = "duration";
    @NotNull
    private static final String FIELD_LOCATION = "location";
    @NotNull
    private static final String FIELD_COORDINATES = "coordinates";
    @NotNull
    private static final String FIELD_LOCATION_ACCURACY = "locationAccuracy";
    @NotNull
    private static final String FIELD_METADATA = "metadata";

    public RadarEvent(@NotNull String _id, @NotNull Date createdAt, @NotNull Date actualCreatedAt, boolean live, @NotNull RadarEventType type, @Nullable String customType, @Nullable RadarGeofence geofence, @Nullable RadarPlace place, @Nullable RadarRegion region, @Nullable RadarBeacon beacon, @Nullable RadarTrip trip, @Nullable RadarPlace[] alternatePlaces, @Nullable RadarPlace verifiedPlace, @NotNull RadarEventVerification verification, @NotNull RadarEventConfidence confidence, float duration, @NotNull Location location, @Nullable JSONObject metadata) {
        Intrinsics.checkNotNullParameter((Object)_id, (String)FIELD_ID);
        Intrinsics.checkNotNullParameter((Object)createdAt, (String)FIELD_CREATED_AT);
        Intrinsics.checkNotNullParameter((Object)actualCreatedAt, (String)FIELD_ACTUAL_CREATED_AT);
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)FIELD_TYPE);
        Intrinsics.checkNotNullParameter((Object)((Object)verification), (String)FIELD_VERIFICATION);
        Intrinsics.checkNotNullParameter((Object)((Object)confidence), (String)FIELD_CONFIDENCE);
        Intrinsics.checkNotNullParameter((Object)location, (String)FIELD_LOCATION);
        this._id = _id;
        this.createdAt = createdAt;
        this.actualCreatedAt = actualCreatedAt;
        this.live = live;
        this.type = type;
        this.customType = customType;
        this.geofence = geofence;
        this.place = place;
        this.region = region;
        this.beacon = beacon;
        this.trip = trip;
        this.alternatePlaces = alternatePlaces;
        this.verifiedPlace = verifiedPlace;
        this.verification = verification;
        this.confidence = confidence;
        this.duration = duration;
        this.location = location;
        this.metadata = metadata;
    }

    @NotNull
    public final String get_id() {
        return this._id;
    }

    @NotNull
    public final Date getCreatedAt() {
        return this.createdAt;
    }

    @NotNull
    public final Date getActualCreatedAt() {
        return this.actualCreatedAt;
    }

    public final boolean getLive() {
        return this.live;
    }

    @NotNull
    public final RadarEventType getType() {
        return this.type;
    }

    @Nullable
    public final String getCustomType() {
        return this.customType;
    }

    @Nullable
    public final RadarGeofence getGeofence() {
        return this.geofence;
    }

    @Nullable
    public final RadarPlace getPlace() {
        return this.place;
    }

    @Nullable
    public final RadarRegion getRegion() {
        return this.region;
    }

    @Nullable
    public final RadarBeacon getBeacon() {
        return this.beacon;
    }

    @Nullable
    public final RadarTrip getTrip() {
        return this.trip;
    }

    @Nullable
    public final RadarPlace[] getAlternatePlaces() {
        return this.alternatePlaces;
    }

    @Nullable
    public final RadarPlace getVerifiedPlace() {
        return this.verifiedPlace;
    }

    @NotNull
    public final RadarEventVerification getVerification() {
        return this.verification;
    }

    @NotNull
    public final RadarEventConfidence getConfidence() {
        return this.confidence;
    }

    public final float getDuration() {
        return this.duration;
    }

    @NotNull
    public final Location getLocation() {
        return this.location;
    }

    @Nullable
    public final JSONObject getMetadata() {
        return this.metadata;
    }

    @NotNull
    public final JSONObject toJson() {
        JSONObject obj = new JSONObject();
        obj.putOpt(FIELD_ID, (Object)this._id);
        obj.putOpt(FIELD_CREATED_AT, (Object)RadarUtils.INSTANCE.dateToISOString$sdk_release(this.createdAt));
        obj.putOpt(FIELD_ACTUAL_CREATED_AT, (Object)RadarUtils.INSTANCE.dateToISOString$sdk_release(this.actualCreatedAt));
        obj.putOpt(FIELD_LIVE, (Object)this.live);
        obj.putOpt(FIELD_TYPE, (Object)Companion.stringForType(this.type));
        obj.putOpt(FIELD_CUSTOM_TYPE, (Object)this.customType);
        Object object = this.geofence;
        obj.putOpt(FIELD_GEOFENCE, (Object)(object == null ? null : ((RadarGeofence)object).toJson()));
        object = this.place;
        obj.putOpt(FIELD_PLACE, (Object)(object == null ? null : ((RadarPlace)object).toJson()));
        obj.putOpt(FIELD_CONFIDENCE, (Object)this.confidence);
        obj.putOpt(FIELD_DURATION, (Object)Float.valueOf(this.duration));
        object = this.region;
        obj.putOpt(FIELD_REGION, (Object)(object == null ? null : ((RadarRegion)object).toJson()));
        object = this.beacon;
        obj.putOpt(FIELD_BEACON, (Object)(object == null ? null : ((RadarBeacon)object).toJson()));
        object = this.trip;
        obj.putOpt(FIELD_TRIP, (Object)(object == null ? null : ((RadarTrip)object).toJson()));
        obj.putOpt(FIELD_ALTERNATE_PLACES, (Object)RadarPlace.Companion.toJson(this.alternatePlaces));
        JSONObject locationObj = new JSONObject();
        locationObj.putOpt(FIELD_TYPE, (Object)"Point");
        JSONArray coordinatesArr = new JSONArray();
        coordinatesArr.put(this.location.getLongitude());
        coordinatesArr.put(this.location.getLatitude());
        locationObj.putOpt(FIELD_COORDINATES, (Object)coordinatesArr);
        obj.putOpt(FIELD_LOCATION, (Object)locationObj);
        obj.putOpt(FIELD_METADATA, (Object)this.metadata);
        return obj;
    }

    @JvmStatic
    @Nullable
    public static final RadarEvent fromJson(@Nullable JSONObject obj) {
        return Companion.fromJson(obj);
    }

    @JvmStatic
    @Nullable
    public static final RadarEvent[] fromJson(@Nullable JSONArray arr) {
        return Companion.fromJson(arr);
    }

    @JvmStatic
    @Nullable
    public static final JSONArray toJson(@Nullable RadarEvent[] events) {
        return Companion.toJson(events);
    }

    @JvmStatic
    @Nullable
    public static final String stringForType(@NotNull RadarEventType type) {
        return Companion.stringForType(type);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0019\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019\u00a8\u0006\u001a"}, d2={"Lio/radar/sdk/model/RadarEvent$RadarEventType;", "", "(Ljava/lang/String;I)V", "UNKNOWN", "CUSTOM", "USER_ENTERED_GEOFENCE", "USER_EXITED_GEOFENCE", "USER_DWELLED_IN_GEOFENCE", "USER_ENTERED_PLACE", "USER_EXITED_PLACE", "USER_ENTERED_REGION_COUNTRY", "USER_EXITED_REGION_COUNTRY", "USER_ENTERED_REGION_DMA", "USER_EXITED_REGION_DMA", "USER_ENTERED_REGION_STATE", "USER_EXITED_REGION_STATE", "USER_ENTERED_REGION_POSTAL_CODE", "USER_EXITED_REGION_POSTAL_CODE", "USER_NEARBY_PLACE_CHAIN", "USER_ENTERED_BEACON", "USER_EXITED_BEACON", "USER_STARTED_TRIP", "USER_UPDATED_TRIP", "USER_STOPPED_TRIP", "USER_APPROACHING_TRIP_DESTINATION", "USER_ARRIVED_AT_TRIP_DESTINATION", "sdk_release"})
    public static final class RadarEventType
    extends Enum<RadarEventType> {
        public static final /* enum */ RadarEventType UNKNOWN = new RadarEventType();
        public static final /* enum */ RadarEventType CUSTOM = new RadarEventType();
        public static final /* enum */ RadarEventType USER_ENTERED_GEOFENCE = new RadarEventType();
        public static final /* enum */ RadarEventType USER_EXITED_GEOFENCE = new RadarEventType();
        public static final /* enum */ RadarEventType USER_DWELLED_IN_GEOFENCE = new RadarEventType();
        public static final /* enum */ RadarEventType USER_ENTERED_PLACE = new RadarEventType();
        public static final /* enum */ RadarEventType USER_EXITED_PLACE = new RadarEventType();
        public static final /* enum */ RadarEventType USER_ENTERED_REGION_COUNTRY = new RadarEventType();
        public static final /* enum */ RadarEventType USER_EXITED_REGION_COUNTRY = new RadarEventType();
        public static final /* enum */ RadarEventType USER_ENTERED_REGION_DMA = new RadarEventType();
        public static final /* enum */ RadarEventType USER_EXITED_REGION_DMA = new RadarEventType();
        public static final /* enum */ RadarEventType USER_ENTERED_REGION_STATE = new RadarEventType();
        public static final /* enum */ RadarEventType USER_EXITED_REGION_STATE = new RadarEventType();
        public static final /* enum */ RadarEventType USER_ENTERED_REGION_POSTAL_CODE = new RadarEventType();
        public static final /* enum */ RadarEventType USER_EXITED_REGION_POSTAL_CODE = new RadarEventType();
        public static final /* enum */ RadarEventType USER_NEARBY_PLACE_CHAIN = new RadarEventType();
        public static final /* enum */ RadarEventType USER_ENTERED_BEACON = new RadarEventType();
        public static final /* enum */ RadarEventType USER_EXITED_BEACON = new RadarEventType();
        public static final /* enum */ RadarEventType USER_STARTED_TRIP = new RadarEventType();
        public static final /* enum */ RadarEventType USER_UPDATED_TRIP = new RadarEventType();
        public static final /* enum */ RadarEventType USER_STOPPED_TRIP = new RadarEventType();
        public static final /* enum */ RadarEventType USER_APPROACHING_TRIP_DESTINATION = new RadarEventType();
        public static final /* enum */ RadarEventType USER_ARRIVED_AT_TRIP_DESTINATION = new RadarEventType();
        private static final /* synthetic */ RadarEventType[] $VALUES;

        public static RadarEventType[] values() {
            return (RadarEventType[])$VALUES.clone();
        }

        public static RadarEventType valueOf(String value) {
            return Enum.valueOf(RadarEventType.class, value);
        }

        static {
            $VALUES = radarEventTypeArray = new RadarEventType[]{RadarEventType.UNKNOWN, RadarEventType.CUSTOM, RadarEventType.USER_ENTERED_GEOFENCE, RadarEventType.USER_EXITED_GEOFENCE, RadarEventType.USER_DWELLED_IN_GEOFENCE, RadarEventType.USER_ENTERED_PLACE, RadarEventType.USER_EXITED_PLACE, RadarEventType.USER_ENTERED_REGION_COUNTRY, RadarEventType.USER_EXITED_REGION_COUNTRY, RadarEventType.USER_ENTERED_REGION_DMA, RadarEventType.USER_EXITED_REGION_DMA, RadarEventType.USER_ENTERED_REGION_STATE, RadarEventType.USER_EXITED_REGION_STATE, RadarEventType.USER_ENTERED_REGION_POSTAL_CODE, RadarEventType.USER_EXITED_REGION_POSTAL_CODE, RadarEventType.USER_NEARBY_PLACE_CHAIN, RadarEventType.USER_ENTERED_BEACON, RadarEventType.USER_EXITED_BEACON, RadarEventType.USER_STARTED_TRIP, RadarEventType.USER_UPDATED_TRIP, RadarEventType.USER_STOPPED_TRIP, RadarEventType.USER_APPROACHING_TRIP_DESTINATION, RadarEventType.USER_ARRIVED_AT_TRIP_DESTINATION};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lio/radar/sdk/model/RadarEvent$RadarEventConfidence;", "", "(Ljava/lang/String;I)V", "NONE", "LOW", "MEDIUM", "HIGH", "sdk_release"})
    public static final class RadarEventConfidence
    extends Enum<RadarEventConfidence> {
        public static final /* enum */ RadarEventConfidence NONE = new RadarEventConfidence();
        public static final /* enum */ RadarEventConfidence LOW = new RadarEventConfidence();
        public static final /* enum */ RadarEventConfidence MEDIUM = new RadarEventConfidence();
        public static final /* enum */ RadarEventConfidence HIGH = new RadarEventConfidence();
        private static final /* synthetic */ RadarEventConfidence[] $VALUES;

        public static RadarEventConfidence[] values() {
            return (RadarEventConfidence[])$VALUES.clone();
        }

        public static RadarEventConfidence valueOf(String value) {
            return Enum.valueOf(RadarEventConfidence.class, value);
        }

        static {
            $VALUES = radarEventConfidenceArray = new RadarEventConfidence[]{RadarEventConfidence.NONE, RadarEventConfidence.LOW, RadarEventConfidence.MEDIUM, RadarEventConfidence.HIGH};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lio/radar/sdk/model/RadarEvent$RadarEventVerification;", "", "(Ljava/lang/String;I)V", "ACCEPT", "UNVERIFY", "REJECT", "sdk_release"})
    public static final class RadarEventVerification
    extends Enum<RadarEventVerification> {
        public static final /* enum */ RadarEventVerification ACCEPT = new RadarEventVerification();
        public static final /* enum */ RadarEventVerification UNVERIFY = new RadarEventVerification();
        public static final /* enum */ RadarEventVerification REJECT = new RadarEventVerification();
        private static final /* synthetic */ RadarEventVerification[] $VALUES;

        public static RadarEventVerification[] values() {
            return (RadarEventVerification[])$VALUES.clone();
        }

        public static RadarEventVerification valueOf(String value) {
            return Enum.valueOf(RadarEventVerification.class, value);
        }

        static {
            $VALUES = radarEventVerificationArray = new RadarEventVerification[]{RadarEventVerification.ACCEPT, RadarEventVerification.UNVERIFY, RadarEventVerification.REJECT};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0014\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u00192\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0007\u00a2\u0006\u0002\u0010\u001dJ\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0007J\u0012\u0010 \u001a\u0004\u0018\u00010\u00042\u0006\u0010!\u001a\u00020\"H\u0007J\u001f\u0010#\u001a\u0004\u0018\u00010\u001c2\u000e\u0010$\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u0019H\u0007\u00a2\u0006\u0002\u0010%R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lio/radar/sdk/model/RadarEvent$Companion;", "", "()V", "FIELD_ACTUAL_CREATED_AT", "", "FIELD_ALTERNATE_PLACES", "FIELD_BEACON", "FIELD_CONFIDENCE", "FIELD_COORDINATES", "FIELD_CREATED_AT", "FIELD_CUSTOM_TYPE", "FIELD_DURATION", "FIELD_GEOFENCE", "FIELD_ID", "FIELD_LIVE", "FIELD_LOCATION", "FIELD_LOCATION_ACCURACY", "FIELD_METADATA", "FIELD_PLACE", "FIELD_REGION", "FIELD_TRIP", "FIELD_TYPE", "FIELD_VERIFICATION", "FIELD_VERIFIED_PLACE", "fromJson", "", "Lio/radar/sdk/model/RadarEvent;", "arr", "Lorg/json/JSONArray;", "(Lorg/json/JSONArray;)[Lio/radar/sdk/model/RadarEvent;", "obj", "Lorg/json/JSONObject;", "stringForType", "type", "Lio/radar/sdk/model/RadarEvent$RadarEventType;", "toJson", "events", "([Lio/radar/sdk/model/RadarEvent;)Lorg/json/JSONArray;", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Unable to fully structure code
         */
        @JvmStatic
        @Nullable
        public final RadarEvent fromJson(@Nullable JSONObject obj) {
            if (obj == null) {
                return null;
            }
            var3_2 = obj.optString("_id");
            id = var3_2 == null ? "" : var3_2;
            var4_4 = RadarUtils.INSTANCE.isoStringToDate$sdk_release(obj.optString("createdAt"));
            createdAt = var4_4 == null ? new Date() : var4_4;
            var5_5 = RadarUtils.INSTANCE.isoStringToDate$sdk_release(obj.optString("actualCreatedAt"));
            actualCreatedAt = var5_5 == null ? new Date() : var5_5;
            live = obj.optBoolean("live");
            var7_7 = obj.optString("type");
            if (var7_7 == null) ** GOTO lbl-1000
            tmp = -1;
            switch (var7_7.hashCode()) {
                case 568887265: {
                    if (var7_7.equals("user.entered_region_postal_code")) {
                        tmp = 1;
                    }
                    break;
                }
                case -258182923: {
                    if (var7_7.equals("user.exited_region_postal_code")) {
                        tmp = 2;
                    }
                    break;
                }
                case -1251605361: {
                    if (var7_7.equals("user.entered_beacon")) {
                        tmp = 3;
                    }
                    break;
                }
                case 1577140650: {
                    if (var7_7.equals("user.exited_region_country")) {
                        tmp = 4;
                    }
                    break;
                }
                case -1005364232: {
                    if (var7_7.equals("user.entered_region_dma")) {
                        tmp = 5;
                    }
                    break;
                }
                case 1081142108: {
                    if (var7_7.equals("user.entered_place")) {
                        tmp = 6;
                    }
                    break;
                }
                case 325491979: {
                    if (var7_7.equals("user.entered_geofence")) {
                        tmp = 7;
                    }
                    break;
                }
                case 1376657564: {
                    if (var7_7.equals("user.approaching_trip_destination")) {
                        tmp = 8;
                    }
                    break;
                }
                case 1650830998: {
                    if (var7_7.equals("user.entered_region_country")) {
                        tmp = 9;
                    }
                    break;
                }
                case 226679697: {
                    if (var7_7.equals("user.entered_region_state")) {
                        tmp = 10;
                    }
                    break;
                }
                case -844188518: {
                    if (var7_7.equals("user.stopped_trip")) {
                        tmp = 11;
                    }
                    break;
                }
                case 1196434341: {
                    if (var7_7.equals("user.exited_region_state")) {
                        tmp = 12;
                    }
                    break;
                }
                case -103183764: {
                    if (var7_7.equals("user.updated_trip")) {
                        tmp = 13;
                    }
                    break;
                }
                case 385587468: {
                    if (var7_7.equals("user.exited_region_dma")) {
                        tmp = 14;
                    }
                    break;
                }
                case 158452425: {
                    if (var7_7.equals("user.dwelled_in_geofence")) {
                        tmp = 15;
                    }
                    break;
                }
                case 678548235: {
                    if (var7_7.equals("user.arrived_at_trip_destination")) {
                        tmp = 16;
                    }
                    break;
                }
                case -1716268600: {
                    if (var7_7.equals("user.exited_place")) {
                        tmp = 17;
                    }
                    break;
                }
                case 1356297932: {
                    if (var7_7.equals("user.nearby_place_chain")) {
                        tmp = 18;
                    }
                    break;
                }
                case -2086465761: {
                    if (var7_7.equals("user.exited_geofence")) {
                        tmp = 19;
                    }
                    break;
                }
                case -2071991389: {
                    if (var7_7.equals("user.exited_beacon")) {
                        tmp = 20;
                    }
                    break;
                }
                case 968365670: {
                    if (var7_7.equals("user.started_trip")) {
                        tmp = 21;
                    }
                    break;
                }
            }
            switch (tmp) {
                case 7: {
                    v0 = RadarEventType.USER_ENTERED_GEOFENCE;
                    break;
                }
                case 19: {
                    v0 = RadarEventType.USER_EXITED_GEOFENCE;
                    break;
                }
                case 15: {
                    v0 = RadarEventType.USER_DWELLED_IN_GEOFENCE;
                    break;
                }
                case 6: {
                    v0 = RadarEventType.USER_ENTERED_PLACE;
                    break;
                }
                case 17: {
                    v0 = RadarEventType.USER_EXITED_PLACE;
                    break;
                }
                case 9: {
                    v0 = RadarEventType.USER_ENTERED_REGION_COUNTRY;
                    break;
                }
                case 4: {
                    v0 = RadarEventType.USER_EXITED_REGION_COUNTRY;
                    break;
                }
                case 5: {
                    v0 = RadarEventType.USER_ENTERED_REGION_DMA;
                    break;
                }
                case 14: {
                    v0 = RadarEventType.USER_EXITED_REGION_DMA;
                    break;
                }
                case 10: {
                    v0 = RadarEventType.USER_ENTERED_REGION_STATE;
                    break;
                }
                case 12: {
                    v0 = RadarEventType.USER_EXITED_REGION_STATE;
                    break;
                }
                case 1: {
                    v0 = RadarEventType.USER_ENTERED_REGION_POSTAL_CODE;
                    break;
                }
                case 2: {
                    v0 = RadarEventType.USER_EXITED_REGION_POSTAL_CODE;
                    break;
                }
                case 18: {
                    v0 = RadarEventType.USER_NEARBY_PLACE_CHAIN;
                    break;
                }
                case 3: {
                    v0 = RadarEventType.USER_ENTERED_BEACON;
                    break;
                }
                case 20: {
                    v0 = RadarEventType.USER_EXITED_BEACON;
                    break;
                }
                case 21: {
                    v0 = RadarEventType.USER_STARTED_TRIP;
                    break;
                }
                case 13: {
                    v0 = RadarEventType.USER_UPDATED_TRIP;
                    break;
                }
                case 11: {
                    v0 = RadarEventType.USER_STOPPED_TRIP;
                    break;
                }
                case 8: {
                    v0 = RadarEventType.USER_APPROACHING_TRIP_DESTINATION;
                    break;
                }
                case 16: {
                    v0 = RadarEventType.USER_ARRIVED_AT_TRIP_DESTINATION;
                    break;
                }
                default: lbl-1000:
                // 2 sources

                {
                    v0 = RadarEventType.CUSTOM;
                }
            }
            type = v0;
            customType = null;
            if (type == RadarEventType.CUSTOM) {
                customType = obj.optString("type");
            }
            geofence = RadarGeofence.Companion.fromJson(obj.optJSONObject("geofence"));
            place = RadarPlace.Companion.fromJson(obj.optJSONObject("place"));
            region = RadarRegion.Companion.fromJson(obj.optJSONObject("region"));
            beacon = RadarBeacon.Companion.fromJson(obj.optJSONObject("beacon"));
            trip = RadarTrip.Companion.fromJson(obj.optJSONObject("trip"));
            alternatePlaces = RadarPlace.Companion.fromJson(obj.optJSONArray("alternatePlaces"));
            verifiedPlace = RadarPlace.Companion.fromJson(obj.optJSONObject("verifiedPlace"));
            var16_16 = obj.optInt("verification");
            switch (var16_16) {
                case 1: {
                    v1 = RadarEventVerification.ACCEPT;
                    break;
                }
                case -1: {
                    v1 = RadarEventVerification.REJECT;
                    break;
                }
                default: {
                    v1 = RadarEventVerification.UNVERIFY;
                }
            }
            verification = v1;
            var17_19 = obj.optInt("confidence");
            switch (var17_19) {
                case 3: {
                    v2 = RadarEventConfidence.HIGH;
                    break;
                }
                case 2: {
                    v2 = RadarEventConfidence.MEDIUM;
                    break;
                }
                case 1: {
                    v2 = RadarEventConfidence.LOW;
                    break;
                }
                default: {
                    v2 = RadarEventConfidence.NONE;
                }
            }
            confidence = v2;
            duration = (float)obj.optDouble("duration", 0.0);
            var20_22 = locationObj = obj.optJSONObject("location");
            locationCoordinatesObj = var20_22 == null ? null : var20_22.optJSONArray("coordinates");
            var21_24 = new Location("RadarSDK");
            var22_25 = false;
            var23_27 = false;
            $this$fromJson_u24lambda_u2d0 = var21_24;
            $i$a$-apply-RadarEvent$Companion$fromJson$location$1 = false;
            var26_30 = locationCoordinatesObj;
            $this$fromJson_u24lambda_u2d0.setLongitude(var26_30 == null ? 0.0 : (var27_31 = var26_30.optDouble(0)));
            var26_30 = locationCoordinatesObj;
            $this$fromJson_u24lambda_u2d0.setLatitude(var26_30 == null ? 0.0 : (var27_31 = var26_30.optDouble(1)));
            if (obj.has("locationAccuracy")) {
                $this$fromJson_u24lambda_u2d0.setAccuracy((float)obj.optDouble("locationAccuracy"));
            }
            $this$fromJson_u24lambda_u2d0.setTime(createdAt.getTime());
            location = var21_24;
            metadata = obj.optJSONObject("metadata");
            event = new RadarEvent(id, createdAt, actualCreatedAt, live, type, customType, geofence, place, region, beacon, trip, alternatePlaces, verifiedPlace, verification, confidence, duration, location, metadata);
            return event;
        }

        @JvmStatic
        @Nullable
        public final RadarEvent[] fromJson(@Nullable JSONArray arr) {
            if (arr == null) {
                return null;
            }
            int n = 0;
            int n2 = arr.length();
            Object[] objectArray = new RadarEvent[n2];
            while (n < n2) {
                int n3 = n++;
                objectArray[n3] = Companion.fromJson(arr.optJSONObject(n3));
            }
            Collection $this$toTypedArray$iv = ArraysKt.filterNotNull((Object[])objectArray);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            RadarEvent[] radarEventArray = thisCollection$iv.toArray(new RadarEvent[0]);
            if (radarEventArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            return radarEventArray;
        }

        @JvmStatic
        @Nullable
        public final JSONArray toJson(@Nullable RadarEvent[] events) {
            if (events == null) {
                return null;
            }
            JSONArray arr = new JSONArray();
            RadarEvent[] $this$forEach$iv = events;
            boolean $i$f$forEach = false;
            RadarEvent[] radarEventArray = $this$forEach$iv;
            int n = radarEventArray.length;
            for (int i = 0; i < n; ++i) {
                RadarEvent element$iv;
                RadarEvent event = element$iv = radarEventArray[i];
                boolean bl = false;
                arr.put((Object)event.toJson());
            }
            return arr;
        }

        @JvmStatic
        @Nullable
        public final String stringForType(@NotNull RadarEventType type) {
            String string;
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)RadarEvent.FIELD_TYPE);
            RadarEventType radarEventType = type;
            int n = WhenMappings.$EnumSwitchMapping$0[radarEventType.ordinal()];
            switch (n) {
                case 1: {
                    string = "user.entered_geofence";
                    break;
                }
                case 2: {
                    string = "user.exited_geofence";
                    break;
                }
                case 3: {
                    string = "user.dwelled_in_geofence";
                    break;
                }
                case 4: {
                    string = "user.entered_place";
                    break;
                }
                case 5: {
                    string = "user.exited_place";
                    break;
                }
                case 6: {
                    string = "user.entered_region_country";
                    break;
                }
                case 7: {
                    string = "user.exited_region_country";
                    break;
                }
                case 8: {
                    string = "user.entered_region_dma";
                    break;
                }
                case 9: {
                    string = "user.exited_region_dma";
                    break;
                }
                case 10: {
                    string = "user.entered_region_state";
                    break;
                }
                case 11: {
                    string = "user.exited_region_state";
                    break;
                }
                case 12: {
                    string = "user.entered_region_postal_code";
                    break;
                }
                case 13: {
                    string = "user.exited_region_postal_code";
                    break;
                }
                case 14: {
                    string = "user.nearby_place_chain";
                    break;
                }
                case 15: {
                    string = "user.entered_beacon";
                    break;
                }
                case 16: {
                    string = "user.exited_beacon";
                    break;
                }
                case 17: {
                    string = "user.started_trip";
                    break;
                }
                case 18: {
                    string = "user.updated_trip";
                    break;
                }
                case 19: {
                    string = "user.stopped_trip";
                    break;
                }
                case 20: {
                    string = "user.approaching_trip_destination";
                    break;
                }
                case 21: {
                    string = "user.arrived_at_trip_destination";
                    break;
                }
                default: {
                    string = null;
                }
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[RadarEventType.values().length];
                nArray[RadarEventType.USER_ENTERED_GEOFENCE.ordinal()] = 1;
                nArray[RadarEventType.USER_EXITED_GEOFENCE.ordinal()] = 2;
                nArray[RadarEventType.USER_DWELLED_IN_GEOFENCE.ordinal()] = 3;
                nArray[RadarEventType.USER_ENTERED_PLACE.ordinal()] = 4;
                nArray[RadarEventType.USER_EXITED_PLACE.ordinal()] = 5;
                nArray[RadarEventType.USER_ENTERED_REGION_COUNTRY.ordinal()] = 6;
                nArray[RadarEventType.USER_EXITED_REGION_COUNTRY.ordinal()] = 7;
                nArray[RadarEventType.USER_ENTERED_REGION_DMA.ordinal()] = 8;
                nArray[RadarEventType.USER_EXITED_REGION_DMA.ordinal()] = 9;
                nArray[RadarEventType.USER_ENTERED_REGION_STATE.ordinal()] = 10;
                nArray[RadarEventType.USER_EXITED_REGION_STATE.ordinal()] = 11;
                nArray[RadarEventType.USER_ENTERED_REGION_POSTAL_CODE.ordinal()] = 12;
                nArray[RadarEventType.USER_EXITED_REGION_POSTAL_CODE.ordinal()] = 13;
                nArray[RadarEventType.USER_NEARBY_PLACE_CHAIN.ordinal()] = 14;
                nArray[RadarEventType.USER_ENTERED_BEACON.ordinal()] = 15;
                nArray[RadarEventType.USER_EXITED_BEACON.ordinal()] = 16;
                nArray[RadarEventType.USER_STARTED_TRIP.ordinal()] = 17;
                nArray[RadarEventType.USER_UPDATED_TRIP.ordinal()] = 18;
                nArray[RadarEventType.USER_STOPPED_TRIP.ordinal()] = 19;
                nArray[RadarEventType.USER_APPROACHING_TRIP_DESTINATION.ordinal()] = 20;
                nArray[RadarEventType.USER_ARRIVED_AT_TRIP_DESTINATION.ordinal()] = 21;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

