/*
 * Decompiled with CFR 0.152.
 */
package io.radar.sdk;

import android.content.Context;
import android.location.Location;
import android.os.Build;
import android.os.SystemClock;
import io.radar.sdk.Radar;
import io.radar.sdk.RadarApiHelper;
import io.radar.sdk.RadarLogger;
import io.radar.sdk.RadarSettings;
import io.radar.sdk.RadarState;
import io.radar.sdk.RadarTrackingOptions;
import io.radar.sdk.RadarTripOptions;
import io.radar.sdk.RadarUtils;
import io.radar.sdk.model.RadarAddress;
import io.radar.sdk.model.RadarBeacon;
import io.radar.sdk.model.RadarConfig;
import io.radar.sdk.model.RadarContext;
import io.radar.sdk.model.RadarEvent;
import io.radar.sdk.model.RadarGeofence;
import io.radar.sdk.model.RadarLog;
import io.radar.sdk.model.RadarPlace;
import io.radar.sdk.model.RadarReplay;
import io.radar.sdk.model.RadarRouteMatrix;
import io.radar.sdk.model.RadarRoutes;
import io.radar.sdk.model.RadarTrip;
import io.radar.sdk.model.RadarUser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00fc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0000\u0018\u00002\u00020\u0001:\u001a\u0082\u0001\u0083\u0001\u0084\u0001\u0085\u0001\u0086\u0001\u0087\u0001\u0088\u0001\u0089\u0001\u008a\u0001\u008b\u0001\u008c\u0001\u008d\u0001\u008e\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJU\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0010\b\u0002\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00162\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u00a2\u0006\u0004\b\u001a\u0010\u001bJ!\u0010\u001c\u001a\u00020\u000e2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u0018\u001a\u0004\u0018\u00010\u001fH\u0000\u00a2\u0006\u0002\b J\u001d\u0010!\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b\"J/\u0010#\u001a\u00020\u000e2\n\b\u0002\u0010$\u001a\u0004\u0018\u00010\u00102\b\b\u0002\u0010%\u001a\u00020&2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010'H\u0000\u00a2\u0006\u0002\b(J\u001d\u0010)\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020+H\u0000\u00a2\u0006\u0002\b,JC\u0010-\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020\u00122\u0006\u0010/\u001a\u00020\u00122\f\u00100\u001a\b\u0012\u0004\u0012\u000202012\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u000206H\u0000\u00a2\u0006\u0002\b7JC\u00108\u001a\u00020\u000e2\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u00120\u00142\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00120\u00142\u0006\u0010;\u001a\u0002022\u0006\u00103\u001a\u0002042\u0006\u0010\u0018\u001a\u00020<H\u0000\u00a2\u0006\u0004\b=\u0010>J\u001c\u0010?\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100@2\u0006\u0010A\u001a\u00020\u0010H\u0002J\u0015\u0010B\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020CH\u0000\u00a2\u0006\u0002\bDJ%\u0010E\u001a\u00020\u000e2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020H0G2\b\u0010\u0018\u001a\u0004\u0018\u00010IH\u0000\u00a2\u0006\u0002\bJJ\u001d\u0010K\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\bLJ9\u0010M\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020\u00122\u0006\u0010N\u001a\u00020\u00162\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0018\u001a\u00020O2\u0006\u0010P\u001a\u00020&H\u0000\u00a2\u0006\u0004\bQ\u0010RJK\u0010S\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020\u00122\u0006\u0010N\u001a\u00020\u00162\u000e\u0010T\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u00142\b\u0010U\u001a\u0004\u0018\u00010V2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0018\u001a\u00020WH\u0000\u00a2\u0006\u0004\bX\u0010YJw\u0010Z\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020\u00122\u0006\u0010N\u001a\u00020\u00162\u000e\u0010[\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u00142\u0014\u0010\\\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0010\u0018\u00010@2\u000e\u0010]\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u00142\u000e\u0010^\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0018\u001a\u00020_H\u0000\u00a2\u0006\u0004\b`\u0010aJC\u0010b\u001a\u00020\u000e2\u0006\u0010c\u001a\u00020\u00102\b\u0010U\u001a\u0004\u0018\u00010V2\b\u0010d\u001a\u0004\u0018\u00010e2\u000e\u0010f\u001a\n\u0012\u0004\u0012\u00020g\u0018\u00010\u00142\u0006\u0010\u0018\u001a\u00020hH\u0000\u00a2\u0006\u0004\bi\u0010jJu\u0010k\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020\u00122\u0006\u0010l\u001a\u00020&2\u0006\u0010m\u001a\u00020&2\u0006\u0010n\u001a\u00020o2\u0006\u0010p\u001a\u00020&2\u000e\u0010q\u001a\n\u0012\u0004\u0012\u00020r\u0018\u00010\u00142\b\b\u0002\u0010%\u001a\u00020&2\n\b\u0002\u0010s\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010t\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010uH\u0000\u00a2\u0006\u0004\bv\u0010wJ+\u0010x\u001a\u00020\u000e2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010y\u001a\u0004\u0018\u00010z2\b\u0010\u0018\u001a\u0004\u0018\u00010\u001fH\u0000\u00a2\u0006\u0002\b{J+\u0010|\u001a\u00020\u000e2\u0006\u0010}\u001a\u00020\u00102\u0006\u0010~\u001a\u00020\u007f2\u000b\b\u0002\u0010\u0080\u0001\u001a\u0004\u0018\u00010\u0010H\u0000\u00a2\u0006\u0003\b\u0081\u0001R\u001a\u0010\u0006\u001a\u00020\u0007X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u008f\u0001"}, d2={"Lio/radar/sdk/RadarApiClient;", "", "context", "Landroid/content/Context;", "logger", "Lio/radar/sdk/RadarLogger;", "apiHelper", "Lio/radar/sdk/RadarApiHelper;", "(Landroid/content/Context;Lio/radar/sdk/RadarLogger;Lio/radar/sdk/RadarApiHelper;)V", "getApiHelper$sdk_release", "()Lio/radar/sdk/RadarApiHelper;", "setApiHelper$sdk_release", "(Lio/radar/sdk/RadarApiHelper;)V", "autocomplete", "", "query", "", "near", "Landroid/location/Location;", "layers", "", "limit", "", "country", "callback", "Lio/radar/sdk/RadarApiClient$RadarGeocodeApiCallback;", "autocomplete$sdk_release", "(Ljava/lang/String;Landroid/location/Location;[Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;Lio/radar/sdk/RadarApiClient$RadarGeocodeApiCallback;)V", "createTrip", "options", "Lio/radar/sdk/RadarTripOptions;", "Lio/radar/sdk/RadarApiClient$RadarTripApiCallback;", "createTrip$sdk_release", "geocode", "geocode$sdk_release", "getConfig", "usage", "verified", "", "Lio/radar/sdk/RadarApiClient$RadarGetConfigApiCallback;", "getConfig$sdk_release", "getContext", "location", "Lio/radar/sdk/RadarApiClient$RadarContextApiCallback;", "getContext$sdk_release", "getDistance", "origin", "destination", "modes", "Ljava/util/EnumSet;", "Lio/radar/sdk/Radar$RadarRouteMode;", "units", "Lio/radar/sdk/Radar$RadarRouteUnits;", "geometryPoints", "Lio/radar/sdk/RadarApiClient$RadarDistanceApiCallback;", "getDistance$sdk_release", "getMatrix", "origins", "destinations", "mode", "Lio/radar/sdk/RadarApiClient$RadarMatrixApiCallback;", "getMatrix$sdk_release", "([Landroid/location/Location;[Landroid/location/Location;Lio/radar/sdk/Radar$RadarRouteMode;Lio/radar/sdk/Radar$RadarRouteUnits;Lio/radar/sdk/RadarApiClient$RadarMatrixApiCallback;)V", "headers", "", "publishableKey", "ipGeocode", "Lio/radar/sdk/RadarApiClient$RadarIpGeocodeApiCallback;", "ipGeocode$sdk_release", "log", "logs", "", "Lio/radar/sdk/model/RadarLog;", "Lio/radar/sdk/RadarApiClient$RadarLogCallback;", "log$sdk_release", "reverseGeocode", "reverseGeocode$sdk_release", "searchBeacons", "radius", "Lio/radar/sdk/RadarApiClient$RadarSearchBeaconsApiCallback;", "cache", "searchBeacons$sdk_release", "(Landroid/location/Location;ILjava/lang/Integer;Lio/radar/sdk/RadarApiClient$RadarSearchBeaconsApiCallback;Z)V", "searchGeofences", "tags", "metadata", "Lorg/json/JSONObject;", "Lio/radar/sdk/RadarApiClient$RadarSearchGeofencesApiCallback;", "searchGeofences$sdk_release", "(Landroid/location/Location;I[Ljava/lang/String;Lorg/json/JSONObject;Ljava/lang/Integer;Lio/radar/sdk/RadarApiClient$RadarSearchGeofencesApiCallback;)V", "searchPlaces", "chains", "chainMetadata", "categories", "groups", "Lio/radar/sdk/RadarApiClient$RadarSearchPlacesApiCallback;", "searchPlaces$sdk_release", "(Landroid/location/Location;I[Ljava/lang/String;Ljava/util/Map;[Ljava/lang/String;[Ljava/lang/String;Ljava/lang/Integer;Lio/radar/sdk/RadarApiClient$RadarSearchPlacesApiCallback;)V", "sendEvent", "name", "user", "Lio/radar/sdk/model/RadarUser;", "trackingEvents", "Lio/radar/sdk/model/RadarEvent;", "Lio/radar/sdk/RadarApiClient$RadarSendEventApiCallback;", "sendEvent$sdk_release", "(Ljava/lang/String;Lorg/json/JSONObject;Lio/radar/sdk/model/RadarUser;[Lio/radar/sdk/model/RadarEvent;Lio/radar/sdk/RadarApiClient$RadarSendEventApiCallback;)V", "track", "stopped", "foreground", "source", "Lio/radar/sdk/Radar$RadarLocationSource;", "replayed", "beacons", "Lio/radar/sdk/model/RadarBeacon;", "integrityToken", "integrityException", "Lio/radar/sdk/RadarApiClient$RadarTrackApiCallback;", "track$sdk_release", "(Landroid/location/Location;ZZLio/radar/sdk/Radar$RadarLocationSource;Z[Lio/radar/sdk/model/RadarBeacon;ZLjava/lang/String;Ljava/lang/String;Lio/radar/sdk/RadarApiClient$RadarTrackApiCallback;)V", "updateTrip", "status", "Lio/radar/sdk/model/RadarTrip$RadarTripStatus;", "updateTrip$sdk_release", "verifyEvent", "eventId", "verification", "Lio/radar/sdk/model/RadarEvent$RadarEventVerification;", "verifiedPlaceId", "verifyEvent$sdk_release", "RadarContextApiCallback", "RadarDistanceApiCallback", "RadarGeocodeApiCallback", "RadarGetConfigApiCallback", "RadarIpGeocodeApiCallback", "RadarLogCallback", "RadarMatrixApiCallback", "RadarSearchBeaconsApiCallback", "RadarSearchGeofencesApiCallback", "RadarSearchPlacesApiCallback", "RadarSendEventApiCallback", "RadarTrackApiCallback", "RadarTripApiCallback", "sdk_release"})
public final class RadarApiClient {
    @NotNull
    private final Context context;
    @NotNull
    private RadarLogger logger;
    @NotNull
    private RadarApiHelper apiHelper;

    public RadarApiClient(@NotNull Context context, @NotNull RadarLogger logger, @NotNull RadarApiHelper apiHelper) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)apiHelper, (String)"apiHelper");
        this.context = context;
        this.logger = logger;
        this.apiHelper = apiHelper;
    }

    public /* synthetic */ RadarApiClient(Context context, RadarLogger radarLogger, RadarApiHelper radarApiHelper, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            radarApiHelper = new RadarApiHelper(radarLogger);
        }
        this(context, radarLogger, radarApiHelper);
    }

    @NotNull
    public final RadarApiHelper getApiHelper$sdk_release() {
        return this.apiHelper;
    }

    public final void setApiHelper$sdk_release(@NotNull RadarApiHelper radarApiHelper) {
        Intrinsics.checkNotNullParameter((Object)radarApiHelper, (String)"<set-?>");
        this.apiHelper = radarApiHelper;
    }

    private final Map<String, String> headers(String publishableKey) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"Authorization", (Object)publishableKey), TuplesKt.to((Object)"Content-Type", (Object)"application/json"), TuplesKt.to((Object)"X-Radar-Config", (Object)"true"), TuplesKt.to((Object)"X-Radar-Device-Make", (Object)RadarUtils.INSTANCE.getDeviceMake$sdk_release()), TuplesKt.to((Object)"X-Radar-Device-Model", (Object)RadarUtils.INSTANCE.getDeviceModel$sdk_release()), TuplesKt.to((Object)"X-Radar-Device-OS", (Object)RadarUtils.INSTANCE.getDeviceOS$sdk_release()), TuplesKt.to((Object)"X-Radar-Device-Type", (Object)"Android"), TuplesKt.to((Object)"X-Radar-SDK-Version", (Object)"3.6.0-beta.8")};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    public final void getConfig$sdk_release(@Nullable String usage, boolean verified, @Nullable RadarGetConfigApiCallback callback) {
        String string = RadarSettings.INSTANCE.getPublishableKey$sdk_release(this.context);
        if (string == null) {
            return;
        }
        String publishableKey = string;
        StringBuilder queryParams = new StringBuilder();
        queryParams.append(Intrinsics.stringPlus((String)"installId=", (Object)RadarSettings.INSTANCE.getInstallId$sdk_release(this.context)));
        queryParams.append(Intrinsics.stringPlus((String)"&sessionId=", (Object)RadarSettings.INSTANCE.getSessionId$sdk_release(this.context)));
        queryParams.append(Intrinsics.stringPlus((String)"&locationAuthorization=", (Object)RadarUtils.INSTANCE.getLocationAuthorization$sdk_release(this.context)));
        queryParams.append(Intrinsics.stringPlus((String)"&locationAccuracyAuthorization=", (Object)RadarUtils.INSTANCE.getLocationAccuracyAuthorization$sdk_release(this.context)));
        queryParams.append(Intrinsics.stringPlus((String)"&verified=", (Object)verified));
        if (usage != null) {
            queryParams.append(Intrinsics.stringPlus((String)"&usage=", (Object)usage));
        }
        String path = Intrinsics.stringPlus((String)"v1/config?", (Object)queryParams);
        Map<String, String> headers = this.headers(publishableKey);
        RadarApiHelper.request$sdk_release$default(this.apiHelper, this.context, "GET", path, headers, null, false, new RadarApiHelper.RadarApiCallback(callback){
            final /* synthetic */ RadarGetConfigApiCallback $callback;
            {
                this.$callback = $callback;
            }

            public void onComplete(@NotNull Radar.RadarStatus status, @Nullable JSONObject res) {
                RadarGetConfigApiCallback radarGetConfigApiCallback;
                Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
                if (status == Radar.RadarStatus.SUCCESS) {
                    Radar.flushLogs$sdk_release();
                }
                if ((radarGetConfigApiCallback = this.$callback) != null) {
                    radarGetConfigApiCallback.onComplete(RadarConfig.Companion.fromJson(res));
                }
            }
        }, false, true, verified, false, 1024, null);
    }

    public static /* synthetic */ void getConfig$sdk_release$default(RadarApiClient radarApiClient, String string, boolean bl, RadarGetConfigApiCallback radarGetConfigApiCallback, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            radarGetConfigApiCallback = null;
        }
        radarApiClient.getConfig$sdk_release(string, bl, radarGetConfigApiCallback);
    }

    public final void log$sdk_release(@NotNull List<RadarLog> logs, @Nullable RadarLogCallback callback) {
        Intrinsics.checkNotNullParameter(logs, (String)"logs");
        String publishableKey = RadarSettings.INSTANCE.getPublishableKey$sdk_release(this.context);
        if (publishableKey == null) {
            RadarLogCallback radarLogCallback = callback;
            if (radarLogCallback != null) {
                RadarLogCallback.DefaultImpls.onComplete$default(radarLogCallback, Radar.RadarStatus.ERROR_PUBLISHABLE_KEY, null, 2, null);
            }
            return;
        }
        JSONObject params = new JSONObject();
        try {
            params.putOpt("id", (Object)RadarSettings.INSTANCE.getId$sdk_release(this.context));
            params.putOpt("deviceId", (Object)RadarUtils.INSTANCE.getDeviceId$sdk_release(this.context));
            params.putOpt("installId", (Object)RadarSettings.INSTANCE.getInstallId$sdk_release(this.context));
            params.putOpt("sessionId", (Object)RadarSettings.INSTANCE.getSessionId$sdk_release(this.context));
            JSONArray array = new JSONArray();
            Iterable $this$forEach$iv = logs;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RadarLog log2 = (RadarLog)element$iv;
                boolean bl = false;
                array.put((Object)log2.toJson());
            }
            params.putOpt("logs", (Object)array);
        }
        catch (JSONException e) {
            RadarLogCallback radarLogCallback = callback;
            if (radarLogCallback != null) {
                RadarLogCallback.DefaultImpls.onComplete$default(radarLogCallback, Radar.RadarStatus.ERROR_BAD_REQUEST, null, 2, null);
            }
            return;
        }
        String path = "v1/logs";
        RadarApiHelper.request$sdk_release$default(this.apiHelper, this.context, "POST", path, this.headers(publishableKey), params, false, new RadarApiHelper.RadarApiCallback(callback){
            final /* synthetic */ RadarLogCallback $callback;
            {
                this.$callback = $callback;
            }

            public void onComplete(@NotNull Radar.RadarStatus status, @Nullable JSONObject res) {
                Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
                RadarLogCallback radarLogCallback = this.$callback;
                if (radarLogCallback != null) {
                    radarLogCallback.onComplete(status, res);
                }
            }
        }, false, true, false, false, 1024, null);
    }

    public final void track$sdk_release(@NotNull Location location, boolean stopped, boolean foreground, @NotNull Radar.RadarLocationSource source, boolean replayed, @Nullable RadarBeacon[] beacons, boolean verified, @Nullable String integrityToken, @Nullable String integrityException, @Nullable RadarTrackApiCallback callback) {
        boolean replaying;
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
        String publishableKey = RadarSettings.INSTANCE.getPublishableKey$sdk_release(this.context);
        if (publishableKey == null) {
            RadarTrackApiCallback radarTrackApiCallback = callback;
            if (radarTrackApiCallback != null) {
                RadarTrackApiCallback.DefaultImpls.onComplete$default(radarTrackApiCallback, Radar.RadarStatus.ERROR_PUBLISHABLE_KEY, null, null, null, null, null, 62, null);
            }
            return;
        }
        JSONObject params = new JSONObject();
        RadarTrackingOptions options = Radar.getTrackingOptions();
        RadarTripOptions tripOptions = RadarSettings.INSTANCE.getTripOptions$sdk_release(this.context);
        boolean anonymous = RadarSettings.INSTANCE.getAnonymousTrackingEnabled$sdk_release(this.context);
        try {
            boolean bl;
            float f;
            float accuracy;
            block31: {
                block30: {
                    params.putOpt("anonymous", (Object)anonymous);
                    if (anonymous) {
                        params.putOpt("deviceId", (Object)"anonymous");
                        params.putOpt("geofenceIds", (Object)new JSONArray((Collection)RadarState.INSTANCE.getGeofenceIds$sdk_release(this.context)));
                        params.putOpt("placeId", (Object)RadarState.INSTANCE.getPlaceId$sdk_release(this.context));
                        params.putOpt("regionIds", (Object)new JSONArray((Collection)RadarState.INSTANCE.getRegionIds$sdk_release(this.context)));
                        params.putOpt("beaconIds", (Object)new JSONArray((Collection)RadarState.INSTANCE.getBeaconIds$sdk_release(this.context)));
                    } else {
                        params.putOpt("id", (Object)RadarSettings.INSTANCE.getId$sdk_release(this.context));
                        params.putOpt("installId", (Object)RadarSettings.INSTANCE.getInstallId$sdk_release(this.context));
                        params.putOpt("userId", (Object)RadarSettings.INSTANCE.getUserId$sdk_release(this.context));
                        params.putOpt("deviceId", (Object)RadarUtils.INSTANCE.getDeviceId$sdk_release(this.context));
                        params.putOpt("description", (Object)RadarSettings.INSTANCE.getDescription$sdk_release(this.context));
                        params.putOpt("metadata", (Object)RadarSettings.INSTANCE.getMetadata$sdk_release(this.context));
                        params.putOpt("sessionId", (Object)RadarSettings.INSTANCE.getSessionId$sdk_release(this.context));
                    }
                    params.putOpt("latitude", (Object)location.getLatitude());
                    params.putOpt("longitude", (Object)location.getLongitude());
                    accuracy = location.getAccuracy();
                    if (!location.hasAccuracy()) break block30;
                    f = location.getAccuracy();
                    bl = false;
                    if (!Float.isNaN(f) && !(accuracy <= 0.0f)) break block31;
                }
                accuracy = 1.0f;
            }
            params.putOpt("accuracy", (Object)Float.valueOf(accuracy));
            if (location.hasSpeed()) {
                f = location.getSpeed();
                bl = false;
                if (!Float.isNaN(f)) {
                    params.putOpt("speed", (Object)Float.valueOf(location.getSpeed()));
                }
            }
            if (location.hasBearing()) {
                f = location.getBearing();
                bl = false;
                if (!Float.isNaN(f)) {
                    params.putOpt("course", (Object)Float.valueOf(location.getBearing()));
                }
            }
            if (Build.VERSION.SDK_INT >= 26) {
                if (location.hasVerticalAccuracy()) {
                    f = location.getVerticalAccuracyMeters();
                    bl = false;
                    if (!Float.isNaN(f)) {
                        params.putOpt("verticalAccuracy", (Object)Float.valueOf(location.getVerticalAccuracyMeters()));
                    }
                }
                if (location.hasSpeedAccuracy()) {
                    f = location.getSpeedAccuracyMetersPerSecond();
                    bl = false;
                    if (!Float.isNaN(f)) {
                        params.putOpt("speedAccuracy", (Object)Float.valueOf(location.getSpeedAccuracyMetersPerSecond()));
                    }
                }
                if (location.hasBearingAccuracy()) {
                    f = location.getBearingAccuracyDegrees();
                    bl = false;
                    if (!Float.isNaN(f)) {
                        params.putOpt("courseAccuracy", (Object)Float.valueOf(location.getBearingAccuracyDegrees()));
                    }
                }
            }
            if (!foreground && Build.VERSION.SDK_INT >= 17) {
                long updatedAtMsDiff = (SystemClock.elapsedRealtimeNanos() - location.getElapsedRealtimeNanos()) / (long)1000000;
                params.putOpt("updatedAtMsDiff", (Object)updatedAtMsDiff);
            }
            params.putOpt("foreground", (Object)foreground);
            params.putOpt("stopped", (Object)stopped);
            params.putOpt("replayed", (Object)replayed);
            params.putOpt("deviceType", (Object)"Android");
            params.putOpt("deviceMake", (Object)RadarUtils.INSTANCE.getDeviceMake$sdk_release());
            params.putOpt("sdkVersion", (Object)"3.6.0-beta.8");
            params.putOpt("deviceModel", (Object)RadarUtils.INSTANCE.getDeviceModel$sdk_release());
            params.putOpt("deviceOS", (Object)RadarUtils.INSTANCE.getDeviceOS$sdk_release());
            params.putOpt("deviceType", (Object)"Android");
            params.putOpt("deviceMake", (Object)RadarUtils.INSTANCE.getDeviceMake$sdk_release());
            params.putOpt("country", (Object)RadarUtils.INSTANCE.getCountry$sdk_release());
            params.putOpt("timeZoneOffset", (Object)RadarUtils.INSTANCE.getTimeZoneOffset$sdk_release());
            params.putOpt("source", (Object)Radar.stringForSource(source));
            if (Build.VERSION.SDK_INT >= 18) {
                boolean mocked = location.isFromMockProvider();
                params.putOpt("mocked", (Object)mocked);
            }
            if (tripOptions != null) {
                JSONObject tripOptionsObj = new JSONObject();
                tripOptionsObj.putOpt("version", (Object)"2");
                tripOptionsObj.putOpt("externalId", (Object)tripOptions.getExternalId());
                tripOptionsObj.putOpt("metadata", (Object)tripOptions.getMetadata());
                tripOptionsObj.putOpt("destinationGeofenceTag", (Object)tripOptions.getDestinationGeofenceTag());
                tripOptionsObj.putOpt("destinationGeofenceExternalId", (Object)tripOptions.getDestinationGeofenceExternalId());
                tripOptionsObj.putOpt("mode", (Object)Radar.stringForMode(tripOptions.getMode()));
                params.putOpt("tripOptions", (Object)tripOptionsObj);
            }
            if (options.getSyncGeofences()) {
                params.putOpt("nearbyGeofences", (Object)true);
                params.putOpt("nearbyGeofencesLimit", (Object)options.getSyncGeofencesLimit());
            }
            if (beacons != null) {
                params.putOpt("beacons", (Object)RadarBeacon.Companion.toJson(beacons));
            }
            params.putOpt("locationAuthorization", (Object)RadarUtils.INSTANCE.getLocationAuthorization$sdk_release(this.context));
            params.putOpt("locationAccuracyAuthorization", (Object)RadarUtils.INSTANCE.getLocationAccuracyAuthorization$sdk_release(this.context));
            params.putOpt("trackingOptions", (Object)Radar.getTrackingOptions().toJson());
            boolean usingRemoteTrackingOptions = RadarSettings.INSTANCE.getTracking$sdk_release(this.context) && RadarSettings.INSTANCE.getRemoteTrackingOptions$sdk_release(this.context) != null;
            params.putOpt("usingRemoteTrackingOptions", (Object)usingRemoteTrackingOptions);
            params.putOpt("locationServicesProvider", (Object)RadarSettings.INSTANCE.getLocationServicesProvider$sdk_release(this.context));
            params.putOpt("verified", (Object)verified);
            if (verified) {
                params.putOpt("integrityToken", (Object)integrityToken);
                params.putOpt("integrityException", (Object)integrityException);
                params.putOpt("sharing", (Object)RadarUtils.INSTANCE.isScreenSharing$sdk_release(this.context));
            }
            params.putOpt("appId", (Object)this.context.getPackageName());
        }
        catch (JSONException e) {
            RadarTrackApiCallback usingRemoteTrackingOptions = callback;
            if (usingRemoteTrackingOptions != null) {
                RadarTrackApiCallback.DefaultImpls.onComplete$default(usingRemoteTrackingOptions, Radar.RadarStatus.ERROR_BAD_REQUEST, null, null, null, null, null, 62, null);
            }
            return;
        }
        String path = "v1/track";
        Map<String, String> headers = this.headers(publishableKey);
        if (anonymous) {
            String usage = "track";
            RadarApiClient.getConfig$sdk_release$default(this, usage, false, null, 6, null);
        }
        List<RadarReplay> replays = Radar.getReplays$sdk_release();
        int replayCount = replays.size();
        JSONObject requestParams = params;
        long nowMS = System.currentTimeMillis();
        boolean bl = replaying = replayCount > 0 && options.getReplay() == RadarTrackingOptions.RadarTrackingOptionsReplay.ALL;
        if (replaying) {
            boolean bl2 = false;
            List replaysList = new ArrayList();
            for (RadarReplay replay : replays) {
                replaysList.add(replay.getReplayParams());
            }
            replaysList.add(params);
            path = "v1/track/replay";
            requestParams = new JSONObject();
            requestParams.putOpt("replays", (Object)new JSONArray((Collection)replaysList));
        }
        this.apiHelper.request$sdk_release(this.context, "POST", path, headers, requestParams, true, new RadarApiHelper.RadarApiCallback(options, params, nowMS, stopped, source, this, location, callback){
            final /* synthetic */ RadarTrackingOptions $options;
            final /* synthetic */ JSONObject $params;
            final /* synthetic */ long $nowMS;
            final /* synthetic */ boolean $stopped;
            final /* synthetic */ Radar.RadarLocationSource $source;
            final /* synthetic */ RadarApiClient this$0;
            final /* synthetic */ Location $location;
            final /* synthetic */ RadarTrackApiCallback $callback;
            {
                this.$options = $options;
                this.$params = $params;
                this.$nowMS = $nowMS;
                this.$stopped = $stopped;
                this.$source = $source;
                this.this$0 = $receiver;
                this.$location = $location;
                this.$callback = $callback;
            }

            /*
             * Unable to fully structure code
             */
            public void onComplete(@NotNull Radar.RadarStatus status, @Nullable JSONObject res) {
                block26: {
                    Intrinsics.checkNotNullParameter((Object)status, (String)"status");
                    if (status != Radar.RadarStatus.SUCCESS || res == null) {
                        if (this.$options.getReplay() == RadarTrackingOptions.RadarTrackingOptionsReplay.ALL) {
                            this.$params.putOpt("replayed", (Object)true);
                            this.$params.putOpt("updatedAtMs", (Object)this.$nowMS);
                            this.$params.remove("updatedAtMsDiff");
                            Radar.addReplay$sdk_release(this.$params);
                        } else if (this.$options.getReplay() == RadarTrackingOptions.RadarTrackingOptionsReplay.STOPS && this.$stopped && this.$source != Radar.RadarLocationSource.FOREGROUND_LOCATION && this.$source != Radar.RadarLocationSource.BACKGROUND_LOCATION) {
                            RadarState.INSTANCE.setLastFailedStoppedLocation$sdk_release(RadarApiClient.access$getContext$p(this.this$0), this.$location);
                        }
                        Radar.INSTANCE.sendError$sdk_release(status);
                        var3_3 = this.$callback;
                        if (var3_3 != null) {
                            RadarTrackApiCallback.DefaultImpls.onComplete$default(var3_3, status, null, null, null, null, null, 62, null);
                        }
                        return;
                    }
                    Radar.clearReplays$sdk_release();
                    RadarState.INSTANCE.setLastFailedStoppedLocation$sdk_release(RadarApiClient.access$getContext$p(this.this$0), null);
                    Radar.flushLogs$sdk_release();
                    config = RadarConfig.Companion.fromJson(res);
                    var5_5 = res.optJSONArray("events");
                    if (var5_5 == null) {
                        v0 = null;
                    } else {
                        var6_6 = var5_5;
                        var7_7 = false;
                        var8_14 = false;
                        eventsArr = var6_6;
                        $i$a$-let-RadarApiClient$track$1$onComplete$events$1 = false;
                        v0 = RadarEvent.Companion.fromJson(eventsArr);
                    }
                    events = v0;
                    var6_6 = res.optJSONObject("user");
                    if (var6_6 == null) {
                        v1 = null;
                    } else {
                        var7_8 = var6_6;
                        var8_14 = false;
                        eventsArr = false;
                        userObj = var7_8;
                        $i$a$-let-RadarApiClient$track$1$onComplete$user$1 = false;
                        v1 = RadarUser.Companion.fromJson((JSONObject)userObj);
                    }
                    user = v1;
                    var7_9 = res.optJSONArray("nearbyGeofences");
                    if (var7_9 == null) {
                        v2 = null;
                    } else {
                        var8_15 = var7_9;
                        eventsArr = false;
                        userObj = false;
                        nearbyGeofencesArr = var8_15;
                        $i$a$-let-RadarApiClient$track$1$onComplete$nearbyGeofences$1 = false;
                        v2 = RadarGeofence.Companion.fromJson(nearbyGeofencesArr);
                    }
                    nearbyGeofences = v2;
                    if (user == null) break block26;
                    if (user.getGeofences() == null) ** GOTO lbl-1000
                    var8_16 = user.getGeofences();
                    eventsArr = false;
                    userObj = var8_16;
                    nearbyGeofencesArr = false;
                    if (userObj.length == 0 == false) {
                        v3 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v3 = false;
                    }
                    inGeofences = v3;
                    atPlace = user.getPlace() != null;
                    canExit = inGeofences != false || atPlace != false;
                    RadarState.INSTANCE.setCanExit$sdk_release(RadarApiClient.access$getContext$p(this.this$0), canExit);
                    nearbyGeofencesArr = false;
                    geofenceIds = new LinkedHashSet<E>();
                    nearbyGeofencesArr = user.getGeofences();
                    if (nearbyGeofencesArr != null) {
                        $this$forEach$iv = nearbyGeofencesArr;
                        $i$f$forEach = false;
                        var14_38 = $this$forEach$iv;
                        var15_41 = ((RadarGeofence[])var14_38).length;
                        for (var16_43 = 0; var16_43 < var15_41; ++var16_43) {
                            geofence = element$iv = var14_38[var16_43];
                            $i$a$-forEach-RadarApiClient$track$1$onComplete$1 = false;
                            geofenceIds.add(geofence.get_id());
                        }
                    }
                    RadarState.INSTANCE.setGeofenceIds$sdk_release(RadarApiClient.access$getContext$p(this.this$0), geofenceIds);
                    $this$forEach$iv = user.getPlace();
                    placeId = $this$forEach$iv == null ? null : $this$forEach$iv.get_id();
                    RadarState.INSTANCE.setPlaceId$sdk_release(RadarApiClient.access$getContext$p(this.this$0), placeId);
                    $i$f$forEach = false;
                    regionIds = new LinkedHashSet<E>();
                    $i$f$forEach = user.getCountry();
                    if ($i$f$forEach != null) {
                        var14_38 = $i$f$forEach;
                        var15_41 = 0;
                        var16_43 = 0;
                        country = var14_38;
                        $i$a$-let-RadarApiClient$track$1$onComplete$2 = false;
                        regionIds.add(country.get_id());
                    }
                    $i$f$forEach = user.getState();
                    if ($i$f$forEach != null) {
                        var14_38 = $i$f$forEach;
                        var15_41 = 0;
                        var16_43 = 0;
                        state = var14_38;
                        $i$a$-let-RadarApiClient$track$1$onComplete$3 = false;
                        regionIds.add(state.get_id());
                    }
                    $i$f$forEach = user.getDma();
                    if ($i$f$forEach != null) {
                        var14_38 = $i$f$forEach;
                        var15_41 = 0;
                        var16_43 = 0;
                        dma = var14_38;
                        $i$a$-let-RadarApiClient$track$1$onComplete$4 = false;
                        regionIds.add(dma.get_id());
                    }
                    $i$f$forEach = user.getPostalCode();
                    if ($i$f$forEach != null) {
                        var14_38 = $i$f$forEach;
                        var15_41 = 0;
                        var16_43 = 0;
                        postalCode = var14_38;
                        $i$a$-let-RadarApiClient$track$1$onComplete$5 = false;
                        regionIds.add(postalCode.get_id());
                    }
                    RadarState.INSTANCE.setRegionIds$sdk_release(RadarApiClient.access$getContext$p(this.this$0), regionIds);
                    var14_39 = false;
                    beaconIds = new LinkedHashSet<E>();
                    var14_40 = user.getBeacons();
                    if (var14_40 != null) {
                        $this$forEach$iv = var14_40;
                        $i$f$forEach = false;
                        var17_44 = $this$forEach$iv;
                        var18_50 = var17_44.length;
                        for (var19_51 = 0; var19_51 < var18_50; ++var19_51) {
                            beacon = element$iv = var17_44[var19_51];
                            $i$a$-forEach-RadarApiClient$track$1$onComplete$6 = false;
                            var23_55 = beacon.get_id();
                            if (var23_55 == null) continue;
                            var24_56 = var23_55;
                            var25_57 = false;
                            var26_58 = false;
                            _id = var24_56;
                            $i$a$-let-RadarApiClient$track$1$onComplete$6$1 = false;
                            beaconIds.add(_id);
                        }
                    }
                    RadarState.INSTANCE.setBeaconIds$sdk_release(RadarApiClient.access$getContext$p(this.this$0), beaconIds);
                }
                if (events != null && user != null) {
                    RadarSettings.INSTANCE.setId$sdk_release(RadarApiClient.access$getContext$p(this.this$0), user.get_id());
                    if (user.getTrip() == null && (tripOptions = RadarSettings.INSTANCE.getTripOptions$sdk_release(RadarApiClient.access$getContext$p(this.this$0))) != null) {
                        Radar.INSTANCE.getLocationManager$sdk_release().restartPreviousTrackingOptions$sdk_release();
                        RadarSettings.INSTANCE.setTripOptions$sdk_release(RadarApiClient.access$getContext$p(this.this$0), null);
                    }
                    RadarSettings.INSTANCE.setUserDebug$sdk_release(RadarApiClient.access$getContext$p(this.this$0), user.getDebug());
                    Radar.INSTANCE.sendLocation$sdk_release(this.$location, user);
                    var7_12 = events;
                    var8_18 = false;
                    var9_19 = var7_12;
                    var10_28 = false;
                    if (var9_19.length == 0 == false) {
                        Radar.INSTANCE.sendEvents$sdk_release(events, user);
                    }
                    if ((var7_12 = this.$callback) != null) {
                        var7_12.onComplete(Radar.RadarStatus.SUCCESS, res, events, user, nearbyGeofences, config);
                    }
                    return;
                }
                Radar.INSTANCE.sendError$sdk_release(status);
                var7_13 = this.$callback;
                if (var7_13 != null) {
                    RadarTrackApiCallback.DefaultImpls.onComplete$default(var7_13, Radar.RadarStatus.ERROR_SERVER, null, null, null, null, null, 62, null);
                }
            }
        }, replaying, false, !replaying, verified);
    }

    public static /* synthetic */ void track$sdk_release$default(RadarApiClient radarApiClient, Location location, boolean bl, boolean bl2, Radar.RadarLocationSource radarLocationSource, boolean bl3, RadarBeacon[] radarBeaconArray, boolean bl4, String string, String string2, RadarTrackApiCallback radarTrackApiCallback, int n, Object object) {
        if ((n & 0x40) != 0) {
            bl4 = false;
        }
        if ((n & 0x80) != 0) {
            string = null;
        }
        if ((n & 0x100) != 0) {
            string2 = null;
        }
        if ((n & 0x200) != 0) {
            radarTrackApiCallback = null;
        }
        radarApiClient.track$sdk_release(location, bl, bl2, radarLocationSource, bl3, radarBeaconArray, bl4, string, string2, radarTrackApiCallback);
    }

    public final void verifyEvent$sdk_release(@NotNull String eventId, @NotNull RadarEvent.RadarEventVerification verification, @Nullable String verifiedPlaceId) {
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        Intrinsics.checkNotNullParameter((Object)((Object)verification), (String)"verification");
        String string = RadarSettings.INSTANCE.getPublishableKey$sdk_release(this.context);
        if (string == null) {
            return;
        }
        String publishableKey = string;
        JSONObject params = new JSONObject();
        params.putOpt("verification", (Object)verification);
        params.putOpt("verifiedPlaceId", (Object)verifiedPlaceId);
        String path = "v1/events/" + eventId + "/verification";
        Map<String, String> headers = this.headers(publishableKey);
        RadarApiHelper.request$sdk_release$default(this.apiHelper, this.context, "PUT", path, headers, params, false, null, false, false, false, false, 1984, null);
    }

    public static /* synthetic */ void verifyEvent$sdk_release$default(RadarApiClient radarApiClient, String string, RadarEvent.RadarEventVerification radarEventVerification, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        radarApiClient.verifyEvent$sdk_release(string, radarEventVerification, string2);
    }

    public final void createTrip$sdk_release(@Nullable RadarTripOptions options, @Nullable RadarTripApiCallback callback) {
        String externalId;
        String publishableKey = RadarSettings.INSTANCE.getPublishableKey$sdk_release(this.context);
        if (publishableKey == null) {
            RadarTripApiCallback radarTripApiCallback = callback;
            if (radarTripApiCallback != null) {
                RadarTripApiCallback.DefaultImpls.onComplete$default(radarTripApiCallback, Radar.RadarStatus.ERROR_PUBLISHABLE_KEY, null, null, null, 14, null);
            }
            return;
        }
        Object object = options;
        String string = externalId = object == null ? null : ((RadarTripOptions)object).getExternalId();
        if (externalId == null) {
            object = callback;
            if (object != null) {
                RadarTripApiCallback.DefaultImpls.onComplete$default((RadarTripApiCallback)object, Radar.RadarStatus.ERROR_BAD_REQUEST, null, null, null, 14, null);
            }
            return;
        }
        JSONObject params = new JSONObject();
        params.putOpt("userId", (Object)RadarSettings.INSTANCE.getUserId$sdk_release(this.context));
        params.putOpt("externalId", (Object)externalId);
        if (options.getMetadata() != null) {
            params.putOpt("metadata", (Object)options.getMetadata());
        }
        if (options.getDestinationGeofenceTag() != null) {
            params.putOpt("destinationGeofenceTag", (Object)options.getDestinationGeofenceTag());
        }
        if (options.getDestinationGeofenceExternalId() != null) {
            params.putOpt("destinationGeofenceExternalId", (Object)options.getDestinationGeofenceExternalId());
        }
        params.putOpt("mode", (Object)Radar.stringForMode(options.getMode()));
        params.putOpt("scheduledArrivalAt", (Object)RadarUtils.INSTANCE.dateToISOString$sdk_release(options.getScheduledArrivalAt()));
        if (options.getApproachingThreshold() > 0) {
            params.put("approachingThreshold", options.getApproachingThreshold());
        }
        String path = "v1/trips";
        Map<String, String> headers = this.headers(publishableKey);
        RadarApiHelper.request$sdk_release$default(this.apiHelper, this.context, "POST", path, headers, params, false, new RadarApiHelper.RadarApiCallback(callback){
            final /* synthetic */ RadarTripApiCallback $callback;
            {
                this.$callback = $callback;
            }

            public void onComplete(@NotNull Radar.RadarStatus status, @Nullable JSONObject res) {
                RadarEvent[] radarEventArray;
                boolean bl;
                boolean bl2;
                Object object;
                RadarTrip radarTrip;
                Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
                if (status != Radar.RadarStatus.SUCCESS || res == null) {
                    RadarTripApiCallback radarTripApiCallback = this.$callback;
                    if (radarTripApiCallback != null) {
                        RadarTripApiCallback.DefaultImpls.onComplete$default(radarTripApiCallback, status, null, null, null, 14, null);
                    }
                    return;
                }
                JSONObject jSONObject = res.optJSONObject("trip");
                if (jSONObject == null) {
                    radarTrip = null;
                } else {
                    object = jSONObject;
                    bl2 = false;
                    bl = false;
                    JSONObject tripObj = object;
                    boolean bl3 = false;
                    radarTrip = RadarTrip.Companion.fromJson(tripObj);
                }
                RadarTrip trip = radarTrip;
                object = res.optJSONArray("events");
                if (object == null) {
                    radarEventArray = null;
                } else {
                    JSONObject jSONObject2 = object;
                    bl = false;
                    boolean bl4 = false;
                    JSONObject eventsArr = jSONObject2;
                    boolean bl5 = false;
                    radarEventArray = RadarEvent.Companion.fromJson((JSONArray)eventsArr);
                }
                RadarEvent[] events = radarEventArray;
                if (events != null) {
                    object = events;
                    bl2 = false;
                    Object object2 = object;
                    boolean bl6 = false;
                    if (!(((JSONObject)object2).length == 0)) {
                        Radar.sendEvents$sdk_release$default(Radar.INSTANCE, events, null, 2, null);
                    }
                }
                if ((object = this.$callback) != null) {
                    object.onComplete(Radar.RadarStatus.SUCCESS, res, trip, events);
                }
            }
        }, false, false, false, false, 1920, null);
    }

    public final void updateTrip$sdk_release(@Nullable RadarTripOptions options, @Nullable RadarTrip.RadarTripStatus status, @Nullable RadarTripApiCallback callback) {
        String externalId;
        String publishableKey = RadarSettings.INSTANCE.getPublishableKey$sdk_release(this.context);
        if (publishableKey == null) {
            RadarTripApiCallback radarTripApiCallback = callback;
            if (radarTripApiCallback != null) {
                RadarTripApiCallback.DefaultImpls.onComplete$default(radarTripApiCallback, Radar.RadarStatus.ERROR_PUBLISHABLE_KEY, null, null, null, 14, null);
            }
            return;
        }
        Object object = options;
        String string = externalId = object == null ? null : ((RadarTripOptions)object).getExternalId();
        if (externalId == null) {
            object = callback;
            if (object != null) {
                RadarTripApiCallback.DefaultImpls.onComplete$default((RadarTripApiCallback)object, Radar.RadarStatus.ERROR_BAD_REQUEST, null, null, null, 14, null);
            }
            return;
        }
        JSONObject params = new JSONObject();
        params.putOpt("userId", (Object)RadarSettings.INSTANCE.getUserId$sdk_release(this.context));
        if (status != null && status != RadarTrip.RadarTripStatus.UNKNOWN) {
            params.putOpt("status", (Object)Radar.stringForTripStatus(status));
        }
        if (options.getMetadata() != null) {
            params.putOpt("metadata", (Object)options.getMetadata());
        }
        if (options.getDestinationGeofenceTag() != null) {
            params.putOpt("destinationGeofenceTag", (Object)options.getDestinationGeofenceTag());
        }
        if (options.getDestinationGeofenceExternalId() != null) {
            params.putOpt("destinationGeofenceExternalId", (Object)options.getDestinationGeofenceExternalId());
        }
        params.putOpt("mode", (Object)Radar.stringForMode(options.getMode()));
        params.putOpt("scheduledArrivalAt", (Object)RadarUtils.INSTANCE.dateToISOString$sdk_release(options.getScheduledArrivalAt()));
        if (options.getApproachingThreshold() > 0) {
            params.put("approachingThreshold", options.getApproachingThreshold());
        }
        String path = "v1/trips/" + externalId + "/update";
        Map<String, String> headers = this.headers(publishableKey);
        RadarApiHelper.request$sdk_release$default(this.apiHelper, this.context, "PATCH", path, headers, params, false, new RadarApiHelper.RadarApiCallback(callback){
            final /* synthetic */ RadarTripApiCallback $callback;
            {
                this.$callback = $callback;
            }

            public void onComplete(@NotNull Radar.RadarStatus status, @Nullable JSONObject res) {
                RadarEvent[] radarEventArray;
                boolean bl;
                boolean bl2;
                Object object;
                RadarTrip radarTrip;
                Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
                if (status != Radar.RadarStatus.SUCCESS || res == null) {
                    RadarTripApiCallback radarTripApiCallback = this.$callback;
                    if (radarTripApiCallback != null) {
                        RadarTripApiCallback.DefaultImpls.onComplete$default(radarTripApiCallback, status, null, null, null, 14, null);
                    }
                    return;
                }
                JSONObject jSONObject = res.optJSONObject("trip");
                if (jSONObject == null) {
                    radarTrip = null;
                } else {
                    object = jSONObject;
                    bl2 = false;
                    bl = false;
                    JSONObject tripObj = object;
                    boolean bl3 = false;
                    radarTrip = RadarTrip.Companion.fromJson(tripObj);
                }
                RadarTrip trip = radarTrip;
                object = res.optJSONArray("events");
                if (object == null) {
                    radarEventArray = null;
                } else {
                    JSONObject jSONObject2 = object;
                    bl = false;
                    boolean bl4 = false;
                    JSONObject eventsArr = jSONObject2;
                    boolean bl5 = false;
                    radarEventArray = RadarEvent.Companion.fromJson((JSONArray)eventsArr);
                }
                RadarEvent[] events = radarEventArray;
                if (events != null) {
                    object = events;
                    bl2 = false;
                    Object object2 = object;
                    boolean bl6 = false;
                    if (!(((JSONObject)object2).length == 0)) {
                        Radar.sendEvents$sdk_release$default(Radar.INSTANCE, events, null, 2, null);
                    }
                }
                if ((object = this.$callback) != null) {
                    object.onComplete(Radar.RadarStatus.SUCCESS, res, trip, events);
                }
            }
        }, false, false, false, false, 1920, null);
    }

    public final void getContext$sdk_release(@NotNull Location location, @NotNull RadarContextApiCallback callback) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        String publishableKey = RadarSettings.INSTANCE.getPublishableKey$sdk_release(this.context);
        if (publishableKey == null) {
            RadarContextApiCallback.DefaultImpls.onComplete$default(callback, Radar.RadarStatus.ERROR_PUBLISHABLE_KEY, null, null, 6, null);
            return;
        }
        StringBuilder queryParams = new StringBuilder();
        queryParams.append("coordinates=" + location.getLatitude() + ',' + location.getLongitude());
        String path = Intrinsics.stringPlus((String)"v1/context?", (Object)queryParams);
        Map<String, String> headers = this.headers(publishableKey);
        RadarApiHelper.request$sdk_release$default(this.apiHelper, this.context, "GET", path, headers, null, false, new RadarApiHelper.RadarApiCallback(callback){
            final /* synthetic */ RadarContextApiCallback $callback;
            {
                this.$callback = $callback;
            }

            public void onComplete(@NotNull Radar.RadarStatus status, @Nullable JSONObject res) {
                RadarContext radarContext;
                Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
                if (status != Radar.RadarStatus.SUCCESS || res == null) {
                    RadarContextApiCallback.DefaultImpls.onComplete$default(this.$callback, status, null, null, 6, null);
                    return;
                }
                JSONObject jSONObject = res.optJSONObject("context");
                if (jSONObject == null) {
                    radarContext = null;
                } else {
                    JSONObject jSONObject2 = jSONObject;
                    boolean bl = false;
                    boolean bl2 = false;
                    JSONObject contextObj = jSONObject2;
                    boolean bl3 = false;
                    radarContext = RadarContext.Companion.fromJson(contextObj);
                }
                RadarContext context = radarContext;
                if (context != null) {
                    this.$callback.onComplete(Radar.RadarStatus.SUCCESS, res, context);
                    return;
                }
                RadarContextApiCallback.DefaultImpls.onComplete$default(this.$callback, Radar.RadarStatus.ERROR_SERVER, null, null, 6, null);
            }
        }, false, false, false, false, 1920, null);
    }

    public final void searchPlaces$sdk_release(@NotNull Location location, int radius, @Nullable String[] chains, @Nullable Map<String, String> chainMetadata, @Nullable String[] categories, @Nullable String[] groups, @Nullable Integer limit, @NotNull RadarSearchPlacesApiCallback callback) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        String[] stringArray;
        boolean bl4;
        Object object;
        boolean bl5;
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        String publishableKey = RadarSettings.INSTANCE.getPublishableKey$sdk_release(this.context);
        if (publishableKey == null) {
            RadarSearchPlacesApiCallback.DefaultImpls.onComplete$default(callback, Radar.RadarStatus.ERROR_PUBLISHABLE_KEY, null, null, 6, null);
            return;
        }
        StringBuilder queryParams = new StringBuilder();
        queryParams.append("near=" + location.getLatitude() + ',' + location.getLongitude());
        queryParams.append(Intrinsics.stringPlus((String)"&radius=", (Object)radius));
        queryParams.append(Intrinsics.stringPlus((String)"&limit=", (Object)limit));
        Object object2 = chains;
        if (object2 == null) {
            bl5 = false;
        } else {
            object = object2;
            bl4 = false;
            stringArray = object;
            bl3 = false;
            bl5 = !(stringArray.length == 0);
        }
        if (bl5) {
            queryParams.append(Intrinsics.stringPlus((String)"&chains=", (Object)ArraysKt.joinToString$default((Object[])chains, (CharSequence)",", null, null, (int)0, null, null, (int)62, null)));
        }
        if ((object2 = categories) == null) {
            bl2 = false;
        } else {
            object = object2;
            bl4 = false;
            stringArray = object;
            bl3 = false;
            bl2 = !(stringArray.length == 0);
        }
        if (bl2) {
            queryParams.append(Intrinsics.stringPlus((String)"&categories=", (Object)ArraysKt.joinToString$default((Object[])categories, (CharSequence)",", null, null, (int)0, null, null, (int)62, null)));
        }
        if ((object2 = groups) == null) {
            bl = false;
        } else {
            object = object2;
            bl4 = false;
            stringArray = object;
            bl3 = false;
            bl = !(stringArray.length == 0);
        }
        if (bl) {
            queryParams.append(Intrinsics.stringPlus((String)"&groups=", (Object)ArraysKt.joinToString$default((Object[])groups, (CharSequence)",", null, null, (int)0, null, null, (int)62, null)));
        }
        if ((object2 = chainMetadata) != null && (object = object2.entrySet()) != null) {
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry it = (Map.Entry)element$iv;
                boolean bl6 = false;
                queryParams.append("&chainMetadata[" + (String)it.getKey() + "]=\"" + (String)it.getValue() + '\"');
            }
        }
        String path = Intrinsics.stringPlus((String)"v1/search/places?", (Object)queryParams);
        Map<String, String> headers = this.headers(publishableKey);
        RadarApiHelper.request$sdk_release$default(this.apiHelper, this.context, "GET", path, headers, null, false, new RadarApiHelper.RadarApiCallback(callback){
            final /* synthetic */ RadarSearchPlacesApiCallback $callback;
            {
                this.$callback = $callback;
            }

            public void onComplete(@NotNull Radar.RadarStatus status, @Nullable JSONObject res) {
                RadarPlace[] radarPlaceArray;
                Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
                if (status != Radar.RadarStatus.SUCCESS || res == null) {
                    RadarSearchPlacesApiCallback.DefaultImpls.onComplete$default(this.$callback, status, null, null, 6, null);
                    return;
                }
                JSONArray jSONArray = res.optJSONArray("places");
                if (jSONArray == null) {
                    radarPlaceArray = null;
                } else {
                    JSONArray jSONArray2 = jSONArray;
                    boolean bl = false;
                    boolean bl2 = false;
                    JSONArray placesArr = jSONArray2;
                    boolean bl3 = false;
                    radarPlaceArray = RadarPlace.Companion.fromJson(placesArr);
                }
                RadarPlace[] places = radarPlaceArray;
                if (places != null) {
                    this.$callback.onComplete(Radar.RadarStatus.SUCCESS, res, places);
                    return;
                }
                RadarSearchPlacesApiCallback.DefaultImpls.onComplete$default(this.$callback, Radar.RadarStatus.ERROR_SERVER, null, null, 6, null);
            }
        }, false, false, false, false, 1920, null);
    }

    public final void searchGeofences$sdk_release(@NotNull Location location, int radius, @Nullable String[] tags, @Nullable JSONObject metadata, @Nullable Integer limit, @NotNull RadarSearchGeofencesApiCallback callback) {
        Object object;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        String publishableKey = RadarSettings.INSTANCE.getPublishableKey$sdk_release(this.context);
        if (publishableKey == null) {
            RadarSearchGeofencesApiCallback.DefaultImpls.onComplete$default(callback, Radar.RadarStatus.ERROR_PUBLISHABLE_KEY, null, null, 6, null);
            return;
        }
        StringBuilder queryParams = new StringBuilder();
        queryParams.append("near=" + location.getLatitude() + ',' + location.getLongitude());
        queryParams.append(Intrinsics.stringPlus((String)"&radius=", (Object)radius));
        queryParams.append(Intrinsics.stringPlus((String)"&limit=", (Object)limit));
        JSONObject jSONObject = tags;
        if (jSONObject == null) {
            bl = false;
        } else {
            object = jSONObject;
            boolean bl2 = false;
            JSONObject jSONObject2 = object;
            boolean bl3 = false;
            bl = !(((JSONObject)jSONObject2).length == 0);
        }
        if (bl) {
            queryParams.append(Intrinsics.stringPlus((String)"&tags=", (Object)ArraysKt.joinToString$default((Object[])tags, (CharSequence)",", null, null, (int)0, null, null, (int)62, null)));
        }
        if ((jSONObject = metadata) != null && (object = jSONObject.keys()) != null) {
            Object $this$forEach$iv = object;
            boolean $i$f$forEach = false;
            Object object2 = $this$forEach$iv;
            boolean bl4 = false;
            Object object3 = object2;
            while (object3.hasNext()) {
                Object element$iv = object3.next();
                String key = (String)element$iv;
                boolean bl5 = false;
                Object value = metadata.get(key);
                queryParams.append("&metadata[" + key + "]=" + value);
            }
        }
        String path = Intrinsics.stringPlus((String)"v1/search/geofences?", (Object)queryParams);
        Map<String, String> headers = this.headers(publishableKey);
        RadarApiHelper.request$sdk_release$default(this.apiHelper, this.context, "GET", path, headers, null, false, new RadarApiHelper.RadarApiCallback(callback){
            final /* synthetic */ RadarSearchGeofencesApiCallback $callback;
            {
                this.$callback = $callback;
            }

            public void onComplete(@NotNull Radar.RadarStatus status, @Nullable JSONObject res) {
                RadarGeofence[] radarGeofenceArray;
                Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
                if (status != Radar.RadarStatus.SUCCESS || res == null) {
                    RadarSearchGeofencesApiCallback.DefaultImpls.onComplete$default(this.$callback, status, null, null, 6, null);
                    return;
                }
                JSONArray jSONArray = res.optJSONArray("geofences");
                if (jSONArray == null) {
                    radarGeofenceArray = null;
                } else {
                    JSONArray jSONArray2 = jSONArray;
                    boolean bl = false;
                    boolean bl2 = false;
                    JSONArray geofencesArr = jSONArray2;
                    boolean bl3 = false;
                    radarGeofenceArray = RadarGeofence.Companion.fromJson(geofencesArr);
                }
                RadarGeofence[] geofences = radarGeofenceArray;
                if (geofences != null) {
                    this.$callback.onComplete(Radar.RadarStatus.SUCCESS, res, geofences);
                    return;
                }
                RadarSearchGeofencesApiCallback.DefaultImpls.onComplete$default(this.$callback, Radar.RadarStatus.ERROR_SERVER, null, null, 6, null);
            }
        }, false, false, false, false, 1920, null);
    }

    public final void searchBeacons$sdk_release(@NotNull Location location, int radius, @Nullable Integer limit, @NotNull RadarSearchBeaconsApiCallback callback, boolean cache) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        String publishableKey = RadarSettings.INSTANCE.getPublishableKey$sdk_release(this.context);
        if (publishableKey == null) {
            RadarSearchBeaconsApiCallback.DefaultImpls.onComplete$default(callback, Radar.RadarStatus.ERROR_PUBLISHABLE_KEY, null, null, null, null, 30, null);
            return;
        }
        if (cache && Build.VERSION.SDK_INT >= 26) {
            Object[] objectArray;
            RadarBeacon[] lastBeacons = RadarState.INSTANCE.getLastBeacons$sdk_release(this.context);
            Object[] lastBeaconUUIDs = RadarState.INSTANCE.getLastBeaconUUIDs$sdk_release(this.context);
            String[] lastBeaconUIDs = RadarState.INSTANCE.getLastBeaconUIDs$sdk_release(this.context);
            StringBuilder stringBuilder = new StringBuilder().append("Using cached search beacons response | lastBeaconUUIDs = ").append((Object)((objectArray = lastBeaconUUIDs) == null ? null : ArraysKt.joinToString$default((Object[])objectArray, (CharSequence)",", null, null, (int)0, null, null, (int)62, null))).append("; lastBeaconUIDs = ");
            objectArray = lastBeaconUIDs;
            RadarLogger.d$default(this.logger, stringBuilder.append((Object)(objectArray == null ? null : ArraysKt.joinToString$default((Object[])objectArray, (CharSequence)",", null, null, (int)0, null, null, (int)62, null))).toString(), null, 2, null);
            callback.onComplete(Radar.RadarStatus.SUCCESS, null, lastBeacons, (String[])lastBeaconUUIDs, lastBeaconUIDs);
            return;
        }
        StringBuilder queryParams = new StringBuilder();
        queryParams.append("near=" + location.getLatitude() + ',' + location.getLongitude());
        queryParams.append(Intrinsics.stringPlus((String)"&radius=", (Object)radius));
        queryParams.append(Intrinsics.stringPlus((String)"&limit=", (Object)limit));
        queryParams.append(Intrinsics.stringPlus((String)"&installId=", (Object)RadarSettings.INSTANCE.getInstallId$sdk_release(this.context)));
        String path = Intrinsics.stringPlus((String)"v1/search/beacons?", (Object)queryParams);
        Map<String, String> headers = this.headers(publishableKey);
        RadarApiHelper.request$sdk_release$default(this.apiHelper, this.context, "GET", path, headers, null, false, new RadarApiHelper.RadarApiCallback(this, callback){
            final /* synthetic */ RadarApiClient this$0;
            final /* synthetic */ RadarSearchBeaconsApiCallback $callback;
            {
                this.this$0 = $receiver;
                this.$callback = $callback;
            }

            /*
             * WARNING - void declaration
             */
            public void onComplete(@NotNull Radar.RadarStatus status, @Nullable JSONObject res) {
                String[] stringArray;
                int $i$f$toTypedArray22;
                int n;
                int $i$f$filterTo;
                Object destination$iv$iv;
                boolean bl;
                JSONArray jSONArray;
                String[] stringArray2;
                JSONArray lastBeaconUIDs2;
                RadarBeacon[] radarBeaconArray;
                Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
                if (status != Radar.RadarStatus.SUCCESS || res == null) {
                    RadarBeacon[] lastBeacons = null;
                    String[] lastBeaconUUIDs = null;
                    String[] lastBeaconUIDs2 = null;
                    if (Build.VERSION.SDK_INT >= 26) {
                        lastBeacons = RadarState.INSTANCE.getLastBeacons$sdk_release(RadarApiClient.access$getContext$p(this.this$0));
                        lastBeaconUUIDs = RadarState.INSTANCE.getLastBeaconUUIDs$sdk_release(RadarApiClient.access$getContext$p(this.this$0));
                        lastBeaconUIDs2 = RadarState.INSTANCE.getLastBeaconUIDs$sdk_release(RadarApiClient.access$getContext$p(this.this$0));
                    }
                    this.$callback.onComplete(status, res, lastBeacons, lastBeaconUUIDs, lastBeaconUIDs2);
                    return;
                }
                JSONArray lastBeaconUUIDs = res.optJSONArray("beacons");
                if (lastBeaconUUIDs == null) {
                    radarBeaconArray = null;
                } else {
                    lastBeaconUIDs2 = lastBeaconUUIDs;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    JSONArray beaconsArr = lastBeaconUIDs2;
                    boolean bl4 = false;
                    radarBeaconArray = RadarBeacon.Companion.fromJson(beaconsArr);
                }
                RadarBeacon[] beacons = radarBeaconArray;
                lastBeaconUIDs2 = res.optJSONObject("meta");
                if (lastBeaconUIDs2 == null) {
                    stringArray2 = null;
                } else {
                    JSONObject jSONObject = lastBeaconUIDs2.optJSONObject("settings");
                    if (jSONObject == null) {
                        stringArray2 = null;
                    } else {
                        JSONObject jSONObject2 = jSONObject.optJSONObject("beacons");
                        if (jSONObject2 == null) {
                            stringArray2 = null;
                        } else {
                            jSONArray = jSONObject2.optJSONArray("uuids");
                            if (jSONArray == null) {
                                stringArray2 = null;
                            } else {
                                void $this$toTypedArray$iv;
                                void $this$filterTo$iv$iv;
                                Collection $this$filter$iv;
                                JSONArray jSONArray2 = jSONArray;
                                boolean bl5 = false;
                                bl = false;
                                JSONArray uuids = jSONArray2;
                                boolean bl6 = false;
                                int n2 = 0;
                                int n3 = uuids.length();
                                String[] stringArray3 = new String[n3];
                                while (n2 < n3) {
                                    int n4 = n2++;
                                    stringArray3[n4] = uuids.getString(n4);
                                }
                                String[] stringArray4 = stringArray3;
                                boolean $i$f$filter = false;
                                stringArray3 = $this$filter$iv;
                                destination$iv$iv = new ArrayList<E>();
                                $i$f$filterTo = 0;
                                void var19_37 = $this$filterTo$iv$iv;
                                int n5 = ((void)var19_37).length;
                                for (n = 0; n < n5; ++n) {
                                    void element$iv$iv;
                                    void uuid = element$iv$iv = var19_37[n];
                                    boolean bl7 = false;
                                    Intrinsics.checkNotNullExpressionValue((Object)uuid, (String)"uuid");
                                    CharSequence charSequence = (CharSequence)uuid;
                                    boolean bl8 = false;
                                    boolean bl9 = charSequence.length() > 0;
                                    if (!bl9) continue;
                                    destination$iv$iv.add(element$iv$iv);
                                }
                                $this$filter$iv = (List)destination$iv$iv;
                                $i$f$toTypedArray22 = 0;
                                void thisCollection$iv = $this$toTypedArray$iv;
                                String[] stringArray5 = thisCollection$iv.toArray(new String[0]);
                                if (stringArray5 == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                                }
                                stringArray2 = stringArray5;
                            }
                        }
                    }
                }
                String[] uuids = stringArray2;
                JSONObject jSONObject = res.optJSONObject("meta");
                if (jSONObject == null) {
                    stringArray = null;
                } else {
                    JSONObject jSONObject3 = jSONObject.optJSONObject("settings");
                    if (jSONObject3 == null) {
                        stringArray = null;
                    } else {
                        jSONArray = jSONObject3.optJSONObject("beacons");
                        if (jSONArray == null) {
                            stringArray = null;
                        } else {
                            JSONArray jSONArray3 = jSONArray.optJSONArray("uids");
                            if (jSONArray3 == null) {
                                stringArray = null;
                            } else {
                                void $this$toTypedArray$iv;
                                void $this$filterTo$iv$iv;
                                Collection $this$filter$iv;
                                JSONArray jSONArray4 = jSONArray3;
                                bl = false;
                                boolean bl10 = false;
                                JSONArray uids = jSONArray4;
                                boolean bl11 = false;
                                $i$f$toTypedArray22 = 0;
                                int thisCollection$iv = uids.length();
                                destination$iv$iv = new String[thisCollection$iv];
                                while ($i$f$toTypedArray22 < thisCollection$iv) {
                                    $i$f$filterTo = $i$f$toTypedArray22++;
                                    destination$iv$iv[$i$f$filterTo] = uids.getString($i$f$filterTo);
                                }
                                String[] $i$f$toTypedArray22 = destination$iv$iv;
                                boolean $i$f$filter = false;
                                destination$iv$iv = $this$filter$iv;
                                Collection destination$iv$iv2 = new ArrayList<E>();
                                boolean $i$f$filterTo2 = false;
                                void var20_40 = $this$filterTo$iv$iv;
                                n = ((void)var20_40).length;
                                for (int i = 0; i < n; ++i) {
                                    void element$iv$iv;
                                    void uid = element$iv$iv = var20_40[i];
                                    boolean bl12 = false;
                                    Intrinsics.checkNotNullExpressionValue((Object)uid, (String)"uid");
                                    CharSequence charSequence = (CharSequence)uid;
                                    boolean bl13 = false;
                                    boolean bl14 = charSequence.length() > 0;
                                    if (!bl14) continue;
                                    destination$iv$iv2.add(element$iv$iv);
                                }
                                $this$filter$iv = (List)destination$iv$iv2;
                                boolean $i$f$toTypedArray = false;
                                void thisCollection$iv2 = $this$toTypedArray$iv;
                                String[] stringArray6 = thisCollection$iv2.toArray(new String[0]);
                                if (stringArray6 == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                                }
                                stringArray = stringArray6;
                            }
                        }
                    }
                }
                String[] uids = stringArray;
                if (Build.VERSION.SDK_INT >= 26) {
                    RadarState.INSTANCE.setLastBeacons$sdk_release(RadarApiClient.access$getContext$p(this.this$0), beacons);
                    RadarState.INSTANCE.setLastBeaconUUIDs$sdk_release(RadarApiClient.access$getContext$p(this.this$0), uuids);
                    RadarState.INSTANCE.setLastBeaconUIDs$sdk_release(RadarApiClient.access$getContext$p(this.this$0), uids);
                }
                this.$callback.onComplete(Radar.RadarStatus.SUCCESS, res, beacons, uuids, uids);
            }
        }, false, false, false, false, 1920, null);
    }

    public final void autocomplete$sdk_release(@NotNull String query, @Nullable Location near, @Nullable String[] layers, @Nullable Integer limit, @Nullable String country, @NotNull RadarGeocodeApiCallback callback) {
        boolean bl;
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        String publishableKey = RadarSettings.INSTANCE.getPublishableKey$sdk_release(this.context);
        if (publishableKey == null) {
            RadarGeocodeApiCallback.DefaultImpls.onComplete$default(callback, Radar.RadarStatus.ERROR_PUBLISHABLE_KEY, null, null, 6, null);
            return;
        }
        StringBuilder queryParams = new StringBuilder();
        queryParams.append(Intrinsics.stringPlus((String)"query=", (Object)query));
        if (near != null) {
            queryParams.append("&near=" + near.getLatitude() + ',' + near.getLongitude());
        }
        if ((stringArray = layers) == null) {
            bl = false;
        } else {
            String[] stringArray2 = stringArray;
            boolean bl2 = false;
            String[] stringArray3 = stringArray2;
            boolean bl3 = false;
            bl = !(stringArray3.length == 0);
        }
        if (bl) {
            queryParams.append(Intrinsics.stringPlus((String)"&layers=", (Object)ArraysKt.joinToString$default((Object[])layers, (CharSequence)",", null, null, (int)0, null, null, (int)62, null)));
        }
        queryParams.append(Intrinsics.stringPlus((String)"&limit=", (Object)limit));
        if (country != null) {
            queryParams.append(Intrinsics.stringPlus((String)"&country=", (Object)country));
        }
        String path = Intrinsics.stringPlus((String)"v1/search/autocomplete?", (Object)queryParams);
        Map<String, String> headers = this.headers(publishableKey);
        RadarApiHelper.request$sdk_release$default(this.apiHelper, this.context, "GET", path, headers, null, false, new RadarApiHelper.RadarApiCallback(callback){
            final /* synthetic */ RadarGeocodeApiCallback $callback;
            {
                this.$callback = $callback;
            }

            public void onComplete(@NotNull Radar.RadarStatus status, @Nullable JSONObject res) {
                RadarAddress[] radarAddressArray;
                Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
                if (status != Radar.RadarStatus.SUCCESS || res == null) {
                    RadarGeocodeApiCallback.DefaultImpls.onComplete$default(this.$callback, status, null, null, 6, null);
                    return;
                }
                JSONArray jSONArray = res.optJSONArray("addresses");
                if (jSONArray == null) {
                    radarAddressArray = null;
                } else {
                    JSONArray jSONArray2 = jSONArray;
                    boolean bl = false;
                    boolean bl2 = false;
                    JSONArray addressesArr = jSONArray2;
                    boolean bl3 = false;
                    radarAddressArray = RadarAddress.Companion.fromJson(addressesArr);
                }
                RadarAddress[] addresses = radarAddressArray;
                if (addresses != null) {
                    this.$callback.onComplete(Radar.RadarStatus.SUCCESS, res, addresses);
                    return;
                }
                RadarGeocodeApiCallback.DefaultImpls.onComplete$default(this.$callback, Radar.RadarStatus.ERROR_SERVER, null, null, 6, null);
            }
        }, false, false, false, false, 1920, null);
    }

    public static /* synthetic */ void autocomplete$sdk_release$default(RadarApiClient radarApiClient, String string, Location location, String[] stringArray, Integer n, String string2, RadarGeocodeApiCallback radarGeocodeApiCallback, int n2, Object object) {
        if ((n2 & 2) != 0) {
            location = null;
        }
        if ((n2 & 4) != 0) {
            stringArray = null;
        }
        if ((n2 & 8) != 0) {
            n = null;
        }
        if ((n2 & 0x10) != 0) {
            string2 = null;
        }
        radarApiClient.autocomplete$sdk_release(string, location, stringArray, n, string2, radarGeocodeApiCallback);
    }

    public final void geocode$sdk_release(@NotNull String query, @NotNull RadarGeocodeApiCallback callback) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        String publishableKey = RadarSettings.INSTANCE.getPublishableKey$sdk_release(this.context);
        if (publishableKey == null) {
            RadarGeocodeApiCallback.DefaultImpls.onComplete$default(callback, Radar.RadarStatus.ERROR_PUBLISHABLE_KEY, null, null, 6, null);
            return;
        }
        StringBuilder queryParams = new StringBuilder();
        queryParams.append(Intrinsics.stringPlus((String)"query=", (Object)query));
        String path = Intrinsics.stringPlus((String)"v1/geocode/forward?", (Object)queryParams);
        Map<String, String> headers = this.headers(publishableKey);
        RadarApiHelper.request$sdk_release$default(this.apiHelper, this.context, "GET", path, headers, null, false, new RadarApiHelper.RadarApiCallback(callback){
            final /* synthetic */ RadarGeocodeApiCallback $callback;
            {
                this.$callback = $callback;
            }

            public void onComplete(@NotNull Radar.RadarStatus status, @Nullable JSONObject res) {
                RadarAddress[] radarAddressArray;
                Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
                if (status != Radar.RadarStatus.SUCCESS || res == null) {
                    RadarGeocodeApiCallback.DefaultImpls.onComplete$default(this.$callback, status, null, null, 6, null);
                    return;
                }
                JSONArray jSONArray = res.optJSONArray("addresses");
                if (jSONArray == null) {
                    radarAddressArray = null;
                } else {
                    JSONArray jSONArray2 = jSONArray;
                    boolean bl = false;
                    boolean bl2 = false;
                    JSONArray addressesArr = jSONArray2;
                    boolean bl3 = false;
                    radarAddressArray = RadarAddress.Companion.fromJson(addressesArr);
                }
                RadarAddress[] addresses = radarAddressArray;
                if (addresses != null) {
                    this.$callback.onComplete(Radar.RadarStatus.SUCCESS, res, addresses);
                    return;
                }
                RadarGeocodeApiCallback.DefaultImpls.onComplete$default(this.$callback, Radar.RadarStatus.ERROR_SERVER, null, null, 6, null);
            }
        }, false, false, false, false, 1920, null);
    }

    public final void reverseGeocode$sdk_release(@NotNull Location location, @NotNull RadarGeocodeApiCallback callback) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        String publishableKey = RadarSettings.INSTANCE.getPublishableKey$sdk_release(this.context);
        if (publishableKey == null) {
            RadarGeocodeApiCallback.DefaultImpls.onComplete$default(callback, Radar.RadarStatus.ERROR_PUBLISHABLE_KEY, null, null, 6, null);
            return;
        }
        StringBuilder queryParams = new StringBuilder();
        queryParams.append("coordinates=" + location.getLatitude() + ',' + location.getLongitude());
        String path = Intrinsics.stringPlus((String)"v1/geocode/reverse?", (Object)queryParams);
        Map<String, String> headers = this.headers(publishableKey);
        RadarApiHelper.request$sdk_release$default(this.apiHelper, this.context, "GET", path, headers, null, false, new RadarApiHelper.RadarApiCallback(callback){
            final /* synthetic */ RadarGeocodeApiCallback $callback;
            {
                this.$callback = $callback;
            }

            public void onComplete(@NotNull Radar.RadarStatus status, @Nullable JSONObject res) {
                RadarAddress[] radarAddressArray;
                Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
                if (status != Radar.RadarStatus.SUCCESS || res == null) {
                    RadarGeocodeApiCallback.DefaultImpls.onComplete$default(this.$callback, status, null, null, 6, null);
                    return;
                }
                JSONArray jSONArray = res.optJSONArray("addresses");
                if (jSONArray == null) {
                    radarAddressArray = null;
                } else {
                    JSONArray jSONArray2 = jSONArray;
                    boolean bl = false;
                    boolean bl2 = false;
                    JSONArray addressesArr = jSONArray2;
                    boolean bl3 = false;
                    radarAddressArray = RadarAddress.Companion.fromJson(addressesArr);
                }
                RadarAddress[] addresses = radarAddressArray;
                if (addresses != null) {
                    this.$callback.onComplete(Radar.RadarStatus.SUCCESS, res, addresses);
                    return;
                }
                RadarGeocodeApiCallback.DefaultImpls.onComplete$default(this.$callback, Radar.RadarStatus.ERROR_SERVER, null, null, 6, null);
            }
        }, false, false, false, false, 1920, null);
    }

    public final void ipGeocode$sdk_release(@NotNull RadarIpGeocodeApiCallback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        String publishableKey = RadarSettings.INSTANCE.getPublishableKey$sdk_release(this.context);
        if (publishableKey == null) {
            RadarIpGeocodeApiCallback.DefaultImpls.onComplete$default(callback, Radar.RadarStatus.ERROR_PUBLISHABLE_KEY, null, null, false, 14, null);
            return;
        }
        String path = "v1/geocode/ip";
        Map<String, String> headers = this.headers(publishableKey);
        RadarApiHelper.request$sdk_release$default(this.apiHelper, this.context, "GET", path, headers, null, false, new RadarApiHelper.RadarApiCallback(callback){
            final /* synthetic */ RadarIpGeocodeApiCallback $callback;
            {
                this.$callback = $callback;
            }

            public void onComplete(@NotNull Radar.RadarStatus status, @Nullable JSONObject res) {
                RadarAddress radarAddress;
                Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
                if (status != Radar.RadarStatus.SUCCESS || res == null) {
                    RadarIpGeocodeApiCallback.DefaultImpls.onComplete$default(this.$callback, status, null, null, false, 14, null);
                    return;
                }
                JSONObject jSONObject = res.optJSONObject("address");
                if (jSONObject == null) {
                    radarAddress = null;
                } else {
                    JSONObject jSONObject2 = jSONObject;
                    boolean bl = false;
                    boolean bl2 = false;
                    JSONObject addressObj = jSONObject2;
                    boolean bl3 = false;
                    radarAddress = RadarAddress.Companion.fromJson(addressObj);
                }
                RadarAddress address = radarAddress;
                boolean proxy = res.optBoolean("proxy");
                if (address != null) {
                    this.$callback.onComplete(Radar.RadarStatus.SUCCESS, res, address, proxy);
                    return;
                }
                RadarIpGeocodeApiCallback.DefaultImpls.onComplete$default(this.$callback, Radar.RadarStatus.ERROR_SERVER, null, null, false, 14, null);
            }
        }, false, false, false, false, 1920, null);
    }

    public final void getDistance$sdk_release(@NotNull Location origin, @NotNull Location destination, @NotNull EnumSet<Radar.RadarRouteMode> modes, @NotNull Radar.RadarRouteUnits units, int geometryPoints, @NotNull RadarDistanceApiCallback callback) {
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Intrinsics.checkNotNullParameter(modes, (String)"modes");
        Intrinsics.checkNotNullParameter((Object)((Object)units), (String)"units");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        String publishableKey = RadarSettings.INSTANCE.getPublishableKey$sdk_release(this.context);
        if (publishableKey == null) {
            RadarDistanceApiCallback.DefaultImpls.onComplete$default(callback, Radar.RadarStatus.ERROR_PUBLISHABLE_KEY, null, null, 6, null);
            return;
        }
        StringBuilder queryParams = new StringBuilder();
        queryParams.append("origin=" + origin.getLatitude() + ',' + origin.getLongitude());
        queryParams.append("&destination=" + destination.getLatitude() + ',' + destination.getLongitude());
        boolean bl = false;
        List modesList = new ArrayList();
        if (modes.contains((Object)Radar.RadarRouteMode.FOOT)) {
            modesList.add("foot");
        }
        if (modes.contains((Object)Radar.RadarRouteMode.BIKE)) {
            modesList.add("bike");
        }
        if (modes.contains((Object)Radar.RadarRouteMode.CAR)) {
            modesList.add("car");
        }
        if (modes.contains((Object)Radar.RadarRouteMode.TRUCK)) {
            modesList.add("truck");
        }
        if (modes.contains((Object)Radar.RadarRouteMode.MOTORBIKE)) {
            modesList.add("motorbike");
        }
        queryParams.append(Intrinsics.stringPlus((String)"&modes=", (Object)CollectionsKt.joinToString$default((Iterable)modesList, (CharSequence)",", null, null, (int)0, null, null, (int)62, null)));
        if (units == Radar.RadarRouteUnits.METRIC) {
            queryParams.append("&units=metric");
        } else {
            queryParams.append("&units=imperial");
        }
        if (geometryPoints > 1) {
            queryParams.append(Intrinsics.stringPlus((String)"&geometryPoints=", (Object)geometryPoints));
        }
        queryParams.append("&geometry=linestring");
        String path = Intrinsics.stringPlus((String)"v1/route/distance?", (Object)queryParams);
        Map<String, String> headers = this.headers(publishableKey);
        RadarApiHelper.request$sdk_release$default(this.apiHelper, this.context, "GET", path, headers, null, false, new RadarApiHelper.RadarApiCallback(callback){
            final /* synthetic */ RadarDistanceApiCallback $callback;
            {
                this.$callback = $callback;
            }

            public void onComplete(@NotNull Radar.RadarStatus status, @Nullable JSONObject res) {
                RadarRoutes radarRoutes;
                Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
                if (status != Radar.RadarStatus.SUCCESS || res == null) {
                    RadarDistanceApiCallback.DefaultImpls.onComplete$default(this.$callback, status, null, null, 6, null);
                    return;
                }
                JSONObject jSONObject = res.optJSONObject("routes");
                if (jSONObject == null) {
                    radarRoutes = null;
                } else {
                    JSONObject jSONObject2 = jSONObject;
                    boolean bl = false;
                    boolean bl2 = false;
                    JSONObject routesObj = jSONObject2;
                    boolean bl3 = false;
                    radarRoutes = RadarRoutes.Companion.fromJson(routesObj);
                }
                RadarRoutes routes = radarRoutes;
                if (routes != null) {
                    this.$callback.onComplete(Radar.RadarStatus.SUCCESS, res, routes);
                    return;
                }
                RadarDistanceApiCallback.DefaultImpls.onComplete$default(this.$callback, Radar.RadarStatus.ERROR_SERVER, null, null, 6, null);
            }
        }, false, false, false, false, 1920, null);
    }

    public final void getMatrix$sdk_release(@NotNull Location[] origins, @NotNull Location[] destinations, @NotNull Radar.RadarRouteMode mode, @NotNull Radar.RadarRouteUnits units, @NotNull RadarMatrixApiCallback callback) {
        int i;
        Intrinsics.checkNotNullParameter((Object)origins, (String)"origins");
        Intrinsics.checkNotNullParameter((Object)destinations, (String)"destinations");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Intrinsics.checkNotNullParameter((Object)((Object)units), (String)"units");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        String publishableKey = RadarSettings.INSTANCE.getPublishableKey$sdk_release(this.context);
        if (publishableKey == null) {
            RadarMatrixApiCallback.DefaultImpls.onComplete$default(callback, Radar.RadarStatus.ERROR_PUBLISHABLE_KEY, null, null, 6, null);
            return;
        }
        StringBuilder queryParams = new StringBuilder();
        queryParams.append("origins=");
        int n = 0;
        int n2 = origins.length + -1;
        if (n <= n2) {
            do {
                i = n++;
                queryParams.append("" + origins[i].getLatitude() + ',' + origins[i].getLongitude());
                if (i >= origins.length - 1) continue;
                queryParams.append("|");
            } while (n <= n2);
        }
        queryParams.append("&destinations=");
        n = 0;
        n2 = destinations.length + -1;
        if (n <= n2) {
            do {
                i = n++;
                queryParams.append("" + destinations[i].getLatitude() + ',' + destinations[i].getLongitude());
                if (i >= destinations.length - 1) continue;
                queryParams.append("|");
            } while (n <= n2);
        }
        if (mode == Radar.RadarRouteMode.FOOT) {
            queryParams.append("&mode=foot");
        } else if (mode == Radar.RadarRouteMode.BIKE) {
            queryParams.append("&mode=bike");
        } else if (mode == Radar.RadarRouteMode.CAR) {
            queryParams.append("&mode=car");
        } else if (mode == Radar.RadarRouteMode.TRUCK) {
            queryParams.append("&mode=truck");
        } else if (mode == Radar.RadarRouteMode.MOTORBIKE) {
            queryParams.append("&mode=motorbike");
        }
        if (units == Radar.RadarRouteUnits.METRIC) {
            queryParams.append("&units=metric");
        } else {
            queryParams.append("&units=imperial");
        }
        String path = Intrinsics.stringPlus((String)"v1/route/matrix?", (Object)queryParams);
        Map<String, String> headers = this.headers(publishableKey);
        RadarApiHelper.request$sdk_release$default(this.apiHelper, this.context, "GET", path, headers, null, false, new RadarApiHelper.RadarApiCallback(callback){
            final /* synthetic */ RadarMatrixApiCallback $callback;
            {
                this.$callback = $callback;
            }

            public void onComplete(@NotNull Radar.RadarStatus status, @Nullable JSONObject res) {
                RadarRouteMatrix radarRouteMatrix;
                Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
                if (status != Radar.RadarStatus.SUCCESS || res == null) {
                    RadarMatrixApiCallback.DefaultImpls.onComplete$default(this.$callback, status, null, null, 6, null);
                    return;
                }
                JSONArray jSONArray = res.optJSONArray("matrix");
                if (jSONArray == null) {
                    radarRouteMatrix = null;
                } else {
                    JSONArray jSONArray2 = jSONArray;
                    boolean bl = false;
                    boolean bl2 = false;
                    JSONArray matrixObj = jSONArray2;
                    boolean bl3 = false;
                    radarRouteMatrix = RadarRouteMatrix.Companion.fromJson(matrixObj);
                }
                RadarRouteMatrix matrix = radarRouteMatrix;
                if (matrix != null) {
                    this.$callback.onComplete(Radar.RadarStatus.SUCCESS, res, matrix);
                    return;
                }
                RadarMatrixApiCallback.DefaultImpls.onComplete$default(this.$callback, Radar.RadarStatus.ERROR_SERVER, null, null, 6, null);
            }
        }, false, false, false, false, 1920, null);
    }

    public final void sendEvent$sdk_release(@NotNull String name, @Nullable JSONObject metadata, @Nullable RadarUser user, @Nullable RadarEvent[] trackingEvents, @NotNull RadarSendEventApiCallback callback) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        String publishableKey = RadarSettings.INSTANCE.getPublishableKey$sdk_release(this.context);
        if (publishableKey == null) {
            RadarSendEventApiCallback.DefaultImpls.onComplete$default(callback, Radar.RadarStatus.ERROR_PUBLISHABLE_KEY, null, null, 6, null);
            return;
        }
        JSONObject params = new JSONObject();
        try {
            params.putOpt("id", (Object)RadarSettings.INSTANCE.getId$sdk_release(this.context));
            params.putOpt("installId", (Object)RadarSettings.INSTANCE.getInstallId$sdk_release(this.context));
            params.putOpt("userId", (Object)RadarSettings.INSTANCE.getUserId$sdk_release(this.context));
            params.putOpt("deviceId", (Object)RadarUtils.INSTANCE.getDeviceId$sdk_release(this.context));
            params.putOpt("type", (Object)name);
            params.putOpt("metadata", (Object)metadata);
        }
        catch (JSONException e) {
            RadarSendEventApiCallback radarSendEventApiCallback = callback;
            RadarSendEventApiCallback.DefaultImpls.onComplete$default(radarSendEventApiCallback, Radar.RadarStatus.ERROR_BAD_REQUEST, null, null, 6, null);
            return;
        }
        String path = "v1/events";
        Map<String, String> headers = this.headers(publishableKey);
        RadarApiHelper.request$sdk_release$default(this.apiHelper, this.context, "POST", path, headers, params, false, new RadarApiHelper.RadarApiCallback(callback, trackingEvents){
            final /* synthetic */ RadarSendEventApiCallback $callback;
            final /* synthetic */ RadarEvent[] $trackingEvents;
            {
                this.$callback = $callback;
                this.$trackingEvents = $trackingEvents;
            }

            public void onComplete(@NotNull Radar.RadarStatus status, @Nullable JSONObject res) {
                RadarEvent radarEvent;
                Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
                if (status != Radar.RadarStatus.SUCCESS || res == null) {
                    RadarSendEventApiCallback.DefaultImpls.onComplete$default(this.$callback, status, null, null, 6, null);
                    return;
                }
                JSONObject jSONObject = res.optJSONObject("event");
                if (jSONObject == null) {
                    radarEvent = null;
                } else {
                    JSONObject jSONObject2 = jSONObject;
                    boolean bl = false;
                    boolean bl2 = false;
                    JSONObject eventObj = jSONObject2;
                    boolean bl3 = false;
                    radarEvent = RadarEvent.Companion.fromJson(eventObj);
                }
                RadarEvent customEvent = radarEvent;
                boolean bl = false;
                List allEvents = new ArrayList<E>();
                if (this.$trackingEvents != null) {
                    CollectionsKt.addAll((Collection)allEvents, (Object[])this.$trackingEvents);
                }
                if (customEvent != null) {
                    allEvents.add(0, customEvent);
                } else {
                    RadarSendEventApiCallback.DefaultImpls.onComplete$default(this.$callback, Radar.RadarStatus.ERROR_SERVER, null, null, 6, null);
                }
                Collection $this$toTypedArray$iv = allEvents;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                RadarEvent[] radarEventArray = thisCollection$iv.toArray(new RadarEvent[0]);
                if (radarEventArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                this.$callback.onComplete(Radar.RadarStatus.SUCCESS, res, radarEventArray);
            }
        }, false, false, false, false, 1920, null);
    }

    public static final /* synthetic */ Context access$getContext$p(RadarApiClient $this) {
        return $this.context;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J]\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0010\b\u0002\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0010\b\u0002\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\t2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010H&\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lio/radar/sdk/RadarApiClient$RadarTrackApiCallback;", "", "onComplete", "", "status", "Lio/radar/sdk/Radar$RadarStatus;", "res", "Lorg/json/JSONObject;", "events", "", "Lio/radar/sdk/model/RadarEvent;", "user", "Lio/radar/sdk/model/RadarUser;", "nearbyGeofences", "Lio/radar/sdk/model/RadarGeofence;", "config", "Lio/radar/sdk/model/RadarConfig;", "(Lio/radar/sdk/Radar$RadarStatus;Lorg/json/JSONObject;[Lio/radar/sdk/model/RadarEvent;Lio/radar/sdk/model/RadarUser;[Lio/radar/sdk/model/RadarGeofence;Lio/radar/sdk/model/RadarConfig;)V", "sdk_release"})
    public static interface RadarTrackApiCallback {
        public void onComplete(@NotNull Radar.RadarStatus var1, @Nullable JSONObject var2, @Nullable RadarEvent[] var3, @Nullable RadarUser var4, @Nullable RadarGeofence[] var5, @Nullable RadarConfig var6);

        @Metadata(mv={1, 5, 1}, k=3, xi=48)
        public static final class DefaultImpls {
            public static /* synthetic */ void onComplete$default(RadarTrackApiCallback radarTrackApiCallback, Radar.RadarStatus radarStatus, JSONObject jSONObject, RadarEvent[] radarEventArray, RadarUser radarUser, RadarGeofence[] radarGeofenceArray, RadarConfig radarConfig, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: onComplete");
                }
                if ((n & 2) != 0) {
                    jSONObject = null;
                }
                if ((n & 4) != 0) {
                    radarEventArray = null;
                }
                if ((n & 8) != 0) {
                    radarUser = null;
                }
                if ((n & 0x10) != 0) {
                    radarGeofenceArray = null;
                }
                if ((n & 0x20) != 0) {
                    radarConfig = null;
                }
                radarTrackApiCallback.onComplete(radarStatus, jSONObject, radarEventArray, radarUser, radarGeofenceArray, radarConfig);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lio/radar/sdk/RadarApiClient$RadarGetConfigApiCallback;", "", "onComplete", "", "config", "Lio/radar/sdk/model/RadarConfig;", "sdk_release"})
    public static interface RadarGetConfigApiCallback {
        public void onComplete(@NotNull RadarConfig var1);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J?\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bH&\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lio/radar/sdk/RadarApiClient$RadarTripApiCallback;", "", "onComplete", "", "status", "Lio/radar/sdk/Radar$RadarStatus;", "res", "Lorg/json/JSONObject;", "trip", "Lio/radar/sdk/model/RadarTrip;", "events", "", "Lio/radar/sdk/model/RadarEvent;", "(Lio/radar/sdk/Radar$RadarStatus;Lorg/json/JSONObject;Lio/radar/sdk/model/RadarTrip;[Lio/radar/sdk/model/RadarEvent;)V", "sdk_release"})
    public static interface RadarTripApiCallback {
        public void onComplete(@NotNull Radar.RadarStatus var1, @Nullable JSONObject var2, @Nullable RadarTrip var3, @Nullable RadarEvent[] var4);

        @Metadata(mv={1, 5, 1}, k=3, xi=48)
        public static final class DefaultImpls {
            public static /* synthetic */ void onComplete$default(RadarTripApiCallback radarTripApiCallback, Radar.RadarStatus radarStatus, JSONObject jSONObject, RadarTrip radarTrip, RadarEvent[] radarEventArray, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: onComplete");
                }
                if ((n & 2) != 0) {
                    jSONObject = null;
                }
                if ((n & 4) != 0) {
                    radarTrip = null;
                }
                if ((n & 8) != 0) {
                    radarEventArray = null;
                }
                radarTripApiCallback.onComplete(radarStatus, jSONObject, radarTrip, radarEventArray);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J(\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH&\u00a8\u0006\n"}, d2={"Lio/radar/sdk/RadarApiClient$RadarContextApiCallback;", "", "onComplete", "", "status", "Lio/radar/sdk/Radar$RadarStatus;", "res", "Lorg/json/JSONObject;", "context", "Lio/radar/sdk/model/RadarContext;", "sdk_release"})
    public static interface RadarContextApiCallback {
        public void onComplete(@NotNull Radar.RadarStatus var1, @Nullable JSONObject var2, @Nullable RadarContext var3);

        @Metadata(mv={1, 5, 1}, k=3, xi=48)
        public static final class DefaultImpls {
            public static /* synthetic */ void onComplete$default(RadarContextApiCallback radarContextApiCallback, Radar.RadarStatus radarStatus, JSONObject jSONObject, RadarContext radarContext, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: onComplete");
                }
                if ((n & 2) != 0) {
                    jSONObject = null;
                }
                if ((n & 4) != 0) {
                    radarContext = null;
                }
                radarContextApiCallback.onComplete(radarStatus, jSONObject, radarContext);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J3\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0010\b\u0002\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tH&\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lio/radar/sdk/RadarApiClient$RadarSearchPlacesApiCallback;", "", "onComplete", "", "status", "Lio/radar/sdk/Radar$RadarStatus;", "res", "Lorg/json/JSONObject;", "places", "", "Lio/radar/sdk/model/RadarPlace;", "(Lio/radar/sdk/Radar$RadarStatus;Lorg/json/JSONObject;[Lio/radar/sdk/model/RadarPlace;)V", "sdk_release"})
    public static interface RadarSearchPlacesApiCallback {
        public void onComplete(@NotNull Radar.RadarStatus var1, @Nullable JSONObject var2, @Nullable RadarPlace[] var3);

        @Metadata(mv={1, 5, 1}, k=3, xi=48)
        public static final class DefaultImpls {
            public static /* synthetic */ void onComplete$default(RadarSearchPlacesApiCallback radarSearchPlacesApiCallback, Radar.RadarStatus radarStatus, JSONObject jSONObject, RadarPlace[] radarPlaceArray, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: onComplete");
                }
                if ((n & 2) != 0) {
                    jSONObject = null;
                }
                if ((n & 4) != 0) {
                    radarPlaceArray = null;
                }
                radarSearchPlacesApiCallback.onComplete(radarStatus, jSONObject, radarPlaceArray);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J3\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0010\b\u0002\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tH&\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lio/radar/sdk/RadarApiClient$RadarSearchGeofencesApiCallback;", "", "onComplete", "", "status", "Lio/radar/sdk/Radar$RadarStatus;", "res", "Lorg/json/JSONObject;", "geofences", "", "Lio/radar/sdk/model/RadarGeofence;", "(Lio/radar/sdk/Radar$RadarStatus;Lorg/json/JSONObject;[Lio/radar/sdk/model/RadarGeofence;)V", "sdk_release"})
    public static interface RadarSearchGeofencesApiCallback {
        public void onComplete(@NotNull Radar.RadarStatus var1, @Nullable JSONObject var2, @Nullable RadarGeofence[] var3);

        @Metadata(mv={1, 5, 1}, k=3, xi=48)
        public static final class DefaultImpls {
            public static /* synthetic */ void onComplete$default(RadarSearchGeofencesApiCallback radarSearchGeofencesApiCallback, Radar.RadarStatus radarStatus, JSONObject jSONObject, RadarGeofence[] radarGeofenceArray, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: onComplete");
                }
                if ((n & 2) != 0) {
                    jSONObject = null;
                }
                if ((n & 4) != 0) {
                    radarGeofenceArray = null;
                }
                radarSearchGeofencesApiCallback.onComplete(radarStatus, jSONObject, radarGeofenceArray);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001JW\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0010\b\u0002\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0010\b\u0002\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\t2\u0010\b\u0002\u0010\r\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\tH&\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lio/radar/sdk/RadarApiClient$RadarSearchBeaconsApiCallback;", "", "onComplete", "", "status", "Lio/radar/sdk/Radar$RadarStatus;", "res", "Lorg/json/JSONObject;", "beacons", "", "Lio/radar/sdk/model/RadarBeacon;", "uuids", "", "uids", "(Lio/radar/sdk/Radar$RadarStatus;Lorg/json/JSONObject;[Lio/radar/sdk/model/RadarBeacon;[Ljava/lang/String;[Ljava/lang/String;)V", "sdk_release"})
    public static interface RadarSearchBeaconsApiCallback {
        public void onComplete(@NotNull Radar.RadarStatus var1, @Nullable JSONObject var2, @Nullable RadarBeacon[] var3, @Nullable String[] var4, @Nullable String[] var5);

        @Metadata(mv={1, 5, 1}, k=3, xi=48)
        public static final class DefaultImpls {
            public static /* synthetic */ void onComplete$default(RadarSearchBeaconsApiCallback radarSearchBeaconsApiCallback, Radar.RadarStatus radarStatus, JSONObject jSONObject, RadarBeacon[] radarBeaconArray, String[] stringArray, String[] stringArray2, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: onComplete");
                }
                if ((n & 2) != 0) {
                    jSONObject = null;
                }
                if ((n & 4) != 0) {
                    radarBeaconArray = null;
                }
                if ((n & 8) != 0) {
                    stringArray = null;
                }
                if ((n & 0x10) != 0) {
                    stringArray2 = null;
                }
                radarSearchBeaconsApiCallback.onComplete(radarStatus, jSONObject, radarBeaconArray, stringArray, stringArray2);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J3\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0010\b\u0002\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tH&\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lio/radar/sdk/RadarApiClient$RadarGeocodeApiCallback;", "", "onComplete", "", "status", "Lio/radar/sdk/Radar$RadarStatus;", "res", "Lorg/json/JSONObject;", "addresses", "", "Lio/radar/sdk/model/RadarAddress;", "(Lio/radar/sdk/Radar$RadarStatus;Lorg/json/JSONObject;[Lio/radar/sdk/model/RadarAddress;)V", "sdk_release"})
    public static interface RadarGeocodeApiCallback {
        public void onComplete(@NotNull Radar.RadarStatus var1, @Nullable JSONObject var2, @Nullable RadarAddress[] var3);

        @Metadata(mv={1, 5, 1}, k=3, xi=48)
        public static final class DefaultImpls {
            public static /* synthetic */ void onComplete$default(RadarGeocodeApiCallback radarGeocodeApiCallback, Radar.RadarStatus radarStatus, JSONObject jSONObject, RadarAddress[] radarAddressArray, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: onComplete");
                }
                if ((n & 2) != 0) {
                    jSONObject = null;
                }
                if ((n & 4) != 0) {
                    radarAddressArray = null;
                }
                radarGeocodeApiCallback.onComplete(radarStatus, jSONObject, radarAddressArray);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\bf\u0018\u00002\u00020\u0001J2\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH&\u00a8\u0006\f"}, d2={"Lio/radar/sdk/RadarApiClient$RadarIpGeocodeApiCallback;", "", "onComplete", "", "status", "Lio/radar/sdk/Radar$RadarStatus;", "res", "Lorg/json/JSONObject;", "address", "Lio/radar/sdk/model/RadarAddress;", "proxy", "", "sdk_release"})
    public static interface RadarIpGeocodeApiCallback {
        public void onComplete(@NotNull Radar.RadarStatus var1, @Nullable JSONObject var2, @Nullable RadarAddress var3, boolean var4);

        @Metadata(mv={1, 5, 1}, k=3, xi=48)
        public static final class DefaultImpls {
            public static /* synthetic */ void onComplete$default(RadarIpGeocodeApiCallback radarIpGeocodeApiCallback, Radar.RadarStatus radarStatus, JSONObject jSONObject, RadarAddress radarAddress, boolean bl, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: onComplete");
                }
                if ((n & 2) != 0) {
                    jSONObject = null;
                }
                if ((n & 4) != 0) {
                    radarAddress = null;
                }
                if ((n & 8) != 0) {
                    bl = false;
                }
                radarIpGeocodeApiCallback.onComplete(radarStatus, jSONObject, radarAddress, bl);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J(\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH&\u00a8\u0006\n"}, d2={"Lio/radar/sdk/RadarApiClient$RadarDistanceApiCallback;", "", "onComplete", "", "status", "Lio/radar/sdk/Radar$RadarStatus;", "res", "Lorg/json/JSONObject;", "routes", "Lio/radar/sdk/model/RadarRoutes;", "sdk_release"})
    public static interface RadarDistanceApiCallback {
        public void onComplete(@NotNull Radar.RadarStatus var1, @Nullable JSONObject var2, @Nullable RadarRoutes var3);

        @Metadata(mv={1, 5, 1}, k=3, xi=48)
        public static final class DefaultImpls {
            public static /* synthetic */ void onComplete$default(RadarDistanceApiCallback radarDistanceApiCallback, Radar.RadarStatus radarStatus, JSONObject jSONObject, RadarRoutes radarRoutes, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: onComplete");
                }
                if ((n & 2) != 0) {
                    jSONObject = null;
                }
                if ((n & 4) != 0) {
                    radarRoutes = null;
                }
                radarDistanceApiCallback.onComplete(radarStatus, jSONObject, radarRoutes);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J(\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH&\u00a8\u0006\n"}, d2={"Lio/radar/sdk/RadarApiClient$RadarMatrixApiCallback;", "", "onComplete", "", "status", "Lio/radar/sdk/Radar$RadarStatus;", "res", "Lorg/json/JSONObject;", "matrix", "Lio/radar/sdk/model/RadarRouteMatrix;", "sdk_release"})
    public static interface RadarMatrixApiCallback {
        public void onComplete(@NotNull Radar.RadarStatus var1, @Nullable JSONObject var2, @Nullable RadarRouteMatrix var3);

        @Metadata(mv={1, 5, 1}, k=3, xi=48)
        public static final class DefaultImpls {
            public static /* synthetic */ void onComplete$default(RadarMatrixApiCallback radarMatrixApiCallback, Radar.RadarStatus radarStatus, JSONObject jSONObject, RadarRouteMatrix radarRouteMatrix, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: onComplete");
                }
                if ((n & 2) != 0) {
                    jSONObject = null;
                }
                if ((n & 4) != 0) {
                    radarRouteMatrix = null;
                }
                radarMatrixApiCallback.onComplete(radarStatus, jSONObject, radarRouteMatrix);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J3\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0010\b\u0002\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tH&\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lio/radar/sdk/RadarApiClient$RadarSendEventApiCallback;", "", "onComplete", "", "status", "Lio/radar/sdk/Radar$RadarStatus;", "res", "Lorg/json/JSONObject;", "events", "", "Lio/radar/sdk/model/RadarEvent;", "(Lio/radar/sdk/Radar$RadarStatus;Lorg/json/JSONObject;[Lio/radar/sdk/model/RadarEvent;)V", "sdk_release"})
    public static interface RadarSendEventApiCallback {
        public void onComplete(@NotNull Radar.RadarStatus var1, @Nullable JSONObject var2, @Nullable RadarEvent[] var3);

        @Metadata(mv={1, 5, 1}, k=3, xi=48)
        public static final class DefaultImpls {
            public static /* synthetic */ void onComplete$default(RadarSendEventApiCallback radarSendEventApiCallback, Radar.RadarStatus radarStatus, JSONObject jSONObject, RadarEvent[] radarEventArray, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: onComplete");
                }
                if ((n & 2) != 0) {
                    jSONObject = null;
                }
                if ((n & 4) != 0) {
                    radarEventArray = null;
                }
                radarSendEventApiCallback.onComplete(radarStatus, jSONObject, radarEventArray);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b`\u0018\u00002\u00020\u0001J\u001c\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00a8\u0006\b"}, d2={"Lio/radar/sdk/RadarApiClient$RadarLogCallback;", "", "onComplete", "", "status", "Lio/radar/sdk/Radar$RadarStatus;", "res", "Lorg/json/JSONObject;", "sdk_release"})
    public static interface RadarLogCallback {
        public void onComplete(@NotNull Radar.RadarStatus var1, @Nullable JSONObject var2);

        @Metadata(mv={1, 5, 1}, k=3, xi=48)
        public static final class DefaultImpls {
            public static /* synthetic */ void onComplete$default(RadarLogCallback radarLogCallback, Radar.RadarStatus radarStatus, JSONObject jSONObject, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: onComplete");
                }
                if ((n & 2) != 0) {
                    jSONObject = null;
                }
                radarLogCallback.onComplete(radarStatus, jSONObject);
            }
        }
    }
}

