/*
 * Decompiled with CFR 0.152.
 */
package io.radar.sdk;

import android.content.Context;
import com.google.android.gms.tasks.Task;
import com.google.android.play.core.integrity.IntegrityManager;
import com.google.android.play.core.integrity.IntegrityManagerFactory;
import com.google.android.play.core.integrity.IntegrityTokenRequest;
import com.google.android.play.core.integrity.IntegrityTokenResponse;
import io.radar.sdk.RadarLogger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J[\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2:\u0010\r\u001a6\u0012\u0015\u0012\u0013\u0018\u00010\f\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0015\u0012\u0013\u0018\u00010\f\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\b0\u000e\u00a2\u0006\u0002\u0010\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/radar/sdk/RadarVerificationManager;", "", "context", "Landroid/content/Context;", "logger", "Lio/radar/sdk/RadarLogger;", "(Landroid/content/Context;Lio/radar/sdk/RadarLogger;)V", "getIntegrityToken", "", "googleCloudProjectNumber", "", "nonce", "", "block", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "integrityToken", "integrityException", "(Ljava/lang/Long;Ljava/lang/String;Lkotlin/jvm/functions/Function2;)V", "sdk_release"})
public final class RadarVerificationManager {
    @NotNull
    private final Context context;
    @NotNull
    private final RadarLogger logger;

    public RadarVerificationManager(@NotNull Context context, @NotNull RadarLogger logger) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.context = context;
        this.logger = logger;
    }

    public final void getIntegrityToken(@Nullable Long googleCloudProjectNumber, @Nullable String nonce, @NotNull Function2<? super String, ? super String, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        RadarLogger.d$default(this.logger, "Requesting integrity token", null, 2, null);
        if (googleCloudProjectNumber == null) {
            String integrityException = "Missing Google Cloud project number";
            RadarLogger.d$default(this.logger, integrityException, null, 2, null);
            block.invoke(null, (Object)integrityException);
            return;
        }
        if (nonce == null) {
            String integrityException = "Missing nonce";
            RadarLogger.d$default(this.logger, integrityException, null, 2, null);
            block.invoke(null, (Object)integrityException);
            return;
        }
        IntegrityManager integrityManager = IntegrityManagerFactory.create((Context)this.context.getApplicationContext());
        Intrinsics.checkNotNullExpressionValue((Object)integrityManager, (String)"create(context.applicationContext)");
        IntegrityManager integrityManager2 = integrityManager;
        integrityManager2.requestIntegrityToken(IntegrityTokenRequest.builder().setCloudProjectNumber(googleCloudProjectNumber.longValue()).setNonce(nonce).build()).addOnCompleteListener(arg_0 -> RadarVerificationManager.getIntegrityToken$lambda-0(this, block, arg_0));
    }

    private static final void getIntegrityToken$lambda-0(RadarVerificationManager this$0, Function2 $block, Task response) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$block, (String)"$block");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        if (response.isSuccessful()) {
            String integrityToken = ((IntegrityTokenResponse)response.getResult()).token();
            RadarLogger.d$default(this$0.logger, Intrinsics.stringPlus((String)"Successfully requested integrity token | integrityToken = ", (Object)integrityToken), null, 2, null);
            $block.invoke((Object)integrityToken, null);
        } else {
            Exception exception = response.getException();
            String integrityException = exception == null ? null : exception.getMessage();
            RadarLogger.d$default(this$0.logger, Intrinsics.stringPlus((String)"Error requesting integrity token | integrityException = ", (Object)integrityException), null, 2, null);
            $block.invoke(null, (Object)integrityException);
        }
    }
}

