/*
 * Decompiled with CFR 0.152.
 */
package io.radar.sdk;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.location.Location;
import android.location.LocationManager;
import android.os.Build;
import android.provider.Settings;
import androidx.core.content.ContextCompat;
import androidx.core.hardware.display.DisplayManagerCompat;
import io.radar.sdk.RadarSettings;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0014\u001a\u0004\u0018\u00010\u00042\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0000\u00a2\u0006\u0002\b\u0017J\u0017\u0010\u0018\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0019\u001a\u00020\u001aH\u0001\u00a2\u0006\u0002\b\u001bJ\u0015\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b\u001dJ\u0015\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b\u001fJ\u0015\u0010 \u001a\u00020!2\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b\"J\u0010\u0010#\u001a\u00020$2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\r\u0010%\u001a\u00020!H\u0000\u00a2\u0006\u0002\b&J\u0015\u0010'\u001a\u00020!2\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b(J\u0019\u0010)\u001a\u0004\u0018\u00010\u00162\b\u0010*\u001a\u0004\u0018\u00010\u0004H\u0000\u00a2\u0006\u0002\b+J\u0015\u0010,\u001a\u00020!2\u0006\u0010-\u001a\u00020.H\u0000\u00a2\u0006\u0002\b/R\u0014\u0010\u0003\u001a\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0007\u001a\n \b*\u0004\u0018\u00010\u00040\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0006R\u001c\u0010\n\u001a\n \b*\u0004\u0018\u00010\u00040\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0006R\u001c\u0010\f\u001a\n \b*\u0004\u0018\u00010\u00040\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0006R\u000e\u0010\u000e\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00118@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u00060"}, d2={"Lio/radar/sdk/RadarUtils;", "", "()V", "country", "", "getCountry$sdk_release", "()Ljava/lang/String;", "deviceMake", "kotlin.jvm.PlatformType", "getDeviceMake$sdk_release", "deviceModel", "getDeviceModel$sdk_release", "deviceOS", "getDeviceOS$sdk_release", "deviceType", "sdkVersion", "timeZoneOffset", "", "getTimeZoneOffset$sdk_release", "()I", "dateToISOString", "date", "Ljava/util/Date;", "dateToISOString$sdk_release", "getDeviceId", "context", "Landroid/content/Context;", "getDeviceId$sdk_release", "getLocationAccuracyAuthorization", "getLocationAccuracyAuthorization$sdk_release", "getLocationAuthorization", "getLocationAuthorization$sdk_release", "getLocationEnabled", "", "getLocationEnabled$sdk_release", "getSharedPreferences", "Landroid/content/SharedPreferences;", "isEmulator", "isEmulator$sdk_release", "isScreenSharing", "isScreenSharing$sdk_release", "isoStringToDate", "str", "isoStringToDate$sdk_release", "valid", "location", "Landroid/location/Location;", "valid$sdk_release", "sdk_release"})
public final class RadarUtils {
    @NotNull
    public static final RadarUtils INSTANCE = new RadarUtils();
    private static final String deviceModel = Build.MODEL;
    private static final String deviceOS = Build.VERSION.RELEASE;
    @NotNull
    public static final String sdkVersion = "3.8.10-beta.2";
    @NotNull
    public static final String deviceType = "Android";
    private static final String deviceMake = Build.MANUFACTURER;

    private RadarUtils() {
    }

    private final SharedPreferences getSharedPreferences(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("RadarSDK", 0);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"context.getSharedPreferences(\"RadarSDK\", Context.MODE_PRIVATE)");
        return sharedPreferences;
    }

    public final String getDeviceModel$sdk_release() {
        return deviceModel;
    }

    public final String getDeviceOS$sdk_release() {
        return deviceOS;
    }

    @NotNull
    public final String getCountry$sdk_release() {
        String string = Locale.getDefault().getCountry();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDefault().country");
        return string;
    }

    public final int getTimeZoneOffset$sdk_release() {
        TimeZone timeZone = Calendar.getInstance().getTimeZone();
        int offset = timeZone.getRawOffset();
        if (timeZone.inDaylightTime(new Date())) {
            offset += timeZone.getDSTSavings();
        }
        return offset / 1000;
    }

    @SuppressLint(value={"HardwareIds"})
    @Nullable
    public final String getDeviceId$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
    }

    public final String getDeviceMake$sdk_release() {
        return deviceMake;
    }

    @NotNull
    public final String getLocationAuthorization$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String locationAuthorization = "NOT_DETERMINED";
        if (RadarSettings.INSTANCE.getPermissionsDenied$sdk_release(context)) {
            locationAuthorization = "DENIED";
        }
        if (ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_FINE_LOCATION") == 0 || ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_COARSE_LOCATION") == 0) {
            locationAuthorization = "GRANTED_FOREGROUND";
        }
        if (Build.VERSION.SDK_INT >= 29 && ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_BACKGROUND_LOCATION") == 0) {
            locationAuthorization = "GRANTED_BACKGROUND";
        }
        return locationAuthorization;
    }

    @NotNull
    public final String getLocationAccuracyAuthorization$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        boolean olderThanAndroidS = Build.VERSION.SDK_INT < 31;
        boolean fineLocationGranted = ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_FINE_LOCATION") == 0;
        return olderThanAndroidS || fineLocationGranted ? "FULL" : "REDUCED";
    }

    public final boolean getLocationEnabled$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("location");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.location.LocationManager");
        }
        LocationManager manager = (LocationManager)object;
        return manager.isProviderEnabled("gps") || manager.isProviderEnabled("network");
    }

    public final boolean valid$sdk_release(@NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        boolean latitudeValid = !(location.getLatitude() == 0.0) && location.getLatitude() > -90.0 && location.getLatitude() < 90.0;
        boolean longitudeValid = !(location.getLongitude() == 0.0) && location.getLongitude() > -180.0 && location.getLongitude() < 180.0;
        boolean accuracyValid = location.getAccuracy() > 0.0f;
        return latitudeValid && longitudeValid && accuracyValid;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isEmulator$sdk_release() {
        String string = Build.BRAND;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"BRAND");
        if (StringsKt.startsWith$default((String)string, (String)"generic", (boolean)false, (int)2, null)) {
            string = Build.DEVICE;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DEVICE");
            if (StringsKt.startsWith$default((String)string, (String)"generic", (boolean)false, (int)2, null)) return true;
        }
        string = Build.FINGERPRINT;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FINGERPRINT");
        if (StringsKt.startsWith$default((String)string, (String)"generic", (boolean)false, (int)2, null)) return true;
        string = Build.FINGERPRINT;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FINGERPRINT");
        if (StringsKt.startsWith$default((String)string, (String)"unknown", (boolean)false, (int)2, null)) return true;
        string = Build.HARDWARE;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"HARDWARE");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"goldfish", (boolean)false, (int)2, null)) return true;
        string = Build.HARDWARE;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"HARDWARE");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"ranchu", (boolean)false, (int)2, null)) return true;
        string = Build.MODEL;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MODEL");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"google_sdk", (boolean)false, (int)2, null)) return true;
        string = Build.MODEL;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MODEL");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"Emulator", (boolean)false, (int)2, null)) return true;
        string = Build.MODEL;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MODEL");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"Android SDK built for x86", (boolean)false, (int)2, null)) return true;
        string = Build.MANUFACTURER;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MANUFACTURER");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"Genymotion", (boolean)false, (int)2, null)) return true;
        string = Build.PRODUCT;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PRODUCT");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"sdk_google", (boolean)false, (int)2, null)) return true;
        string = Build.PRODUCT;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PRODUCT");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"google_sdk", (boolean)false, (int)2, null)) return true;
        string = Build.PRODUCT;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PRODUCT");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"sdk", (boolean)false, (int)2, null)) return true;
        string = Build.PRODUCT;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PRODUCT");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"sdk_x86", (boolean)false, (int)2, null)) return true;
        string = Build.PRODUCT;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PRODUCT");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"vbox86p", (boolean)false, (int)2, null)) return true;
        string = Build.PRODUCT;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PRODUCT");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"emulator", (boolean)false, (int)2, null)) return true;
        string = Build.PRODUCT;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PRODUCT");
        if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"simulator", (boolean)false, (int)2, null)) return false;
        return true;
    }

    public final boolean isScreenSharing$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (Build.VERSION.SDK_INT < 17) {
            return false;
        }
        DisplayManagerCompat displayManagerCompat = DisplayManagerCompat.getInstance((Context)context);
        Intrinsics.checkNotNullExpressionValue((Object)displayManagerCompat, (String)"getInstance(context)");
        DisplayManagerCompat displayManager = displayManagerCompat;
        boolean multipleDisplays = displayManager.getDisplays().length > 1;
        boolean sharing = RadarSettings.INSTANCE.getSharing$sdk_release(context);
        return multipleDisplays || sharing;
    }

    @Nullable
    public final Date isoStringToDate$sdk_release(@Nullable String str) {
        if (str == null) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        try {
            return dateFormat.parse(str);
        }
        catch (ParseException pe) {
            return null;
        }
    }

    @Nullable
    public final String dateToISOString$sdk_release(@Nullable Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat.format(date);
    }
}

