/*
 * Decompiled with CFR 0.152.
 */
package io.radar.sdk;

import android.content.Context;
import android.content.SharedPreferences;
import io.radar.sdk.Radar;
import io.radar.sdk.RadarLogger;
import io.radar.sdk.RadarNotificationOptions;
import io.radar.sdk.RadarTrackingOptions;
import io.radar.sdk.RadarTripOptions;
import io.radar.sdk.model.RadarFeatureSettings;
import java.text.DecimalFormat;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0002\b,\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0000\u00a2\u0006\u0002\b(J\u0015\u0010)\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0000\u00a2\u0006\u0002\b*J\u0017\u0010+\u001a\u0004\u0018\u00010\u00042\u0006\u0010&\u001a\u00020'H\u0000\u00a2\u0006\u0002\b,J\u000e\u0010-\u001a\u00020.2\u0006\u0010&\u001a\u00020'J\u0015\u0010/\u001a\u0002002\u0006\u0010&\u001a\u00020'H\u0000\u00a2\u0006\u0002\b1J\u0015\u00102\u001a\u0002032\u0006\u0010&\u001a\u00020'H\u0000\u00a2\u0006\u0002\b4J\u0015\u00105\u001a\u00020\u00042\u0006\u0010&\u001a\u00020'H\u0000\u00a2\u0006\u0002\b6J\u0017\u00107\u001a\u0004\u0018\u00010\u00042\u0006\u0010&\u001a\u00020'H\u0000\u00a2\u0006\u0002\b8J\u0015\u00109\u001a\u00020\u00042\u0006\u0010&\u001a\u00020'H\u0000\u00a2\u0006\u0002\b:J\u0015\u0010;\u001a\u0002032\u0006\u0010&\u001a\u00020'H\u0000\u00a2\u0006\u0002\b<J\u0015\u0010=\u001a\u0002032\u0006\u0010&\u001a\u00020'H\u0000\u00a2\u0006\u0002\b>J\u0017\u0010?\u001a\u0004\u0018\u00010\u00042\u0006\u0010&\u001a\u00020'H\u0000\u00a2\u0006\u0002\b@J\u0015\u0010A\u001a\u00020B2\u0006\u0010&\u001a\u00020'H\u0000\u00a2\u0006\u0002\bCJ\u0017\u0010D\u001a\u0004\u0018\u00010E2\u0006\u0010&\u001a\u00020'H\u0000\u00a2\u0006\u0002\bFJ\u0017\u0010G\u001a\u0004\u0018\u00010H2\u0006\u0010&\u001a\u00020'H\u0000\u00a2\u0006\u0002\bIJ\u0015\u0010J\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0000\u00a2\u0006\u0002\bKJ\u0017\u0010L\u001a\u0004\u0018\u00010M2\u0006\u0010&\u001a\u00020'H\u0000\u00a2\u0006\u0002\bNJ\u0017\u0010O\u001a\u0004\u0018\u00010\u00042\u0006\u0010&\u001a\u00020'H\u0000\u00a2\u0006\u0002\bPJ\u0017\u0010Q\u001a\u0004\u0018\u00010M2\u0006\u0010&\u001a\u00020'H\u0000\u00a2\u0006\u0002\bRJ\u0015\u0010S\u001a\u00020\u00042\u0006\u0010&\u001a\u00020'H\u0000\u00a2\u0006\u0002\bTJ\u0010\u0010U\u001a\u00020V2\u0006\u0010&\u001a\u00020'H\u0002J\u0015\u0010W\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0000\u00a2\u0006\u0002\bXJ\u0015\u0010Y\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0000\u00a2\u0006\u0002\bZJ\u0015\u0010[\u001a\u00020M2\u0006\u0010&\u001a\u00020'H\u0000\u00a2\u0006\u0002\b\\J\u0018\u0010]\u001a\u00020M2\u0006\u0010&\u001a\u00020'2\u0006\u0010^\u001a\u00020\u0004H\u0002J\u0017\u0010_\u001a\u0004\u0018\u00010`2\u0006\u0010&\u001a\u00020'H\u0000\u00a2\u0006\u0002\baJ\u0015\u0010b\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0000\u00a2\u0006\u0002\bcJ\u0017\u0010d\u001a\u0004\u0018\u00010\u00042\u0006\u0010&\u001a\u00020'H\u0000\u00a2\u0006\u0002\beJ\u0015\u0010f\u001a\u00020\u00042\u0006\u0010&\u001a\u00020'H\u0000\u00a2\u0006\u0002\bgJ\u0015\u0010h\u001a\u00020i2\u0006\u0010&\u001a\u00020'H\u0000\u00a2\u0006\u0002\bjJ\u0015\u0010k\u001a\u00020i2\u0006\u0010&\u001a\u00020'H\u0000\u00a2\u0006\u0002\blJ\u001d\u0010m\u001a\u00020i2\u0006\u0010&\u001a\u00020'2\u0006\u0010n\u001a\u00020%H\u0000\u00a2\u0006\u0002\boJ\u001d\u0010p\u001a\u00020i2\u0006\u0010&\u001a\u00020'2\u0006\u0010n\u001a\u00020%H\u0000\u00a2\u0006\u0002\bqJ\u001f\u0010r\u001a\u00020i2\u0006\u0010&\u001a\u00020'2\b\u0010s\u001a\u0004\u0018\u00010\u0004H\u0000\u00a2\u0006\u0002\btJ\u0016\u0010u\u001a\u00020i2\u0006\u0010&\u001a\u00020'2\u0006\u0010v\u001a\u00020.J\u001d\u0010w\u001a\u00020i2\u0006\u0010&\u001a\u00020'2\u0006\u0010x\u001a\u000200H\u0000\u00a2\u0006\u0002\byJ\u001d\u0010z\u001a\u00020i2\u0006\u0010&\u001a\u00020'2\u0006\u0010{\u001a\u000203H\u0000\u00a2\u0006\u0002\b|J\u001f\u0010}\u001a\u00020i2\u0006\u0010&\u001a\u00020'2\b\u0010~\u001a\u0004\u0018\u00010\u0004H\u0000\u00a2\u0006\u0002\b\u007fJ!\u0010\u0080\u0001\u001a\u00020i2\u0006\u0010&\u001a\u00020'2\b\u0010\u0081\u0001\u001a\u00030\u0082\u0001H\u0000\u00a2\u0006\u0003\b\u0083\u0001J \u0010\u0084\u0001\u001a\u00020i2\u0006\u0010&\u001a\u00020'2\u0007\u0010\u0085\u0001\u001a\u00020BH\u0000\u00a2\u0006\u0003\b\u0086\u0001J\"\u0010\u0087\u0001\u001a\u00020i2\u0006\u0010&\u001a\u00020'2\t\u0010\u0088\u0001\u001a\u0004\u0018\u00010EH\u0000\u00a2\u0006\u0003\b\u0089\u0001J \u0010\u008a\u0001\u001a\u00020i2\u0006\u0010&\u001a\u00020'2\u0007\u0010\u008b\u0001\u001a\u00020HH\u0000\u00a2\u0006\u0003\b\u008c\u0001J \u0010\u008d\u0001\u001a\u00020i2\u0006\u0010&\u001a\u00020'2\u0007\u0010\u008e\u0001\u001a\u00020%H\u0000\u00a2\u0006\u0003\b\u008f\u0001J \u0010\u0090\u0001\u001a\u00020i2\u0006\u0010&\u001a\u00020'2\u0007\u0010\u0091\u0001\u001a\u00020MH\u0000\u00a2\u0006\u0003\b\u0092\u0001J\"\u0010\u0093\u0001\u001a\u00020i2\u0006\u0010&\u001a\u00020'2\t\u0010\u0094\u0001\u001a\u0004\u0018\u00010\u0004H\u0000\u00a2\u0006\u0003\b\u0095\u0001J \u0010\u0096\u0001\u001a\u00020i2\u0006\u0010&\u001a\u00020'2\u0007\u0010\u0091\u0001\u001a\u00020MH\u0000\u00a2\u0006\u0003\b\u0097\u0001J \u0010\u0098\u0001\u001a\u00020i2\u0006\u0010&\u001a\u00020'2\u0007\u0010\u0099\u0001\u001a\u00020%H\u0000\u00a2\u0006\u0003\b\u009a\u0001J \u0010\u009b\u0001\u001a\u00020i2\u0006\u0010&\u001a\u00020'2\u0007\u0010\u009c\u0001\u001a\u00020%H\u0000\u00a2\u0006\u0003\b\u009d\u0001J \u0010\u009e\u0001\u001a\u00020i2\u0006\u0010&\u001a\u00020'2\u0007\u0010\u0091\u0001\u001a\u00020MH\u0000\u00a2\u0006\u0003\b\u009f\u0001J\"\u0010\u00a0\u0001\u001a\u00020i2\u0006\u0010&\u001a\u00020'2\t\u0010\u0091\u0001\u001a\u0004\u0018\u00010`H\u0000\u00a2\u0006\u0003\b\u00a1\u0001J \u0010\u00a2\u0001\u001a\u00020i2\u0006\u0010&\u001a\u00020'2\u0007\u0010\u00a3\u0001\u001a\u00020%H\u0000\u00a2\u0006\u0003\b\u00a4\u0001J\"\u0010\u00a5\u0001\u001a\u00020i2\u0006\u0010&\u001a\u00020'2\t\u0010\u00a6\u0001\u001a\u0004\u0018\u00010\u0004H\u0000\u00a2\u0006\u0003\b\u00a7\u0001J\u0017\u0010\u00a8\u0001\u001a\u00020i2\u0006\u0010&\u001a\u00020'H\u0000\u00a2\u0006\u0003\b\u00a9\u0001J\u0017\u0010\u00aa\u0001\u001a\u00020i2\u0006\u0010&\u001a\u00020'H\u0000\u00a2\u0006\u0003\b\u00ab\u0001J\u0017\u0010\u00ac\u0001\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0000\u00a2\u0006\u0003\b\u00ad\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00ae\u0001"}, d2={"Lio/radar/sdk/RadarSettings;", "", "()V", "KEY_AD_ID_ENABLED", "", "KEY_ANONYMOUS", "KEY_DESCRIPTION", "KEY_FEATURE_SETTINGS", "KEY_FOREGROUND_SERVICE", "KEY_GOOGLE_PLAY_PROJECT_NUMBER", "KEY_HOST", "KEY_ID", "KEY_INSTALL_ID", "KEY_LAST_APP_OPEN_TIME", "KEY_LAST_TRACKED_TIME", "KEY_LOCATION_SERVICES_PROVIDER", "KEY_LOG_LEVEL", "KEY_METADATA", "KEY_NOTIFICATION_OPTIONS", "KEY_OLD_OFFLINE_MODE", "KEY_OLD_SYNC_MODE", "KEY_OLD_UPDATE_INTERVAL", "KEY_OLD_UPDATE_INTERVAL_RESPONSIVE", "", "KEY_PERMISSIONS_DENIED", "KEY_PREVIOUS_TRACKING_OPTIONS", "KEY_PUBLISHABLE_KEY", "KEY_REMOTE_TRACKING_OPTIONS", "KEY_SESSION_ID", "KEY_SHARING", "KEY_TRACKING", "KEY_TRACKING_OPTIONS", "KEY_TRIP_OPTIONS", "KEY_USER_DEBUG", "KEY_USER_ID", "KEY_VERIFIED_HOST", "getAdIdEnabled", "", "context", "Landroid/content/Context;", "getAdIdEnabled$sdk_release", "getAnonymousTrackingEnabled", "getAnonymousTrackingEnabled$sdk_release", "getDescription", "getDescription$sdk_release", "getFeatureSettings", "Lio/radar/sdk/model/RadarFeatureSettings;", "getForegroundService", "Lio/radar/sdk/RadarTrackingOptions$RadarTrackingOptionsForegroundService;", "getForegroundService$sdk_release", "getGooglePlayProjectNumber", "", "getGooglePlayProjectNumber$sdk_release", "getHost", "getHost$sdk_release", "getId", "getId$sdk_release", "getInstallId", "getInstallId$sdk_release", "getLastAppOpenTimeMillis", "getLastAppOpenTimeMillis$sdk_release", "getLastTrackedTime", "getLastTrackedTime$sdk_release", "getLocationServicesProvider", "getLocationServicesProvider$sdk_release", "getLogLevel", "Lio/radar/sdk/Radar$RadarLogLevel;", "getLogLevel$sdk_release", "getMetadata", "Lorg/json/JSONObject;", "getMetadata$sdk_release", "getNotificationOptions", "Lio/radar/sdk/RadarNotificationOptions;", "getNotificationOptions$sdk_release", "getPermissionsDenied", "getPermissionsDenied$sdk_release", "getPreviousTrackingOptions", "Lio/radar/sdk/RadarTrackingOptions;", "getPreviousTrackingOptions$sdk_release", "getPublishableKey", "getPublishableKey$sdk_release", "getRemoteTrackingOptions", "getRemoteTrackingOptions$sdk_release", "getSessionId", "getSessionId$sdk_release", "getSharedPreferences", "Landroid/content/SharedPreferences;", "getSharing", "getSharing$sdk_release", "getTracking", "getTracking$sdk_release", "getTrackingOptions", "getTrackingOptions$sdk_release", "getTrackingOptionsByKey", "key", "getTripOptions", "Lio/radar/sdk/RadarTripOptions;", "getTripOptions$sdk_release", "getUserDebug", "getUserDebug$sdk_release", "getUserId", "getUserId$sdk_release", "getVerifiedHost", "getVerifiedHost$sdk_release", "removePreviousTrackingOptions", "", "removePreviousTrackingOptions$sdk_release", "removeRemoteTrackingOptions", "removeRemoteTrackingOptions$sdk_release", "setAdIdEnabled", "enabled", "setAdIdEnabled$sdk_release", "setAnonymousTrackingEnabled", "setAnonymousTrackingEnabled$sdk_release", "setDescription", "description", "setDescription$sdk_release", "setFeatureSettings", "featureSettings", "setForegroundService", "foregroundService", "setForegroundService$sdk_release", "setGooglePlayProjectNumber", "googlePlayProjectNumber", "setGooglePlayProjectNumber$sdk_release", "setId", "_id", "setId$sdk_release", "setLocationServicesProvider", "provider", "Lio/radar/sdk/Radar$RadarLocationServicesProvider;", "setLocationServicesProvider$sdk_release", "setLogLevel", "level", "setLogLevel$sdk_release", "setMetadata", "metadata", "setMetadata$sdk_release", "setNotificationOptions", "notificationOptions", "setNotificationOptions$sdk_release", "setPermissionsDenied", "denied", "setPermissionsDenied$sdk_release", "setPreviousTrackingOptions", "options", "setPreviousTrackingOptions$sdk_release", "setPublishableKey", "publishableKey", "setPublishableKey$sdk_release", "setRemoteTrackingOptions", "setRemoteTrackingOptions$sdk_release", "setSharing", "sharing", "setSharing$sdk_release", "setTracking", "tracking", "setTracking$sdk_release", "setTrackingOptions", "setTrackingOptions$sdk_release", "setTripOptions", "setTripOptions$sdk_release", "setUserDebug", "userDebug", "setUserDebug$sdk_release", "setUserId", "userId", "setUserId$sdk_release", "updateLastAppOpenTimeMillis", "updateLastAppOpenTimeMillis$sdk_release", "updateLastTrackedTime", "updateLastTrackedTime$sdk_release", "updateSessionId", "updateSessionId$sdk_release", "sdk_release"})
public final class RadarSettings {
    @NotNull
    public static final RadarSettings INSTANCE = new RadarSettings();
    @NotNull
    private static final String KEY_PUBLISHABLE_KEY = "publishable_key";
    @NotNull
    private static final String KEY_LOCATION_SERVICES_PROVIDER = "provider";
    @NotNull
    private static final String KEY_INSTALL_ID = "install_id";
    @NotNull
    private static final String KEY_SESSION_ID = "session_id";
    @NotNull
    private static final String KEY_ID = "radar_user_id";
    @NotNull
    private static final String KEY_USER_ID = "user_id";
    @NotNull
    private static final String KEY_DESCRIPTION = "user_description";
    @NotNull
    private static final String KEY_METADATA = "user_metadata";
    @NotNull
    private static final String KEY_ANONYMOUS = "anonymous";
    @NotNull
    private static final String KEY_AD_ID_ENABLED = "ad_id_enabled";
    @NotNull
    private static final String KEY_TRACKING = "background_tracking";
    @NotNull
    private static final String KEY_TRACKING_OPTIONS = "tracking_options";
    @NotNull
    private static final String KEY_PREVIOUS_TRACKING_OPTIONS = "previous_tracking_options";
    @NotNull
    private static final String KEY_REMOTE_TRACKING_OPTIONS = "remote_tracking_options";
    @NotNull
    private static final String KEY_FOREGROUND_SERVICE = "foreground_service";
    @NotNull
    private static final String KEY_NOTIFICATION_OPTIONS = "notification_options";
    @NotNull
    private static final String KEY_FEATURE_SETTINGS = "feature_settings";
    @NotNull
    private static final String KEY_TRIP_OPTIONS = "trip_options";
    @NotNull
    private static final String KEY_LOG_LEVEL = "log_level";
    @NotNull
    private static final String KEY_HOST = "host";
    @NotNull
    private static final String KEY_PERMISSIONS_DENIED = "permissions_denied";
    @NotNull
    private static final String KEY_LAST_TRACKED_TIME = "last_tracked_time";
    @NotNull
    private static final String KEY_VERIFIED_HOST = "verified_host";
    @NotNull
    private static final String KEY_LAST_APP_OPEN_TIME = "last_app_open_time";
    @NotNull
    private static final String KEY_SHARING = "sharing";
    @NotNull
    private static final String KEY_GOOGLE_PLAY_PROJECT_NUMBER = "google_play_project_number";
    @NotNull
    private static final String KEY_OLD_UPDATE_INTERVAL = "dwell_delay";
    private static final int KEY_OLD_UPDATE_INTERVAL_RESPONSIVE = 60000;
    @NotNull
    private static final String KEY_OLD_SYNC_MODE = "sync_mode";
    @NotNull
    private static final String KEY_OLD_OFFLINE_MODE = "offline_mode";
    @NotNull
    private static final String KEY_USER_DEBUG = "user_debug";

    private RadarSettings() {
    }

    private final SharedPreferences getSharedPreferences(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("RadarSDK", 0);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"context.getSharedPreferences(\"RadarSDK\", Context.MODE_PRIVATE)");
        return sharedPreferences;
    }

    @Nullable
    public final String getPublishableKey$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.getSharedPreferences(context).getString(KEY_PUBLISHABLE_KEY, null);
    }

    public final void setPublishableKey$sdk_release(@NotNull Context context, @Nullable String publishableKey) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$setPublishableKey_u24lambda_u2d0 = editor$iv;
        boolean bl = false;
        $this$setPublishableKey_u24lambda_u2d0.putString(KEY_PUBLISHABLE_KEY, publishableKey);
        editor$iv.apply();
    }

    @Nullable
    public final String getLocationServicesProvider$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.getSharedPreferences(context).getString(KEY_LOCATION_SERVICES_PROVIDER, null);
    }

    public final void setLocationServicesProvider$sdk_release(@NotNull Context context, @NotNull Radar.RadarLocationServicesProvider provider) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)provider), (String)KEY_LOCATION_SERVICES_PROVIDER);
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$setLocationServicesProvider_u24lambda_u2d1 = editor$iv;
        boolean bl = false;
        $this$setLocationServicesProvider_u24lambda_u2d1.putString(KEY_LOCATION_SERVICES_PROVIDER, provider.name());
        editor$iv.apply();
    }

    @NotNull
    public final String getInstallId$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String installId = null;
        installId = this.getSharedPreferences(context).getString(KEY_INSTALL_ID, null);
        if (installId == null) {
            installId = UUID.randomUUID().toString();
            SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
            boolean commit$iv = false;
            boolean $i$f$edit = false;
            SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
            Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
            SharedPreferences.Editor $this$getInstallId_u24lambda_u2d2 = editor$iv;
            boolean bl = false;
            $this$getInstallId_u24lambda_u2d2.putString(KEY_INSTALL_ID, installId);
            editor$iv.apply();
        }
        return installId;
    }

    @NotNull
    public final String getSessionId$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string = new DecimalFormat("#").format(this.getSharedPreferences(context).getLong(KEY_SESSION_ID, 0L));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DecimalFormat(\"#\").format(getSharedPreferences(context).getLong(KEY_SESSION_ID, 0))");
        return string;
    }

    public final boolean updateSessionId$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        long timestampSeconds = System.currentTimeMillis() / (long)1000;
        long sessionIdSeconds = this.getSharedPreferences(context).getLong(KEY_SESSION_ID, 0L);
        RadarFeatureSettings settings = INSTANCE.getFeatureSettings(context);
        if (settings.getExtendFlushReplays()) {
            RadarLogger.d$default(Radar.INSTANCE.getLogger$sdk_release(), "Flushing replays from updateSessionId", null, null, 6, null);
            Radar.flushReplays$sdk_release$default(null, null, 3, null);
        }
        if (timestampSeconds - sessionIdSeconds > 300L) {
            SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
            boolean commit$iv = false;
            boolean $i$f$edit = false;
            SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
            Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
            SharedPreferences.Editor $this$updateSessionId_u24lambda_u2d3 = editor$iv;
            boolean bl = false;
            $this$updateSessionId_u24lambda_u2d3.putLong(KEY_SESSION_ID, timestampSeconds);
            editor$iv.apply();
            Radar.INSTANCE.logOpenedAppConversion$sdk_release();
            RadarLogger.d$default(Radar.INSTANCE.getLogger$sdk_release(), Intrinsics.stringPlus((String)"New session | sessionId = ", (Object)this.getSessionId$sdk_release(context)), null, null, 6, null);
            this.setSharing$sdk_release(context, false);
            return true;
        }
        return false;
    }

    @Nullable
    public final String getId$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.getSharedPreferences(context).getString(KEY_ID, null);
    }

    public final void setId$sdk_release(@NotNull Context context, @Nullable String _id) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$setId_u24lambda_u2d4 = editor$iv;
        boolean bl = false;
        $this$setId_u24lambda_u2d4.putString(KEY_ID, _id);
        editor$iv.apply();
    }

    @Nullable
    public final String getUserId$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.getSharedPreferences(context).getString(KEY_USER_ID, null);
    }

    public final void setUserId$sdk_release(@NotNull Context context, @Nullable String userId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$setUserId_u24lambda_u2d5 = editor$iv;
        boolean bl = false;
        $this$setUserId_u24lambda_u2d5.putString(KEY_USER_ID, userId);
        editor$iv.apply();
    }

    @Nullable
    public final String getDescription$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.getSharedPreferences(context).getString(KEY_DESCRIPTION, null);
    }

    public final void setDescription$sdk_release(@NotNull Context context, @Nullable String description) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$setDescription_u24lambda_u2d6 = editor$iv;
        boolean bl = false;
        $this$setDescription_u24lambda_u2d6.putString(KEY_DESCRIPTION, description);
        editor$iv.apply();
    }

    @Nullable
    public final JSONObject getMetadata$sdk_release(@NotNull Context context) {
        String string;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string2 = this.getSharedPreferences(context).getString(KEY_METADATA, null);
        if (string2 == null) {
            return null;
        }
        String metadataJson = string = string2;
        return new JSONObject(metadataJson);
    }

    public final void setMetadata$sdk_release(@NotNull Context context, @Nullable JSONObject metadata) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        JSONObject jSONObject = metadata;
        String metadataJSON = jSONObject == null ? null : jSONObject.toString();
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$setMetadata_u24lambda_u2d7 = editor$iv;
        boolean bl = false;
        $this$setMetadata_u24lambda_u2d7.putString(KEY_METADATA, metadataJSON);
        editor$iv.apply();
    }

    public final boolean getAnonymousTrackingEnabled$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.getSharedPreferences(context).getBoolean(KEY_ANONYMOUS, false);
    }

    public final void setAnonymousTrackingEnabled$sdk_release(@NotNull Context context, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$setAnonymousTrackingEnabled_u24lambda_u2d8 = editor$iv;
        boolean bl = false;
        $this$setAnonymousTrackingEnabled_u24lambda_u2d8.putBoolean(KEY_ANONYMOUS, enabled);
        editor$iv.apply();
    }

    public final boolean getAdIdEnabled$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.getSharedPreferences(context).getBoolean(KEY_AD_ID_ENABLED, false);
    }

    public final void setAdIdEnabled$sdk_release(@NotNull Context context, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$setAdIdEnabled_u24lambda_u2d9 = editor$iv;
        boolean bl = false;
        $this$setAdIdEnabled_u24lambda_u2d9.putBoolean(KEY_AD_ID_ENABLED, enabled);
        editor$iv.apply();
    }

    public final boolean getTracking$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.getSharedPreferences(context).getBoolean(KEY_TRACKING, false);
    }

    public final void setTracking$sdk_release(@NotNull Context context, boolean tracking) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$setTracking_u24lambda_u2d10 = editor$iv;
        boolean bl = false;
        $this$setTracking_u24lambda_u2d10.putBoolean(KEY_TRACKING, tracking);
        editor$iv.apply();
    }

    @NotNull
    public final RadarTrackingOptions getTrackingOptions$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.getTrackingOptionsByKey(context, KEY_TRACKING_OPTIONS);
    }

    private final RadarTrackingOptions getTrackingOptionsByKey(Context context, String key) {
        String optionsJson = this.getSharedPreferences(context).getString(key, null);
        RadarTrackingOptions options = null;
        if (optionsJson != null) {
            JSONObject optionsObj = new JSONObject(optionsJson);
            options = RadarTrackingOptions.Companion.fromJson(optionsObj);
        } else {
            int oldInterval = this.getSharedPreferences(context).getInt(KEY_OLD_UPDATE_INTERVAL, 0);
            if (oldInterval > 0) {
                int oldOffline;
                options = oldInterval == 60000 ? RadarTrackingOptions.RESPONSIVE : RadarTrackingOptions.EFFICIENT;
                int oldSync = this.getSharedPreferences(context).getInt(KEY_OLD_SYNC_MODE, 0);
                if (oldSync == -1) {
                    options.setSync(RadarTrackingOptions.RadarTrackingOptionsSync.ALL);
                }
                if ((oldOffline = this.getSharedPreferences(context).getInt(KEY_OLD_OFFLINE_MODE, 0)) == -1) {
                    options.setReplay(RadarTrackingOptions.RadarTrackingOptionsReplay.NONE);
                }
            } else {
                options = RadarTrackingOptions.EFFICIENT;
            }
        }
        return options;
    }

    public final void setTrackingOptions$sdk_release(@NotNull Context context, @NotNull RadarTrackingOptions options) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        JSONObject optionsObj = options.toJson();
        String string = optionsObj.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"optionsObj.toString()");
        String optionsJson = string;
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$setTrackingOptions_u24lambda_u2d11 = editor$iv;
        boolean bl = false;
        $this$setTrackingOptions_u24lambda_u2d11.putString(KEY_TRACKING_OPTIONS, optionsJson);
        editor$iv.apply();
    }

    @Nullable
    public final RadarTrackingOptions getPreviousTrackingOptions$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        boolean keyExists = this.getSharedPreferences(context).contains(KEY_PREVIOUS_TRACKING_OPTIONS);
        return keyExists ? this.getTrackingOptionsByKey(context, KEY_PREVIOUS_TRACKING_OPTIONS) : null;
    }

    public final void setPreviousTrackingOptions$sdk_release(@NotNull Context context, @NotNull RadarTrackingOptions options) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        JSONObject optionsObj = options.toJson();
        String string = optionsObj.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"optionsObj.toString()");
        String optionsJson = string;
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$setPreviousTrackingOptions_u24lambda_u2d12 = editor$iv;
        boolean bl = false;
        $this$setPreviousTrackingOptions_u24lambda_u2d12.putString(KEY_PREVIOUS_TRACKING_OPTIONS, optionsJson);
        editor$iv.apply();
    }

    public final void removePreviousTrackingOptions$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$removePreviousTrackingOptions_u24lambda_u2d13 = editor$iv;
        boolean bl = false;
        $this$removePreviousTrackingOptions_u24lambda_u2d13.remove(KEY_PREVIOUS_TRACKING_OPTIONS);
        editor$iv.apply();
    }

    @Nullable
    public final RadarTrackingOptions getRemoteTrackingOptions$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        boolean keyExists = this.getSharedPreferences(context).contains(KEY_REMOTE_TRACKING_OPTIONS);
        return keyExists ? this.getTrackingOptionsByKey(context, KEY_REMOTE_TRACKING_OPTIONS) : null;
    }

    public final void setRemoteTrackingOptions$sdk_release(@NotNull Context context, @NotNull RadarTrackingOptions options) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        String string = options.toJson().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"options.toJson().toString()");
        String optionsJson = string;
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$setRemoteTrackingOptions_u24lambda_u2d14 = editor$iv;
        boolean bl = false;
        $this$setRemoteTrackingOptions_u24lambda_u2d14.putString(KEY_REMOTE_TRACKING_OPTIONS, optionsJson);
        editor$iv.apply();
    }

    public final void removeRemoteTrackingOptions$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$removeRemoteTrackingOptions_u24lambda_u2d15 = editor$iv;
        boolean bl = false;
        $this$removeRemoteTrackingOptions_u24lambda_u2d15.remove(KEY_REMOTE_TRACKING_OPTIONS);
        editor$iv.apply();
    }

    public final void setNotificationOptions$sdk_release(@NotNull Context context, @NotNull RadarNotificationOptions notificationOptions) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)notificationOptions, (String)"notificationOptions");
        String string = notificationOptions.toJson().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"notificationOptions.toJson().toString()");
        String notificationOptionsJson = string;
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$setNotificationOptions_u24lambda_u2d16 = editor$iv;
        boolean bl = false;
        $this$setNotificationOptions_u24lambda_u2d16.putString(KEY_NOTIFICATION_OPTIONS, notificationOptionsJson);
        editor$iv.apply();
        RadarTrackingOptions.RadarTrackingOptionsForegroundService previousValue = this.getForegroundService$sdk_release(context);
        String string2 = notificationOptions.getForegroundServiceIcon();
        String string3 = string2 == null ? previousValue.getIconString() : string2;
        string2 = notificationOptions.getForegroundServiceColor();
        this.setForegroundService$sdk_release(context, new RadarTrackingOptions.RadarTrackingOptionsForegroundService(previousValue.getText(), previousValue.getTitle(), previousValue.getIcon(), previousValue.getUpdatesOnly(), previousValue.getActivity(), previousValue.getImportance(), previousValue.getId(), previousValue.getChannelName(), string3, string2 == null ? previousValue.getIconColor() : string2));
    }

    @Nullable
    public final RadarNotificationOptions getNotificationOptions$sdk_release(@NotNull Context context) {
        String string;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string2 = this.getSharedPreferences(context).getString(KEY_NOTIFICATION_OPTIONS, null);
        if (string2 == null) {
            return null;
        }
        String optionsJson = string = string2;
        JSONObject optionsObj = new JSONObject(optionsJson);
        return RadarNotificationOptions.Companion.fromJson(optionsObj);
    }

    @NotNull
    public final RadarTrackingOptions.RadarTrackingOptionsForegroundService getForegroundService$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String foregroundJson = this.getSharedPreferences(context).getString(KEY_FOREGROUND_SERVICE, null);
        RadarTrackingOptions.RadarTrackingOptionsForegroundService foregroundService = null;
        if (foregroundJson != null) {
            JSONObject foregroundObj = new JSONObject(foregroundJson);
            foregroundService = RadarTrackingOptions.RadarTrackingOptionsForegroundService.Companion.fromJson(foregroundObj);
        }
        if (foregroundService == null) {
            foregroundService = new RadarTrackingOptions.RadarTrackingOptionsForegroundService(null, null, null, false, null, null, null, null, null, null, 1023, null);
        }
        return foregroundService;
    }

    public final void setForegroundService$sdk_release(@NotNull Context context, @NotNull RadarTrackingOptions.RadarTrackingOptionsForegroundService foregroundService) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)foregroundService, (String)"foregroundService");
        RadarTrackingOptions.RadarTrackingOptionsForegroundService previousValue = this.getForegroundService$sdk_release(context);
        if (foregroundService.getIconString() == null) {
            foregroundService.setIconString(previousValue.getIconString());
        }
        if (foregroundService.getIconColor() == null) {
            foregroundService.setIconColor(previousValue.getIconColor());
        }
        String string = foregroundService.toJson().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"foregroundService.toJson().toString()");
        String foregroundJson = string;
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$setForegroundService_u24lambda_u2d17 = editor$iv;
        boolean bl = false;
        $this$setForegroundService_u24lambda_u2d17.putString(KEY_FOREGROUND_SERVICE, foregroundJson);
        editor$iv.apply();
    }

    @Nullable
    public final RadarTripOptions getTripOptions$sdk_release(@NotNull Context context) {
        String string;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string2 = this.getSharedPreferences(context).getString(KEY_TRIP_OPTIONS, null);
        if (string2 == null) {
            return null;
        }
        String optionsJson = string = string2;
        JSONObject optionsObj = new JSONObject(optionsJson);
        return RadarTripOptions.Companion.fromJson(optionsObj);
    }

    public final void setTripOptions$sdk_release(@NotNull Context context, @Nullable RadarTripOptions options) {
        JSONObject optionsObj;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        RadarTripOptions radarTripOptions = options;
        JSONObject jSONObject = optionsObj = radarTripOptions == null ? null : radarTripOptions.toJson();
        String optionsJson = jSONObject == null ? null : jSONObject.toString();
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$setTripOptions_u24lambda_u2d18 = editor$iv;
        boolean bl = false;
        $this$setTripOptions_u24lambda_u2d18.putString(KEY_TRIP_OPTIONS, optionsJson);
        editor$iv.apply();
    }

    public final void setFeatureSettings(@NotNull Context context, @NotNull RadarFeatureSettings featureSettings) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)featureSettings, (String)"featureSettings");
        String string = featureSettings.toJson().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"featureSettings.toJson().toString()");
        String optionsJson = string;
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$setFeatureSettings_u24lambda_u2d19 = editor$iv;
        boolean bl = false;
        $this$setFeatureSettings_u24lambda_u2d19.putString(KEY_FEATURE_SETTINGS, optionsJson);
        editor$iv.apply();
    }

    @NotNull
    public final RadarFeatureSettings getFeatureSettings(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String sharedPrefFeatureSettings = this.getSharedPreferences(context).getString(KEY_FEATURE_SETTINGS, null);
        RadarLogger.d$default(Radar.INSTANCE.getLogger$sdk_release(), Intrinsics.stringPlus((String)"getFeatureSettings | featureSettings = ", (Object)sharedPrefFeatureSettings), null, null, 6, null);
        String string = sharedPrefFeatureSettings;
        if (string == null) {
            return RadarFeatureSettings.Companion.default();
        }
        String optionsJson = string;
        return RadarFeatureSettings.Companion.fromJson(new JSONObject(optionsJson));
    }

    @NotNull
    public final Radar.RadarLogLevel getLogLevel$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int logLevelInt = this.getSharedPreferences(context).getInt(KEY_LOG_LEVEL, 3);
        boolean userDebug = this.getUserDebug$sdk_release(context);
        return userDebug ? Radar.RadarLogLevel.DEBUG : Radar.RadarLogLevel.Companion.fromInt(logLevelInt);
    }

    public final void setLogLevel$sdk_release(@NotNull Context context, @NotNull Radar.RadarLogLevel level) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        int logLevelInt = level.getValue();
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$setLogLevel_u24lambda_u2d20 = editor$iv;
        boolean bl = false;
        $this$setLogLevel_u24lambda_u2d20.putInt(KEY_LOG_LEVEL, logLevelInt);
        editor$iv.apply();
    }

    @NotNull
    public final String getHost$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string = this.getSharedPreferences(context).getString(KEY_HOST, null);
        return string == null ? "https://api.radar.io" : string;
    }

    public final void setPermissionsDenied$sdk_release(@NotNull Context context, boolean denied) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$setPermissionsDenied_u24lambda_u2d21 = editor$iv;
        boolean bl = false;
        $this$setPermissionsDenied_u24lambda_u2d21.putBoolean(KEY_PERMISSIONS_DENIED, denied);
        editor$iv.apply();
    }

    public final boolean getPermissionsDenied$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.getSharedPreferences(context).getBoolean(KEY_PERMISSIONS_DENIED, false);
    }

    public final void updateLastTrackedTime$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        long timestampSeconds = System.currentTimeMillis() / (long)1000;
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$updateLastTrackedTime_u24lambda_u2d22 = editor$iv;
        boolean bl = false;
        $this$updateLastTrackedTime_u24lambda_u2d22.putLong(KEY_LAST_TRACKED_TIME, timestampSeconds);
        editor$iv.apply();
    }

    public final long getLastTrackedTime$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.getSharedPreferences(context).getLong(KEY_LAST_TRACKED_TIME, 0L);
    }

    @NotNull
    public final String getVerifiedHost$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string = this.getSharedPreferences(context).getString(KEY_VERIFIED_HOST, null);
        return string == null ? "https://api-verified.radar.io" : string;
    }

    public final boolean getUserDebug$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.getSharedPreferences(context).getBoolean(KEY_USER_DEBUG, true);
    }

    public final void setUserDebug$sdk_release(@NotNull Context context, boolean userDebug) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$setUserDebug_u24lambda_u2d23 = editor$iv;
        boolean bl = false;
        $this$setUserDebug_u24lambda_u2d23.putBoolean(KEY_USER_DEBUG, userDebug);
        editor$iv.apply();
    }

    public final long getLastAppOpenTimeMillis$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.getSharedPreferences(context).getLong(KEY_LAST_APP_OPEN_TIME, 0L);
    }

    public final void updateLastAppOpenTimeMillis$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        long timestampSeconds = System.currentTimeMillis();
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$updateLastAppOpenTimeMillis_u24lambda_u2d24 = editor$iv;
        boolean bl = false;
        $this$updateLastAppOpenTimeMillis_u24lambda_u2d24.putLong(KEY_LAST_APP_OPEN_TIME, timestampSeconds);
        editor$iv.apply();
    }

    public final boolean getSharing$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.getSharedPreferences(context).getBoolean(KEY_SHARING, false);
    }

    public final void setSharing$sdk_release(@NotNull Context context, boolean sharing) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$setSharing_u24lambda_u2d25 = editor$iv;
        boolean bl = false;
        $this$setSharing_u24lambda_u2d25.putBoolean(KEY_SHARING, sharing);
        editor$iv.apply();
    }

    public final long getGooglePlayProjectNumber$sdk_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.getSharedPreferences(context).getLong(KEY_GOOGLE_PLAY_PROJECT_NUMBER, 0L);
    }

    public final void setGooglePlayProjectNumber$sdk_release(@NotNull Context context, long googlePlayProjectNumber) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$setGooglePlayProjectNumber_u24lambda_u2d26 = editor$iv;
        boolean bl = false;
        $this$setGooglePlayProjectNumber_u24lambda_u2d26.putLong(KEY_GOOGLE_PLAY_PROJECT_NUMBER, googlePlayProjectNumber);
        editor$iv.apply();
    }
}

