/*
 * Decompiled with CFR 0.152.
 */
package io.radar.sdk.util;

import android.content.Context;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/radar/sdk/util/RadarFileSystem;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "deleteFileAtPath", "", "filePath", "", "readFileAtPath", "writeData", "", "filename", "content", "sdk_release"})
public final class RadarFileSystem {
    @NotNull
    private final Context context;

    public RadarFileSystem(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    public final void writeData(@NotNull String filename, @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        FileOutputStream fileOutputStream = null;
        try {
            Object object = this.context.openFileOutput(filename, 0);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.openFileOutput(filename, Context.MODE_PRIVATE)");
            fileOutputStream = object;
            object = content;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            byte[] byArray = ((String)object).getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            fileOutputStream.write(byArray);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String readFileAtPath(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = this.context.openFileInput(filePath);
            Object object = fileInputStream;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)object, charset);
            object = TextStreamsKt.readText((Reader)inputStreamReader);
            return object;
        }
        catch (FileNotFoundException e) {
            String string = "";
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            FileInputStream fileInputStream2 = fileInputStream;
            if (fileInputStream2 != null) {
                fileInputStream2.close();
            }
        }
        return "";
    }

    public final boolean deleteFileAtPath(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        File file = new File(this.context.getFilesDir(), filePath);
        return file.delete();
    }
}

