/*
 * Decompiled with CFR 0.152.
 */
package io.radar.sdk.util;

import android.content.Context;
import io.radar.sdk.Radar;
import io.radar.sdk.model.RadarLog;
import io.radar.sdk.util.Flushable;
import io.radar.sdk.util.RadarFileSystem;
import io.radar.sdk.util.RadarLogBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000eH\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0016\u0010\u0012\u001a\u00020\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\"\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u0016\u0010\u001b\u001a\u00020\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u001cH\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lio/radar/sdk/util/RadarSimpleLogBuffer;", "Lio/radar/sdk/util/RadarLogBuffer;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "getContext", "()Landroid/content/Context;", "list", "Ljava/util/concurrent/LinkedBlockingDeque;", "Lio/radar/sdk/model/RadarLog;", "scheduler", "Ljava/util/concurrent/ScheduledExecutorService;", "kotlin.jvm.PlatformType", "getFlushableLogsStash", "Lio/radar/sdk/util/Flushable;", "getLogsFromDisk", "persist", "", "purgeOldestLogs", "logs", "write", "level", "Lio/radar/sdk/Radar$RadarLogLevel;", "message", "", "type", "Lio/radar/sdk/Radar$RadarLogType;", "writeLogsToDisk", "", "Companion", "sdk_release"})
public final class RadarSimpleLogBuffer
implements RadarLogBuffer {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    private final ScheduledExecutorService scheduler;
    @NotNull
    private final LinkedBlockingDeque<RadarLog> list;
    @Deprecated
    public static final int MAXIMUM_MEMORY_CAPACITY = 200;
    @Deprecated
    public static final int MAXIMUM_CAPACITY = 500;
    @Deprecated
    public static final int HALF_CAPACITY = 250;
    @Deprecated
    @NotNull
    public static final String logFilePath = "radarLogs.txt";

    public RadarSimpleLogBuffer(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.scheduler = Executors.newScheduledThreadPool(1);
        this.scheduler.scheduleAtFixedRate(() -> RadarSimpleLogBuffer._init_$lambda-0(this), 30L, 30L, TimeUnit.SECONDS);
        this.list = new LinkedBlockingDeque(200);
    }

    @Override
    @NotNull
    public Context getContext() {
        return this.context;
    }

    @Override
    public void write(@NotNull Radar.RadarLogLevel level, @NotNull String message, @Nullable Radar.RadarLogType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (!this.list.offer(new RadarLog(level, message, type, null, 8, null))) {
            this.persist();
            this.list.put(new RadarLog(level, message, type, null, 8, null));
        }
    }

    @Override
    public void persist() {
        if (this.list.size() > 0) {
            LinkedBlockingDeque<RadarLog> logs = this.getLogsFromDisk();
            if (logs.size() + this.list.size() > 500) {
                this.purgeOldestLogs(logs);
            }
            this.list.drainTo((Collection<RadarLog>)logs);
            this.writeLogsToDisk((Collection<RadarLog>)logs);
        }
    }

    @Override
    @NotNull
    public Flushable<RadarLog> getFlushableLogsStash() {
        this.persist();
        boolean bl = false;
        List logs = new ArrayList();
        this.getLogsFromDisk().drainTo(logs);
        return new Flushable<RadarLog>((List<RadarLog>)logs, this){
            final /* synthetic */ List<RadarLog> $logs;
            final /* synthetic */ RadarSimpleLogBuffer this$0;
            {
                this.$logs = $logs;
                this.this$0 = $receiver;
            }

            @NotNull
            public List<RadarLog> get() {
                return this.$logs;
            }

            /*
             * WARNING - void declaration
             */
            public void onFlush(boolean success) {
                if (success) {
                    new RadarFileSystem(this.this$0.getContext()).deleteFileAtPath("radarLogs.txt");
                }
                if (!success) {
                    void $this$forEach$iv;
                    LinkedBlockingDeque<RadarLog> purgedLogs = new LinkedBlockingDeque<RadarLog>();
                    CollectionsKt.reverse(this.$logs);
                    Iterable iterable = this.$logs;
                    RadarSimpleLogBuffer radarSimpleLogBuffer = this.this$0;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        RadarLog it = (RadarLog)element$iv;
                        boolean bl = false;
                        if (purgedLogs.offerFirst(it)) continue;
                        RadarSimpleLogBuffer.access$purgeOldestLogs(radarSimpleLogBuffer, purgedLogs);
                    }
                    RadarSimpleLogBuffer.access$writeLogsToDisk(this.this$0, purgedLogs);
                }
            }
        };
    }

    private final void purgeOldestLogs(LinkedBlockingDeque<RadarLog> logs) {
        boolean bl = false;
        List logsToDiscard = new ArrayList();
        logs.drainTo(logsToDiscard, 250);
        logs.put(new RadarLog(Radar.RadarLogLevel.DEBUG, "----- purged oldest logs -----", null, null, 8, null));
    }

    private final LinkedBlockingDeque<RadarLog> getLogsFromDisk() {
        String json = new RadarFileSystem(this.getContext()).readFileAtPath(logFilePath);
        LinkedBlockingDeque<RadarLog> logs = new LinkedBlockingDeque<RadarLog>();
        if (Intrinsics.areEqual((Object)json, (Object)"")) {
            return logs;
        }
        int n = 0;
        JSONArray jsonArray = new JSONArray(json);
        int n2 = jsonArray.length();
        if (n < n2) {
            do {
                int i = n++;
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"jsonObject");
                RadarLog log2 = RadarLog.Companion.fromJson(jsonObject);
                logs.add(log2);
            } while (n < n2);
        }
        return logs;
    }

    private final void writeLogsToDisk(Collection<RadarLog> logs) {
        JSONArray jsonArray = new JSONArray();
        for (RadarLog log2 : logs) {
            jsonArray.put((Object)log2.toJson());
        }
        RadarFileSystem radarFileSystem = new RadarFileSystem(this.getContext());
        String string = jsonArray.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonArray.toString()");
        radarFileSystem.writeData(logFilePath, string);
    }

    private static final void _init_$lambda-0(RadarSimpleLogBuffer this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.persist();
    }

    public static final /* synthetic */ void access$writeLogsToDisk(RadarSimpleLogBuffer $this, Collection logs) {
        $this.writeLogsToDisk(logs);
    }

    public static final /* synthetic */ void access$purgeOldestLogs(RadarSimpleLogBuffer $this, LinkedBlockingDeque logs) {
        $this.purgeOldestLogs(logs);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/radar/sdk/util/RadarSimpleLogBuffer$Companion;", "", "()V", "HALF_CAPACITY", "", "MAXIMUM_CAPACITY", "MAXIMUM_MEMORY_CAPACITY", "logFilePath", "", "sdk_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

