/*
 * Decompiled with CFR 0.152.
 */
package io.radar.sdk.util;

import android.content.Context;
import io.radar.sdk.Radar;
import io.radar.sdk.RadarSettings;
import io.radar.sdk.model.RadarLog;
import io.radar.sdk.util.Flushable;
import io.radar.sdk.util.RadarFileStorage;
import io.radar.sdk.util.RadarLogBuffer;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\b\u0000\u0018\u0000 !2\u00020\u0001:\u0001!B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000fH\u0016J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0012H\u0002J*\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0016\u0010\u001e\u001a\u00020\u00122\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\t0 H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lio/radar/sdk/util/RadarSimpleLogBuffer;", "Lio/radar/sdk/util/RadarLogBuffer;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "getContext", "()Landroid/content/Context;", "list", "Ljava/util/concurrent/LinkedBlockingDeque;", "Lio/radar/sdk/model/RadarLog;", "oldList", "scheduler", "Ljava/util/concurrent/ScheduledExecutorService;", "kotlin.jvm.PlatformType", "getFlushableLogsStash", "Lio/radar/sdk/util/Flushable;", "getLogsFromDisk", "oldPurgeOldestLogs", "", "persistLogs", "purgeOldestLogs", "write", "level", "Lio/radar/sdk/Radar$RadarLogLevel;", "message", "", "type", "Lio/radar/sdk/Radar$RadarLogType;", "createdAt", "Ljava/util/Date;", "writeLogsToDisk", "logs", "", "Companion", "sdk_release"})
public final class RadarSimpleLogBuffer
implements RadarLogBuffer {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    private final ScheduledExecutorService scheduler;
    @NotNull
    private final LinkedBlockingDeque<RadarLog> list;
    @NotNull
    private final LinkedBlockingDeque<RadarLog> oldList;
    @Deprecated
    public static final int MAXIMUM_MEMORY_CAPACITY = 200;
    @Deprecated
    public static final int MAXIMUM_CAPACITY = 500;
    @Deprecated
    public static final int HALF_CAPACITY = 250;
    @Deprecated
    @NotNull
    public static final String logFileDir = "radar_logs";
    @Deprecated
    private static int counter;

    public RadarSimpleLogBuffer(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.scheduler = Executors.newScheduledThreadPool(1);
        this.scheduler.scheduleAtFixedRate(() -> RadarSimpleLogBuffer._init_$lambda-0(this), 30L, 30L, TimeUnit.SECONDS);
        File file = new File(this.getContext().getFilesDir(), logFileDir);
        if (!file.exists()) {
            file.mkdir();
        }
        this.list = new LinkedBlockingDeque(200);
        this.oldList = new LinkedBlockingDeque(500);
    }

    @Override
    @NotNull
    public Context getContext() {
        return this.context;
    }

    @Override
    public void write(@NotNull Radar.RadarLogLevel level, @NotNull String message, @Nullable Radar.RadarLogType type, @NotNull Date createdAt) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)createdAt, (String)"createdAt");
        if (!this.oldList.offer(new RadarLog(level, message, type, null, 8, null))) {
            this.oldPurgeOldestLogs();
            this.oldList.put(new RadarLog(level, message, type, null, 8, null));
        }
        if (RadarSettings.INSTANCE.getFeatureSettings(this.getContext()).getUseLogPersistence() && !this.list.offer(new RadarLog(level, message, type, createdAt))) {
            this.persistLogs();
            this.list.put(new RadarLog(level, message, type, createdAt));
        }
    }

    @Override
    public void persistLogs() {
        if (RadarSettings.INSTANCE.getFeatureSettings(this.getContext()).getUseLogPersistence()) {
            int n;
            File[] files;
            File[] fileArray;
            if (this.list.size() > 0) {
                this.writeLogsToDisk((Collection<RadarLog>)this.list);
                this.list.clear();
            }
            if (((fileArray = (files = new RadarFileStorage(this.getContext()).allFilesInDirectory(logFileDir))) == null ? 0 : (n = fileArray.length)) > 500) {
                this.purgeOldestLogs();
            }
        }
    }

    @Override
    @NotNull
    public Flushable<RadarLog> getFlushableLogsStash() {
        this.persistLogs();
        boolean bl = false;
        List logs = new ArrayList();
        this.getLogsFromDisk().drainTo(logs);
        boolean bl2 = false;
        List oldLogs = new ArrayList();
        this.oldList.drainTo(oldLogs);
        return new Flushable<RadarLog>(this, (List<RadarLog>)logs, (List<RadarLog>)oldLogs){
            final /* synthetic */ RadarSimpleLogBuffer this$0;
            final /* synthetic */ List<RadarLog> $logs;
            final /* synthetic */ List<RadarLog> $oldLogs;
            {
                this.this$0 = $receiver;
                this.$logs = $logs;
                this.$oldLogs = $oldLogs;
            }

            @NotNull
            public List<RadarLog> get() {
                if (RadarSettings.INSTANCE.getFeatureSettings(this.this$0.getContext()).getUseLogPersistence()) {
                    return this.$logs;
                }
                return this.$oldLogs;
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            public void onFlush(boolean success) {
                block7: {
                    if (!success) break block7;
                    files = new RadarFileStorage(this.this$0.getContext()).allFilesInDirectory("radar_logs");
                    var3_3 = files;
                    var4_4 = false;
                    var5_6 = false;
                    if (var3_3 == null) ** GOTO lbl-1000
                    var5_7 /* !! */  = var3_3;
                    var6_9 = false;
                    if (var5_7 /* !! */ .length == 0) lbl-1000:
                    // 2 sources

                    {
                        v0 = true;
                    } else {
                        v0 = false;
                    }
                    if (!v0) {
                        var3_3 = ArrayIteratorKt.iterator((Object[])files);
                        while (var3_3.hasNext()) {
                            file = (File)var3_3.next();
                            file.delete();
                        }
                    }
                }
                if (!success) {
                    CollectionsKt.reverse(this.$oldLogs);
                    files = this.$oldLogs;
                    var3_3 = this.this$0;
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        it = (RadarLog)element$iv;
                        $i$a$-forEach-RadarSimpleLogBuffer$getFlushableLogsStash$1$onFlush$1 = false;
                        if (RadarSimpleLogBuffer.access$getOldList$p((RadarSimpleLogBuffer)var3_3).offerFirst(it)) continue;
                        RadarSimpleLogBuffer.access$oldPurgeOldestLogs((RadarSimpleLogBuffer)var3_3);
                    }
                    if (RadarSettings.INSTANCE.getFeatureSettings(this.this$0.getContext()).getUseLogPersistence()) {
                        RadarSimpleLogBuffer.access$purgeOldestLogs(this.this$0);
                    }
                }
            }
        };
    }

    private final void oldPurgeOldestLogs() {
        boolean bl = false;
        List oldLogs = new ArrayList();
        this.oldList.drainTo(oldLogs, 250);
        if (!RadarSettings.INSTANCE.getFeatureSettings(this.getContext()).getUseLogPersistence()) {
            RadarLogBuffer.DefaultImpls.write$default(this, Radar.RadarLogLevel.DEBUG, "----- purged oldest logs -----", null, null, 8, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void purgeOldestLogs() {
        File[] files;
        File[] fileArray = files = new RadarFileStorage(this.getContext()).allFilesInDirectory(logFileDir);
        boolean bl = false;
        int n = 0;
        if (fileArray == null) return;
        File[] fileArray2 = fileArray;
        int n2 = 0;
        if (fileArray2.length == 0) {
            return;
        }
        boolean bl2 = false;
        if (bl2) {
            return;
        }
        boolean bl3 = false;
        if (bl3) {
            return;
        }
        boolean printedPurgedLogs = false;
        File[] fileArray3;
        while ((fileArray3 = files) != null) {
            int n3 = n = fileArray3.length;
            if (n3 <= 500) return;
            File[] fileArray4 = files;
            int numberToPurge = Integer.min(250, fileArray4 == null ? 0 : (n2 = fileArray4.length));
            n = 0;
            if (n < numberToPurge) {
                do {
                    File file;
                    int i = n++;
                    File[] fileArray5 = files;
                    if (fileArray5 == null || (file = fileArray5[i]) == null) continue;
                    file.delete();
                } while (n < numberToPurge);
            }
            if (!printedPurgedLogs) {
                this.writeLogsToDisk(CollectionsKt.listOf((Object)new RadarLog(Radar.RadarLogLevel.DEBUG, "----- purged oldest logs -----", null, null, 8, null)));
                printedPurgedLogs = true;
            }
            files = new RadarFileStorage(this.getContext()).allFilesInDirectory(logFileDir);
        }
        return;
    }

    /*
     * Unable to fully structure code
     */
    private final LinkedBlockingDeque<RadarLog> getLogsFromDisk() {
        files = new RadarFileStorage(this.getContext()).allFilesInDirectory("radar_logs");
        logs = new LinkedBlockingDeque<RadarLog>();
        var3_3 = files;
        var4_4 = false;
        var5_6 = false;
        if (var3_3 == null) ** GOTO lbl-1000
        var5_7 = var3_3;
        var6_9 = false;
        if (var5_7.length == 0) lbl-1000:
        // 2 sources

        {
            v0 = true;
        } else {
            v0 = false;
        }
        if (v0) {
            return logs;
        }
        var3_3 = ArrayIteratorKt.iterator((Object[])files);
        while (var3_3.hasNext()) {
            file = (File)var3_3.next();
            v1 = new RadarFileStorage(this.getContext());
            var6_10 = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)var6_10, (String)"file.name");
            jsonString = v1.readFileAtPath("radar_logs", var6_10);
            log = RadarLog.Companion.fromJson(new JSONObject(jsonString));
            if (log == null) continue;
            logs.add(log);
        }
        return logs;
    }

    private final void writeLogsToDisk(Collection<RadarLog> logs) {
        for (RadarLog log2 : logs) {
            String counterString;
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "%04d";
            Object[] objectArray = new Object[1];
            Companion companion = Companion;
            int n = counter;
            counter = n + 1;
            objectArray[0] = n;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(format, *args)");
            String fileName = log2.getCreatedAt().getTime() / (long)1000 + counterString;
            RadarFileStorage radarFileStorage = new RadarFileStorage(this.getContext());
            string = log2.toJson().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"log.toJson().toString()");
            radarFileStorage.writeData(logFileDir, fileName, string);
        }
    }

    private static final void _init_$lambda-0(RadarSimpleLogBuffer this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.persistLogs();
    }

    public static final /* synthetic */ void access$purgeOldestLogs(RadarSimpleLogBuffer $this) {
        $this.purgeOldestLogs();
    }

    public static final /* synthetic */ LinkedBlockingDeque access$getOldList$p(RadarSimpleLogBuffer $this) {
        return $this.oldList;
    }

    public static final /* synthetic */ void access$oldPurgeOldestLogs(RadarSimpleLogBuffer $this) {
        $this.oldPurgeOldestLogs();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/radar/sdk/util/RadarSimpleLogBuffer$Companion;", "", "()V", "HALF_CAPACITY", "", "MAXIMUM_CAPACITY", "MAXIMUM_MEMORY_CAPACITY", "counter", "getCounter", "()I", "setCounter", "(I)V", "logFileDir", "", "sdk_release"})
    private static final class Companion {
        private Companion() {
        }

        public final int getCounter() {
            return counter;
        }

        public final void setCounter(int n) {
            counter = n;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

