/*
 * Decompiled with CFR 0.152.
 */
package io.radar.sdk;

import android.annotation.SuppressLint;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.location.Location;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.GeofencingClient;
import com.google.android.gms.location.GeofencingEvent;
import com.google.android.gms.location.GeofencingRequest;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationResult;
import com.google.android.gms.location.LocationServices;
import io.radar.sdk.Radar;
import io.radar.sdk.RadarAbstractLocationClient;
import io.radar.sdk.RadarLogger;
import io.radar.sdk.RadarTrackingOptions;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0001\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006JN\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172!\u0010\u0018\u001a\u001d\u0012\u0013\u0012\u00110\u001a\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001d\u0012\u0004\u0012\u00020\u00100\u0019H\u0016\u00a2\u0006\u0002\u0010\u001eJ5\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020!2#\u0010\u0018\u001a\u001f\u0012\u0015\u0012\u0013\u0018\u00010\"\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(#\u0012\u0004\u0012\u00020\u00100\u0019H\u0016J-\u0010$\u001a\u00020\u00102#\u0010\u0018\u001a\u001f\u0012\u0015\u0012\u0013\u0018\u00010\"\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(#\u0012\u0004\u0012\u00020\u00100\u0019H\u0016J\u0012\u0010%\u001a\u0004\u0018\u00010\"2\u0006\u0010&\u001a\u00020'H\u0016J\u0018\u0010(\u001a\n\u0012\u0004\u0012\u00020\"\u0018\u00010)2\u0006\u0010&\u001a\u00020'H\u0016J\u0012\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010,\u001a\u00020-2\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010.\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010/\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J(\u00100\u001a\u00020\u00102\u0006\u0010 \u001a\u00020!2\u0006\u00101\u001a\u00020-2\u0006\u00102\u001a\u00020-2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lio/radar/sdk/RadarGoogleLocationClient;", "Lio/radar/sdk/RadarAbstractLocationClient;", "context", "Landroid/content/Context;", "logger", "Lio/radar/sdk/RadarLogger;", "(Landroid/content/Context;Lio/radar/sdk/RadarLogger;)V", "geofencingClient", "Lcom/google/android/gms/location/GeofencingClient;", "getGeofencingClient", "()Lcom/google/android/gms/location/GeofencingClient;", "locationClient", "Lcom/google/android/gms/location/FusedLocationProviderClient;", "getLocationClient", "()Lcom/google/android/gms/location/FusedLocationProviderClient;", "addGeofences", "", "abstractGeofences", "", "Lio/radar/sdk/RadarAbstractLocationClient$RadarAbstractGeofence;", "abstractGeofenceRequest", "Lio/radar/sdk/RadarAbstractLocationClient$RadarAbstractGeofenceRequest;", "pendingIntent", "Landroid/app/PendingIntent;", "block", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "success", "([Lio/radar/sdk/RadarAbstractLocationClient$RadarAbstractGeofence;Lio/radar/sdk/RadarAbstractLocationClient$RadarAbstractGeofenceRequest;Landroid/app/PendingIntent;Lkotlin/jvm/functions/Function1;)V", "getCurrentLocation", "desiredAccuracy", "Lio/radar/sdk/RadarTrackingOptions$RadarTrackingOptionsDesiredAccuracy;", "Landroid/location/Location;", "location", "getLastLocation", "getLocationFromGeofenceIntent", "intent", "Landroid/content/Intent;", "getLocationsFromLocationIntent", "", "getSourceFromGeofenceIntent", "Lio/radar/sdk/Radar$RadarLocationSource;", "priorityForDesiredAccuracy", "", "removeGeofences", "removeLocationUpdates", "requestLocationUpdates", "interval", "fastestInterval", "sdk_release"})
@SuppressLint(value={"MissingPermission"})
public final class RadarGoogleLocationClient
extends RadarAbstractLocationClient {
    @NotNull
    private final RadarLogger logger;
    @SuppressLint(value={"VisibleForTests"})
    @NotNull
    private final FusedLocationProviderClient locationClient;
    @NotNull
    private final GeofencingClient geofencingClient;

    public RadarGoogleLocationClient(@NotNull Context context, @NotNull RadarLogger logger) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
        FusedLocationProviderClient fusedLocationProviderClient = LocationServices.getFusedLocationProviderClient((Context)context);
        Intrinsics.checkNotNullExpressionValue((Object)fusedLocationProviderClient, (String)"getFusedLocationProviderClient(context)");
        this.locationClient = fusedLocationProviderClient;
        fusedLocationProviderClient = LocationServices.getGeofencingClient((Context)context);
        Intrinsics.checkNotNullExpressionValue((Object)fusedLocationProviderClient, (String)"getGeofencingClient(context)");
        this.geofencingClient = fusedLocationProviderClient;
    }

    @NotNull
    public final FusedLocationProviderClient getLocationClient() {
        return this.locationClient;
    }

    @NotNull
    public final GeofencingClient getGeofencingClient() {
        return this.geofencingClient;
    }

    @Override
    public void getCurrentLocation(@NotNull RadarTrackingOptions.RadarTrackingOptionsDesiredAccuracy desiredAccuracy, @NotNull Function1<? super Location, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)((Object)desiredAccuracy), (String)"desiredAccuracy");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        int priority = this.priorityForDesiredAccuracy(desiredAccuracy);
        RadarLogger.d$default(this.logger, "Requesting location", null, null, 6, null);
        this.locationClient.getCurrentLocation(priority, null).addOnSuccessListener(arg_0 -> RadarGoogleLocationClient.getCurrentLocation$lambda-0(this, block, arg_0)).addOnCanceledListener(() -> RadarGoogleLocationClient.getCurrentLocation$lambda-1(block));
    }

    @Override
    public void requestLocationUpdates(@NotNull RadarTrackingOptions.RadarTrackingOptionsDesiredAccuracy desiredAccuracy, int interval, int fastestInterval, @NotNull PendingIntent pendingIntent) {
        Intrinsics.checkNotNullParameter((Object)((Object)desiredAccuracy), (String)"desiredAccuracy");
        Intrinsics.checkNotNullParameter((Object)pendingIntent, (String)"pendingIntent");
        int priority = this.priorityForDesiredAccuracy(desiredAccuracy);
        LocationRequest locationRequest = new LocationRequest();
        boolean bl = false;
        boolean bl2 = false;
        LocationRequest $this$requestLocationUpdates_u24lambda_u2d2 = locationRequest;
        boolean bl3 = false;
        $this$requestLocationUpdates_u24lambda_u2d2.setPriority(priority);
        $this$requestLocationUpdates_u24lambda_u2d2.setInterval((long)interval * 1000L);
        $this$requestLocationUpdates_u24lambda_u2d2.setFastestInterval((long)fastestInterval * 1000L);
        $this$requestLocationUpdates_u24lambda_u2d2.setMaxWaitTime((long)interval * 1000L);
        LocationRequest locationRequest2 = locationRequest;
        this.locationClient.requestLocationUpdates(locationRequest2, pendingIntent);
    }

    @Override
    public void removeLocationUpdates(@NotNull PendingIntent pendingIntent) {
        Intrinsics.checkNotNullParameter((Object)pendingIntent, (String)"pendingIntent");
        this.locationClient.removeLocationUpdates(pendingIntent);
    }

    @Override
    public void getLastLocation(@NotNull Function1<? super Location, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.locationClient.getLastLocation().addOnSuccessListener(arg_0 -> RadarGoogleLocationClient.getLastLocation$lambda-3(block, arg_0)).addOnFailureListener(arg_0 -> RadarGoogleLocationClient.getLastLocation$lambda-4(block, arg_0));
    }

    @Override
    public void addGeofences(@NotNull RadarAbstractLocationClient.RadarAbstractGeofence[] abstractGeofences, @NotNull RadarAbstractLocationClient.RadarAbstractGeofenceRequest abstractGeofenceRequest, @NotNull PendingIntent pendingIntent, @NotNull Function1<? super Boolean, Unit> block) {
        int n;
        Intrinsics.checkNotNullParameter((Object)abstractGeofences, (String)"abstractGeofences");
        Intrinsics.checkNotNullParameter((Object)abstractGeofenceRequest, (String)"abstractGeofenceRequest");
        Intrinsics.checkNotNullParameter((Object)pendingIntent, (String)"pendingIntent");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean bl = false;
        List geofences = new ArrayList();
        GeofencingRequest $this$forEach$iv = abstractGeofences;
        boolean $i$f$forEach = false;
        GeofencingRequest geofencingRequest = $this$forEach$iv;
        int n2 = ((RadarAbstractLocationClient.RadarAbstractGeofence[])geofencingRequest).length;
        for (n = 0; n < n2; ++n) {
            RadarAbstractLocationClient.RadarAbstractGeofence element$iv;
            RadarAbstractLocationClient.RadarAbstractGeofence abstractGeofence = element$iv = geofencingRequest[n];
            boolean bl2 = false;
            int transitionTypes = 0;
            if (abstractGeofence.getTransitionEnter()) {
                transitionTypes |= 1;
            }
            if (abstractGeofence.getTransitionExit()) {
                transitionTypes |= 2;
            }
            if (abstractGeofence.getTransitionDwell()) {
                transitionTypes |= 4;
            }
            Geofence geofence = new Geofence.Builder().setRequestId(abstractGeofence.getRequestId()).setCircularRegion(abstractGeofence.getLatitude(), abstractGeofence.getLongitude(), abstractGeofence.getRadius()).setExpirationDuration(-1L).setTransitionTypes(transitionTypes).setLoiteringDelay(abstractGeofence.getDwellDuration()).build();
            Intrinsics.checkNotNullExpressionValue((Object)geofence, (String)"Builder()\n                .setRequestId(abstractGeofence.requestId)\n                .setCircularRegion(abstractGeofence.latitude, abstractGeofence.longitude, abstractGeofence.radius)\n                .setExpirationDuration(Geofence.NEVER_EXPIRE)\n                .setTransitionTypes(transitionTypes)\n                .setLoiteringDelay(abstractGeofence.dwellDuration)\n                .build()");
            Geofence geofence2 = geofence;
            geofences.add(geofence2);
        }
        int initialTrigger = 0;
        if (abstractGeofenceRequest.getInitialTriggerEnter()) {
            initialTrigger |= 1;
        }
        if (abstractGeofenceRequest.getInitialTriggerExit()) {
            initialTrigger |= 2;
        }
        if (abstractGeofenceRequest.getInitialTriggerDwell()) {
            initialTrigger |= 4;
        }
        geofencingRequest = new GeofencingRequest.Builder().addGeofences(geofences).setInitialTrigger(initialTrigger).build();
        Intrinsics.checkNotNullExpressionValue((Object)geofencingRequest, (String)"Builder()\n            .addGeofences(geofences)\n            .setInitialTrigger(initialTrigger)\n            .build()");
        GeofencingRequest request = geofencingRequest;
        geofencingRequest = this.geofencingClient.addGeofences(request, pendingIntent);
        n2 = 0;
        n = 0;
        GeofencingRequest $this$addGeofences_u24lambda_u2d8 = geofencingRequest;
        boolean bl3 = false;
        $this$addGeofences_u24lambda_u2d8.addOnSuccessListener(arg_0 -> RadarGoogleLocationClient.addGeofences$lambda-8$lambda-6(block, arg_0));
        $this$addGeofences_u24lambda_u2d8.addOnFailureListener(arg_0 -> RadarGoogleLocationClient.addGeofences$lambda-8$lambda-7(block, arg_0));
    }

    @Override
    public void removeGeofences(@NotNull PendingIntent pendingIntent) {
        Intrinsics.checkNotNullParameter((Object)pendingIntent, (String)"pendingIntent");
        this.geofencingClient.removeGeofences(pendingIntent);
    }

    private final int priorityForDesiredAccuracy(RadarTrackingOptions.RadarTrackingOptionsDesiredAccuracy desiredAccuracy) {
        int n;
        RadarTrackingOptions.RadarTrackingOptionsDesiredAccuracy radarTrackingOptionsDesiredAccuracy = desiredAccuracy;
        int n2 = WhenMappings.$EnumSwitchMapping$0[radarTrackingOptionsDesiredAccuracy.ordinal()];
        switch (n2) {
            case 1: {
                n = 100;
                break;
            }
            case 2: {
                n = 102;
                break;
            }
            case 3: {
                n = 104;
                break;
            }
            case 4: {
                n = 105;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    @Override
    @Nullable
    public Location getLocationFromGeofenceIntent(@NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        GeofencingEvent event = GeofencingEvent.fromIntent((Intent)intent);
        if (event == null) {
            return null;
        }
        return event.getTriggeringLocation();
    }

    @Override
    @Nullable
    public Radar.RadarLocationSource getSourceFromGeofenceIntent(@NotNull Intent intent) {
        Radar.RadarLocationSource radarLocationSource;
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        GeofencingEvent event = GeofencingEvent.fromIntent((Intent)intent);
        if (event == null) {
            return null;
        }
        int n = event.getGeofenceTransition();
        switch (n) {
            case 1: {
                radarLocationSource = Radar.RadarLocationSource.GEOFENCE_ENTER;
                break;
            }
            case 4: {
                radarLocationSource = Radar.RadarLocationSource.GEOFENCE_DWELL;
                break;
            }
            default: {
                radarLocationSource = Radar.RadarLocationSource.GEOFENCE_EXIT;
            }
        }
        return radarLocationSource;
    }

    @Override
    @Nullable
    public List<Location> getLocationsFromLocationIntent(@NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        LocationResult result = LocationResult.extractResult((Intent)intent);
        RadarLogger.d$default(this.logger, Intrinsics.stringPlus((String)"Received location intent with result: ", (Object)result), null, null, 6, null);
        if (result == null) {
            return null;
        }
        return result.getLocations();
    }

    private static final void getCurrentLocation$lambda-0(RadarGoogleLocationClient this$0, Function1 $block, Location location) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$block, (String)"$block");
        RadarLogger.d$default(this$0.logger, "Received current location", null, null, 6, null);
        $block.invoke((Object)location);
    }

    private static final void getCurrentLocation$lambda-1(Function1 $block) {
        Intrinsics.checkNotNullParameter((Object)$block, (String)"$block");
        $block.invoke(null);
    }

    private static final void getLastLocation$lambda-3(Function1 $block, Location location) {
        Intrinsics.checkNotNullParameter((Object)$block, (String)"$block");
        $block.invoke((Object)location);
    }

    private static final void getLastLocation$lambda-4(Function1 $block, Exception it) {
        Intrinsics.checkNotNullParameter((Object)$block, (String)"$block");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $block.invoke(null);
    }

    private static final void addGeofences$lambda-8$lambda-6(Function1 $block, Void it) {
        Intrinsics.checkNotNullParameter((Object)$block, (String)"$block");
        $block.invoke((Object)true);
    }

    private static final void addGeofences$lambda-8$lambda-7(Function1 $block, Exception it) {
        Intrinsics.checkNotNullParameter((Object)$block, (String)"$block");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $block.invoke((Object)false);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RadarTrackingOptions.RadarTrackingOptionsDesiredAccuracy.values().length];
            nArray[RadarTrackingOptions.RadarTrackingOptionsDesiredAccuracy.HIGH.ordinal()] = 1;
            nArray[RadarTrackingOptions.RadarTrackingOptionsDesiredAccuracy.MEDIUM.ordinal()] = 2;
            nArray[RadarTrackingOptions.RadarTrackingOptionsDesiredAccuracy.LOW.ordinal()] = 3;
            nArray[RadarTrackingOptions.RadarTrackingOptionsDesiredAccuracy.NONE.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

