/*
 * Decompiled with CFR 0.152.
 */
package io.radar.sdk;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import android.view.InputDevice;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import io.radar.sdk.Radar;
import io.radar.sdk.RadarApiClient;
import io.radar.sdk.RadarSettings;
import io.radar.sdk.model.RadarConfig;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\fH\u0016J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/radar/sdk/RadarActivityLifecycleCallbacks;", "Landroid/app/Application$ActivityLifecycleCallbacks;", "fraud", "", "(Z)V", "count", "", "onActivityCreated", "", "activity", "Landroid/app/Activity;", "savedInstanceState", "Landroid/os/Bundle;", "onActivityDestroyed", "onActivityPaused", "onActivityResumed", "onActivitySaveInstanceState", "outState", "onActivityStarted", "onActivityStopped", "updatePermissionsDenied", "Companion", "sdk_release"})
public final class RadarActivityLifecycleCallbacks
implements Application.ActivityLifecycleCallbacks {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean fraud;
    private int count;
    private static boolean foreground;
    @NotNull
    private static final String TAG = "RadarActivityLifecycle";

    public RadarActivityLifecycleCallbacks(boolean fraud) {
        this.fraud = fraud;
    }

    public /* synthetic */ RadarActivityLifecycleCallbacks(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    private final void updatePermissionsDenied(Activity activity) {
        try {
            Context context;
            if (ContextCompat.checkSelfPermission((Context)activity.getApplicationContext(), (String)"android.permission.ACCESS_FINE_LOCATION") == -1 && ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, (String)"android.permission.ACCESS_FINE_LOCATION")) {
                context = activity.getApplicationContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"activity.applicationContext");
                RadarSettings.INSTANCE.setPermissionsDenied$sdk_release(context, true);
            }
            if (ContextCompat.checkSelfPermission((Context)activity.getApplicationContext(), (String)"android.permission.ACCESS_COARSE_LOCATION") == -1 && ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, (String)"android.permission.ACCESS_COARSE_LOCATION")) {
                context = activity.getApplicationContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"activity.applicationContext");
                RadarSettings.INSTANCE.setPermissionsDenied$sdk_release(context, true);
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
        }
    }

    public void onActivityResumed(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (this.count == 0) {
            try {
                Context context = activity.getApplicationContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"activity.applicationContext");
                boolean updated = RadarSettings.INSTANCE.updateSessionId$sdk_release(context);
                if (updated) {
                    String usage = "resume";
                    Radar.INSTANCE.getApiClient$sdk_release().getConfig$sdk_release(usage, false, new RadarApiClient.RadarGetConfigApiCallback(activity){
                        final /* synthetic */ Activity $activity;
                        {
                            this.$activity = $activity;
                        }

                        public void onComplete(@NotNull RadarConfig config) {
                            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
                            Radar.INSTANCE.getLocationManager$sdk_release().updateTrackingFromMeta$sdk_release(config.getMeta());
                            Context context = this.$activity.getApplicationContext();
                            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"activity.applicationContext");
                            RadarSettings.INSTANCE.setFeatureSettings(context, config.getFeatureSettings());
                        }
                    });
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
            }
        }
        RadarActivityLifecycleCallbacks e = this;
        int n = e.count;
        e.count = n + 1;
        foreground = this.count > 0;
        Radar.INSTANCE.logOpenedAppConversion$sdk_release();
        this.updatePermissionsDenied(activity);
        if (this.fraud) {
            Context context = activity.getApplicationContext();
            View touchView2 = new View(activity, context){
                final /* synthetic */ Activity $activity;
                {
                    this.$activity = $activity;
                    super($super_call_param$1);
                }

                public boolean dispatchTouchEvent(@NotNull MotionEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    try {
                        InputDevice inputDevice = InputDevice.getDevice((int)event.getDeviceId());
                        if (event.getToolType(0) == 0 || inputDevice.isVirtual()) {
                            Context context = this.$activity.getApplicationContext();
                            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"activity.applicationContext");
                            RadarSettings.INSTANCE.setSharing$sdk_release(context, true);
                        }
                    }
                    catch (Exception e) {
                        Log.e((String)"RadarActivityLifecycle", (String)e.getMessage(), (Throwable)e);
                    }
                    return super.dispatchTouchEvent(event);
                }

                public void _$_clearFindViewByIdCache() {
                }
            };
            activity.addContentView(touchView2, new ViewGroup.LayoutParams(-1, -1));
        }
    }

    public void onActivityPaused(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        int n = this.count - 1;
        int n2 = 0;
        boolean bl = false;
        this.count = Math.max(n, n2);
        foreground = this.count > 0;
        this.updatePermissionsDenied(activity);
    }

    public void onActivityStarted(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.updatePermissionsDenied(activity);
    }

    public void onActivityStopped(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.updatePermissionsDenied(activity);
    }

    public void onActivityDestroyed(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.updatePermissionsDenied(activity);
    }

    public void onActivitySaveInstanceState(@NotNull Activity activity, @NotNull Bundle outState) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
        this.updatePermissionsDenied(activity);
    }

    public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.updatePermissionsDenied(activity);
    }

    public RadarActivityLifecycleCallbacks() {
        this(false, 1, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lio/radar/sdk/RadarActivityLifecycleCallbacks$Companion;", "", "()V", "TAG", "", "<set-?>", "", "foreground", "getForeground", "()Z", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean getForeground() {
            return foreground;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

